/*
 * This combined file was created by the DataTables downloader builder:
 *   https://datatables.net/download
 *
 * To rebuild or modify this file with the latest versions of the included
 * software please visit:
 *   https://datatables.net/download/#dt/pdfmake-0.1.36/dt-1.10.20/af-2.3.4/b-1.6.1/b-html5-1.6.1/b-print-1.6.1/cr-1.5.2/fc-3.3.0/fh-3.1.6/kt-2.5.1/r-2.2.3/rg-1.1.1/sc-2.0.1/sl-1.3.1
 *
 * Included libraries:
 *   pdfmake 0.1.36, DataTables 1.10.20, AutoFill 2.3.4, Buttons 1.6.1, HTML5 export 1.6.1, Print view 1.6.1, ColReorder 1.5.2, FixedColumns 3.3.0, FixedHeader 3.1.6, KeyTable 2.5.1, Responsive 2.2.3, RowGroup 1.1.1, Scroller 2.0.1, Select 1.3.1
 */

/*! pdfmake v0.1.36, @license MIT, @link http://pdfmake.org */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 122);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function isString(variable) {
	return typeof variable === 'string' || variable instanceof String;
}

function isNumber(variable) {
	return typeof variable === 'number' || variable instanceof Number;
}

function isBoolean(variable) {
	return typeof variable === 'boolean';
}

function isArray(variable) {
	return Array.isArray(variable);
}

function isFunction(variable) {
	return typeof variable === 'function';
}

function isObject(variable) {
	return variable !== null && typeof variable === 'object';
}

function isNull(variable) {
	return variable === null;
}

function isUndefined(variable) {
	return variable === undefined;
}

function pack() {
	var result = {};

	for (var i = 0, l = arguments.length; i < l; i++) {
		var obj = arguments[i];

		if (obj) {
			for (var key in obj) {
				if (obj.hasOwnProperty(key)) {
					result[key] = obj[key];
				}
			}
		}
	}

	return result;
}

function offsetVector(vector, x, y) {
	switch (vector.type) {
		case 'ellipse':
		case 'rect':
			vector.x += x;
			vector.y += y;
			break;
		case 'line':
			vector.x1 += x;
			vector.x2 += x;
			vector.y1 += y;
			vector.y2 += y;
			break;
		case 'polyline':
			for (var i = 0, l = vector.points.length; i < l; i++) {
				vector.points[i].x += x;
				vector.points[i].y += y;
			}
			break;
	}
}

function fontStringify(key, val) {
	if (key === 'font') {
		return 'font';
	}
	return val;
}

module.exports = {
	isString: isString,
	isNumber: isNumber,
	isBoolean: isBoolean,
	isArray: isArray,
	isFunction: isFunction,
	isObject: isObject,
	isNull: isNull,
	isUndefined: isUndefined,
	pack: pack,
	fontStringify: fontStringify,
	offsetVector: offsetVector
};


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(124)
var ieee754 = __webpack_require__(125)
var isArray = __webpack_require__(76)

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7)))

/***/ }),
/* 2 */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.5.3' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(10);
var core = __webpack_require__(2);
var ctx = __webpack_require__(20);
var hide = __webpack_require__(13);
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && key in exports) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(65)('wks');
var uid = __webpack_require__(38);
var Symbol = __webpack_require__(10).Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(19)(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(14);
var IE8_DOM_DEFINE = __webpack_require__(95);
var toPrimitive = __webpack_require__(58);
var dP = Object.defineProperty;

exports.f = __webpack_require__(5) ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),
/* 7 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer, __dirname) {

function VirtualFileSystem() {
	this.fileSystem = {};
	this.baseSystem = {};
}

VirtualFileSystem.prototype.readFileSync = function (filename) {
	filename = fixFilename(filename);

	var base64content = this.baseSystem[filename];
	if (base64content) {
		return new Buffer(base64content, 'base64');
	}

	var content = this.fileSystem[filename];
	if (content) {
		return content;
	}

	throw 'File \'' + filename + '\' not found in virtual file system';
};

VirtualFileSystem.prototype.writeFileSync = function (filename, content) {
	this.fileSystem[fixFilename(filename)] = content;
};

VirtualFileSystem.prototype.bindFS = function (data) {
	this.baseSystem = data || {};
};


function fixFilename(filename) {
	if (filename.indexOf(__dirname) === 0) {
		filename = filename.substring(__dirname.length);
	}

	if (filename.indexOf('/') === 0) {
		filename = filename.substring(1);
	}

	return filename;
}

module.exports = new VirtualFileSystem();

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer, "/"))

/***/ }),
/* 9 */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),
/* 10 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),
/* 11 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
(function() {
  var NumberT, PropertyDescriptor;

  NumberT = __webpack_require__(22).Number;

  exports.resolveLength = function(length, stream, parent) {
    var res;
    if (typeof length === 'number') {
      res = length;
    } else if (typeof length === 'function') {
      res = length.call(parent, parent);
    } else if (parent && typeof length === 'string') {
      res = parent[length];
    } else if (stream && length instanceof NumberT) {
      res = length.decode(stream);
    }
    if (isNaN(res)) {
      throw new Error('Not a fixed size');
    }
    return res;
  };

  PropertyDescriptor = (function() {
    function PropertyDescriptor(opts) {
      var key, val;
      if (opts == null) {
        opts = {};
      }
      this.enumerable = true;
      this.configurable = true;
      for (key in opts) {
        val = opts[key];
        this[key] = val;
      }
    }

    return PropertyDescriptor;

  })();

  exports.PropertyDescriptor = PropertyDescriptor;

}).call(this);


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(6);
var createDesc = __webpack_require__(27);
module.exports = __webpack_require__(5) ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9);
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Stream;

var EE = __webpack_require__(31).EventEmitter;
var inherits = __webpack_require__(21);

inherits(Stream, EE);
Stream.Readable = __webpack_require__(45);
Stream.Writable = __webpack_require__(146);
Stream.Duplex = __webpack_require__(147);
Stream.Transform = __webpack_require__(148);
Stream.PassThrough = __webpack_require__(149);

// Backwards-compat with node 0.4.x
Stream.Stream = Stream;



// old-style streams.  Note that the pipe method (the only relevant
// part of this class) is overridden in the Readable class.

function Stream() {
  EE.call(this);
}

Stream.prototype.pipe = function(dest, options) {
  var source = this;

  function ondata(chunk) {
    if (dest.writable) {
      if (false === dest.write(chunk) && source.pause) {
        source.pause();
      }
    }
  }

  source.on('data', ondata);

  function ondrain() {
    if (source.readable && source.resume) {
      source.resume();
    }
  }

  dest.on('drain', ondrain);

  // If the 'end' option is not supplied, dest.end() will be called when
  // source gets the 'end' or 'close' events.  Only dest.end() once.
  if (!dest._isStdio && (!options || options.end !== false)) {
    source.on('end', onend);
    source.on('close', onclose);
  }

  var didOnEnd = false;
  function onend() {
    if (didOnEnd) return;
    didOnEnd = true;

    dest.end();
  }


  function onclose() {
    if (didOnEnd) return;
    didOnEnd = true;

    if (typeof dest.destroy === 'function') dest.destroy();
  }

  // don't leave dangling pipes when there are errors.
  function onerror(er) {
    cleanup();
    if (EE.listenerCount(this, 'error') === 0) {
      throw er; // Unhandled stream error in pipe.
    }
  }

  source.on('error', onerror);
  dest.on('error', onerror);

  // remove all the event listeners that were added.
  function cleanup() {
    source.removeListener('data', ondata);
    dest.removeListener('drain', ondrain);

    source.removeListener('end', onend);
    source.removeListener('close', onclose);

    source.removeListener('error', onerror);
    dest.removeListener('error', onerror);

    source.removeListener('end', cleanup);
    source.removeListener('close', cleanup);

    dest.removeListener('close', cleanup);
  }

  source.on('end', cleanup);
  source.on('close', cleanup);

  dest.on('close', cleanup);

  dest.emit('pipe', source);

  // Allow for unix-like usage: A.pipe(B).pipe(C)
  return dest;
};


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/

var processNextTick = __webpack_require__(32).nextTick;
/*</replacement>*/

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    keys.push(key);
  }return keys;
};
/*</replacement>*/

module.exports = Duplex;

/*<replacement>*/
var util = __webpack_require__(25);
util.inherits = __webpack_require__(21);
/*</replacement>*/

var Readable = __webpack_require__(83);
var Writable = __webpack_require__(46);

util.inherits(Duplex, Readable);

var keys = objectKeys(Writable.prototype);
for (var v = 0; v < keys.length; v++) {
  var method = keys[v];
  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
}

function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false) this.readable = false;

  if (options && options.writable === false) this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

  this.once('end', onend);
}

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  processNextTick(onEndNT, this);
}

function onEndNT(self) {
  self.end();
}

Object.defineProperty(Duplex.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

Duplex.prototype._destroy = function (err, cb) {
  this.push(null);
  this.end();

  processNextTick(cb, err);
};

function forEach(xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(54);
var defined = __webpack_require__(56);
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),
/* 18 */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),
/* 19 */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(97);
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),
/* 21 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
(function() {
  var DecodeStream, Fixed, NumberT,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  DecodeStream = __webpack_require__(51);

  NumberT = (function() {
    function NumberT(type, endian) {
      this.type = type;
      this.endian = endian != null ? endian : 'BE';
      this.fn = this.type;
      if (this.type[this.type.length - 1] !== '8') {
        this.fn += this.endian;
      }
    }

    NumberT.prototype.size = function() {
      return DecodeStream.TYPES[this.type];
    };

    NumberT.prototype.decode = function(stream) {
      return stream['read' + this.fn]();
    };

    NumberT.prototype.encode = function(stream, val) {
      return stream['write' + this.fn](val);
    };

    return NumberT;

  })();

  exports.Number = NumberT;

  exports.uint8 = new NumberT('UInt8');

  exports.uint16be = exports.uint16 = new NumberT('UInt16', 'BE');

  exports.uint16le = new NumberT('UInt16', 'LE');

  exports.uint24be = exports.uint24 = new NumberT('UInt24', 'BE');

  exports.uint24le = new NumberT('UInt24', 'LE');

  exports.uint32be = exports.uint32 = new NumberT('UInt32', 'BE');

  exports.uint32le = new NumberT('UInt32', 'LE');

  exports.int8 = new NumberT('Int8');

  exports.int16be = exports.int16 = new NumberT('Int16', 'BE');

  exports.int16le = new NumberT('Int16', 'LE');

  exports.int24be = exports.int24 = new NumberT('Int24', 'BE');

  exports.int24le = new NumberT('Int24', 'LE');

  exports.int32be = exports.int32 = new NumberT('Int32', 'BE');

  exports.int32le = new NumberT('Int32', 'LE');

  exports.floatbe = exports.float = new NumberT('Float', 'BE');

  exports.floatle = new NumberT('Float', 'LE');

  exports.doublebe = exports.double = new NumberT('Double', 'BE');

  exports.doublele = new NumberT('Double', 'LE');

  Fixed = (function(_super) {
    __extends(Fixed, _super);

    function Fixed(size, endian, fracBits) {
      if (fracBits == null) {
        fracBits = size >> 1;
      }
      Fixed.__super__.constructor.call(this, "Int" + size, endian);
      this._point = 1 << fracBits;
    }

    Fixed.prototype.decode = function(stream) {
      return Fixed.__super__.decode.call(this, stream) / this._point;
    };

    Fixed.prototype.encode = function(stream, val) {
      return Fixed.__super__.encode.call(this, stream, val * this._point | 0);
    };

    return Fixed;

  })(NumberT);

  exports.Fixed = Fixed;

  exports.fixed16be = exports.fixed16 = new Fixed(16, 'BE');

  exports.fixed16le = new Fixed(16, 'LE');

  exports.fixed32be = exports.fixed32 = new Fixed(32, 'BE');

  exports.fixed32le = new Fixed(32, 'LE');

}).call(this);


/***/ }),
/* 23 */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $at = __webpack_require__(207)(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(61)(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

/*
PDFObject - converts JavaScript types into their corrisponding PDF types.
By Devon Govett
 */

(function() {
  var PDFObject, PDFReference;

  PDFObject = (function() {
    var escapable, escapableRe, pad, swapBytes;

    function PDFObject() {}

    pad = function(str, length) {
      return (Array(length + 1).join('0') + str).slice(-length);
    };

    escapableRe = /[\n\r\t\b\f\(\)\\]/g;

    escapable = {
      '\n': '\\n',
      '\r': '\\r',
      '\t': '\\t',
      '\b': '\\b',
      '\f': '\\f',
      '\\': '\\\\',
      '(': '\\(',
      ')': '\\)'
    };

    swapBytes = function(buff) {
      var a, i, j, l, ref;
      l = buff.length;
      if (l & 0x01) {
        throw new Error("Buffer length must be even");
      } else {
        for (i = j = 0, ref = l - 1; j < ref; i = j += 2) {
          a = buff[i];
          buff[i] = buff[i + 1];
          buff[i + 1] = a;
        }
      }
      return buff;
    };

    PDFObject.convert = function(object) {
      var e, i, isUnicode, items, j, key, out, ref, string, val;
      if (typeof object === 'string') {
        return '/' + object;
      } else if (object instanceof String) {
        string = object;
        isUnicode = false;
        for (i = j = 0, ref = string.length; j < ref; i = j += 1) {
          if (string.charCodeAt(i) > 0x7f) {
            isUnicode = true;
            break;
          }
        }
        if (isUnicode) {
          string = swapBytes(new Buffer('\ufeff' + string, 'utf16le')).toString('binary');
        }
        string = string.replace(escapableRe, function(c) {
          return escapable[c];
        });
        return '(' + string + ')';
      } else if (Buffer.isBuffer(object)) {
        return '<' + object.toString('hex') + '>';
      } else if (object instanceof PDFReference) {
        return object.toString();
      } else if (object instanceof Date) {
        return '(D:' + pad(object.getUTCFullYear(), 4) + pad(object.getUTCMonth() + 1, 2) + pad(object.getUTCDate(), 2) + pad(object.getUTCHours(), 2) + pad(object.getUTCMinutes(), 2) + pad(object.getUTCSeconds(), 2) + 'Z)';
      } else if (Array.isArray(object)) {
        items = ((function() {
          var k, len, results;
          results = [];
          for (k = 0, len = object.length; k < len; k++) {
            e = object[k];
            results.push(PDFObject.convert(e));
          }
          return results;
        })()).join(' ');
        return '[' + items + ']';
      } else if ({}.toString.call(object) === '[object Object]') {
        out = ['<<'];
        for (key in object) {
          val = object[key];
          out.push('/' + key + ' ' + PDFObject.convert(val));
        }
        out.push('>>');
        return out.join('\n');
      } else if (typeof object === 'number') {
        return PDFObject.number(object);
      } else {
        return '' + object;
      }
    };

    PDFObject.number = function(n) {
      if (n > -1e21 && n < 1e21) {
        return Math.round(n * 1e6) / 1e6;
      }
      throw new Error("unsupported number: " + n);
    };

    return PDFObject;

  })();

  module.exports = PDFObject;

  PDFReference = __webpack_require__(87);

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 27 */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(201);
var global = __webpack_require__(10);
var hide = __webpack_require__(13);
var Iterators = __webpack_require__(23);
var TO_STRING_TAG = __webpack_require__(4)('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(101);
var enumBugKeys = __webpack_require__(66);

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(56);
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),
/* 31 */
/***/ (function(module, exports) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        // At least give some kind of context to the user
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
        err.context = er;
        throw err;
      }
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];

    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};

EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

if (!process.version ||
    process.version.indexOf('v0.') === 0 ||
    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
  module.exports = { nextTick: nextTick };
} else {
  module.exports = process
}

function nextTick(fn, arg1, arg2, arg3) {
  if (typeof fn !== 'function') {
    throw new TypeError('"callback" argument must be a function');
  }
  var len = arguments.length;
  var args, i;
  switch (len) {
  case 0:
  case 1:
    return process.nextTick(fn);
  case 2:
    return process.nextTick(function afterTickOne() {
      fn.call(null, arg1);
    });
  case 3:
    return process.nextTick(function afterTickTwo() {
      fn.call(null, arg1, arg2);
    });
  case 4:
    return process.nextTick(function afterTickThree() {
      fn.call(null, arg1, arg2, arg3);
    });
  default:
    args = new Array(len - 1);
    i = 0;
    while (i < args.length) {
      args[i++] = arguments[i];
    }
    return process.nextTick(function afterTick() {
      fn.apply(null, args);
    });
  }
}


/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(1)
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";



var TYPED_OK =  (typeof Uint8Array !== 'undefined') &&
                (typeof Uint16Array !== 'undefined') &&
                (typeof Int32Array !== 'undefined');

function _has(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}

exports.assign = function (obj /*from1, from2, from3, ...*/) {
  var sources = Array.prototype.slice.call(arguments, 1);
  while (sources.length) {
    var source = sources.shift();
    if (!source) { continue; }

    if (typeof source !== 'object') {
      throw new TypeError(source + 'must be non-object');
    }

    for (var p in source) {
      if (_has(source, p)) {
        obj[p] = source[p];
      }
    }
  }

  return obj;
};


// reduce buffer size, avoiding mem copy
exports.shrinkBuf = function (buf, size) {
  if (buf.length === size) { return buf; }
  if (buf.subarray) { return buf.subarray(0, size); }
  buf.length = size;
  return buf;
};


var fnTyped = {
  arraySet: function (dest, src, src_offs, len, dest_offs) {
    if (src.subarray && dest.subarray) {
      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
      return;
    }
    // Fallback to ordinary array
    for (var i = 0; i < len; i++) {
      dest[dest_offs + i] = src[src_offs + i];
    }
  },
  // Join array of chunks to single array.
  flattenChunks: function (chunks) {
    var i, l, len, pos, chunk, result;

    // calculate data length
    len = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      len += chunks[i].length;
    }

    // join chunks
    result = new Uint8Array(len);
    pos = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      chunk = chunks[i];
      result.set(chunk, pos);
      pos += chunk.length;
    }

    return result;
  }
};

var fnUntyped = {
  arraySet: function (dest, src, src_offs, len, dest_offs) {
    for (var i = 0; i < len; i++) {
      dest[dest_offs + i] = src[src_offs + i];
    }
  },
  // Join array of chunks to single array.
  flattenChunks: function (chunks) {
    return [].concat.apply([], chunks);
  }
};


// Enable/Disable typed arrays use, for testing
//
exports.setTyped = function (on) {
  if (on) {
    exports.Buf8  = Uint8Array;
    exports.Buf16 = Uint16Array;
    exports.Buf32 = Int32Array;
    exports.assign(exports, fnTyped);
  } else {
    exports.Buf8  = Array;
    exports.Buf16 = Array;
    exports.Buf32 = Array;
    exports.assign(exports, fnUntyped);
  }
};

exports.setTyped(TYPED_OK);


/***/ }),
/* 35 */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(14);
var dPs = __webpack_require__(100);
var enumBugKeys = __webpack_require__(66);
var IE_PROTO = __webpack_require__(64)('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(96)('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(205).appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
var toInteger = __webpack_require__(63);
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),
/* 38 */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(6).f;
var has = __webpack_require__(18);
var TAG = __webpack_require__(4)('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(38)('meta');
var isObject = __webpack_require__(9);
var has = __webpack_require__(18);
var setDesc = __webpack_require__(6).f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(19)(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

var ctx = __webpack_require__(20);
var call = __webpack_require__(111);
var isArrayIter = __webpack_require__(112);
var anObject = __webpack_require__(14);
var toLength = __webpack_require__(37);
var getIterFn = __webpack_require__(67);
var BREAK = {};
var RETURN = {};
var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
  var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);
  var f = ctx(fn, that, entries ? 2 : 1);
  var index = 0;
  var length, step, iterator, result;
  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
  // fast case for arrays with default iterator
  if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {
    result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
    if (result === BREAK || result === RETURN) return result;
  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
    result = call(iterator, f, step.value, entries);
    if (result === BREAK || result === RETURN) return result;
  }
};
exports.BREAK = BREAK;
exports.RETURN = RETURN;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isString = __webpack_require__(0).isString;
var isNumber = __webpack_require__(0).isNumber;
var isObject = __webpack_require__(0).isObject;
var isArray = __webpack_require__(0).isArray;
var LineBreaker = __webpack_require__(78);

var LEADING = /^(\s)+/g;
var TRAILING = /(\s)+$/g;

/**
 * Creates an instance of TextTools - text measurement utility
 *
 * @constructor
 * @param {FontProvider} fontProvider
 */
function TextTools(fontProvider) {
	this.fontProvider = fontProvider;
}

/**
 * Converts an array of strings (or inline-definition-objects) into a collection
 * of inlines and calculated minWidth/maxWidth.
 * and their min/max widths
 * @param  {Object} textArray - an array of inline-definition-objects (or strings)
 * @param  {Object} styleContextStack current style stack
 * @return {Object}                   collection of inlines, minWidth, maxWidth
 */
TextTools.prototype.buildInlines = function (textArray, styleContextStack) {
	var measured = measure(this.fontProvider, textArray, styleContextStack);

	var minWidth = 0,
		maxWidth = 0,
		currentLineWidth;

	measured.forEach(function (inline) {
		minWidth = Math.max(minWidth, inline.width - inline.leadingCut - inline.trailingCut);

		if (!currentLineWidth) {
			currentLineWidth = {width: 0, leadingCut: inline.leadingCut, trailingCut: 0};
		}

		currentLineWidth.width += inline.width;
		currentLineWidth.trailingCut = inline.trailingCut;

		maxWidth = Math.max(maxWidth, getTrimmedWidth(currentLineWidth));

		if (inline.lineEnd) {
			currentLineWidth = null;
		}
	});

	if (getStyleProperty({}, styleContextStack, 'noWrap', false)) {
		minWidth = maxWidth;
	}

	return {
		items: measured,
		minWidth: minWidth,
		maxWidth: maxWidth
	};

	function getTrimmedWidth(item) {
		return Math.max(0, item.width - item.leadingCut - item.trailingCut);
	}
};

/**
 * Returns size of the specified string (without breaking it) using the current style
 * @param  {String} text              text to be measured
 * @param  {Object} styleContextStack current style stack
 * @return {Object}                   size of the specified string
 */
TextTools.prototype.sizeOfString = function (text, styleContextStack) {
	text = text ? text.toString().replace(/\t/g, '    ') : '';

	//TODO: refactor - extract from measure
	var fontName = getStyleProperty({}, styleContextStack, 'font', 'Roboto');
	var fontSize = getStyleProperty({}, styleContextStack, 'fontSize', 12);
	var fontFeatures = getStyleProperty({}, styleContextStack, 'fontFeatures', null);
	var bold = getStyleProperty({}, styleContextStack, 'bold', false);
	var italics = getStyleProperty({}, styleContextStack, 'italics', false);
	var lineHeight = getStyleProperty({}, styleContextStack, 'lineHeight', 1);
	var characterSpacing = getStyleProperty({}, styleContextStack, 'characterSpacing', 0);

	var font = this.fontProvider.provideFont(fontName, bold, italics);

	return {
		width: widthOfString(text, font, fontSize, characterSpacing, fontFeatures),
		height: font.lineHeight(fontSize) * lineHeight,
		fontSize: fontSize,
		lineHeight: lineHeight,
		ascender: font.ascender / 1000 * fontSize,
		descender: font.descender / 1000 * fontSize
	};
};

TextTools.prototype.widthOfString = function (text, font, fontSize, characterSpacing, fontFeatures) {
	return widthOfString(text, font, fontSize, characterSpacing, fontFeatures);
};

function splitWords(text, noWrap) {
	var results = [];
	text = text.replace(/\t/g, '    ');

	if (noWrap) {
		results.push({text: text});
		return results;
	}

	var breaker = new LineBreaker(text);
	var last = 0;
	var bk;

	while (bk = breaker.nextBreak()) {
		var word = text.slice(last, bk.position);

		if (bk.required || word.match(/\r?\n$|\r$/)) { // new line
			word = word.replace(/\r?\n$|\r$/, '');
			results.push({text: word, lineEnd: true});
		} else {
			results.push({text: word});
		}

		last = bk.position;
	}

	return results;
}

function copyStyle(source, destination) {
	destination = destination || {};
	source = source || {}; //TODO: default style

	for (var key in source) {
		if (key != 'text' && source.hasOwnProperty(key)) {
			destination[key] = source[key];
		}
	}

	return destination;
}

function normalizeTextArray(array, styleContextStack) {
	function flatten(array) {
		return array.reduce(function (prev, cur) {
			var current = isArray(cur.text) ? flatten(cur.text) : cur;
			var more = [].concat(current).some(Array.isArray);
			return prev.concat(more ? flatten(current) : current);
		}, []);
	}

	var results = [];

	if (!isArray(array)) {
		array = [array];
	}

	array = flatten(array);

	for (var i = 0, l = array.length; i < l; i++) {
		var item = array[i];
		var style = null;
		var words;

		var noWrap = getStyleProperty(item || {}, styleContextStack, 'noWrap', false);
		if (isObject(item)) {
			words = splitWords(normalizeString(item.text), noWrap);
			style = copyStyle(item);
		} else {
			words = splitWords(normalizeString(item), noWrap);
		}

		for (var i2 = 0, l2 = words.length; i2 < l2; i2++) {
			var result = {
				text: words[i2].text
			};

			if (words[i2].lineEnd) {
				result.lineEnd = true;
			}

			copyStyle(style, result);

			results.push(result);
		}
	}

	return results;
}

function normalizeString(value) {
	if (value === undefined || value === null) {
		return '';
	} else if (isNumber(value)) {
		return value.toString();
	} else if (isString(value)) {
		return value;
	} else {
		return value.toString();
	}
}

function getStyleProperty(item, styleContextStack, property, defaultValue) {
	var value;

	if (item[property] !== undefined && item[property] !== null) {
		// item defines this property
		return item[property];
	}

	if (!styleContextStack) {
		return defaultValue;
	}

	styleContextStack.auto(item, function () {
		value = styleContextStack.getProperty(property);
	});

	if (value !== null && value !== undefined) {
		return value;
	} else {
		return defaultValue;
	}
}

function measure(fontProvider, textArray, styleContextStack) {
	var normalized = normalizeTextArray(textArray, styleContextStack);

	if (normalized.length) {
		var leadingIndent = getStyleProperty(normalized[0], styleContextStack, 'leadingIndent', 0);

		if (leadingIndent) {
			normalized[0].leadingCut = -leadingIndent;
			normalized[0].leadingIndent = leadingIndent;
		}
	}

	normalized.forEach(function (item) {
		var fontName = getStyleProperty(item, styleContextStack, 'font', 'Roboto');
		var fontSize = getStyleProperty(item, styleContextStack, 'fontSize', 12);
		var fontFeatures = getStyleProperty(item, styleContextStack, 'fontFeatures', null);
		var bold = getStyleProperty(item, styleContextStack, 'bold', false);
		var italics = getStyleProperty(item, styleContextStack, 'italics', false);
		var color = getStyleProperty(item, styleContextStack, 'color', 'black');
		var decoration = getStyleProperty(item, styleContextStack, 'decoration', null);
		var decorationColor = getStyleProperty(item, styleContextStack, 'decorationColor', null);
		var decorationStyle = getStyleProperty(item, styleContextStack, 'decorationStyle', null);
		var background = getStyleProperty(item, styleContextStack, 'background', null);
		var lineHeight = getStyleProperty(item, styleContextStack, 'lineHeight', 1);
		var characterSpacing = getStyleProperty(item, styleContextStack, 'characterSpacing', 0);
		var link = getStyleProperty(item, styleContextStack, 'link', null);
		var linkToPage = getStyleProperty(item, styleContextStack, 'linkToPage', null);
		var noWrap = getStyleProperty(item, styleContextStack, 'noWrap', null);
		var preserveLeadingSpaces = getStyleProperty(item, styleContextStack, 'preserveLeadingSpaces', false);

		var font = fontProvider.provideFont(fontName, bold, italics);

		item.width = widthOfString(item.text, font, fontSize, characterSpacing, fontFeatures);
		item.height = font.lineHeight(fontSize) * lineHeight;

		var leadingSpaces = item.text.match(LEADING);

		if (!item.leadingCut) {
			item.leadingCut = 0;
		}

		if (leadingSpaces && !preserveLeadingSpaces) {
			item.leadingCut += widthOfString(leadingSpaces[0], font, fontSize, characterSpacing, fontFeatures);
		}

		var trailingSpaces = item.text.match(TRAILING);
		if (trailingSpaces) {
			item.trailingCut = widthOfString(trailingSpaces[0], font, fontSize, characterSpacing, fontFeatures);
		} else {
			item.trailingCut = 0;
		}

		item.alignment = getStyleProperty(item, styleContextStack, 'alignment', 'left');
		item.font = font;
		item.fontSize = fontSize;
		item.fontFeatures = fontFeatures;
		item.characterSpacing = characterSpacing;
		item.color = color;
		item.decoration = decoration;
		item.decorationColor = decorationColor;
		item.decorationStyle = decorationStyle;
		item.background = background;
		item.link = link;
		item.linkToPage = linkToPage;
		item.noWrap = noWrap;
	});

	return normalized;
}

function widthOfString(text, font, fontSize, characterSpacing, fontFeatures) {
	return font.widthOfString(text, fontSize, fontFeatures) + ((characterSpacing || 0) * (text.length - 1));
}

module.exports = TextTools;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
var UnicodeTrie, inflate;

inflate = __webpack_require__(79);

UnicodeTrie = (function() {
  var DATA_BLOCK_LENGTH, DATA_GRANULARITY, DATA_MASK, INDEX_1_OFFSET, INDEX_2_BLOCK_LENGTH, INDEX_2_BMP_LENGTH, INDEX_2_MASK, INDEX_SHIFT, LSCP_INDEX_2_LENGTH, LSCP_INDEX_2_OFFSET, OMITTED_BMP_INDEX_1_LENGTH, SHIFT_1, SHIFT_1_2, SHIFT_2, UTF8_2B_INDEX_2_LENGTH, UTF8_2B_INDEX_2_OFFSET;

  SHIFT_1 = 6 + 5;

  SHIFT_2 = 5;

  SHIFT_1_2 = SHIFT_1 - SHIFT_2;

  OMITTED_BMP_INDEX_1_LENGTH = 0x10000 >> SHIFT_1;

  INDEX_2_BLOCK_LENGTH = 1 << SHIFT_1_2;

  INDEX_2_MASK = INDEX_2_BLOCK_LENGTH - 1;

  INDEX_SHIFT = 2;

  DATA_BLOCK_LENGTH = 1 << SHIFT_2;

  DATA_MASK = DATA_BLOCK_LENGTH - 1;

  LSCP_INDEX_2_OFFSET = 0x10000 >> SHIFT_2;

  LSCP_INDEX_2_LENGTH = 0x400 >> SHIFT_2;

  INDEX_2_BMP_LENGTH = LSCP_INDEX_2_OFFSET + LSCP_INDEX_2_LENGTH;

  UTF8_2B_INDEX_2_OFFSET = INDEX_2_BMP_LENGTH;

  UTF8_2B_INDEX_2_LENGTH = 0x800 >> 6;

  INDEX_1_OFFSET = UTF8_2B_INDEX_2_OFFSET + UTF8_2B_INDEX_2_LENGTH;

  DATA_GRANULARITY = 1 << INDEX_SHIFT;

  function UnicodeTrie(data) {
    var isBuffer, uncompressedLength, view;
    isBuffer = typeof data.readUInt32BE === 'function' && typeof data.slice === 'function';
    if (isBuffer || data instanceof Uint8Array) {
      if (isBuffer) {
        this.highStart = data.readUInt32BE(0);
        this.errorValue = data.readUInt32BE(4);
        uncompressedLength = data.readUInt32BE(8);
        data = data.slice(12);
      } else {
        view = new DataView(data.buffer);
        this.highStart = view.getUint32(0);
        this.errorValue = view.getUint32(4);
        uncompressedLength = view.getUint32(8);
        data = data.subarray(12);
      }
      data = inflate(data, new Uint8Array(uncompressedLength));
      data = inflate(data, new Uint8Array(uncompressedLength));
      this.data = new Uint32Array(data.buffer);
    } else {
      this.data = data.data, this.highStart = data.highStart, this.errorValue = data.errorValue;
    }
  }

  UnicodeTrie.prototype.get = function(codePoint) {
    var index;
    if (codePoint < 0 || codePoint > 0x10ffff) {
      return this.errorValue;
    }
    if (codePoint < 0xd800 || (codePoint > 0xdbff && codePoint <= 0xffff)) {
      index = (this.data[codePoint >> SHIFT_2] << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }
    if (codePoint <= 0xffff) {
      index = (this.data[LSCP_INDEX_2_OFFSET + ((codePoint - 0xd800) >> SHIFT_2)] << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }
    if (codePoint < this.highStart) {
      index = this.data[(INDEX_1_OFFSET - OMITTED_BMP_INDEX_1_LENGTH) + (codePoint >> SHIFT_1)];
      index = this.data[index + ((codePoint >> SHIFT_2) & INDEX_2_MASK)];
      index = (index << INDEX_SHIFT) + (codePoint & DATA_MASK);
      return this.data[index];
    }
    return this.data[this.data.length - DATA_GRANULARITY];
  };

  return UnicodeTrie;

})();

module.exports = UnicodeTrie;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isString = __webpack_require__(0).isString;

function buildColumnWidths(columns, availableWidth) {
	var autoColumns = [],
		autoMin = 0, autoMax = 0,
		starColumns = [],
		starMaxMin = 0,
		starMaxMax = 0,
		fixedColumns = [],
		initial_availableWidth = availableWidth;

	columns.forEach(function (column) {
		if (isAutoColumn(column)) {
			autoColumns.push(column);
			autoMin += column._minWidth;
			autoMax += column._maxWidth;
		} else if (isStarColumn(column)) {
			starColumns.push(column);
			starMaxMin = Math.max(starMaxMin, column._minWidth);
			starMaxMax = Math.max(starMaxMax, column._maxWidth);
		} else {
			fixedColumns.push(column);
		}
	});

	fixedColumns.forEach(function (col) {
		// width specified as %
		if (isString(col.width) && /\d+%/.test(col.width)) {
			col.width = parseFloat(col.width) * initial_availableWidth / 100;
		}
		if (col.width < (col._minWidth) && col.elasticWidth) {
			col._calcWidth = col._minWidth;
		} else {
			col._calcWidth = col.width;
		}

		availableWidth -= col._calcWidth;
	});

	// http://www.freesoft.org/CIE/RFC/1942/18.htm
	// http://www.w3.org/TR/CSS2/tables.html#width-layout
	// http://dev.w3.org/csswg/css3-tables-algorithms/Overview.src.htm
	var minW = autoMin + starMaxMin * starColumns.length;
	var maxW = autoMax + starMaxMax * starColumns.length;
	if (minW >= availableWidth) {
		// case 1 - there's no way to fit all columns within available width
		// that's actually pretty bad situation with PDF as we have no horizontal scroll
		// no easy workaround (unless we decide, in the future, to split single words)
		// currently we simply use minWidths for all columns
		autoColumns.forEach(function (col) {
			col._calcWidth = col._minWidth;
		});

		starColumns.forEach(function (col) {
			col._calcWidth = starMaxMin; // starMaxMin already contains padding
		});
	} else {
		if (maxW < availableWidth) {
			// case 2 - we can fit rest of the table within available space
			autoColumns.forEach(function (col) {
				col._calcWidth = col._maxWidth;
				availableWidth -= col._calcWidth;
			});
		} else {
			// maxW is too large, but minW fits within available width
			var W = availableWidth - minW;
			var D = maxW - minW;

			autoColumns.forEach(function (col) {
				var d = col._maxWidth - col._minWidth;
				col._calcWidth = col._minWidth + d * W / D;
				availableWidth -= col._calcWidth;
			});
		}

		if (starColumns.length > 0) {
			var starSize = availableWidth / starColumns.length;

			starColumns.forEach(function (col) {
				col._calcWidth = starSize;
			});
		}
	}
}

function isAutoColumn(column) {
	return column.width === 'auto';
}

function isStarColumn(column) {
	return column.width === null || column.width === undefined || column.width === '*' || column.width === 'star';
}

//TODO: refactor and reuse in measureTable
function measureMinMax(columns) {
	var result = {min: 0, max: 0};

	var maxStar = {min: 0, max: 0};
	var starCount = 0;

	for (var i = 0, l = columns.length; i < l; i++) {
		var c = columns[i];

		if (isStarColumn(c)) {
			maxStar.min = Math.max(maxStar.min, c._minWidth);
			maxStar.max = Math.max(maxStar.max, c._maxWidth);
			starCount++;
		} else if (isAutoColumn(c)) {
			result.min += c._minWidth;
			result.max += c._maxWidth;
		} else {
			result.min += ((c.width !== undefined && c.width) || c._minWidth);
			result.max += ((c.width !== undefined && c.width) || c._maxWidth);
		}
	}

	if (starCount) {
		result.min += starCount * maxStar.min;
		result.max += starCount * maxStar.max;
	}

	return result;
}

/**
 * Calculates column widths
 * @private
 */
module.exports = {
	buildColumnWidths: buildColumnWidths,
	measureMinMax: measureMinMax,
	isAutoColumn: isAutoColumn,
	isStarColumn: isStarColumn
};


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(83);
exports.Stream = exports;
exports.Readable = exports;
exports.Writable = __webpack_require__(46);
exports.Duplex = __webpack_require__(16);
exports.Transform = __webpack_require__(86);
exports.PassThrough = __webpack_require__(145);


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var processNextTick = __webpack_require__(32).nextTick;
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = __webpack_require__(25);
util.inherits = __webpack_require__(21);
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(144)
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(84);
/*</replacement>*/

/*<replacement>*/

var Buffer = __webpack_require__(33).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

var destroyImpl = __webpack_require__(85);

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__(16);

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var writableHwm = options.writableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;
      if (this !== Writable) return false;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__(16);

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  processNextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    processNextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = !state.objectMode && _isUint8Array(chunk);

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    processNextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    processNextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
    state.bufferedRequestCount = 0;
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      state.bufferedRequestCount--;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      processNextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) processNextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }
  if (state.corkedRequestsFree) {
    state.corkedRequestsFree.next = corkReq;
  } else {
    state.corkedRequestsFree = corkReq;
  }
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11), __webpack_require__(142).setImmediate, __webpack_require__(7)))

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Buffer = __webpack_require__(33).Buffer;

var isEncoding = Buffer.isEncoding || function (encoding) {
  encoding = '' + encoding;
  switch (encoding && encoding.toLowerCase()) {
    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
      return true;
    default:
      return false;
  }
};

function _normalizeEncoding(enc) {
  if (!enc) return 'utf8';
  var retried;
  while (true) {
    switch (enc) {
      case 'utf8':
      case 'utf-8':
        return 'utf8';
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return 'utf16le';
      case 'latin1':
      case 'binary':
        return 'latin1';
      case 'base64':
      case 'ascii':
      case 'hex':
        return enc;
      default:
        if (retried) return; // undefined
        enc = ('' + enc).toLowerCase();
        retried = true;
    }
  }
};

// Do not cache `Buffer.isEncoding` when checking encoding names as some
// modules monkey-patch it to support additional encodings
function normalizeEncoding(enc) {
  var nenc = _normalizeEncoding(enc);
  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
  return nenc || enc;
}

// StringDecoder provides an interface for efficiently splitting a series of
// buffers into a series of JS strings without breaking apart multi-byte
// characters.
exports.StringDecoder = StringDecoder;
function StringDecoder(encoding) {
  this.encoding = normalizeEncoding(encoding);
  var nb;
  switch (this.encoding) {
    case 'utf16le':
      this.text = utf16Text;
      this.end = utf16End;
      nb = 4;
      break;
    case 'utf8':
      this.fillLast = utf8FillLast;
      nb = 4;
      break;
    case 'base64':
      this.text = base64Text;
      this.end = base64End;
      nb = 3;
      break;
    default:
      this.write = simpleWrite;
      this.end = simpleEnd;
      return;
  }
  this.lastNeed = 0;
  this.lastTotal = 0;
  this.lastChar = Buffer.allocUnsafe(nb);
}

StringDecoder.prototype.write = function (buf) {
  if (buf.length === 0) return '';
  var r;
  var i;
  if (this.lastNeed) {
    r = this.fillLast(buf);
    if (r === undefined) return '';
    i = this.lastNeed;
    this.lastNeed = 0;
  } else {
    i = 0;
  }
  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
  return r || '';
};

StringDecoder.prototype.end = utf8End;

// Returns only complete characters in a Buffer
StringDecoder.prototype.text = utf8Text;

// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
StringDecoder.prototype.fillLast = function (buf) {
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
  this.lastNeed -= buf.length;
};

// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
// continuation byte.
function utf8CheckByte(byte) {
  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
  return -1;
}

// Checks at most 3 bytes at the end of a Buffer in order to detect an
// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
// needed to complete the UTF-8 character (if applicable) are returned.
function utf8CheckIncomplete(self, buf, i) {
  var j = buf.length - 1;
  if (j < i) return 0;
  var nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 1;
    return nb;
  }
  if (--j < i) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 2;
    return nb;
  }
  if (--j < i) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) {
      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
    }
    return nb;
  }
  return 0;
}

// Validates as many continuation bytes for a multi-byte UTF-8 character as
// needed or are available. If we see a non-continuation byte where we expect
// one, we "replace" the validated continuation bytes we've seen so far with
// UTF-8 replacement characters ('\ufffd'), to match v8's UTF-8 decoding
// behavior. The continuation byte check is included three times in the case
// where all of the continuation bytes for a character exist in the same buffer.
// It is also done this way as a slight performance increase instead of using a
// loop.
function utf8CheckExtraBytes(self, buf, p) {
  if ((buf[0] & 0xC0) !== 0x80) {
    self.lastNeed = 0;
    return '\ufffd'.repeat(p);
  }
  if (self.lastNeed > 1 && buf.length > 1) {
    if ((buf[1] & 0xC0) !== 0x80) {
      self.lastNeed = 1;
      return '\ufffd'.repeat(p + 1);
    }
    if (self.lastNeed > 2 && buf.length > 2) {
      if ((buf[2] & 0xC0) !== 0x80) {
        self.lastNeed = 2;
        return '\ufffd'.repeat(p + 2);
      }
    }
  }
}

// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
function utf8FillLast(buf) {
  var p = this.lastTotal - this.lastNeed;
  var r = utf8CheckExtraBytes(this, buf, p);
  if (r !== undefined) return r;
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, p, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, p, 0, buf.length);
  this.lastNeed -= buf.length;
}

// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
// partial character, the character's bytes are buffered until the required
// number of bytes are available.
function utf8Text(buf, i) {
  var total = utf8CheckIncomplete(this, buf, i);
  if (!this.lastNeed) return buf.toString('utf8', i);
  this.lastTotal = total;
  var end = buf.length - (total - this.lastNeed);
  buf.copy(this.lastChar, 0, end);
  return buf.toString('utf8', i, end);
}

// For UTF-8, a replacement character for each buffered byte of a (partial)
// character needs to be added to the output.
function utf8End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + '\ufffd'.repeat(this.lastTotal - this.lastNeed);
  return r;
}

// UTF-16LE typically needs two bytes per character, but even if we have an even
// number of bytes available, we need to check if we end on a leading/high
// surrogate. In that case, we need to wait for the next two bytes in order to
// decode the last character properly.
function utf16Text(buf, i) {
  if ((buf.length - i) % 2 === 0) {
    var r = buf.toString('utf16le', i);
    if (r) {
      var c = r.charCodeAt(r.length - 1);
      if (c >= 0xD800 && c <= 0xDBFF) {
        this.lastNeed = 2;
        this.lastTotal = 4;
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
        return r.slice(0, -1);
      }
    }
    return r;
  }
  this.lastNeed = 1;
  this.lastTotal = 2;
  this.lastChar[0] = buf[buf.length - 1];
  return buf.toString('utf16le', i, buf.length - 1);
}

// For UTF-16LE we do not explicitly append special replacement characters if we
// end on a partial character, we simply let v8 handle that.
function utf16End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) {
    var end = this.lastTotal - this.lastNeed;
    return r + this.lastChar.toString('utf16le', 0, end);
  }
  return r;
}

function base64Text(buf, i) {
  var n = (buf.length - i) % 3;
  if (n === 0) return buf.toString('base64', i);
  this.lastNeed = 3 - n;
  this.lastTotal = 3;
  if (n === 1) {
    this.lastChar[0] = buf[buf.length - 1];
  } else {
    this.lastChar[0] = buf[buf.length - 2];
    this.lastChar[1] = buf[buf.length - 1];
  }
  return buf.toString('base64', i, buf.length - n);
}

function base64End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
  return r;
}

// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
function simpleWrite(buf) {
  return buf.toString(this.encoding);
}

function simpleEnd(buf) {
  return buf && buf.length ? this.write(buf) : '';
}

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

var Buffer = __webpack_require__(1).Buffer;
var Transform = __webpack_require__(15).Transform;
var binding = __webpack_require__(150);
var util = __webpack_require__(49);
var assert = __webpack_require__(88).ok;
var kMaxLength = __webpack_require__(1).kMaxLength;
var kRangeErrorMessage = 'Cannot create final Buffer. It would be larger ' + 'than 0x' + kMaxLength.toString(16) + ' bytes';

// zlib doesn't provide these, so kludge them in following the same
// const naming scheme zlib uses.
binding.Z_MIN_WINDOWBITS = 8;
binding.Z_MAX_WINDOWBITS = 15;
binding.Z_DEFAULT_WINDOWBITS = 15;

// fewer than 64 bytes per chunk is stupid.
// technically it could work with as few as 8, but even 64 bytes
// is absurdly low.  Usually a MB or more is best.
binding.Z_MIN_CHUNK = 64;
binding.Z_MAX_CHUNK = Infinity;
binding.Z_DEFAULT_CHUNK = 16 * 1024;

binding.Z_MIN_MEMLEVEL = 1;
binding.Z_MAX_MEMLEVEL = 9;
binding.Z_DEFAULT_MEMLEVEL = 8;

binding.Z_MIN_LEVEL = -1;
binding.Z_MAX_LEVEL = 9;
binding.Z_DEFAULT_LEVEL = binding.Z_DEFAULT_COMPRESSION;

// expose all the zlib constants
var bkeys = Object.keys(binding);
for (var bk = 0; bk < bkeys.length; bk++) {
  var bkey = bkeys[bk];
  if (bkey.match(/^Z/)) {
    Object.defineProperty(exports, bkey, {
      enumerable: true, value: binding[bkey], writable: false
    });
  }
}

// translation table for return codes.
var codes = {
  Z_OK: binding.Z_OK,
  Z_STREAM_END: binding.Z_STREAM_END,
  Z_NEED_DICT: binding.Z_NEED_DICT,
  Z_ERRNO: binding.Z_ERRNO,
  Z_STREAM_ERROR: binding.Z_STREAM_ERROR,
  Z_DATA_ERROR: binding.Z_DATA_ERROR,
  Z_MEM_ERROR: binding.Z_MEM_ERROR,
  Z_BUF_ERROR: binding.Z_BUF_ERROR,
  Z_VERSION_ERROR: binding.Z_VERSION_ERROR
};

var ckeys = Object.keys(codes);
for (var ck = 0; ck < ckeys.length; ck++) {
  var ckey = ckeys[ck];
  codes[codes[ckey]] = ckey;
}

Object.defineProperty(exports, 'codes', {
  enumerable: true, value: Object.freeze(codes), writable: false
});

exports.Deflate = Deflate;
exports.Inflate = Inflate;
exports.Gzip = Gzip;
exports.Gunzip = Gunzip;
exports.DeflateRaw = DeflateRaw;
exports.InflateRaw = InflateRaw;
exports.Unzip = Unzip;

exports.createDeflate = function (o) {
  return new Deflate(o);
};

exports.createInflate = function (o) {
  return new Inflate(o);
};

exports.createDeflateRaw = function (o) {
  return new DeflateRaw(o);
};

exports.createInflateRaw = function (o) {
  return new InflateRaw(o);
};

exports.createGzip = function (o) {
  return new Gzip(o);
};

exports.createGunzip = function (o) {
  return new Gunzip(o);
};

exports.createUnzip = function (o) {
  return new Unzip(o);
};

// Convenience methods.
// compress/decompress a string or buffer in one step.
exports.deflate = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new Deflate(opts), buffer, callback);
};

exports.deflateSync = function (buffer, opts) {
  return zlibBufferSync(new Deflate(opts), buffer);
};

exports.gzip = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new Gzip(opts), buffer, callback);
};

exports.gzipSync = function (buffer, opts) {
  return zlibBufferSync(new Gzip(opts), buffer);
};

exports.deflateRaw = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new DeflateRaw(opts), buffer, callback);
};

exports.deflateRawSync = function (buffer, opts) {
  return zlibBufferSync(new DeflateRaw(opts), buffer);
};

exports.unzip = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new Unzip(opts), buffer, callback);
};

exports.unzipSync = function (buffer, opts) {
  return zlibBufferSync(new Unzip(opts), buffer);
};

exports.inflate = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new Inflate(opts), buffer, callback);
};

exports.inflateSync = function (buffer, opts) {
  return zlibBufferSync(new Inflate(opts), buffer);
};

exports.gunzip = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new Gunzip(opts), buffer, callback);
};

exports.gunzipSync = function (buffer, opts) {
  return zlibBufferSync(new Gunzip(opts), buffer);
};

exports.inflateRaw = function (buffer, opts, callback) {
  if (typeof opts === 'function') {
    callback = opts;
    opts = {};
  }
  return zlibBuffer(new InflateRaw(opts), buffer, callback);
};

exports.inflateRawSync = function (buffer, opts) {
  return zlibBufferSync(new InflateRaw(opts), buffer);
};

function zlibBuffer(engine, buffer, callback) {
  var buffers = [];
  var nread = 0;

  engine.on('error', onError);
  engine.on('end', onEnd);

  engine.end(buffer);
  flow();

  function flow() {
    var chunk;
    while (null !== (chunk = engine.read())) {
      buffers.push(chunk);
      nread += chunk.length;
    }
    engine.once('readable', flow);
  }

  function onError(err) {
    engine.removeListener('end', onEnd);
    engine.removeListener('readable', flow);
    callback(err);
  }

  function onEnd() {
    var buf;
    var err = null;

    if (nread >= kMaxLength) {
      err = new RangeError(kRangeErrorMessage);
    } else {
      buf = Buffer.concat(buffers, nread);
    }

    buffers = [];
    engine.close();
    callback(err, buf);
  }
}

function zlibBufferSync(engine, buffer) {
  if (typeof buffer === 'string') buffer = Buffer.from(buffer);

  if (!Buffer.isBuffer(buffer)) throw new TypeError('Not a string or buffer');

  var flushFlag = engine._finishFlushFlag;

  return engine._processChunk(buffer, flushFlag);
}

// generic zlib
// minimal 2-byte header
function Deflate(opts) {
  if (!(this instanceof Deflate)) return new Deflate(opts);
  Zlib.call(this, opts, binding.DEFLATE);
}

function Inflate(opts) {
  if (!(this instanceof Inflate)) return new Inflate(opts);
  Zlib.call(this, opts, binding.INFLATE);
}

// gzip - bigger header, same deflate compression
function Gzip(opts) {
  if (!(this instanceof Gzip)) return new Gzip(opts);
  Zlib.call(this, opts, binding.GZIP);
}

function Gunzip(opts) {
  if (!(this instanceof Gunzip)) return new Gunzip(opts);
  Zlib.call(this, opts, binding.GUNZIP);
}

// raw - no header
function DeflateRaw(opts) {
  if (!(this instanceof DeflateRaw)) return new DeflateRaw(opts);
  Zlib.call(this, opts, binding.DEFLATERAW);
}

function InflateRaw(opts) {
  if (!(this instanceof InflateRaw)) return new InflateRaw(opts);
  Zlib.call(this, opts, binding.INFLATERAW);
}

// auto-detect header.
function Unzip(opts) {
  if (!(this instanceof Unzip)) return new Unzip(opts);
  Zlib.call(this, opts, binding.UNZIP);
}

function isValidFlushFlag(flag) {
  return flag === binding.Z_NO_FLUSH || flag === binding.Z_PARTIAL_FLUSH || flag === binding.Z_SYNC_FLUSH || flag === binding.Z_FULL_FLUSH || flag === binding.Z_FINISH || flag === binding.Z_BLOCK;
}

// the Zlib class they all inherit from
// This thing manages the queue of requests, and returns
// true or false if there is anything in the queue when
// you call the .write() method.

function Zlib(opts, mode) {
  var _this = this;

  this._opts = opts = opts || {};
  this._chunkSize = opts.chunkSize || exports.Z_DEFAULT_CHUNK;

  Transform.call(this, opts);

  if (opts.flush && !isValidFlushFlag(opts.flush)) {
    throw new Error('Invalid flush flag: ' + opts.flush);
  }
  if (opts.finishFlush && !isValidFlushFlag(opts.finishFlush)) {
    throw new Error('Invalid flush flag: ' + opts.finishFlush);
  }

  this._flushFlag = opts.flush || binding.Z_NO_FLUSH;
  this._finishFlushFlag = typeof opts.finishFlush !== 'undefined' ? opts.finishFlush : binding.Z_FINISH;

  if (opts.chunkSize) {
    if (opts.chunkSize < exports.Z_MIN_CHUNK || opts.chunkSize > exports.Z_MAX_CHUNK) {
      throw new Error('Invalid chunk size: ' + opts.chunkSize);
    }
  }

  if (opts.windowBits) {
    if (opts.windowBits < exports.Z_MIN_WINDOWBITS || opts.windowBits > exports.Z_MAX_WINDOWBITS) {
      throw new Error('Invalid windowBits: ' + opts.windowBits);
    }
  }

  if (opts.level) {
    if (opts.level < exports.Z_MIN_LEVEL || opts.level > exports.Z_MAX_LEVEL) {
      throw new Error('Invalid compression level: ' + opts.level);
    }
  }

  if (opts.memLevel) {
    if (opts.memLevel < exports.Z_MIN_MEMLEVEL || opts.memLevel > exports.Z_MAX_MEMLEVEL) {
      throw new Error('Invalid memLevel: ' + opts.memLevel);
    }
  }

  if (opts.strategy) {
    if (opts.strategy != exports.Z_FILTERED && opts.strategy != exports.Z_HUFFMAN_ONLY && opts.strategy != exports.Z_RLE && opts.strategy != exports.Z_FIXED && opts.strategy != exports.Z_DEFAULT_STRATEGY) {
      throw new Error('Invalid strategy: ' + opts.strategy);
    }
  }

  if (opts.dictionary) {
    if (!Buffer.isBuffer(opts.dictionary)) {
      throw new Error('Invalid dictionary: it should be a Buffer instance');
    }
  }

  this._handle = new binding.Zlib(mode);

  var self = this;
  this._hadError = false;
  this._handle.onerror = function (message, errno) {
    // there is no way to cleanly recover.
    // continuing only obscures problems.
    _close(self);
    self._hadError = true;

    var error = new Error(message);
    error.errno = errno;
    error.code = exports.codes[errno];
    self.emit('error', error);
  };

  var level = exports.Z_DEFAULT_COMPRESSION;
  if (typeof opts.level === 'number') level = opts.level;

  var strategy = exports.Z_DEFAULT_STRATEGY;
  if (typeof opts.strategy === 'number') strategy = opts.strategy;

  this._handle.init(opts.windowBits || exports.Z_DEFAULT_WINDOWBITS, level, opts.memLevel || exports.Z_DEFAULT_MEMLEVEL, strategy, opts.dictionary);

  this._buffer = Buffer.allocUnsafe(this._chunkSize);
  this._offset = 0;
  this._level = level;
  this._strategy = strategy;

  this.once('end', this.close);

  Object.defineProperty(this, '_closed', {
    get: function () {
      return !_this._handle;
    },
    configurable: true,
    enumerable: true
  });
}

util.inherits(Zlib, Transform);

Zlib.prototype.params = function (level, strategy, callback) {
  if (level < exports.Z_MIN_LEVEL || level > exports.Z_MAX_LEVEL) {
    throw new RangeError('Invalid compression level: ' + level);
  }
  if (strategy != exports.Z_FILTERED && strategy != exports.Z_HUFFMAN_ONLY && strategy != exports.Z_RLE && strategy != exports.Z_FIXED && strategy != exports.Z_DEFAULT_STRATEGY) {
    throw new TypeError('Invalid strategy: ' + strategy);
  }

  if (this._level !== level || this._strategy !== strategy) {
    var self = this;
    this.flush(binding.Z_SYNC_FLUSH, function () {
      assert(self._handle, 'zlib binding closed');
      self._handle.params(level, strategy);
      if (!self._hadError) {
        self._level = level;
        self._strategy = strategy;
        if (callback) callback();
      }
    });
  } else {
    process.nextTick(callback);
  }
};

Zlib.prototype.reset = function () {
  assert(this._handle, 'zlib binding closed');
  return this._handle.reset();
};

// This is the _flush function called by the transform class,
// internally, when the last chunk has been written.
Zlib.prototype._flush = function (callback) {
  this._transform(Buffer.alloc(0), '', callback);
};

Zlib.prototype.flush = function (kind, callback) {
  var _this2 = this;

  var ws = this._writableState;

  if (typeof kind === 'function' || kind === undefined && !callback) {
    callback = kind;
    kind = binding.Z_FULL_FLUSH;
  }

  if (ws.ended) {
    if (callback) process.nextTick(callback);
  } else if (ws.ending) {
    if (callback) this.once('end', callback);
  } else if (ws.needDrain) {
    if (callback) {
      this.once('drain', function () {
        return _this2.flush(kind, callback);
      });
    }
  } else {
    this._flushFlag = kind;
    this.write(Buffer.alloc(0), '', callback);
  }
};

Zlib.prototype.close = function (callback) {
  _close(this, callback);
  process.nextTick(emitCloseNT, this);
};

function _close(engine, callback) {
  if (callback) process.nextTick(callback);

  // Caller may invoke .close after a zlib error (which will null _handle).
  if (!engine._handle) return;

  engine._handle.close();
  engine._handle = null;
}

function emitCloseNT(self) {
  self.emit('close');
}

Zlib.prototype._transform = function (chunk, encoding, cb) {
  var flushFlag;
  var ws = this._writableState;
  var ending = ws.ending || ws.ended;
  var last = ending && (!chunk || ws.length === chunk.length);

  if (chunk !== null && !Buffer.isBuffer(chunk)) return cb(new Error('invalid input'));

  if (!this._handle) return cb(new Error('zlib binding closed'));

  // If it's the last chunk, or a final flush, we use the Z_FINISH flush flag
  // (or whatever flag was provided using opts.finishFlush).
  // If it's explicitly flushing at some other time, then we use
  // Z_FULL_FLUSH. Otherwise, use Z_NO_FLUSH for maximum compression
  // goodness.
  if (last) flushFlag = this._finishFlushFlag;else {
    flushFlag = this._flushFlag;
    // once we've flushed the last of the queue, stop flushing and
    // go back to the normal behavior.
    if (chunk.length >= ws.length) {
      this._flushFlag = this._opts.flush || binding.Z_NO_FLUSH;
    }
  }

  this._processChunk(chunk, flushFlag, cb);
};

Zlib.prototype._processChunk = function (chunk, flushFlag, cb) {
  var availInBefore = chunk && chunk.length;
  var availOutBefore = this._chunkSize - this._offset;
  var inOff = 0;

  var self = this;

  var async = typeof cb === 'function';

  if (!async) {
    var buffers = [];
    var nread = 0;

    var error;
    this.on('error', function (er) {
      error = er;
    });

    assert(this._handle, 'zlib binding closed');
    do {
      var res = this._handle.writeSync(flushFlag, chunk, // in
      inOff, // in_off
      availInBefore, // in_len
      this._buffer, // out
      this._offset, //out_off
      availOutBefore); // out_len
    } while (!this._hadError && callback(res[0], res[1]));

    if (this._hadError) {
      throw error;
    }

    if (nread >= kMaxLength) {
      _close(this);
      throw new RangeError(kRangeErrorMessage);
    }

    var buf = Buffer.concat(buffers, nread);
    _close(this);

    return buf;
  }

  assert(this._handle, 'zlib binding closed');
  var req = this._handle.write(flushFlag, chunk, // in
  inOff, // in_off
  availInBefore, // in_len
  this._buffer, // out
  this._offset, //out_off
  availOutBefore); // out_len

  req.buffer = chunk;
  req.callback = callback;

  function callback(availInAfter, availOutAfter) {
    // When the callback is used in an async write, the callback's
    // context is the `req` object that was created. The req object
    // is === this._handle, and that's why it's important to null
    // out the values after they are done being used. `this._handle`
    // can stay in memory longer than the callback and buffer are needed.
    if (this) {
      this.buffer = null;
      this.callback = null;
    }

    if (self._hadError) return;

    var have = availOutBefore - availOutAfter;
    assert(have >= 0, 'have should not go down');

    if (have > 0) {
      var out = self._buffer.slice(self._offset, self._offset + have);
      self._offset += have;
      // serve some output to the consumer.
      if (async) {
        self.push(out);
      } else {
        buffers.push(out);
        nread += out.length;
      }
    }

    // exhausted the output buffer, or used all the input create a new one.
    if (availOutAfter === 0 || self._offset >= self._chunkSize) {
      availOutBefore = self._chunkSize;
      self._offset = 0;
      self._buffer = Buffer.allocUnsafe(self._chunkSize);
    }

    if (availOutAfter === 0) {
      // Not actually done.  Need to reprocess.
      // Also, update the availInBefore to the availInAfter value,
      // so that if we have to hit it a third (fourth, etc.) time,
      // it'll have the correct byte counts.
      inOff += availInBefore - availInAfter;
      availInBefore = availInAfter;

      if (!async) return true;

      var newReq = self._handle.write(flushFlag, chunk, inOff, availInBefore, self._buffer, self._offset, self._chunkSize);
      newReq.callback = callback; // this same function
      newReq.buffer = chunk;
      return;
    }

    if (!async) return false;

    // finished with the chunk.
    cb();
  }
};

util.inherits(Deflate, Zlib);
util.inherits(Inflate, Zlib);
util.inherits(Gzip, Zlib);
util.inherits(Gunzip, Zlib);
util.inherits(DeflateRaw, Zlib);
util.inherits(InflateRaw, Zlib);
util.inherits(Unzip, Zlib);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  // Allow for deprecating things in the process of starting up.
  if (isUndefined(global.process)) {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  if (process.noDeprecation === true) {
    return fn;
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnviron;
exports.debuglog = function(set) {
  if (isUndefined(debugEnviron))
    debugEnviron = process.env.NODE_DEBUG || '';
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = __webpack_require__(151);

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = __webpack_require__(152);

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7), __webpack_require__(11)))

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6
(function() {
  var EmbeddedFont, PDFFont, StandardFont, fontkit;

  fontkit = __webpack_require__(167);

  PDFFont = (function() {
    PDFFont.open = function(document, src, family, id) {
      var font;
      if (typeof src === 'string') {
        if (StandardFont.isStandardFont(src)) {
          return new StandardFont(document, src, id);
        }
        font = fontkit.openSync(src, family);
      } else if (Buffer.isBuffer(src)) {
        font = fontkit.create(src, family);
      } else if (src instanceof Uint8Array) {
        font = fontkit.create(new Buffer(src), family);
      } else if (src instanceof ArrayBuffer) {
        font = fontkit.create(new Buffer(new Uint8Array(src)), family);
      }
      if (font == null) {
        throw new Error('Not a supported font format or standard PDF font.');
      }
      return new EmbeddedFont(document, font, id);
    };

    function PDFFont() {
      throw new Error('Cannot construct a PDFFont directly.');
    }

    PDFFont.prototype.encode = function(text) {
      throw new Error('Must be implemented by subclasses');
    };

    PDFFont.prototype.widthOfString = function(text) {
      throw new Error('Must be implemented by subclasses');
    };

    PDFFont.prototype.ref = function() {
      return this.dictionary != null ? this.dictionary : this.dictionary = this.document.ref();
    };

    PDFFont.prototype.finalize = function() {
      if (this.embedded || (this.dictionary == null)) {
        return;
      }
      this.embed();
      return this.embedded = true;
    };

    PDFFont.prototype.embed = function() {
      throw new Error('Must be implemented by subclasses');
    };

    PDFFont.prototype.lineHeight = function(size, includeGap) {
      var gap;
      if (includeGap == null) {
        includeGap = false;
      }
      gap = includeGap ? this.lineGap : 0;
      return (this.ascender + gap - this.descender) / 1000 * size;
    };

    return PDFFont;

  })();

  module.exports = PDFFont;

  StandardFont = __webpack_require__(292);

  EmbeddedFont = __webpack_require__(294);

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.7.1
(function() {
  var DecodeStream, iconv;

  try {
    iconv = __webpack_require__(52);
  } catch (_error) {}

  DecodeStream = (function() {
    var key;

    function DecodeStream(buffer) {
      this.buffer = buffer;
      this.pos = 0;
      this.length = this.buffer.length;
    }

    DecodeStream.TYPES = {
      UInt8: 1,
      UInt16: 2,
      UInt24: 3,
      UInt32: 4,
      Int8: 1,
      Int16: 2,
      Int24: 3,
      Int32: 4,
      Float: 4,
      Double: 8
    };

    for (key in Buffer.prototype) {
      if (key.slice(0, 4) === 'read') {
        (function(key) {
          var bytes;
          bytes = DecodeStream.TYPES[key.replace(/read|[BL]E/g, '')];
          return DecodeStream.prototype[key] = function() {
            var ret;
            ret = this.buffer[key](this.pos);
            this.pos += bytes;
            return ret;
          };
        })(key);
      }
    }

    DecodeStream.prototype.readString = function(length, encoding) {
      var buf, byte, i, _i, _ref;
      if (encoding == null) {
        encoding = 'ascii';
      }
      switch (encoding) {
        case 'utf16le':
        case 'ucs2':
        case 'utf8':
        case 'ascii':
          return this.buffer.toString(encoding, this.pos, this.pos += length);
        case 'utf16be':
          buf = new Buffer(this.readBuffer(length));
          for (i = _i = 0, _ref = buf.length - 1; _i < _ref; i = _i += 2) {
            byte = buf[i];
            buf[i] = buf[i + 1];
            buf[i + 1] = byte;
          }
          return buf.toString('utf16le');
        default:
          buf = this.readBuffer(length);
          if (iconv) {
            try {
              return iconv.decode(buf, encoding);
            } catch (_error) {}
          }
          return buf;
      }
    };

    DecodeStream.prototype.readBuffer = function(length) {
      return this.buffer.slice(this.pos, this.pos += length);
    };

    DecodeStream.prototype.readUInt24BE = function() {
      return (this.readUInt16BE() << 8) + this.readUInt8();
    };

    DecodeStream.prototype.readUInt24LE = function() {
      return this.readUInt16LE() + (this.readUInt8() << 16);
    };

    DecodeStream.prototype.readInt24BE = function() {
      return (this.readInt16BE() << 8) + this.readUInt8();
    };

    DecodeStream.prototype.readInt24LE = function() {
      return this.readUInt16LE() + (this.readInt8() << 16);
    };

    return DecodeStream;

  })();

  module.exports = DecodeStream;

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

// Some environments don't have global Buffer (e.g. React Native).
// Solution would be installing npm modules "buffer" and "stream" explicitly.
var Buffer = __webpack_require__(1).Buffer;

var bomHandling = __webpack_require__(170),
    iconv = module.exports;

// All codecs and aliases are kept here, keyed by encoding name/alias.
// They are lazy loaded in `iconv.getCodec` from `encodings/index.js`.
iconv.encodings = null;

// Characters emitted in case of error.
iconv.defaultCharUnicode = '�';
iconv.defaultCharSingleByte = '?';

// Public API.
iconv.encode = function encode(str, encoding, options) {
    str = "" + (str || ""); // Ensure string.

    var encoder = iconv.getEncoder(encoding, options);

    var res = encoder.write(str);
    var trail = encoder.end();
    
    return (trail && trail.length > 0) ? Buffer.concat([res, trail]) : res;
}

iconv.decode = function decode(buf, encoding, options) {
    if (typeof buf === 'string') {
        if (!iconv.skipDecodeWarning) {
            console.error('Iconv-lite warning: decode()-ing strings is deprecated. Refer to https://github.com/ashtuchkin/iconv-lite/wiki/Use-Buffers-when-decoding');
            iconv.skipDecodeWarning = true;
        }

        buf = new Buffer("" + (buf || ""), "binary"); // Ensure buffer.
    }

    var decoder = iconv.getDecoder(encoding, options);

    var res = decoder.write(buf);
    var trail = decoder.end();

    return trail ? (res + trail) : res;
}

iconv.encodingExists = function encodingExists(enc) {
    try {
        iconv.getCodec(enc);
        return true;
    } catch (e) {
        return false;
    }
}

// Legacy aliases to convert functions
iconv.toEncoding = iconv.encode;
iconv.fromEncoding = iconv.decode;

// Search for a codec in iconv.encodings. Cache codec data in iconv._codecDataCache.
iconv._codecDataCache = {};
iconv.getCodec = function getCodec(encoding) {
    if (!iconv.encodings)
        iconv.encodings = __webpack_require__(171); // Lazy load all encoding definitions.
    
    // Canonicalize encoding name: strip all non-alphanumeric chars and appended year.
    var enc = (''+encoding).toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, "");

    // Traverse iconv.encodings to find actual codec.
    var codecOptions = {};
    while (true) {
        var codec = iconv._codecDataCache[enc];
        if (codec)
            return codec;

        var codecDef = iconv.encodings[enc];

        switch (typeof codecDef) {
            case "string": // Direct alias to other encoding.
                enc = codecDef;
                break;

            case "object": // Alias with options. Can be layered.
                for (var key in codecDef)
                    codecOptions[key] = codecDef[key];

                if (!codecOptions.encodingName)
                    codecOptions.encodingName = enc;
                
                enc = codecDef.type;
                break;

            case "function": // Codec itself.
                if (!codecOptions.encodingName)
                    codecOptions.encodingName = enc;

                // The codec function must load all tables and return object with .encoder and .decoder methods.
                // It'll be called only once (for each different options object).
                codec = new codecDef(codecOptions, iconv);

                iconv._codecDataCache[codecOptions.encodingName] = codec; // Save it to be reused later.
                return codec;

            default:
                throw new Error("Encoding not recognized: '" + encoding + "' (searched as: '"+enc+"')");
        }
    }
}

iconv.getEncoder = function getEncoder(encoding, options) {
    var codec = iconv.getCodec(encoding),
        encoder = new codec.encoder(options, codec);

    if (codec.bomAware && options && options.addBOM)
        encoder = new bomHandling.PrependBOM(encoder, options);

    return encoder;
}

iconv.getDecoder = function getDecoder(encoding, options) {
    var codec = iconv.getCodec(encoding),
        decoder = new codec.decoder(options, codec);

    if (codec.bomAware && !(options && options.stripBOM === false))
        decoder = new bomHandling.StripBOM(decoder, options);

    return decoder;
}


// Load extensions in Node. All of them are omitted in Browserify build via 'browser' field in package.json.
var nodeVer = typeof process !== 'undefined' && process.versions && process.versions.node;
if (nodeVer) {

    // Load streaming support in Node v0.10+
    var nodeVerArr = nodeVer.split(".").map(Number);
    if (nodeVerArr[0] > 0 || nodeVerArr[1] >= 10) {
        __webpack_require__(185)(iconv);
    }

    // Load Node primitive extensions.
    __webpack_require__(186)(iconv);
}

if (false) {
    console.error("iconv-lite warning: javascript files use encoding different from utf-8. See https://github.com/ashtuchkin/iconv-lite/wiki/Javascript-source-file-encodings for more info.");
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(11)))

/***/ }),
/* 53 */
/***/ (function(module, exports) {

module.exports = [["0","\u0000",127,"€"],["8140","丂丄丅丆丏丒丗丟丠両丣並丩丮丯丱丳丵丷丼乀乁乂乄乆乊乑乕乗乚乛乢乣乤乥乧乨乪",5,"乲乴",9,"乿",6,"亇亊"],["8180","亐亖亗亙亜亝亞亣亪亯亰亱亴亶亷亸亹亼亽亾仈仌仏仐仒仚仛仜仠仢仦仧仩仭仮仯仱仴仸仹仺仼仾伀伂",6,"伋伌伒",4,"伜伝伡伣伨伩伬伭伮伱伳伵伷伹伻伾",4,"佄佅佇",5,"佒佔佖佡佢佦佨佪佫佭佮佱佲併佷佸佹佺佽侀侁侂侅來侇侊侌侎侐侒侓侕侖侘侙侚侜侞侟価侢"],["8240","侤侫侭侰",4,"侶",8,"俀俁係俆俇俈俉俋俌俍俒",4,"俙俛俠俢俤俥俧俫俬俰俲俴俵俶俷俹俻俼俽俿",11],["8280","個倎倐們倓倕倖倗倛倝倞倠倢倣値倧倫倯",10,"倻倽倿偀偁偂偄偅偆偉偊偋偍偐",4,"偖偗偘偙偛偝",7,"偦",5,"偭",8,"偸偹偺偼偽傁傂傃傄傆傇傉傊傋傌傎",20,"傤傦傪傫傭",4,"傳",6,"傼"],["8340","傽",17,"僐",5,"僗僘僙僛",10,"僨僩僪僫僯僰僱僲僴僶",4,"僼",9,"儈"],["8380","儉儊儌",5,"儓",13,"儢",28,"兂兇兊兌兎兏児兒兓兗兘兙兛兝",4,"兣兤兦內兩兪兯兲兺兾兿冃冄円冇冊冋冎冏冐冑冓冔冘冚冝冞冟冡冣冦",4,"冭冮冴冸冹冺冾冿凁凂凃凅凈凊凍凎凐凒",5],["8440","凘凙凚凜凞凟凢凣凥",5,"凬凮凱凲凴凷凾刄刅刉刋刌刏刐刓刔刕刜刞刟刡刢刣別刦刧刪刬刯刱刲刴刵刼刾剄",5,"剋剎剏剒剓剕剗剘"],["8480","剙剚剛剝剟剠剢剣剤剦剨剫剬剭剮剰剱剳",9,"剾劀劃",4,"劉",6,"劑劒劔",6,"劜劤劥劦劧劮劯劰労",9,"勀勁勂勄勅勆勈勊勌勍勎勏勑勓勔動勗務",5,"勠勡勢勣勥",10,"勱",7,"勻勼勽匁匂匃匄匇匉匊匋匌匎"],["8540","匑匒匓匔匘匛匜匞匟匢匤匥匧匨匩匫匬匭匯",9,"匼匽區卂卄卆卋卌卍卐協単卙卛卝卥卨卪卬卭卲卶卹卻卼卽卾厀厁厃厇厈厊厎厏"],["8580","厐",4,"厖厗厙厛厜厞厠厡厤厧厪厫厬厭厯",6,"厷厸厹厺厼厽厾叀參",4,"収叏叐叒叓叕叚叜叝叞叡叢叧叴叺叾叿吀吂吅吇吋吔吘吙吚吜吢吤吥吪吰吳吶吷吺吽吿呁呂呄呅呇呉呌呍呎呏呑呚呝",4,"呣呥呧呩",7,"呴呹呺呾呿咁咃咅咇咈咉咊咍咑咓咗咘咜咞咟咠咡"],["8640","咢咥咮咰咲咵咶咷咹咺咼咾哃哅哊哋哖哘哛哠",4,"哫哬哯哰哱哴",5,"哻哾唀唂唃唄唅唈唊",4,"唒唓唕",5,"唜唝唞唟唡唥唦"],["8680","唨唩唫唭唲唴唵唶唸唹唺唻唽啀啂啅啇啈啋",4,"啑啒啓啔啗",4,"啝啞啟啠啢啣啨啩啫啯",5,"啹啺啽啿喅喆喌喍喎喐喒喓喕喖喗喚喛喞喠",6,"喨",8,"喲喴営喸喺喼喿",4,"嗆嗇嗈嗊嗋嗎嗏嗐嗕嗗",4,"嗞嗠嗢嗧嗩嗭嗮嗰嗱嗴嗶嗸",4,"嗿嘂嘃嘄嘅"],["8740","嘆嘇嘊嘋嘍嘐",7,"嘙嘚嘜嘝嘠嘡嘢嘥嘦嘨嘩嘪嘫嘮嘯嘰嘳嘵嘷嘸嘺嘼嘽嘾噀",11,"噏",4,"噕噖噚噛噝",4],["8780","噣噥噦噧噭噮噯噰噲噳噴噵噷噸噹噺噽",7,"嚇",6,"嚐嚑嚒嚔",14,"嚤",10,"嚰",6,"嚸嚹嚺嚻嚽",12,"囋",8,"囕囖囘囙囜団囥",5,"囬囮囯囲図囶囷囸囻囼圀圁圂圅圇國",6],["8840","園",9,"圝圞圠圡圢圤圥圦圧圫圱圲圴",4,"圼圽圿坁坃坄坅坆坈坉坋坒",4,"坘坙坢坣坥坧坬坮坰坱坲坴坵坸坹坺坽坾坿垀"],["8880","垁垇垈垉垊垍",4,"垔",6,"垜垝垞垟垥垨垪垬垯垰垱垳垵垶垷垹",8,"埄",6,"埌埍埐埑埓埖埗埛埜埞埡埢埣埥",7,"埮埰埱埲埳埵埶執埻埼埾埿堁堃堄堅堈堉堊堌堎堏堐堒堓堔堖堗堘堚堛堜堝堟堢堣堥",4,"堫",4,"報堲堳場堶",7],["8940","堾",5,"塅",6,"塎塏塐塒塓塕塖塗塙",4,"塟",5,"塦",4,"塭",16,"塿墂墄墆墇墈墊墋墌"],["8980","墍",4,"墔",4,"墛墜墝墠",7,"墪",17,"墽墾墿壀壂壃壄壆",10,"壒壓壔壖",13,"壥",5,"壭壯壱売壴壵壷壸壺",7,"夃夅夆夈",4,"夎夐夑夒夓夗夘夛夝夞夠夡夢夣夦夨夬夰夲夳夵夶夻"],["8a40","夽夾夿奀奃奅奆奊奌奍奐奒奓奙奛",4,"奡奣奤奦",12,"奵奷奺奻奼奾奿妀妅妉妋妌妎妏妐妑妔妕妘妚妛妜妝妟妠妡妢妦"],["8a80","妧妬妭妰妱妳",5,"妺妼妽妿",6,"姇姈姉姌姍姎姏姕姖姙姛姞",4,"姤姦姧姩姪姫姭",11,"姺姼姽姾娀娂娊娋娍娎娏娐娒娔娕娖娗娙娚娛娝娞娡娢娤娦娧娨娪",6,"娳娵娷",4,"娽娾娿婁",4,"婇婈婋",9,"婖婗婘婙婛",5],["8b40","婡婣婤婥婦婨婩婫",8,"婸婹婻婼婽婾媀",17,"媓",6,"媜",13,"媫媬"],["8b80","媭",4,"媴媶媷媹",4,"媿嫀嫃",5,"嫊嫋嫍",4,"嫓嫕嫗嫙嫚嫛嫝嫞嫟嫢嫤嫥嫧嫨嫪嫬",4,"嫲",22,"嬊",11,"嬘",25,"嬳嬵嬶嬸",7,"孁",6],["8c40","孈",7,"孒孖孞孠孡孧孨孫孭孮孯孲孴孶孷學孹孻孼孾孿宂宆宊宍宎宐宑宒宔宖実宧宨宩宬宭宮宯宱宲宷宺宻宼寀寁寃寈寉寊寋寍寎寏"],["8c80","寑寔",8,"寠寢寣實寧審",4,"寯寱",6,"寽対尀専尃尅將專尋尌對導尐尒尓尗尙尛尞尟尠尡尣尦尨尩尪尫尭尮尯尰尲尳尵尶尷屃屄屆屇屌屍屒屓屔屖屗屘屚屛屜屝屟屢層屧",6,"屰屲",6,"屻屼屽屾岀岃",4,"岉岊岋岎岏岒岓岕岝",4,"岤",4],["8d40","岪岮岯岰岲岴岶岹岺岻岼岾峀峂峃峅",5,"峌",5,"峓",5,"峚",6,"峢峣峧峩峫峬峮峯峱",9,"峼",4],["8d80","崁崄崅崈",5,"崏",4,"崕崗崘崙崚崜崝崟",4,"崥崨崪崫崬崯",4,"崵",7,"崿",7,"嵈嵉嵍",10,"嵙嵚嵜嵞",10,"嵪嵭嵮嵰嵱嵲嵳嵵",12,"嶃",21,"嶚嶛嶜嶞嶟嶠"],["8e40","嶡",21,"嶸",12,"巆",6,"巎",12,"巜巟巠巣巤巪巬巭"],["8e80","巰巵巶巸",4,"巿帀帄帇帉帊帋帍帎帒帓帗帞",7,"帨",4,"帯帰帲",4,"帹帺帾帿幀幁幃幆",5,"幍",6,"幖",4,"幜幝幟幠幣",14,"幵幷幹幾庁庂広庅庈庉庌庍庎庒庘庛庝庡庢庣庤庨",4,"庮",4,"庴庺庻庼庽庿",6],["8f40","廆廇廈廋",5,"廔廕廗廘廙廚廜",11,"廩廫",8,"廵廸廹廻廼廽弅弆弇弉弌弍弎弐弒弔弖弙弚弜弝弞弡弢弣弤"],["8f80","弨弫弬弮弰弲",6,"弻弽弾弿彁",14,"彑彔彙彚彛彜彞彟彠彣彥彧彨彫彮彯彲彴彵彶彸彺彽彾彿徃徆徍徎徏徑従徔徖徚徛徝從徟徠徢",5,"復徫徬徯",5,"徶徸徹徺徻徾",4,"忇忈忊忋忎忓忔忕忚忛応忞忟忢忣忥忦忨忩忬忯忰忲忳忴忶忷忹忺忼怇"],["9040","怈怉怋怌怐怑怓怗怘怚怞怟怢怣怤怬怭怮怰",4,"怶",4,"怽怾恀恄",6,"恌恎恏恑恓恔恖恗恘恛恜恞恟恠恡恥恦恮恱恲恴恵恷恾悀"],["9080","悁悂悅悆悇悈悊悋悎悏悐悑悓悕悗悘悙悜悞悡悢悤悥悧悩悪悮悰悳悵悶悷悹悺悽",7,"惇惈惉惌",4,"惒惓惔惖惗惙惛惞惡",4,"惪惱惲惵惷惸惻",4,"愂愃愄愅愇愊愋愌愐",4,"愖愗愘愙愛愜愝愞愡愢愥愨愩愪愬",18,"慀",6],["9140","慇慉態慍慏慐慒慓慔慖",6,"慞慟慠慡慣慤慥慦慩",6,"慱慲慳慴慶慸",18,"憌憍憏",4,"憕"],["9180","憖",6,"憞",8,"憪憫憭",9,"憸",5,"憿懀懁懃",4,"應懌",4,"懓懕",16,"懧",13,"懶",8,"戀",5,"戇戉戓戔戙戜戝戞戠戣戦戧戨戩戫戭戯戰戱戲戵戶戸",4,"扂扄扅扆扊"],["9240","扏扐払扖扗扙扚扜",6,"扤扥扨扱扲扴扵扷扸扺扻扽抁抂抃抅抆抇抈抋",5,"抔抙抜抝択抣抦抧抩抪抭抮抯抰抲抳抴抶抷抸抺抾拀拁"],["9280","拃拋拏拑拕拝拞拠拡拤拪拫拰拲拵拸拹拺拻挀挃挄挅挆挊挋挌挍挏挐挒挓挔挕挗挘挙挜挦挧挩挬挭挮挰挱挳",5,"挻挼挾挿捀捁捄捇捈捊捑捒捓捔捖",7,"捠捤捥捦捨捪捫捬捯捰捲捳捴捵捸捹捼捽捾捿掁掃掄掅掆掋掍掑掓掔掕掗掙",6,"採掤掦掫掯掱掲掵掶掹掻掽掿揀"],["9340","揁揂揃揅揇揈揊揋揌揑揓揔揕揗",6,"揟揢揤",4,"揫揬揮揯揰揱揳揵揷揹揺揻揼揾搃搄搆",4,"損搎搑搒搕",5,"搝搟搢搣搤"],["9380","搥搧搨搩搫搮",5,"搵",4,"搻搼搾摀摂摃摉摋",6,"摓摕摖摗摙",4,"摟",7,"摨摪摫摬摮",9,"摻",6,"撃撆撈",8,"撓撔撗撘撚撛撜撝撟",4,"撥撦撧撨撪撫撯撱撲撳撴撶撹撻撽撾撿擁擃擄擆",6,"擏擑擓擔擕擖擙據"],["9440","擛擜擝擟擠擡擣擥擧",24,"攁",7,"攊",7,"攓",4,"攙",8],["9480","攢攣攤攦",4,"攬攭攰攱攲攳攷攺攼攽敀",4,"敆敇敊敋敍敎敐敒敓敔敗敘敚敜敟敠敡敤敥敧敨敩敪敭敮敯敱敳敵敶數",14,"斈斉斊斍斎斏斒斔斕斖斘斚斝斞斠斢斣斦斨斪斬斮斱",7,"斺斻斾斿旀旂旇旈旉旊旍旐旑旓旔旕旘",7,"旡旣旤旪旫"],["9540","旲旳旴旵旸旹旻",4,"昁昄昅昇昈昉昋昍昐昑昒昖昗昘昚昛昜昞昡昢昣昤昦昩昪昫昬昮昰昲昳昷",4,"昽昿晀時晄",6,"晍晎晐晑晘"],["9580","晙晛晜晝晞晠晢晣晥晧晩",4,"晱晲晳晵晸晹晻晼晽晿暀暁暃暅暆暈暉暊暋暍暎暏暐暒暓暔暕暘",4,"暞",8,"暩",4,"暯",4,"暵暶暷暸暺暻暼暽暿",25,"曚曞",7,"曧曨曪",5,"曱曵曶書曺曻曽朁朂會"],["9640","朄朅朆朇朌朎朏朑朒朓朖朘朙朚朜朞朠",5,"朧朩朮朰朲朳朶朷朸朹朻朼朾朿杁杄杅杇杊杋杍杒杔杕杗",4,"杝杢杣杤杦杧杫杬杮東杴杶"],["9680","杸杹杺杻杽枀枂枃枅枆枈枊枌枍枎枏枑枒枓枔枖枙枛枟枠枡枤枦枩枬枮枱枲枴枹",7,"柂柅",9,"柕柖柗柛柟柡柣柤柦柧柨柪柫柭柮柲柵",7,"柾栁栂栃栄栆栍栐栒栔栕栘",4,"栞栟栠栢",6,"栫",6,"栴栵栶栺栻栿桇桋桍桏桒桖",5],["9740","桜桝桞桟桪桬",7,"桵桸",8,"梂梄梇",7,"梐梑梒梔梕梖梘",9,"梣梤梥梩梪梫梬梮梱梲梴梶梷梸"],["9780","梹",6,"棁棃",5,"棊棌棎棏棐棑棓棔棖棗棙棛",4,"棡棢棤",9,"棯棲棳棴棶棷棸棻棽棾棿椀椂椃椄椆",4,"椌椏椑椓",11,"椡椢椣椥",7,"椮椯椱椲椳椵椶椷椸椺椻椼椾楀楁楃",16,"楕楖楘楙楛楜楟"],["9840","楡楢楤楥楧楨楩楪楬業楯楰楲",4,"楺楻楽楾楿榁榃榅榊榋榌榎",5,"榖榗榙榚榝",9,"榩榪榬榮榯榰榲榳榵榶榸榹榺榼榽"],["9880","榾榿槀槂",7,"構槍槏槑槒槓槕",5,"槜槝槞槡",11,"槮槯槰槱槳",9,"槾樀",9,"樋",11,"標",5,"樠樢",5,"権樫樬樭樮樰樲樳樴樶",6,"樿",4,"橅橆橈",7,"橑",6,"橚"],["9940","橜",4,"橢橣橤橦",10,"橲",6,"橺橻橽橾橿檁檂檃檅",8,"檏檒",4,"檘",7,"檡",5],["9980","檧檨檪檭",114,"欥欦欨",6],["9a40","欯欰欱欳欴欵欶欸欻欼欽欿歀歁歂歄歅歈歊歋歍",11,"歚",7,"歨歩歫",13,"歺歽歾歿殀殅殈"],["9a80","殌殎殏殐殑殔殕殗殘殙殜",4,"殢",7,"殫",7,"殶殸",6,"毀毃毄毆",4,"毌毎毐毑毘毚毜",4,"毢",7,"毬毭毮毰毱毲毴毶毷毸毺毻毼毾",6,"氈",4,"氎氒気氜氝氞氠氣氥氫氬氭氱氳氶氷氹氺氻氼氾氿汃汄汅汈汋",4,"汑汒汓汖汘"],["9b40","汙汚汢汣汥汦汧汫",4,"汱汳汵汷汸決汻汼汿沀沄沇沊沋沍沎沑沒沕沖沗沘沚沜沝沞沠沢沨沬沯沰沴沵沶沷沺泀況泂泃泆泇泈泋泍泎泏泑泒泘"],["9b80","泙泚泜泝泟泤泦泧泩泬泭泲泴泹泿洀洂洃洅洆洈洉洊洍洏洐洑洓洔洕洖洘洜洝洟",5,"洦洨洩洬洭洯洰洴洶洷洸洺洿浀浂浄浉浌浐浕浖浗浘浛浝浟浡浢浤浥浧浨浫浬浭浰浱浲浳浵浶浹浺浻浽",4,"涃涄涆涇涊涋涍涏涐涒涖",4,"涜涢涥涬涭涰涱涳涴涶涷涹",5,"淁淂淃淈淉淊"],["9c40","淍淎淏淐淒淓淔淕淗淚淛淜淟淢淣淥淧淨淩淪淭淯淰淲淴淵淶淸淺淽",7,"渆渇済渉渋渏渒渓渕渘渙減渜渞渟渢渦渧渨渪測渮渰渱渳渵"],["9c80","渶渷渹渻",7,"湅",7,"湏湐湑湒湕湗湙湚湜湝湞湠",10,"湬湭湯",14,"満溁溂溄溇溈溊",4,"溑",6,"溙溚溛溝溞溠溡溣溤溦溨溩溫溬溭溮溰溳溵溸溹溼溾溿滀滃滄滅滆滈滉滊滌滍滎滐滒滖滘滙滛滜滝滣滧滪",5],["9d40","滰滱滲滳滵滶滷滸滺",7,"漃漄漅漇漈漊",4,"漐漑漒漖",9,"漡漢漣漥漦漧漨漬漮漰漲漴漵漷",6,"漿潀潁潂"],["9d80","潃潄潅潈潉潊潌潎",9,"潙潚潛潝潟潠潡潣潤潥潧",5,"潯潰潱潳潵潶潷潹潻潽",6,"澅澆澇澊澋澏",12,"澝澞澟澠澢",4,"澨",10,"澴澵澷澸澺",5,"濁濃",5,"濊",6,"濓",10,"濟濢濣濤濥"],["9e40","濦",7,"濰",32,"瀒",7,"瀜",6,"瀤",6],["9e80","瀫",9,"瀶瀷瀸瀺",17,"灍灎灐",13,"灟",11,"灮灱灲灳灴灷灹灺灻災炁炂炃炄炆炇炈炋炌炍炏炐炑炓炗炘炚炛炞",12,"炰炲炴炵炶為炾炿烄烅烆烇烉烋",12,"烚"],["9f40","烜烝烞烠烡烢烣烥烪烮烰",6,"烸烺烻烼烾",10,"焋",4,"焑焒焔焗焛",10,"焧",7,"焲焳焴"],["9f80","焵焷",13,"煆煇煈煉煋煍煏",12,"煝煟",4,"煥煩",4,"煯煰煱煴煵煶煷煹煻煼煾",5,"熅",4,"熋熌熍熎熐熑熒熓熕熖熗熚",4,"熡",6,"熩熪熫熭",5,"熴熶熷熸熺",8,"燄",9,"燏",4],["a040","燖",9,"燡燢燣燤燦燨",5,"燯",9,"燺",11,"爇",19],["a080","爛爜爞",9,"爩爫爭爮爯爲爳爴爺爼爾牀",6,"牉牊牋牎牏牐牑牓牔牕牗牘牚牜牞牠牣牤牥牨牪牫牬牭牰牱牳牴牶牷牸牻牼牽犂犃犅",4,"犌犎犐犑犓",11,"犠",11,"犮犱犲犳犵犺",6,"狅狆狇狉狊狋狌狏狑狓狔狕狖狘狚狛"],["a1a1","　、。·ˉˇ¨〃々—～‖…‘’“”〔〕〈",7,"〖〗【】±×÷∶∧∨∑∏∪∩∈∷√⊥∥∠⌒⊙∫∮≡≌≈∽∝≠≮≯≤≥∞∵∴♂♀°′″℃＄¤￠￡‰§№☆★○●◎◇◆□■△▲※→←↑↓〓"],["a2a1","ⅰ",9],["a2b1","⒈",19,"⑴",19,"①",9],["a2e5","㈠",9],["a2f1","Ⅰ",11],["a3a1","！＂＃￥％",88,"￣"],["a4a1","ぁ",82],["a5a1","ァ",85],["a6a1","Α",16,"Σ",6],["a6c1","α",16,"σ",6],["a6e0","︵︶︹︺︿﹀︽︾﹁﹂﹃﹄"],["a6ee","︻︼︷︸︱"],["a6f4","︳︴"],["a7a1","А",5,"ЁЖ",25],["a7d1","а",5,"ёж",25],["a840","ˊˋ˙–―‥‵℅℉↖↗↘↙∕∟∣≒≦≧⊿═",35,"▁",6],["a880","█",7,"▓▔▕▼▽◢◣◤◥☉⊕〒〝〞"],["a8a1","āáǎàēéěèīíǐìōóǒòūúǔùǖǘǚǜüêɑ"],["a8bd","ńň"],["a8c0","ɡ"],["a8c5","ㄅ",36],["a940","〡",8,"㊣㎎㎏㎜㎝㎞㎡㏄㏎㏑㏒㏕︰￢￤"],["a959","℡㈱"],["a95c","‐"],["a960","ー゛゜ヽヾ〆ゝゞ﹉",9,"﹔﹕﹖﹗﹙",8],["a980","﹢",4,"﹨﹩﹪﹫"],["a996","〇"],["a9a4","─",75],["aa40","狜狝狟狢",5,"狪狫狵狶狹狽狾狿猀猂猄",5,"猋猌猍猏猐猑猒猔猘猙猚猟猠猣猤猦猧猨猭猯猰猲猳猵猶猺猻猼猽獀",8],["aa80","獉獊獋獌獎獏獑獓獔獕獖獘",7,"獡",10,"獮獰獱"],["ab40","獲",11,"獿",4,"玅玆玈玊玌玍玏玐玒玓玔玕玗玘玙玚玜玝玞玠玡玣",5,"玪玬玭玱玴玵玶玸玹玼玽玾玿珁珃",4],["ab80","珋珌珎珒",6,"珚珛珜珝珟珡珢珣珤珦珨珪珫珬珮珯珰珱珳",4],["ac40","珸",10,"琄琇琈琋琌琍琎琑",8,"琜",5,"琣琤琧琩琫琭琯琱琲琷",4,"琽琾琿瑀瑂",11],["ac80","瑎",6,"瑖瑘瑝瑠",12,"瑮瑯瑱",4,"瑸瑹瑺"],["ad40","瑻瑼瑽瑿璂璄璅璆璈璉璊璌璍璏璑",10,"璝璟",7,"璪",15,"璻",12],["ad80","瓈",9,"瓓",8,"瓝瓟瓡瓥瓧",6,"瓰瓱瓲"],["ae40","瓳瓵瓸",6,"甀甁甂甃甅",7,"甎甐甒甔甕甖甗甛甝甞甠",4,"甦甧甪甮甴甶甹甼甽甿畁畂畃畄畆畇畉畊畍畐畑畒畓畕畖畗畘"],["ae80","畝",7,"畧畨畩畫",6,"畳畵當畷畺",4,"疀疁疂疄疅疇"],["af40","疈疉疊疌疍疎疐疓疕疘疛疜疞疢疦",4,"疭疶疷疺疻疿痀痁痆痋痌痎痏痐痑痓痗痙痚痜痝痟痠痡痥痩痬痭痮痯痲痳痵痶痷痸痺痻痽痾瘂瘄瘆瘇"],["af80","瘈瘉瘋瘍瘎瘏瘑瘒瘓瘔瘖瘚瘜瘝瘞瘡瘣瘧瘨瘬瘮瘯瘱瘲瘶瘷瘹瘺瘻瘽癁療癄"],["b040","癅",6,"癎",5,"癕癗",4,"癝癟癠癡癢癤",6,"癬癭癮癰",7,"癹発發癿皀皁皃皅皉皊皌皍皏皐皒皔皕皗皘皚皛"],["b080","皜",7,"皥",8,"皯皰皳皵",9,"盀盁盃啊阿埃挨哎唉哀皑癌蔼矮艾碍爱隘鞍氨安俺按暗岸胺案肮昂盎凹敖熬翱袄傲奥懊澳芭捌扒叭吧笆八疤巴拔跋靶把耙坝霸罢爸白柏百摆佰败拜稗斑班搬扳般颁板版扮拌伴瓣半办绊邦帮梆榜膀绑棒磅蚌镑傍谤苞胞包褒剥"],["b140","盄盇盉盋盌盓盕盙盚盜盝盞盠",4,"盦",7,"盰盳盵盶盷盺盻盽盿眀眂眃眅眆眊県眎",10,"眛眜眝眞眡眣眤眥眧眪眫"],["b180","眬眮眰",4,"眹眻眽眾眿睂睄睅睆睈",7,"睒",7,"睜薄雹保堡饱宝抱报暴豹鲍爆杯碑悲卑北辈背贝钡倍狈备惫焙被奔苯本笨崩绷甭泵蹦迸逼鼻比鄙笔彼碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛鞭边编贬扁便变卞辨辩辫遍标彪膘表鳖憋别瘪彬斌濒滨宾摈兵冰柄丙秉饼炳"],["b240","睝睞睟睠睤睧睩睪睭",11,"睺睻睼瞁瞂瞃瞆",5,"瞏瞐瞓",11,"瞡瞣瞤瞦瞨瞫瞭瞮瞯瞱瞲瞴瞶",4],["b280","瞼瞾矀",12,"矎",8,"矘矙矚矝",4,"矤病并玻菠播拨钵波博勃搏铂箔伯帛舶脖膊渤泊驳捕卜哺补埠不布步簿部怖擦猜裁材才财睬踩采彩菜蔡餐参蚕残惭惨灿苍舱仓沧藏操糙槽曹草厕策侧册测层蹭插叉茬茶查碴搽察岔差诧拆柴豺搀掺蝉馋谗缠铲产阐颤昌猖"],["b340","矦矨矪矯矰矱矲矴矵矷矹矺矻矼砃",5,"砊砋砎砏砐砓砕砙砛砞砠砡砢砤砨砪砫砮砯砱砲砳砵砶砽砿硁硂硃硄硆硈硉硊硋硍硏硑硓硔硘硙硚"],["b380","硛硜硞",11,"硯",7,"硸硹硺硻硽",6,"场尝常长偿肠厂敞畅唱倡超抄钞朝嘲潮巢吵炒车扯撤掣彻澈郴臣辰尘晨忱沉陈趁衬撑称城橙成呈乘程惩澄诚承逞骋秤吃痴持匙池迟弛驰耻齿侈尺赤翅斥炽充冲虫崇宠抽酬畴踌稠愁筹仇绸瞅丑臭初出橱厨躇锄雏滁除楚"],["b440","碄碅碆碈碊碋碏碐碒碔碕碖碙碝碞碠碢碤碦碨",7,"碵碶碷碸確碻碼碽碿磀磂磃磄磆磇磈磌磍磎磏磑磒磓磖磗磘磚",9],["b480","磤磥磦磧磩磪磫磭",4,"磳磵磶磸磹磻",5,"礂礃礄礆",6,"础储矗搐触处揣川穿椽传船喘串疮窗幢床闯创吹炊捶锤垂春椿醇唇淳纯蠢戳绰疵茨磁雌辞慈瓷词此刺赐次聪葱囱匆从丛凑粗醋簇促蹿篡窜摧崔催脆瘁粹淬翠村存寸磋撮搓措挫错搭达答瘩打大呆歹傣戴带殆代贷袋待逮"],["b540","礍",5,"礔",9,"礟",4,"礥",14,"礵",4,"礽礿祂祃祄祅祇祊",8,"祔祕祘祙祡祣"],["b580","祤祦祩祪祫祬祮祰",6,"祹祻",4,"禂禃禆禇禈禉禋禌禍禎禐禑禒怠耽担丹单郸掸胆旦氮但惮淡诞弹蛋当挡党荡档刀捣蹈倒岛祷导到稻悼道盗德得的蹬灯登等瞪凳邓堤低滴迪敌笛狄涤翟嫡抵底地蒂第帝弟递缔颠掂滇碘点典靛垫电佃甸店惦奠淀殿碉叼雕凋刁掉吊钓调跌爹碟蝶迭谍叠"],["b640","禓",6,"禛",11,"禨",10,"禴",4,"禼禿秂秄秅秇秈秊秌秎秏秐秓秔秖秗秙",5,"秠秡秢秥秨秪"],["b680","秬秮秱",6,"秹秺秼秾秿稁稄稅稇稈稉稊稌稏",4,"稕稖稘稙稛稜丁盯叮钉顶鼎锭定订丢东冬董懂动栋侗恫冻洞兜抖斗陡豆逗痘都督毒犊独读堵睹赌杜镀肚度渡妒端短锻段断缎堆兑队对墩吨蹲敦顿囤钝盾遁掇哆多夺垛躲朵跺舵剁惰堕蛾峨鹅俄额讹娥恶厄扼遏鄂饿恩而儿耳尔饵洱二"],["b740","稝稟稡稢稤",14,"稴稵稶稸稺稾穀",5,"穇",9,"穒",4,"穘",16],["b780","穩",6,"穱穲穳穵穻穼穽穾窂窅窇窉窊窋窌窎窏窐窓窔窙窚窛窞窡窢贰发罚筏伐乏阀法珐藩帆番翻樊矾钒繁凡烦反返范贩犯饭泛坊芳方肪房防妨仿访纺放菲非啡飞肥匪诽吠肺废沸费芬酚吩氛分纷坟焚汾粉奋份忿愤粪丰封枫蜂峰锋风疯烽逢冯缝讽奉凤佛否夫敷肤孵扶拂辐幅氟符伏俘服"],["b840","窣窤窧窩窪窫窮",4,"窴",10,"竀",10,"竌",9,"竗竘竚竛竜竝竡竢竤竧",5,"竮竰竱竲竳"],["b880","竴",4,"竻竼竾笀笁笂笅笇笉笌笍笎笐笒笓笖笗笘笚笜笝笟笡笢笣笧笩笭浮涪福袱弗甫抚辅俯釜斧脯腑府腐赴副覆赋复傅付阜父腹负富讣附妇缚咐噶嘎该改概钙盖溉干甘杆柑竿肝赶感秆敢赣冈刚钢缸肛纲岗港杠篙皋高膏羔糕搞镐稿告哥歌搁戈鸽胳疙割革葛格蛤阁隔铬个各给根跟耕更庚羹"],["b940","笯笰笲笴笵笶笷笹笻笽笿",5,"筆筈筊筍筎筓筕筗筙筜筞筟筡筣",10,"筯筰筳筴筶筸筺筼筽筿箁箂箃箄箆",6,"箎箏"],["b980","箑箒箓箖箘箙箚箛箞箟箠箣箤箥箮箯箰箲箳箵箶箷箹",7,"篂篃範埂耿梗工攻功恭龚供躬公宫弓巩汞拱贡共钩勾沟苟狗垢构购够辜菇咕箍估沽孤姑鼓古蛊骨谷股故顾固雇刮瓜剐寡挂褂乖拐怪棺关官冠观管馆罐惯灌贯光广逛瑰规圭硅归龟闺轨鬼诡癸桂柜跪贵刽辊滚棍锅郭国果裹过哈"],["ba40","篅篈築篊篋篍篎篏篐篒篔",4,"篛篜篞篟篠篢篣篤篧篨篩篫篬篭篯篰篲",4,"篸篹篺篻篽篿",7,"簈簉簊簍簎簐",5,"簗簘簙"],["ba80","簚",4,"簠",5,"簨簩簫",12,"簹",5,"籂骸孩海氦亥害骇酣憨邯韩含涵寒函喊罕翰撼捍旱憾悍焊汗汉夯杭航壕嚎豪毫郝好耗号浩呵喝荷菏核禾和何合盒貉阂河涸赫褐鹤贺嘿黑痕很狠恨哼亨横衡恒轰哄烘虹鸿洪宏弘红喉侯猴吼厚候后呼乎忽瑚壶葫胡蝴狐糊湖"],["bb40","籃",9,"籎",36,"籵",5,"籾",9],["bb80","粈粊",6,"粓粔粖粙粚粛粠粡粣粦粧粨粩粫粬粭粯粰粴",4,"粺粻弧虎唬护互沪户花哗华猾滑画划化话槐徊怀淮坏欢环桓还缓换患唤痪豢焕涣宦幻荒慌黄磺蝗簧皇凰惶煌晃幌恍谎灰挥辉徽恢蛔回毁悔慧卉惠晦贿秽会烩汇讳诲绘荤昏婚魂浑混豁活伙火获或惑霍货祸击圾基机畸稽积箕"],["bc40","粿糀糂糃糄糆糉糋糎",6,"糘糚糛糝糞糡",6,"糩",5,"糰",7,"糹糺糼",13,"紋",5],["bc80","紑",14,"紡紣紤紥紦紨紩紪紬紭紮細",6,"肌饥迹激讥鸡姬绩缉吉极棘辑籍集及急疾汲即嫉级挤几脊己蓟技冀季伎祭剂悸济寄寂计记既忌际妓继纪嘉枷夹佳家加荚颊贾甲钾假稼价架驾嫁歼监坚尖笺间煎兼肩艰奸缄茧检柬碱硷拣捡简俭剪减荐槛鉴践贱见键箭件"],["bd40","紷",54,"絯",7],["bd80","絸",32,"健舰剑饯渐溅涧建僵姜将浆江疆蒋桨奖讲匠酱降蕉椒礁焦胶交郊浇骄娇嚼搅铰矫侥脚狡角饺缴绞剿教酵轿较叫窖揭接皆秸街阶截劫节桔杰捷睫竭洁结解姐戒藉芥界借介疥诫届巾筋斤金今津襟紧锦仅谨进靳晋禁近烬浸"],["be40","継",12,"綧",6,"綯",42],["be80","線",32,"尽劲荆兢茎睛晶鲸京惊精粳经井警景颈静境敬镜径痉靖竟竞净炯窘揪究纠玖韭久灸九酒厩救旧臼舅咎就疚鞠拘狙疽居驹菊局咀矩举沮聚拒据巨具距踞锯俱句惧炬剧捐鹃娟倦眷卷绢撅攫抉掘倔爵觉决诀绝均菌钧军君峻"],["bf40","緻",62],["bf80","縺縼",4,"繂",4,"繈",21,"俊竣浚郡骏喀咖卡咯开揩楷凯慨刊堪勘坎砍看康慷糠扛抗亢炕考拷烤靠坷苛柯棵磕颗科壳咳可渴克刻客课肯啃垦恳坑吭空恐孔控抠口扣寇枯哭窟苦酷库裤夸垮挎跨胯块筷侩快宽款匡筐狂框矿眶旷况亏盔岿窥葵奎魁傀"],["c040","繞",35,"纃",23,"纜纝纞"],["c080","纮纴纻纼绖绤绬绹缊缐缞缷缹缻",6,"罃罆",9,"罒罓馈愧溃坤昆捆困括扩廓阔垃拉喇蜡腊辣啦莱来赖蓝婪栏拦篮阑兰澜谰揽览懒缆烂滥琅榔狼廊郎朗浪捞劳牢老佬姥酪烙涝勒乐雷镭蕾磊累儡垒擂肋类泪棱楞冷厘梨犁黎篱狸离漓理李里鲤礼莉荔吏栗丽厉励砾历利傈例俐"],["c140","罖罙罛罜罝罞罠罣",4,"罫罬罭罯罰罳罵罶罷罸罺罻罼罽罿羀羂",7,"羋羍羏",4,"羕",4,"羛羜羠羢羣羥羦羨",6,"羱"],["c180","羳",4,"羺羻羾翀翂翃翄翆翇翈翉翋翍翏",4,"翖翗翙",5,"翢翣痢立粒沥隶力璃哩俩联莲连镰廉怜涟帘敛脸链恋炼练粮凉梁粱良两辆量晾亮谅撩聊僚疗燎寥辽潦了撂镣廖料列裂烈劣猎琳林磷霖临邻鳞淋凛赁吝拎玲菱零龄铃伶羚凌灵陵岭领另令溜琉榴硫馏留刘瘤流柳六龙聋咙笼窿"],["c240","翤翧翨翪翫翬翭翯翲翴",6,"翽翾翿耂耇耈耉耊耎耏耑耓耚耛耝耞耟耡耣耤耫",5,"耲耴耹耺耼耾聀聁聄聅聇聈聉聎聏聐聑聓聕聖聗"],["c280","聙聛",13,"聫",5,"聲",11,"隆垄拢陇楼娄搂篓漏陋芦卢颅庐炉掳卤虏鲁麓碌露路赂鹿潞禄录陆戮驴吕铝侣旅履屡缕虑氯律率滤绿峦挛孪滦卵乱掠略抡轮伦仑沦纶论萝螺罗逻锣箩骡裸落洛骆络妈麻玛码蚂马骂嘛吗埋买麦卖迈脉瞒馒蛮满蔓曼慢漫"],["c340","聾肁肂肅肈肊肍",5,"肔肕肗肙肞肣肦肧肨肬肰肳肵肶肸肹肻胅胇",4,"胏",6,"胘胟胠胢胣胦胮胵胷胹胻胾胿脀脁脃脄脅脇脈脋"],["c380","脌脕脗脙脛脜脝脟",12,"脭脮脰脳脴脵脷脹",4,"脿谩芒茫盲氓忙莽猫茅锚毛矛铆卯茂冒帽貌贸么玫枚梅酶霉煤没眉媒镁每美昧寐妹媚门闷们萌蒙檬盟锰猛梦孟眯醚靡糜迷谜弥米秘觅泌蜜密幂棉眠绵冕免勉娩缅面苗描瞄藐秒渺庙妙蔑灭民抿皿敏悯闽明螟鸣铭名命谬摸"],["c440","腀",5,"腇腉腍腎腏腒腖腗腘腛",4,"腡腢腣腤腦腨腪腫腬腯腲腳腵腶腷腸膁膃",4,"膉膋膌膍膎膐膒",5,"膙膚膞",4,"膤膥"],["c480","膧膩膫",7,"膴",5,"膼膽膾膿臄臅臇臈臉臋臍",6,"摹蘑模膜磨摩魔抹末莫墨默沫漠寞陌谋牟某拇牡亩姆母墓暮幕募慕木目睦牧穆拿哪呐钠那娜纳氖乃奶耐奈南男难囊挠脑恼闹淖呢馁内嫩能妮霓倪泥尼拟你匿腻逆溺蔫拈年碾撵捻念娘酿鸟尿捏聂孽啮镊镍涅您柠狞凝宁"],["c540","臔",14,"臤臥臦臨臩臫臮",4,"臵",5,"臽臿舃與",4,"舎舏舑舓舕",5,"舝舠舤舥舦舧舩舮舲舺舼舽舿"],["c580","艀艁艂艃艅艆艈艊艌艍艎艐",7,"艙艛艜艝艞艠",7,"艩拧泞牛扭钮纽脓浓农弄奴努怒女暖虐疟挪懦糯诺哦欧鸥殴藕呕偶沤啪趴爬帕怕琶拍排牌徘湃派攀潘盘磐盼畔判叛乓庞旁耪胖抛咆刨炮袍跑泡呸胚培裴赔陪配佩沛喷盆砰抨烹澎彭蓬棚硼篷膨朋鹏捧碰坯砒霹批披劈琵毗"],["c640","艪艫艬艭艱艵艶艷艸艻艼芀芁芃芅芆芇芉芌芐芓芔芕芖芚芛芞芠芢芣芧芲芵芶芺芻芼芿苀苂苃苅苆苉苐苖苙苚苝苢苧苨苩苪苬苭苮苰苲苳苵苶苸"],["c680","苺苼",4,"茊茋茍茐茒茓茖茘茙茝",9,"茩茪茮茰茲茷茻茽啤脾疲皮匹痞僻屁譬篇偏片骗飘漂瓢票撇瞥拼频贫品聘乒坪苹萍平凭瓶评屏坡泼颇婆破魄迫粕剖扑铺仆莆葡菩蒲埔朴圃普浦谱曝瀑期欺栖戚妻七凄漆柒沏其棋奇歧畦崎脐齐旗祈祁骑起岂乞企启契砌器气迄弃汽泣讫掐"],["c740","茾茿荁荂荄荅荈荊",4,"荓荕",4,"荝荢荰",6,"荹荺荾",6,"莇莈莊莋莌莍莏莐莑莔莕莖莗莙莚莝莟莡",6,"莬莭莮"],["c780","莯莵莻莾莿菂菃菄菆菈菉菋菍菎菐菑菒菓菕菗菙菚菛菞菢菣菤菦菧菨菫菬菭恰洽牵扦钎铅千迁签仟谦乾黔钱钳前潜遣浅谴堑嵌欠歉枪呛腔羌墙蔷强抢橇锹敲悄桥瞧乔侨巧鞘撬翘峭俏窍切茄且怯窃钦侵亲秦琴勤芹擒禽寝沁青轻氢倾卿清擎晴氰情顷请庆琼穷秋丘邱球求囚酋泅趋区蛆曲躯屈驱渠"],["c840","菮華菳",4,"菺菻菼菾菿萀萂萅萇萈萉萊萐萒",5,"萙萚萛萞",5,"萩",7,"萲",5,"萹萺萻萾",7,"葇葈葉"],["c880","葊",6,"葒",4,"葘葝葞葟葠葢葤",4,"葪葮葯葰葲葴葷葹葻葼取娶龋趣去圈颧权醛泉全痊拳犬券劝缺炔瘸却鹊榷确雀裙群然燃冉染瓤壤攘嚷让饶扰绕惹热壬仁人忍韧任认刃妊纫扔仍日戎茸蓉荣融熔溶容绒冗揉柔肉茹蠕儒孺如辱乳汝入褥软阮蕊瑞锐闰润若弱撒洒萨腮鳃塞赛三叁"],["c940","葽",4,"蒃蒄蒅蒆蒊蒍蒏",7,"蒘蒚蒛蒝蒞蒟蒠蒢",12,"蒰蒱蒳蒵蒶蒷蒻蒼蒾蓀蓂蓃蓅蓆蓇蓈蓋蓌蓎蓏蓒蓔蓕蓗"],["c980","蓘",4,"蓞蓡蓢蓤蓧",4,"蓭蓮蓯蓱",10,"蓽蓾蔀蔁蔂伞散桑嗓丧搔骚扫嫂瑟色涩森僧莎砂杀刹沙纱傻啥煞筛晒珊苫杉山删煽衫闪陕擅赡膳善汕扇缮墒伤商赏晌上尚裳梢捎稍烧芍勺韶少哨邵绍奢赊蛇舌舍赦摄射慑涉社设砷申呻伸身深娠绅神沈审婶甚肾慎渗声生甥牲升绳"],["ca40","蔃",8,"蔍蔎蔏蔐蔒蔔蔕蔖蔘蔙蔛蔜蔝蔞蔠蔢",8,"蔭",9,"蔾",4,"蕄蕅蕆蕇蕋",10],["ca80","蕗蕘蕚蕛蕜蕝蕟",4,"蕥蕦蕧蕩",8,"蕳蕵蕶蕷蕸蕼蕽蕿薀薁省盛剩胜圣师失狮施湿诗尸虱十石拾时什食蚀实识史矢使屎驶始式示士世柿事拭誓逝势是嗜噬适仕侍释饰氏市恃室视试收手首守寿授售受瘦兽蔬枢梳殊抒输叔舒淑疏书赎孰熟薯暑曙署蜀黍鼠属术述树束戍竖墅庶数漱"],["cb40","薂薃薆薈",6,"薐",10,"薝",6,"薥薦薧薩薫薬薭薱",5,"薸薺",6,"藂",6,"藊",4,"藑藒"],["cb80","藔藖",5,"藝",6,"藥藦藧藨藪",14,"恕刷耍摔衰甩帅栓拴霜双爽谁水睡税吮瞬顺舜说硕朔烁斯撕嘶思私司丝死肆寺嗣四伺似饲巳松耸怂颂送宋讼诵搜艘擞嗽苏酥俗素速粟僳塑溯宿诉肃酸蒜算虽隋随绥髓碎岁穗遂隧祟孙损笋蓑梭唆缩琐索锁所塌他它她塔"],["cc40","藹藺藼藽藾蘀",4,"蘆",10,"蘒蘓蘔蘕蘗",15,"蘨蘪",13,"蘹蘺蘻蘽蘾蘿虀"],["cc80","虁",11,"虒虓處",4,"虛虜虝號虠虡虣",7,"獭挞蹋踏胎苔抬台泰酞太态汰坍摊贪瘫滩坛檀痰潭谭谈坦毯袒碳探叹炭汤塘搪堂棠膛唐糖倘躺淌趟烫掏涛滔绦萄桃逃淘陶讨套特藤腾疼誊梯剔踢锑提题蹄啼体替嚏惕涕剃屉天添填田甜恬舔腆挑条迢眺跳贴铁帖厅听烃"],["cd40","虭虯虰虲",6,"蚃",6,"蚎",4,"蚔蚖",5,"蚞",4,"蚥蚦蚫蚭蚮蚲蚳蚷蚸蚹蚻",4,"蛁蛂蛃蛅蛈蛌蛍蛒蛓蛕蛖蛗蛚蛜"],["cd80","蛝蛠蛡蛢蛣蛥蛦蛧蛨蛪蛫蛬蛯蛵蛶蛷蛺蛻蛼蛽蛿蜁蜄蜅蜆蜋蜌蜎蜏蜐蜑蜔蜖汀廷停亭庭挺艇通桐酮瞳同铜彤童桶捅筒统痛偷投头透凸秃突图徒途涂屠土吐兔湍团推颓腿蜕褪退吞屯臀拖托脱鸵陀驮驼椭妥拓唾挖哇蛙洼娃瓦袜歪外豌弯湾玩顽丸烷完碗挽晚皖惋宛婉万腕汪王亡枉网往旺望忘妄威"],["ce40","蜙蜛蜝蜟蜠蜤蜦蜧蜨蜪蜫蜬蜭蜯蜰蜲蜳蜵蜶蜸蜹蜺蜼蜽蝀",6,"蝊蝋蝍蝏蝐蝑蝒蝔蝕蝖蝘蝚",5,"蝡蝢蝦",7,"蝯蝱蝲蝳蝵"],["ce80","蝷蝸蝹蝺蝿螀螁螄螆螇螉螊螌螎",4,"螔螕螖螘",6,"螠",4,"巍微危韦违桅围唯惟为潍维苇萎委伟伪尾纬未蔚味畏胃喂魏位渭谓尉慰卫瘟温蚊文闻纹吻稳紊问嗡翁瓮挝蜗涡窝我斡卧握沃巫呜钨乌污诬屋无芜梧吾吴毋武五捂午舞伍侮坞戊雾晤物勿务悟误昔熙析西硒矽晰嘻吸锡牺"],["cf40","螥螦螧螩螪螮螰螱螲螴螶螷螸螹螻螼螾螿蟁",4,"蟇蟈蟉蟌",4,"蟔",6,"蟜蟝蟞蟟蟡蟢蟣蟤蟦蟧蟨蟩蟫蟬蟭蟯",9],["cf80","蟺蟻蟼蟽蟿蠀蠁蠂蠄",5,"蠋",7,"蠔蠗蠘蠙蠚蠜",4,"蠣稀息希悉膝夕惜熄烯溪汐犀檄袭席习媳喜铣洗系隙戏细瞎虾匣霞辖暇峡侠狭下厦夏吓掀锨先仙鲜纤咸贤衔舷闲涎弦嫌显险现献县腺馅羡宪陷限线相厢镶香箱襄湘乡翔祥详想响享项巷橡像向象萧硝霄削哮嚣销消宵淆晓"],["d040","蠤",13,"蠳",5,"蠺蠻蠽蠾蠿衁衂衃衆",5,"衎",5,"衕衖衘衚",6,"衦衧衪衭衯衱衳衴衵衶衸衹衺"],["d080","衻衼袀袃袆袇袉袊袌袎袏袐袑袓袔袕袗",4,"袝",4,"袣袥",5,"小孝校肖啸笑效楔些歇蝎鞋协挟携邪斜胁谐写械卸蟹懈泄泻谢屑薪芯锌欣辛新忻心信衅星腥猩惺兴刑型形邢行醒幸杏性姓兄凶胸匈汹雄熊休修羞朽嗅锈秀袖绣墟戌需虚嘘须徐许蓄酗叙旭序畜恤絮婿绪续轩喧宣悬旋玄"],["d140","袬袮袯袰袲",4,"袸袹袺袻袽袾袿裀裃裄裇裈裊裋裌裍裏裐裑裓裖裗裚",4,"裠裡裦裧裩",6,"裲裵裶裷裺裻製裿褀褁褃",5],["d180","褉褋",4,"褑褔",4,"褜",4,"褢褣褤褦褧褨褩褬褭褮褯褱褲褳褵褷选癣眩绚靴薛学穴雪血勋熏循旬询寻驯巡殉汛训讯逊迅压押鸦鸭呀丫芽牙蚜崖衙涯雅哑亚讶焉咽阉烟淹盐严研蜒岩延言颜阎炎沿奄掩眼衍演艳堰燕厌砚雁唁彦焰宴谚验殃央鸯秧杨扬佯疡羊洋阳氧仰痒养样漾邀腰妖瑶"],["d240","褸",8,"襂襃襅",24,"襠",5,"襧",19,"襼"],["d280","襽襾覀覂覄覅覇",26,"摇尧遥窑谣姚咬舀药要耀椰噎耶爷野冶也页掖业叶曳腋夜液一壹医揖铱依伊衣颐夷遗移仪胰疑沂宜姨彝椅蚁倚已乙矣以艺抑易邑屹亿役臆逸肄疫亦裔意毅忆义益溢诣议谊译异翼翌绎茵荫因殷音阴姻吟银淫寅饮尹引隐"],["d340","覢",30,"觃觍觓觔觕觗觘觙觛觝觟觠觡觢觤觧觨觩觪觬觭觮觰觱觲觴",6],["d380","觻",4,"訁",5,"計",21,"印英樱婴鹰应缨莹萤营荧蝇迎赢盈影颖硬映哟拥佣臃痈庸雍踊蛹咏泳涌永恿勇用幽优悠忧尤由邮铀犹油游酉有友右佑釉诱又幼迂淤于盂榆虞愚舆余俞逾鱼愉渝渔隅予娱雨与屿禹宇语羽玉域芋郁吁遇喻峪御愈欲狱育誉"],["d440","訞",31,"訿",8,"詉",21],["d480","詟",25,"詺",6,"浴寓裕预豫驭鸳渊冤元垣袁原援辕园员圆猿源缘远苑愿怨院曰约越跃钥岳粤月悦阅耘云郧匀陨允运蕴酝晕韵孕匝砸杂栽哉灾宰载再在咱攒暂赞赃脏葬遭糟凿藻枣早澡蚤躁噪造皂灶燥责择则泽贼怎增憎曾赠扎喳渣札轧"],["d540","誁",7,"誋",7,"誔",46],["d580","諃",32,"铡闸眨栅榨咋乍炸诈摘斋宅窄债寨瞻毡詹粘沾盏斩辗崭展蘸栈占战站湛绽樟章彰漳张掌涨杖丈帐账仗胀瘴障招昭找沼赵照罩兆肇召遮折哲蛰辙者锗蔗这浙珍斟真甄砧臻贞针侦枕疹诊震振镇阵蒸挣睁征狰争怔整拯正政"],["d640","諤",34,"謈",27],["d680","謤謥謧",30,"帧症郑证芝枝支吱蜘知肢脂汁之织职直植殖执值侄址指止趾只旨纸志挚掷至致置帜峙制智秩稚质炙痔滞治窒中盅忠钟衷终种肿重仲众舟周州洲诌粥轴肘帚咒皱宙昼骤珠株蛛朱猪诸诛逐竹烛煮拄瞩嘱主著柱助蛀贮铸筑"],["d740","譆",31,"譧",4,"譭",25],["d780","讇",24,"讬讱讻诇诐诪谉谞住注祝驻抓爪拽专砖转撰赚篆桩庄装妆撞壮状椎锥追赘坠缀谆准捉拙卓桌琢茁酌啄着灼浊兹咨资姿滋淄孜紫仔籽滓子自渍字鬃棕踪宗综总纵邹走奏揍租足卒族祖诅阻组钻纂嘴醉最罪尊遵昨左佐柞做作坐座"],["d840","谸",8,"豂豃豄豅豈豊豋豍",7,"豖豗豘豙豛",5,"豣",6,"豬",6,"豴豵豶豷豻",6,"貃貄貆貇"],["d880","貈貋貍",6,"貕貖貗貙",20,"亍丌兀丐廿卅丕亘丞鬲孬噩丨禺丿匕乇夭爻卮氐囟胤馗毓睾鼗丶亟鼐乜乩亓芈孛啬嘏仄厍厝厣厥厮靥赝匚叵匦匮匾赜卦卣刂刈刎刭刳刿剀剌剞剡剜蒯剽劂劁劐劓冂罔亻仃仉仂仨仡仫仞伛仳伢佤仵伥伧伉伫佞佧攸佚佝"],["d940","貮",62],["d980","賭",32,"佟佗伲伽佶佴侑侉侃侏佾佻侪佼侬侔俦俨俪俅俚俣俜俑俟俸倩偌俳倬倏倮倭俾倜倌倥倨偾偃偕偈偎偬偻傥傧傩傺僖儆僭僬僦僮儇儋仝氽佘佥俎龠汆籴兮巽黉馘冁夔勹匍訇匐凫夙兕亠兖亳衮袤亵脔裒禀嬴蠃羸冫冱冽冼"],["da40","贎",14,"贠赑赒赗赟赥赨赩赪赬赮赯赱赲赸",8,"趂趃趆趇趈趉趌",4,"趒趓趕",9,"趠趡"],["da80","趢趤",12,"趲趶趷趹趻趽跀跁跂跅跇跈跉跊跍跐跒跓跔凇冖冢冥讠讦讧讪讴讵讷诂诃诋诏诎诒诓诔诖诘诙诜诟诠诤诨诩诮诰诳诶诹诼诿谀谂谄谇谌谏谑谒谔谕谖谙谛谘谝谟谠谡谥谧谪谫谮谯谲谳谵谶卩卺阝阢阡阱阪阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺"],["db40","跕跘跙跜跠跡跢跥跦跧跩跭跮跰跱跲跴跶跼跾",6,"踆踇踈踋踍踎踐踑踒踓踕",7,"踠踡踤",4,"踫踭踰踲踳踴踶踷踸踻踼踾"],["db80","踿蹃蹅蹆蹌",4,"蹓",5,"蹚",11,"蹧蹨蹪蹫蹮蹱邸邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄱鄯鄹酃酆刍奂劢劬劭劾哿勐勖勰叟燮矍廴凵凼鬯厶弁畚巯坌垩垡塾墼壅壑圩圬圪圳圹圮圯坜圻坂坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝"],["dc40","蹳蹵蹷",4,"蹽蹾躀躂躃躄躆躈",6,"躑躒躓躕",6,"躝躟",11,"躭躮躰躱躳",6,"躻",7],["dc80","軃",10,"軏",21,"堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀馨鼙懿艹艽艿芏芊芨芄芎芑芗芙芫芸芾芰苈苊苣芘芷芮苋苌苁芩芴芡芪芟苄苎芤苡茉苷苤茏茇苜苴苒苘茌苻苓茑茚茆茔茕苠苕茜荑荛荜茈莒茼茴茱莛荞茯荏荇荃荟荀茗荠茭茺茳荦荥"],["dd40","軥",62],["dd80","輤",32,"荨茛荩荬荪荭荮莰荸莳莴莠莪莓莜莅荼莶莩荽莸荻莘莞莨莺莼菁萁菥菘堇萘萋菝菽菖萜萸萑萆菔菟萏萃菸菹菪菅菀萦菰菡葜葑葚葙葳蒇蒈葺蒉葸萼葆葩葶蒌蒎萱葭蓁蓍蓐蓦蒽蓓蓊蒿蒺蓠蒡蒹蒴蒗蓥蓣蔌甍蔸蓰蔹蔟蔺"],["de40","轅",32,"轪辀辌辒辝辠辡辢辤辥辦辧辪辬辭辮辯農辳辴辵辷辸辺辻込辿迀迃迆"],["de80","迉",4,"迏迒迖迗迚迠迡迣迧迬迯迱迲迴迵迶迺迻迼迾迿逇逈逌逎逓逕逘蕖蔻蓿蓼蕙蕈蕨蕤蕞蕺瞢蕃蕲蕻薤薨薇薏蕹薮薜薅薹薷薰藓藁藜藿蘧蘅蘩蘖蘼廾弈夼奁耷奕奚奘匏尢尥尬尴扌扪抟抻拊拚拗拮挢拶挹捋捃掭揶捱捺掎掴捭掬掊捩掮掼揲揸揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖"],["df40","這逜連逤逥逧",5,"逰",4,"逷逹逺逽逿遀遃遅遆遈",4,"過達違遖遙遚遜",5,"遤遦遧適遪遫遬遯",4,"遶",6,"遾邁"],["df80","還邅邆邇邉邊邌",4,"邒邔邖邘邚邜邞邟邠邤邥邧邨邩邫邭邲邷邼邽邿郀摺撷撸撙撺擀擐擗擤擢攉攥攮弋忒甙弑卟叱叽叩叨叻吒吖吆呋呒呓呔呖呃吡呗呙吣吲咂咔呷呱呤咚咛咄呶呦咝哐咭哂咴哒咧咦哓哔呲咣哕咻咿哌哙哚哜咩咪咤哝哏哞唛哧唠哽唔哳唢唣唏唑唧唪啧喏喵啉啭啁啕唿啐唼"],["e040","郂郃郆郈郉郋郌郍郒郔郕郖郘郙郚郞郟郠郣郤郥郩郪郬郮郰郱郲郳郵郶郷郹郺郻郼郿鄀鄁鄃鄅",19,"鄚鄛鄜"],["e080","鄝鄟鄠鄡鄤",10,"鄰鄲",6,"鄺",8,"酄唷啖啵啶啷唳唰啜喋嗒喃喱喹喈喁喟啾嗖喑啻嗟喽喾喔喙嗪嗷嗉嘟嗑嗫嗬嗔嗦嗝嗄嗯嗥嗲嗳嗌嗍嗨嗵嗤辔嘞嘈嘌嘁嘤嘣嗾嘀嘧嘭噘嘹噗嘬噍噢噙噜噌噔嚆噤噱噫噻噼嚅嚓嚯囔囗囝囡囵囫囹囿圄圊圉圜帏帙帔帑帱帻帼"],["e140","酅酇酈酑酓酔酕酖酘酙酛酜酟酠酦酧酨酫酭酳酺酻酼醀",4,"醆醈醊醎醏醓",6,"醜",5,"醤",5,"醫醬醰醱醲醳醶醷醸醹醻"],["e180","醼",10,"釈釋釐釒",9,"針",8,"帷幄幔幛幞幡岌屺岍岐岖岈岘岙岑岚岜岵岢岽岬岫岱岣峁岷峄峒峤峋峥崂崃崧崦崮崤崞崆崛嵘崾崴崽嵬嵛嵯嵝嵫嵋嵊嵩嵴嶂嶙嶝豳嶷巅彳彷徂徇徉後徕徙徜徨徭徵徼衢彡犭犰犴犷犸狃狁狎狍狒狨狯狩狲狴狷猁狳猃狺"],["e240","釦",62],["e280","鈥",32,"狻猗猓猡猊猞猝猕猢猹猥猬猸猱獐獍獗獠獬獯獾舛夥飧夤夂饣饧",5,"饴饷饽馀馄馇馊馍馐馑馓馔馕庀庑庋庖庥庠庹庵庾庳赓廒廑廛廨廪膺忄忉忖忏怃忮怄忡忤忾怅怆忪忭忸怙怵怦怛怏怍怩怫怊怿怡恸恹恻恺恂"],["e340","鉆",45,"鉵",16],["e380","銆",7,"銏",24,"恪恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愕愣惴愀愎愫慊慵憬憔憧憷懔懵忝隳闩闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阙阚丬爿戕氵汔汜汊沣沅沐沔沌汨汩汴汶沆沩泐泔沭泷泸泱泗沲泠泖泺泫泮沱泓泯泾"],["e440","銨",5,"銯",24,"鋉",31],["e480","鋩",32,"洹洧洌浃浈洇洄洙洎洫浍洮洵洚浏浒浔洳涑浯涞涠浞涓涔浜浠浼浣渚淇淅淞渎涿淠渑淦淝淙渖涫渌涮渫湮湎湫溲湟溆湓湔渲渥湄滟溱溘滠漭滢溥溧溽溻溷滗溴滏溏滂溟潢潆潇漤漕滹漯漶潋潴漪漉漩澉澍澌潸潲潼潺濑"],["e540","錊",51,"錿",10],["e580","鍊",31,"鍫濉澧澹澶濂濡濮濞濠濯瀚瀣瀛瀹瀵灏灞宀宄宕宓宥宸甯骞搴寤寮褰寰蹇謇辶迓迕迥迮迤迩迦迳迨逅逄逋逦逑逍逖逡逵逶逭逯遄遑遒遐遨遘遢遛暹遴遽邂邈邃邋彐彗彖彘尻咫屐屙孱屣屦羼弪弩弭艴弼鬻屮妁妃妍妩妪妣"],["e640","鍬",34,"鎐",27],["e680","鎬",29,"鏋鏌鏍妗姊妫妞妤姒妲妯姗妾娅娆姝娈姣姘姹娌娉娲娴娑娣娓婀婧婊婕娼婢婵胬媪媛婷婺媾嫫媲嫒嫔媸嫠嫣嫱嫖嫦嫘嫜嬉嬗嬖嬲嬷孀尕尜孚孥孳孑孓孢驵驷驸驺驿驽骀骁骅骈骊骐骒骓骖骘骛骜骝骟骠骢骣骥骧纟纡纣纥纨纩"],["e740","鏎",7,"鏗",54],["e780","鐎",32,"纭纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绮绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡",6,"缪缫缬缭缯",4,"缵幺畿巛甾邕玎玑玮玢玟珏珂珑玷玳珀珉珈珥珙顼琊珩珧珞玺珲琏琪瑛琦琥琨琰琮琬"],["e840","鐯",14,"鐿",43,"鑬鑭鑮鑯"],["e880","鑰",20,"钑钖钘铇铏铓铔铚铦铻锜锠琛琚瑁瑜瑗瑕瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺韪韫韬杌杓杞杈杩枥枇杪杳枘枧杵枨枞枭枋杷杼柰栉柘栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧桀栾桊桉栩梵梏桴桷梓桫棂楮棼椟椠棹"],["e940","锧锳锽镃镈镋镕镚镠镮镴镵長",7,"門",42],["e980","閫",32,"椤棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉楦楣楹榛榧榻榫榭槔榱槁槊槟榕槠榍槿樯槭樗樘橥槲橄樾檠橐橛樵檎橹樽樨橘橼檑檐檩檗檫猷獒殁殂殇殄殒殓殍殚殛殡殪轫轭轱轲轳轵轶轸轷轹轺轼轾辁辂辄辇辋"],["ea40","闌",27,"闬闿阇阓阘阛阞阠阣",6,"阫阬阭阯阰阷阸阹阺阾陁陃陊陎陏陑陒陓陖陗"],["ea80","陘陙陚陜陝陞陠陣陥陦陫陭",4,"陳陸",12,"隇隉隊辍辎辏辘辚軎戋戗戛戟戢戡戥戤戬臧瓯瓴瓿甏甑甓攴旮旯旰昊昙杲昃昕昀炅曷昝昴昱昶昵耆晟晔晁晏晖晡晗晷暄暌暧暝暾曛曜曦曩贲贳贶贻贽赀赅赆赈赉赇赍赕赙觇觊觋觌觎觏觐觑牮犟牝牦牯牾牿犄犋犍犏犒挈挲掰"],["eb40","隌階隑隒隓隕隖隚際隝",9,"隨",7,"隱隲隴隵隷隸隺隻隿雂雃雈雊雋雐雑雓雔雖",9,"雡",6,"雫"],["eb80","雬雭雮雰雱雲雴雵雸雺電雼雽雿霂霃霅霊霋霌霐霑霒霔霕霗",4,"霝霟霠搿擘耄毪毳毽毵毹氅氇氆氍氕氘氙氚氡氩氤氪氲攵敕敫牍牒牖爰虢刖肟肜肓肼朊肽肱肫肭肴肷胧胨胩胪胛胂胄胙胍胗朐胝胫胱胴胭脍脎胲胼朕脒豚脶脞脬脘脲腈腌腓腴腙腚腱腠腩腼腽腭腧塍媵膈膂膑滕膣膪臌朦臊膻"],["ec40","霡",8,"霫霬霮霯霱霳",4,"霺霻霼霽霿",18,"靔靕靗靘靚靜靝靟靣靤靦靧靨靪",7],["ec80","靲靵靷",4,"靽",7,"鞆",4,"鞌鞎鞏鞐鞓鞕鞖鞗鞙",4,"臁膦欤欷欹歃歆歙飑飒飓飕飙飚殳彀毂觳斐齑斓於旆旄旃旌旎旒旖炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煲煊煸煺熘熳熵熨熠燠燔燧燹爝爨灬焘煦熹戾戽扃扈扉礻祀祆祉祛祜祓祚祢祗祠祯祧祺禅禊禚禧禳忑忐"],["ed40","鞞鞟鞡鞢鞤",6,"鞬鞮鞰鞱鞳鞵",46],["ed80","韤韥韨韮",4,"韴韷",23,"怼恝恚恧恁恙恣悫愆愍慝憩憝懋懑戆肀聿沓泶淼矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥磔磙磉磬磲礅磴礓礤礞礴龛黹黻黼盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睇睃睚睨"],["ee40","頏",62],["ee80","顎",32,"睢睥睿瞍睽瞀瞌瞑瞟瞠瞰瞵瞽町畀畎畋畈畛畲畹疃罘罡罟詈罨罴罱罹羁罾盍盥蠲钅钆钇钋钊钌钍钏钐钔钗钕钚钛钜钣钤钫钪钭钬钯钰钲钴钶",4,"钼钽钿铄铈",6,"铐铑铒铕铖铗铙铘铛铞铟铠铢铤铥铧铨铪"],["ef40","顯",5,"颋颎颒颕颙颣風",37,"飏飐飔飖飗飛飜飝飠",4],["ef80","飥飦飩",30,"铩铫铮铯铳铴铵铷铹铼铽铿锃锂锆锇锉锊锍锎锏锒",4,"锘锛锝锞锟锢锪锫锩锬锱锲锴锶锷锸锼锾锿镂锵镄镅镆镉镌镎镏镒镓镔镖镗镘镙镛镞镟镝镡镢镤",8,"镯镱镲镳锺矧矬雉秕秭秣秫稆嵇稃稂稞稔"],["f040","餈",4,"餎餏餑",28,"餯",26],["f080","饊",9,"饖",12,"饤饦饳饸饹饻饾馂馃馉稹稷穑黏馥穰皈皎皓皙皤瓞瓠甬鸠鸢鸨",4,"鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹉鹋鹌鹎鹑鹕鹗鹚鹛鹜鹞鹣鹦",6,"鹱鹭鹳疒疔疖疠疝疬疣疳疴疸痄疱疰痃痂痖痍痣痨痦痤痫痧瘃痱痼痿瘐瘀瘅瘌瘗瘊瘥瘘瘕瘙"],["f140","馌馎馚",10,"馦馧馩",47],["f180","駙",32,"瘛瘼瘢瘠癀瘭瘰瘿瘵癃瘾瘳癍癞癔癜癖癫癯翊竦穸穹窀窆窈窕窦窠窬窨窭窳衤衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褴褫褶襁襦襻疋胥皲皴矜耒耔耖耜耠耢耥耦耧耩耨耱耋耵聃聆聍聒聩聱覃顸颀颃"],["f240","駺",62],["f280","騹",32,"颉颌颍颏颔颚颛颞颟颡颢颥颦虍虔虬虮虿虺虼虻蚨蚍蚋蚬蚝蚧蚣蚪蚓蚩蚶蛄蚵蛎蚰蚺蚱蚯蛉蛏蚴蛩蛱蛲蛭蛳蛐蜓蛞蛴蛟蛘蛑蜃蜇蛸蜈蜊蜍蜉蜣蜻蜞蜥蜮蜚蜾蝈蜴蜱蜩蜷蜿螂蜢蝽蝾蝻蝠蝰蝌蝮螋蝓蝣蝼蝤蝙蝥螓螯螨蟒"],["f340","驚",17,"驲骃骉骍骎骔骕骙骦骩",6,"骲骳骴骵骹骻骽骾骿髃髄髆",4,"髍髎髏髐髒體髕髖髗髙髚髛髜"],["f380","髝髞髠髢髣髤髥髧髨髩髪髬髮髰",8,"髺髼",6,"鬄鬅鬆蟆螈螅螭螗螃螫蟥螬螵螳蟋蟓螽蟑蟀蟊蟛蟪蟠蟮蠖蠓蟾蠊蠛蠡蠹蠼缶罂罄罅舐竺竽笈笃笄笕笊笫笏筇笸笪笙笮笱笠笥笤笳笾笞筘筚筅筵筌筝筠筮筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箫箴篑篁篌篝篚篥篦篪簌篾篼簏簖簋"],["f440","鬇鬉",5,"鬐鬑鬒鬔",10,"鬠鬡鬢鬤",10,"鬰鬱鬳",7,"鬽鬾鬿魀魆魊魋魌魎魐魒魓魕",5],["f480","魛",32,"簟簪簦簸籁籀臾舁舂舄臬衄舡舢舣舭舯舨舫舸舻舳舴舾艄艉艋艏艚艟艨衾袅袈裘裟襞羝羟羧羯羰羲籼敉粑粝粜粞粢粲粼粽糁糇糌糍糈糅糗糨艮暨羿翎翕翥翡翦翩翮翳糸絷綦綮繇纛麸麴赳趄趔趑趱赧赭豇豉酊酐酎酏酤"],["f540","魼",62],["f580","鮻",32,"酢酡酰酩酯酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醴醺豕鹾趸跫踅蹙蹩趵趿趼趺跄跖跗跚跞跎跏跛跆跬跷跸跣跹跻跤踉跽踔踝踟踬踮踣踯踺蹀踹踵踽踱蹉蹁蹂蹑蹒蹊蹰蹶蹼蹯蹴躅躏躔躐躜躞豸貂貊貅貘貔斛觖觞觚觜"],["f640","鯜",62],["f680","鰛",32,"觥觫觯訾謦靓雩雳雯霆霁霈霏霎霪霭霰霾龀龃龅",5,"龌黾鼋鼍隹隼隽雎雒瞿雠銎銮鋈錾鍪鏊鎏鐾鑫鱿鲂鲅鲆鲇鲈稣鲋鲎鲐鲑鲒鲔鲕鲚鲛鲞",5,"鲥",4,"鲫鲭鲮鲰",7,"鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋"],["f740","鰼",62],["f780","鱻鱽鱾鲀鲃鲄鲉鲊鲌鲏鲓鲖鲗鲘鲙鲝鲪鲬鲯鲹鲾",4,"鳈鳉鳑鳒鳚鳛鳠鳡鳌",4,"鳓鳔鳕鳗鳘鳙鳜鳝鳟鳢靼鞅鞑鞒鞔鞯鞫鞣鞲鞴骱骰骷鹘骶骺骼髁髀髅髂髋髌髑魅魃魇魉魈魍魑飨餍餮饕饔髟髡髦髯髫髻髭髹鬈鬏鬓鬟鬣麽麾縻麂麇麈麋麒鏖麝麟黛黜黝黠黟黢黩黧黥黪黯鼢鼬鼯鼹鼷鼽鼾齄"],["f840","鳣",62],["f880","鴢",32],["f940","鵃",62],["f980","鶂",32],["fa40","鶣",62],["fa80","鷢",32],["fb40","鸃",27,"鸤鸧鸮鸰鸴鸻鸼鹀鹍鹐鹒鹓鹔鹖鹙鹝鹟鹠鹡鹢鹥鹮鹯鹲鹴",9,"麀"],["fb80","麁麃麄麅麆麉麊麌",5,"麔",8,"麞麠",5,"麧麨麩麪"],["fc40","麫",8,"麵麶麷麹麺麼麿",4,"黅黆黇黈黊黋黌黐黒黓黕黖黗黙黚點黡黣黤黦黨黫黬黭黮黰",8,"黺黽黿",6],["fc80","鼆",4,"鼌鼏鼑鼒鼔鼕鼖鼘鼚",5,"鼡鼣",8,"鼭鼮鼰鼱"],["fd40","鼲",4,"鼸鼺鼼鼿",4,"齅",10,"齒",38],["fd80","齹",5,"龁龂龍",11,"龜龝龞龡",4,"郎凉秊裏隣"],["fe40","兀嗀﨎﨏﨑﨓﨔礼﨟蘒﨡﨣﨤﨧﨨﨩"]]

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(55);
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),
/* 55 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),
/* 56 */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

var pIE = __webpack_require__(35);
var createDesc = __webpack_require__(27);
var toIObject = __webpack_require__(17);
var toPrimitive = __webpack_require__(58);
var has = __webpack_require__(18);
var IE8_DOM_DEFINE = __webpack_require__(95);
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(5) ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(9);
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(3);
var core = __webpack_require__(2);
var fails = __webpack_require__(19);
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(200), __esModule: true };

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(62);
var $export = __webpack_require__(3);
var redefine = __webpack_require__(99);
var hide = __webpack_require__(13);
var has = __webpack_require__(18);
var Iterators = __webpack_require__(23);
var $iterCreate = __webpack_require__(203);
var setToStringTag = __webpack_require__(39);
var getPrototypeOf = __webpack_require__(206);
var ITERATOR = __webpack_require__(4)('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = (!BUGGY && $native) || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),
/* 62 */
/***/ (function(module, exports) {

module.exports = true;


/***/ }),
/* 63 */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(65)('keys');
var uid = __webpack_require__(38);
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(10);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});
module.exports = function (key) {
  return store[key] || (store[key] = {});
};


/***/ }),
/* 66 */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(68);
var ITERATOR = __webpack_require__(4)('iterator');
var Iterators = __webpack_require__(23);
module.exports = __webpack_require__(2).getIteratorMethod = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(55);
var TAG = __webpack_require__(4)('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(103);

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(216);

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

exports.f = __webpack_require__(4);


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(10);
var core = __webpack_require__(2);
var LIBRARY = __webpack_require__(62);
var wksExt = __webpack_require__(70);
var defineProperty = __webpack_require__(6).f;
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),
/* 72 */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),
/* 73 */
/***/ (function(module, exports) {



/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(223), __esModule: true };

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9);
module.exports = function (it, TYPE) {
  if (!isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
  return it;
};


/***/ }),
/* 76 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function TraversalTracker() {
	this.events = {};
}

TraversalTracker.prototype.startTracking = function (event, callback) {
	var callbacks = this.events[event] || (this.events[event] = []);

	if (callbacks.indexOf(callback) < 0) {
		callbacks.push(callback);
	}
};

TraversalTracker.prototype.stopTracking = function (event, callback) {
	var callbacks = this.events[event];

	if (!callbacks) {
		return;
	}

	var index = callbacks.indexOf(callback);
	if (index >= 0) {
		callbacks.splice(index, 1);
	}
};

TraversalTracker.prototype.emit = function (event) {
	var args = Array.prototype.slice.call(arguments, 1);
	var callbacks = this.events[event];

	if (!callbacks) {
		return;
	}

	callbacks.forEach(function (callback) {
		callback.apply(this, args);
	});
};

TraversalTracker.prototype.auto = function (event, callback, innerFunction) {
	this.startTracking(event, callback);
	innerFunction();
	this.stopTracking(event, callback);
};

module.exports = TraversalTracker;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
(function() {
  var AI, AL, BA, BK, CB, CI_BRK, CJ, CP_BRK, CR, DI_BRK, ID, IN_BRK, LF, LineBreaker, NL, NS, PR_BRK, SA, SG, SP, UnicodeTrie, WJ, XX, base64, characterClasses, classTrie, data, fs, pairTable, _ref, _ref1;

  UnicodeTrie = __webpack_require__(43);

  

  base64 = __webpack_require__(131);

  _ref = __webpack_require__(132), BK = _ref.BK, CR = _ref.CR, LF = _ref.LF, NL = _ref.NL, CB = _ref.CB, BA = _ref.BA, SP = _ref.SP, WJ = _ref.WJ, SP = _ref.SP, BK = _ref.BK, LF = _ref.LF, NL = _ref.NL, AI = _ref.AI, AL = _ref.AL, SA = _ref.SA, SG = _ref.SG, XX = _ref.XX, CJ = _ref.CJ, ID = _ref.ID, NS = _ref.NS, characterClasses = _ref.characterClasses;

  _ref1 = __webpack_require__(133), DI_BRK = _ref1.DI_BRK, IN_BRK = _ref1.IN_BRK, CI_BRK = _ref1.CI_BRK, CP_BRK = _ref1.CP_BRK, PR_BRK = _ref1.PR_BRK, pairTable = _ref1.pairTable;

  data = base64.toByteArray("AA4IAAAAAAAAAhqg5VV7NJtZvz7fTC8zU5deplUlMrQoWqmqahD5So0aipYWrUhVFSVBQ10iSTtUtW6nKDVF6k7d75eQfEUbFcQ9KiFS90tQEolcP23nrLPmO+esr/+f39rr/a293t/e7/P8nmfvlz0O6RvrBJADtbBNaD88IOKTOmOrCqhu9zE770vc1pBV/xL5dxj2V7Zj4FGSomFKStCWNlV7hG1VabZfZ1LaHbFrRwzzLjzPoi1UHDnlV/lWbhgIIJvLBp/pu7AHEdRnIY+ROdXxg4fNpMdTxVnnm08OjozejAVsBqwqz8kddGRlRxsd8c55dNZoPuex6a7Dt6L0NNb03sqgTlR2/OT7eTt0Y0WnpUXxLsp5SMANc4DsmX4zJUBQvznwexm9tsMH+C9uRYMPOd96ZHB29NZjCIM2nfO7tsmQveX3l2r7ft0N4/SRJ7kO6Y8ZCaeuUQ4gMTZ67cp7TgxvlNDsPgOBdZi2YTam5Q7m3+00l+XG7PrDe6YoPmHgK+yLih7fAR16ZFCeD9WvOVt+gfNW/KT5/M6rb/9KERt+N1lad5RneVjzxXHsLofuU+TvrEsr3+26sVz5WJh6L/svoPK3qepFH9bysDljWtD1F7KrxzW1i9r+e/NLxV/acts7zuo304J9+t3Pd6Y6u8f3EAqxNRgv5DZjaI3unyvkvHPya/v3mWVYOC38qBq11+yHZ2bAyP1HbkV92vdno7r2lxz9UwCdCJVfd14NLcpO2CadHS/XPJ9doXgz5vLv/1OBVS3gX0D9n6LiNIDfpilO9RsLgZ2W/wIy8W/Rh93jfoz4qmRV2xElv6p2lRXQdO6/Cv8f5nGn3u0wLXjhnvClabL1o+7yvIpvLfT/xsKG30y/sTvq30ia9Czxp9dr9v/e7Yn/O0QJXxxBOJmceP/DBFa1q1v6oudn/e6qc/37dUoNvnYL4plQ9OoneYOh/r8fOFm7yl7FETHY9dXd5K2n/qEc53dOEe1TTJcvCfp1dpTC334l0vyaFL6mttNEbFjzO+ZV2mLk0qc3BrxJ4d9gweMmjRorxb7vic0rSq6D4wzAyFWas1TqPE0sLI8XLAryC8tPChaN3ALEZSWmtB34SyZcxXYn/E4Tg0LeMIPhgPKD9zyHGMxxhxnDDih7eI86xECTM8zodUCdgffUmRh4rQ8zyA6ow/Aei+01a8OMfziQQ+GAEkhwN/cqUFYAVzA9ex4n6jgtsiMvXf5BtXxEU4hSphvx3v8+9au8eEekEEpkrkne/zB1M+HAPuXIz3paxKlfe8aDMfGWAX6Md6PuuAdKHFVH++Ed5LEji94Z5zeiJIxbmWeN7rr1/ZcaBl5/nimdHsHgIH/ssyLUXZ4fDQ46HnBb+hQqG8yNiKRrXL/b1IPYDUsu3dFKtRMcjqlRvONd4xBvOufx2cUHuk8pmG1D7PyOQmUmluisVFS9OWS8fPIe8LiCtjwJKnEC9hrS9uKmISI3Wa5+vdXUG9dtyfr7g/oJv2wbzeZU838G6mEvntUb3SVV/fBZ6H/sL+lElzeRrHy2Xbe7UWX1q5sgOQ81rv+2baej4fP4m5Mf/GkoxfDtT3++KP7do9Jn26aa6xAhCf5L9RZVfkWKCcjI1eYbm2plvTEqkDxKC402bGzXCYaGnuALHabBT1dFLuOSB7RorOPEhZah1NjZIgR/UFGfK3p1ElYnevOMBDLURdpIjrI+qZk4sffGbRFiXuEmdFjiAODlQCJvIaB1rW61Ljg3y4eS4LAcSgDxxZQs0DYa15wA032Z+lGUfpoyOrFo3mg1sRQtN/fHHCx3TrM8eTrldMbYisDLXbUDoXMLejSq0fUNuO1muX0gEa8vgyegkqiqqbC3W0S4cC9Kmt8MuS/hFO7Xei3f8rSvIjeveMM7kxjUixOrl6gJshe4JU7PhOHpfrRYvu7yoAZKa3Buyk2J+K5W+nNTz1nhJDhRUfDJLiUXxjxXCJeeaOe/r7HlBP/uURc/5efaZEPxr55Qj39rfTLkugUGyMrwo7HAglfEjDriehF1jXtwJkPoiYkYQ5aoXSA7qbCBGKq5hwtu2VkpI9xVDop/1xrC52eiIvCoPWx4lLl40jm9upvycVPfpaH9/o2D4xKXpeNjE2HPQRS+3RFaYTc4Txw7Dvq5X6JBRwzs9mvoB49BK6b+XgsZVJYiInTlSXZ+62FT18mkFVcPKCJsoF5ahb19WheZLUYsSwdrrVM3aQ2XE6SzU2xHDS6iWkodk5AF6F8WUNmmushi8aVpMPwiIfEiQWo3CApONDRjrhDiVnkaFsaP5rjIJkmsN6V26li5LNM3JxGSyKgomknTyyrhcnwv9Qcqaq5utAh44W30SWo8Q0XHKR0glPF4fWst1FUCnk2woFq3iy9fAbzcjJ8fvSjgKVOfn14RDqyQuIgaGJZuswTywdCFSa89SakMf6fe+9KaQMYQlKxiJBczuPSho4wmBjdA+ag6QUOr2GdpcbSl51Ay6khhBt5UXdrnxc7ZGMxCvz96A4oLocxh2+px+1zkyLacCGrxnPzTRSgrLKpStFpH5ppKWm7PgMKZtwgytKLOjbGCOQLTm+KOowqa1sdut9raj1CZFkZD0jbaKNLpJUarSH5Qknx1YiOxdA5L6d5sfI/unmkSF65Ic/AvtXt98Pnrdwl5vgppQ3dYzWFwknZsy6xh2llmLxpegF8ayLwniknlXRHiF4hzzrgB8jQ4wdIqcaHCEAxyJwCeGkXPBZYSrrGa4vMwZvNN9aK0F4JBOK9mQ8g8EjEbIQVwvfS2D8GuCYsdqwqSWbQrfWdTRUJMqmpnWPax4Z7E137I6brHbvjpPlfNZpF1d7PP7HB/MPHcHVKTMhLO4f3CZcaccZEOiS2DpKiQB5KXDJ+Ospcz4qTRCRxgrKEQIgUkKLTKKwskdx2DWo3bg3PEoB5h2nA24olwfKSR+QR6TAvEDi/0czhUT59RZmO1MGeKGeEfuOSPWfL+XKmhqpZmOVR9mJVNDPKOS49Lq+Um10YsBybzDMtemlPCOJEtE8zaXhsaqEs9bngSJGhlOTTMlCXly9Qv5cRN3PVLK7zoMptutf7ihutrQ/Xj7VqeCdUwleTTKklOI8Wep9h7fCY0kVtDtIWKnubWAvbNZtsRRqOYl802vebPEkZRSZc6wXOfPtpPtN5HI63EUFfsy7U/TLr8NkIzaY3vx4A28x765XZMzRZTpMk81YIMuwJ5+/zoCuZj1wGnaHObxa5rpKZj4WhT670maRw04w0e3cZW74Z0aZe2n05hjZaxm6urenz8Ef5O6Yu1J2aqYAlqsCXs5ZB5o1JJ5l3xkTVr8rJQ09NLsBqRRDT2IIjOPmcJa6xQ1R5yGP9jAsj23xYDTezdyqG8YWZ7vJBIWK56K+iDgcHimiQOTIasNSua1fOBxsKMMEKd15jxTl+3CyvGCR+UyRwuSI2XuwRIPoNNclPihfJhaq2mKkNijwYLY6feqohktukmI3KDvOpN7ItCqHHhNuKlxMfBAEO5LjW2RKh6lE5Hd1dtAOopac/Z4FdsNsjMhXz/ug8JGmbVJTA+VOBJXdrYyJcIn5+OEeoK8kWEWF+wdG8ZtZHKSquWDtDVyhFPkRVqguKFkLkKCz46hcU1SUY9oJ2Sk+dmq0kglqk4kqKT1CV9JDELPjK1WsWGkEXF87g9P98e5ff0mIupm/w6vc3kCeq04X5bgJQlcMFRjlFWmSk+kssXCAVikfeAlMuzpUvCSdXiG+dc6KrIiLxxhbEVuKf7vW7KmDQI95bZe3H9mN3/77F6fZ2Yx/F9yClllj8gXpLWLpd5+v90iOaFa9sd7Pvx0lNa1o1+bkiZ69wCiC2x9UIb6/boBCuNMB/HYR0RC6+FD9Oe5qrgQl6JbXtkaYn0wkdNhROLqyhv6cKvyMj1Fvs2o3OOKoMYTubGENLfY5F6H9d8wX1cnINsvz+wZFQu3zhWVlwJvwBEp69Dqu/ZnkBf3nIfbx4TK7zOVJH5sGJX+IMwkn1vVBn38GbpTg9bJnMcTOb5F6Ci5gOn9Fcy6Qzcu+FL6mYJJ+f2ZZJGda1VqruZ0JRXItp8X0aTjIcJgzdaXlha7q7kV4ebrMsunfsRyRa9qYuryBHA0hc1KVsKdE+oI0ljLmSAyMze8lWmc5/lQ18slyTVC/vADTc+SNM5++gztTBLz4m0aVUKcfgOEExuKVomJ7XQDZuziMDjG6JP9tgR7JXZTeo9RGetW/Xm9/TgPJpTgHACPOGvmy2mDm9fl09WeMm9sQUAXP3Su2uApeCwJVT5iWCXDgmcuTsFgU9Nm6/PusJzSbDQIMfl6INY/OAEvZRN54BSSXUClM51im6Wn9VhVamKJmzOaFJErgJcs0etFZ40LIF3EPkjFTjGmAhsd174NnOwJW8TdJ1Dja+E6Wa6FVS22Haj1DDA474EesoMP5nbspAPJLWJ8rYcP1DwCslhnn+gTFm+sS9wY+U6SogAa9tiwpoxuaFeqm2OK+uozR6SfiLCOPz36LiDlzXr6UWd7BpY6mlrNANkTOeme5EgnnAkQRTGo9T6iYxbUKfGJcI9B+ub2PcyUOgpwXbOf3bHFWtygD7FYbRhb+vkzi87dB0JeXl/vBpBUz93VtqZi7AL7C1VowTF+tGmyurw7DBcktc+UMY0E10Jw4URojf8NdaNpN6E1q4+Oz+4YePtMLy8FPRP");

  classTrie = new UnicodeTrie(data);

  LineBreaker = (function() {
    var Break, mapClass, mapFirst;

    function LineBreaker(string) {
      this.string = string;
      this.pos = 0;
      this.lastPos = 0;
      this.curClass = null;
      this.nextClass = null;
    }

    LineBreaker.prototype.nextCodePoint = function() {
      var code, next;
      code = this.string.charCodeAt(this.pos++);
      next = this.string.charCodeAt(this.pos);
      if ((0xd800 <= code && code <= 0xdbff) && (0xdc00 <= next && next <= 0xdfff)) {
        this.pos++;
        return ((code - 0xd800) * 0x400) + (next - 0xdc00) + 0x10000;
      }
      return code;
    };

    mapClass = function(c) {
      switch (c) {
        case AI:
          return AL;
        case SA:
        case SG:
        case XX:
          return AL;
        case CJ:
          return NS;
        default:
          return c;
      }
    };

    mapFirst = function(c) {
      switch (c) {
        case LF:
        case NL:
          return BK;
        case CB:
          return BA;
        case SP:
          return WJ;
        default:
          return c;
      }
    };

    LineBreaker.prototype.nextCharClass = function(first) {
      if (first == null) {
        first = false;
      }
      return mapClass(classTrie.get(this.nextCodePoint()));
    };

    Break = (function() {
      function Break(position, required) {
        this.position = position;
        this.required = required != null ? required : false;
      }

      return Break;

    })();

    LineBreaker.prototype.nextBreak = function() {
      var cur, lastClass, shouldBreak;
      if (this.curClass == null) {
        this.curClass = mapFirst(this.nextCharClass());
      }
      while (this.pos < this.string.length) {
        this.lastPos = this.pos;
        lastClass = this.nextClass;
        this.nextClass = this.nextCharClass();
        if (this.curClass === BK || (this.curClass === CR && this.nextClass !== LF)) {
          this.curClass = mapFirst(mapClass(this.nextClass));
          return new Break(this.lastPos, true);
        }
        cur = (function() {
          switch (this.nextClass) {
            case SP:
              return this.curClass;
            case BK:
            case LF:
            case NL:
              return BK;
            case CR:
              return CR;
            case CB:
              return BA;
          }
        }).call(this);
        if (cur != null) {
          this.curClass = cur;
          if (this.nextClass === CB) {
            return new Break(this.lastPos);
          }
          continue;
        }
        shouldBreak = false;
        switch (pairTable[this.curClass][this.nextClass]) {
          case DI_BRK:
            shouldBreak = true;
            break;
          case IN_BRK:
            shouldBreak = lastClass === SP;
            break;
          case CI_BRK:
            shouldBreak = lastClass === SP;
            if (!shouldBreak) {
              continue;
            }
            break;
          case CP_BRK:
            if (lastClass !== SP) {
              continue;
            }
        }
        this.curClass = this.nextClass;
        if (shouldBreak) {
          return new Break(this.lastPos);
        }
      }
      if (this.pos >= this.string.length) {
        if (this.lastPos < this.string.length) {
          this.lastPos = this.string.length;
          return new Break(this.string.length);
        } else {
          return null;
        }
      }
    };

    return LineBreaker;

  })();

  module.exports = LineBreaker;

}).call(this);


/***/ }),
/* 79 */
/***/ (function(module, exports) {

var TINF_OK = 0;
var TINF_DATA_ERROR = -3;

function Tree() {
  this.table = new Uint16Array(16);   /* table of code length counts */
  this.trans = new Uint16Array(288);  /* code -> symbol translation table */
}

function Data(source, dest) {
  this.source = source;
  this.sourceIndex = 0;
  this.tag = 0;
  this.bitcount = 0;
  
  this.dest = dest;
  this.destLen = 0;
  
  this.ltree = new Tree();  /* dynamic length/symbol tree */
  this.dtree = new Tree();  /* dynamic distance tree */
}

/* --------------------------------------------------- *
 * -- uninitialized global data (static structures) -- *
 * --------------------------------------------------- */

var sltree = new Tree();
var sdtree = new Tree();

/* extra bits and base tables for length codes */
var length_bits = new Uint8Array(30);
var length_base = new Uint16Array(30);

/* extra bits and base tables for distance codes */
var dist_bits = new Uint8Array(30);
var dist_base = new Uint16Array(30);

/* special ordering of code length codes */
var clcidx = new Uint8Array([
  16, 17, 18, 0, 8, 7, 9, 6,
  10, 5, 11, 4, 12, 3, 13, 2,
  14, 1, 15
]);

/* used by tinf_decode_trees, avoids allocations every call */
var code_tree = new Tree();
var lengths = new Uint8Array(288 + 32);

/* ----------------------- *
 * -- utility functions -- *
 * ----------------------- */

/* build extra bits and base tables */
function tinf_build_bits_base(bits, base, delta, first) {
  var i, sum;

  /* build bits table */
  for (i = 0; i < delta; ++i) bits[i] = 0;
  for (i = 0; i < 30 - delta; ++i) bits[i + delta] = i / delta | 0;

  /* build base table */
  for (sum = first, i = 0; i < 30; ++i) {
    base[i] = sum;
    sum += 1 << bits[i];
  }
}

/* build the fixed huffman trees */
function tinf_build_fixed_trees(lt, dt) {
  var i;

  /* build fixed length tree */
  for (i = 0; i < 7; ++i) lt.table[i] = 0;

  lt.table[7] = 24;
  lt.table[8] = 152;
  lt.table[9] = 112;

  for (i = 0; i < 24; ++i) lt.trans[i] = 256 + i;
  for (i = 0; i < 144; ++i) lt.trans[24 + i] = i;
  for (i = 0; i < 8; ++i) lt.trans[24 + 144 + i] = 280 + i;
  for (i = 0; i < 112; ++i) lt.trans[24 + 144 + 8 + i] = 144 + i;

  /* build fixed distance tree */
  for (i = 0; i < 5; ++i) dt.table[i] = 0;

  dt.table[5] = 32;

  for (i = 0; i < 32; ++i) dt.trans[i] = i;
}

/* given an array of code lengths, build a tree */
var offs = new Uint16Array(16);

function tinf_build_tree(t, lengths, off, num) {
  var i, sum;

  /* clear code length count table */
  for (i = 0; i < 16; ++i) t.table[i] = 0;

  /* scan symbol lengths, and sum code length counts */
  for (i = 0; i < num; ++i) t.table[lengths[off + i]]++;

  t.table[0] = 0;

  /* compute offset table for distribution sort */
  for (sum = 0, i = 0; i < 16; ++i) {
    offs[i] = sum;
    sum += t.table[i];
  }

  /* create code->symbol translation table (symbols sorted by code) */
  for (i = 0; i < num; ++i) {
    if (lengths[off + i]) t.trans[offs[lengths[off + i]]++] = i;
  }
}

/* ---------------------- *
 * -- decode functions -- *
 * ---------------------- */

/* get one bit from source stream */
function tinf_getbit(d) {
  /* check if tag is empty */
  if (!d.bitcount--) {
    /* load next tag */
    d.tag = d.source[d.sourceIndex++];
    d.bitcount = 7;
  }

  /* shift bit out of tag */
  var bit = d.tag & 1;
  d.tag >>>= 1;

  return bit;
}

/* read a num bit value from a stream and add base */
function tinf_read_bits(d, num, base) {
  if (!num)
    return base;

  while (d.bitcount < 24) {
    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
    d.bitcount += 8;
  }

  var val = d.tag & (0xffff >>> (16 - num));
  d.tag >>>= num;
  d.bitcount -= num;
  return val + base;
}

/* given a data stream and a tree, decode a symbol */
function tinf_decode_symbol(d, t) {
  while (d.bitcount < 24) {
    d.tag |= d.source[d.sourceIndex++] << d.bitcount;
    d.bitcount += 8;
  }
  
  var sum = 0, cur = 0, len = 0;
  var tag = d.tag;

  /* get more bits while code value is above sum */
  do {
    cur = 2 * cur + (tag & 1);
    tag >>>= 1;
    ++len;

    sum += t.table[len];
    cur -= t.table[len];
  } while (cur >= 0);
  
  d.tag = tag;
  d.bitcount -= len;

  return t.trans[sum + cur];
}

/* given a data stream, decode dynamic trees from it */
function tinf_decode_trees(d, lt, dt) {
  var hlit, hdist, hclen;
  var i, num, length;

  /* get 5 bits HLIT (257-286) */
  hlit = tinf_read_bits(d, 5, 257);

  /* get 5 bits HDIST (1-32) */
  hdist = tinf_read_bits(d, 5, 1);

  /* get 4 bits HCLEN (4-19) */
  hclen = tinf_read_bits(d, 4, 4);

  for (i = 0; i < 19; ++i) lengths[i] = 0;

  /* read code lengths for code length alphabet */
  for (i = 0; i < hclen; ++i) {
    /* get 3 bits code length (0-7) */
    var clen = tinf_read_bits(d, 3, 0);
    lengths[clcidx[i]] = clen;
  }

  /* build code length tree */
  tinf_build_tree(code_tree, lengths, 0, 19);

  /* decode code lengths for the dynamic trees */
  for (num = 0; num < hlit + hdist;) {
    var sym = tinf_decode_symbol(d, code_tree);

    switch (sym) {
      case 16:
        /* copy previous code length 3-6 times (read 2 bits) */
        var prev = lengths[num - 1];
        for (length = tinf_read_bits(d, 2, 3); length; --length) {
          lengths[num++] = prev;
        }
        break;
      case 17:
        /* repeat code length 0 for 3-10 times (read 3 bits) */
        for (length = tinf_read_bits(d, 3, 3); length; --length) {
          lengths[num++] = 0;
        }
        break;
      case 18:
        /* repeat code length 0 for 11-138 times (read 7 bits) */
        for (length = tinf_read_bits(d, 7, 11); length; --length) {
          lengths[num++] = 0;
        }
        break;
      default:
        /* values 0-15 represent the actual code lengths */
        lengths[num++] = sym;
        break;
    }
  }

  /* build dynamic trees */
  tinf_build_tree(lt, lengths, 0, hlit);
  tinf_build_tree(dt, lengths, hlit, hdist);
}

/* ----------------------------- *
 * -- block inflate functions -- *
 * ----------------------------- */

/* given a stream and two trees, inflate a block of data */
function tinf_inflate_block_data(d, lt, dt) {
  while (1) {
    var sym = tinf_decode_symbol(d, lt);

    /* check for end of block */
    if (sym === 256) {
      return TINF_OK;
    }

    if (sym < 256) {
      d.dest[d.destLen++] = sym;
    } else {
      var length, dist, offs;
      var i;

      sym -= 257;

      /* possibly get more bits from length code */
      length = tinf_read_bits(d, length_bits[sym], length_base[sym]);

      dist = tinf_decode_symbol(d, dt);

      /* possibly get more bits from distance code */
      offs = d.destLen - tinf_read_bits(d, dist_bits[dist], dist_base[dist]);

      /* copy match */
      for (i = offs; i < offs + length; ++i) {
        d.dest[d.destLen++] = d.dest[i];
      }
    }
  }
}

/* inflate an uncompressed block of data */
function tinf_inflate_uncompressed_block(d) {
  var length, invlength;
  var i;
  
  /* unread from bitbuffer */
  while (d.bitcount > 8) {
    d.sourceIndex--;
    d.bitcount -= 8;
  }

  /* get length */
  length = d.source[d.sourceIndex + 1];
  length = 256 * length + d.source[d.sourceIndex];

  /* get one's complement of length */
  invlength = d.source[d.sourceIndex + 3];
  invlength = 256 * invlength + d.source[d.sourceIndex + 2];

  /* check length */
  if (length !== (~invlength & 0x0000ffff))
    return TINF_DATA_ERROR;

  d.sourceIndex += 4;

  /* copy block */
  for (i = length; i; --i)
    d.dest[d.destLen++] = d.source[d.sourceIndex++];

  /* make sure we start next block on a byte boundary */
  d.bitcount = 0;

  return TINF_OK;
}

/* inflate stream from source to dest */
function tinf_uncompress(source, dest) {
  var d = new Data(source, dest);
  var bfinal, btype, res;

  do {
    /* read final block flag */
    bfinal = tinf_getbit(d);

    /* read block type (2 bits) */
    btype = tinf_read_bits(d, 2, 0);

    /* decompress block */
    switch (btype) {
      case 0:
        /* decompress uncompressed block */
        res = tinf_inflate_uncompressed_block(d);
        break;
      case 1:
        /* decompress block with fixed huffman trees */
        res = tinf_inflate_block_data(d, sltree, sdtree);
        break;
      case 2:
        /* decompress block with dynamic huffman trees */
        tinf_decode_trees(d, d.ltree, d.dtree);
        res = tinf_inflate_block_data(d, d.ltree, d.dtree);
        break;
      default:
        res = TINF_DATA_ERROR;
    }

    if (res !== TINF_OK)
      throw new Error('Data error');

  } while (!bfinal);

  if (d.destLen < d.dest.length) {
    if (typeof d.dest.slice === 'function')
      return d.dest.slice(0, d.destLen);
    else
      return d.dest.subarray(0, d.destLen);
  }
  
  return d.dest;
}

/* -------------------- *
 * -- initialization -- *
 * -------------------- */

/* build fixed huffman trees */
tinf_build_fixed_trees(sltree, sdtree);

/* build extra bits and base tables */
tinf_build_bits_base(length_bits, length_base, 4, 3);
tinf_build_bits_base(dist_bits, dist_base, 2, 1);

/* fix a special case */
length_bits[28] = 0;
length_base[28] = 258;

module.exports = tinf_uncompress;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isString = __webpack_require__(0).isString;
var isArray = __webpack_require__(0).isArray;
var isUndefined = __webpack_require__(0).isUndefined;
var isNull = __webpack_require__(0).isNull;

/**
 * Creates an instance of StyleContextStack used for style inheritance and style overrides
 *
 * @constructor
 * @this {StyleContextStack}
 * @param {Object} named styles dictionary
 * @param {Object} optional default style definition
 */
function StyleContextStack(styleDictionary, defaultStyle) {
	this.defaultStyle = defaultStyle || {};
	this.styleDictionary = styleDictionary;
	this.styleOverrides = [];
}

/**
 * Creates cloned version of current stack
 * @return {StyleContextStack} current stack snapshot
 */
StyleContextStack.prototype.clone = function () {
	var stack = new StyleContextStack(this.styleDictionary, this.defaultStyle);

	this.styleOverrides.forEach(function (item) {
		stack.styleOverrides.push(item);
	});

	return stack;
};

/**
 * Pushes style-name or style-overrides-object onto the stack for future evaluation
 *
 * @param {String|Object} styleNameOrOverride style-name (referring to styleDictionary) or
 *                                            a new dictionary defining overriding properties
 */
StyleContextStack.prototype.push = function (styleNameOrOverride) {
	this.styleOverrides.push(styleNameOrOverride);
};

/**
 * Removes last style-name or style-overrides-object from the stack
 *
 * @param {Number} howMany - optional number of elements to be popped (if not specified,
 *                           one element will be removed from the stack)
 */
StyleContextStack.prototype.pop = function (howMany) {
	howMany = howMany || 1;

	while (howMany-- > 0) {
		this.styleOverrides.pop();
	}
};

/**
 * Creates a set of named styles or/and a style-overrides-object based on the item,
 * pushes those elements onto the stack for future evaluation and returns the number
 * of elements pushed, so they can be easily poped then.
 *
 * @param {Object} item - an object with optional style property and/or style overrides
 * @return the number of items pushed onto the stack
 */
StyleContextStack.prototype.autopush = function (item) {
	if (isString(item)) {
		return 0;
	}

	var styleNames = [];

	if (item.style) {
		if (isArray(item.style)) {
			styleNames = item.style;
		} else {
			styleNames = [item.style];
		}
	}

	for (var i = 0, l = styleNames.length; i < l; i++) {
		this.push(styleNames[i]);
	}

	var styleProperties = [
		'font',
		'fontSize',
		'fontFeatures',
		'bold',
		'italics',
		'alignment',
		'color',
		'columnGap',
		'fillColor',
		'decoration',
		'decorationStyle',
		'decorationColor',
		'background',
		'lineHeight',
		'characterSpacing',
		'noWrap',
		'markerColor',
		'leadingIndent'
			//'tableCellPadding'
			// 'cellBorder',
			// 'headerCellBorder',
			// 'oddRowCellBorder',
			// 'evenRowCellBorder',
			// 'tableBorder'
	];
	var styleOverrideObject = {};
	var pushStyleOverrideObject = false;

	styleProperties.forEach(function (key) {
		if (!isUndefined(item[key]) && !isNull(item[key])) {
			styleOverrideObject[key] = item[key];
			pushStyleOverrideObject = true;
		}
	});

	if (pushStyleOverrideObject) {
		this.push(styleOverrideObject);
	}

	return styleNames.length + (pushStyleOverrideObject ? 1 : 0);
};

/**
 * Automatically pushes elements onto the stack, using autopush based on item,
 * executes callback and then pops elements back. Returns value returned by callback
 *
 * @param  {Object}   item - an object with optional style property and/or style overrides
 * @param  {Function} function to be called between autopush and pop
 * @return {Object} value returned by callback
 */
StyleContextStack.prototype.auto = function (item, callback) {
	var pushedItems = this.autopush(item);
	var result = callback();

	if (pushedItems > 0) {
		this.pop(pushedItems);
	}

	return result;
};

/**
 * Evaluates stack and returns value of a named property
 *
 * @param {String} property - property name
 * @return property value or null if not found
 */
StyleContextStack.prototype.getProperty = function (property) {
	if (this.styleOverrides) {
		for (var i = this.styleOverrides.length - 1; i >= 0; i--) {
			var item = this.styleOverrides[i];

			if (isString(item)) {
				// named-style-override
				var style = this.styleDictionary[item];
				if (style && !isUndefined(style[property]) && !isNull(style[property])) {
					return style[property];
				}
			} else if (!isUndefined(item[property]) && !isNull(item[property])) {
				// style-overrides-object
				return item[property];
			}
		}
	}

	return this.defaultStyle && this.defaultStyle[property];
};

module.exports = StyleContextStack;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var TraversalTracker = __webpack_require__(77);
var isString = __webpack_require__(0).isString;

/**
 * Creates an instance of DocumentContext - a store for current x, y positions and available width/height.
 * It facilitates column divisions and vertical sync
 */
function DocumentContext(pageSize, pageMargins) {
	this.pages = [];

	this.pageMargins = pageMargins;

	this.x = pageMargins.left;
	this.availableWidth = pageSize.width - pageMargins.left - pageMargins.right;
	this.availableHeight = 0;
	this.page = -1;

	this.snapshots = [];

	this.endingCell = null;

	this.tracker = new TraversalTracker();

	this.addPage(pageSize);

	this.hasBackground = false;
}

DocumentContext.prototype.beginColumnGroup = function () {
	this.snapshots.push({
		x: this.x,
		y: this.y,
		availableHeight: this.availableHeight,
		availableWidth: this.availableWidth,
		page: this.page,
		bottomMost: {
			x: this.x,
			y: this.y,
			availableHeight: this.availableHeight,
			availableWidth: this.availableWidth,
			page: this.page
		},
		endingCell: this.endingCell,
		lastColumnWidth: this.lastColumnWidth
	});

	this.lastColumnWidth = 0;
};

DocumentContext.prototype.beginColumn = function (width, offset, endingCell) {
	var saved = this.snapshots[this.snapshots.length - 1];

	this.calculateBottomMost(saved);

	this.endingCell = endingCell;
	this.page = saved.page;
	this.x = this.x + this.lastColumnWidth + (offset || 0);
	this.y = saved.y;
	this.availableWidth = width;	//saved.availableWidth - offset;
	this.availableHeight = saved.availableHeight;

	this.lastColumnWidth = width;
};

DocumentContext.prototype.calculateBottomMost = function (destContext) {
	if (this.endingCell) {
		this.saveContextInEndingCell(this.endingCell);
		this.endingCell = null;
	} else {
		destContext.bottomMost = bottomMostContext(this, destContext.bottomMost);
	}
};

DocumentContext.prototype.markEnding = function (endingCell) {
	this.page = endingCell._columnEndingContext.page;
	this.x = endingCell._columnEndingContext.x;
	this.y = endingCell._columnEndingContext.y;
	this.availableWidth = endingCell._columnEndingContext.availableWidth;
	this.availableHeight = endingCell._columnEndingContext.availableHeight;
	this.lastColumnWidth = endingCell._columnEndingContext.lastColumnWidth;
};

DocumentContext.prototype.saveContextInEndingCell = function (endingCell) {
	endingCell._columnEndingContext = {
		page: this.page,
		x: this.x,
		y: this.y,
		availableHeight: this.availableHeight,
		availableWidth: this.availableWidth,
		lastColumnWidth: this.lastColumnWidth
	};
};

DocumentContext.prototype.completeColumnGroup = function (height) {
	var saved = this.snapshots.pop();

	this.calculateBottomMost(saved);

	this.endingCell = null;
	this.x = saved.x;

	var y = saved.bottomMost.y;
	if (height) {
		if (saved.page === saved.bottomMost.page) {
			if ((saved.y + height) > y) {
				y = saved.y + height;
			}
		} else {
			y += height;
		}
	}

	this.y = y;
	this.page = saved.bottomMost.page;
	this.availableWidth = saved.availableWidth;
	this.availableHeight = saved.bottomMost.availableHeight;
	if (height) {
		this.availableHeight -= (y - saved.bottomMost.y);
	}
	this.lastColumnWidth = saved.lastColumnWidth;
};

DocumentContext.prototype.addMargin = function (left, right) {
	this.x += left;
	this.availableWidth -= left + (right || 0);
};

DocumentContext.prototype.moveDown = function (offset) {
	this.y += offset;
	this.availableHeight -= offset;

	return this.availableHeight > 0;
};

DocumentContext.prototype.initializePage = function () {
	this.y = this.pageMargins.top;
	this.availableHeight = this.getCurrentPage().pageSize.height - this.pageMargins.top - this.pageMargins.bottom;
	this.pageSnapshot().availableWidth = this.getCurrentPage().pageSize.width - this.pageMargins.left - this.pageMargins.right;
};

DocumentContext.prototype.pageSnapshot = function () {
	if (this.snapshots[0]) {
		return this.snapshots[0];
	} else {
		return this;
	}
};

DocumentContext.prototype.moveTo = function (x, y) {
	if (x !== undefined && x !== null) {
		this.x = x;
		this.availableWidth = this.getCurrentPage().pageSize.width - this.x - this.pageMargins.right;
	}
	if (y !== undefined && y !== null) {
		this.y = y;
		this.availableHeight = this.getCurrentPage().pageSize.height - this.y - this.pageMargins.bottom;
	}
};

DocumentContext.prototype.beginDetachedBlock = function () {
	this.snapshots.push({
		x: this.x,
		y: this.y,
		availableHeight: this.availableHeight,
		availableWidth: this.availableWidth,
		page: this.page,
		endingCell: this.endingCell,
		lastColumnWidth: this.lastColumnWidth
	});
};

DocumentContext.prototype.endDetachedBlock = function () {
	var saved = this.snapshots.pop();

	this.x = saved.x;
	this.y = saved.y;
	this.availableWidth = saved.availableWidth;
	this.availableHeight = saved.availableHeight;
	this.page = saved.page;
	this.endingCell = saved.endingCell;
	this.lastColumnWidth = saved.lastColumnWidth;
};

function pageOrientation(pageOrientationString, currentPageOrientation) {
	if (pageOrientationString === undefined) {
		return currentPageOrientation;
	} else if (isString(pageOrientationString) && (pageOrientationString.toLowerCase() === 'landscape')) {
		return 'landscape';
	} else {
		return 'portrait';
	}
}

var getPageSize = function (currentPage, newPageOrientation) {

	newPageOrientation = pageOrientation(newPageOrientation, currentPage.pageSize.orientation);

	if (newPageOrientation !== currentPage.pageSize.orientation) {
		return {
			orientation: newPageOrientation,
			width: currentPage.pageSize.height,
			height: currentPage.pageSize.width
		};
	} else {
		return {
			orientation: currentPage.pageSize.orientation,
			width: currentPage.pageSize.width,
			height: currentPage.pageSize.height
		};
	}

};


DocumentContext.prototype.moveToNextPage = function (pageOrientation) {
	var nextPageIndex = this.page + 1;

	var prevPage = this.page;
	var prevY = this.y;

	var createNewPage = nextPageIndex >= this.pages.length;
	if (createNewPage) {
		var currentAvailableWidth = this.availableWidth;
		var currentPageOrientation = this.getCurrentPage().pageSize.orientation;

		var pageSize = getPageSize(this.getCurrentPage(), pageOrientation);
		this.addPage(pageSize);

		if (currentPageOrientation === pageSize.orientation) {
			this.availableWidth = currentAvailableWidth;
		}
	} else {
		this.page = nextPageIndex;
		this.initializePage();
	}

	return {
		newPageCreated: createNewPage,
		prevPage: prevPage,
		prevY: prevY,
		y: this.y
	};
};


DocumentContext.prototype.addPage = function (pageSize) {
	var page = {items: [], pageSize: pageSize};
	this.pages.push(page);
	this.page = this.pages.length - 1;
	this.initializePage();

	this.tracker.emit('pageAdded');

	return page;
};

DocumentContext.prototype.getCurrentPage = function () {
	if (this.page < 0 || this.page >= this.pages.length) {
		return null;
	}

	return this.pages[this.page];
};

DocumentContext.prototype.getCurrentPosition = function () {
	var pageSize = this.getCurrentPage().pageSize;
	var innerHeight = pageSize.height - this.pageMargins.top - this.pageMargins.bottom;
	var innerWidth = pageSize.width - this.pageMargins.left - this.pageMargins.right;

	return {
		pageNumber: this.page + 1,
		pageOrientation: pageSize.orientation,
		pageInnerHeight: innerHeight,
		pageInnerWidth: innerWidth,
		left: this.x,
		top: this.y,
		verticalRatio: ((this.y - this.pageMargins.top) / innerHeight),
		horizontalRatio: ((this.x - this.pageMargins.left) / innerWidth)
	};
};

function bottomMostContext(c1, c2) {
	var r;

	if (c1.page > c2.page) {
		r = c1;
	} else if (c2.page > c1.page) {
		r = c2;
	} else {
		r = (c1.y > c2.y) ? c1 : c2;
	}

	return {
		page: r.page,
		x: r.x,
		y: r.y,
		availableHeight: r.availableHeight,
		availableWidth: r.availableWidth
	};
}

module.exports = DocumentContext;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Creates an instance of Line
 *
 * @constructor
 * @this {Line}
 * @param {Number} Maximum width this line can have
 */
function Line(maxWidth) {
	this.maxWidth = maxWidth;
	this.leadingCut = 0;
	this.trailingCut = 0;
	this.inlineWidths = 0;
	this.inlines = [];
}

Line.prototype.getAscenderHeight = function () {
	var y = 0;

	this.inlines.forEach(function (inline) {
		y = Math.max(y, inline.font.ascender / 1000 * inline.fontSize);
	});
	return y;
};

Line.prototype.hasEnoughSpaceForInline = function (inline) {
	if (this.inlines.length === 0) {
		return true;
	}
	if (this.newLineForced) {
		return false;
	}

	return this.inlineWidths + inline.width - this.leadingCut - (inline.trailingCut || 0) <= this.maxWidth;
};

Line.prototype.addInline = function (inline) {
	if (this.inlines.length === 0) {
		this.leadingCut = inline.leadingCut || 0;
	}
	this.trailingCut = inline.trailingCut || 0;

	inline.x = this.inlineWidths - this.leadingCut;

	this.inlines.push(inline);
	this.inlineWidths += inline.width;

	if (inline.lineEnd) {
		this.newLineForced = true;
	}
};

Line.prototype.getWidth = function () {
	return this.inlineWidths - this.leadingCut - this.trailingCut;
};

/**
 * Returns line height
 * @return {Number}
 */
Line.prototype.getHeight = function () {
	var max = 0;

	this.inlines.forEach(function (item) {
		max = Math.max(max, item.height || 0);
	});

	return max;
};

module.exports = Line;


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/

var processNextTick = __webpack_require__(32).nextTick;
/*</replacement>*/

module.exports = Readable;

/*<replacement>*/
var isArray = __webpack_require__(76);
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Readable.ReadableState = ReadableState;

/*<replacement>*/
var EE = __webpack_require__(31).EventEmitter;

var EElistenerCount = function (emitter, type) {
  return emitter.listeners(type).length;
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(84);
/*</replacement>*/

/*<replacement>*/

var Buffer = __webpack_require__(33).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*</replacement>*/

/*<replacement>*/
var util = __webpack_require__(25);
util.inherits = __webpack_require__(21);
/*</replacement>*/

/*<replacement>*/
var debugUtil = __webpack_require__(139);
var debug = void 0;
if (debugUtil && debugUtil.debuglog) {
  debug = debugUtil.debuglog('stream');
} else {
  debug = function () {};
}
/*</replacement>*/

var BufferList = __webpack_require__(140);
var destroyImpl = __webpack_require__(85);
var StringDecoder;

util.inherits(Readable, Stream);

var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

function prependListener(emitter, event, fn) {
  // Sadly this is not cacheable as some libraries bundle their own
  // event emitter implementation with them.
  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

  // This is a hack to make sure that our error handler is attached before any
  // userland ones.  NEVER DO THIS. This is here only because this code needs
  // to continue to work with older versions of Node.js that do not include
  // the prependListener() method. The goal is to eventually remove this hack.
  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
}

function ReadableState(options, stream) {
  Duplex = Duplex || __webpack_require__(16);

  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  var isDuplex = stream instanceof Duplex;

  // object stream flag. Used to make read(n) ignore n and to
  // make all the buffer merging and length checks go away
  this.objectMode = !!options.objectMode;

  if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

  // the point at which it stops calling _read() to fill the buffer
  // Note: 0 is a valid value, means "don't call _read preemptively ever"
  var hwm = options.highWaterMark;
  var readableHwm = options.readableHighWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;

  if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;else this.highWaterMark = defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // A linked list is used to store data chunks instead of an array because the
  // linked list can remove elements from the beginning faster than
  // array.shift()
  this.buffer = new BufferList();
  this.length = 0;
  this.pipes = null;
  this.pipesCount = 0;
  this.flowing = null;
  this.ended = false;
  this.endEmitted = false;
  this.reading = false;

  // a flag to be able to tell if the event 'readable'/'data' is emitted
  // immediately, or on a later tick.  We set this to true at first, because
  // any actions that shouldn't happen until "later" should generally also
  // not happen before the first read call.
  this.sync = true;

  // whenever we return null, then we set a flag to say
  // that we're awaiting a 'readable' event emission.
  this.needReadable = false;
  this.emittedReadable = false;
  this.readableListening = false;
  this.resumeScheduled = false;

  // has it been destroyed
  this.destroyed = false;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // the number of writers that are awaiting a drain event in .pipe()s
  this.awaitDrain = 0;

  // if true, a maybeReadMore has been scheduled
  this.readingMore = false;

  this.decoder = null;
  this.encoding = null;
  if (options.encoding) {
    if (!StringDecoder) StringDecoder = __webpack_require__(47).StringDecoder;
    this.decoder = new StringDecoder(options.encoding);
    this.encoding = options.encoding;
  }
}

function Readable(options) {
  Duplex = Duplex || __webpack_require__(16);

  if (!(this instanceof Readable)) return new Readable(options);

  this._readableState = new ReadableState(options, this);

  // legacy
  this.readable = true;

  if (options) {
    if (typeof options.read === 'function') this._read = options.read;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;
  }

  Stream.call(this);
}

Object.defineProperty(Readable.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined) {
      return false;
    }
    return this._readableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._readableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
  }
});

Readable.prototype.destroy = destroyImpl.destroy;
Readable.prototype._undestroy = destroyImpl.undestroy;
Readable.prototype._destroy = function (err, cb) {
  this.push(null);
  cb(err);
};

// Manually shove something into the read() buffer.
// This returns true if the highWaterMark has not been hit yet,
// similar to how Writable.write() returns true if you should
// write() some more.
Readable.prototype.push = function (chunk, encoding) {
  var state = this._readableState;
  var skipChunkCheck;

  if (!state.objectMode) {
    if (typeof chunk === 'string') {
      encoding = encoding || state.defaultEncoding;
      if (encoding !== state.encoding) {
        chunk = Buffer.from(chunk, encoding);
        encoding = '';
      }
      skipChunkCheck = true;
    }
  } else {
    skipChunkCheck = true;
  }

  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
};

// Unshift should *always* be something directly out of read()
Readable.prototype.unshift = function (chunk) {
  return readableAddChunk(this, chunk, null, true, false);
};

function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
  var state = stream._readableState;
  if (chunk === null) {
    state.reading = false;
    onEofChunk(stream, state);
  } else {
    var er;
    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
    if (er) {
      stream.emit('error', er);
    } else if (state.objectMode || chunk && chunk.length > 0) {
      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
        chunk = _uint8ArrayToBuffer(chunk);
      }

      if (addToFront) {
        if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
      } else if (state.ended) {
        stream.emit('error', new Error('stream.push() after EOF'));
      } else {
        state.reading = false;
        if (state.decoder && !encoding) {
          chunk = state.decoder.write(chunk);
          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
        } else {
          addChunk(stream, state, chunk, false);
        }
      }
    } else if (!addToFront) {
      state.reading = false;
    }
  }

  return needMoreData(state);
}

function addChunk(stream, state, chunk, addToFront) {
  if (state.flowing && state.length === 0 && !state.sync) {
    stream.emit('data', chunk);
    stream.read(0);
  } else {
    // update the buffer info.
    state.length += state.objectMode ? 1 : chunk.length;
    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

    if (state.needReadable) emitReadable(stream);
  }
  maybeReadMore(stream, state);
}

function chunkInvalid(state, chunk) {
  var er;
  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  return er;
}

// if it's past the high water mark, we can push in some more.
// Also, if we have no data yet, we can stand some
// more bytes.  This is to work around cases where hwm=0,
// such as the repl.  Also, if the push() triggered a
// readable event, and the user called read(largeNumber) such that
// needReadable was set, then we ought to push more, so that another
// 'readable' event will be triggered.
function needMoreData(state) {
  return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
}

Readable.prototype.isPaused = function () {
  return this._readableState.flowing === false;
};

// backwards compatibility.
Readable.prototype.setEncoding = function (enc) {
  if (!StringDecoder) StringDecoder = __webpack_require__(47).StringDecoder;
  this._readableState.decoder = new StringDecoder(enc);
  this._readableState.encoding = enc;
  return this;
};

// Don't raise the hwm > 8MB
var MAX_HWM = 0x800000;
function computeNewHighWaterMark(n) {
  if (n >= MAX_HWM) {
    n = MAX_HWM;
  } else {
    // Get the next highest power of 2 to prevent increasing hwm excessively in
    // tiny amounts
    n--;
    n |= n >>> 1;
    n |= n >>> 2;
    n |= n >>> 4;
    n |= n >>> 8;
    n |= n >>> 16;
    n++;
  }
  return n;
}

// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function howMuchToRead(n, state) {
  if (n <= 0 || state.length === 0 && state.ended) return 0;
  if (state.objectMode) return 1;
  if (n !== n) {
    // Only flow one buffer at a time
    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
  }
  // If we're asking for more than the current hwm, then raise the hwm.
  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
  if (n <= state.length) return n;
  // Don't have enough
  if (!state.ended) {
    state.needReadable = true;
    return 0;
  }
  return state.length;
}

// you can override either this method, or the async _read(n) below.
Readable.prototype.read = function (n) {
  debug('read', n);
  n = parseInt(n, 10);
  var state = this._readableState;
  var nOrig = n;

  if (n !== 0) state.emittedReadable = false;

  // if we're doing read(0) to trigger a readable event, but we
  // already have a bunch of data in the buffer, then just trigger
  // the 'readable' event and move on.
  if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
    debug('read: emitReadable', state.length, state.ended);
    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
    return null;
  }

  n = howMuchToRead(n, state);

  // if we've ended, and we're now clear, then finish it up.
  if (n === 0 && state.ended) {
    if (state.length === 0) endReadable(this);
    return null;
  }

  // All the actual chunk generation logic needs to be
  // *below* the call to _read.  The reason is that in certain
  // synthetic stream cases, such as passthrough streams, _read
  // may be a completely synchronous operation which may change
  // the state of the read buffer, providing enough data when
  // before there was *not* enough.
  //
  // So, the steps are:
  // 1. Figure out what the state of things will be after we do
  // a read from the buffer.
  //
  // 2. If that resulting state will trigger a _read, then call _read.
  // Note that this may be asynchronous, or synchronous.  Yes, it is
  // deeply ugly to write APIs this way, but that still doesn't mean
  // that the Readable class should behave improperly, as streams are
  // designed to be sync/async agnostic.
  // Take note if the _read call is sync or async (ie, if the read call
  // has returned yet), so that we know whether or not it's safe to emit
  // 'readable' etc.
  //
  // 3. Actually pull the requested chunks out of the buffer and return.

  // if we need a readable event, then we need to do some reading.
  var doRead = state.needReadable;
  debug('need readable', doRead);

  // if we currently have less than the highWaterMark, then also read some
  if (state.length === 0 || state.length - n < state.highWaterMark) {
    doRead = true;
    debug('length less than watermark', doRead);
  }

  // however, if we've ended, then there's no point, and if we're already
  // reading, then it's unnecessary.
  if (state.ended || state.reading) {
    doRead = false;
    debug('reading or ended', doRead);
  } else if (doRead) {
    debug('do read');
    state.reading = true;
    state.sync = true;
    // if the length is currently zero, then we *need* a readable event.
    if (state.length === 0) state.needReadable = true;
    // call internal read method
    this._read(state.highWaterMark);
    state.sync = false;
    // If _read pushed data synchronously, then `reading` will be false,
    // and we need to re-evaluate how much data we can return to the user.
    if (!state.reading) n = howMuchToRead(nOrig, state);
  }

  var ret;
  if (n > 0) ret = fromList(n, state);else ret = null;

  if (ret === null) {
    state.needReadable = true;
    n = 0;
  } else {
    state.length -= n;
  }

  if (state.length === 0) {
    // If we have nothing in the buffer, then we want to know
    // as soon as we *do* get something into the buffer.
    if (!state.ended) state.needReadable = true;

    // If we tried to read() past the EOF, then emit end on the next tick.
    if (nOrig !== n && state.ended) endReadable(this);
  }

  if (ret !== null) this.emit('data', ret);

  return ret;
};

function onEofChunk(stream, state) {
  if (state.ended) return;
  if (state.decoder) {
    var chunk = state.decoder.end();
    if (chunk && chunk.length) {
      state.buffer.push(chunk);
      state.length += state.objectMode ? 1 : chunk.length;
    }
  }
  state.ended = true;

  // emit 'readable' now to make sure it gets picked up.
  emitReadable(stream);
}

// Don't emit readable right away in sync mode, because this can trigger
// another read() call => stack overflow.  This way, it might trigger
// a nextTick recursion warning, but that's not so bad.
function emitReadable(stream) {
  var state = stream._readableState;
  state.needReadable = false;
  if (!state.emittedReadable) {
    debug('emitReadable', state.flowing);
    state.emittedReadable = true;
    if (state.sync) processNextTick(emitReadable_, stream);else emitReadable_(stream);
  }
}

function emitReadable_(stream) {
  debug('emit readable');
  stream.emit('readable');
  flow(stream);
}

// at this point, the user has presumably seen the 'readable' event,
// and called read() to consume some data.  that may have triggered
// in turn another _read(n) call, in which case reading = true if
// it's in progress.
// However, if we're not ended, or reading, and the length < hwm,
// then go ahead and try to read some more preemptively.
function maybeReadMore(stream, state) {
  if (!state.readingMore) {
    state.readingMore = true;
    processNextTick(maybeReadMore_, stream, state);
  }
}

function maybeReadMore_(stream, state) {
  var len = state.length;
  while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
    debug('maybeReadMore read 0');
    stream.read(0);
    if (len === state.length)
      // didn't get any data, stop spinning.
      break;else len = state.length;
  }
  state.readingMore = false;
}

// abstract method.  to be overridden in specific implementation classes.
// call cb(er, data) where data is <= n in length.
// for virtual (non-string, non-buffer) streams, "length" is somewhat
// arbitrary, and perhaps not very meaningful.
Readable.prototype._read = function (n) {
  this.emit('error', new Error('_read() is not implemented'));
};

Readable.prototype.pipe = function (dest, pipeOpts) {
  var src = this;
  var state = this._readableState;

  switch (state.pipesCount) {
    case 0:
      state.pipes = dest;
      break;
    case 1:
      state.pipes = [state.pipes, dest];
      break;
    default:
      state.pipes.push(dest);
      break;
  }
  state.pipesCount += 1;
  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

  var endFn = doEnd ? onend : unpipe;
  if (state.endEmitted) processNextTick(endFn);else src.once('end', endFn);

  dest.on('unpipe', onunpipe);
  function onunpipe(readable, unpipeInfo) {
    debug('onunpipe');
    if (readable === src) {
      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
        unpipeInfo.hasUnpiped = true;
        cleanup();
      }
    }
  }

  function onend() {
    debug('onend');
    dest.end();
  }

  // when the dest drains, it reduces the awaitDrain counter
  // on the source.  This would be more elegant with a .once()
  // handler in flow(), but adding and removing repeatedly is
  // too slow.
  var ondrain = pipeOnDrain(src);
  dest.on('drain', ondrain);

  var cleanedUp = false;
  function cleanup() {
    debug('cleanup');
    // cleanup event handlers once the pipe is broken
    dest.removeListener('close', onclose);
    dest.removeListener('finish', onfinish);
    dest.removeListener('drain', ondrain);
    dest.removeListener('error', onerror);
    dest.removeListener('unpipe', onunpipe);
    src.removeListener('end', onend);
    src.removeListener('end', unpipe);
    src.removeListener('data', ondata);

    cleanedUp = true;

    // if the reader is waiting for a drain event from this
    // specific writer, then it would cause it to never start
    // flowing again.
    // So, if this is awaiting a drain, then we just call it now.
    // If we don't know, then assume that we are waiting for one.
    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
  }

  // If the user pushes more data while we're writing to dest then we'll end up
  // in ondata again. However, we only want to increase awaitDrain once because
  // dest will only emit one 'drain' event for the multiple writes.
  // => Introduce a guard on increasing awaitDrain.
  var increasedAwaitDrain = false;
  src.on('data', ondata);
  function ondata(chunk) {
    debug('ondata');
    increasedAwaitDrain = false;
    var ret = dest.write(chunk);
    if (false === ret && !increasedAwaitDrain) {
      // If the user unpiped during `dest.write()`, it is possible
      // to get stuck in a permanently paused state if that write
      // also returned false.
      // => Check whether `dest` is still a piping destination.
      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
        debug('false write response, pause', src._readableState.awaitDrain);
        src._readableState.awaitDrain++;
        increasedAwaitDrain = true;
      }
      src.pause();
    }
  }

  // if the dest has an error, then stop piping into it.
  // however, don't suppress the throwing behavior for this.
  function onerror(er) {
    debug('onerror', er);
    unpipe();
    dest.removeListener('error', onerror);
    if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
  }

  // Make sure our error handler is attached before userland ones.
  prependListener(dest, 'error', onerror);

  // Both close and finish should trigger unpipe, but only once.
  function onclose() {
    dest.removeListener('finish', onfinish);
    unpipe();
  }
  dest.once('close', onclose);
  function onfinish() {
    debug('onfinish');
    dest.removeListener('close', onclose);
    unpipe();
  }
  dest.once('finish', onfinish);

  function unpipe() {
    debug('unpipe');
    src.unpipe(dest);
  }

  // tell the dest that it's being piped to
  dest.emit('pipe', src);

  // start the flow if it hasn't been started already.
  if (!state.flowing) {
    debug('pipe resume');
    src.resume();
  }

  return dest;
};

function pipeOnDrain(src) {
  return function () {
    var state = src._readableState;
    debug('pipeOnDrain', state.awaitDrain);
    if (state.awaitDrain) state.awaitDrain--;
    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
      state.flowing = true;
      flow(src);
    }
  };
}

Readable.prototype.unpipe = function (dest) {
  var state = this._readableState;
  var unpipeInfo = { hasUnpiped: false };

  // if we're not piping anywhere, then do nothing.
  if (state.pipesCount === 0) return this;

  // just one destination.  most common case.
  if (state.pipesCount === 1) {
    // passed in one, but it's not the right one.
    if (dest && dest !== state.pipes) return this;

    if (!dest) dest = state.pipes;

    // got a match.
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    if (dest) dest.emit('unpipe', this, unpipeInfo);
    return this;
  }

  // slow case. multiple pipe destinations.

  if (!dest) {
    // remove all.
    var dests = state.pipes;
    var len = state.pipesCount;
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;

    for (var i = 0; i < len; i++) {
      dests[i].emit('unpipe', this, unpipeInfo);
    }return this;
  }

  // try to find the right one.
  var index = indexOf(state.pipes, dest);
  if (index === -1) return this;

  state.pipes.splice(index, 1);
  state.pipesCount -= 1;
  if (state.pipesCount === 1) state.pipes = state.pipes[0];

  dest.emit('unpipe', this, unpipeInfo);

  return this;
};

// set up data events if they are asked for
// Ensure readable listeners eventually get something
Readable.prototype.on = function (ev, fn) {
  var res = Stream.prototype.on.call(this, ev, fn);

  if (ev === 'data') {
    // Start flowing on next tick if stream isn't explicitly paused
    if (this._readableState.flowing !== false) this.resume();
  } else if (ev === 'readable') {
    var state = this._readableState;
    if (!state.endEmitted && !state.readableListening) {
      state.readableListening = state.needReadable = true;
      state.emittedReadable = false;
      if (!state.reading) {
        processNextTick(nReadingNextTick, this);
      } else if (state.length) {
        emitReadable(this);
      }
    }
  }

  return res;
};
Readable.prototype.addListener = Readable.prototype.on;

function nReadingNextTick(self) {
  debug('readable nexttick read 0');
  self.read(0);
}

// pause() and resume() are remnants of the legacy readable stream API
// If the user uses them, then switch into old mode.
Readable.prototype.resume = function () {
  var state = this._readableState;
  if (!state.flowing) {
    debug('resume');
    state.flowing = true;
    resume(this, state);
  }
  return this;
};

function resume(stream, state) {
  if (!state.resumeScheduled) {
    state.resumeScheduled = true;
    processNextTick(resume_, stream, state);
  }
}

function resume_(stream, state) {
  if (!state.reading) {
    debug('resume read 0');
    stream.read(0);
  }

  state.resumeScheduled = false;
  state.awaitDrain = 0;
  stream.emit('resume');
  flow(stream);
  if (state.flowing && !state.reading) stream.read(0);
}

Readable.prototype.pause = function () {
  debug('call pause flowing=%j', this._readableState.flowing);
  if (false !== this._readableState.flowing) {
    debug('pause');
    this._readableState.flowing = false;
    this.emit('pause');
  }
  return this;
};

function flow(stream) {
  var state = stream._readableState;
  debug('flow', state.flowing);
  while (state.flowing && stream.read() !== null) {}
}

// wrap an old-style stream as the async data source.
// This is *not* part of the readable stream interface.
// It is an ugly unfortunate mess of history.
Readable.prototype.wrap = function (stream) {
  var _this = this;

  var state = this._readableState;
  var paused = false;

  stream.on('end', function () {
    debug('wrapped end');
    if (state.decoder && !state.ended) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length) _this.push(chunk);
    }

    _this.push(null);
  });

  stream.on('data', function (chunk) {
    debug('wrapped data');
    if (state.decoder) chunk = state.decoder.write(chunk);

    // don't skip over falsy values in objectMode
    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

    var ret = _this.push(chunk);
    if (!ret) {
      paused = true;
      stream.pause();
    }
  });

  // proxy all the other methods.
  // important when wrapping filters and duplexes.
  for (var i in stream) {
    if (this[i] === undefined && typeof stream[i] === 'function') {
      this[i] = function (method) {
        return function () {
          return stream[method].apply(stream, arguments);
        };
      }(i);
    }
  }

  // proxy certain important events.
  for (var n = 0; n < kProxyEvents.length; n++) {
    stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
  }

  // when we try to consume some more bytes, simply unpause the
  // underlying stream.
  this._read = function (n) {
    debug('wrapped _read', n);
    if (paused) {
      paused = false;
      stream.resume();
    }
  };

  return this;
};

// exposed for testing purposes only.
Readable._fromList = fromList;

// Pluck off n bytes from an array of buffers.
// Length is the combined lengths of all the buffers in the list.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromList(n, state) {
  // nothing buffered
  if (state.length === 0) return null;

  var ret;
  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
    // read it all, truncate the list
    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
    state.buffer.clear();
  } else {
    // read part of list
    ret = fromListPartial(n, state.buffer, state.decoder);
  }

  return ret;
}

// Extracts only enough buffered data to satisfy the amount requested.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromListPartial(n, list, hasStrings) {
  var ret;
  if (n < list.head.data.length) {
    // slice is the same for buffers and strings
    ret = list.head.data.slice(0, n);
    list.head.data = list.head.data.slice(n);
  } else if (n === list.head.data.length) {
    // first chunk is a perfect match
    ret = list.shift();
  } else {
    // result spans more than one buffer
    ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
  }
  return ret;
}

// Copies a specified amount of characters from the list of buffered data
// chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBufferString(n, list) {
  var p = list.head;
  var c = 1;
  var ret = p.data;
  n -= ret.length;
  while (p = p.next) {
    var str = p.data;
    var nb = n > str.length ? str.length : n;
    if (nb === str.length) ret += str;else ret += str.slice(0, n);
    n -= nb;
    if (n === 0) {
      if (nb === str.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = str.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

// Copies a specified amount of bytes from the list of buffered data chunks.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function copyFromBuffer(n, list) {
  var ret = Buffer.allocUnsafe(n);
  var p = list.head;
  var c = 1;
  p.data.copy(ret);
  n -= p.data.length;
  while (p = p.next) {
    var buf = p.data;
    var nb = n > buf.length ? buf.length : n;
    buf.copy(ret, ret.length - n, 0, nb);
    n -= nb;
    if (n === 0) {
      if (nb === buf.length) {
        ++c;
        if (p.next) list.head = p.next;else list.head = list.tail = null;
      } else {
        list.head = p;
        p.data = buf.slice(nb);
      }
      break;
    }
    ++c;
  }
  list.length -= c;
  return ret;
}

function endReadable(stream) {
  var state = stream._readableState;

  // If we get here before consuming all the bytes, then that is a
  // bug in node.  Should never happen.
  if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

  if (!state.endEmitted) {
    state.ended = true;
    processNextTick(endReadableNT, state, stream);
  }
}

function endReadableNT(state, stream) {
  // Check that we didn't get one last unshift.
  if (!state.endEmitted && state.length === 0) {
    state.endEmitted = true;
    stream.readable = false;
    stream.emit('end');
  }
}

function forEach(xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

function indexOf(xs, x) {
  for (var i = 0, l = xs.length; i < l; i++) {
    if (xs[i] === x) return i;
  }
  return -1;
}
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7), __webpack_require__(11)))

/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(31).EventEmitter;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*<replacement>*/

var processNextTick = __webpack_require__(32).nextTick;
/*</replacement>*/

// undocumented cb() API, needed for core, not for public API
function destroy(err, cb) {
  var _this = this;

  var readableDestroyed = this._readableState && this._readableState.destroyed;
  var writableDestroyed = this._writableState && this._writableState.destroyed;

  if (readableDestroyed || writableDestroyed) {
    if (cb) {
      cb(err);
    } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
      processNextTick(emitErrorNT, this, err);
    }
    return this;
  }

  // we set destroyed to true before firing error callbacks in order
  // to make it re-entrance safe in case destroy() is called within callbacks

  if (this._readableState) {
    this._readableState.destroyed = true;
  }

  // if this is a duplex stream mark the writable part as destroyed as well
  if (this._writableState) {
    this._writableState.destroyed = true;
  }

  this._destroy(err || null, function (err) {
    if (!cb && err) {
      processNextTick(emitErrorNT, _this, err);
      if (_this._writableState) {
        _this._writableState.errorEmitted = true;
      }
    } else if (cb) {
      cb(err);
    }
  });

  return this;
}

function undestroy() {
  if (this._readableState) {
    this._readableState.destroyed = false;
    this._readableState.reading = false;
    this._readableState.ended = false;
    this._readableState.endEmitted = false;
  }

  if (this._writableState) {
    this._writableState.destroyed = false;
    this._writableState.ended = false;
    this._writableState.ending = false;
    this._writableState.finished = false;
    this._writableState.errorEmitted = false;
  }
}

function emitErrorNT(self, err) {
  self.emit('error', err);
}

module.exports = {
  destroy: destroy,
  undestroy: undestroy
};

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.



module.exports = Transform;

var Duplex = __webpack_require__(16);

/*<replacement>*/
var util = __webpack_require__(25);
util.inherits = __webpack_require__(21);
/*</replacement>*/

util.inherits(Transform, Duplex);

function afterTransform(er, data) {
  var ts = this._transformState;
  ts.transforming = false;

  var cb = ts.writecb;

  if (!cb) {
    return this.emit('error', new Error('write callback called multiple times'));
  }

  ts.writechunk = null;
  ts.writecb = null;

  if (data != null) // single equals check for both `null` and `undefined`
    this.push(data);

  cb(er);

  var rs = this._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    this._read(rs.highWaterMark);
  }
}

function Transform(options) {
  if (!(this instanceof Transform)) return new Transform(options);

  Duplex.call(this, options);

  this._transformState = {
    afterTransform: afterTransform.bind(this),
    needTransform: false,
    transforming: false,
    writecb: null,
    writechunk: null,
    writeencoding: null
  };

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;

  if (options) {
    if (typeof options.transform === 'function') this._transform = options.transform;

    if (typeof options.flush === 'function') this._flush = options.flush;
  }

  // When the writable side finishes, then flush out anything remaining.
  this.on('prefinish', prefinish);
}

function prefinish() {
  var _this = this;

  if (typeof this._flush === 'function') {
    this._flush(function (er, data) {
      done(_this, er, data);
    });
  } else {
    done(this, null, null);
  }
}

Transform.prototype.push = function (chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function (chunk, encoding, cb) {
  throw new Error('_transform() is not implemented');
};

Transform.prototype._write = function (chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function (n) {
  var ts = this._transformState;

  if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};

Transform.prototype._destroy = function (err, cb) {
  var _this2 = this;

  Duplex.prototype._destroy.call(this, err, function (err2) {
    cb(err2);
    _this2.emit('close');
  });
};

function done(stream, er, data) {
  if (er) return stream.emit('error', er);

  if (data != null) // single equals check for both `null` and `undefined`
    stream.push(data);

  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  if (stream._writableState.length) throw new Error('Calling transform done when ws.length != 0');

  if (stream._transformState.transforming) throw new Error('Calling transform done when still transforming');

  return stream.push(null);
}

/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

/*
PDFReference - represents a reference to another object in the PDF object heirarchy
By Devon Govett
 */

(function() {
  var PDFObject, PDFReference, stream, zlib,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  zlib = __webpack_require__(48);

  stream = __webpack_require__(15);

  PDFReference = (function(superClass) {
    extend(PDFReference, superClass);

    function PDFReference(document, id, data) {
      this.document = document;
      this.id = id;
      this.data = data != null ? data : {};
      this.finalize = bind(this.finalize, this);
      PDFReference.__super__.constructor.call(this, {
        decodeStrings: false
      });
      this.gen = 0;
      this.deflate = null;
      this.compress = this.document.compress && !this.data.Filter;
      this.uncompressedLength = 0;
      this.chunks = [];
    }

    PDFReference.prototype.initDeflate = function() {
      this.data.Filter = 'FlateDecode';
      this.deflate = zlib.createDeflate();
      this.deflate.on('data', (function(_this) {
        return function(chunk) {
          _this.chunks.push(chunk);
          return _this.data.Length += chunk.length;
        };
      })(this));
      return this.deflate.on('end', this.finalize);
    };

    PDFReference.prototype._write = function(chunk, encoding, callback) {
      var base;
      if (!Buffer.isBuffer(chunk)) {
        chunk = new Buffer(chunk + '\n', 'binary');
      }
      this.uncompressedLength += chunk.length;
      if ((base = this.data).Length == null) {
        base.Length = 0;
      }
      if (this.compress) {
        if (!this.deflate) {
          this.initDeflate();
        }
        this.deflate.write(chunk);
      } else {
        this.chunks.push(chunk);
        this.data.Length += chunk.length;
      }
      return callback();
    };

    PDFReference.prototype.end = function(chunk) {
      PDFReference.__super__.end.apply(this, arguments);
      if (this.deflate) {
        return this.deflate.end();
      } else {
        return this.finalize();
      }
    };

    PDFReference.prototype.finalize = function() {
      var chunk, i, len, ref;
      this.offset = this.document._offset;
      this.document._write(this.id + " " + this.gen + " obj");
      this.document._write(PDFObject.convert(this.data));
      if (this.chunks.length) {
        this.document._write('stream');
        ref = this.chunks;
        for (i = 0, len = ref.length; i < len; i++) {
          chunk = ref[i];
          this.document._write(chunk);
        }
        this.chunks.length = 0;
        this.document._write('\nendstream');
      }
      this.document._write('endobj');
      return this.document._refEnd(this);
    };

    PDFReference.prototype.toString = function() {
      return this.id + " " + this.gen + " R";
    };

    return PDFReference;

  })(stream.Writable);

  module.exports = PDFReference;

  PDFObject = __webpack_require__(26);

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
function compare(a, b) {
  if (a === b) {
    return 0;
  }

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }

  if (x < y) {
    return -1;
  }
  if (y < x) {
    return 1;
  }
  return 0;
}
function isBuffer(b) {
  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
    return global.Buffer.isBuffer(b);
  }
  return !!(b != null && b._isBuffer);
}

// based on node assert, original notice:

// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
//
// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
//
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

var util = __webpack_require__(49);
var hasOwn = Object.prototype.hasOwnProperty;
var pSlice = Array.prototype.slice;
var functionsHaveNames = (function () {
  return function foo() {}.name === 'foo';
}());
function pToString (obj) {
  return Object.prototype.toString.call(obj);
}
function isView(arrbuf) {
  if (isBuffer(arrbuf)) {
    return false;
  }
  if (typeof global.ArrayBuffer !== 'function') {
    return false;
  }
  if (typeof ArrayBuffer.isView === 'function') {
    return ArrayBuffer.isView(arrbuf);
  }
  if (!arrbuf) {
    return false;
  }
  if (arrbuf instanceof DataView) {
    return true;
  }
  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
    return true;
  }
  return false;
}
// 1. The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;

// 2. The AssertionError is defined in assert.
// new assert.AssertionError({ message: message,
//                             actual: actual,
//                             expected: expected })

var regex = /\s*function\s+([^\(\s]*)\s*/;
// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
function getName(func) {
  if (!util.isFunction(func)) {
    return;
  }
  if (functionsHaveNames) {
    return func.name;
  }
  var str = func.toString();
  var match = str.match(regex);
  return match && match[1];
}
assert.AssertionError = function AssertionError(options) {
  this.name = 'AssertionError';
  this.actual = options.actual;
  this.expected = options.expected;
  this.operator = options.operator;
  if (options.message) {
    this.message = options.message;
    this.generatedMessage = false;
  } else {
    this.message = getMessage(this);
    this.generatedMessage = true;
  }
  var stackStartFunction = options.stackStartFunction || fail;
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, stackStartFunction);
  } else {
    // non v8 browsers so we can have a stacktrace
    var err = new Error();
    if (err.stack) {
      var out = err.stack;

      // try to strip useless frames
      var fn_name = getName(stackStartFunction);
      var idx = out.indexOf('\n' + fn_name);
      if (idx >= 0) {
        // once we have located the function frame
        // we need to strip out everything before it (and its line)
        var next_line = out.indexOf('\n', idx + 1);
        out = out.substring(next_line + 1);
      }

      this.stack = out;
    }
  }
};

// assert.AssertionError instanceof Error
util.inherits(assert.AssertionError, Error);

function truncate(s, n) {
  if (typeof s === 'string') {
    return s.length < n ? s : s.slice(0, n);
  } else {
    return s;
  }
}
function inspect(something) {
  if (functionsHaveNames || !util.isFunction(something)) {
    return util.inspect(something);
  }
  var rawname = getName(something);
  var name = rawname ? ': ' + rawname : '';
  return '[Function' +  name + ']';
}
function getMessage(self) {
  return truncate(inspect(self.actual), 128) + ' ' +
         self.operator + ' ' +
         truncate(inspect(self.expected), 128);
}

// At present only the three keys mentioned above are used and
// understood by the spec. Implementations or sub modules can pass
// other keys to the AssertionError's constructor - they will be
// ignored.

// 3. All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided.  All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function fail(actual, expected, message, operator, stackStartFunction) {
  throw new assert.AssertionError({
    message: message,
    actual: actual,
    expected: expected,
    operator: operator,
    stackStartFunction: stackStartFunction
  });
}

// EXTENSION! allows for well behaved errors defined elsewhere.
assert.fail = fail;

// 4. Pure assertion tests whether a value is truthy, as determined
// by !!guard.
// assert.ok(guard, message_opt);
// This statement is equivalent to assert.equal(true, !!guard,
// message_opt);. To test strictly for the value true, use
// assert.strictEqual(true, guard, message_opt);.

function ok(value, message) {
  if (!value) fail(value, true, message, '==', assert.ok);
}
assert.ok = ok;

// 5. The equality assertion tests shallow, coercive equality with
// ==.
// assert.equal(actual, expected, message_opt);

assert.equal = function equal(actual, expected, message) {
  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
};

// 6. The non-equality assertion tests for whether two objects are not equal
// with != assert.notEqual(actual, expected, message_opt);

assert.notEqual = function notEqual(actual, expected, message) {
  if (actual == expected) {
    fail(actual, expected, message, '!=', assert.notEqual);
  }
};

// 7. The equivalence assertion tests a deep equality relation.
// assert.deepEqual(actual, expected, message_opt);

assert.deepEqual = function deepEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
  }
};

assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
  }
};

function _deepEqual(actual, expected, strict, memos) {
  // 7.1. All identical values are equivalent, as determined by ===.
  if (actual === expected) {
    return true;
  } else if (isBuffer(actual) && isBuffer(expected)) {
    return compare(actual, expected) === 0;

  // 7.2. If the expected value is a Date object, the actual value is
  // equivalent if it is also a Date object that refers to the same time.
  } else if (util.isDate(actual) && util.isDate(expected)) {
    return actual.getTime() === expected.getTime();

  // 7.3 If the expected value is a RegExp object, the actual value is
  // equivalent if it is also a RegExp object with the same source and
  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
    return actual.source === expected.source &&
           actual.global === expected.global &&
           actual.multiline === expected.multiline &&
           actual.lastIndex === expected.lastIndex &&
           actual.ignoreCase === expected.ignoreCase;

  // 7.4. Other pairs that do not both pass typeof value == 'object',
  // equivalence is determined by ==.
  } else if ((actual === null || typeof actual !== 'object') &&
             (expected === null || typeof expected !== 'object')) {
    return strict ? actual === expected : actual == expected;

  // If both values are instances of typed arrays, wrap their underlying
  // ArrayBuffers in a Buffer each to increase performance
  // This optimization requires the arrays to have the same type as checked by
  // Object.prototype.toString (aka pToString). Never perform binary
  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
  // bit patterns are not identical.
  } else if (isView(actual) && isView(expected) &&
             pToString(actual) === pToString(expected) &&
             !(actual instanceof Float32Array ||
               actual instanceof Float64Array)) {
    return compare(new Uint8Array(actual.buffer),
                   new Uint8Array(expected.buffer)) === 0;

  // 7.5 For all other Object pairs, including Array objects, equivalence is
  // determined by having the same number of owned properties (as verified
  // with Object.prototype.hasOwnProperty.call), the same set of keys
  // (although not necessarily the same order), equivalent values for every
  // corresponding key, and an identical 'prototype' property. Note: this
  // accounts for both named and indexed properties on Arrays.
  } else if (isBuffer(actual) !== isBuffer(expected)) {
    return false;
  } else {
    memos = memos || {actual: [], expected: []};

    var actualIndex = memos.actual.indexOf(actual);
    if (actualIndex !== -1) {
      if (actualIndex === memos.expected.indexOf(expected)) {
        return true;
      }
    }

    memos.actual.push(actual);
    memos.expected.push(expected);

    return objEquiv(actual, expected, strict, memos);
  }
}

function isArguments(object) {
  return Object.prototype.toString.call(object) == '[object Arguments]';
}

function objEquiv(a, b, strict, actualVisitedObjects) {
  if (a === null || a === undefined || b === null || b === undefined)
    return false;
  // if one is a primitive, the other must be same
  if (util.isPrimitive(a) || util.isPrimitive(b))
    return a === b;
  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
    return false;
  var aIsArgs = isArguments(a);
  var bIsArgs = isArguments(b);
  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
    return false;
  if (aIsArgs) {
    a = pSlice.call(a);
    b = pSlice.call(b);
    return _deepEqual(a, b, strict);
  }
  var ka = objectKeys(a);
  var kb = objectKeys(b);
  var key, i;
  // having the same number of owned properties (keys incorporates
  // hasOwnProperty)
  if (ka.length !== kb.length)
    return false;
  //the same set of keys (although not necessarily the same order),
  ka.sort();
  kb.sort();
  //~~~cheap key test
  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] !== kb[i])
      return false;
  }
  //equivalent values for every corresponding key, and
  //~~~possibly expensive deep test
  for (i = ka.length - 1; i >= 0; i--) {
    key = ka[i];
    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
      return false;
  }
  return true;
}

// 8. The non-equivalence assertion tests for any deep inequality.
// assert.notDeepEqual(actual, expected, message_opt);

assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
  }
};

assert.notDeepStrictEqual = notDeepStrictEqual;
function notDeepStrictEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
  }
}


// 9. The strict equality assertion tests strict equality, as determined by ===.
// assert.strictEqual(actual, expected, message_opt);

assert.strictEqual = function strictEqual(actual, expected, message) {
  if (actual !== expected) {
    fail(actual, expected, message, '===', assert.strictEqual);
  }
};

// 10. The strict non-equality assertion tests for strict inequality, as
// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (actual === expected) {
    fail(actual, expected, message, '!==', assert.notStrictEqual);
  }
};

function expectedException(actual, expected) {
  if (!actual || !expected) {
    return false;
  }

  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
    return expected.test(actual);
  }

  try {
    if (actual instanceof expected) {
      return true;
    }
  } catch (e) {
    // Ignore.  The instanceof check doesn't work for arrow functions.
  }

  if (Error.isPrototypeOf(expected)) {
    return false;
  }

  return expected.call({}, actual) === true;
}

function _tryBlock(block) {
  var error;
  try {
    block();
  } catch (e) {
    error = e;
  }
  return error;
}

function _throws(shouldThrow, block, expected, message) {
  var actual;

  if (typeof block !== 'function') {
    throw new TypeError('"block" argument must be a function');
  }

  if (typeof expected === 'string') {
    message = expected;
    expected = null;
  }

  actual = _tryBlock(block);

  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
            (message ? ' ' + message : '.');

  if (shouldThrow && !actual) {
    fail(actual, expected, 'Missing expected exception' + message);
  }

  var userProvidedMessage = typeof message === 'string';
  var isUnwantedException = !shouldThrow && util.isError(actual);
  var isUnexpectedException = !shouldThrow && actual && !expected;

  if ((isUnwantedException &&
      userProvidedMessage &&
      expectedException(actual, expected)) ||
      isUnexpectedException) {
    fail(actual, expected, 'Got unwanted exception' + message);
  }

  if ((shouldThrow && actual && expected &&
      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
    throw actual;
  }
}

// 11. Expected to throw an error:
// assert.throws(block, Error_opt, message_opt);

assert.throws = function(block, /*optional*/error, /*optional*/message) {
  _throws(true, block, error, message);
};

// EXTENSION! This is annoying to write outside this module.
assert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {
  _throws(false, block, error, message);
};

assert.ifError = function(err) { if (err) throw err; };

var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    if (hasOwn.call(obj, key)) keys.push(key);
  }
  return keys;
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7)))

/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Note: adler32 takes 12% for level 0 and 2% for level 6.
// It isn't worth it to make additional optimizations as in original.
// Small size is preferable.

// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

function adler32(adler, buf, len, pos) {
  var s1 = (adler & 0xffff) |0,
      s2 = ((adler >>> 16) & 0xffff) |0,
      n = 0;

  while (len !== 0) {
    // Set limit ~ twice less than 5552, to keep
    // s2 in 31-bits, because we force signed ints.
    // in other case %= will fail.
    n = len > 2000 ? 2000 : len;
    len -= n;

    do {
      s1 = (s1 + buf[pos++]) |0;
      s2 = (s2 + s1) |0;
    } while (--n);

    s1 %= 65521;
    s2 %= 65521;
  }

  return (s1 | (s2 << 16)) |0;
}


module.exports = adler32;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Note: we can't get significant speed boost here.
// So write code to minimize size - no pregenerated tables
// and array tools dependencies.

// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

// Use ordinary array, since untyped makes no boost here
function makeTable() {
  var c, table = [];

  for (var n = 0; n < 256; n++) {
    c = n;
    for (var k = 0; k < 8; k++) {
      c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
    }
    table[n] = c;
  }

  return table;
}

// Create table on load. Just 255 signed longs. Not a problem.
var crcTable = makeTable();


function crc32(crc, buf, len, pos) {
  var t = crcTable,
      end = pos + len;

  crc ^= -1;

  for (var i = pos; i < end; i++) {
    crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
  }

  return (crc ^ (-1)); // >>> 0;
}


module.exports = crc32;


/***/ }),
/* 91 */
/***/ (function(module, exports) {

module.exports = [["a140","",62],["a180","",32],["a240","",62],["a280","",32],["a2ab","",5],["a2e3","€"],["a2ef",""],["a2fd",""],["a340","",62],["a380","",31,"　"],["a440","",62],["a480","",32],["a4f4","",10],["a540","",62],["a580","",32],["a5f7","",7],["a640","",62],["a680","",32],["a6b9","",7],["a6d9","",6],["a6ec",""],["a6f3",""],["a6f6","",8],["a740","",62],["a780","",32],["a7c2","",14],["a7f2","",12],["a896","",10],["a8bc",""],["a8bf","ǹ"],["a8c1",""],["a8ea","",20],["a958",""],["a95b",""],["a95d",""],["a989","〾⿰",11],["a997","",12],["a9f0","",14],["aaa1","",93],["aba1","",93],["aca1","",93],["ada1","",93],["aea1","",93],["afa1","",93],["d7fa","",4],["f8a1","",93],["f9a1","",93],["faa1","",93],["fba1","",93],["fca1","",93],["fda1","",93],["fe50","⺁⺄㑳㑇⺈⺋㖞㘚㘎⺌⺗㥮㤘㧏㧟㩳㧐㭎㱮㳠⺧⺪䁖䅟⺮䌷⺳⺶⺷䎱䎬⺻䏝䓖䙡䙌"],["fe80","䜣䜩䝼䞍⻊䥇䥺䥽䦂䦃䦅䦆䦟䦛䦷䦶䲣䲟䲠䲡䱷䲢䴓",6,"䶮",93]]

/***/ }),
/* 92 */
/***/ (function(module, exports) {

module.exports = [["0","\u0000",127],["a140","　，、。．‧；：？！︰…‥﹐﹑﹒·﹔﹕﹖﹗｜–︱—︳╴︴﹏（）︵︶｛｝︷︸〔〕︹︺【】︻︼《》︽︾〈〉︿﹀「」﹁﹂『』﹃﹄﹙﹚"],["a1a1","﹛﹜﹝﹞‘’“”〝〞‵′＃＆＊※§〃○●△▲◎☆★◇◆□■▽▼㊣℅¯￣＿ˍ﹉﹊﹍﹎﹋﹌﹟﹠﹡＋－×÷±√＜＞＝≦≧≠∞≒≡﹢",4,"～∩∪⊥∠∟⊿㏒㏑∫∮∵∴♀♂⊕⊙↑↓←→↖↗↙↘∥∣／"],["a240","＼∕﹨＄￥〒￠￡％＠℃℉﹩﹪﹫㏕㎜㎝㎞㏎㎡㎎㎏㏄°兙兛兞兝兡兣嗧瓩糎▁",7,"▏▎▍▌▋▊▉┼┴┬┤├▔─│▕┌┐└┘╭"],["a2a1","╮╰╯═╞╪╡◢◣◥◤╱╲╳０",9,"Ⅰ",9,"〡",8,"十卄卅Ａ",25,"ａ",21],["a340","ｗｘｙｚΑ",16,"Σ",6,"α",16,"σ",6,"ㄅ",10],["a3a1","ㄐ",25,"˙ˉˊˇˋ"],["a3e1","€"],["a440","一乙丁七乃九了二人儿入八几刀刁力匕十卜又三下丈上丫丸凡久么也乞于亡兀刃勺千叉口土士夕大女子孑孓寸小尢尸山川工己已巳巾干廾弋弓才"],["a4a1","丑丐不中丰丹之尹予云井互五亢仁什仃仆仇仍今介仄元允內六兮公冗凶分切刈勻勾勿化匹午升卅卞厄友及反壬天夫太夭孔少尤尺屯巴幻廿弔引心戈戶手扎支文斗斤方日曰月木欠止歹毋比毛氏水火爪父爻片牙牛犬王丙"],["a540","世丕且丘主乍乏乎以付仔仕他仗代令仙仞充兄冉冊冬凹出凸刊加功包匆北匝仟半卉卡占卯卮去可古右召叮叩叨叼司叵叫另只史叱台句叭叻四囚外"],["a5a1","央失奴奶孕它尼巨巧左市布平幼弁弘弗必戊打扔扒扑斥旦朮本未末札正母民氐永汁汀氾犯玄玉瓜瓦甘生用甩田由甲申疋白皮皿目矛矢石示禾穴立丞丟乒乓乩亙交亦亥仿伉伙伊伕伍伐休伏仲件任仰仳份企伋光兇兆先全"],["a640","共再冰列刑划刎刖劣匈匡匠印危吉吏同吊吐吁吋各向名合吃后吆吒因回囝圳地在圭圬圯圩夙多夷夸妄奸妃好她如妁字存宇守宅安寺尖屹州帆并年"],["a6a1","式弛忙忖戎戌戍成扣扛托收早旨旬旭曲曳有朽朴朱朵次此死氖汝汗汙江池汐汕污汛汍汎灰牟牝百竹米糸缶羊羽老考而耒耳聿肉肋肌臣自至臼舌舛舟艮色艾虫血行衣西阡串亨位住佇佗佞伴佛何估佐佑伽伺伸佃佔似但佣"],["a740","作你伯低伶余佝佈佚兌克免兵冶冷別判利刪刨劫助努劬匣即卵吝吭吞吾否呎吧呆呃吳呈呂君吩告吹吻吸吮吵吶吠吼呀吱含吟听囪困囤囫坊坑址坍"],["a7a1","均坎圾坐坏圻壯夾妝妒妨妞妣妙妖妍妤妓妊妥孝孜孚孛完宋宏尬局屁尿尾岐岑岔岌巫希序庇床廷弄弟彤形彷役忘忌志忍忱快忸忪戒我抄抗抖技扶抉扭把扼找批扳抒扯折扮投抓抑抆改攻攸旱更束李杏材村杜杖杞杉杆杠"],["a840","杓杗步每求汞沙沁沈沉沅沛汪決沐汰沌汨沖沒汽沃汲汾汴沆汶沍沔沘沂灶灼災灸牢牡牠狄狂玖甬甫男甸皂盯矣私秀禿究系罕肖肓肝肘肛肚育良芒"],["a8a1","芋芍見角言谷豆豕貝赤走足身車辛辰迂迆迅迄巡邑邢邪邦那酉釆里防阮阱阪阬並乖乳事些亞享京佯依侍佳使佬供例來侃佰併侈佩佻侖佾侏侑佺兔兒兕兩具其典冽函刻券刷刺到刮制剁劾劻卒協卓卑卦卷卸卹取叔受味呵"],["a940","咖呸咕咀呻呷咄咒咆呼咐呱呶和咚呢周咋命咎固垃坷坪坩坡坦坤坼夜奉奇奈奄奔妾妻委妹妮姑姆姐姍始姓姊妯妳姒姅孟孤季宗定官宜宙宛尚屈居"],["a9a1","屆岷岡岸岩岫岱岳帘帚帖帕帛帑幸庚店府底庖延弦弧弩往征彿彼忝忠忽念忿怏怔怯怵怖怪怕怡性怩怫怛或戕房戾所承拉拌拄抿拂抹拒招披拓拔拋拈抨抽押拐拙拇拍抵拚抱拘拖拗拆抬拎放斧於旺昔易昌昆昂明昀昏昕昊"],["aa40","昇服朋杭枋枕東果杳杷枇枝林杯杰板枉松析杵枚枓杼杪杲欣武歧歿氓氛泣注泳沱泌泥河沽沾沼波沫法泓沸泄油況沮泗泅泱沿治泡泛泊沬泯泜泖泠"],["aaa1","炕炎炒炊炙爬爭爸版牧物狀狎狙狗狐玩玨玟玫玥甽疝疙疚的盂盲直知矽社祀祁秉秈空穹竺糾罔羌羋者肺肥肢肱股肫肩肴肪肯臥臾舍芳芝芙芭芽芟芹花芬芥芯芸芣芰芾芷虎虱初表軋迎返近邵邸邱邶采金長門阜陀阿阻附"],["ab40","陂隹雨青非亟亭亮信侵侯便俠俑俏保促侶俘俟俊俗侮俐俄係俚俎俞侷兗冒冑冠剎剃削前剌剋則勇勉勃勁匍南卻厚叛咬哀咨哎哉咸咦咳哇哂咽咪品"],["aba1","哄哈咯咫咱咻咩咧咿囿垂型垠垣垢城垮垓奕契奏奎奐姜姘姿姣姨娃姥姪姚姦威姻孩宣宦室客宥封屎屏屍屋峙峒巷帝帥帟幽庠度建弈弭彥很待徊律徇後徉怒思怠急怎怨恍恰恨恢恆恃恬恫恪恤扁拜挖按拼拭持拮拽指拱拷"],["ac40","拯括拾拴挑挂政故斫施既春昭映昧是星昨昱昤曷柿染柱柔某柬架枯柵柩柯柄柑枴柚查枸柏柞柳枰柙柢柝柒歪殃殆段毒毗氟泉洋洲洪流津洌洱洞洗"],["aca1","活洽派洶洛泵洹洧洸洩洮洵洎洫炫為炳炬炯炭炸炮炤爰牲牯牴狩狠狡玷珊玻玲珍珀玳甚甭畏界畎畋疫疤疥疢疣癸皆皇皈盈盆盃盅省盹相眉看盾盼眇矜砂研砌砍祆祉祈祇禹禺科秒秋穿突竿竽籽紂紅紀紉紇約紆缸美羿耄"],["ad40","耐耍耑耶胖胥胚胃胄背胡胛胎胞胤胝致舢苧范茅苣苛苦茄若茂茉苒苗英茁苜苔苑苞苓苟苯茆虐虹虻虺衍衫要觔計訂訃貞負赴赳趴軍軌述迦迢迪迥"],["ada1","迭迫迤迨郊郎郁郃酋酊重閂限陋陌降面革韋韭音頁風飛食首香乘亳倌倍倣俯倦倥俸倩倖倆值借倚倒們俺倀倔倨俱倡個候倘俳修倭倪俾倫倉兼冤冥冢凍凌准凋剖剜剔剛剝匪卿原厝叟哨唐唁唷哼哥哲唆哺唔哩哭員唉哮哪"],["ae40","哦唧唇哽唏圃圄埂埔埋埃堉夏套奘奚娑娘娜娟娛娓姬娠娣娩娥娌娉孫屘宰害家宴宮宵容宸射屑展屐峭峽峻峪峨峰島崁峴差席師庫庭座弱徒徑徐恙"],["aea1","恣恥恐恕恭恩息悄悟悚悍悔悌悅悖扇拳挈拿捎挾振捕捂捆捏捉挺捐挽挪挫挨捍捌效敉料旁旅時晉晏晃晒晌晅晁書朔朕朗校核案框桓根桂桔栩梳栗桌桑栽柴桐桀格桃株桅栓栘桁殊殉殷氣氧氨氦氤泰浪涕消涇浦浸海浙涓"],["af40","浬涉浮浚浴浩涌涊浹涅浥涔烊烘烤烙烈烏爹特狼狹狽狸狷玆班琉珮珠珪珞畔畝畜畚留疾病症疲疳疽疼疹痂疸皋皰益盍盎眩真眠眨矩砰砧砸砝破砷"],["afa1","砥砭砠砟砲祕祐祠祟祖神祝祗祚秤秣秧租秦秩秘窄窈站笆笑粉紡紗紋紊素索純紐紕級紜納紙紛缺罟羔翅翁耆耘耕耙耗耽耿胱脂胰脅胭胴脆胸胳脈能脊胼胯臭臬舀舐航舫舨般芻茫荒荔荊茸荐草茵茴荏茲茹茶茗荀茱茨荃"],["b040","虔蚊蚪蚓蚤蚩蚌蚣蚜衰衷袁袂衽衹記訐討訌訕訊託訓訖訏訑豈豺豹財貢起躬軒軔軏辱送逆迷退迺迴逃追逅迸邕郡郝郢酒配酌釘針釗釜釙閃院陣陡"],["b0a1","陛陝除陘陞隻飢馬骨高鬥鬲鬼乾偺偽停假偃偌做偉健偶偎偕偵側偷偏倏偯偭兜冕凰剪副勒務勘動匐匏匙匿區匾參曼商啪啦啄啞啡啃啊唱啖問啕唯啤唸售啜唬啣唳啁啗圈國圉域堅堊堆埠埤基堂堵執培夠奢娶婁婉婦婪婀"],["b140","娼婢婚婆婊孰寇寅寄寂宿密尉專將屠屜屝崇崆崎崛崖崢崑崩崔崙崤崧崗巢常帶帳帷康庸庶庵庾張強彗彬彩彫得徙從徘御徠徜恿患悉悠您惋悴惦悽"],["b1a1","情悻悵惜悼惘惕惆惟悸惚惇戚戛扈掠控捲掖探接捷捧掘措捱掩掉掃掛捫推掄授掙採掬排掏掀捻捩捨捺敝敖救教敗啟敏敘敕敔斜斛斬族旋旌旎晝晚晤晨晦晞曹勗望梁梯梢梓梵桿桶梱梧梗械梃棄梭梆梅梔條梨梟梡梂欲殺"],["b240","毫毬氫涎涼淳淙液淡淌淤添淺清淇淋涯淑涮淞淹涸混淵淅淒渚涵淚淫淘淪深淮淨淆淄涪淬涿淦烹焉焊烽烯爽牽犁猜猛猖猓猙率琅琊球理現琍瓠瓶"],["b2a1","瓷甜產略畦畢異疏痔痕疵痊痍皎盔盒盛眷眾眼眶眸眺硫硃硎祥票祭移窒窕笠笨笛第符笙笞笮粒粗粕絆絃統紮紹紼絀細紳組累終紲紱缽羞羚翌翎習耜聊聆脯脖脣脫脩脰脤舂舵舷舶船莎莞莘荸莢莖莽莫莒莊莓莉莠荷荻荼"],["b340","莆莧處彪蛇蛀蚶蛄蚵蛆蛋蚱蚯蛉術袞袈被袒袖袍袋覓規訪訝訣訥許設訟訛訢豉豚販責貫貨貪貧赧赦趾趺軛軟這逍通逗連速逝逐逕逞造透逢逖逛途"],["b3a1","部郭都酗野釵釦釣釧釭釩閉陪陵陳陸陰陴陶陷陬雀雪雩章竟頂頃魚鳥鹵鹿麥麻傢傍傅備傑傀傖傘傚最凱割剴創剩勞勝勛博厥啻喀喧啼喊喝喘喂喜喪喔喇喋喃喳單喟唾喲喚喻喬喱啾喉喫喙圍堯堪場堤堰報堡堝堠壹壺奠"],["b440","婷媚婿媒媛媧孳孱寒富寓寐尊尋就嵌嵐崴嵇巽幅帽幀幃幾廊廁廂廄弼彭復循徨惑惡悲悶惠愜愣惺愕惰惻惴慨惱愎惶愉愀愒戟扉掣掌描揀揩揉揆揍"],["b4a1","插揣提握揖揭揮捶援揪換摒揚揹敞敦敢散斑斐斯普晰晴晶景暑智晾晷曾替期朝棺棕棠棘棗椅棟棵森棧棹棒棲棣棋棍植椒椎棉棚楮棻款欺欽殘殖殼毯氮氯氬港游湔渡渲湧湊渠渥渣減湛湘渤湖湮渭渦湯渴湍渺測湃渝渾滋"],["b540","溉渙湎湣湄湲湩湟焙焚焦焰無然煮焜牌犄犀猶猥猴猩琺琪琳琢琥琵琶琴琯琛琦琨甥甦畫番痢痛痣痙痘痞痠登發皖皓皴盜睏短硝硬硯稍稈程稅稀窘"],["b5a1","窗窖童竣等策筆筐筒答筍筋筏筑粟粥絞結絨絕紫絮絲絡給絢絰絳善翔翕耋聒肅腕腔腋腑腎脹腆脾腌腓腴舒舜菩萃菸萍菠菅萋菁華菱菴著萊菰萌菌菽菲菊萸萎萄菜萇菔菟虛蛟蛙蛭蛔蛛蛤蛐蛞街裁裂袱覃視註詠評詞証詁"],["b640","詔詛詐詆訴診訶詖象貂貯貼貳貽賁費賀貴買貶貿貸越超趁跎距跋跚跑跌跛跆軻軸軼辜逮逵週逸進逶鄂郵鄉郾酣酥量鈔鈕鈣鈉鈞鈍鈐鈇鈑閔閏開閑"],["b6a1","間閒閎隊階隋陽隅隆隍陲隄雁雅雄集雇雯雲韌項順須飧飪飯飩飲飭馮馭黃黍黑亂傭債傲傳僅傾催傷傻傯僇剿剷剽募勦勤勢勣匯嗟嗨嗓嗦嗎嗜嗇嗑嗣嗤嗯嗚嗡嗅嗆嗥嗉園圓塞塑塘塗塚塔填塌塭塊塢塒塋奧嫁嫉嫌媾媽媼"],["b740","媳嫂媲嵩嵯幌幹廉廈弒彙徬微愚意慈感想愛惹愁愈慎慌慄慍愾愴愧愍愆愷戡戢搓搾搞搪搭搽搬搏搜搔損搶搖搗搆敬斟新暗暉暇暈暖暄暘暍會榔業"],["b7a1","楚楷楠楔極椰概楊楨楫楞楓楹榆楝楣楛歇歲毀殿毓毽溢溯滓溶滂源溝滇滅溥溘溼溺溫滑準溜滄滔溪溧溴煎煙煩煤煉照煜煬煦煌煥煞煆煨煖爺牒猷獅猿猾瑯瑚瑕瑟瑞瑁琿瑙瑛瑜當畸瘀痰瘁痲痱痺痿痴痳盞盟睛睫睦睞督"],["b840","睹睪睬睜睥睨睢矮碎碰碗碘碌碉硼碑碓硿祺祿禁萬禽稜稚稠稔稟稞窟窠筷節筠筮筧粱粳粵經絹綑綁綏絛置罩罪署義羨群聖聘肆肄腱腰腸腥腮腳腫"],["b8a1","腹腺腦舅艇蒂葷落萱葵葦葫葉葬葛萼萵葡董葩葭葆虞虜號蛹蜓蜈蜇蜀蛾蛻蜂蜃蜆蜊衙裟裔裙補裘裝裡裊裕裒覜解詫該詳試詩詰誇詼詣誠話誅詭詢詮詬詹詻訾詨豢貊貉賊資賈賄貲賃賂賅跡跟跨路跳跺跪跤跦躲較載軾輊"],["b940","辟農運遊道遂達逼違遐遇遏過遍遑逾遁鄒鄗酬酪酩釉鈷鉗鈸鈽鉀鈾鉛鉋鉤鉑鈴鉉鉍鉅鈹鈿鉚閘隘隔隕雍雋雉雊雷電雹零靖靴靶預頑頓頊頒頌飼飴"],["b9a1","飽飾馳馱馴髡鳩麂鼎鼓鼠僧僮僥僖僭僚僕像僑僱僎僩兢凳劃劂匱厭嗾嘀嘛嘗嗽嘔嘆嘉嘍嘎嗷嘖嘟嘈嘐嗶團圖塵塾境墓墊塹墅塽壽夥夢夤奪奩嫡嫦嫩嫗嫖嫘嫣孵寞寧寡寥實寨寢寤察對屢嶄嶇幛幣幕幗幔廓廖弊彆彰徹慇"],["ba40","愿態慷慢慣慟慚慘慵截撇摘摔撤摸摟摺摑摧搴摭摻敲斡旗旖暢暨暝榜榨榕槁榮槓構榛榷榻榫榴槐槍榭槌榦槃榣歉歌氳漳演滾漓滴漩漾漠漬漏漂漢"],["baa1","滿滯漆漱漸漲漣漕漫漯澈漪滬漁滲滌滷熔熙煽熊熄熒爾犒犖獄獐瑤瑣瑪瑰瑭甄疑瘧瘍瘋瘉瘓盡監瞄睽睿睡磁碟碧碳碩碣禎福禍種稱窪窩竭端管箕箋筵算箝箔箏箸箇箄粹粽精綻綰綜綽綾綠緊綴網綱綺綢綿綵綸維緒緇綬"],["bb40","罰翠翡翟聞聚肇腐膀膏膈膊腿膂臧臺與舔舞艋蓉蒿蓆蓄蒙蒞蒲蒜蓋蒸蓀蓓蒐蒼蓑蓊蜿蜜蜻蜢蜥蜴蜘蝕蜷蜩裳褂裴裹裸製裨褚裯誦誌語誣認誡誓誤"],["bba1","說誥誨誘誑誚誧豪貍貌賓賑賒赫趙趕跼輔輒輕輓辣遠遘遜遣遙遞遢遝遛鄙鄘鄞酵酸酷酴鉸銀銅銘銖鉻銓銜銨鉼銑閡閨閩閣閥閤隙障際雌雒需靼鞅韶頗領颯颱餃餅餌餉駁骯骰髦魁魂鳴鳶鳳麼鼻齊億儀僻僵價儂儈儉儅凜"],["bc40","劇劈劉劍劊勰厲嘮嘻嘹嘲嘿嘴嘩噓噎噗噴嘶嘯嘰墀墟增墳墜墮墩墦奭嬉嫻嬋嫵嬌嬈寮寬審寫層履嶝嶔幢幟幡廢廚廟廝廣廠彈影德徵慶慧慮慝慕憂"],["bca1","慼慰慫慾憧憐憫憎憬憚憤憔憮戮摩摯摹撞撲撈撐撰撥撓撕撩撒撮播撫撚撬撙撢撳敵敷數暮暫暴暱樣樟槨樁樞標槽模樓樊槳樂樅槭樑歐歎殤毅毆漿潼澄潑潦潔澆潭潛潸潮澎潺潰潤澗潘滕潯潠潟熟熬熱熨牖犛獎獗瑩璋璃"],["bd40","瑾璀畿瘠瘩瘟瘤瘦瘡瘢皚皺盤瞎瞇瞌瞑瞋磋磅確磊碾磕碼磐稿稼穀稽稷稻窯窮箭箱範箴篆篇篁箠篌糊締練緯緻緘緬緝編緣線緞緩綞緙緲緹罵罷羯"],["bda1","翩耦膛膜膝膠膚膘蔗蔽蔚蓮蔬蔭蔓蔑蔣蔡蔔蓬蔥蓿蔆螂蝴蝶蝠蝦蝸蝨蝙蝗蝌蝓衛衝褐複褒褓褕褊誼諒談諄誕請諸課諉諂調誰論諍誶誹諛豌豎豬賠賞賦賤賬賭賢賣賜質賡赭趟趣踫踐踝踢踏踩踟踡踞躺輝輛輟輩輦輪輜輞"],["be40","輥適遮遨遭遷鄰鄭鄧鄱醇醉醋醃鋅銻銷鋪銬鋤鋁銳銼鋒鋇鋰銲閭閱霄霆震霉靠鞍鞋鞏頡頫頜颳養餓餒餘駝駐駟駛駑駕駒駙骷髮髯鬧魅魄魷魯鴆鴉"],["bea1","鴃麩麾黎墨齒儒儘儔儐儕冀冪凝劑劓勳噙噫噹噩噤噸噪器噥噱噯噬噢噶壁墾壇壅奮嬝嬴學寰導彊憲憑憩憊懍憶憾懊懈戰擅擁擋撻撼據擄擇擂操撿擒擔撾整曆曉暹曄曇暸樽樸樺橙橫橘樹橄橢橡橋橇樵機橈歙歷氅濂澱澡"],["bf40","濃澤濁澧澳激澹澶澦澠澴熾燉燐燒燈燕熹燎燙燜燃燄獨璜璣璘璟璞瓢甌甍瘴瘸瘺盧盥瞠瞞瞟瞥磨磚磬磧禦積穎穆穌穋窺篙簑築篤篛篡篩篦糕糖縊"],["bfa1","縑縈縛縣縞縝縉縐罹羲翰翱翮耨膳膩膨臻興艘艙蕊蕙蕈蕨蕩蕃蕉蕭蕪蕞螃螟螞螢融衡褪褲褥褫褡親覦諦諺諫諱謀諜諧諮諾謁謂諷諭諳諶諼豫豭貓賴蹄踱踴蹂踹踵輻輯輸輳辨辦遵遴選遲遼遺鄴醒錠錶鋸錳錯錢鋼錫錄錚"],["c040","錐錦錡錕錮錙閻隧隨險雕霎霑霖霍霓霏靛靜靦鞘頰頸頻頷頭頹頤餐館餞餛餡餚駭駢駱骸骼髻髭鬨鮑鴕鴣鴦鴨鴒鴛默黔龍龜優償儡儲勵嚎嚀嚐嚅嚇"],["c0a1","嚏壕壓壑壎嬰嬪嬤孺尷屨嶼嶺嶽嶸幫彌徽應懂懇懦懋戲戴擎擊擘擠擰擦擬擱擢擭斂斃曙曖檀檔檄檢檜櫛檣橾檗檐檠歜殮毚氈濘濱濟濠濛濤濫濯澀濬濡濩濕濮濰燧營燮燦燥燭燬燴燠爵牆獰獲璩環璦璨癆療癌盪瞳瞪瞰瞬"],["c140","瞧瞭矯磷磺磴磯礁禧禪穗窿簇簍篾篷簌篠糠糜糞糢糟糙糝縮績繆縷縲繃縫總縱繅繁縴縹繈縵縿縯罄翳翼聱聲聰聯聳臆臃膺臂臀膿膽臉膾臨舉艱薪"],["c1a1","薄蕾薜薑薔薯薛薇薨薊虧蟀蟑螳蟒蟆螫螻螺蟈蟋褻褶襄褸褽覬謎謗謙講謊謠謝謄謐豁谿豳賺賽購賸賻趨蹉蹋蹈蹊轄輾轂轅輿避遽還邁邂邀鄹醣醞醜鍍鎂錨鍵鍊鍥鍋錘鍾鍬鍛鍰鍚鍔闊闋闌闈闆隱隸雖霜霞鞠韓顆颶餵騁"],["c240","駿鮮鮫鮪鮭鴻鴿麋黏點黜黝黛鼾齋叢嚕嚮壙壘嬸彝懣戳擴擲擾攆擺擻擷斷曜朦檳檬櫃檻檸櫂檮檯歟歸殯瀉瀋濾瀆濺瀑瀏燻燼燾燸獷獵璧璿甕癖癘"],["c2a1","癒瞽瞿瞻瞼礎禮穡穢穠竄竅簫簧簪簞簣簡糧織繕繞繚繡繒繙罈翹翻職聶臍臏舊藏薩藍藐藉薰薺薹薦蟯蟬蟲蟠覆覲觴謨謹謬謫豐贅蹙蹣蹦蹤蹟蹕軀轉轍邇邃邈醫醬釐鎔鎊鎖鎢鎳鎮鎬鎰鎘鎚鎗闔闖闐闕離雜雙雛雞霤鞣鞦"],["c340","鞭韹額顏題顎顓颺餾餿餽餮馥騎髁鬃鬆魏魎魍鯊鯉鯽鯈鯀鵑鵝鵠黠鼕鼬儳嚥壞壟壢寵龐廬懲懷懶懵攀攏曠曝櫥櫝櫚櫓瀛瀟瀨瀚瀝瀕瀘爆爍牘犢獸"],["c3a1","獺璽瓊瓣疇疆癟癡矇礙禱穫穩簾簿簸簽簷籀繫繭繹繩繪羅繳羶羹羸臘藩藝藪藕藤藥藷蟻蠅蠍蟹蟾襠襟襖襞譁譜識證譚譎譏譆譙贈贊蹼蹲躇蹶蹬蹺蹴轔轎辭邊邋醱醮鏡鏑鏟鏃鏈鏜鏝鏖鏢鏍鏘鏤鏗鏨關隴難霪霧靡韜韻類"],["c440","願顛颼饅饉騖騙鬍鯨鯧鯖鯛鶉鵡鵲鵪鵬麒麗麓麴勸嚨嚷嚶嚴嚼壤孀孃孽寶巉懸懺攘攔攙曦朧櫬瀾瀰瀲爐獻瓏癢癥礦礪礬礫竇競籌籃籍糯糰辮繽繼"],["c4a1","纂罌耀臚艦藻藹蘑藺蘆蘋蘇蘊蠔蠕襤覺觸議譬警譯譟譫贏贍躉躁躅躂醴釋鐘鐃鏽闡霰飄饒饑馨騫騰騷騵鰓鰍鹹麵黨鼯齟齣齡儷儸囁囀囂夔屬巍懼懾攝攜斕曩櫻欄櫺殲灌爛犧瓖瓔癩矓籐纏續羼蘗蘭蘚蠣蠢蠡蠟襪襬覽譴"],["c540","護譽贓躊躍躋轟辯醺鐮鐳鐵鐺鐸鐲鐫闢霸霹露響顧顥饗驅驃驀騾髏魔魑鰭鰥鶯鶴鷂鶸麝黯鼙齜齦齧儼儻囈囊囉孿巔巒彎懿攤權歡灑灘玀瓤疊癮癬"],["c5a1","禳籠籟聾聽臟襲襯觼讀贖贗躑躓轡酈鑄鑑鑒霽霾韃韁顫饕驕驍髒鬚鱉鰱鰾鰻鷓鷗鼴齬齪龔囌巖戀攣攫攪曬欐瓚竊籤籣籥纓纖纔臢蘸蘿蠱變邐邏鑣鑠鑤靨顯饜驚驛驗髓體髑鱔鱗鱖鷥麟黴囑壩攬灞癱癲矗罐羈蠶蠹衢讓讒"],["c640","讖艷贛釀鑪靂靈靄韆顰驟鬢魘鱟鷹鷺鹼鹽鼇齷齲廳欖灣籬籮蠻觀躡釁鑲鑰顱饞髖鬣黌灤矚讚鑷韉驢驥纜讜躪釅鑽鑾鑼鱷鱸黷豔鑿鸚爨驪鬱鸛鸞籲"],["c940","乂乜凵匚厂万丌乇亍囗兀屮彳丏冇与丮亓仂仉仈冘勼卬厹圠夃夬尐巿旡殳毌气爿丱丼仨仜仩仡仝仚刌匜卌圢圣夗夯宁宄尒尻屴屳帄庀庂忉戉扐氕"],["c9a1","氶汃氿氻犮犰玊禸肊阞伎优伬仵伔仱伀价伈伝伂伅伢伓伄仴伒冱刓刉刐劦匢匟卍厊吇囡囟圮圪圴夼妀奼妅奻奾奷奿孖尕尥屼屺屻屾巟幵庄异弚彴忕忔忏扜扞扤扡扦扢扙扠扚扥旯旮朾朹朸朻机朿朼朳氘汆汒汜汏汊汔汋"],["ca40","汌灱牞犴犵玎甪癿穵网艸艼芀艽艿虍襾邙邗邘邛邔阢阤阠阣佖伻佢佉体佤伾佧佒佟佁佘伭伳伿佡冏冹刜刞刡劭劮匉卣卲厎厏吰吷吪呔呅吙吜吥吘"],["caa1","吽呏呁吨吤呇囮囧囥坁坅坌坉坋坒夆奀妦妘妠妗妎妢妐妏妧妡宎宒尨尪岍岏岈岋岉岒岊岆岓岕巠帊帎庋庉庌庈庍弅弝彸彶忒忑忐忭忨忮忳忡忤忣忺忯忷忻怀忴戺抃抌抎抏抔抇扱扻扺扰抁抈扷扽扲扴攷旰旴旳旲旵杅杇"],["cb40","杙杕杌杈杝杍杚杋毐氙氚汸汧汫沄沋沏汱汯汩沚汭沇沕沜汦汳汥汻沎灴灺牣犿犽狃狆狁犺狅玕玗玓玔玒町甹疔疕皁礽耴肕肙肐肒肜芐芏芅芎芑芓"],["cba1","芊芃芄豸迉辿邟邡邥邞邧邠阰阨阯阭丳侘佼侅佽侀侇佶佴侉侄佷佌侗佪侚佹侁佸侐侜侔侞侒侂侕佫佮冞冼冾刵刲刳剆刱劼匊匋匼厒厔咇呿咁咑咂咈呫呺呾呥呬呴呦咍呯呡呠咘呣呧呤囷囹坯坲坭坫坱坰坶垀坵坻坳坴坢"],["cc40","坨坽夌奅妵妺姏姎妲姌姁妶妼姃姖妱妽姀姈妴姇孢孥宓宕屄屇岮岤岠岵岯岨岬岟岣岭岢岪岧岝岥岶岰岦帗帔帙弨弢弣弤彔徂彾彽忞忥怭怦怙怲怋"],["cca1","怴怊怗怳怚怞怬怢怍怐怮怓怑怌怉怜戔戽抭抴拑抾抪抶拊抮抳抯抻抩抰抸攽斨斻昉旼昄昒昈旻昃昋昍昅旽昑昐曶朊枅杬枎枒杶杻枘枆构杴枍枌杺枟枑枙枃杽极杸杹枔欥殀歾毞氝沓泬泫泮泙沶泔沭泧沷泐泂沺泃泆泭泲"],["cd40","泒泝沴沊沝沀泞泀洰泍泇沰泹泏泩泑炔炘炅炓炆炄炑炖炂炚炃牪狖狋狘狉狜狒狔狚狌狑玤玡玭玦玢玠玬玝瓝瓨甿畀甾疌疘皯盳盱盰盵矸矼矹矻矺"],["cda1","矷祂礿秅穸穻竻籵糽耵肏肮肣肸肵肭舠芠苀芫芚芘芛芵芧芮芼芞芺芴芨芡芩苂芤苃芶芢虰虯虭虮豖迒迋迓迍迖迕迗邲邴邯邳邰阹阽阼阺陃俍俅俓侲俉俋俁俔俜俙侻侳俛俇俖侺俀侹俬剄剉勀勂匽卼厗厖厙厘咺咡咭咥哏"],["ce40","哃茍咷咮哖咶哅哆咠呰咼咢咾呲哞咰垵垞垟垤垌垗垝垛垔垘垏垙垥垚垕壴复奓姡姞姮娀姱姝姺姽姼姶姤姲姷姛姩姳姵姠姾姴姭宨屌峐峘峌峗峋峛"],["cea1","峞峚峉峇峊峖峓峔峏峈峆峎峟峸巹帡帢帣帠帤庰庤庢庛庣庥弇弮彖徆怷怹恔恲恞恅恓恇恉恛恌恀恂恟怤恄恘恦恮扂扃拏挍挋拵挎挃拫拹挏挌拸拶挀挓挔拺挕拻拰敁敃斪斿昶昡昲昵昜昦昢昳昫昺昝昴昹昮朏朐柁柲柈枺"],["cf40","柜枻柸柘柀枷柅柫柤柟枵柍枳柷柶柮柣柂枹柎柧柰枲柼柆柭柌枮柦柛柺柉柊柃柪柋欨殂殄殶毖毘毠氠氡洨洴洭洟洼洿洒洊泚洳洄洙洺洚洑洀洝浂"],["cfa1","洁洘洷洃洏浀洇洠洬洈洢洉洐炷炟炾炱炰炡炴炵炩牁牉牊牬牰牳牮狊狤狨狫狟狪狦狣玅珌珂珈珅玹玶玵玴珫玿珇玾珃珆玸珋瓬瓮甮畇畈疧疪癹盄眈眃眄眅眊盷盻盺矧矨砆砑砒砅砐砏砎砉砃砓祊祌祋祅祄秕种秏秖秎窀"],["d040","穾竑笀笁籺籸籹籿粀粁紃紈紁罘羑羍羾耇耎耏耔耷胘胇胠胑胈胂胐胅胣胙胜胊胕胉胏胗胦胍臿舡芔苙苾苹茇苨茀苕茺苫苖苴苬苡苲苵茌苻苶苰苪"],["d0a1","苤苠苺苳苭虷虴虼虳衁衎衧衪衩觓訄訇赲迣迡迮迠郱邽邿郕郅邾郇郋郈釔釓陔陏陑陓陊陎倞倅倇倓倢倰倛俵俴倳倷倬俶俷倗倜倠倧倵倯倱倎党冔冓凊凄凅凈凎剡剚剒剞剟剕剢勍匎厞唦哢唗唒哧哳哤唚哿唄唈哫唑唅哱"],["d140","唊哻哷哸哠唎唃唋圁圂埌堲埕埒垺埆垽垼垸垶垿埇埐垹埁夎奊娙娖娭娮娕娏娗娊娞娳孬宧宭宬尃屖屔峬峿峮峱峷崀峹帩帨庨庮庪庬弳弰彧恝恚恧"],["d1a1","恁悢悈悀悒悁悝悃悕悛悗悇悜悎戙扆拲挐捖挬捄捅挶捃揤挹捋捊挼挩捁挴捘捔捙挭捇挳捚捑挸捗捀捈敊敆旆旃旄旂晊晟晇晑朒朓栟栚桉栲栳栻桋桏栖栱栜栵栫栭栯桎桄栴栝栒栔栦栨栮桍栺栥栠欬欯欭欱欴歭肂殈毦毤"],["d240","毨毣毢毧氥浺浣浤浶洍浡涒浘浢浭浯涑涍淯浿涆浞浧浠涗浰浼浟涂涘洯浨涋浾涀涄洖涃浻浽浵涐烜烓烑烝烋缹烢烗烒烞烠烔烍烅烆烇烚烎烡牂牸"],["d2a1","牷牶猀狺狴狾狶狳狻猁珓珙珥珖玼珧珣珩珜珒珛珔珝珚珗珘珨瓞瓟瓴瓵甡畛畟疰痁疻痄痀疿疶疺皊盉眝眛眐眓眒眣眑眕眙眚眢眧砣砬砢砵砯砨砮砫砡砩砳砪砱祔祛祏祜祓祒祑秫秬秠秮秭秪秜秞秝窆窉窅窋窌窊窇竘笐"],["d340","笄笓笅笏笈笊笎笉笒粄粑粊粌粈粍粅紞紝紑紎紘紖紓紟紒紏紌罜罡罞罠罝罛羖羒翃翂翀耖耾耹胺胲胹胵脁胻脀舁舯舥茳茭荄茙荑茥荖茿荁茦茜茢"],["d3a1","荂荎茛茪茈茼荍茖茤茠茷茯茩荇荅荌荓茞茬荋茧荈虓虒蚢蚨蚖蚍蚑蚞蚇蚗蚆蚋蚚蚅蚥蚙蚡蚧蚕蚘蚎蚝蚐蚔衃衄衭衵衶衲袀衱衿衯袃衾衴衼訒豇豗豻貤貣赶赸趵趷趶軑軓迾迵适迿迻逄迼迶郖郠郙郚郣郟郥郘郛郗郜郤酐"],["d440","酎酏釕釢釚陜陟隼飣髟鬯乿偰偪偡偞偠偓偋偝偲偈偍偁偛偊偢倕偅偟偩偫偣偤偆偀偮偳偗偑凐剫剭剬剮勖勓匭厜啵啶唼啍啐唴唪啑啢唶唵唰啒啅"],["d4a1","唌唲啥啎唹啈唭唻啀啋圊圇埻堔埢埶埜埴堀埭埽堈埸堋埳埏堇埮埣埲埥埬埡堎埼堐埧堁堌埱埩埰堍堄奜婠婘婕婧婞娸娵婭婐婟婥婬婓婤婗婃婝婒婄婛婈媎娾婍娹婌婰婩婇婑婖婂婜孲孮寁寀屙崞崋崝崚崠崌崨崍崦崥崏"],["d540","崰崒崣崟崮帾帴庱庴庹庲庳弶弸徛徖徟悊悐悆悾悰悺惓惔惏惤惙惝惈悱惛悷惊悿惃惍惀挲捥掊掂捽掽掞掭掝掗掫掎捯掇掐据掯捵掜捭掮捼掤挻掟"],["d5a1","捸掅掁掑掍捰敓旍晥晡晛晙晜晢朘桹梇梐梜桭桮梮梫楖桯梣梬梩桵桴梲梏桷梒桼桫桲梪梀桱桾梛梖梋梠梉梤桸桻梑梌梊桽欶欳欷欸殑殏殍殎殌氪淀涫涴涳湴涬淩淢涷淶淔渀淈淠淟淖涾淥淜淝淛淴淊涽淭淰涺淕淂淏淉"],["d640","淐淲淓淽淗淍淣涻烺焍烷焗烴焌烰焄烳焐烼烿焆焓焀烸烶焋焂焎牾牻牼牿猝猗猇猑猘猊猈狿猏猞玈珶珸珵琄琁珽琇琀珺珼珿琌琋珴琈畤畣痎痒痏"],["d6a1","痋痌痑痐皏皉盓眹眯眭眱眲眴眳眽眥眻眵硈硒硉硍硊硌砦硅硐祤祧祩祪祣祫祡离秺秸秶秷窏窔窐笵筇笴笥笰笢笤笳笘笪笝笱笫笭笯笲笸笚笣粔粘粖粣紵紽紸紶紺絅紬紩絁絇紾紿絊紻紨罣羕羜羝羛翊翋翍翐翑翇翏翉耟"],["d740","耞耛聇聃聈脘脥脙脛脭脟脬脞脡脕脧脝脢舑舸舳舺舴舲艴莐莣莨莍荺荳莤荴莏莁莕莙荵莔莩荽莃莌莝莛莪莋荾莥莯莈莗莰荿莦莇莮荶莚虙虖蚿蚷"],["d7a1","蛂蛁蛅蚺蚰蛈蚹蚳蚸蛌蚴蚻蚼蛃蚽蚾衒袉袕袨袢袪袚袑袡袟袘袧袙袛袗袤袬袌袓袎覂觖觙觕訰訧訬訞谹谻豜豝豽貥赽赻赹趼跂趹趿跁軘軞軝軜軗軠軡逤逋逑逜逌逡郯郪郰郴郲郳郔郫郬郩酖酘酚酓酕釬釴釱釳釸釤釹釪"],["d840","釫釷釨釮镺閆閈陼陭陫陱陯隿靪頄飥馗傛傕傔傞傋傣傃傌傎傝偨傜傒傂傇兟凔匒匑厤厧喑喨喥喭啷噅喢喓喈喏喵喁喣喒喤啽喌喦啿喕喡喎圌堩堷"],["d8a1","堙堞堧堣堨埵塈堥堜堛堳堿堶堮堹堸堭堬堻奡媯媔媟婺媢媞婸媦婼媥媬媕媮娷媄媊媗媃媋媩婻婽媌媜媏媓媝寪寍寋寔寑寊寎尌尰崷嵃嵫嵁嵋崿崵嵑嵎嵕崳崺嵒崽崱嵙嵂崹嵉崸崼崲崶嵀嵅幄幁彘徦徥徫惉悹惌惢惎惄愔"],["d940","惲愊愖愅惵愓惸惼惾惁愃愘愝愐惿愄愋扊掔掱掰揎揥揨揯揃撝揳揊揠揶揕揲揵摡揟掾揝揜揄揘揓揂揇揌揋揈揰揗揙攲敧敪敤敜敨敥斌斝斞斮旐旒"],["d9a1","晼晬晻暀晱晹晪晲朁椌棓椄棜椪棬棪棱椏棖棷棫棤棶椓椐棳棡椇棌椈楰梴椑棯棆椔棸棐棽棼棨椋椊椗棎棈棝棞棦棴棑椆棔棩椕椥棇欹欻欿欼殔殗殙殕殽毰毲毳氰淼湆湇渟湉溈渼渽湅湢渫渿湁湝湳渜渳湋湀湑渻渃渮湞"],["da40","湨湜湡渱渨湠湱湫渹渢渰湓湥渧湸湤湷湕湹湒湦渵渶湚焠焞焯烻焮焱焣焥焢焲焟焨焺焛牋牚犈犉犆犅犋猒猋猰猢猱猳猧猲猭猦猣猵猌琮琬琰琫琖"],["daa1","琚琡琭琱琤琣琝琩琠琲瓻甯畯畬痧痚痡痦痝痟痤痗皕皒盚睆睇睄睍睅睊睎睋睌矞矬硠硤硥硜硭硱硪确硰硩硨硞硢祴祳祲祰稂稊稃稌稄窙竦竤筊笻筄筈筌筎筀筘筅粢粞粨粡絘絯絣絓絖絧絪絏絭絜絫絒絔絩絑絟絎缾缿罥"],["db40","罦羢羠羡翗聑聏聐胾胔腃腊腒腏腇脽腍脺臦臮臷臸臹舄舼舽舿艵茻菏菹萣菀菨萒菧菤菼菶萐菆菈菫菣莿萁菝菥菘菿菡菋菎菖菵菉萉萏菞萑萆菂菳"],["dba1","菕菺菇菑菪萓菃菬菮菄菻菗菢萛菛菾蛘蛢蛦蛓蛣蛚蛪蛝蛫蛜蛬蛩蛗蛨蛑衈衖衕袺裗袹袸裀袾袶袼袷袽袲褁裉覕覘覗觝觚觛詎詍訹詙詀詗詘詄詅詒詈詑詊詌詏豟貁貀貺貾貰貹貵趄趀趉跘跓跍跇跖跜跏跕跙跈跗跅軯軷軺"],["dc40","軹軦軮軥軵軧軨軶軫軱軬軴軩逭逴逯鄆鄬鄄郿郼鄈郹郻鄁鄀鄇鄅鄃酡酤酟酢酠鈁鈊鈥鈃鈚鈦鈏鈌鈀鈒釿釽鈆鈄鈧鈂鈜鈤鈙鈗鈅鈖镻閍閌閐隇陾隈"],["dca1","隉隃隀雂雈雃雱雰靬靰靮頇颩飫鳦黹亃亄亶傽傿僆傮僄僊傴僈僂傰僁傺傱僋僉傶傸凗剺剸剻剼嗃嗛嗌嗐嗋嗊嗝嗀嗔嗄嗩喿嗒喍嗏嗕嗢嗖嗈嗲嗍嗙嗂圔塓塨塤塏塍塉塯塕塎塝塙塥塛堽塣塱壼嫇嫄嫋媺媸媱媵媰媿嫈媻嫆"],["dd40","媷嫀嫊媴媶嫍媹媐寖寘寙尟尳嵱嵣嵊嵥嵲嵬嵞嵨嵧嵢巰幏幎幊幍幋廅廌廆廋廇彀徯徭惷慉慊愫慅愶愲愮慆愯慏愩慀戠酨戣戥戤揅揱揫搐搒搉搠搤"],["dda1","搳摃搟搕搘搹搷搢搣搌搦搰搨摁搵搯搊搚摀搥搧搋揧搛搮搡搎敯斒旓暆暌暕暐暋暊暙暔晸朠楦楟椸楎楢楱椿楅楪椹楂楗楙楺楈楉椵楬椳椽楥棰楸椴楩楀楯楄楶楘楁楴楌椻楋椷楜楏楑椲楒椯楻椼歆歅歃歂歈歁殛嗀毻毼"],["de40","毹毷毸溛滖滈溏滀溟溓溔溠溱溹滆滒溽滁溞滉溷溰滍溦滏溲溾滃滜滘溙溒溎溍溤溡溿溳滐滊溗溮溣煇煔煒煣煠煁煝煢煲煸煪煡煂煘煃煋煰煟煐煓"],["dea1","煄煍煚牏犍犌犑犐犎猼獂猻猺獀獊獉瑄瑊瑋瑒瑑瑗瑀瑏瑐瑎瑂瑆瑍瑔瓡瓿瓾瓽甝畹畷榃痯瘏瘃痷痾痼痹痸瘐痻痶痭痵痽皙皵盝睕睟睠睒睖睚睩睧睔睙睭矠碇碚碔碏碄碕碅碆碡碃硹碙碀碖硻祼禂祽祹稑稘稙稒稗稕稢稓"],["df40","稛稐窣窢窞竫筦筤筭筴筩筲筥筳筱筰筡筸筶筣粲粴粯綈綆綀綍絿綅絺綎絻綃絼綌綔綄絽綒罭罫罧罨罬羦羥羧翛翜耡腤腠腷腜腩腛腢腲朡腞腶腧腯"],["dfa1","腄腡舝艉艄艀艂艅蓱萿葖葶葹蒏蒍葥葑葀蒆葧萰葍葽葚葙葴葳葝蔇葞萷萺萴葺葃葸萲葅萩菙葋萯葂萭葟葰萹葎葌葒葯蓅蒎萻葇萶萳葨葾葄萫葠葔葮葐蜋蜄蛷蜌蛺蛖蛵蝍蛸蜎蜉蜁蛶蜍蜅裖裋裍裎裞裛裚裌裐覅覛觟觥觤"],["e040","觡觠觢觜触詶誆詿詡訿詷誂誄詵誃誁詴詺谼豋豊豥豤豦貆貄貅賌赨赩趑趌趎趏趍趓趔趐趒跰跠跬跱跮跐跩跣跢跧跲跫跴輆軿輁輀輅輇輈輂輋遒逿"],["e0a1","遄遉逽鄐鄍鄏鄑鄖鄔鄋鄎酮酯鉈鉒鈰鈺鉦鈳鉥鉞銃鈮鉊鉆鉭鉬鉏鉠鉧鉯鈶鉡鉰鈱鉔鉣鉐鉲鉎鉓鉌鉖鈲閟閜閞閛隒隓隑隗雎雺雽雸雵靳靷靸靲頏頍頎颬飶飹馯馲馰馵骭骫魛鳪鳭鳧麀黽僦僔僗僨僳僛僪僝僤僓僬僰僯僣僠"],["e140","凘劀劁勩勫匰厬嘧嘕嘌嘒嗼嘏嘜嘁嘓嘂嗺嘝嘄嗿嗹墉塼墐墘墆墁塿塴墋塺墇墑墎塶墂墈塻墔墏壾奫嫜嫮嫥嫕嫪嫚嫭嫫嫳嫢嫠嫛嫬嫞嫝嫙嫨嫟孷寠"],["e1a1","寣屣嶂嶀嵽嶆嵺嶁嵷嶊嶉嶈嵾嵼嶍嵹嵿幘幙幓廘廑廗廎廜廕廙廒廔彄彃彯徶愬愨慁慞慱慳慒慓慲慬憀慴慔慺慛慥愻慪慡慖戩戧戫搫摍摛摝摴摶摲摳摽摵摦撦摎撂摞摜摋摓摠摐摿搿摬摫摙摥摷敳斠暡暠暟朅朄朢榱榶槉"],["e240","榠槎榖榰榬榼榑榙榎榧榍榩榾榯榿槄榽榤槔榹槊榚槏榳榓榪榡榞槙榗榐槂榵榥槆歊歍歋殞殟殠毃毄毾滎滵滱漃漥滸漷滻漮漉潎漙漚漧漘漻漒滭漊"],["e2a1","漶潳滹滮漭潀漰漼漵滫漇漎潃漅滽滶漹漜滼漺漟漍漞漈漡熇熐熉熀熅熂熏煻熆熁熗牄牓犗犕犓獃獍獑獌瑢瑳瑱瑵瑲瑧瑮甀甂甃畽疐瘖瘈瘌瘕瘑瘊瘔皸瞁睼瞅瞂睮瞀睯睾瞃碲碪碴碭碨硾碫碞碥碠碬碢碤禘禊禋禖禕禔禓"],["e340","禗禈禒禐稫穊稰稯稨稦窨窫窬竮箈箜箊箑箐箖箍箌箛箎箅箘劄箙箤箂粻粿粼粺綧綷緂綣綪緁緀緅綝緎緄緆緋緌綯綹綖綼綟綦綮綩綡緉罳翢翣翥翞"],["e3a1","耤聝聜膉膆膃膇膍膌膋舕蒗蒤蒡蒟蒺蓎蓂蒬蒮蒫蒹蒴蓁蓍蒪蒚蒱蓐蒝蒧蒻蒢蒔蓇蓌蒛蒩蒯蒨蓖蒘蒶蓏蒠蓗蓔蓒蓛蒰蒑虡蜳蜣蜨蝫蝀蜮蜞蜡蜙蜛蝃蜬蝁蜾蝆蜠蜲蜪蜭蜼蜒蜺蜱蜵蝂蜦蜧蜸蜤蜚蜰蜑裷裧裱裲裺裾裮裼裶裻"],["e440","裰裬裫覝覡覟覞觩觫觨誫誙誋誒誏誖谽豨豩賕賏賗趖踉踂跿踍跽踊踃踇踆踅跾踀踄輐輑輎輍鄣鄜鄠鄢鄟鄝鄚鄤鄡鄛酺酲酹酳銥銤鉶銛鉺銠銔銪銍"],["e4a1","銦銚銫鉹銗鉿銣鋮銎銂銕銢鉽銈銡銊銆銌銙銧鉾銇銩銝銋鈭隞隡雿靘靽靺靾鞃鞀鞂靻鞄鞁靿韎韍頖颭颮餂餀餇馝馜駃馹馻馺駂馽駇骱髣髧鬾鬿魠魡魟鳱鳲鳵麧僿儃儰僸儆儇僶僾儋儌僽儊劋劌勱勯噈噂噌嘵噁噊噉噆噘"],["e540","噚噀嘳嘽嘬嘾嘸嘪嘺圚墫墝墱墠墣墯墬墥墡壿嫿嫴嫽嫷嫶嬃嫸嬂嫹嬁嬇嬅嬏屧嶙嶗嶟嶒嶢嶓嶕嶠嶜嶡嶚嶞幩幝幠幜緳廛廞廡彉徲憋憃慹憱憰憢憉"],["e5a1","憛憓憯憭憟憒憪憡憍慦憳戭摮摰撖撠撅撗撜撏撋撊撌撣撟摨撱撘敶敺敹敻斲斳暵暰暩暲暷暪暯樀樆樗槥槸樕槱槤樠槿槬槢樛樝槾樧槲槮樔槷槧橀樈槦槻樍槼槫樉樄樘樥樏槶樦樇槴樖歑殥殣殢殦氁氀毿氂潁漦潾澇濆澒"],["e640","澍澉澌潢潏澅潚澖潶潬澂潕潲潒潐潗澔澓潝漀潡潫潽潧澐潓澋潩潿澕潣潷潪潻熲熯熛熰熠熚熩熵熝熥熞熤熡熪熜熧熳犘犚獘獒獞獟獠獝獛獡獚獙"],["e6a1","獢璇璉璊璆璁瑽璅璈瑼瑹甈甇畾瘥瘞瘙瘝瘜瘣瘚瘨瘛皜皝皞皛瞍瞏瞉瞈磍碻磏磌磑磎磔磈磃磄磉禚禡禠禜禢禛歶稹窲窴窳箷篋箾箬篎箯箹篊箵糅糈糌糋緷緛緪緧緗緡縃緺緦緶緱緰緮緟罶羬羰羭翭翫翪翬翦翨聤聧膣膟"],["e740","膞膕膢膙膗舖艏艓艒艐艎艑蔤蔻蔏蔀蔩蔎蔉蔍蔟蔊蔧蔜蓻蔫蓺蔈蔌蓴蔪蓲蔕蓷蓫蓳蓼蔒蓪蓩蔖蓾蔨蔝蔮蔂蓽蔞蓶蔱蔦蓧蓨蓰蓯蓹蔘蔠蔰蔋蔙蔯虢"],["e7a1","蝖蝣蝤蝷蟡蝳蝘蝔蝛蝒蝡蝚蝑蝞蝭蝪蝐蝎蝟蝝蝯蝬蝺蝮蝜蝥蝏蝻蝵蝢蝧蝩衚褅褌褔褋褗褘褙褆褖褑褎褉覢覤覣觭觰觬諏諆誸諓諑諔諕誻諗誾諀諅諘諃誺誽諙谾豍貏賥賟賙賨賚賝賧趠趜趡趛踠踣踥踤踮踕踛踖踑踙踦踧"],["e840","踔踒踘踓踜踗踚輬輤輘輚輠輣輖輗遳遰遯遧遫鄯鄫鄩鄪鄲鄦鄮醅醆醊醁醂醄醀鋐鋃鋄鋀鋙銶鋏鋱鋟鋘鋩鋗鋝鋌鋯鋂鋨鋊鋈鋎鋦鋍鋕鋉鋠鋞鋧鋑鋓"],["e8a1","銵鋡鋆銴镼閬閫閮閰隤隢雓霅霈霂靚鞊鞎鞈韐韏頞頝頦頩頨頠頛頧颲餈飺餑餔餖餗餕駜駍駏駓駔駎駉駖駘駋駗駌骳髬髫髳髲髱魆魃魧魴魱魦魶魵魰魨魤魬鳼鳺鳽鳿鳷鴇鴀鳹鳻鴈鴅鴄麃黓鼏鼐儜儓儗儚儑凞匴叡噰噠噮"],["e940","噳噦噣噭噲噞噷圜圛壈墽壉墿墺壂墼壆嬗嬙嬛嬡嬔嬓嬐嬖嬨嬚嬠嬞寯嶬嶱嶩嶧嶵嶰嶮嶪嶨嶲嶭嶯嶴幧幨幦幯廩廧廦廨廥彋徼憝憨憖懅憴懆懁懌憺"],["e9a1","憿憸憌擗擖擐擏擉撽撉擃擛擳擙攳敿敼斢曈暾曀曊曋曏暽暻暺曌朣樴橦橉橧樲橨樾橝橭橶橛橑樨橚樻樿橁橪橤橐橏橔橯橩橠樼橞橖橕橍橎橆歕歔歖殧殪殫毈毇氄氃氆澭濋澣濇澼濎濈潞濄澽澞濊澨瀄澥澮澺澬澪濏澿澸"],["ea40","澢濉澫濍澯澲澰燅燂熿熸燖燀燁燋燔燊燇燏熽燘熼燆燚燛犝犞獩獦獧獬獥獫獪瑿璚璠璔璒璕璡甋疀瘯瘭瘱瘽瘳瘼瘵瘲瘰皻盦瞚瞝瞡瞜瞛瞢瞣瞕瞙"],["eaa1","瞗磝磩磥磪磞磣磛磡磢磭磟磠禤穄穈穇窶窸窵窱窷篞篣篧篝篕篥篚篨篹篔篪篢篜篫篘篟糒糔糗糐糑縒縡縗縌縟縠縓縎縜縕縚縢縋縏縖縍縔縥縤罃罻罼罺羱翯耪耩聬膱膦膮膹膵膫膰膬膴膲膷膧臲艕艖艗蕖蕅蕫蕍蕓蕡蕘"],["eb40","蕀蕆蕤蕁蕢蕄蕑蕇蕣蔾蕛蕱蕎蕮蕵蕕蕧蕠薌蕦蕝蕔蕥蕬虣虥虤螛螏螗螓螒螈螁螖螘蝹螇螣螅螐螑螝螄螔螜螚螉褞褦褰褭褮褧褱褢褩褣褯褬褟觱諠"],["eba1","諢諲諴諵諝謔諤諟諰諈諞諡諨諿諯諻貑貒貐賵賮賱賰賳赬赮趥趧踳踾踸蹀蹅踶踼踽蹁踰踿躽輶輮輵輲輹輷輴遶遹遻邆郺鄳鄵鄶醓醐醑醍醏錧錞錈錟錆錏鍺錸錼錛錣錒錁鍆錭錎錍鋋錝鋺錥錓鋹鋷錴錂錤鋿錩錹錵錪錔錌"],["ec40","錋鋾錉錀鋻錖閼闍閾閹閺閶閿閵閽隩雔霋霒霐鞙鞗鞔韰韸頵頯頲餤餟餧餩馞駮駬駥駤駰駣駪駩駧骹骿骴骻髶髺髹髷鬳鮀鮅鮇魼魾魻鮂鮓鮒鮐魺鮕"],["eca1","魽鮈鴥鴗鴠鴞鴔鴩鴝鴘鴢鴐鴙鴟麈麆麇麮麭黕黖黺鼒鼽儦儥儢儤儠儩勴嚓嚌嚍嚆嚄嚃噾嚂噿嚁壖壔壏壒嬭嬥嬲嬣嬬嬧嬦嬯嬮孻寱寲嶷幬幪徾徻懃憵憼懧懠懥懤懨懞擯擩擣擫擤擨斁斀斶旚曒檍檖檁檥檉檟檛檡檞檇檓檎"],["ed40","檕檃檨檤檑橿檦檚檅檌檒歛殭氉濌澩濴濔濣濜濭濧濦濞濲濝濢濨燡燱燨燲燤燰燢獳獮獯璗璲璫璐璪璭璱璥璯甐甑甒甏疄癃癈癉癇皤盩瞵瞫瞲瞷瞶"],["eda1","瞴瞱瞨矰磳磽礂磻磼磲礅磹磾礄禫禨穜穛穖穘穔穚窾竀竁簅簏篲簀篿篻簎篴簋篳簂簉簃簁篸篽簆篰篱簐簊糨縭縼繂縳顈縸縪繉繀繇縩繌縰縻縶繄縺罅罿罾罽翴翲耬膻臄臌臊臅臇膼臩艛艚艜薃薀薏薧薕薠薋薣蕻薤薚薞"],["ee40","蕷蕼薉薡蕺蕸蕗薎薖薆薍薙薝薁薢薂薈薅蕹蕶薘薐薟虨螾螪螭蟅螰螬螹螵螼螮蟉蟃蟂蟌螷螯蟄蟊螴螶螿螸螽蟞螲褵褳褼褾襁襒褷襂覭覯覮觲觳謞"],["eea1","謘謖謑謅謋謢謏謒謕謇謍謈謆謜謓謚豏豰豲豱豯貕貔賹赯蹎蹍蹓蹐蹌蹇轃轀邅遾鄸醚醢醛醙醟醡醝醠鎡鎃鎯鍤鍖鍇鍼鍘鍜鍶鍉鍐鍑鍠鍭鎏鍌鍪鍹鍗鍕鍒鍏鍱鍷鍻鍡鍞鍣鍧鎀鍎鍙闇闀闉闃闅閷隮隰隬霠霟霘霝霙鞚鞡鞜"],["ef40","鞞鞝韕韔韱顁顄顊顉顅顃餥餫餬餪餳餲餯餭餱餰馘馣馡騂駺駴駷駹駸駶駻駽駾駼騃骾髾髽鬁髼魈鮚鮨鮞鮛鮦鮡鮥鮤鮆鮢鮠鮯鴳鵁鵧鴶鴮鴯鴱鴸鴰"],["efa1","鵅鵂鵃鴾鴷鵀鴽翵鴭麊麉麍麰黈黚黻黿鼤鼣鼢齔龠儱儭儮嚘嚜嚗嚚嚝嚙奰嬼屩屪巀幭幮懘懟懭懮懱懪懰懫懖懩擿攄擽擸攁攃擼斔旛曚曛曘櫅檹檽櫡櫆檺檶檷櫇檴檭歞毉氋瀇瀌瀍瀁瀅瀔瀎濿瀀濻瀦濼濷瀊爁燿燹爃燽獶"],["f040","璸瓀璵瓁璾璶璻瓂甔甓癜癤癙癐癓癗癚皦皽盬矂瞺磿礌礓礔礉礐礒礑禭禬穟簜簩簙簠簟簭簝簦簨簢簥簰繜繐繖繣繘繢繟繑繠繗繓羵羳翷翸聵臑臒"],["f0a1","臐艟艞薴藆藀藃藂薳薵薽藇藄薿藋藎藈藅薱薶藒蘤薸薷薾虩蟧蟦蟢蟛蟫蟪蟥蟟蟳蟤蟔蟜蟓蟭蟘蟣螤蟗蟙蠁蟴蟨蟝襓襋襏襌襆襐襑襉謪謧謣謳謰謵譇謯謼謾謱謥謷謦謶謮謤謻謽謺豂豵貙貘貗賾贄贂贀蹜蹢蹠蹗蹖蹞蹥蹧"],["f140","蹛蹚蹡蹝蹩蹔轆轇轈轋鄨鄺鄻鄾醨醥醧醯醪鎵鎌鎒鎷鎛鎝鎉鎧鎎鎪鎞鎦鎕鎈鎙鎟鎍鎱鎑鎲鎤鎨鎴鎣鎥闒闓闑隳雗雚巂雟雘雝霣霢霥鞬鞮鞨鞫鞤鞪"],["f1a1","鞢鞥韗韙韖韘韺顐顑顒颸饁餼餺騏騋騉騍騄騑騊騅騇騆髀髜鬈鬄鬅鬩鬵魊魌魋鯇鯆鯃鮿鯁鮵鮸鯓鮶鯄鮹鮽鵜鵓鵏鵊鵛鵋鵙鵖鵌鵗鵒鵔鵟鵘鵚麎麌黟鼁鼀鼖鼥鼫鼪鼩鼨齌齕儴儵劖勷厴嚫嚭嚦嚧嚪嚬壚壝壛夒嬽嬾嬿巃幰"],["f240","徿懻攇攐攍攉攌攎斄旞旝曞櫧櫠櫌櫑櫙櫋櫟櫜櫐櫫櫏櫍櫞歠殰氌瀙瀧瀠瀖瀫瀡瀢瀣瀩瀗瀤瀜瀪爌爊爇爂爅犥犦犤犣犡瓋瓅璷瓃甖癠矉矊矄矱礝礛"],["f2a1","礡礜礗礞禰穧穨簳簼簹簬簻糬糪繶繵繸繰繷繯繺繲繴繨罋罊羃羆羷翽翾聸臗臕艤艡艣藫藱藭藙藡藨藚藗藬藲藸藘藟藣藜藑藰藦藯藞藢蠀蟺蠃蟶蟷蠉蠌蠋蠆蟼蠈蟿蠊蠂襢襚襛襗襡襜襘襝襙覈覷覶觶譐譈譊譀譓譖譔譋譕"],["f340","譑譂譒譗豃豷豶貚贆贇贉趬趪趭趫蹭蹸蹳蹪蹯蹻軂轒轑轏轐轓辴酀鄿醰醭鏞鏇鏏鏂鏚鏐鏹鏬鏌鏙鎩鏦鏊鏔鏮鏣鏕鏄鏎鏀鏒鏧镽闚闛雡霩霫霬霨霦"],["f3a1","鞳鞷鞶韝韞韟顜顙顝顗颿颽颻颾饈饇饃馦馧騚騕騥騝騤騛騢騠騧騣騞騜騔髂鬋鬊鬎鬌鬷鯪鯫鯠鯞鯤鯦鯢鯰鯔鯗鯬鯜鯙鯥鯕鯡鯚鵷鶁鶊鶄鶈鵱鶀鵸鶆鶋鶌鵽鵫鵴鵵鵰鵩鶅鵳鵻鶂鵯鵹鵿鶇鵨麔麑黀黼鼭齀齁齍齖齗齘匷嚲"],["f440","嚵嚳壣孅巆巇廮廯忀忁懹攗攖攕攓旟曨曣曤櫳櫰櫪櫨櫹櫱櫮櫯瀼瀵瀯瀷瀴瀱灂瀸瀿瀺瀹灀瀻瀳灁爓爔犨獽獼璺皫皪皾盭矌矎矏矍矲礥礣礧礨礤礩"],["f4a1","禲穮穬穭竷籉籈籊籇籅糮繻繾纁纀羺翿聹臛臙舋艨艩蘢藿蘁藾蘛蘀藶蘄蘉蘅蘌藽蠙蠐蠑蠗蠓蠖襣襦覹觷譠譪譝譨譣譥譧譭趮躆躈躄轙轖轗轕轘轚邍酃酁醷醵醲醳鐋鐓鏻鐠鐏鐔鏾鐕鐐鐨鐙鐍鏵鐀鏷鐇鐎鐖鐒鏺鐉鏸鐊鏿"],["f540","鏼鐌鏶鐑鐆闞闠闟霮霯鞹鞻韽韾顠顢顣顟飁飂饐饎饙饌饋饓騲騴騱騬騪騶騩騮騸騭髇髊髆鬐鬒鬑鰋鰈鯷鰅鰒鯸鱀鰇鰎鰆鰗鰔鰉鶟鶙鶤鶝鶒鶘鶐鶛"],["f5a1","鶠鶔鶜鶪鶗鶡鶚鶢鶨鶞鶣鶿鶩鶖鶦鶧麙麛麚黥黤黧黦鼰鼮齛齠齞齝齙龑儺儹劘劗囃嚽嚾孈孇巋巏廱懽攛欂櫼欃櫸欀灃灄灊灈灉灅灆爝爚爙獾甗癪矐礭礱礯籔籓糲纊纇纈纋纆纍罍羻耰臝蘘蘪蘦蘟蘣蘜蘙蘧蘮蘡蘠蘩蘞蘥"],["f640","蠩蠝蠛蠠蠤蠜蠫衊襭襩襮襫觺譹譸譅譺譻贐贔趯躎躌轞轛轝酆酄酅醹鐿鐻鐶鐩鐽鐼鐰鐹鐪鐷鐬鑀鐱闥闤闣霵霺鞿韡顤飉飆飀饘饖騹騽驆驄驂驁騺"],["f6a1","騿髍鬕鬗鬘鬖鬺魒鰫鰝鰜鰬鰣鰨鰩鰤鰡鶷鶶鶼鷁鷇鷊鷏鶾鷅鷃鶻鶵鷎鶹鶺鶬鷈鶱鶭鷌鶳鷍鶲鹺麜黫黮黭鼛鼘鼚鼱齎齥齤龒亹囆囅囋奱孋孌巕巑廲攡攠攦攢欋欈欉氍灕灖灗灒爞爟犩獿瓘瓕瓙瓗癭皭礵禴穰穱籗籜籙籛籚"],["f740","糴糱纑罏羇臞艫蘴蘵蘳蘬蘲蘶蠬蠨蠦蠪蠥襱覿覾觻譾讄讂讆讅譿贕躕躔躚躒躐躖躗轠轢酇鑌鑐鑊鑋鑏鑇鑅鑈鑉鑆霿韣顪顩飋饔饛驎驓驔驌驏驈驊"],["f7a1","驉驒驐髐鬙鬫鬻魖魕鱆鱈鰿鱄鰹鰳鱁鰼鰷鰴鰲鰽鰶鷛鷒鷞鷚鷋鷐鷜鷑鷟鷩鷙鷘鷖鷵鷕鷝麶黰鼵鼳鼲齂齫龕龢儽劙壨壧奲孍巘蠯彏戁戃戄攩攥斖曫欑欒欏毊灛灚爢玂玁玃癰矔籧籦纕艬蘺虀蘹蘼蘱蘻蘾蠰蠲蠮蠳襶襴襳觾"],["f840","讌讎讋讈豅贙躘轤轣醼鑢鑕鑝鑗鑞韄韅頀驖驙鬞鬟鬠鱒鱘鱐鱊鱍鱋鱕鱙鱌鱎鷻鷷鷯鷣鷫鷸鷤鷶鷡鷮鷦鷲鷰鷢鷬鷴鷳鷨鷭黂黐黲黳鼆鼜鼸鼷鼶齃齏"],["f8a1","齱齰齮齯囓囍孎屭攭曭曮欓灟灡灝灠爣瓛瓥矕礸禷禶籪纗羉艭虃蠸蠷蠵衋讔讕躞躟躠躝醾醽釂鑫鑨鑩雥靆靃靇韇韥驞髕魙鱣鱧鱦鱢鱞鱠鸂鷾鸇鸃鸆鸅鸀鸁鸉鷿鷽鸄麠鼞齆齴齵齶囔攮斸欘欙欗欚灢爦犪矘矙礹籩籫糶纚"],["f940","纘纛纙臠臡虆虇虈襹襺襼襻觿讘讙躥躤躣鑮鑭鑯鑱鑳靉顲饟鱨鱮鱭鸋鸍鸐鸏鸒鸑麡黵鼉齇齸齻齺齹圞灦籯蠼趲躦釃鑴鑸鑶鑵驠鱴鱳鱱鱵鸔鸓黶鼊"],["f9a1","龤灨灥糷虪蠾蠽蠿讞貜躩軉靋顳顴飌饡馫驤驦驧鬤鸕鸗齈戇欞爧虌躨钂钀钁驩驨鬮鸙爩虋讟钃鱹麷癵驫鱺鸝灩灪麤齾齉龘碁銹裏墻恒粧嫺╔╦╗╠╬╣╚╩╝╒╤╕╞╪╡╘╧╛╓╥╖╟╫╢╙╨╜║═╭╮╰╯▓"]]

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
(function() {
  var ArrayT, NumberT, utils;

  NumberT = __webpack_require__(22).Number;

  utils = __webpack_require__(12);

  ArrayT = (function() {
    function ArrayT(type, length, lengthType) {
      this.type = type;
      this.length = length;
      this.lengthType = lengthType != null ? lengthType : 'count';
    }

    ArrayT.prototype.decode = function(stream, parent) {
      var ctx, i, length, pos, res, target, _i;
      pos = stream.pos;
      res = [];
      ctx = parent;
      if (this.length != null) {
        length = utils.resolveLength(this.length, stream, parent);
      }
      if (this.length instanceof NumberT) {
        Object.defineProperties(res, {
          parent: {
            value: parent
          },
          _startOffset: {
            value: pos
          },
          _currentOffset: {
            value: 0,
            writable: true
          },
          _length: {
            value: length
          }
        });
        ctx = res;
      }
      if ((length == null) || this.lengthType === 'bytes') {
        target = length != null ? stream.pos + length : (parent != null ? parent._length : void 0) ? parent._startOffset + parent._length : stream.length;
        while (stream.pos < target) {
          res.push(this.type.decode(stream, ctx));
        }
      } else {
        for (i = _i = 0; _i < length; i = _i += 1) {
          res.push(this.type.decode(stream, ctx));
        }
      }
      return res;
    };

    ArrayT.prototype.size = function(array, ctx) {
      var item, size, _i, _len;
      if (!array) {
        return this.type.size(null, ctx) * utils.resolveLength(this.length, null, ctx);
      }
      size = 0;
      if (this.length instanceof NumberT) {
        size += this.length.size();
        ctx = {
          parent: ctx
        };
      }
      for (_i = 0, _len = array.length; _i < _len; _i++) {
        item = array[_i];
        size += this.type.size(item, ctx);
      }
      return size;
    };

    ArrayT.prototype.encode = function(stream, array, parent) {
      var ctx, i, item, ptr, _i, _len;
      ctx = parent;
      if (this.length instanceof NumberT) {
        ctx = {
          pointers: [],
          startOffset: stream.pos,
          parent: parent
        };
        ctx.pointerOffset = stream.pos + this.size(array, ctx);
        this.length.encode(stream, array.length);
      }
      for (_i = 0, _len = array.length; _i < _len; _i++) {
        item = array[_i];
        this.type.encode(stream, item, ctx);
      }
      if (this.length instanceof NumberT) {
        i = 0;
        while (i < ctx.pointers.length) {
          ptr = ctx.pointers[i++];
          ptr.type.encode(stream, ptr.val);
        }
      }
    };

    return ArrayT;

  })();

  module.exports = ArrayT;

}).call(this);


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

// Generated by CoffeeScript 1.7.1
(function() {
  var Struct, utils;

  utils = __webpack_require__(12);

  Struct = (function() {
    function Struct(fields) {
      this.fields = fields != null ? fields : {};
    }

    Struct.prototype.decode = function(stream, parent, length) {
      var res, _ref;
      if (length == null) {
        length = 0;
      }
      res = this._setup(stream, parent, length);
      this._parseFields(stream, res, this.fields);
      if ((_ref = this.process) != null) {
        _ref.call(res, stream);
      }
      return res;
    };

    Struct.prototype._setup = function(stream, parent, length) {
      var res;
      res = {};
      Object.defineProperties(res, {
        parent: {
          value: parent
        },
        _startOffset: {
          value: stream.pos
        },
        _currentOffset: {
          value: 0,
          writable: true
        },
        _length: {
          value: length
        }
      });
      return res;
    };

    Struct.prototype._parseFields = function(stream, res, fields) {
      var key, type, val;
      for (key in fields) {
        type = fields[key];
        if (typeof type === 'function') {
          val = type.call(res, res);
        } else {
          val = type.decode(stream, res);
        }
        if (val !== void 0) {
          if (val instanceof utils.PropertyDescriptor) {
            Object.defineProperty(res, key, val);
          } else {
            res[key] = val;
          }
        }
        res._currentOffset = stream.pos - res._startOffset;
      }
    };

    Struct.prototype.size = function(val, parent, includePointers) {
      var ctx, key, size, type, _ref;
      if (val == null) {
        val = {};
      }
      if (includePointers == null) {
        includePointers = true;
      }
      ctx = {
        parent: parent,
        val: val,
        pointerSize: 0
      };
      size = 0;
      _ref = this.fields;
      for (key in _ref) {
        type = _ref[key];
        if (type.size != null) {
          size += type.size(val[key], ctx);
        }
      }
      if (includePointers) {
        size += ctx.pointerSize;
      }
      return size;
    };

    Struct.prototype.encode = function(stream, val, parent) {
      var ctx, i, key, ptr, type, _ref, _ref1;
      if ((_ref = this.preEncode) != null) {
        _ref.call(val, stream);
      }
      ctx = {
        pointers: [],
        startOffset: stream.pos,
        parent: parent,
        val: val,
        pointerSize: 0
      };
      ctx.pointerOffset = stream.pos + this.size(val, ctx, false);
      _ref1 = this.fields;
      for (key in _ref1) {
        type = _ref1[key];
        if (type.encode != null) {
          type.encode(stream, val[key], ctx);
        }
      }
      i = 0;
      while (i < ctx.pointers.length) {
        ptr = ctx.pointers[i++];
        ptr.type.encode(stream, ptr.val, ptr.parent);
      }
    };

    return Struct;

  })();

  module.exports = Struct;

}).call(this);


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(5) && !__webpack_require__(19)(function () {
  return Object.defineProperty(__webpack_require__(96)('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(9);
var document = __webpack_require__(10).document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),
/* 97 */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),
/* 98 */
/***/ (function(module, exports) {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(13);


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(6);
var anObject = __webpack_require__(14);
var getKeys = __webpack_require__(29);

module.exports = __webpack_require__(5) ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(18);
var toIObject = __webpack_require__(17);
var arrayIndexOf = __webpack_require__(204)(false);
var IE_PROTO = __webpack_require__(64)('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(63);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = { "default": __webpack_require__(215), __esModule: true };

/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(55);
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(101);
var hiddenKeys = __webpack_require__(66).concat('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

exports.default = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.__esModule = true;

var _defineProperty = __webpack_require__(74);

var _defineProperty2 = _interopRequireDefault(_defineProperty);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      (0, _defineProperty2.default)(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();

/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var dP = __webpack_require__(6).f;
var create = __webpack_require__(36);
var redefineAll = __webpack_require__(109);
var ctx = __webpack_require__(20);
var anInstance = __webpack_require__(110);
var forOf = __webpack_require__(41);
var $iterDefine = __webpack_require__(61);
var step = __webpack_require__(98);
var setSpecies = __webpack_require__(228);
var DESCRIPTORS = __webpack_require__(5);
var fastKey = __webpack_require__(40).fastKey;
var validate = __webpack_require__(75);
var SIZE = DESCRIPTORS ? '_s' : 'size';

var getEntry = function (that, key) {
  // fast case
  var index = fastKey(key);
  var entry;
  if (index !== 'F') return that._i[index];
  // frozen object case
  for (entry = that._f; entry; entry = entry.n) {
    if (entry.k == key) return entry;
  }
};

module.exports = {
  getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, NAME, '_i');
      that._t = NAME;         // collection type
      that._i = create(null); // index
      that._f = undefined;    // first entry
      that._l = undefined;    // last entry
      that[SIZE] = 0;         // size
      if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);
    });
    redefineAll(C.prototype, {
      // 23.1.3.1 Map.prototype.clear()
      // 23.2.3.2 Set.prototype.clear()
      clear: function clear() {
        for (var that = validate(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {
          entry.r = true;
          if (entry.p) entry.p = entry.p.n = undefined;
          delete data[entry.i];
        }
        that._f = that._l = undefined;
        that[SIZE] = 0;
      },
      // 23.1.3.3 Map.prototype.delete(key)
      // 23.2.3.4 Set.prototype.delete(value)
      'delete': function (key) {
        var that = validate(this, NAME);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.n;
          var prev = entry.p;
          delete that._i[entry.i];
          entry.r = true;
          if (prev) prev.n = next;
          if (next) next.p = prev;
          if (that._f == entry) that._f = next;
          if (that._l == entry) that._l = prev;
          that[SIZE]--;
        } return !!entry;
      },
      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
      forEach: function forEach(callbackfn /* , that = undefined */) {
        validate(this, NAME);
        var f = ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.n : this._f) {
          f(entry.v, entry.k, this);
          // revert to the last existing entry
          while (entry && entry.r) entry = entry.p;
        }
      },
      // 23.1.3.7 Map.prototype.has(key)
      // 23.2.3.7 Set.prototype.has(value)
      has: function has(key) {
        return !!getEntry(validate(this, NAME), key);
      }
    });
    if (DESCRIPTORS) dP(C.prototype, 'size', {
      get: function () {
        return validate(this, NAME)[SIZE];
      }
    });
    return C;
  },
  def: function (that, key, value) {
    var entry = getEntry(that, key);
    var prev, index;
    // change existing entry
    if (entry) {
      entry.v = value;
    // create new entry
    } else {
      that._l = entry = {
        i: index = fastKey(key, true), // <- index
        k: key,                        // <- key
        v: value,                      // <- value
        p: prev = that._l,             // <- previous entry
        n: undefined,                  // <- next entry
        r: false                       // <- removed
      };
      if (!that._f) that._f = entry;
      if (prev) prev.n = entry;
      that[SIZE]++;
      // add to index
      if (index !== 'F') that._i[index] = entry;
    } return that;
  },
  getEntry: getEntry,
  setStrong: function (C, NAME, IS_MAP) {
    // add .keys, .values, .entries, [@@iterator]
    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
    $iterDefine(C, NAME, function (iterated, kind) {
      this._t = validate(iterated, NAME); // target
      this._k = kind;                     // kind
      this._l = undefined;                // previous
    }, function () {
      var that = this;
      var kind = that._k;
      var entry = that._l;
      // revert to the last existing entry
      while (entry && entry.r) entry = entry.p;
      // get next entry
      if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
        // or finish the iteration
        that._t = undefined;
        return step(1);
      }
      // return step by kind
      if (kind == 'keys') return step(0, entry.k);
      if (kind == 'values') return step(0, entry.v);
      return step(0, [entry.k, entry.v]);
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // add [@@species], 23.1.2.2, 23.2.2.2
    setSpecies(NAME);
  }
};


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

var hide = __webpack_require__(13);
module.exports = function (target, src, safe) {
  for (var key in src) {
    if (safe && target[key]) target[key] = src[key];
    else hide(target, key, src[key]);
  } return target;
};


/***/ }),
/* 110 */
/***/ (function(module, exports) {

module.exports = function (it, Constructor, name, forbiddenField) {
  if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
    throw TypeError(name + ': incorrect invocation!');
  } return it;
};


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

// call something on iterator step with safe closing on error
var anObject = __webpack_require__(14);
module.exports = function (iterator, fn, value, entries) {
  try {
    return entries ? fn(anObject(value)[0], value[1]) : fn(value);
  // 7.4.6 IteratorClose(iterator, completion)
  } catch (e) {
    var ret = iterator['return'];
    if (ret !== undefined) anObject(ret.call(iterator));
    throw e;
  }
};


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

// check on default Array iterator
var Iterators = __webpack_require__(23);
var ITERATOR = __webpack_require__(4)('iterator');
var ArrayProto = Array.prototype;

module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
};


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(10);
var $export = __webpack_require__(3);
var meta = __webpack_require__(40);
var fails = __webpack_require__(19);
var hide = __webpack_require__(13);
var redefineAll = __webpack_require__(109);
var forOf = __webpack_require__(41);
var anInstance = __webpack_require__(110);
var isObject = __webpack_require__(9);
var setToStringTag = __webpack_require__(39);
var dP = __webpack_require__(6).f;
var each = __webpack_require__(229)(0);
var DESCRIPTORS = __webpack_require__(5);

module.exports = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {
  var Base = global[NAME];
  var C = Base;
  var ADDER = IS_MAP ? 'set' : 'add';
  var proto = C && C.prototype;
  var O = {};
  if (!DESCRIPTORS || typeof C != 'function' || !(IS_WEAK || proto.forEach && !fails(function () {
    new C().entries().next();
  }))) {
    // create collection constructor
    C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);
    redefineAll(C.prototype, methods);
    meta.NEED = true;
  } else {
    C = wrapper(function (target, iterable) {
      anInstance(target, C, NAME, '_c');
      target._c = new Base();
      if (iterable != undefined) forOf(iterable, IS_MAP, target[ADDER], target);
    });
    each('add,clear,delete,forEach,get,has,set,keys,values,entries,toJSON'.split(','), function (KEY) {
      var IS_ADDER = KEY == 'add' || KEY == 'set';
      if (KEY in proto && !(IS_WEAK && KEY == 'clear')) hide(C.prototype, KEY, function (a, b) {
        anInstance(this, C, KEY);
        if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY == 'get' ? undefined : false;
        var result = this._c[KEY](a === 0 ? 0 : a, b);
        return IS_ADDER ? this : result;
      });
    });
    IS_WEAK || dP(C.prototype, 'size', {
      get: function () {
        return this._c.size;
      }
    });
  }

  setToStringTag(C, NAME);

  O[NAME] = C;
  $export($export.G + $export.W + $export.F, O);

  if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);

  return C;
};


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

// https://github.com/DavidBruant/Map-Set.prototype.toJSON
var classof = __webpack_require__(68);
var from = __webpack_require__(233);
module.exports = function (NAME) {
  return function toJSON() {
    if (classof(this) != NAME) throw TypeError(NAME + "#toJSON isn't generic");
    return from(this);
  };
};


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(3);

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { of: function of() {
    var length = arguments.length;
    var A = new Array(length);
    while (length--) A[length] = arguments[length];
    return new this(A);
  } });
};


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(3);
var aFunction = __webpack_require__(97);
var ctx = __webpack_require__(20);
var forOf = __webpack_require__(41);

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {
    var mapFn = arguments[1];
    var mapping, A, n, cb;
    aFunction(this);
    mapping = mapFn !== undefined;
    if (mapping) aFunction(mapFn);
    if (source == undefined) return new this();
    A = [];
    if (mapping) {
      n = 0;
      cb = ctx(mapFn, arguments[2], 2);
      forOf(source, false, function (nextItem) {
        A.push(cb(nextItem, n++));
      });
    } else {
      forOf(source, false, A.push, A);
    }
    return new this(A);
  } });
};


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

var BrotliInput = __webpack_require__(118).BrotliInput;
var BrotliOutput = __webpack_require__(118).BrotliOutput;
var BrotliBitReader = __webpack_require__(285);
var BrotliDictionary = __webpack_require__(119);
var HuffmanCode = __webpack_require__(120).HuffmanCode;
var BrotliBuildHuffmanTable = __webpack_require__(120).BrotliBuildHuffmanTable;
var Context = __webpack_require__(289);
var Prefix = __webpack_require__(290);
var Transform = __webpack_require__(291);

var kDefaultCodeLength = 8;
var kCodeLengthRepeatCode = 16;
var kNumLiteralCodes = 256;
var kNumInsertAndCopyCodes = 704;
var kNumBlockLengthCodes = 26;
var kLiteralContextBits = 6;
var kDistanceContextBits = 2;

var HUFFMAN_TABLE_BITS = 8;
var HUFFMAN_TABLE_MASK = 0xff;
/* Maximum possible Huffman table size for an alphabet size of 704, max code
 * length 15 and root table bits 8. */
var HUFFMAN_MAX_TABLE_SIZE = 1080;

var CODE_LENGTH_CODES = 18;
var kCodeLengthCodeOrder = new Uint8Array([
  1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15,
]);

var NUM_DISTANCE_SHORT_CODES = 16;
var kDistanceShortCodeIndexOffset = new Uint8Array([
  3, 2, 1, 0, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2
]);

var kDistanceShortCodeValueOffset = new Int8Array([
  0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3
]);

var kMaxHuffmanTableSize = new Uint16Array([
  256, 402, 436, 468, 500, 534, 566, 598, 630, 662, 694, 726, 758, 790, 822,
  854, 886, 920, 952, 984, 1016, 1048, 1080
]);

function DecodeWindowBits(br) {
  var n;
  if (br.readBits(1) === 0) {
    return 16;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 17 + n;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 8 + n;
  }
  
  return 17;
}

/* Decodes a number in the range [0..255], by reading 1 - 11 bits. */
function DecodeVarLenUint8(br) {
  if (br.readBits(1)) {
    var nbits = br.readBits(3);
    if (nbits === 0) {
      return 1;
    } else {
      return br.readBits(nbits) + (1 << nbits);
    }
  }
  return 0;
}

function MetaBlockLength() {
  this.meta_block_length = 0;
  this.input_end = 0;
  this.is_uncompressed = 0;
  this.is_metadata = false;
}

function DecodeMetaBlockLength(br) {
  var out = new MetaBlockLength;  
  var size_nibbles;
  var size_bytes;
  var i;
  
  out.input_end = br.readBits(1);
  if (out.input_end && br.readBits(1)) {
    return out;
  }
  
  size_nibbles = br.readBits(2) + 4;
  if (size_nibbles === 7) {
    out.is_metadata = true;
    
    if (br.readBits(1) !== 0)
      throw new Error('Invalid reserved bit');
    
    size_bytes = br.readBits(2);
    if (size_bytes === 0)
      return out;
    
    for (i = 0; i < size_bytes; i++) {
      var next_byte = br.readBits(8);
      if (i + 1 === size_bytes && size_bytes > 1 && next_byte === 0)
        throw new Error('Invalid size byte');
      
      out.meta_block_length |= next_byte << (i * 8);
    }
  } else {
    for (i = 0; i < size_nibbles; ++i) {
      var next_nibble = br.readBits(4);
      if (i + 1 === size_nibbles && size_nibbles > 4 && next_nibble === 0)
        throw new Error('Invalid size nibble');
      
      out.meta_block_length |= next_nibble << (i * 4);
    }
  }
  
  ++out.meta_block_length;
  
  if (!out.input_end && !out.is_metadata) {
    out.is_uncompressed = br.readBits(1);
  }
  
  return out;
}

/* Decodes the next Huffman code from bit-stream. */
function ReadSymbol(table, index, br) {
  var start_index = index;
  
  var nbits;
  br.fillBitWindow();
  index += (br.val_ >>> br.bit_pos_) & HUFFMAN_TABLE_MASK;
  nbits = table[index].bits - HUFFMAN_TABLE_BITS;
  if (nbits > 0) {
    br.bit_pos_ += HUFFMAN_TABLE_BITS;
    index += table[index].value;
    index += (br.val_ >>> br.bit_pos_) & ((1 << nbits) - 1);
  }
  br.bit_pos_ += table[index].bits;
  return table[index].value;
}

function ReadHuffmanCodeLengths(code_length_code_lengths, num_symbols, code_lengths, br) {
  var symbol = 0;
  var prev_code_len = kDefaultCodeLength;
  var repeat = 0;
  var repeat_code_len = 0;
  var space = 32768;
  
  var table = [];
  for (var i = 0; i < 32; i++)
    table.push(new HuffmanCode(0, 0));
  
  BrotliBuildHuffmanTable(table, 0, 5, code_length_code_lengths, CODE_LENGTH_CODES);

  while (symbol < num_symbols && space > 0) {
    var p = 0;
    var code_len;
    
    br.readMoreInput();
    br.fillBitWindow();
    p += (br.val_ >>> br.bit_pos_) & 31;
    br.bit_pos_ += table[p].bits;
    code_len = table[p].value & 0xff;
    if (code_len < kCodeLengthRepeatCode) {
      repeat = 0;
      code_lengths[symbol++] = code_len;
      if (code_len !== 0) {
        prev_code_len = code_len;
        space -= 32768 >> code_len;
      }
    } else {
      var extra_bits = code_len - 14;
      var old_repeat;
      var repeat_delta;
      var new_len = 0;
      if (code_len === kCodeLengthRepeatCode) {
        new_len = prev_code_len;
      }
      if (repeat_code_len !== new_len) {
        repeat = 0;
        repeat_code_len = new_len;
      }
      old_repeat = repeat;
      if (repeat > 0) {
        repeat -= 2;
        repeat <<= extra_bits;
      }
      repeat += br.readBits(extra_bits) + 3;
      repeat_delta = repeat - old_repeat;
      if (symbol + repeat_delta > num_symbols) {
        throw new Error('[ReadHuffmanCodeLengths] symbol + repeat_delta > num_symbols');
      }
      
      for (var x = 0; x < repeat_delta; x++)
        code_lengths[symbol + x] = repeat_code_len;
      
      symbol += repeat_delta;
      
      if (repeat_code_len !== 0) {
        space -= repeat_delta << (15 - repeat_code_len);
      }
    }
  }
  if (space !== 0) {
    throw new Error("[ReadHuffmanCodeLengths] space = " + space);
  }
  
  for (; symbol < num_symbols; symbol++)
    code_lengths[symbol] = 0;
}

function ReadHuffmanCode(alphabet_size, tables, table, br) {
  var table_size = 0;
  var simple_code_or_skip;
  var code_lengths = new Uint8Array(alphabet_size);
  
  br.readMoreInput();
  
  /* simple_code_or_skip is used as follows:
     1 for simple code;
     0 for no skipping, 2 skips 2 code lengths, 3 skips 3 code lengths */
  simple_code_or_skip = br.readBits(2);
  if (simple_code_or_skip === 1) {
    /* Read symbols, codes & code lengths directly. */
    var i;
    var max_bits_counter = alphabet_size - 1;
    var max_bits = 0;
    var symbols = new Int32Array(4);
    var num_symbols = br.readBits(2) + 1;
    while (max_bits_counter) {
      max_bits_counter >>= 1;
      ++max_bits;
    }

    for (i = 0; i < num_symbols; ++i) {
      symbols[i] = br.readBits(max_bits) % alphabet_size;
      code_lengths[symbols[i]] = 2;
    }
    code_lengths[symbols[0]] = 1;
    switch (num_symbols) {
      case 1:
        break;
      case 3:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[1] === symbols[2])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        break;
      case 2:
        if (symbols[0] === symbols[1]) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        code_lengths[symbols[1]] = 1;
        break;
      case 4:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[0] === symbols[3]) ||
            (symbols[1] === symbols[2]) ||
            (symbols[1] === symbols[3]) ||
            (symbols[2] === symbols[3])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        if (br.readBits(1)) {
          code_lengths[symbols[2]] = 3;
          code_lengths[symbols[3]] = 3;
        } else {
          code_lengths[symbols[0]] = 2;
        }
        break;
    }
  } else {  /* Decode Huffman-coded code lengths. */
    var i;
    var code_length_code_lengths = new Uint8Array(CODE_LENGTH_CODES);
    var space = 32;
    var num_codes = 0;
    /* Static Huffman code for the code length code lengths */
    var huff = [
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 1),
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 5)
    ];
    for (i = simple_code_or_skip; i < CODE_LENGTH_CODES && space > 0; ++i) {
      var code_len_idx = kCodeLengthCodeOrder[i];
      var p = 0;
      var v;
      br.fillBitWindow();
      p += (br.val_ >>> br.bit_pos_) & 15;
      br.bit_pos_ += huff[p].bits;
      v = huff[p].value;
      code_length_code_lengths[code_len_idx] = v;
      if (v !== 0) {
        space -= (32 >> v);
        ++num_codes;
      }
    }
    
    if (!(num_codes === 1 || space === 0))
      throw new Error('[ReadHuffmanCode] invalid num_codes or space');
    
    ReadHuffmanCodeLengths(code_length_code_lengths, alphabet_size, code_lengths, br);
  }
  
  table_size = BrotliBuildHuffmanTable(tables, table, HUFFMAN_TABLE_BITS, code_lengths, alphabet_size);
  
  if (table_size === 0) {
    throw new Error("[ReadHuffmanCode] BuildHuffmanTable failed: ");
  }
  
  return table_size;
}

function ReadBlockLength(table, index, br) {
  var code;
  var nbits;
  code = ReadSymbol(table, index, br);
  nbits = Prefix.kBlockLengthPrefixCode[code].nbits;
  return Prefix.kBlockLengthPrefixCode[code].offset + br.readBits(nbits);
}

function TranslateShortCodes(code, ringbuffer, index) {
  var val;
  if (code < NUM_DISTANCE_SHORT_CODES) {
    index += kDistanceShortCodeIndexOffset[code];
    index &= 3;
    val = ringbuffer[index] + kDistanceShortCodeValueOffset[code];
  } else {
    val = code - NUM_DISTANCE_SHORT_CODES + 1;
  }
  return val;
}

function MoveToFront(v, index) {
  var value = v[index];
  var i = index;
  for (; i; --i) v[i] = v[i - 1];
  v[0] = value;
}

function InverseMoveToFrontTransform(v, v_len) {
  var mtf = new Uint8Array(256);
  var i;
  for (i = 0; i < 256; ++i) {
    mtf[i] = i;
  }
  for (i = 0; i < v_len; ++i) {
    var index = v[i];
    v[i] = mtf[index];
    if (index) MoveToFront(mtf, index);
  }
}

/* Contains a collection of huffman trees with the same alphabet size. */
function HuffmanTreeGroup(alphabet_size, num_htrees) {
  this.alphabet_size = alphabet_size;
  this.num_htrees = num_htrees;
  this.codes = new Array(num_htrees + num_htrees * kMaxHuffmanTableSize[(alphabet_size + 31) >>> 5]);  
  this.htrees = new Uint32Array(num_htrees);
}

HuffmanTreeGroup.prototype.decode = function(br) {
  var i;
  var table_size;
  var next = 0;
  for (i = 0; i < this.num_htrees; ++i) {
    this.htrees[i] = next;
    table_size = ReadHuffmanCode(this.alphabet_size, this.codes, next, br);
    next += table_size;
  }
};

function DecodeContextMap(context_map_size, br) {
  var out = { num_htrees: null, context_map: null };
  var use_rle_for_zeros;
  var max_run_length_prefix = 0;
  var table;
  var i;
  
  br.readMoreInput();
  var num_htrees = out.num_htrees = DecodeVarLenUint8(br) + 1;

  var context_map = out.context_map = new Uint8Array(context_map_size);
  if (num_htrees <= 1) {
    return out;
  }

  use_rle_for_zeros = br.readBits(1);
  if (use_rle_for_zeros) {
    max_run_length_prefix = br.readBits(4) + 1;
  }
  
  table = [];
  for (i = 0; i < HUFFMAN_MAX_TABLE_SIZE; i++) {
    table[i] = new HuffmanCode(0, 0);
  }
  
  ReadHuffmanCode(num_htrees + max_run_length_prefix, table, 0, br);
  
  for (i = 0; i < context_map_size;) {
    var code;

    br.readMoreInput();
    code = ReadSymbol(table, 0, br);
    if (code === 0) {
      context_map[i] = 0;
      ++i;
    } else if (code <= max_run_length_prefix) {
      var reps = 1 + (1 << code) + br.readBits(code);
      while (--reps) {
        if (i >= context_map_size) {
          throw new Error("[DecodeContextMap] i >= context_map_size");
        }
        context_map[i] = 0;
        ++i;
      }
    } else {
      context_map[i] = code - max_run_length_prefix;
      ++i;
    }
  }
  if (br.readBits(1)) {
    InverseMoveToFrontTransform(context_map, context_map_size);
  }
  
  return out;
}

function DecodeBlockType(max_block_type, trees, tree_type, block_types, ringbuffers, indexes, br) {
  var ringbuffer = tree_type * 2;
  var index = tree_type;
  var type_code = ReadSymbol(trees, tree_type * HUFFMAN_MAX_TABLE_SIZE, br);
  var block_type;
  if (type_code === 0) {
    block_type = ringbuffers[ringbuffer + (indexes[index] & 1)];
  } else if (type_code === 1) {
    block_type = ringbuffers[ringbuffer + ((indexes[index] - 1) & 1)] + 1;
  } else {
    block_type = type_code - 2;
  }
  if (block_type >= max_block_type) {
    block_type -= max_block_type;
  }
  block_types[tree_type] = block_type;
  ringbuffers[ringbuffer + (indexes[index] & 1)] = block_type;
  ++indexes[index];
}

function CopyUncompressedBlockToOutput(output, len, pos, ringbuffer, ringbuffer_mask, br) {
  var rb_size = ringbuffer_mask + 1;
  var rb_pos = pos & ringbuffer_mask;
  var br_pos = br.pos_ & BrotliBitReader.IBUF_MASK;
  var nbytes;

  /* For short lengths copy byte-by-byte */
  if (len < 8 || br.bit_pos_ + (len << 3) < br.bit_end_pos_) {
    while (len-- > 0) {
      br.readMoreInput();
      ringbuffer[rb_pos++] = br.readBits(8);
      if (rb_pos === rb_size) {
        output.write(ringbuffer, rb_size);
        rb_pos = 0;
      }
    }
    return;
  }

  if (br.bit_end_pos_ < 32) {
    throw new Error('[CopyUncompressedBlockToOutput] br.bit_end_pos_ < 32');
  }

  /* Copy remaining 0-4 bytes from br.val_ to ringbuffer. */
  while (br.bit_pos_ < 32) {
    ringbuffer[rb_pos] = (br.val_ >>> br.bit_pos_);
    br.bit_pos_ += 8;
    ++rb_pos;
    --len;
  }

  /* Copy remaining bytes from br.buf_ to ringbuffer. */
  nbytes = (br.bit_end_pos_ - br.bit_pos_) >> 3;
  if (br_pos + nbytes > BrotliBitReader.IBUF_MASK) {
    var tail = BrotliBitReader.IBUF_MASK + 1 - br_pos;
    for (var x = 0; x < tail; x++)
      ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
    
    nbytes -= tail;
    rb_pos += tail;
    len -= tail;
    br_pos = 0;
  }

  for (var x = 0; x < nbytes; x++)
    ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
  
  rb_pos += nbytes;
  len -= nbytes;

  /* If we wrote past the logical end of the ringbuffer, copy the tail of the
     ringbuffer to its beginning and flush the ringbuffer to the output. */
  if (rb_pos >= rb_size) {
    output.write(ringbuffer, rb_size);
    rb_pos -= rb_size;    
    for (var x = 0; x < rb_pos; x++)
      ringbuffer[x] = ringbuffer[rb_size + x];
  }

  /* If we have more to copy than the remaining size of the ringbuffer, then we
     first fill the ringbuffer from the input and then flush the ringbuffer to
     the output */
  while (rb_pos + len >= rb_size) {
    nbytes = rb_size - rb_pos;
    if (br.input_.read(ringbuffer, rb_pos, nbytes) < nbytes) {
      throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
    }
    output.write(ringbuffer, rb_size);
    len -= nbytes;
    rb_pos = 0;
  }

  /* Copy straight from the input onto the ringbuffer. The ringbuffer will be
     flushed to the output at a later time. */
  if (br.input_.read(ringbuffer, rb_pos, len) < len) {
    throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
  }

  /* Restore the state of the bit reader. */
  br.reset();
}

/* Advances the bit reader position to the next byte boundary and verifies
   that any skipped bits are set to zero. */
function JumpToByteBoundary(br) {
  var new_bit_pos = (br.bit_pos_ + 7) & ~7;
  var pad_bits = br.readBits(new_bit_pos - br.bit_pos_);
  return pad_bits == 0;
}

function BrotliDecompressedSize(buffer) {
  var input = new BrotliInput(buffer);
  var br = new BrotliBitReader(input);
  DecodeWindowBits(br);
  var out = DecodeMetaBlockLength(br);
  return out.meta_block_length;
}

exports.BrotliDecompressedSize = BrotliDecompressedSize;

function BrotliDecompressBuffer(buffer, output_size) {
  var input = new BrotliInput(buffer);
  
  if (output_size == null) {
    output_size = BrotliDecompressedSize(buffer);
  }
  
  var output_buffer = new Uint8Array(output_size);
  var output = new BrotliOutput(output_buffer);
  
  BrotliDecompress(input, output);
  
  if (output.pos < output.buffer.length) {
    output.buffer = output.buffer.subarray(0, output.pos);
  }
  
  return output.buffer;
}

exports.BrotliDecompressBuffer = BrotliDecompressBuffer;

function BrotliDecompress(input, output) {
  var i;
  var pos = 0;
  var input_end = 0;
  var window_bits = 0;
  var max_backward_distance;
  var max_distance = 0;
  var ringbuffer_size;
  var ringbuffer_mask;
  var ringbuffer;
  var ringbuffer_end;
  /* This ring buffer holds a few past copy distances that will be used by */
  /* some special distance codes. */
  var dist_rb = [ 16, 15, 11, 4 ];
  var dist_rb_idx = 0;
  /* The previous 2 bytes used for context. */
  var prev_byte1 = 0;
  var prev_byte2 = 0;
  var hgroup = [new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0)];
  var block_type_trees;
  var block_len_trees;
  var br;

  /* We need the slack region for the following reasons:
       - always doing two 8-byte copies for fast backward copying
       - transforms
       - flushing the input ringbuffer when decoding uncompressed blocks */
  var kRingBufferWriteAheadSlack = 128 + BrotliBitReader.READ_SIZE;

  br = new BrotliBitReader(input);

  /* Decode window size. */
  window_bits = DecodeWindowBits(br);
  max_backward_distance = (1 << window_bits) - 16;

  ringbuffer_size = 1 << window_bits;
  ringbuffer_mask = ringbuffer_size - 1;
  ringbuffer = new Uint8Array(ringbuffer_size + kRingBufferWriteAheadSlack + BrotliDictionary.maxDictionaryWordLength);
  ringbuffer_end = ringbuffer_size;

  block_type_trees = [];
  block_len_trees = [];
  for (var x = 0; x < 3 * HUFFMAN_MAX_TABLE_SIZE; x++) {
    block_type_trees[x] = new HuffmanCode(0, 0);
    block_len_trees[x] = new HuffmanCode(0, 0);
  }

  while (!input_end) {
    var meta_block_remaining_len = 0;
    var is_uncompressed;
    var block_length = [ 1 << 28, 1 << 28, 1 << 28 ];
    var block_type = [ 0 ];
    var num_block_types = [ 1, 1, 1 ];
    var block_type_rb = [ 0, 1, 0, 1, 0, 1 ];
    var block_type_rb_index = [ 0 ];
    var distance_postfix_bits;
    var num_direct_distance_codes;
    var distance_postfix_mask;
    var num_distance_codes;
    var context_map = null;
    var context_modes = null;
    var num_literal_htrees;
    var dist_context_map = null;
    var num_dist_htrees;
    var context_offset = 0;
    var context_map_slice = null;
    var literal_htree_index = 0;
    var dist_context_offset = 0;
    var dist_context_map_slice = null;
    var dist_htree_index = 0;
    var context_lookup_offset1 = 0;
    var context_lookup_offset2 = 0;
    var context_mode;
    var htree_command;

    for (i = 0; i < 3; ++i) {
      hgroup[i].codes = null;
      hgroup[i].htrees = null;
    }

    br.readMoreInput();
    
    var _out = DecodeMetaBlockLength(br);
    meta_block_remaining_len = _out.meta_block_length;
    if (pos + meta_block_remaining_len > output.buffer.length) {
      /* We need to grow the output buffer to fit the additional data. */
      var tmp = new Uint8Array( pos + meta_block_remaining_len );
      tmp.set( output.buffer );
      output.buffer = tmp;
    }    
    input_end = _out.input_end;
    is_uncompressed = _out.is_uncompressed;
    
    if (_out.is_metadata) {
      JumpToByteBoundary(br);
      
      for (; meta_block_remaining_len > 0; --meta_block_remaining_len) {
        br.readMoreInput();
        /* Read one byte and ignore it. */
        br.readBits(8);
      }
      
      continue;
    }
    
    if (meta_block_remaining_len === 0) {
      continue;
    }
    
    if (is_uncompressed) {
      br.bit_pos_ = (br.bit_pos_ + 7) & ~7;
      CopyUncompressedBlockToOutput(output, meta_block_remaining_len, pos,
                                    ringbuffer, ringbuffer_mask, br);
      pos += meta_block_remaining_len;
      continue;
    }
    
    for (i = 0; i < 3; ++i) {
      num_block_types[i] = DecodeVarLenUint8(br) + 1;
      if (num_block_types[i] >= 2) {
        ReadHuffmanCode(num_block_types[i] + 2, block_type_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        ReadHuffmanCode(kNumBlockLengthCodes, block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_length[i] = ReadBlockLength(block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_type_rb_index[i] = 1;
      }
    }
    
    br.readMoreInput();
    
    distance_postfix_bits = br.readBits(2);
    num_direct_distance_codes = NUM_DISTANCE_SHORT_CODES + (br.readBits(4) << distance_postfix_bits);
    distance_postfix_mask = (1 << distance_postfix_bits) - 1;
    num_distance_codes = (num_direct_distance_codes + (48 << distance_postfix_bits));
    context_modes = new Uint8Array(num_block_types[0]);

    for (i = 0; i < num_block_types[0]; ++i) {
       br.readMoreInput();
       context_modes[i] = (br.readBits(2) << 1);
    }
    
    var _o1 = DecodeContextMap(num_block_types[0] << kLiteralContextBits, br);
    num_literal_htrees = _o1.num_htrees;
    context_map = _o1.context_map;
    
    var _o2 = DecodeContextMap(num_block_types[2] << kDistanceContextBits, br);
    num_dist_htrees = _o2.num_htrees;
    dist_context_map = _o2.context_map;
    
    hgroup[0] = new HuffmanTreeGroup(kNumLiteralCodes, num_literal_htrees);
    hgroup[1] = new HuffmanTreeGroup(kNumInsertAndCopyCodes, num_block_types[1]);
    hgroup[2] = new HuffmanTreeGroup(num_distance_codes, num_dist_htrees);

    for (i = 0; i < 3; ++i) {
      hgroup[i].decode(br);
    }

    context_map_slice = 0;
    dist_context_map_slice = 0;
    context_mode = context_modes[block_type[0]];
    context_lookup_offset1 = Context.lookupOffsets[context_mode];
    context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
    htree_command = hgroup[1].htrees[0];

    while (meta_block_remaining_len > 0) {
      var cmd_code;
      var range_idx;
      var insert_code;
      var copy_code;
      var insert_length;
      var copy_length;
      var distance_code;
      var distance;
      var context;
      var j;
      var copy_dst;

      br.readMoreInput();
      
      if (block_length[1] === 0) {
        DecodeBlockType(num_block_types[1],
                        block_type_trees, 1, block_type, block_type_rb,
                        block_type_rb_index, br);
        block_length[1] = ReadBlockLength(block_len_trees, HUFFMAN_MAX_TABLE_SIZE, br);
        htree_command = hgroup[1].htrees[block_type[1]];
      }
      --block_length[1];
      cmd_code = ReadSymbol(hgroup[1].codes, htree_command, br);
      range_idx = cmd_code >> 6;
      if (range_idx >= 2) {
        range_idx -= 2;
        distance_code = -1;
      } else {
        distance_code = 0;
      }
      insert_code = Prefix.kInsertRangeLut[range_idx] + ((cmd_code >> 3) & 7);
      copy_code = Prefix.kCopyRangeLut[range_idx] + (cmd_code & 7);
      insert_length = Prefix.kInsertLengthPrefixCode[insert_code].offset +
          br.readBits(Prefix.kInsertLengthPrefixCode[insert_code].nbits);
      copy_length = Prefix.kCopyLengthPrefixCode[copy_code].offset +
          br.readBits(Prefix.kCopyLengthPrefixCode[copy_code].nbits);
      prev_byte1 = ringbuffer[pos-1 & ringbuffer_mask];
      prev_byte2 = ringbuffer[pos-2 & ringbuffer_mask];
      for (j = 0; j < insert_length; ++j) {
        br.readMoreInput();

        if (block_length[0] === 0) {
          DecodeBlockType(num_block_types[0],
                          block_type_trees, 0, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[0] = ReadBlockLength(block_len_trees, 0, br);
          context_offset = block_type[0] << kLiteralContextBits;
          context_map_slice = context_offset;
          context_mode = context_modes[block_type[0]];
          context_lookup_offset1 = Context.lookupOffsets[context_mode];
          context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
        }
        context = (Context.lookup[context_lookup_offset1 + prev_byte1] |
                   Context.lookup[context_lookup_offset2 + prev_byte2]);
        literal_htree_index = context_map[context_map_slice + context];
        --block_length[0];
        prev_byte2 = prev_byte1;
        prev_byte1 = ReadSymbol(hgroup[0].codes, hgroup[0].htrees[literal_htree_index], br);
        ringbuffer[pos & ringbuffer_mask] = prev_byte1;
        if ((pos & ringbuffer_mask) === ringbuffer_mask) {
          output.write(ringbuffer, ringbuffer_size);
        }
        ++pos;
      }
      meta_block_remaining_len -= insert_length;
      if (meta_block_remaining_len <= 0) break;

      if (distance_code < 0) {
        var context;
        
        br.readMoreInput();
        if (block_length[2] === 0) {
          DecodeBlockType(num_block_types[2],
                          block_type_trees, 2, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[2] = ReadBlockLength(block_len_trees, 2 * HUFFMAN_MAX_TABLE_SIZE, br);
          dist_context_offset = block_type[2] << kDistanceContextBits;
          dist_context_map_slice = dist_context_offset;
        }
        --block_length[2];
        context = (copy_length > 4 ? 3 : copy_length - 2) & 0xff;
        dist_htree_index = dist_context_map[dist_context_map_slice + context];
        distance_code = ReadSymbol(hgroup[2].codes, hgroup[2].htrees[dist_htree_index], br);
        if (distance_code >= num_direct_distance_codes) {
          var nbits;
          var postfix;
          var offset;
          distance_code -= num_direct_distance_codes;
          postfix = distance_code & distance_postfix_mask;
          distance_code >>= distance_postfix_bits;
          nbits = (distance_code >> 1) + 1;
          offset = ((2 + (distance_code & 1)) << nbits) - 4;
          distance_code = num_direct_distance_codes +
              ((offset + br.readBits(nbits)) <<
               distance_postfix_bits) + postfix;
        }
      }

      /* Convert the distance code to the actual distance by possibly looking */
      /* up past distnaces from the ringbuffer. */
      distance = TranslateShortCodes(distance_code, dist_rb, dist_rb_idx);
      if (distance < 0) {
        throw new Error('[BrotliDecompress] invalid distance');
      }

      if (pos < max_backward_distance &&
          max_distance !== max_backward_distance) {
        max_distance = pos;
      } else {
        max_distance = max_backward_distance;
      }

      copy_dst = pos & ringbuffer_mask;

      if (distance > max_distance) {
        if (copy_length >= BrotliDictionary.minDictionaryWordLength &&
            copy_length <= BrotliDictionary.maxDictionaryWordLength) {
          var offset = BrotliDictionary.offsetsByLength[copy_length];
          var word_id = distance - max_distance - 1;
          var shift = BrotliDictionary.sizeBitsByLength[copy_length];
          var mask = (1 << shift) - 1;
          var word_idx = word_id & mask;
          var transform_idx = word_id >> shift;
          offset += word_idx * copy_length;
          if (transform_idx < Transform.kNumTransforms) {
            var len = Transform.transformDictionaryWord(ringbuffer, copy_dst, offset, copy_length, transform_idx);
            copy_dst += len;
            pos += len;
            meta_block_remaining_len -= len;
            if (copy_dst >= ringbuffer_end) {
              output.write(ringbuffer, ringbuffer_size);
              
              for (var _x = 0; _x < (copy_dst - ringbuffer_end); _x++)
                ringbuffer[_x] = ringbuffer[ringbuffer_end + _x];
            }
          } else {
            throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
              " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
          }
        } else {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }
      } else {
        if (distance_code > 0) {
          dist_rb[dist_rb_idx & 3] = distance;
          ++dist_rb_idx;
        }

        if (copy_length > meta_block_remaining_len) {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }

        for (j = 0; j < copy_length; ++j) {
          ringbuffer[pos & ringbuffer_mask] = ringbuffer[(pos - distance) & ringbuffer_mask];
          if ((pos & ringbuffer_mask) === ringbuffer_mask) {
            output.write(ringbuffer, ringbuffer_size);
          }
          ++pos;
          --meta_block_remaining_len;
        }
      }

      /* When we get here, we must have inserted at least one literal and */
      /* made a copy of at least length two, therefore accessing the last 2 */
      /* bytes is valid. */
      prev_byte1 = ringbuffer[(pos - 1) & ringbuffer_mask];
      prev_byte2 = ringbuffer[(pos - 2) & ringbuffer_mask];
    }

    /* Protect pos from overflow, wrap it around at every GB of input data */
    pos &= 0x3fffffff;
  }

  output.write(ringbuffer, pos & ringbuffer_mask);
}

exports.BrotliDecompress = BrotliDecompress;

BrotliDictionary.init();


/***/ }),
/* 118 */
/***/ (function(module, exports) {

function BrotliInput(buffer) {
  this.buffer = buffer;
  this.pos = 0;
}

BrotliInput.prototype.read = function(buf, i, count) {
  if (this.pos + count > this.buffer.length) {
    count = this.buffer.length - this.pos;
  }
  
  for (var p = 0; p < count; p++)
    buf[i + p] = this.buffer[this.pos + p];
  
  this.pos += count;
  return count;
}

exports.BrotliInput = BrotliInput;

function BrotliOutput(buf) {
  this.buffer = buf;
  this.pos = 0;
}

BrotliOutput.prototype.write = function(buf, count) {
  if (this.pos + count > this.buffer.length)
    throw new Error('Output buffer is not large enough');
  
  this.buffer.set(buf.subarray(0, count), this.pos);
  this.pos += count;
  return count;
};

exports.BrotliOutput = BrotliOutput;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Collection of static dictionary words.
*/

var data = __webpack_require__(286);
exports.init = function() {
  exports.dictionary = data.init();
};

exports.offsetsByLength = new Uint32Array([
     0,     0,     0,     0,     0,  4096,  9216, 21504, 35840, 44032,
 53248, 63488, 74752, 87040, 93696, 100864, 104704, 106752, 108928, 113536,
 115968, 118528, 119872, 121280, 122016,
]);

exports.sizeBitsByLength = new Uint8Array([
  0,  0,  0,  0, 10, 10, 11, 11, 10, 10,
 10, 10, 10,  9,  9,  8,  7,  7,  8,  7,
  7,  6,  6,  5,  5,
]);

exports.minDictionaryWordLength = 4;
exports.maxDictionaryWordLength = 24;


/***/ }),
/* 120 */
/***/ (function(module, exports) {

function HuffmanCode(bits, value) {
  this.bits = bits;   /* number of bits used for this symbol */
  this.value = value; /* symbol value or table offset */
}

exports.HuffmanCode = HuffmanCode;

var MAX_LENGTH = 15;

/* Returns reverse(reverse(key, len) + 1, len), where reverse(key, len) is the
   bit-wise reversal of the len least significant bits of key. */
function GetNextKey(key, len) {
  var step = 1 << (len - 1);
  while (key & step) {
    step >>= 1;
  }
  return (key & (step - 1)) + step;
}

/* Stores code in table[0], table[step], table[2*step], ..., table[end] */
/* Assumes that end is an integer multiple of step */
function ReplicateValue(table, i, step, end, code) {
  do {
    end -= step;
    table[i + end] = new HuffmanCode(code.bits, code.value);
  } while (end > 0);
}

/* Returns the table width of the next 2nd level table. count is the histogram
   of bit lengths for the remaining symbols, len is the code length of the next
   processed symbol */
function NextTableBitSize(count, len, root_bits) {
  var left = 1 << (len - root_bits);
  while (len < MAX_LENGTH) {
    left -= count[len];
    if (left <= 0) break;
    ++len;
    left <<= 1;
  }
  return len - root_bits;
}

exports.BrotliBuildHuffmanTable = function(root_table, table, root_bits, code_lengths, code_lengths_size) {
  var start_table = table;
  var code;            /* current table entry */
  var len;             /* current code length */
  var symbol;          /* symbol index in original or sorted table */
  var key;             /* reversed prefix code */
  var step;            /* step size to replicate values in current table */
  var low;             /* low bits for current root entry */
  var mask;            /* mask for low bits */
  var table_bits;      /* key length of current table */
  var table_size;      /* size of current table */
  var total_size;      /* sum of root table size and 2nd level table sizes */
  var sorted;          /* symbols sorted by code length */
  var count = new Int32Array(MAX_LENGTH + 1);  /* number of codes of each length */
  var offset = new Int32Array(MAX_LENGTH + 1);  /* offsets in sorted table for each length */

  sorted = new Int32Array(code_lengths_size);

  /* build histogram of code lengths */
  for (symbol = 0; symbol < code_lengths_size; symbol++) {
    count[code_lengths[symbol]]++;
  }

  /* generate offsets into sorted symbol table by code length */
  offset[1] = 0;
  for (len = 1; len < MAX_LENGTH; len++) {
    offset[len + 1] = offset[len] + count[len];
  }

  /* sort symbols by length, by symbol order within each length */
  for (symbol = 0; symbol < code_lengths_size; symbol++) {
    if (code_lengths[symbol] !== 0) {
      sorted[offset[code_lengths[symbol]]++] = symbol;
    }
  }
  
  table_bits = root_bits;
  table_size = 1 << table_bits;
  total_size = table_size;

  /* special case code with only one value */
  if (offset[MAX_LENGTH] === 1) {
    for (key = 0; key < total_size; ++key) {
      root_table[table + key] = new HuffmanCode(0, sorted[0] & 0xffff);
    }
    
    return total_size;
  }

  /* fill in root table */
  key = 0;
  symbol = 0;
  for (len = 1, step = 2; len <= root_bits; ++len, step <<= 1) {
    for (; count[len] > 0; --count[len]) {
      code = new HuffmanCode(len & 0xff, sorted[symbol++] & 0xffff);
      ReplicateValue(root_table, table + key, step, table_size, code);
      key = GetNextKey(key, len);
    }
  }

  /* fill in 2nd level tables and add pointers to root table */
  mask = total_size - 1;
  low = -1;
  for (len = root_bits + 1, step = 2; len <= MAX_LENGTH; ++len, step <<= 1) {
    for (; count[len] > 0; --count[len]) {
      if ((key & mask) !== low) {
        table += table_size;
        table_bits = NextTableBitSize(count, len, root_bits);
        table_size = 1 << table_bits;
        total_size += table_size;
        low = key & mask;
        root_table[start_table + low] = new HuffmanCode((table_bits + root_bits) & 0xff, ((table - start_table) - low) & 0xffff);
      }
      code = new HuffmanCode((len - root_bits) & 0xff, sorted[symbol++] & 0xffff);
      ReplicateValue(root_table, table + (key >> root_bits), step, table_size, code);
      key = GetNextKey(key, len);
    }
  }
  
  return total_size;
}


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

/*
PDFImage - embeds images in PDF documents
By Devon Govett
 */

(function() {
  var Data, JPEG, PDFImage, PNG, fs;

  fs = __webpack_require__(8);

  Data = __webpack_require__(298);

  JPEG = __webpack_require__(299);

  PNG = __webpack_require__(300);

  PDFImage = (function() {
    function PDFImage() {}

    PDFImage.open = function(src, label) {
      var data, match;
      if (Buffer.isBuffer(src)) {
        data = src;
      } else if (src instanceof ArrayBuffer) {
        data = new Buffer(new Uint8Array(src));
      } else {
        if (match = /^data:.+;base64,(.*)$/.exec(src)) {
          data = new Buffer(match[1], 'base64');
        } else {
          data = fs.readFileSync(src);
          if (!data) {
            return;
          }
        }
      }
      if (data[0] === 0xff && data[1] === 0xd8) {
        return new JPEG(data, label);
      } else if (data[0] === 0x89 && data.toString('ascii', 1, 4) === 'PNG') {
        return new PNG(data, label);
      } else {
        throw new Error('Unknown image format.');
      }
    };

    return PDFImage;

  })();

  module.exports = PDFImage;

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {module.exports = global["pdfMake"] = __webpack_require__(123);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7)))

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer, global) {

var PdfPrinter = __webpack_require__(126);
var isFunction = __webpack_require__(0).isFunction;
var FileSaver = __webpack_require__(306);
var saveAs = FileSaver.saveAs;

var defaultClientFonts = {
	Roboto: {
		normal: 'Roboto-Regular.ttf',
		bold: 'Roboto-Medium.ttf',
		italics: 'Roboto-Italic.ttf',
		bolditalics: 'Roboto-MediumItalic.ttf'
	}
};

function Document(docDefinition, tableLayouts, fonts, vfs) {
	this.docDefinition = docDefinition;
	this.tableLayouts = tableLayouts || null;
	this.fonts = fonts || defaultClientFonts;
	this.vfs = vfs;
}

function canCreatePdf() {
	// Ensure the browser provides the level of support needed
	if (!Object.keys) {
		return false;
	}
	return true;
}

Document.prototype._createDoc = function (options, callback) {
	options = options || {};
	if (this.tableLayouts) {
		options.tableLayouts = this.tableLayouts;
	}

	var printer = new PdfPrinter(this.fonts);
	__webpack_require__(8).bindFS(this.vfs); // bind virtual file system to file system

	var doc = printer.createPdfKitDocument(this.docDefinition, options);
	var chunks = [];
	var result;

	doc.on('readable', function () {
		var chunk;
		while ((chunk = doc.read(9007199254740991)) !== null) {
			chunks.push(chunk);
		}
	});
	doc.on('end', function () {
		result = Buffer.concat(chunks);
		callback(result, doc._pdfMakePages);
	});
	doc.end();
};

Document.prototype._getPages = function (options, cb) {
	if (!cb) {
		throw '_getPages is an async method and needs a callback argument';
	}
	this._createDoc(options, function (ignoreBuffer, pages) {
		cb(pages);
	});
};

Document.prototype._bufferToBlob = function (buffer) {
	var blob;
	try {
		blob = new Blob([buffer], {type: 'application/pdf'});
	} catch (e) {
		// Old browser which can't handle it without making it an byte array (ie10)
		if (e.name === 'InvalidStateError') {
			var byteArray = new Uint8Array(buffer);
			blob = new Blob([byteArray.buffer], {type: 'application/pdf'});
		}
	}

	if (!blob) {
		throw 'Could not generate blob';
	}

	return blob;
};

Document.prototype._openWindow = function () {
	// we have to open the window immediately and store the reference
	// otherwise popup blockers will stop us
	var win = window.open('', '_blank');
	if (win === null) {
		throw 'Open PDF in new window blocked by browser';
	}

	return win;
};

Document.prototype._openPdf = function (options, win) {
	if (!win) {
		win = this._openWindow();
	}
	try {
		this.getBlob(function (result) {
			var urlCreator = window.URL || window.webkitURL;
			var pdfUrl = urlCreator.createObjectURL(result);
			win.location.href = pdfUrl;
		}, options);
	} catch (e) {
		win.close();
		throw e;
	}
};

Document.prototype.open = function (options, win) {
	options = options || {};
	options.autoPrint = false;
	win = win || null;

	this._openPdf(options, win);
};


Document.prototype.print = function (options, win) {
	options = options || {};
	options.autoPrint = true;
	win = win || null;

	this._openPdf(options, win);
};

Document.prototype.download = function (defaultFileName, cb, options) {
	if (isFunction(defaultFileName)) {
		cb = defaultFileName;
		defaultFileName = null;
	}

	defaultFileName = defaultFileName || 'file.pdf';
	this.getBlob(function (result) {
		saveAs(result, defaultFileName);

		if (isFunction(cb)) {
			cb();
		}
	}, options);
};

Document.prototype.getBase64 = function (cb, options) {
	if (!cb) {
		throw 'getBase64 is an async method and needs a callback argument';
	}
	this.getBuffer(function (buffer) {
		cb(buffer.toString('base64'));
	}, options);
};

Document.prototype.getDataUrl = function (cb, options) {
	if (!cb) {
		throw 'getDataUrl is an async method and needs a callback argument';
	}
	this.getBuffer(function (buffer) {
		cb('data:application/pdf;base64,' + buffer.toString('base64'));
	}, options);
};

Document.prototype.getBlob = function (cb, options) {
	if (!cb) {
		throw 'getBlob is an async method and needs a callback argument';
	}
	var that = this;
	this.getBuffer(function (result) {
		var blob = that._bufferToBlob(result);
		cb(blob);
	}, options);
};

Document.prototype.getBuffer = function (cb, options) {
	if (!cb) {
		throw 'getBuffer is an async method and needs a callback argument';
	}
	this._createDoc(options, function (buffer) {
		cb(buffer);
	});
};

module.exports = {
	createPdf: function (docDefinition) {
		if (!canCreatePdf()) {
			throw 'Your browser does not provide the level of support needed';
		}
		return new Document(docDefinition, global.pdfMake.tableLayouts, global.pdfMake.fonts, global.pdfMake.vfs);
	}
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer, __webpack_require__(7)))

/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function placeHoldersCount (b64) {
  var len = b64.length
  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // the number of equal signs (place holders)
  // if there are two placeholders, than the two characters before it
  // represent one byte
  // if there is only one, then the three characters before it represent 2 bytes
  // this is just a cheap hack to not do indexOf twice
  return b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0
}

function byteLength (b64) {
  // base64 is 4/3 + up to two characters of the original data
  return (b64.length * 3 / 4) - placeHoldersCount(b64)
}

function toByteArray (b64) {
  var i, l, tmp, placeHolders, arr
  var len = b64.length
  placeHolders = placeHoldersCount(b64)

  arr = new Arr((len * 3 / 4) - placeHolders)

  // if there are placeholders, only get up to the last complete 4 chars
  l = placeHolders > 0 ? len - 4 : len

  var L = 0

  for (i = 0; i < l; i += 4) {
    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]
    arr[L++] = (tmp >> 16) & 0xFF
    arr[L++] = (tmp >> 8) & 0xFF
    arr[L++] = tmp & 0xFF
  }

  if (placeHolders === 2) {
    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[L++] = tmp & 0xFF
  } else if (placeHolders === 1) {
    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[L++] = (tmp >> 8) & 0xFF
    arr[L++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp = ((uint8[i] << 16) & 0xFF0000) + ((uint8[i + 1] << 8) & 0xFF00) + (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var output = ''
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    output += lookup[tmp >> 2]
    output += lookup[(tmp << 4) & 0x3F]
    output += '=='
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])
    output += lookup[tmp >> 10]
    output += lookup[(tmp >> 4) & 0x3F]
    output += lookup[(tmp << 2) & 0x3F]
    output += '='
  }

  parts.push(output)

  return parts.join('')
}


/***/ }),
/* 125 */
/***/ (function(module, exports) {

exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = nBytes * 8 - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = nBytes * 8 - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*eslint no-unused-vars: ["error", {"args": "none"}]*/


var FontProvider = __webpack_require__(127);
var LayoutBuilder = __webpack_require__(128);
var PdfKit = __webpack_require__(138);
var sizes = __webpack_require__(303);
var ImageMeasure = __webpack_require__(304);
var textDecorator = __webpack_require__(305);
var TextTools = __webpack_require__(42);
var isFunction = __webpack_require__(0).isFunction;
var isString = __webpack_require__(0).isString;
var isNumber = __webpack_require__(0).isNumber;
var isBoolean = __webpack_require__(0).isBoolean;
var isArray = __webpack_require__(0).isArray;

////////////////////////////////////////
// PdfPrinter

/**
 * @class Creates an instance of a PdfPrinter which turns document definition into a pdf
 *
 * @param {Object} fontDescriptors font definition dictionary
 *
 * @example
 * var fontDescriptors = {
 *	Roboto: {
 *		normal: 'fonts/Roboto-Regular.ttf',
 *		bold: 'fonts/Roboto-Medium.ttf',
 *		italics: 'fonts/Roboto-Italic.ttf',
 *		bolditalics: 'fonts/Roboto-MediumItalic.ttf'
 *	}
 * };
 *
 * var printer = new PdfPrinter(fontDescriptors);
 */
function PdfPrinter(fontDescriptors) {
	this.fontDescriptors = fontDescriptors;
}

/**
 * Executes layout engine for the specified document and renders it into a pdfkit document
 * ready to be saved.
 *
 * @param {Object} docDefinition document definition
 * @param {Object} docDefinition.content an array describing the pdf structure (for more information take a look at the examples in the /examples folder)
 * @param {Object} [docDefinition.defaultStyle] default (implicit) style definition
 * @param {Object} [docDefinition.styles] dictionary defining all styles which can be used in the document
 * @param {Object} [docDefinition.pageSize] page size (pdfkit units, A4 dimensions by default)
 * @param {Number} docDefinition.pageSize.width width
 * @param {Number} docDefinition.pageSize.height height
 * @param {Object} [docDefinition.pageMargins] page margins (pdfkit units)
 * @param {Number} docDefinition.maxPagesNumber maximum number of pages to render
 *
 * @example
 *
 * var docDefinition = {
 * 	info: {
 *		title: 'awesome Document',
 *		author: 'john doe',
 *		subject: 'subject of document',
 *		keywords: 'keywords for document',
 * 	},
 *	content: [
 *		'First paragraph',
 *		'Second paragraph, this time a little bit longer',
 *		{ text: 'Third paragraph, slightly bigger font size', fontSize: 20 },
 *		{ text: 'Another paragraph using a named style', style: 'header' },
 *		{ text: ['playing with ', 'inlines' ] },
 *		{ text: ['and ', { text: 'restyling ', bold: true }, 'them'] },
 *	],
 *	styles: {
 *		header: { fontSize: 30, bold: true }
 *	}
 * }
 *
 * var pdfKitDoc = printer.createPdfKitDocument(docDefinition);
 *
 * pdfKitDoc.pipe(fs.createWriteStream('sample.pdf'));
 * pdfKitDoc.end();
 *
 * @return {Object} a pdfKit document object which can be saved or encode to data-url
 */
PdfPrinter.prototype.createPdfKitDocument = function (docDefinition, options) {
	options = options || {};

	var pageSize = fixPageSize(docDefinition.pageSize, docDefinition.pageOrientation);
	var compressPdf = isBoolean(docDefinition.compress) ? docDefinition.compress : true;

	this.pdfKitDoc = new PdfKit({size: [pageSize.width, pageSize.height], autoFirstPage: false, compress: compressPdf});
	setMetadata(docDefinition, this.pdfKitDoc);

	this.fontProvider = new FontProvider(this.fontDescriptors, this.pdfKitDoc);

	docDefinition.images = docDefinition.images || {};

	var builder = new LayoutBuilder(pageSize, fixPageMargins(docDefinition.pageMargins || 40), new ImageMeasure(this.pdfKitDoc, docDefinition.images));

	registerDefaultTableLayouts(builder);
	if (options.tableLayouts) {
		builder.registerTableLayouts(options.tableLayouts);
	}

	var pages = builder.layoutDocument(docDefinition.content, this.fontProvider, docDefinition.styles || {}, docDefinition.defaultStyle || {fontSize: 12, font: 'Roboto'}, docDefinition.background, docDefinition.header, docDefinition.footer, docDefinition.images, docDefinition.watermark, docDefinition.pageBreakBefore);
	var maxNumberPages = docDefinition.maxPagesNumber || -1;
	if (isNumber(maxNumberPages) && maxNumberPages > -1) {
		pages = pages.slice(0, maxNumberPages);
	}

	// if pageSize.height is set to Infinity, calculate the actual height of the page that
	// was laid out using the height of each of the items in the page.
	if (pageSize.height === Infinity) {
		var pageHeight = calculatePageHeight(pages, docDefinition.pageMargins);
		this.pdfKitDoc.options.size = [pageSize.width, pageHeight];
	}

	renderPages(pages, this.fontProvider, this.pdfKitDoc, options.progressCallback);

	if (options.autoPrint) {
		var printActionRef = this.pdfKitDoc.ref({
			Type: 'Action',
			S: 'Named',
			N: 'Print'
		});
		this.pdfKitDoc._root.data.OpenAction = printActionRef;
		printActionRef.end();
	}
	return this.pdfKitDoc;
};

function setMetadata(docDefinition, pdfKitDoc) {
	// PDF standard has these properties reserved: Title, Author, Subject, Keywords,
	// Creator, Producer, CreationDate, ModDate, Trapped.
	// To keep the pdfmake api consistent, the info field are defined lowercase.
	// Custom properties don't contain a space.
	function standardizePropertyKey(key) {
		var standardProperties = ['Title', 'Author', 'Subject', 'Keywords',
			'Creator', 'Producer', 'CreationDate', 'ModDate', 'Trapped'];
		var standardizedKey = key.charAt(0).toUpperCase() + key.slice(1);
		if (standardProperties.indexOf(standardizedKey) !== -1) {
			return standardizedKey;
		}

		return key.replace(/\s+/g, '');
	}

	pdfKitDoc.info.Producer = 'pdfmake';
	pdfKitDoc.info.Creator = 'pdfmake';

	if (docDefinition.info) {
		for (var key in docDefinition.info) {
			var value = docDefinition.info[key];
			if (value) {
				key = standardizePropertyKey(key);
				pdfKitDoc.info[key] = value;
			}
		}
	}
}

function calculatePageHeight(pages, margins) {
	function getItemHeight(item) {
		if (isFunction(item.item.getHeight)) {
			return item.item.getHeight();
		} else if (item.item._height) {
			return item.item._height;
		} else {
			// TODO: add support for next item types
			return 0;
		}
	}

	var fixedMargins = fixPageMargins(margins || 40);
	var height = fixedMargins.top + fixedMargins.bottom;
	pages.forEach(function (page) {
		page.items.forEach(function (item) {
			height += getItemHeight(item);
		});
	});
	return height;
}

function fixPageSize(pageSize, pageOrientation) {
	function isNeedSwapPageSizes(pageOrientation) {
		if (isString(pageOrientation)) {
			pageOrientation = pageOrientation.toLowerCase();
			return ((pageOrientation === 'portrait') && (size.width > size.height)) ||
				((pageOrientation === 'landscape') && (size.width < size.height));
		}
		return false;
	}

	// if pageSize.height is set to auto, set the height to infinity so there are no page breaks.
	if (pageSize && pageSize.height === 'auto') {
		pageSize.height = Infinity;
	}

	var size = pageSize2widthAndHeight(pageSize || 'A4');
	if (isNeedSwapPageSizes(pageOrientation)) { // swap page sizes
		size = {width: size.height, height: size.width};
	}
	size.orientation = size.width > size.height ? 'landscape' : 'portrait';
	return size;
}

function fixPageMargins(margin) {
	if (!margin) {
		return null;
	}

	if (isNumber(margin)) {
		margin = {left: margin, right: margin, top: margin, bottom: margin};
	} else if (isArray(margin)) {
		if (margin.length === 2) {
			margin = {left: margin[0], top: margin[1], right: margin[0], bottom: margin[1]};
		} else if (margin.length === 4) {
			margin = {left: margin[0], top: margin[1], right: margin[2], bottom: margin[3]};
		} else {
			throw 'Invalid pageMargins definition';
		}
	}

	return margin;
}

function registerDefaultTableLayouts(layoutBuilder) {
	layoutBuilder.registerTableLayouts({
		noBorders: {
			hLineWidth: function (i) {
				return 0;
			},
			vLineWidth: function (i) {
				return 0;
			},
			paddingLeft: function (i) {
				return i && 4 || 0;
			},
			paddingRight: function (i, node) {
				return (i < node.table.widths.length - 1) ? 4 : 0;
			}
		},
		headerLineOnly: {
			hLineWidth: function (i, node) {
				if (i === 0 || i === node.table.body.length) {
					return 0;
				}
				return (i === node.table.headerRows) ? 2 : 0;
			},
			vLineWidth: function (i) {
				return 0;
			},
			paddingLeft: function (i) {
				return i === 0 ? 0 : 8;
			},
			paddingRight: function (i, node) {
				return (i === node.table.widths.length - 1) ? 0 : 8;
			}
		},
		lightHorizontalLines: {
			hLineWidth: function (i, node) {
				if (i === 0 || i === node.table.body.length) {
					return 0;
				}
				return (i === node.table.headerRows) ? 2 : 1;
			},
			vLineWidth: function (i) {
				return 0;
			},
			hLineColor: function (i) {
				return i === 1 ? 'black' : '#aaa';
			},
			paddingLeft: function (i) {
				return i === 0 ? 0 : 8;
			},
			paddingRight: function (i, node) {
				return (i === node.table.widths.length - 1) ? 0 : 8;
			}
		}
	});
}

function pageSize2widthAndHeight(pageSize) {
	if (isString(pageSize)) {
		var size = sizes[pageSize.toUpperCase()];
		if (!size) {
			throw 'Page size ' + pageSize + ' not recognized';
		}
		return {width: size[0], height: size[1]};
	}

	return pageSize;
}

function updatePageOrientationInOptions(currentPage, pdfKitDoc) {
	var previousPageOrientation = pdfKitDoc.options.size[0] > pdfKitDoc.options.size[1] ? 'landscape' : 'portrait';

	if (currentPage.pageSize.orientation !== previousPageOrientation) {
		var width = pdfKitDoc.options.size[0];
		var height = pdfKitDoc.options.size[1];
		pdfKitDoc.options.size = [height, width];
	}
}

function renderPages(pages, fontProvider, pdfKitDoc, progressCallback) {
	pdfKitDoc._pdfMakePages = pages;
	pdfKitDoc.addPage();

	var totalItems = 0;
	if (progressCallback) {
		pages.forEach(function (page) {
			totalItems += page.items.length;
		});
	}

	var renderedItems = 0;
	progressCallback = progressCallback || function () {};

	for (var i = 0; i < pages.length; i++) {
		if (i > 0) {
			updatePageOrientationInOptions(pages[i], pdfKitDoc);
			pdfKitDoc.addPage(pdfKitDoc.options);
		}

		var page = pages[i];
		for (var ii = 0, il = page.items.length; ii < il; ii++) {
			var item = page.items[ii];
			switch (item.type) {
				case 'vector':
					renderVector(item.item, pdfKitDoc);
					break;
				case 'line':
					renderLine(item.item, item.item.x, item.item.y, pdfKitDoc);
					break;
				case 'image':
					renderImage(item.item, item.item.x, item.item.y, pdfKitDoc);
					break;
				case 'beginClip':
					beginClip(item.item, pdfKitDoc);
					break;
				case 'endClip':
					endClip(pdfKitDoc);
					break;
			}
			renderedItems++;
			progressCallback(renderedItems / totalItems);
		}
		if (page.watermark) {
			renderWatermark(page, pdfKitDoc);
		}
	}
}

function renderLine(line, x, y, pdfKitDoc) {
	if (line._pageNodeRef) {
		var newWidth;
		var diffWidth;
		var textTools = new TextTools(null);
		var pageNumber = line._pageNodeRef.positions[0].pageNumber.toString();

		line.inlines[0].text = pageNumber;
		line.inlines[0].linkToPage = pageNumber;
		newWidth = textTools.widthOfString(line.inlines[0].text, line.inlines[0].font, line.inlines[0].fontSize, line.inlines[0].characterSpacing, line.inlines[0].fontFeatures);
		diffWidth = line.inlines[0].width - newWidth;
		line.inlines[0].width = newWidth;

		switch (line.inlines[0].alignment) {
			case 'right':
				line.inlines[0].x += diffWidth;
				break;
			case 'center':
				line.inlines[0].x += diffWidth / 2;
				break;
		}
	}

	x = x || 0;
	y = y || 0;

	var lineHeight = line.getHeight();
	var ascenderHeight = line.getAscenderHeight();
	var descent = lineHeight - ascenderHeight;

	textDecorator.drawBackground(line, x, y, pdfKitDoc);

	//TODO: line.optimizeInlines();
	for (var i = 0, l = line.inlines.length; i < l; i++) {
		var inline = line.inlines[i];
		var shiftToBaseline = lineHeight - ((inline.font.ascender / 1000) * inline.fontSize) - descent;
		var options = {
			lineBreak: false,
			textWidth: inline.width,
			characterSpacing: inline.characterSpacing,
			wordCount: 1,
			link: inline.link
		};

		if (inline.fontFeatures) {
			options.features = inline.fontFeatures;
		}

		pdfKitDoc.fill(inline.color || 'black');

		pdfKitDoc._font = inline.font;
		pdfKitDoc.fontSize(inline.fontSize);
		pdfKitDoc.text(inline.text, x + inline.x, y + shiftToBaseline, options);

		if (inline.linkToPage) {
			var _ref = pdfKitDoc.ref({Type: 'Action', S: 'GoTo', D: [inline.linkToPage, 0, 0]}).end();
			pdfKitDoc.annotate(x + inline.x, y + shiftToBaseline, inline.width, inline.height, {Subtype: 'Link', Dest: [inline.linkToPage - 1, 'XYZ', null, null, null]});
		}

	}

	textDecorator.drawDecorations(line, x, y, pdfKitDoc);
}

function renderWatermark(page, pdfKitDoc) {
	var watermark = page.watermark;

	pdfKitDoc.fill(watermark.color);
	pdfKitDoc.opacity(watermark.opacity);

	pdfKitDoc.save();

	var angle = Math.atan2(pdfKitDoc.page.height, pdfKitDoc.page.width) * -180 / Math.PI;
	pdfKitDoc.rotate(angle, {origin: [pdfKitDoc.page.width / 2, pdfKitDoc.page.height / 2]});

	var x = pdfKitDoc.page.width / 2 - watermark.size.size.width / 2;
	var y = pdfKitDoc.page.height / 2 - watermark.size.size.height / 4;

	pdfKitDoc._font = watermark.font;
	pdfKitDoc.fontSize(watermark.size.fontSize);
	pdfKitDoc.text(watermark.text, x, y, {lineBreak: false});

	pdfKitDoc.restore();
}

function renderVector(vector, pdfKitDoc) {
	//TODO: pdf optimization (there's no need to write all properties everytime)
	pdfKitDoc.lineWidth(vector.lineWidth || 1);
	if (vector.dash) {
		pdfKitDoc.dash(vector.dash.length, {space: vector.dash.space || vector.dash.length, phase: vector.dash.phase || 0});
	} else {
		pdfKitDoc.undash();
	}
	pdfKitDoc.lineJoin(vector.lineJoin || 'miter');
	pdfKitDoc.lineCap(vector.lineCap || 'butt');

	//TODO: clipping

	switch (vector.type) {
		case 'ellipse':
			pdfKitDoc.ellipse(vector.x, vector.y, vector.r1, vector.r2);
			break;
		case 'rect':
			if (vector.r) {
				pdfKitDoc.roundedRect(vector.x, vector.y, vector.w, vector.h, vector.r);
			} else {
				pdfKitDoc.rect(vector.x, vector.y, vector.w, vector.h);
			}

			if (vector.linearGradient) {
				var gradient = pdfKitDoc.linearGradient(vector.x, vector.y, vector.x + vector.w, vector.y);
				var step = 1 / (vector.linearGradient.length - 1);

				for (var i = 0; i < vector.linearGradient.length; i++) {
					gradient.stop(i * step, vector.linearGradient[i]);
				}

				vector.color = gradient;
			}
			break;
		case 'line':
			pdfKitDoc.moveTo(vector.x1, vector.y1);
			pdfKitDoc.lineTo(vector.x2, vector.y2);
			break;
		case 'polyline':
			if (vector.points.length === 0) {
				break;
			}

			pdfKitDoc.moveTo(vector.points[0].x, vector.points[0].y);
			for (var i = 1, l = vector.points.length; i < l; i++) {
				pdfKitDoc.lineTo(vector.points[i].x, vector.points[i].y);
			}

			if (vector.points.length > 1) {
				var p1 = vector.points[0];
				var pn = vector.points[vector.points.length - 1];

				if (vector.closePath || p1.x === pn.x && p1.y === pn.y) {
					pdfKitDoc.closePath();
				}
			}
			break;
		case 'path':
			pdfKitDoc.path(vector.d);
			break;
	}

	if (vector.color && vector.lineColor) {
		pdfKitDoc.fillColor(vector.color, vector.fillOpacity || 1);
		pdfKitDoc.strokeColor(vector.lineColor, vector.strokeOpacity || 1);
		pdfKitDoc.fillAndStroke();
	} else if (vector.color) {
		pdfKitDoc.fillColor(vector.color, vector.fillOpacity || 1);
		pdfKitDoc.fill();
	} else {
		pdfKitDoc.strokeColor(vector.lineColor || 'black', vector.strokeOpacity || 1);
		pdfKitDoc.stroke();
	}
}

function renderImage(image, x, y, pdfKitDoc) {
	pdfKitDoc.image(image.image, image.x, image.y, {width: image._width, height: image._height});
	if (image.link) {
		pdfKitDoc.link(image.x, image.y, image._width, image._height, image.link);
	}
}

function beginClip(rect, pdfKitDoc) {
	pdfKitDoc.save();
	pdfKitDoc.addContent('' + rect.x + ' ' + rect.y + ' ' + rect.width + ' ' + rect.height + ' re');
	pdfKitDoc.clip();
}

function endClip(pdfKitDoc) {
	pdfKitDoc.restore();
}

module.exports = PdfPrinter;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isArray = __webpack_require__(0).isArray;

function typeName(bold, italics) {
	var type = 'normal';
	if (bold && italics) {
		type = 'bolditalics';
	} else if (bold) {
		type = 'bold';
	} else if (italics) {
		type = 'italics';
	}
	return type;
}

function FontProvider(fontDescriptors, pdfKitDoc) {
	this.fonts = {};
	this.pdfKitDoc = pdfKitDoc;
	this.fontCache = {};

	for (var font in fontDescriptors) {
		if (fontDescriptors.hasOwnProperty(font)) {
			var fontDef = fontDescriptors[font];

			this.fonts[font] = {
				normal: fontDef.normal,
				bold: fontDef.bold,
				italics: fontDef.italics,
				bolditalics: fontDef.bolditalics
			};
		}
	}
}

FontProvider.prototype.provideFont = function (familyName, bold, italics) {
	var type = typeName(bold, italics);
	if (!this.fonts[familyName] || !this.fonts[familyName][type]) {
		throw new Error('Font \'' + familyName + '\' in style \'' + type + '\' is not defined in the font section of the document definition.');
	}

	this.fontCache[familyName] = this.fontCache[familyName] || {};

	if (!this.fontCache[familyName][type]) {
		var def = this.fonts[familyName][type];
		if (!isArray(def)) {
			def = [def];
		}
		this.fontCache[familyName][type] = this.pdfKitDoc.font.apply(this.pdfKitDoc, def)._font;
	}

	return this.fontCache[familyName][type];
};

module.exports = FontProvider;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var TraversalTracker = __webpack_require__(77);
var DocPreprocessor = __webpack_require__(129);
var DocMeasure = __webpack_require__(130);
var DocumentContext = __webpack_require__(81);
var PageElementWriter = __webpack_require__(135);
var ColumnCalculator = __webpack_require__(44);
var TableProcessor = __webpack_require__(137);
var Line = __webpack_require__(82);
var isString = __webpack_require__(0).isString;
var isArray = __webpack_require__(0).isArray;
var pack = __webpack_require__(0).pack;
var offsetVector = __webpack_require__(0).offsetVector;
var fontStringify = __webpack_require__(0).fontStringify;
var isFunction = __webpack_require__(0).isFunction;
var TextTools = __webpack_require__(42);
var StyleContextStack = __webpack_require__(80);

function addAll(target, otherArray) {
	otherArray.forEach(function (item) {
		target.push(item);
	});
}

/**
 * Creates an instance of LayoutBuilder - layout engine which turns document-definition-object
 * into a set of pages, lines, inlines and vectors ready to be rendered into a PDF
 *
 * @param {Object} pageSize - an object defining page width and height
 * @param {Object} pageMargins - an object defining top, left, right and bottom margins
 */
function LayoutBuilder(pageSize, pageMargins, imageMeasure) {
	this.pageSize = pageSize;
	this.pageMargins = pageMargins;
	this.tracker = new TraversalTracker();
	this.imageMeasure = imageMeasure;
	this.tableLayouts = {};
}

LayoutBuilder.prototype.registerTableLayouts = function (tableLayouts) {
	this.tableLayouts = pack(this.tableLayouts, tableLayouts);
};

/**
 * Executes layout engine on document-definition-object and creates an array of pages
 * containing positioned Blocks, Lines and inlines
 *
 * @param {Object} docStructure document-definition-object
 * @param {Object} fontProvider font provider
 * @param {Object} styleDictionary dictionary with style definitions
 * @param {Object} defaultStyle default style definition
 * @return {Array} an array of pages
 */
LayoutBuilder.prototype.layoutDocument = function (docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark, pageBreakBeforeFct) {

	function addPageBreaksIfNecessary(linearNodeList, pages) {

		if (!isFunction(pageBreakBeforeFct)) {
			return false;
		}

		linearNodeList = linearNodeList.filter(function (node) {
			return node.positions.length > 0;
		});

		linearNodeList.forEach(function (node) {
			var nodeInfo = {};
			[
				'id', 'text', 'ul', 'ol', 'table', 'image', 'qr', 'canvas', 'columns',
				'headlineLevel', 'style', 'pageBreak', 'pageOrientation',
				'width', 'height'
			].forEach(function (key) {
				if (node[key] !== undefined) {
					nodeInfo[key] = node[key];
				}
			});
			nodeInfo.startPosition = node.positions[0];
			nodeInfo.pageNumbers = node.positions.map(function (node) {
				return node.pageNumber;
			}).filter(function (element, position, array) {
				return array.indexOf(element) === position;
			});
			nodeInfo.pages = pages.length;
			nodeInfo.stack = isArray(node.stack);

			node.nodeInfo = nodeInfo;
		});

		return linearNodeList.some(function (node, index, followingNodeList) {
			if (node.pageBreak !== 'before' && !node.pageBreakCalculated) {
				node.pageBreakCalculated = true;
				var pageNumber = node.nodeInfo.pageNumbers[0];

				var followingNodesOnPage = followingNodeList.slice(index + 1).filter(function (node0) {
					return node0.nodeInfo.pageNumbers.indexOf(pageNumber) > -1;
				});

				var nodesOnNextPage = followingNodeList.slice(index + 1).filter(function (node0) {
					return node0.nodeInfo.pageNumbers.indexOf(pageNumber + 1) > -1;
				});

				var previousNodesOnPage = followingNodeList.slice(0, index).filter(function (node0) {
					return node0.nodeInfo.pageNumbers.indexOf(pageNumber) > -1;
				});

				if (
					pageBreakBeforeFct(
						node.nodeInfo,
						followingNodesOnPage.map(function (node) {
							return node.nodeInfo;
						}),
						nodesOnNextPage.map(function (node) {
							return node.nodeInfo;
						}),
						previousNodesOnPage.map(function (node) {
							return node.nodeInfo;
						}))) {
					node.pageBreak = 'before';
					return true;
				}
			}
		});
	}

	this.docPreprocessor = new DocPreprocessor();
	this.docMeasure = new DocMeasure(fontProvider, styleDictionary, defaultStyle, this.imageMeasure, this.tableLayouts, images);


	function resetXYs(result) {
		result.linearNodeList.forEach(function (node) {
			node.resetXY();
		});
	}

	var result = this.tryLayoutDocument(docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark);
	while (addPageBreaksIfNecessary(result.linearNodeList, result.pages)) {
		resetXYs(result);
		result = this.tryLayoutDocument(docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark);
	}

	return result.pages;
};

LayoutBuilder.prototype.tryLayoutDocument = function (docStructure, fontProvider, styleDictionary, defaultStyle, background, header, footer, images, watermark, pageBreakBeforeFct) {

	this.linearNodeList = [];
	docStructure = this.docPreprocessor.preprocessDocument(docStructure);
	docStructure = this.docMeasure.measureDocument(docStructure);

	this.writer = new PageElementWriter(
		new DocumentContext(this.pageSize, this.pageMargins), this.tracker);

	var _this = this;
	this.writer.context().tracker.startTracking('pageAdded', function () {
		_this.addBackground(background);
	});

	this.addBackground(background);
	this.processNode(docStructure);
	this.addHeadersAndFooters(header, footer);
	if (watermark != null) {
		this.addWatermark(watermark, fontProvider, defaultStyle);
	}

	return {pages: this.writer.context().pages, linearNodeList: this.linearNodeList};
};


LayoutBuilder.prototype.addBackground = function (background) {
	var backgroundGetter = isFunction(background) ? background : function () {
		return background;
	};

	var pageBackground = backgroundGetter(this.writer.context().page + 1);

	if (pageBackground) {
		var pageSize = this.writer.context().getCurrentPage().pageSize;
		this.writer.beginUnbreakableBlock(pageSize.width, pageSize.height);
		pageBackground = this.docPreprocessor.preprocessDocument(pageBackground);
		this.processNode(this.docMeasure.measureDocument(pageBackground));
		this.writer.commitUnbreakableBlock(0, 0);
		this.writer.context().hasBackground = true;
	}
};

LayoutBuilder.prototype.addStaticRepeatable = function (headerOrFooter, sizeFunction) {
	this.addDynamicRepeatable(function () {
		return JSON.parse(JSON.stringify(headerOrFooter)); // copy to new object
	}, sizeFunction);
};

LayoutBuilder.prototype.addDynamicRepeatable = function (nodeGetter, sizeFunction) {
	var pages = this.writer.context().pages;

	for (var pageIndex = 0, l = pages.length; pageIndex < l; pageIndex++) {
		this.writer.context().page = pageIndex;

		var node = nodeGetter(pageIndex + 1, l, this.writer.context().pages[pageIndex].pageSize);

		if (node) {
			var sizes = sizeFunction(this.writer.context().getCurrentPage().pageSize, this.pageMargins);
			this.writer.beginUnbreakableBlock(sizes.width, sizes.height);
			node = this.docPreprocessor.preprocessDocument(node);
			this.processNode(this.docMeasure.measureDocument(node));
			this.writer.commitUnbreakableBlock(sizes.x, sizes.y);
		}
	}
};

LayoutBuilder.prototype.addHeadersAndFooters = function (header, footer) {
	var headerSizeFct = function (pageSize, pageMargins) {
		return {
			x: 0,
			y: 0,
			width: pageSize.width,
			height: pageMargins.top
		};
	};

	var footerSizeFct = function (pageSize, pageMargins) {
		return {
			x: 0,
			y: pageSize.height - pageMargins.bottom,
			width: pageSize.width,
			height: pageMargins.bottom
		};
	};

	if (isFunction(header)) {
		this.addDynamicRepeatable(header, headerSizeFct);
	} else if (header) {
		this.addStaticRepeatable(header, headerSizeFct);
	}

	if (isFunction(footer)) {
		this.addDynamicRepeatable(footer, footerSizeFct);
	} else if (footer) {
		this.addStaticRepeatable(footer, footerSizeFct);
	}
};

LayoutBuilder.prototype.addWatermark = function (watermark, fontProvider, defaultStyle) {
	if (isString(watermark)) {
		watermark = {'text': watermark};
	}

	if (!watermark.text) { // empty watermark text
		return;
	}

	watermark.font = watermark.font || defaultStyle.font || 'Roboto';
	watermark.color = watermark.color || 'black';
	watermark.opacity = watermark.opacity || 0.6;
	watermark.bold = watermark.bold || false;
	watermark.italics = watermark.italics || false;

	var watermarkObject = {
		text: watermark.text,
		font: fontProvider.provideFont(watermark.font, watermark.bold, watermark.italics),
		size: getSize(this.pageSize, watermark, fontProvider),
		color: watermark.color,
		opacity: watermark.opacity
	};

	var pages = this.writer.context().pages;
	for (var i = 0, l = pages.length; i < l; i++) {
		pages[i].watermark = watermarkObject;
	}

	function getSize(pageSize, watermark, fontProvider) {
		var width = pageSize.width;
		var height = pageSize.height;
		var targetWidth = Math.sqrt(width * width + height * height) * 0.8; /* page diagonal * sample factor */
		var textTools = new TextTools(fontProvider);
		var styleContextStack = new StyleContextStack(null, {font: watermark.font, bold: watermark.bold, italics: watermark.italics});
		var size;

		/**
		 * Binary search the best font size.
		 * Initial bounds [0, 1000]
		 * Break when range < 1
		 */
		var a = 0;
		var b = 1000;
		var c = (a + b) / 2;
		while (Math.abs(a - b) > 1) {
			styleContextStack.push({
				fontSize: c
			});
			size = textTools.sizeOfString(watermark.text, styleContextStack);
			if (size.width > targetWidth) {
				b = c;
				c = (a + b) / 2;
			} else if (size.width < targetWidth) {
				a = c;
				c = (a + b) / 2;
			}
			styleContextStack.pop();
		}
		/*
		 End binary search
		 */
		return {size: size, fontSize: c};
	}
};

function decorateNode(node) {
	var x = node.x, y = node.y;
	node.positions = [];

	if (isArray(node.canvas)) {
		node.canvas.forEach(function (vector) {
			var x = vector.x, y = vector.y, x1 = vector.x1, y1 = vector.y1, x2 = vector.x2, y2 = vector.y2;
			vector.resetXY = function () {
				vector.x = x;
				vector.y = y;
				vector.x1 = x1;
				vector.y1 = y1;
				vector.x2 = x2;
				vector.y2 = y2;
			};
		});
	}

	node.resetXY = function () {
		node.x = x;
		node.y = y;
		if (isArray(node.canvas)) {
			node.canvas.forEach(function (vector) {
				vector.resetXY();
			});
		}
	};
}

LayoutBuilder.prototype.processNode = function (node) {
	var self = this;

	this.linearNodeList.push(node);
	decorateNode(node);

	applyMargins(function () {
		var unbreakable = node.unbreakable;
		if (unbreakable) {
			self.writer.beginUnbreakableBlock();
		}

		var absPosition = node.absolutePosition;
		if (absPosition) {
			self.writer.context().beginDetachedBlock();
			self.writer.context().moveTo(absPosition.x || 0, absPosition.y || 0);
		}

		var relPosition = node.relativePosition;
		if (relPosition) {
			self.writer.context().beginDetachedBlock();
			self.writer.context().moveTo((relPosition.x || 0) + self.writer.context().x, (relPosition.y || 0) + self.writer.context().y);
		}

		if (node.stack) {
			self.processVerticalContainer(node);
		} else if (node.columns) {
			self.processColumns(node);
		} else if (node.ul) {
			self.processList(false, node);
		} else if (node.ol) {
			self.processList(true, node);
		} else if (node.table) {
			self.processTable(node);
		} else if (node.text !== undefined) {
			self.processLeaf(node);
		} else if (node.toc) {
			self.processToc(node);
		} else if (node.image) {
			self.processImage(node);
		} else if (node.canvas) {
			self.processCanvas(node);
		} else if (node.qr) {
			self.processQr(node);
		} else if (!node._span) {
			throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
		}

		if (absPosition || relPosition) {
			self.writer.context().endDetachedBlock();
		}

		if (unbreakable) {
			self.writer.commitUnbreakableBlock();
		}
	});

	function applyMargins(callback) {
		var margin = node._margin;

		if (node.pageBreak === 'before') {
			self.writer.moveToNextPage(node.pageOrientation);
		}

		if (margin) {
			self.writer.context().moveDown(margin[1]);
			self.writer.context().addMargin(margin[0], margin[2]);
		}

		callback();

		if (margin) {
			self.writer.context().addMargin(-margin[0], -margin[2]);
			self.writer.context().moveDown(margin[3]);
		}

		if (node.pageBreak === 'after') {
			self.writer.moveToNextPage(node.pageOrientation);
		}
	}
};

// vertical container
LayoutBuilder.prototype.processVerticalContainer = function (node) {
	var self = this;
	node.stack.forEach(function (item) {
		self.processNode(item);
		addAll(node.positions, item.positions);

		//TODO: paragraph gap
	});
};

// columns
LayoutBuilder.prototype.processColumns = function (columnNode) {
	var columns = columnNode.columns;
	var availableWidth = this.writer.context().availableWidth;
	var gaps = gapArray(columnNode._gap);

	if (gaps) {
		availableWidth -= (gaps.length - 1) * columnNode._gap;
	}

	ColumnCalculator.buildColumnWidths(columns, availableWidth);
	var result = this.processRow(columns, columns, gaps);
	addAll(columnNode.positions, result.positions);


	function gapArray(gap) {
		if (!gap) {
			return null;
		}

		var gaps = [];
		gaps.push(0);

		for (var i = columns.length - 1; i > 0; i--) {
			gaps.push(gap);
		}

		return gaps;
	}
};

LayoutBuilder.prototype.processRow = function (columns, widths, gaps, tableBody, tableRow, height) {
	var self = this;
	var pageBreaks = [], positions = [];

	this.tracker.auto('pageChanged', storePageBreakData, function () {
		widths = widths || columns;

		self.writer.context().beginColumnGroup();

		for (var i = 0, l = columns.length; i < l; i++) {
			var column = columns[i];
			var width = widths[i]._calcWidth;
			var leftOffset = colLeftOffset(i);

			if (column.colSpan && column.colSpan > 1) {
				for (var j = 1; j < column.colSpan; j++) {
					width += widths[++i]._calcWidth + gaps[i];
				}
			}

			self.writer.context().beginColumn(width, leftOffset, getEndingCell(column, i));
			if (!column._span) {
				self.processNode(column);
				addAll(positions, column.positions);
			} else if (column._columnEndingContext) {
				// row-span ending
				self.writer.context().markEnding(column);
			}
		}

		self.writer.context().completeColumnGroup(height);
	});

	return {pageBreaks: pageBreaks, positions: positions};

	function storePageBreakData(data) {
		var pageDesc;

		for (var i = 0, l = pageBreaks.length; i < l; i++) {
			var desc = pageBreaks[i];
			if (desc.prevPage === data.prevPage) {
				pageDesc = desc;
				break;
			}
		}

		if (!pageDesc) {
			pageDesc = data;
			pageBreaks.push(pageDesc);
		}
		pageDesc.prevY = Math.max(pageDesc.prevY, data.prevY);
		pageDesc.y = Math.min(pageDesc.y, data.y);
	}

	function colLeftOffset(i) {
		if (gaps && gaps.length > i) {
			return gaps[i];
		}
		return 0;
	}

	function getEndingCell(column, columnIndex) {
		if (column.rowSpan && column.rowSpan > 1) {
			var endingRow = tableRow + column.rowSpan - 1;
			if (endingRow >= tableBody.length) {
				throw 'Row span for column ' + columnIndex + ' (with indexes starting from 0) exceeded row count';
			}
			return tableBody[endingRow][columnIndex];
		}

		return null;
	}
};

// lists
LayoutBuilder.prototype.processList = function (orderedList, node) {
	var self = this,
		items = orderedList ? node.ol : node.ul,
		gapSize = node._gapSize;

	this.writer.context().addMargin(gapSize.width);

	var nextMarker;
	this.tracker.auto('lineAdded', addMarkerToFirstLeaf, function () {
		items.forEach(function (item) {
			nextMarker = item.listMarker;
			self.processNode(item);
			addAll(node.positions, item.positions);
		});
	});

	this.writer.context().addMargin(-gapSize.width);

	function addMarkerToFirstLeaf(line) {
		// I'm not very happy with the way list processing is implemented
		// (both code and algorithm should be rethinked)
		if (nextMarker) {
			var marker = nextMarker;
			nextMarker = null;

			if (marker.canvas) {
				var vector = marker.canvas[0];

				offsetVector(vector, -marker._minWidth, 0);
				self.writer.addVector(vector);
			} else if (marker._inlines) {
				var markerLine = new Line(self.pageSize.width);
				markerLine.addInline(marker._inlines[0]);
				markerLine.x = -marker._minWidth;
				markerLine.y = line.getAscenderHeight() - markerLine.getAscenderHeight();
				self.writer.addLine(markerLine, true);
			}
		}
	}
};

// tables
LayoutBuilder.prototype.processTable = function (tableNode) {
	var processor = new TableProcessor(tableNode);

	processor.beginTable(this.writer);

	var rowHeights = tableNode.table.heights;
	for (var i = 0, l = tableNode.table.body.length; i < l; i++) {
		processor.beginRow(i, this.writer);

		var height;
		if (isFunction(rowHeights)) {
			height = rowHeights(i);
		} else if (isArray(rowHeights)) {
			height = rowHeights[i];
		} else {
			height = rowHeights;
		}

		if (height === 'auto') {
			height = undefined;
		}

		var result = this.processRow(tableNode.table.body[i], tableNode.table.widths, tableNode._offsets.offsets, tableNode.table.body, i, height);
		addAll(tableNode.positions, result.positions);

		processor.endRow(i, this.writer, result.pageBreaks);
	}

	processor.endTable(this.writer);
};

// leafs (texts)
LayoutBuilder.prototype.processLeaf = function (node) {
	var line = this.buildNextLine(node);
	var currentHeight = (line) ? line.getHeight() : 0;
	var maxHeight = node.maxHeight || -1;

	if (node._tocItemRef) {
		line._pageNodeRef = node._tocItemRef;
	}

	if (node._pageRef) {
		line._pageNodeRef = node._pageRef._nodeRef;
	}

	while (line && (maxHeight === -1 || currentHeight < maxHeight)) {
		var positions = this.writer.addLine(line);
		node.positions.push(positions);
		line = this.buildNextLine(node);
		if (line) {
			currentHeight += line.getHeight();
		}
	}
};

LayoutBuilder.prototype.processToc = function (node) {
	if (node.toc.title) {
		this.processNode(node.toc.title);
	}
	this.processNode(node.toc._table);
};

LayoutBuilder.prototype.buildNextLine = function (textNode) {

	function cloneInline(inline) {
		var newInline = inline.constructor();
		for (var key in inline) {
			newInline[key] = inline[key];
		}
		return newInline;
	}

	if (!textNode._inlines || textNode._inlines.length === 0) {
		return null;
	}

	var line = new Line(this.writer.context().availableWidth);
	var textTools = new TextTools(null);

	while (textNode._inlines && textNode._inlines.length > 0 && line.hasEnoughSpaceForInline(textNode._inlines[0])) {
		var inline = textNode._inlines.shift();

		if (!inline.noWrap && inline.text.length > 1 && inline.width > line.maxWidth) {
			var widthPerChar = inline.width / inline.text.length;
			var maxChars = Math.floor(line.maxWidth / widthPerChar);
			if (maxChars < 1) {
				maxChars = 1;
			}
			if (maxChars < inline.text.length) {
				var newInline = cloneInline(inline);

				newInline.text = inline.text.substr(maxChars);
				inline.text = inline.text.substr(0, maxChars);

				newInline.width = textTools.widthOfString(newInline.text, newInline.font, newInline.fontSize, newInline.characterSpacing, newInline.fontFeatures);
				inline.width = textTools.widthOfString(inline.text, inline.font, inline.fontSize, inline.characterSpacing, inline.fontFeatures);

				textNode._inlines.unshift(newInline);
			}
		}

		line.addInline(inline);
	}

	line.lastLineInParagraph = textNode._inlines.length === 0;

	return line;
};

// images
LayoutBuilder.prototype.processImage = function (node) {
	var position = this.writer.addImage(node);
	node.positions.push(position);
};

LayoutBuilder.prototype.processCanvas = function (node) {
	var height = node._minHeight;

	if (node.absolutePosition === undefined && this.writer.context().availableHeight < height) {
		// TODO: support for canvas larger than a page
		// TODO: support for other overflow methods

		this.writer.moveToNextPage();
	}

	this.writer.alignCanvas(node);

	node.canvas.forEach(function (vector) {
		var position = this.writer.addVector(vector);
		node.positions.push(position);
	}, this);

	this.writer.context().moveDown(height);
};

LayoutBuilder.prototype.processQr = function (node) {
	var position = this.writer.addQr(node);
	node.positions.push(position);
};

module.exports = LayoutBuilder;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {

var isString = __webpack_require__(0).isString;
var isNumber = __webpack_require__(0).isNumber;
var isBoolean = __webpack_require__(0).isBoolean;
var isArray = __webpack_require__(0).isArray;
var isUndefined = __webpack_require__(0).isUndefined;
var fontStringify = __webpack_require__(0).fontStringify;

function DocPreprocessor() {

}

DocPreprocessor.prototype.preprocessDocument = function (docStructure) {
	this.tocs = [];
	this.nodeReferences = [];
	return this.preprocessNode(docStructure);
};

DocPreprocessor.prototype.preprocessNode = function (node) {
	// expand shortcuts and casting values
	if (isArray(node)) {
		node = {stack: node};
	} else if (isString(node)) {
		node = {text: node};
	} else if (isNumber(node) || isBoolean(node)) {
		node = {text: node.toString()};
	} else if (node === null) {
		node = {text: ''};
	} else if (Object.keys(node).length === 0) { // empty object
		node = {text: ''};
	}

	if (node.columns) {
		return this.preprocessColumns(node);
	} else if (node.stack) {
		return this.preprocessVerticalContainer(node);
	} else if (node.ul) {
		return this.preprocessList(node);
	} else if (node.ol) {
		return this.preprocessList(node);
	} else if (node.table) {
		return this.preprocessTable(node);
	} else if (node.text !== undefined) {
		return this.preprocessText(node);
	} else if (node.toc) {
		return this.preprocessToc(node);
	} else if (node.image) {
		return this.preprocessImage(node);
	} else if (node.canvas) {
		return this.preprocessCanvas(node);
	} else if (node.qr) {
		return this.preprocessQr(node);
	} else if (node.pageReference || node.textReference) {
		return this.preprocessText(node);
	} else {
		throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
	}
};

DocPreprocessor.prototype.preprocessColumns = function (node) {
	var columns = node.columns;

	for (var i = 0, l = columns.length; i < l; i++) {
		columns[i] = this.preprocessNode(columns[i]);
	}

	return node;
};

DocPreprocessor.prototype.preprocessVerticalContainer = function (node) {
	var items = node.stack;

	for (var i = 0, l = items.length; i < l; i++) {
		items[i] = this.preprocessNode(items[i]);
	}

	return node;
};

DocPreprocessor.prototype.preprocessList = function (node) {
	var items = node.ul || node.ol;

	for (var i = 0, l = items.length; i < l; i++) {
		items[i] = this.preprocessNode(items[i]);
	}

	return node;
};

DocPreprocessor.prototype.preprocessTable = function (node) {
	var col, row, cols, rows;

	for (col = 0, cols = node.table.body[0].length; col < cols; col++) {
		for (row = 0, rows = node.table.body.length; row < rows; row++) {
			var rowData = node.table.body[row];
			var data = rowData[col];
			if (data !== undefined) {
				if (data === null) { // transform to object
					data = '';
				}
				if (!data._span) {
					rowData[col] = this.preprocessNode(data);
				}
			}
		}
	}

	return node;
};

DocPreprocessor.prototype.preprocessText = function (node) {
	if (node.tocItem) {
		if (!isArray(node.tocItem)) {
			node.tocItem = [node.tocItem];
		}

		for (var i = 0, l = node.tocItem.length; i < l; i++) {
			if (!isString(node.tocItem[i])) {
				node.tocItem[i] = '_default_';
			}

			var tocItemId = node.tocItem[i];

			if (!this.tocs[tocItemId]) {
				this.tocs[tocItemId] = {toc: {_items: [], _pseudo: true}};
			}

			this.tocs[tocItemId].toc._items.push(node);
		}
	}

	if (node.id) {
		if (this.nodeReferences[node.id]) {
			if (!this.nodeReferences[node.id]._pseudo) {
				throw "Node id '" + node.id + "' already exists";
			}

			this.nodeReferences[node.id]._nodeRef = node;
			this.nodeReferences[node.id]._pseudo = false;
		} else {
			this.nodeReferences[node.id] = {_nodeRef: node};
		}
	}

	if (node.pageReference) {
		if (!this.nodeReferences[node.pageReference]) {
			this.nodeReferences[node.pageReference] = {_nodeRef: {}, _pseudo: true};
		}
		node.text = '00000';
		node._pageRef = this.nodeReferences[node.pageReference];
	}

	if (node.textReference) {
		if (!this.nodeReferences[node.textReference]) {
			this.nodeReferences[node.textReference] = {_nodeRef: {}, _pseudo: true};
		}

		node.text = '';
		node._textRef = this.nodeReferences[node.textReference];
	}

	if (node.text && node.text.text) {
		node.text = [this.preprocessNode(node.text)];
	}

	return node;
};

DocPreprocessor.prototype.preprocessToc = function (node) {
	if (!node.toc.id) {
		node.toc.id = '_default_';
	}

	node.toc.title = node.toc.title ? this.preprocessNode(node.toc.title) : null;
	node.toc._items = [];

	if (this.tocs[node.toc.id]) {
		if (!this.tocs[node.toc.id].toc._pseudo) {
			throw "TOC '" + node.toc.id + "' already exists";
		}

		node.toc._items = this.tocs[node.toc.id].toc._items;
	}

	this.tocs[node.toc.id] = node;

	return node;
};

DocPreprocessor.prototype.preprocessImage = function (node) {
	if (!isUndefined(node.image.type) && !isUndefined(node.image.data) && (node.image.type === 'Buffer') && isArray(node.image.data)) {
		node.image = Buffer.from(node.image.data);
	}
	return node;
};

DocPreprocessor.prototype.preprocessCanvas = function (node) {
	return node;
};

DocPreprocessor.prototype.preprocessQr = function (node) {
	return node;
};

module.exports = DocPreprocessor;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*eslint no-unused-vars: ["error", {"args": "none"}]*/



var TextTools = __webpack_require__(42);
var StyleContextStack = __webpack_require__(80);
var ColumnCalculator = __webpack_require__(44);
var isString = __webpack_require__(0).isString;
var isNumber = __webpack_require__(0).isNumber;
var isObject = __webpack_require__(0).isObject;
var isArray = __webpack_require__(0).isArray;
var fontStringify = __webpack_require__(0).fontStringify;
var pack = __webpack_require__(0).pack;
var qrEncoder = __webpack_require__(134);

/**
 * @private
 */
function DocMeasure(fontProvider, styleDictionary, defaultStyle, imageMeasure, tableLayouts, images) {
	this.textTools = new TextTools(fontProvider);
	this.styleStack = new StyleContextStack(styleDictionary, defaultStyle);
	this.imageMeasure = imageMeasure;
	this.tableLayouts = tableLayouts;
	this.images = images;
	this.autoImageIndex = 1;
}

/**
 * Measures all nodes and sets min/max-width properties required for the second
 * layout-pass.
 * @param  {Object} docStructure document-definition-object
 * @return {Object}              document-measurement-object
 */
DocMeasure.prototype.measureDocument = function (docStructure) {
	return this.measureNode(docStructure);
};

DocMeasure.prototype.measureNode = function (node) {

	var self = this;

	return this.styleStack.auto(node, function () {
		// TODO: refactor + rethink whether this is the proper way to handle margins
		node._margin = getNodeMargin(node);

		if (node.columns) {
			return extendMargins(self.measureColumns(node));
		} else if (node.stack) {
			return extendMargins(self.measureVerticalContainer(node));
		} else if (node.ul) {
			return extendMargins(self.measureUnorderedList(node));
		} else if (node.ol) {
			return extendMargins(self.measureOrderedList(node));
		} else if (node.table) {
			return extendMargins(self.measureTable(node));
		} else if (node.text !== undefined) {
			return extendMargins(self.measureLeaf(node));
		} else if (node.toc) {
			return extendMargins(self.measureToc(node));
		} else if (node.image) {
			return extendMargins(self.measureImage(node));
		} else if (node.canvas) {
			return extendMargins(self.measureCanvas(node));
		} else if (node.qr) {
			return extendMargins(self.measureQr(node));
		} else {
			throw 'Unrecognized document structure: ' + JSON.stringify(node, fontStringify);
		}
	});

	function extendMargins(node) {
		var margin = node._margin;

		if (margin) {
			node._minWidth += margin[0] + margin[2];
			node._maxWidth += margin[0] + margin[2];
		}

		return node;
	}

	function getNodeMargin() {

		function processSingleMargins(node, currentMargin) {
			if (node.marginLeft || node.marginTop || node.marginRight || node.marginBottom) {
				return [
					node.marginLeft || currentMargin[0] || 0,
					node.marginTop || currentMargin[1] || 0,
					node.marginRight || currentMargin[2] || 0,
					node.marginBottom || currentMargin[3] || 0
				];
			}
			return currentMargin;
		}

		function flattenStyleArray(styleArray) {
			var flattenedStyles = {};
			for (var i = styleArray.length - 1; i >= 0; i--) {
				var styleName = styleArray[i];
				var style = self.styleStack.styleDictionary[styleName];
				for (var key in style) {
					if (style.hasOwnProperty(key)) {
						flattenedStyles[key] = style[key];
					}
				}
			}
			return flattenedStyles;
		}

		function convertMargin(margin) {
			if (isNumber(margin)) {
				margin = [margin, margin, margin, margin];
			} else if (isArray(margin)) {
				if (margin.length === 2) {
					margin = [margin[0], margin[1], margin[0], margin[1]];
				}
			}
			return margin;
		}

		var margin = [undefined, undefined, undefined, undefined];

		if (node.style) {
			var styleArray = isArray(node.style) ? node.style : [node.style];
			var flattenedStyleArray = flattenStyleArray(styleArray);

			if (flattenedStyleArray) {
				margin = processSingleMargins(flattenedStyleArray, margin);
			}

			if (flattenedStyleArray.margin) {
				margin = convertMargin(flattenedStyleArray.margin);
			}
		}

		margin = processSingleMargins(node, margin);

		if (node.margin) {
			margin = convertMargin(node.margin);
		}

		if (margin[0] === undefined && margin[1] === undefined && margin[2] === undefined && margin[3] === undefined) {
			return null;
		} else {
			return margin;
		}
	}
};

DocMeasure.prototype.convertIfBase64Image = function (node) {
	if (/^data:image\/(jpeg|jpg|png);base64,/.test(node.image)) {
		var label = '$$pdfmake$$' + this.autoImageIndex++;
		this.images[label] = node.image;
		node.image = label;
	}
};

DocMeasure.prototype.measureImage = function (node) {
	if (this.images) {
		this.convertIfBase64Image(node);
	}

	var imageSize = this.imageMeasure.measureImage(node.image);

	if (node.fit) {
		var factor = (imageSize.width / imageSize.height > node.fit[0] / node.fit[1]) ? node.fit[0] / imageSize.width : node.fit[1] / imageSize.height;
		node._width = node._minWidth = node._maxWidth = imageSize.width * factor;
		node._height = imageSize.height * factor;
	} else {
		node._width = node._minWidth = node._maxWidth = node.width || imageSize.width;
		node._height = node.height || (imageSize.height * node._width / imageSize.width);

		if (isNumber(node.maxWidth) && node.maxWidth < node._width) {
			node._width = node._minWidth = node._maxWidth = node.maxWidth;
			node._height = node._width * imageSize.height / imageSize.width;
		}

		if (isNumber(node.maxHeight) && node.maxHeight < node._height) {
			node._height = node.maxHeight;
			node._width = node._minWidth = node._maxWidth = node._height * imageSize.width / imageSize.height;
		}

		if (isNumber(node.minWidth) && node.minWidth > node._width) {
			node._width = node._minWidth = node._maxWidth = node.minWidth;
			node._height = node._width * imageSize.height / imageSize.width;
		}

		if (isNumber(node.minHeight) && node.minHeight > node._height) {
			node._height = node.minHeight;
			node._width = node._minWidth = node._maxWidth = node._height * imageSize.width / imageSize.height;
		}
	}

	node._alignment = this.styleStack.getProperty('alignment');
	return node;
};

DocMeasure.prototype.measureLeaf = function (node) {

	if (node._textRef && node._textRef._nodeRef.text) {
		node.text = node._textRef._nodeRef.text;
	}

	// Make sure style properties of the node itself are considered when building inlines.
	// We could also just pass [node] to buildInlines, but that fails for bullet points.
	var styleStack = this.styleStack.clone();
	styleStack.push(node);

	var data = this.textTools.buildInlines(node.text, styleStack);

	node._inlines = data.items;
	node._minWidth = data.minWidth;
	node._maxWidth = data.maxWidth;

	return node;
};

DocMeasure.prototype.measureToc = function (node) {
	if (node.toc.title) {
		node.toc.title = this.measureNode(node.toc.title);
	}

	var body = [];
	var textStyle = node.toc.textStyle || {};
	var numberStyle = node.toc.numberStyle || textStyle;
	var textMargin = node.toc.textMargin || [0, 0, 0, 0];
	for (var i = 0, l = node.toc._items.length; i < l; i++) {
		var item = node.toc._items[i];
		var lineStyle = node.toc._items[i].tocStyle || textStyle;
		var lineMargin = node.toc._items[i].tocMargin || textMargin;
		body.push([
			{text: item.text, alignment: 'left', style: lineStyle, margin: lineMargin},
			{text: '00000', alignment: 'right', _tocItemRef: item, style: numberStyle, margin: [0, lineMargin[1], 0, lineMargin[3]]}
		]);
	}


	node.toc._table = {
		table: {
			dontBreakRows: true,
			widths: ['*', 'auto'],
			body: body
		},
		layout: 'noBorders'
	};

	node.toc._table = this.measureNode(node.toc._table);

	return node;
};

DocMeasure.prototype.measureVerticalContainer = function (node) {
	var items = node.stack;

	node._minWidth = 0;
	node._maxWidth = 0;

	for (var i = 0, l = items.length; i < l; i++) {
		items[i] = this.measureNode(items[i]);

		node._minWidth = Math.max(node._minWidth, items[i]._minWidth);
		node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth);
	}

	return node;
};

DocMeasure.prototype.gapSizeForList = function () {
	return this.textTools.sizeOfString('9. ', this.styleStack);
};

DocMeasure.prototype.buildUnorderedMarker = function (styleStack, gapSize, type) {
	function buildDisc(gapSize, color) {
		// TODO: ascender-based calculations
		var radius = gapSize.fontSize / 6;
		return {
			canvas: [{
					x: radius,
					y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - gapSize.fontSize / 3,
					r1: radius,
					r2: radius,
					type: 'ellipse',
					color: color
				}]
		};
	}

	function buildSquare(gapSize, color) {
		// TODO: ascender-based calculations
		var size = gapSize.fontSize / 3;
		return {
			canvas: [{
					x: 0,
					y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - (gapSize.fontSize / 3) - (size / 2),
					h: size,
					w: size,
					type: 'rect',
					color: color
				}]
		};
	}

	function buildCircle(gapSize, color) {
		// TODO: ascender-based calculations
		var radius = gapSize.fontSize / 6;
		return {
			canvas: [{
					x: radius,
					y: (gapSize.height / gapSize.lineHeight) + gapSize.descender - gapSize.fontSize / 3,
					r1: radius,
					r2: radius,
					type: 'ellipse',
					lineColor: color
				}]
		};
	}

	var marker;
	var color = styleStack.getProperty('markerColor') || styleStack.getProperty('color') || 'black';

	switch (type) {
		case 'circle':
			marker = buildCircle(gapSize, color);
			break;

		case 'square':
			marker = buildSquare(gapSize, color);
			break;

		case 'none':
			marker = {};
			break;

		case 'disc':
		default:
			marker = buildDisc(gapSize, color);
			break;
	}

	marker._minWidth = marker._maxWidth = gapSize.width;
	marker._minHeight = marker._maxHeight = gapSize.height;

	return marker;
};

DocMeasure.prototype.buildOrderedMarker = function (counter, styleStack, type, separator) {
	function prepareAlpha(counter) {
		function toAlpha(num) {
			return (num >= 26 ? toAlpha((num / 26 >> 0) - 1) : '') + 'abcdefghijklmnopqrstuvwxyz'[num % 26 >> 0];
		}

		if (counter < 1) {
			return counter.toString();
		}

		return toAlpha(counter - 1);
	}

	function prepareRoman(counter) {
		if (counter < 1 || counter > 4999) {
			return counter.toString();
		}
		var num = counter;
		var lookup = {M: 1000, CM: 900, D: 500, CD: 400, C: 100, XC: 90, L: 50, XL: 40, X: 10, IX: 9, V: 5, IV: 4, I: 1}, roman = '', i;
		for (i in lookup) {
			while (num >= lookup[i]) {
				roman += i;
				num -= lookup[i];
			}
		}
		return roman;
	}

	function prepareDecimal(counter) {
		return counter.toString();
	}

	var counterText;
	switch (type) {
		case 'none':
			counterText = null;
			break;

		case 'upper-alpha':
			counterText = prepareAlpha(counter).toUpperCase();
			break;

		case 'lower-alpha':
			counterText = prepareAlpha(counter);
			break;

		case 'upper-roman':
			counterText = prepareRoman(counter);
			break;

		case 'lower-roman':
			counterText = prepareRoman(counter).toLowerCase();
			break;

		case 'decimal':
		default:
			counterText = prepareDecimal(counter);
			break;
	}

	if (counterText === null) {
		return {};
	}

	if (separator) {
		if (isArray(separator)) {
			if (separator[0]) {
				counterText = separator[0] + counterText;
			}

			if (separator[1]) {
				counterText += separator[1];
			}
			counterText += ' ';
		} else {
			counterText += separator + ' ';
		}
	}

	var textArray = {text: counterText};
	var markerColor = styleStack.getProperty('markerColor');
	if (markerColor) {
		textArray.color = markerColor;
	}

	return {_inlines: this.textTools.buildInlines(textArray, styleStack).items};
};

DocMeasure.prototype.measureUnorderedList = function (node) {
	var style = this.styleStack.clone();
	var items = node.ul;
	node.type = node.type || 'disc';
	node._gapSize = this.gapSizeForList();
	node._minWidth = 0;
	node._maxWidth = 0;

	for (var i = 0, l = items.length; i < l; i++) {
		var item = items[i] = this.measureNode(items[i]);

		if (!item.ol && !item.ul) {
			item.listMarker = this.buildUnorderedMarker(style, node._gapSize, item.listType || node.type);
		}

		node._minWidth = Math.max(node._minWidth, items[i]._minWidth + node._gapSize.width);
		node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth + node._gapSize.width);
	}

	return node;
};

DocMeasure.prototype.measureOrderedList = function (node) {
	var style = this.styleStack.clone();
	var items = node.ol;
	node.type = node.type || 'decimal';
	node.separator = node.separator || '.';
	node.reversed = node.reversed || false;
	if (!node.start) {
		node.start = node.reversed ? items.length : 1;
	}
	node._gapSize = this.gapSizeForList();
	node._minWidth = 0;
	node._maxWidth = 0;

	var counter = node.start;
	for (var i = 0, l = items.length; i < l; i++) {
		var item = items[i] = this.measureNode(items[i]);

		if (!item.ol && !item.ul) {
			item.listMarker = this.buildOrderedMarker(item.counter || counter, style, item.listType || node.type, node.separator);
			if (item.listMarker._inlines) {
				node._gapSize.width = Math.max(node._gapSize.width, item.listMarker._inlines[0].width);
			}
		}  // TODO: else - nested lists numbering

		node._minWidth = Math.max(node._minWidth, items[i]._minWidth);
		node._maxWidth = Math.max(node._maxWidth, items[i]._maxWidth);

		if (node.reversed) {
			counter--;
		} else {
			counter++;
		}
	}

	node._minWidth += node._gapSize.width;
	node._maxWidth += node._gapSize.width;

	for (var i = 0, l = items.length; i < l; i++) {
		var item = items[i];
		if (!item.ol && !item.ul) {
			item.listMarker._minWidth = item.listMarker._maxWidth = node._gapSize.width;
		}
	}

	return node;
};

DocMeasure.prototype.measureColumns = function (node) {
	var columns = node.columns;
	node._gap = this.styleStack.getProperty('columnGap') || 0;

	for (var i = 0, l = columns.length; i < l; i++) {
		columns[i] = this.measureNode(columns[i]);
	}

	var measures = ColumnCalculator.measureMinMax(columns);

	var numGaps = (columns.length > 0) ? (columns.length - 1) : 0;
	node._minWidth = measures.min + node._gap * numGaps;
	node._maxWidth = measures.max + node._gap * numGaps;

	return node;
};

DocMeasure.prototype.measureTable = function (node) {
	extendTableWidths(node);
	node._layout = getLayout(this.tableLayouts);
	node._offsets = getOffsets(node._layout);

	var colSpans = [];
	var col, row, cols, rows;

	for (col = 0, cols = node.table.body[0].length; col < cols; col++) {
		var c = node.table.widths[col];
		c._minWidth = 0;
		c._maxWidth = 0;

		for (row = 0, rows = node.table.body.length; row < rows; row++) {
			var rowData = node.table.body[row];
			var data = rowData[col];
			if (data === undefined) {
				console.error('Malformed table row ', rowData, 'in node ', node);
				throw 'Malformed table row, a cell is undefined.';
			}
			if (data === null) { // transform to object
				data = '';
			}

			if (!data._span) {
				data = rowData[col] = this.styleStack.auto(data, measureCb(this, data));

				if (data.colSpan && data.colSpan > 1) {
					markSpans(rowData, col, data.colSpan);
					colSpans.push({col: col, span: data.colSpan, minWidth: data._minWidth, maxWidth: data._maxWidth});
				} else {
					c._minWidth = Math.max(c._minWidth, data._minWidth);
					c._maxWidth = Math.max(c._maxWidth, data._maxWidth);
				}
			}

			if (data.rowSpan && data.rowSpan > 1) {
				markVSpans(node.table, row, col, data.rowSpan);
			}
		}
	}

	extendWidthsForColSpans();

	var measures = ColumnCalculator.measureMinMax(node.table.widths);

	node._minWidth = measures.min + node._offsets.total;
	node._maxWidth = measures.max + node._offsets.total;

	return node;

	function measureCb(_this, data) {
		return function () {
			if (isObject(data)) {
				data.fillColor = _this.styleStack.getProperty('fillColor');
			}
			return _this.measureNode(data);
		};
	}

	function getLayout(tableLayouts) {
		var layout = node.layout;

		if (isString(layout)) {
			layout = tableLayouts[layout];
		}

		var defaultLayout = {
			hLineWidth: function (i, node) {
				return 1;
			},
			vLineWidth: function (i, node) {
				return 1;
			},
			hLineColor: function (i, node) {
				return 'black';
			},
			vLineColor: function (i, node) {
				return 'black';
			},
			paddingLeft: function (i, node) {
				return 4;
			},
			paddingRight: function (i, node) {
				return 4;
			},
			paddingTop: function (i, node) {
				return 2;
			},
			paddingBottom: function (i, node) {
				return 2;
			},
			fillColor: function (i, node) {
				return null;
			},
			defaultBorder: true
		};

		return pack(defaultLayout, layout);
	}

	function getOffsets(layout) {
		var offsets = [];
		var totalOffset = 0;
		var prevRightPadding = 0;

		for (var i = 0, l = node.table.widths.length; i < l; i++) {
			var lOffset = prevRightPadding + layout.vLineWidth(i, node) + layout.paddingLeft(i, node);
			offsets.push(lOffset);
			totalOffset += lOffset;
			prevRightPadding = layout.paddingRight(i, node);
		}

		totalOffset += prevRightPadding + layout.vLineWidth(node.table.widths.length, node);

		return {
			total: totalOffset,
			offsets: offsets
		};
	}

	function extendWidthsForColSpans() {
		var q, j;

		for (var i = 0, l = colSpans.length; i < l; i++) {
			var span = colSpans[i];

			var currentMinMax = getMinMax(span.col, span.span, node._offsets);
			var minDifference = span.minWidth - currentMinMax.minWidth;
			var maxDifference = span.maxWidth - currentMinMax.maxWidth;

			if (minDifference > 0) {
				q = minDifference / span.span;

				for (j = 0; j < span.span; j++) {
					node.table.widths[span.col + j]._minWidth += q;
				}
			}

			if (maxDifference > 0) {
				q = maxDifference / span.span;

				for (j = 0; j < span.span; j++) {
					node.table.widths[span.col + j]._maxWidth += q;
				}
			}
		}
	}

	function getMinMax(col, span, offsets) {
		var result = {minWidth: 0, maxWidth: 0};

		for (var i = 0; i < span; i++) {
			result.minWidth += node.table.widths[col + i]._minWidth + (i ? offsets.offsets[col + i] : 0);
			result.maxWidth += node.table.widths[col + i]._maxWidth + (i ? offsets.offsets[col + i] : 0);
		}

		return result;
	}

	function markSpans(rowData, col, span) {
		for (var i = 1; i < span; i++) {
			rowData[col + i] = {
				_span: true,
				_minWidth: 0,
				_maxWidth: 0,
				rowSpan: rowData[col].rowSpan
			};
		}
	}

	function markVSpans(table, row, col, span) {
		for (var i = 1; i < span; i++) {
			table.body[row + i][col] = {
				_span: true,
				_minWidth: 0,
				_maxWidth: 0,
				fillColor: table.body[row][col].fillColor
			};
		}
	}

	function extendTableWidths(node) {
		if (!node.table.widths) {
			node.table.widths = 'auto';
		}

		if (isString(node.table.widths)) {
			node.table.widths = [node.table.widths];

			while (node.table.widths.length < node.table.body[0].length) {
				node.table.widths.push(node.table.widths[node.table.widths.length - 1]);
			}
		}

		for (var i = 0, l = node.table.widths.length; i < l; i++) {
			var w = node.table.widths[i];
			if (isNumber(w) || isString(w)) {
				node.table.widths[i] = {width: w};
			}
		}
	}
};

DocMeasure.prototype.measureCanvas = function (node) {
	var w = 0, h = 0;

	for (var i = 0, l = node.canvas.length; i < l; i++) {
		var vector = node.canvas[i];

		switch (vector.type) {
			case 'ellipse':
				w = Math.max(w, vector.x + vector.r1);
				h = Math.max(h, vector.y + vector.r2);
				break;
			case 'rect':
				w = Math.max(w, vector.x + vector.w);
				h = Math.max(h, vector.y + vector.h);
				break;
			case 'line':
				w = Math.max(w, vector.x1, vector.x2);
				h = Math.max(h, vector.y1, vector.y2);
				break;
			case 'polyline':
				for (var i2 = 0, l2 = vector.points.length; i2 < l2; i2++) {
					w = Math.max(w, vector.points[i2].x);
					h = Math.max(h, vector.points[i2].y);
				}
				break;
		}
	}

	node._minWidth = node._maxWidth = w;
	node._minHeight = node._maxHeight = h;
	node._alignment = this.styleStack.getProperty('alignment');

	return node;
};

DocMeasure.prototype.measureQr = function (node) {
	node = qrEncoder.measure(node);
	node._alignment = this.styleStack.getProperty('alignment');
	return node;
};

module.exports = DocMeasure;


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

var lookup = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

;(function (exports) {
	'use strict';

  var Arr = (typeof Uint8Array !== 'undefined')
    ? Uint8Array
    : Array

	var PLUS   = '+'.charCodeAt(0)
	var SLASH  = '/'.charCodeAt(0)
	var NUMBER = '0'.charCodeAt(0)
	var LOWER  = 'a'.charCodeAt(0)
	var UPPER  = 'A'.charCodeAt(0)
	var PLUS_URL_SAFE = '-'.charCodeAt(0)
	var SLASH_URL_SAFE = '_'.charCodeAt(0)

	function decode (elt) {
		var code = elt.charCodeAt(0)
		if (code === PLUS ||
		    code === PLUS_URL_SAFE)
			return 62 // '+'
		if (code === SLASH ||
		    code === SLASH_URL_SAFE)
			return 63 // '/'
		if (code < NUMBER)
			return -1 //no match
		if (code < NUMBER + 10)
			return code - NUMBER + 26 + 26
		if (code < UPPER + 26)
			return code - UPPER
		if (code < LOWER + 26)
			return code - LOWER + 26
	}

	function b64ToByteArray (b64) {
		var i, j, l, tmp, placeHolders, arr

		if (b64.length % 4 > 0) {
			throw new Error('Invalid string. Length must be a multiple of 4')
		}

		// the number of equal signs (place holders)
		// if there are two placeholders, than the two characters before it
		// represent one byte
		// if there is only one, then the three characters before it represent 2 bytes
		// this is just a cheap hack to not do indexOf twice
		var len = b64.length
		placeHolders = '=' === b64.charAt(len - 2) ? 2 : '=' === b64.charAt(len - 1) ? 1 : 0

		// base64 is 4/3 + up to two characters of the original data
		arr = new Arr(b64.length * 3 / 4 - placeHolders)

		// if there are placeholders, only get up to the last complete 4 chars
		l = placeHolders > 0 ? b64.length - 4 : b64.length

		var L = 0

		function push (v) {
			arr[L++] = v
		}

		for (i = 0, j = 0; i < l; i += 4, j += 3) {
			tmp = (decode(b64.charAt(i)) << 18) | (decode(b64.charAt(i + 1)) << 12) | (decode(b64.charAt(i + 2)) << 6) | decode(b64.charAt(i + 3))
			push((tmp & 0xFF0000) >> 16)
			push((tmp & 0xFF00) >> 8)
			push(tmp & 0xFF)
		}

		if (placeHolders === 2) {
			tmp = (decode(b64.charAt(i)) << 2) | (decode(b64.charAt(i + 1)) >> 4)
			push(tmp & 0xFF)
		} else if (placeHolders === 1) {
			tmp = (decode(b64.charAt(i)) << 10) | (decode(b64.charAt(i + 1)) << 4) | (decode(b64.charAt(i + 2)) >> 2)
			push((tmp >> 8) & 0xFF)
			push(tmp & 0xFF)
		}

		return arr
	}

	function uint8ToBase64 (uint8) {
		var i,
			extraBytes = uint8.length % 3, // if we have 1 byte left, pad 2 bytes
			output = "",
			temp, length

		function encode (num) {
			return lookup.charAt(num)
		}

		function tripletToBase64 (num) {
			return encode(num >> 18 & 0x3F) + encode(num >> 12 & 0x3F) + encode(num >> 6 & 0x3F) + encode(num & 0x3F)
		}

		// go through the array every three bytes, we'll deal with trailing stuff later
		for (i = 0, length = uint8.length - extraBytes; i < length; i += 3) {
			temp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
			output += tripletToBase64(temp)
		}

		// pad the end with zeros, but make sure to not forget the extra bytes
		switch (extraBytes) {
			case 1:
				temp = uint8[uint8.length - 1]
				output += encode(temp >> 2)
				output += encode((temp << 4) & 0x3F)
				output += '=='
				break
			case 2:
				temp = (uint8[uint8.length - 2] << 8) + (uint8[uint8.length - 1])
				output += encode(temp >> 10)
				output += encode((temp >> 4) & 0x3F)
				output += encode((temp << 2) & 0x3F)
				output += '='
				break
		}

		return output
	}

	exports.toByteArray = b64ToByteArray
	exports.fromByteArray = uint8ToBase64
}( false ? (this.base64js = {}) : exports))


/***/ }),
/* 132 */
/***/ (function(module, exports) {

// Generated by CoffeeScript 1.7.1
(function() {
  var AI, AL, B2, BA, BB, BK, CB, CJ, CL, CM, CP, CR, EX, GL, H2, H3, HL, HY, ID, IN, IS, JL, JT, JV, LF, NL, NS, NU, OP, PO, PR, QU, RI, SA, SG, SP, SY, WJ, XX, ZW;

  exports.OP = OP = 0;

  exports.CL = CL = 1;

  exports.CP = CP = 2;

  exports.QU = QU = 3;

  exports.GL = GL = 4;

  exports.NS = NS = 5;

  exports.EX = EX = 6;

  exports.SY = SY = 7;

  exports.IS = IS = 8;

  exports.PR = PR = 9;

  exports.PO = PO = 10;

  exports.NU = NU = 11;

  exports.AL = AL = 12;

  exports.HL = HL = 13;

  exports.ID = ID = 14;

  exports.IN = IN = 15;

  exports.HY = HY = 16;

  exports.BA = BA = 17;

  exports.BB = BB = 18;

  exports.B2 = B2 = 19;

  exports.ZW = ZW = 20;

  exports.CM = CM = 21;

  exports.WJ = WJ = 22;

  exports.H2 = H2 = 23;

  exports.H3 = H3 = 24;

  exports.JL = JL = 25;

  exports.JV = JV = 26;

  exports.JT = JT = 27;

  exports.RI = RI = 28;

  exports.AI = AI = 29;

  exports.BK = BK = 30;

  exports.CB = CB = 31;

  exports.CJ = CJ = 32;

  exports.CR = CR = 33;

  exports.LF = LF = 34;

  exports.NL = NL = 35;

  exports.SA = SA = 36;

  exports.SG = SG = 37;

  exports.SP = SP = 38;

  exports.XX = XX = 39;

}).call(this);


/***/ }),
/* 133 */
/***/ (function(module, exports) {

// Generated by CoffeeScript 1.7.1
(function() {
  var CI_BRK, CP_BRK, DI_BRK, IN_BRK, PR_BRK;

  exports.DI_BRK = DI_BRK = 0;

  exports.IN_BRK = IN_BRK = 1;

  exports.CI_BRK = CI_BRK = 2;

  exports.CP_BRK = CP_BRK = 3;

  exports.PR_BRK = PR_BRK = 4;

  exports.pairTable = [[PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, CP_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, DI_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, DI_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, PR_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK], [IN_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, IN_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, DI_BRK], [DI_BRK, PR_BRK, PR_BRK, IN_BRK, IN_BRK, IN_BRK, PR_BRK, PR_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK, IN_BRK, DI_BRK, DI_BRK, PR_BRK, CI_BRK, PR_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, DI_BRK, IN_BRK]];

}).call(this);


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*eslint no-unused-vars: ["error", {"args": "none"}]*/
/*eslint no-redeclare: "off"*/


/* qr.js -- QR code generator in Javascript (revision 2011-01-19)
 * Written by Kang Seonghoon <public+qrjs@mearie.org>.
 *
 * This source code is in the public domain; if your jurisdiction does not
 * recognize the public domain the terms of Creative Commons CC0 license
 * apply. In the other words, you can always do what you want.
 */


// per-version information (cf. JIS X 0510:2004 pp. 30--36, 71)
//
// [0]: the degree of generator polynomial by ECC levels
// [1]: # of code blocks by ECC levels
// [2]: left-top positions of alignment patterns
//
// the number in this table (in particular, [0]) does not exactly match with
// the numbers in the specficiation. see augumenteccs below for the reason.
var VERSIONS = [
	null,
	[[10, 7, 17, 13], [1, 1, 1, 1], []],
	[[16, 10, 28, 22], [1, 1, 1, 1], [4, 16]],
	[[26, 15, 22, 18], [1, 1, 2, 2], [4, 20]],
	[[18, 20, 16, 26], [2, 1, 4, 2], [4, 24]],
	[[24, 26, 22, 18], [2, 1, 4, 4], [4, 28]],
	[[16, 18, 28, 24], [4, 2, 4, 4], [4, 32]],
	[[18, 20, 26, 18], [4, 2, 5, 6], [4, 20, 36]],
	[[22, 24, 26, 22], [4, 2, 6, 6], [4, 22, 40]],
	[[22, 30, 24, 20], [5, 2, 8, 8], [4, 24, 44]],
	[[26, 18, 28, 24], [5, 4, 8, 8], [4, 26, 48]],
	[[30, 20, 24, 28], [5, 4, 11, 8], [4, 28, 52]],
	[[22, 24, 28, 26], [8, 4, 11, 10], [4, 30, 56]],
	[[22, 26, 22, 24], [9, 4, 16, 12], [4, 32, 60]],
	[[24, 30, 24, 20], [9, 4, 16, 16], [4, 24, 44, 64]],
	[[24, 22, 24, 30], [10, 6, 18, 12], [4, 24, 46, 68]],
	[[28, 24, 30, 24], [10, 6, 16, 17], [4, 24, 48, 72]],
	[[28, 28, 28, 28], [11, 6, 19, 16], [4, 28, 52, 76]],
	[[26, 30, 28, 28], [13, 6, 21, 18], [4, 28, 54, 80]],
	[[26, 28, 26, 26], [14, 7, 25, 21], [4, 28, 56, 84]],
	[[26, 28, 28, 30], [16, 8, 25, 20], [4, 32, 60, 88]],
	[[26, 28, 30, 28], [17, 8, 25, 23], [4, 26, 48, 70, 92]],
	[[28, 28, 24, 30], [17, 9, 34, 23], [4, 24, 48, 72, 96]],
	[[28, 30, 30, 30], [18, 9, 30, 25], [4, 28, 52, 76, 100]],
	[[28, 30, 30, 30], [20, 10, 32, 27], [4, 26, 52, 78, 104]],
	[[28, 26, 30, 30], [21, 12, 35, 29], [4, 30, 56, 82, 108]],
	[[28, 28, 30, 28], [23, 12, 37, 34], [4, 28, 56, 84, 112]],
	[[28, 30, 30, 30], [25, 12, 40, 34], [4, 32, 60, 88, 116]],
	[[28, 30, 30, 30], [26, 13, 42, 35], [4, 24, 48, 72, 96, 120]],
	[[28, 30, 30, 30], [28, 14, 45, 38], [4, 28, 52, 76, 100, 124]],
	[[28, 30, 30, 30], [29, 15, 48, 40], [4, 24, 50, 76, 102, 128]],
	[[28, 30, 30, 30], [31, 16, 51, 43], [4, 28, 54, 80, 106, 132]],
	[[28, 30, 30, 30], [33, 17, 54, 45], [4, 32, 58, 84, 110, 136]],
	[[28, 30, 30, 30], [35, 18, 57, 48], [4, 28, 56, 84, 112, 140]],
	[[28, 30, 30, 30], [37, 19, 60, 51], [4, 32, 60, 88, 116, 144]],
	[[28, 30, 30, 30], [38, 19, 63, 53], [4, 28, 52, 76, 100, 124, 148]],
	[[28, 30, 30, 30], [40, 20, 66, 56], [4, 22, 48, 74, 100, 126, 152]],
	[[28, 30, 30, 30], [43, 21, 70, 59], [4, 26, 52, 78, 104, 130, 156]],
	[[28, 30, 30, 30], [45, 22, 74, 62], [4, 30, 56, 82, 108, 134, 160]],
	[[28, 30, 30, 30], [47, 24, 77, 65], [4, 24, 52, 80, 108, 136, 164]],
	[[28, 30, 30, 30], [49, 25, 81, 68], [4, 28, 56, 84, 112, 140, 168]]];

// mode constants (cf. Table 2 in JIS X 0510:2004 p. 16)
var MODE_TERMINATOR = 0;
var MODE_NUMERIC = 1, MODE_ALPHANUMERIC = 2, MODE_OCTET = 4, MODE_KANJI = 8;

// validation regexps
var NUMERIC_REGEXP = /^\d*$/;
var ALPHANUMERIC_REGEXP = /^[A-Za-z0-9 $%*+\-./:]*$/;
var ALPHANUMERIC_OUT_REGEXP = /^[A-Z0-9 $%*+\-./:]*$/;

// ECC levels (cf. Table 22 in JIS X 0510:2004 p. 45)
var ECCLEVEL_L = 1, ECCLEVEL_M = 0, ECCLEVEL_Q = 3, ECCLEVEL_H = 2;

// GF(2^8)-to-integer mapping with a reducing polynomial x^8+x^4+x^3+x^2+1
// invariant: GF256_MAP[GF256_INVMAP[i]] == i for all i in [1,256)
var GF256_MAP = [], GF256_INVMAP = [-1];
for (var i = 0, v = 1; i < 255; ++i) {
	GF256_MAP.push(v);
	GF256_INVMAP[v] = i;
	v = (v * 2) ^ (v >= 128 ? 0x11d : 0);
}

// generator polynomials up to degree 30
// (should match with polynomials in JIS X 0510:2004 Appendix A)
//
// generator polynomial of degree K is product of (x-\alpha^0), (x-\alpha^1),
// ..., (x-\alpha^(K-1)). by convention, we omit the K-th coefficient (always 1)
// from the result; also other coefficients are written in terms of the exponent
// to \alpha to avoid the redundant calculation. (see also calculateecc below.)
var GF256_GENPOLY = [[]];
for (var i = 0; i < 30; ++i) {
	var prevpoly = GF256_GENPOLY[i], poly = [];
	for (var j = 0; j <= i; ++j) {
		var a = (j < i ? GF256_MAP[prevpoly[j]] : 0);
		var b = GF256_MAP[(i + (prevpoly[j - 1] || 0)) % 255];
		poly.push(GF256_INVMAP[a ^ b]);
	}
	GF256_GENPOLY.push(poly);
}

// alphanumeric character mapping (cf. Table 5 in JIS X 0510:2004 p. 19)
var ALPHANUMERIC_MAP = {};
for (var i = 0; i < 45; ++i) {
	ALPHANUMERIC_MAP['0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:'.charAt(i)] = i;
}

// mask functions in terms of row # and column #
// (cf. Table 20 in JIS X 0510:2004 p. 42)
/*jshint unused: false */
var MASKFUNCS = [
	function (i, j) {
		return (i + j) % 2 === 0;
	},
	function (i, j) {
		return i % 2 === 0;
	},
	function (i, j) {
		return j % 3 === 0;
	},
	function (i, j) {
		return (i + j) % 3 === 0;
	},
	function (i, j) {
		return (((i / 2) | 0) + ((j / 3) | 0)) % 2 === 0;
	},
	function (i, j) {
		return (i * j) % 2 + (i * j) % 3 === 0;
	},
	function (i, j) {
		return ((i * j) % 2 + (i * j) % 3) % 2 === 0;
	},
	function (i, j) {
		return ((i + j) % 2 + (i * j) % 3) % 2 === 0;
	}];

// returns true when the version information has to be embeded.
var needsverinfo = function (ver) {
	return ver > 6;
};

// returns the size of entire QR code for given version.
var getsizebyver = function (ver) {
	return 4 * ver + 17;
};

// returns the number of bits available for code words in this version.
var nfullbits = function (ver) {
	/*
	 * |<--------------- n --------------->|
	 * |        |<----- n-17 ---->|        |
	 * +-------+                ///+-------+ ----
	 * |       |                ///|       |    ^
	 * |  9x9  |       @@@@@    ///|  9x8  |    |
	 * |       | # # # @5x5@ # # # |       |    |
	 * +-------+       @@@@@       +-------+    |
	 *       #                               ---|
	 *                                        ^ |
	 *       #                                |
	 *     @@@@@       @@@@@       @@@@@      | n
	 *     @5x5@       @5x5@       @5x5@   n-17
	 *     @@@@@       @@@@@       @@@@@      | |
	 *       #                                | |
	 * //////                                 v |
	 * //////#                               ---|
	 * +-------+       @@@@@       @@@@@        |
	 * |       |       @5x5@       @5x5@        |
	 * |  8x9  |       @@@@@       @@@@@        |
	 * |       |                                v
	 * +-------+                             ----
	 *
	 * when the entire code has n^2 modules and there are m^2-3 alignment
	 * patterns, we have:
	 * - 225 (= 9x9 + 9x8 + 8x9) modules for finder patterns and
	 *   format information;
	 * - 2n-34 (= 2(n-17)) modules for timing patterns;
	 * - 36 (= 3x6 + 6x3) modules for version information, if any;
	 * - 25m^2-75 (= (m^2-3)(5x5)) modules for alignment patterns
	 *   if any, but 10m-20 (= 2(m-2)x5) of them overlaps with
	 *   timing patterns.
	 */
	var v = VERSIONS[ver];
	var nbits = 16 * ver * ver + 128 * ver + 64; // finder, timing and format info.
	if (needsverinfo(ver))
		nbits -= 36; // version information
	if (v[2].length) { // alignment patterns
		nbits -= 25 * v[2].length * v[2].length - 10 * v[2].length - 55;
	}
	return nbits;
};

// returns the number of bits available for data portions (i.e. excludes ECC
// bits but includes mode and length bits) in this version and ECC level.
var ndatabits = function (ver, ecclevel) {
	var nbits = nfullbits(ver) & ~7; // no sub-octet code words
	var v = VERSIONS[ver];
	nbits -= 8 * v[0][ecclevel] * v[1][ecclevel]; // ecc bits
	return nbits;
};

// returns the number of bits required for the length of data.
// (cf. Table 3 in JIS X 0510:2004 p. 16)
var ndatalenbits = function (ver, mode) {
	switch (mode) {
		case MODE_NUMERIC:
			return (ver < 10 ? 10 : ver < 27 ? 12 : 14);
		case MODE_ALPHANUMERIC:
			return (ver < 10 ? 9 : ver < 27 ? 11 : 13);
		case MODE_OCTET:
			return (ver < 10 ? 8 : 16);
		case MODE_KANJI:
			return (ver < 10 ? 8 : ver < 27 ? 10 : 12);
	}
};

// returns the maximum length of data possible in given configuration.
var getmaxdatalen = function (ver, mode, ecclevel) {
	var nbits = ndatabits(ver, ecclevel) - 4 - ndatalenbits(ver, mode); // 4 for mode bits
	switch (mode) {
		case MODE_NUMERIC:
			return ((nbits / 10) | 0) * 3 + (nbits % 10 < 4 ? 0 : nbits % 10 < 7 ? 1 : 2);
		case MODE_ALPHANUMERIC:
			return ((nbits / 11) | 0) * 2 + (nbits % 11 < 6 ? 0 : 1);
		case MODE_OCTET:
			return (nbits / 8) | 0;
		case MODE_KANJI:
			return (nbits / 13) | 0;
	}
};

// checks if the given data can be encoded in given mode, and returns
// the converted data for the further processing if possible. otherwise
// returns null.
//
// this function does not check the length of data; it is a duty of
// encode function below (as it depends on the version and ECC level too).
var validatedata = function (mode, data) {
	switch (mode) {
		case MODE_NUMERIC:
			if (!data.match(NUMERIC_REGEXP))
				return null;
			return data;

		case MODE_ALPHANUMERIC:
			if (!data.match(ALPHANUMERIC_REGEXP))
				return null;
			return data.toUpperCase();

		case MODE_OCTET:
			if (typeof data === 'string') { // encode as utf-8 string
				var newdata = [];
				for (var i = 0; i < data.length; ++i) {
					var ch = data.charCodeAt(i);
					if (ch < 0x80) {
						newdata.push(ch);
					} else if (ch < 0x800) {
						newdata.push(0xc0 | (ch >> 6),
							0x80 | (ch & 0x3f));
					} else if (ch < 0x10000) {
						newdata.push(0xe0 | (ch >> 12),
							0x80 | ((ch >> 6) & 0x3f),
							0x80 | (ch & 0x3f));
					} else {
						newdata.push(0xf0 | (ch >> 18),
							0x80 | ((ch >> 12) & 0x3f),
							0x80 | ((ch >> 6) & 0x3f),
							0x80 | (ch & 0x3f));
					}
				}
				return newdata;
			} else {
				return data;
			}
	}
};

// returns the code words (sans ECC bits) for given data and configurations.
// requires data to be preprocessed by validatedata. no length check is
// performed, and everything has to be checked before calling this function.
var encode = function (ver, mode, data, maxbuflen) {
	var buf = [];
	var bits = 0, remaining = 8;
	var datalen = data.length;

	// this function is intentionally no-op when n=0.
	var pack = function (x, n) {
		if (n >= remaining) {
			buf.push(bits | (x >> (n -= remaining)));
			while (n >= 8)
				buf.push((x >> (n -= 8)) & 255);
			bits = 0;
			remaining = 8;
		}
		if (n > 0)
			bits |= (x & ((1 << n) - 1)) << (remaining -= n);
	};

	var nlenbits = ndatalenbits(ver, mode);
	pack(mode, 4);
	pack(datalen, nlenbits);

	switch (mode) {
		case MODE_NUMERIC:
			for (var i = 2; i < datalen; i += 3) {
				pack(parseInt(data.substring(i - 2, i + 1), 10), 10);
			}
			pack(parseInt(data.substring(i - 2), 10), [0, 4, 7][datalen % 3]);
			break;

		case MODE_ALPHANUMERIC:
			for (var i = 1; i < datalen; i += 2) {
				pack(ALPHANUMERIC_MAP[data.charAt(i - 1)] * 45 +
					ALPHANUMERIC_MAP[data.charAt(i)], 11);
			}
			if (datalen % 2 == 1) {
				pack(ALPHANUMERIC_MAP[data.charAt(i - 1)], 6);
			}
			break;

		case MODE_OCTET:
			for (var i = 0; i < datalen; ++i) {
				pack(data[i], 8);
			}
			break;
	}

	// final bits. it is possible that adding terminator causes the buffer
	// to overflow, but then the buffer truncated to the maximum size will
	// be valid as the truncated terminator mode bits and padding is
	// identical in appearance (cf. JIS X 0510:2004 sec 8.4.8).
	pack(MODE_TERMINATOR, 4);
	if (remaining < 8)
		buf.push(bits);

	// the padding to fill up the remaining space. we should not add any
	// words when the overflow already occurred.
	while (buf.length + 1 < maxbuflen)
		buf.push(0xec, 0x11);
	if (buf.length < maxbuflen)
		buf.push(0xec);
	return buf;
};

// calculates ECC code words for given code words and generator polynomial.
//
// this is quite similar to CRC calculation as both Reed-Solomon and CRC use
// the certain kind of cyclic codes, which is effectively the division of
// zero-augumented polynomial by the generator polynomial. the only difference
// is that Reed-Solomon uses GF(2^8), instead of CRC's GF(2), and Reed-Solomon
// uses the different generator polynomial than CRC's.
var calculateecc = function (poly, genpoly) {
	var modulus = poly.slice(0);
	var polylen = poly.length, genpolylen = genpoly.length;
	for (var i = 0; i < genpolylen; ++i)
		modulus.push(0);
	for (var i = 0; i < polylen; ) {
		var quotient = GF256_INVMAP[modulus[i++]];
		if (quotient >= 0) {
			for (var j = 0; j < genpolylen; ++j) {
				modulus[i + j] ^= GF256_MAP[(quotient + genpoly[j]) % 255];
			}
		}
	}
	return modulus.slice(polylen);
};

// auguments ECC code words to given code words. the resulting words are
// ready to be encoded in the matrix.
//
// the much of actual augumenting procedure follows JIS X 0510:2004 sec 8.7.
// the code is simplified using the fact that the size of each code & ECC
// blocks is almost same; for example, when we have 4 blocks and 46 data words
// the number of code words in those blocks are 11, 11, 12, 12 respectively.
var augumenteccs = function (poly, nblocks, genpoly) {
	var subsizes = [];
	var subsize = (poly.length / nblocks) | 0, subsize0 = 0;
	var pivot = nblocks - poly.length % nblocks;
	for (var i = 0; i < pivot; ++i) {
		subsizes.push(subsize0);
		subsize0 += subsize;
	}
	for (var i = pivot; i < nblocks; ++i) {
		subsizes.push(subsize0);
		subsize0 += subsize + 1;
	}
	subsizes.push(subsize0);

	var eccs = [];
	for (var i = 0; i < nblocks; ++i) {
		eccs.push(calculateecc(poly.slice(subsizes[i], subsizes[i + 1]), genpoly));
	}

	var result = [];
	var nitemsperblock = (poly.length / nblocks) | 0;
	for (var i = 0; i < nitemsperblock; ++i) {
		for (var j = 0; j < nblocks; ++j) {
			result.push(poly[subsizes[j] + i]);
		}
	}
	for (var j = pivot; j < nblocks; ++j) {
		result.push(poly[subsizes[j + 1] - 1]);
	}
	for (var i = 0; i < genpoly.length; ++i) {
		for (var j = 0; j < nblocks; ++j) {
			result.push(eccs[j][i]);
		}
	}
	return result;
};

// auguments BCH(p+q,q) code to the polynomial over GF(2), given the proper
// genpoly. the both input and output are in binary numbers, and unlike
// calculateecc genpoly should include the 1 bit for the highest degree.
//
// actual polynomials used for this procedure are as follows:
// - p=10, q=5, genpoly=x^10+x^8+x^5+x^4+x^2+x+1 (JIS X 0510:2004 Appendix C)
// - p=18, q=6, genpoly=x^12+x^11+x^10+x^9+x^8+x^5+x^2+1 (ibid. Appendix D)
var augumentbch = function (poly, p, genpoly, q) {
	var modulus = poly << q;
	for (var i = p - 1; i >= 0; --i) {
		if ((modulus >> (q + i)) & 1)
			modulus ^= genpoly << i;
	}
	return (poly << q) | modulus;
};

// creates the base matrix for given version. it returns two matrices, one of
// them is the actual one and the another represents the "reserved" portion
// (e.g. finder and timing patterns) of the matrix.
//
// some entries in the matrix may be undefined, rather than 0 or 1. this is
// intentional (no initialization needed!), and putdata below will fill
// the remaining ones.
var makebasematrix = function (ver) {
	var v = VERSIONS[ver], n = getsizebyver(ver);
	var matrix = [], reserved = [];
	for (var i = 0; i < n; ++i) {
		matrix.push([]);
		reserved.push([]);
	}

	var blit = function (y, x, h, w, bits) {
		for (var i = 0; i < h; ++i) {
			for (var j = 0; j < w; ++j) {
				matrix[y + i][x + j] = (bits[i] >> j) & 1;
				reserved[y + i][x + j] = 1;
			}
		}
	};

	// finder patterns and a part of timing patterns
	// will also mark the format information area (not yet written) as reserved.
	blit(0, 0, 9, 9, [0x7f, 0x41, 0x5d, 0x5d, 0x5d, 0x41, 0x17f, 0x00, 0x40]);
	blit(n - 8, 0, 8, 9, [0x100, 0x7f, 0x41, 0x5d, 0x5d, 0x5d, 0x41, 0x7f]);
	blit(0, n - 8, 9, 8, [0xfe, 0x82, 0xba, 0xba, 0xba, 0x82, 0xfe, 0x00, 0x00]);

	// the rest of timing patterns
	for (var i = 9; i < n - 8; ++i) {
		matrix[6][i] = matrix[i][6] = ~i & 1;
		reserved[6][i] = reserved[i][6] = 1;
	}

	// alignment patterns
	var aligns = v[2], m = aligns.length;
	for (var i = 0; i < m; ++i) {
		var minj = (i === 0 || i === m - 1 ? 1 : 0), maxj = (i === 0 ? m - 1 : m);
		for (var j = minj; j < maxj; ++j) {
			blit(aligns[i], aligns[j], 5, 5, [0x1f, 0x11, 0x15, 0x11, 0x1f]);
		}
	}

	// version information
	if (needsverinfo(ver)) {
		var code = augumentbch(ver, 6, 0x1f25, 12);
		var k = 0;
		for (var i = 0; i < 6; ++i) {
			for (var j = 0; j < 3; ++j) {
				matrix[i][(n - 11) + j] = matrix[(n - 11) + j][i] = (code >> k++) & 1;
				reserved[i][(n - 11) + j] = reserved[(n - 11) + j][i] = 1;
			}
		}
	}

	return {matrix: matrix, reserved: reserved};
};

// fills the data portion (i.e. unmarked in reserved) of the matrix with given
// code words. the size of code words should be no more than available bits,
// and remaining bits are padded to 0 (cf. JIS X 0510:2004 sec 8.7.3).
var putdata = function (matrix, reserved, buf) {
	var n = matrix.length;
	var k = 0, dir = -1;
	for (var i = n - 1; i >= 0; i -= 2) {
		if (i == 6)
			--i; // skip the entire timing pattern column
		var jj = (dir < 0 ? n - 1 : 0);
		for (var j = 0; j < n; ++j) {
			for (var ii = i; ii > i - 2; --ii) {
				if (!reserved[jj][ii]) {
					// may overflow, but (undefined >> x)
					// is 0 so it will auto-pad to zero.
					matrix[jj][ii] = (buf[k >> 3] >> (~k & 7)) & 1;
					++k;
				}
			}
			jj += dir;
		}
		dir = -dir;
	}
	return matrix;
};

// XOR-masks the data portion of the matrix. repeating the call with the same
// arguments will revert the prior call (convenient in the matrix evaluation).
var maskdata = function (matrix, reserved, mask) {
	var maskf = MASKFUNCS[mask];
	var n = matrix.length;
	for (var i = 0; i < n; ++i) {
		for (var j = 0; j < n; ++j) {
			if (!reserved[i][j])
				matrix[i][j] ^= maskf(i, j);
		}
	}
	return matrix;
};

// puts the format information.
var putformatinfo = function (matrix, reserved, ecclevel, mask) {
	var n = matrix.length;
	var code = augumentbch((ecclevel << 3) | mask, 5, 0x537, 10) ^ 0x5412;
	for (var i = 0; i < 15; ++i) {
		var r = [0, 1, 2, 3, 4, 5, 7, 8, n - 7, n - 6, n - 5, n - 4, n - 3, n - 2, n - 1][i];
		var c = [n - 1, n - 2, n - 3, n - 4, n - 5, n - 6, n - 7, n - 8, 7, 5, 4, 3, 2, 1, 0][i];
		matrix[r][8] = matrix[8][c] = (code >> i) & 1;
		// we don't have to mark those bits reserved; always done
		// in makebasematrix above.
	}
	return matrix;
};

// evaluates the resulting matrix and returns the score (lower is better).
// (cf. JIS X 0510:2004 sec 8.8.2)
//
// the evaluation procedure tries to avoid the problematic patterns naturally
// occuring from the original matrix. for example, it penaltizes the patterns
// which just look like the finder pattern which will confuse the decoder.
// we choose the mask which results in the lowest score among 8 possible ones.
//
// note: zxing seems to use the same procedure and in many cases its choice
// agrees to ours, but sometimes it does not. practically it doesn't matter.
var evaluatematrix = function (matrix) {
	// N1+(k-5) points for each consecutive row of k same-colored modules,
	// where k >= 5. no overlapping row counts.
	var PENALTY_CONSECUTIVE = 3;
	// N2 points for each 2x2 block of same-colored modules.
	// overlapping block does count.
	var PENALTY_TWOBYTWO = 3;
	// N3 points for each pattern with >4W:1B:1W:3B:1W:1B or
	// 1B:1W:3B:1W:1B:>4W, or their multiples (e.g. highly unlikely,
	// but 13W:3B:3W:9B:3W:3B counts).
	var PENALTY_FINDERLIKE = 40;
	// N4*k points for every (5*k)% deviation from 50% black density.
	// i.e. k=1 for 55~60% and 40~45%, k=2 for 60~65% and 35~40%, etc.
	var PENALTY_DENSITY = 10;

	var evaluategroup = function (groups) { // assumes [W,B,W,B,W,...,B,W]
		var score = 0;
		for (var i = 0; i < groups.length; ++i) {
			if (groups[i] >= 5)
				score += PENALTY_CONSECUTIVE + (groups[i] - 5);
		}
		for (var i = 5; i < groups.length; i += 2) {
			var p = groups[i];
			if (groups[i - 1] == p && groups[i - 2] == 3 * p && groups[i - 3] == p &&
				groups[i - 4] == p && (groups[i - 5] >= 4 * p || groups[i + 1] >= 4 * p)) {
				// this part differs from zxing...
				score += PENALTY_FINDERLIKE;
			}
		}
		return score;
	};

	var n = matrix.length;
	var score = 0, nblacks = 0;
	for (var i = 0; i < n; ++i) {
		var row = matrix[i];
		var groups;

		// evaluate the current row
		groups = [0]; // the first empty group of white
		for (var j = 0; j < n; ) {
			var k;
			for (k = 0; j < n && row[j]; ++k)
				++j;
			groups.push(k);
			for (k = 0; j < n && !row[j]; ++k)
				++j;
			groups.push(k);
		}
		score += evaluategroup(groups);

		// evaluate the current column
		groups = [0];
		for (var j = 0; j < n; ) {
			var k;
			for (k = 0; j < n && matrix[j][i]; ++k)
				++j;
			groups.push(k);
			for (k = 0; j < n && !matrix[j][i]; ++k)
				++j;
			groups.push(k);
		}
		score += evaluategroup(groups);

		// check the 2x2 box and calculate the density
		var nextrow = matrix[i + 1] || [];
		nblacks += row[0];
		for (var j = 1; j < n; ++j) {
			var p = row[j];
			nblacks += p;
			// at least comparison with next row should be strict...
			if (row[j - 1] == p && nextrow[j] === p && nextrow[j - 1] === p) {
				score += PENALTY_TWOBYTWO;
			}
		}
	}

	score += PENALTY_DENSITY * ((Math.abs(nblacks / n / n - 0.5) / 0.05) | 0);
	return score;
};

// returns the fully encoded QR code matrix which contains given data.
// it also chooses the best mask automatically when mask is -1.
var generate = function (data, ver, mode, ecclevel, mask) {
	var v = VERSIONS[ver];
	var buf = encode(ver, mode, data, ndatabits(ver, ecclevel) >> 3);
	buf = augumenteccs(buf, v[1][ecclevel], GF256_GENPOLY[v[0][ecclevel]]);

	var result = makebasematrix(ver);
	var matrix = result.matrix, reserved = result.reserved;
	putdata(matrix, reserved, buf);

	if (mask < 0) {
		// find the best mask
		maskdata(matrix, reserved, 0);
		putformatinfo(matrix, reserved, ecclevel, 0);
		var bestmask = 0, bestscore = evaluatematrix(matrix);
		maskdata(matrix, reserved, 0);
		for (mask = 1; mask < 8; ++mask) {
			maskdata(matrix, reserved, mask);
			putformatinfo(matrix, reserved, ecclevel, mask);
			var score = evaluatematrix(matrix);
			if (bestscore > score) {
				bestscore = score;
				bestmask = mask;
			}
			maskdata(matrix, reserved, mask);
		}
		mask = bestmask;
	}

	maskdata(matrix, reserved, mask);
	putformatinfo(matrix, reserved, ecclevel, mask);
	return matrix;
};

// the public interface is trivial; the options available are as follows:
//
// - version: an integer in [1,40]. when omitted (or -1) the smallest possible
//   version is chosen.
// - mode: one of 'numeric', 'alphanumeric', 'octet'. when omitted the smallest
//   possible mode is chosen.
// - eccLevel: one of 'L', 'M', 'Q', 'H'. defaults to 'L'.
// - mask: an integer in [0,7]. when omitted (or -1) the best mask is chosen.
//

function generateFrame(data, options) {
	var MODES = {'numeric': MODE_NUMERIC, 'alphanumeric': MODE_ALPHANUMERIC,
		'octet': MODE_OCTET};
	var ECCLEVELS = {'L': ECCLEVEL_L, 'M': ECCLEVEL_M, 'Q': ECCLEVEL_Q,
		'H': ECCLEVEL_H};

	options = options || {};
	var ver = options.version || -1;
	var ecclevel = ECCLEVELS[(options.eccLevel || 'L').toUpperCase()];
	var mode = options.mode ? MODES[options.mode.toLowerCase()] : -1;
	var mask = 'mask' in options ? options.mask : -1;

	if (mode < 0) {
		if (typeof data === 'string') {
			if (data.match(NUMERIC_REGEXP)) {
				mode = MODE_NUMERIC;
			} else if (data.match(ALPHANUMERIC_OUT_REGEXP)) {
				// while encode supports case-insensitive encoding, we restrict the data to be uppercased when auto-selecting the mode.
				mode = MODE_ALPHANUMERIC;
			} else {
				mode = MODE_OCTET;
			}
		} else {
			mode = MODE_OCTET;
		}
	} else if (!(mode == MODE_NUMERIC || mode == MODE_ALPHANUMERIC ||
		mode == MODE_OCTET)) {
		throw 'invalid or unsupported mode';
	}

	data = validatedata(mode, data);
	if (data === null)
		throw 'invalid data format';

	if (ecclevel < 0 || ecclevel > 3)
		throw 'invalid ECC level';

	if (ver < 0) {
		for (ver = 1; ver <= 40; ++ver) {
			if (data.length <= getmaxdatalen(ver, mode, ecclevel))
				break;
		}
		if (ver > 40)
			throw 'too large data for the Qr format';
	} else if (ver < 1 || ver > 40) {
		throw 'invalid Qr version! should be between 1 and 40';
	}

	if (mask != -1 && (mask < 0 || mask > 8))
		throw 'invalid mask';
	//console.log('version:', ver, 'mode:', mode, 'ECC:', ecclevel, 'mask:', mask )
	return generate(data, ver, mode, ecclevel, mask);
}


// options
// - modulesize: a number. this is a size of each modules in pixels, and
//   defaults to 5px.
// - margin: a number. this is a size of margin in *modules*, and defaults to
//   4 (white modules). the specficiation mandates the margin no less than 4
//   modules, so it is better not to alter this value unless you know what
//   you're doing.
function buildCanvas(data, options) {

	var canvas = [];
	var background = options.background || '#fff';
	var foreground = options.foreground || '#000';
	//var margin = options.margin || 4;
	var matrix = generateFrame(data, options);
	var n = matrix.length;
	var modSize = Math.floor(options.fit ? options.fit / n : 5);
	var size = n * modSize;

	canvas.push({
		type: 'rect',
		x: 0, y: 0, w: size, h: size, lineWidth: 0, color: background
	});

	for (var i = 0; i < n; ++i) {
		for (var j = 0; j < n; ++j) {
			if (matrix[i][j]) {
				canvas.push({
					type: 'rect',
					x: modSize * j,
					y: modSize * i,
					w: modSize,
					h: modSize,
					lineWidth: 0,
					color: foreground
				});
			}
		}
	}

	return {
		canvas: canvas,
		size: size
	};

}

function measure(node) {
	var cd = buildCanvas(node.qr, node);
	node._canvas = cd.canvas;
	node._width = node._height = node._minWidth = node._maxWidth = node._minHeight = node._maxHeight = cd.size;
	return node;
}

module.exports = {
	measure: measure
};

/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ElementWriter = __webpack_require__(136);

/**
 * Creates an instance of PageElementWriter - an extended ElementWriter
 * which can handle:
 * - page-breaks (it adds new pages when there's not enough space left),
 * - repeatable fragments (like table-headers, which are repeated everytime
 *                         a page-break occurs)
 * - transactions (used for unbreakable-blocks when we want to make sure
 *                 whole block will be rendered on the same page)
 */
function PageElementWriter(context, tracker) {
	this.transactionLevel = 0;
	this.repeatables = [];
	this.tracker = tracker;
	this.writer = new ElementWriter(context, tracker);
}

function fitOnPage(self, addFct) {
	var position = addFct(self);
	if (!position) {
		self.moveToNextPage();
		position = addFct(self);
	}
	return position;
}

PageElementWriter.prototype.addLine = function (line, dontUpdateContextPosition, index) {
	return fitOnPage(this, function (self) {
		return self.writer.addLine(line, dontUpdateContextPosition, index);
	});
};

PageElementWriter.prototype.addImage = function (image, index) {
	return fitOnPage(this, function (self) {
		return self.writer.addImage(image, index);
	});
};

PageElementWriter.prototype.addQr = function (qr, index) {
	return fitOnPage(this, function (self) {
		return self.writer.addQr(qr, index);
	});
};

PageElementWriter.prototype.addVector = function (vector, ignoreContextX, ignoreContextY, index) {
	return this.writer.addVector(vector, ignoreContextX, ignoreContextY, index);
};

PageElementWriter.prototype.beginClip = function (width, height) {
	return this.writer.beginClip(width, height);
};

PageElementWriter.prototype.endClip = function () {
	return this.writer.endClip();
};

PageElementWriter.prototype.alignCanvas = function (node) {
	this.writer.alignCanvas(node);
};

PageElementWriter.prototype.addFragment = function (fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition) {
	if (!this.writer.addFragment(fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition)) {
		this.moveToNextPage();
		this.writer.addFragment(fragment, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition);
	}
};

PageElementWriter.prototype.moveToNextPage = function (pageOrientation) {

	var nextPage = this.writer.context.moveToNextPage(pageOrientation);

	if (nextPage.newPageCreated) {
		this.repeatables.forEach(function (rep) {
			this.writer.addFragment(rep, true);
		}, this);
	} else {
		this.repeatables.forEach(function (rep) {
			this.writer.context.moveDown(rep.height);
		}, this);
	}

	this.writer.tracker.emit('pageChanged', {
		prevPage: nextPage.prevPage,
		prevY: nextPage.prevY,
		y: nextPage.y
	});
};

PageElementWriter.prototype.beginUnbreakableBlock = function (width, height) {
	if (this.transactionLevel++ === 0) {
		this.originalX = this.writer.context.x;
		this.writer.pushContext(width, height);
	}
};

PageElementWriter.prototype.commitUnbreakableBlock = function (forcedX, forcedY) {
	if (--this.transactionLevel === 0) {
		var unbreakableContext = this.writer.context;
		this.writer.popContext();

		var nbPages = unbreakableContext.pages.length;
		if (nbPages > 0) {
			// no support for multi-page unbreakableBlocks
			var fragment = unbreakableContext.pages[0];
			fragment.xOffset = forcedX;
			fragment.yOffset = forcedY;

			//TODO: vectors can influence height in some situations
			if (nbPages > 1) {
				// on out-of-context blocs (headers, footers, background) height should be the whole DocumentContext height
				if (forcedX !== undefined || forcedY !== undefined) {
					fragment.height = unbreakableContext.getCurrentPage().pageSize.height - unbreakableContext.pageMargins.top - unbreakableContext.pageMargins.bottom;
				} else {
					fragment.height = this.writer.context.getCurrentPage().pageSize.height - this.writer.context.pageMargins.top - this.writer.context.pageMargins.bottom;
					for (var i = 0, l = this.repeatables.length; i < l; i++) {
						fragment.height -= this.repeatables[i].height;
					}
				}
			} else {
				fragment.height = unbreakableContext.y;
			}

			if (forcedX !== undefined || forcedY !== undefined) {
				this.writer.addFragment(fragment, true, true, true);
			} else {
				this.addFragment(fragment);
			}
		}
	}
};

PageElementWriter.prototype.currentBlockToRepeatable = function () {
	var unbreakableContext = this.writer.context;
	var rep = {items: []};

	unbreakableContext.pages[0].items.forEach(function (item) {
		rep.items.push(item);
	});

	rep.xOffset = this.originalX;

	//TODO: vectors can influence height in some situations
	rep.height = unbreakableContext.y;

	return rep;
};

PageElementWriter.prototype.pushToRepeatables = function (rep) {
	this.repeatables.push(rep);
};

PageElementWriter.prototype.popFromRepeatables = function () {
	this.repeatables.pop();
};

PageElementWriter.prototype.context = function () {
	return this.writer.context;
};

module.exports = PageElementWriter;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Line = __webpack_require__(82);
var isNumber = __webpack_require__(0).isNumber;
var pack = __webpack_require__(0).pack;
var offsetVector = __webpack_require__(0).offsetVector;
var DocumentContext = __webpack_require__(81);

/**
 * Creates an instance of ElementWriter - a line/vector writer, which adds
 * elements to current page and sets their positions based on the context
 */
function ElementWriter(context, tracker) {
	this.context = context;
	this.contextStack = [];
	this.tracker = tracker;
}

function addPageItem(page, item, index) {
	if (index === null || index === undefined || index < 0 || index > page.items.length) {
		page.items.push(item);
	} else {
		page.items.splice(index, 0, item);
	}
}

ElementWriter.prototype.addLine = function (line, dontUpdateContextPosition, index) {
	var height = line.getHeight();
	var context = this.context;
	var page = context.getCurrentPage(),
		position = this.getCurrentPositionOnPage();

	if (context.availableHeight < height || !page) {
		return false;
	}

	line.x = context.x + (line.x || 0);
	line.y = context.y + (line.y || 0);

	this.alignLine(line);

	addPageItem(page, {
		type: 'line',
		item: line
	}, index);
	this.tracker.emit('lineAdded', line);

	if (!dontUpdateContextPosition) {
		context.moveDown(height);
	}

	return position;
};

ElementWriter.prototype.alignLine = function (line) {
	var width = this.context.availableWidth;
	var lineWidth = line.getWidth();

	var alignment = line.inlines && line.inlines.length > 0 && line.inlines[0].alignment;

	var offset = 0;
	switch (alignment) {
		case 'right':
			offset = width - lineWidth;
			break;
		case 'center':
			offset = (width - lineWidth) / 2;
			break;
	}

	if (offset) {
		line.x = (line.x || 0) + offset;
	}

	if (alignment === 'justify' &&
		!line.newLineForced &&
		!line.lastLineInParagraph &&
		line.inlines.length > 1) {
		var additionalSpacing = (width - lineWidth) / (line.inlines.length - 1);

		for (var i = 1, l = line.inlines.length; i < l; i++) {
			offset = i * additionalSpacing;

			line.inlines[i].x += offset;
			line.inlines[i].justifyShift = additionalSpacing;
		}
	}
};

ElementWriter.prototype.addImage = function (image, index) {
	var context = this.context;
	var page = context.getCurrentPage(),
		position = this.getCurrentPositionOnPage();

	if (!page || (image.absolutePosition === undefined && context.availableHeight < image._height && page.items.length > 0)) {
		return false;
	}

	if (image._x === undefined) {
		image._x = image.x || 0;
	}

	image.x = context.x + image._x;
	image.y = context.y;

	this.alignImage(image);

	addPageItem(page, {
		type: 'image',
		item: image
	}, index);

	context.moveDown(image._height);

	return position;
};

ElementWriter.prototype.addQr = function (qr, index) {
	var context = this.context;
	var page = context.getCurrentPage(),
		position = this.getCurrentPositionOnPage();

	if (!page || (qr.absolutePosition === undefined && context.availableHeight < qr._height)) {
		return false;
	}

	if (qr._x === undefined) {
		qr._x = qr.x || 0;
	}

	qr.x = context.x + qr._x;
	qr.y = context.y;

	this.alignImage(qr);

	for (var i = 0, l = qr._canvas.length; i < l; i++) {
		var vector = qr._canvas[i];
		vector.x += qr.x;
		vector.y += qr.y;
		this.addVector(vector, true, true, index);
	}

	context.moveDown(qr._height);

	return position;
};

ElementWriter.prototype.alignImage = function (image) {
	var width = this.context.availableWidth;
	var imageWidth = image._minWidth;
	var offset = 0;
	switch (image._alignment) {
		case 'right':
			offset = width - imageWidth;
			break;
		case 'center':
			offset = (width - imageWidth) / 2;
			break;
	}

	if (offset) {
		image.x = (image.x || 0) + offset;
	}
};

ElementWriter.prototype.alignCanvas = function (node) {
	var width = this.context.availableWidth;
	var canvasWidth = node._minWidth;
	var offset = 0;
	switch (node._alignment) {
		case 'right':
			offset = width - canvasWidth;
			break;
		case 'center':
			offset = (width - canvasWidth) / 2;
			break;
	}
	if (offset) {
		node.canvas.forEach(function (vector) {
			offsetVector(vector, offset, 0);
		});
	}
};

ElementWriter.prototype.addVector = function (vector, ignoreContextX, ignoreContextY, index) {
	var context = this.context;
	var page = context.getCurrentPage(),
		position = this.getCurrentPositionOnPage();

	if (page) {
		offsetVector(vector, ignoreContextX ? 0 : context.x, ignoreContextY ? 0 : context.y);
		addPageItem(page, {
			type: 'vector',
			item: vector
		}, index);
		return position;
	}
};

ElementWriter.prototype.beginClip = function (width, height) {
	var ctx = this.context;
	var page = ctx.getCurrentPage();
	page.items.push({
		type: 'beginClip',
		item: {x: ctx.x, y: ctx.y, width: width, height: height}
	});
	return true;
};

ElementWriter.prototype.endClip = function () {
	var ctx = this.context;
	var page = ctx.getCurrentPage();
	page.items.push({
		type: 'endClip'
	});
	return true;
};

function cloneLine(line) {
	var result = new Line(line.maxWidth);

	for (var key in line) {
		if (line.hasOwnProperty(key)) {
			result[key] = line[key];
		}
	}

	return result;
}

ElementWriter.prototype.addFragment = function (block, useBlockXOffset, useBlockYOffset, dontUpdateContextPosition) {
	var ctx = this.context;
	var page = ctx.getCurrentPage();

	if (!useBlockXOffset && block.height > ctx.availableHeight) {
		return false;
	}

	block.items.forEach(function (item) {
		switch (item.type) {
			case 'line':
				var l = cloneLine(item.item);

				l.x = (l.x || 0) + (useBlockXOffset ? (block.xOffset || 0) : ctx.x);
				l.y = (l.y || 0) + (useBlockYOffset ? (block.yOffset || 0) : ctx.y);

				page.items.push({
					type: 'line',
					item: l
				});
				break;

			case 'vector':
				var v = pack(item.item);

				offsetVector(v, useBlockXOffset ? (block.xOffset || 0) : ctx.x, useBlockYOffset ? (block.yOffset || 0) : ctx.y);
				page.items.push({
					type: 'vector',
					item: v
				});
				break;

			case 'image':
				var img = pack(item.item);

				img.x = (img.x || 0) + (useBlockXOffset ? (block.xOffset || 0) : ctx.x);
				img.y = (img.y || 0) + (useBlockYOffset ? (block.yOffset || 0) : ctx.y);

				page.items.push({
					type: 'image',
					item: img
				});
				break;
		}
	});

	if (!dontUpdateContextPosition) {
		ctx.moveDown(block.height);
	}

	return true;
};

/**
 * Pushes the provided context onto the stack or creates a new one
 *
 * pushContext(context) - pushes the provided context and makes it current
 * pushContext(width, height) - creates and pushes a new context with the specified width and height
 * pushContext() - creates a new context for unbreakable blocks (with current availableWidth and full-page-height)
 */
ElementWriter.prototype.pushContext = function (contextOrWidth, height) {
	if (contextOrWidth === undefined) {
		height = this.context.getCurrentPage().height - this.context.pageMargins.top - this.context.pageMargins.bottom;
		contextOrWidth = this.context.availableWidth;
	}

	if (isNumber(contextOrWidth)) {
		contextOrWidth = new DocumentContext({width: contextOrWidth, height: height}, {left: 0, right: 0, top: 0, bottom: 0});
	}

	this.contextStack.push(this.context);
	this.context = contextOrWidth;
};

ElementWriter.prototype.popContext = function () {
	this.context = this.contextStack.pop();
};

ElementWriter.prototype.getCurrentPositionOnPage = function () {
	return (this.contextStack[0] || this.context).getCurrentPosition();
};


module.exports = ElementWriter;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ColumnCalculator = __webpack_require__(44);
var isFunction = __webpack_require__(0).isFunction;

function TableProcessor(tableNode) {
	this.tableNode = tableNode;
}

TableProcessor.prototype.beginTable = function (writer) {
	var tableNode;
	var availableWidth;
	var self = this;

	tableNode = this.tableNode;
	this.offsets = tableNode._offsets;
	this.layout = tableNode._layout;

	availableWidth = writer.context().availableWidth - this.offsets.total;
	ColumnCalculator.buildColumnWidths(tableNode.table.widths, availableWidth);

	this.tableWidth = tableNode._offsets.total + getTableInnerContentWidth();
	this.rowSpanData = prepareRowSpanData();
	this.cleanUpRepeatables = false;

	this.headerRows = tableNode.table.headerRows || 0;
	this.rowsWithoutPageBreak = this.headerRows + (tableNode.table.keepWithHeaderRows || 0);
	this.dontBreakRows = tableNode.table.dontBreakRows || false;

	if (this.rowsWithoutPageBreak) {
		writer.beginUnbreakableBlock();
	}

	// update the border properties of all cells before drawing any lines
	prepareCellBorders(this.tableNode.table.body);

	this.drawHorizontalLine(0, writer);

	function getTableInnerContentWidth() {
		var width = 0;

		tableNode.table.widths.forEach(function (w) {
			width += w._calcWidth;
		});

		return width;
	}

	function prepareRowSpanData() {
		var rsd = [];
		var x = 0;
		var lastWidth = 0;

		rsd.push({left: 0, rowSpan: 0});

		for (var i = 0, l = self.tableNode.table.body[0].length; i < l; i++) {
			var paddings = self.layout.paddingLeft(i, self.tableNode) + self.layout.paddingRight(i, self.tableNode);
			var lBorder = self.layout.vLineWidth(i, self.tableNode);
			lastWidth = paddings + lBorder + self.tableNode.table.widths[i]._calcWidth;
			rsd[rsd.length - 1].width = lastWidth;
			x += lastWidth;
			rsd.push({left: x, rowSpan: 0, width: 0});
		}

		return rsd;
	}

	// Iterate through all cells. If the current cell is the start of a
	// rowSpan/colSpan, update the border property of the cells on its
	// bottom/right accordingly. This is needed since each iteration of the
	// line-drawing loops draws lines for a single cell, not for an entire
	// rowSpan/colSpan.
	function prepareCellBorders(body) {
		for (var rowIndex = 0; rowIndex < body.length; rowIndex++) {
			var row = body[rowIndex];

			for (var colIndex = 0; colIndex < row.length; colIndex++) {
				var cell = row[colIndex];

				if (cell.border) {
					var rowSpan = cell.rowSpan || 1;
					var colSpan = cell.colSpan || 1;

					for (var rowOffset = 0; rowOffset < rowSpan; rowOffset++) {
						// set left border
						if (cell.border[0] !== undefined && rowOffset > 0) {
							setBorder(rowIndex + rowOffset, colIndex, 0, cell.border[0]);
						}

						// set right border
						if (cell.border[2] !== undefined) {
							setBorder(rowIndex + rowOffset, colIndex + colSpan - 1, 2, cell.border[2]);
						}
					}

					for (var colOffset = 0; colOffset < colSpan; colOffset++) {
						// set top border
						if (cell.border[1] !== undefined && colOffset > 0) {
							setBorder(rowIndex, colIndex + colOffset, 1, cell.border[1]);
						}

						// set bottom border
						if (cell.border[3] !== undefined) {
							setBorder(rowIndex + rowSpan - 1, colIndex + colOffset, 3, cell.border[3]);
						}
					}
				}
			}
		}

		// helper function to set the border for a given cell
		function setBorder(rowIndex, colIndex, borderIndex, borderValue) {
			var cell = body[rowIndex][colIndex];
			cell.border = cell.border || {};
			cell.border[borderIndex] = borderValue;
		}
	}
};

TableProcessor.prototype.onRowBreak = function (rowIndex, writer) {
	var self = this;
	return function () {
		var offset = self.rowPaddingTop + (!self.headerRows ? self.topLineWidth : 0);
		writer.context().availableHeight -= self.reservedAtBottom;
		writer.context().moveDown(offset);
	};
};

TableProcessor.prototype.beginRow = function (rowIndex, writer) {
	this.topLineWidth = this.layout.hLineWidth(rowIndex, this.tableNode);
	this.rowPaddingTop = this.layout.paddingTop(rowIndex, this.tableNode);
	this.bottomLineWidth = this.layout.hLineWidth(rowIndex + 1, this.tableNode);
	this.rowPaddingBottom = this.layout.paddingBottom(rowIndex, this.tableNode);

	this.rowCallback = this.onRowBreak(rowIndex, writer);
	writer.tracker.startTracking('pageChanged', this.rowCallback);
	if (this.dontBreakRows) {
		writer.beginUnbreakableBlock();
	}
	this.rowTopY = writer.context().y;
	this.reservedAtBottom = this.bottomLineWidth + this.rowPaddingBottom;

	writer.context().availableHeight -= this.reservedAtBottom;

	writer.context().moveDown(this.rowPaddingTop);
};

TableProcessor.prototype.drawHorizontalLine = function (lineIndex, writer, overrideY) {
	var lineWidth = this.layout.hLineWidth(lineIndex, this.tableNode);
	if (lineWidth) {
		var offset = lineWidth / 2;
		var currentLine = null;
		var body = this.tableNode.table.body;

		for (var i = 0, l = this.rowSpanData.length; i < l; i++) {
			var data = this.rowSpanData[i];
			var shouldDrawLine = !data.rowSpan;

			// draw only if the current cell requires a top border or the cell in the
			// row above requires a bottom border
			if (shouldDrawLine && i < l - 1) {
				var topBorder = false, bottomBorder = false;

				// the current cell
				if (lineIndex < body.length) {
					var cell = body[lineIndex][i];
					topBorder = cell.border ? cell.border[1] : this.layout.defaultBorder;
				}

				// the cell in the row above
				if (lineIndex > 0) {
					var cellAbove = body[lineIndex - 1][i];
					bottomBorder = cellAbove.border ? cellAbove.border[3] : this.layout.defaultBorder;
				}

				shouldDrawLine = topBorder || bottomBorder;
			}

			if (!currentLine && shouldDrawLine) {
				currentLine = {left: data.left, width: 0};
			}

			if (shouldDrawLine) {
				currentLine.width += (data.width || 0);
			}

			var y = (overrideY || 0) + offset;

			if (!shouldDrawLine || i === l - 1) {
				if (currentLine && currentLine.width) {
					writer.addVector({
						type: 'line',
						x1: currentLine.left,
						x2: currentLine.left + currentLine.width,
						y1: y,
						y2: y,
						lineWidth: lineWidth,
						lineColor: isFunction(this.layout.hLineColor) ? this.layout.hLineColor(lineIndex, this.tableNode) : this.layout.hLineColor
					}, false, overrideY);
					currentLine = null;
				}
			}
		}

		writer.context().moveDown(lineWidth);
	}
};

TableProcessor.prototype.drawVerticalLine = function (x, y0, y1, vLineIndex, writer) {
	var width = this.layout.vLineWidth(vLineIndex, this.tableNode);
	if (width === 0) {
		return;
	}
	writer.addVector({
		type: 'line',
		x1: x + width / 2,
		x2: x + width / 2,
		y1: y0,
		y2: y1,
		lineWidth: width,
		lineColor: isFunction(this.layout.vLineColor) ? this.layout.vLineColor(vLineIndex, this.tableNode) : this.layout.vLineColor
	}, false, true);
};

TableProcessor.prototype.endTable = function (writer) {
	if (this.cleanUpRepeatables) {
		writer.popFromRepeatables();
		this.headerRepeatableHeight = null;
	}
};

TableProcessor.prototype.endRow = function (rowIndex, writer, pageBreaks) {
	var l, i;
	var self = this;
	writer.tracker.stopTracking('pageChanged', this.rowCallback);
	writer.context().moveDown(this.layout.paddingBottom(rowIndex, this.tableNode));
	writer.context().availableHeight += this.reservedAtBottom;

	var endingPage = writer.context().page;
	var endingY = writer.context().y;

	var xs = getLineXs();

	var ys = [];

	var hasBreaks = pageBreaks && pageBreaks.length > 0;
	var body = this.tableNode.table.body;

	ys.push({
		y0: this.rowTopY,
		page: hasBreaks ? pageBreaks[0].prevPage : endingPage
	});

	if (hasBreaks) {
		for (i = 0, l = pageBreaks.length; i < l; i++) {
			var pageBreak = pageBreaks[i];
			ys[ys.length - 1].y1 = pageBreak.prevY;

			ys.push({y0: pageBreak.y, page: pageBreak.prevPage + 1});

			if (this.headerRepeatableHeight) {
				ys[ys.length - 1].y0 += this.headerRepeatableHeight;
			}
		}
	}

	ys[ys.length - 1].y1 = endingY;

	var skipOrphanePadding = (ys[0].y1 - ys[0].y0 === this.rowPaddingTop);
	for (var yi = (skipOrphanePadding ? 1 : 0), yl = ys.length; yi < yl; yi++) {
		var willBreak = yi < ys.length - 1;
		var rowBreakWithoutHeader = (yi > 0 && !this.headerRows);
		var hzLineOffset = rowBreakWithoutHeader ? 0 : this.topLineWidth;
		var y1 = ys[yi].y0;
		var y2 = ys[yi].y1;

		if (willBreak) {
			y2 = y2 + this.rowPaddingBottom;
		}

		if (writer.context().page != ys[yi].page) {
			writer.context().page = ys[yi].page;

			//TODO: buggy, availableHeight should be updated on every pageChanged event
			// TableProcessor should be pageChanged listener, instead of processRow
			this.reservedAtBottom = 0;
		}

		for (i = 0, l = xs.length; i < l; i++) {
			var leftBorder = false, rightBorder = false;
			var colIndex = xs[i].index;

			// the current cell
			if (colIndex < body[rowIndex].length) {
				var cell = body[rowIndex][colIndex];
				leftBorder = cell.border ? cell.border[0] : this.layout.defaultBorder;
			}

			// the cell from before column
			if (colIndex > 0) {
				var cell = body[rowIndex][colIndex - 1];
				rightBorder = cell.border ? cell.border[2] : this.layout.defaultBorder;
			}

			if (leftBorder || rightBorder) {
				this.drawVerticalLine(xs[i].x, y1 - hzLineOffset, y2 + this.bottomLineWidth, xs[i].index, writer);
			}

			if (i < l - 1) {
				var fillColor = body[rowIndex][colIndex].fillColor;
				if (!fillColor) {
					fillColor = isFunction(this.layout.fillColor) ? this.layout.fillColor(rowIndex, this.tableNode, colIndex) : this.layout.fillColor;
				}
				if (fillColor) {
					var wBorder = (leftBorder || rightBorder) ? this.layout.vLineWidth(colIndex, this.tableNode) : 0;
					var xf = xs[i].x + wBorder;
					var yf = this.dontBreakRows ? y1 : y1 - hzLineOffset;
					writer.addVector({
						type: 'rect',
						x: xf,
						y: yf,
						w: xs[i + 1].x - xf,
						h: y2 + this.bottomLineWidth - yf,
						lineWidth: 0,
						color: fillColor
					}, false, true, writer.context().hasBackground ? 1 : 0);
				}
			}
		}

		if (willBreak && this.layout.hLineWhenBroken !== false) {
			this.drawHorizontalLine(rowIndex + 1, writer, y2);
		}
		if (rowBreakWithoutHeader && this.layout.hLineWhenBroken !== false) {
			this.drawHorizontalLine(rowIndex, writer, y1);
		}
	}

	writer.context().page = endingPage;
	writer.context().y = endingY;

	var row = this.tableNode.table.body[rowIndex];
	for (i = 0, l = row.length; i < l; i++) {
		if (row[i].rowSpan) {
			this.rowSpanData[i].rowSpan = row[i].rowSpan;

			// fix colSpans
			if (row[i].colSpan && row[i].colSpan > 1) {
				for (var j = 1; j < row[i].rowSpan; j++) {
					this.tableNode.table.body[rowIndex + j][i]._colSpan = row[i].colSpan;
				}
			}
		}

		if (this.rowSpanData[i].rowSpan > 0) {
			this.rowSpanData[i].rowSpan--;
		}
	}

	this.drawHorizontalLine(rowIndex + 1, writer);

	if (this.headerRows && rowIndex === this.headerRows - 1) {
		this.headerRepeatable = writer.currentBlockToRepeatable();
	}

	if (this.dontBreakRows) {
		writer.tracker.auto('pageChanged',
			function () {
				if (!self.headerRows && self.layout.hLineWhenBroken !== false) {
					self.drawHorizontalLine(rowIndex, writer);
				}
			},
			function () {
				writer.commitUnbreakableBlock();
			}
		);
	}

	if (this.headerRepeatable && (rowIndex === (this.rowsWithoutPageBreak - 1) || rowIndex === this.tableNode.table.body.length - 1)) {
		this.headerRepeatableHeight = this.headerRepeatable.height;
		writer.commitUnbreakableBlock();
		writer.pushToRepeatables(this.headerRepeatable);
		this.cleanUpRepeatables = true;
		this.headerRepeatable = null;
	}

	function getLineXs() {
		var result = [];
		var cols = 0;

		for (var i = 0, l = self.tableNode.table.body[rowIndex].length; i < l; i++) {
			if (!cols) {
				result.push({x: self.rowSpanData[i].left, index: i});

				var item = self.tableNode.table.body[rowIndex][i];
				cols = (item._colSpan || item.colSpan || 0);
			}
			if (cols > 0) {
				cols--;
			}
		}

		result.push({x: self.rowSpanData[self.rowSpanData.length - 1].left, index: self.rowSpanData.length - 1});

		return result;
	}
};

module.exports = TableProcessor;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Generated by CoffeeScript 1.12.6

/*
PDFDocument - represents an entire PDF document
By Devon Govett
 */

(function() {
  var PDFDocument, PDFObject, PDFPage, PDFReference, fs, stream,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  stream = __webpack_require__(15);

  fs = __webpack_require__(8);

  PDFObject = __webpack_require__(26);

  PDFReference = __webpack_require__(87);

  PDFPage = __webpack_require__(161);

  PDFDocument = (function(superClass) {
    var mixin;

    extend(PDFDocument, superClass);

    function PDFDocument(options1) {
      var key, ref1, ref2, val;
      this.options = options1 != null ? options1 : {};
      PDFDocument.__super__.constructor.apply(this, arguments);
      this.version = 1.3;
      this.compress = (ref1 = this.options.compress) != null ? ref1 : true;
      this._pageBuffer = [];
      this._pageBufferStart = 0;
      this._offsets = [];
      this._waiting = 0;
      this._ended = false;
      this._offset = 0;
      this._root = this.ref({
        Type: 'Catalog',
        Pages: this.ref({
          Type: 'Pages',
          Count: 0,
          Kids: []
        })
      });
      this.page = null;
      this.initColor();
      this.initVector();
      this.initFonts();
      this.initText();
      this.initImages();
      this.info = {
        Producer: 'PDFKit',
        Creator: 'PDFKit',
        CreationDate: new Date()
      };
      if (this.options.info) {
        ref2 = this.options.info;
        for (key in ref2) {
          val = ref2[key];
          this.info[key] = val;
        }
      }
      this._write("%PDF-" + this.version);
      this._write("%\xFF\xFF\xFF\xFF");
      if (this.options.autoFirstPage !== false) {
        this.addPage();
      }
    }

    mixin = function(methods) {
      var method, name, results;
      results = [];
      for (name in methods) {
        method = methods[name];
        results.push(PDFDocument.prototype[name] = method);
      }
      return results;
    };

    mixin(__webpack_require__(162));

    mixin(__webpack_require__(164));

    mixin(__webpack_require__(166));

    mixin(__webpack_require__(295));

    mixin(__webpack_require__(297));

    mixin(__webpack_require__(302));

    PDFDocument.prototype.addPage = function(options) {
      var pages;
      if (options == null) {
        options = this.options;
      }
      if (!this.options.bufferPages) {
        this.flushPages();
      }
      this.page = new PDFPage(this, options);
      this._pageBuffer.push(this.page);
      pages = this._root.data.Pages.data;
      pages.Kids.push(this.page.dictionary);
      pages.Count++;
      this.x = this.page.margins.left;
      this.y = this.page.margins.top;
      this._ctm = [1, 0, 0, 1, 0, 0];
      this.transform(1, 0, 0, -1, 0, this.page.height);
      this.emit('pageAdded');
      return this;
    };

    PDFDocument.prototype.bufferedPageRange = function() {
      return {
        start: this._pageBufferStart,
        count: this._pageBuffer.length
      };
    };

    PDFDocument.prototype.switchToPage = function(n) {
      var page;
      if (!(page = this._pageBuffer[n - this._pageBufferStart])) {
        throw new Error("switchToPage(" + n + ") out of bounds, current buffer covers pages " + this._pageBufferStart + " to " + (this._pageBufferStart + this._pageBuffer.length - 1));
      }
      return this.page = page;
    };

    PDFDocument.prototype.flushPages = function() {
      var i, len, page, pages;
      pages = this._pageBuffer;
      this._pageBuffer = [];
      this._pageBufferStart += pages.length;
      for (i = 0, len = pages.length; i < len; i++) {
        page = pages[i];
        page.end();
      }
    };

    PDFDocument.prototype.ref = function(data) {
      var ref;
      ref = new PDFReference(this, this._offsets.length + 1, data);
      this._offsets.push(null);
      this._waiting++;
      return ref;
    };

    PDFDocument.prototype._read = function() {};

    PDFDocument.prototype._write = function(data) {
      if (!Buffer.isBuffer(data)) {
        data = new Buffer(data + '\n', 'binary');
      }
      this.push(data);
      return this._offset += data.length;
    };

    PDFDocument.prototype.addContent = function(data) {
      this.page.write(data);
      return this;
    };

    PDFDocument.prototype._refEnd = function(ref) {
      this._offsets[ref.id - 1] = ref.offset;
      if (--this._waiting === 0 && this._ended) {
        this._finalize();
        return this._ended = false;
      }
    };

    PDFDocument.prototype.write = function(filename, fn) {
      var err;
      err = new Error('PDFDocument#write is deprecated, and will be removed in a future version of PDFKit. Please pipe the document into a Node stream.');
      console.warn(err.stack);
      this.pipe(fs.createWriteStream(filename));
      this.end();
      return this.once('end', fn);
    };

    PDFDocument.prototype.output = function(fn) {
      throw new Error('PDFDocument#output is deprecated, and has been removed from PDFKit. Please pipe the document into a Node stream.');
    };

    PDFDocument.prototype.end = function() {
      var font, key, name, ref1, ref2, val;
      this.flushPages();
      this._info = this.ref();
      ref1 = this.info;
      for (key in ref1) {
        val = ref1[key];
        if (typeof val === 'string') {
          val = new String(val);
        }
        this._info.data[key] = val;
      }
      this._info.end();
      ref2 = this._fontFamilies;
      for (name in ref2) {
        font = ref2[name];
        font.finalize();
      }
      this._root.end();
      this._root.data.Pages.end();
      if (this._waiting === 0) {
        return this._finalize();
      } else {
        return this._ended = true;
      }
    };

    PDFDocument.prototype._finalize = function(fn) {
      var i, len, offset, ref1, xRefOffset;
      xRefOffset = this._offset;
      this._write("xref");
      this._write("0 " + (this._offsets.length + 1));
      this._write("0000000000 65535 f ");
      ref1 = this._offsets;
      for (i = 0, len = ref1.length; i < len; i++) {
        offset = ref1[i];
        offset = ('0000000000' + offset).slice(-10);
        this._write(offset + ' 00000 n ');
      }
      this._write('trailer');
      this._write(PDFObject.convert({
        Size: this._offsets.length + 1,
        Root: this._root,
        Info: this._info
      }));
      this._write('startxref');
      this._write("" + xRefOffset);
      this._write('%%EOF');
      return this.push(null);
    };

    PDFDocument.prototype.toString = function() {
      return "[object PDFDocument]";
    };

    return PDFDocument;

  })(stream.Readable);

  module.exports = PDFDocument;

}).call(this);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer))

/***/ }),
/* 139 */
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Buffer = __webpack_require__(33).Buffer;
var util = __webpack_require__(141);

function copyBuffer(src, target, offset) {
  src.copy(target, offset);
}

module.exports = function () {
  function BufferList() {
    _classCallCheck(this, BufferList);

    this.head = null;
    this.tail = null;
    this.length = 0;
  }

  BufferList.prototype.push = function push(v) {
    var entry = { data: v, next: null };
    if (this.length > 0) this.tail.next = entry;else this.head = entry;
    this.tail = entry;
    ++this.length;
  };

  BufferList.prototype.unshift = function unshift(v) {
    var entry = { data: v, next: this.head };
    if (this.length === 0) this.tail = entry;
    this.head = entry;
    ++this.length;
  };

  BufferList.prototype.shift = function shift() {
    if (this.length === 0) return;
    var ret = this.head.data;
    if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
    --this.length;
    return ret;
  };

  BufferList.prototype.clear = function clear() {
    this.head = this.tail = null;
    this.length = 0;
  };

  BufferList.prototype.join = function join(s) {
    if (this.length === 0) return '';
    var p = this.head;
    var ret = '' + p.data;
    while (p = p.next) {
      ret += s + p.data;
    }return ret;
  };

  BufferList.prototype.concat = function concat(n) {
    if (this.length === 0) return Buffer.alloc(0);
    if (this.length === 1) return this.head.data;
    var ret = Buffer.allocUnsafe(n >>> 0);
    var p = this.head;
    var i = 0;
    while (p) {
      copyBuffer(p.data, ret, i);
      i += p.data.length;
      p = p.next;
    }
    return ret;
  };

  return BufferList;
}();

if (util && util.inspect && util.inspect.custom) {
  module.exports.prototype[util.inspect.custom] = function () {
    var obj = util.inspect({ length: this.length });
    return this.constructor.name + ' ' + obj;
  };
}

/***/ }),
/* 141 */
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var apply = Function.prototype.apply;

// DOM APIs, for completeness

exports.setTimeout = function() {
  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
};
exports.setInterval = function() {
  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
};
exports.clearTimeout =
exports.clearInterval = function(timeout) {
  if (timeout) {
    timeout.close();
  }
};

function Timeout(id, clearFn) {
  this._id = id;
  this._clearFn = clearFn;
}
Timeout.prototype.unref = Timeout.prototype.ref = function() {};
Timeout.prototype.close = function() {
  this._clearFn.call(window, this._id);
};

// Does not start the time, just sets up the members needed.
exports.enroll = function(item, msecs) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = msecs;
};

exports.unenroll = function(item) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = -1;
};

exports._unrefActive = exports.active = function(item) {
  clearTimeout(item._idleTimeoutId);

  var msecs = item._idleTimeout;
  if (msecs >= 0) {
    item._idleTimeoutId = setTimeout(function onTimeout() {
      if (item._onTimeout)
        item._onTimeout();
    }, msecs);
  }
};

// setimmediate attaches itself to the global object
__webpack_require__(143);
// On some exotic environments, it's not clear which object `setimmeidate` was
// able to install onto.  Search each possibility in the same order as the
// `setimmediate` library.
exports.setImmediate = (typeof self !== "undefined" && self.setImmediate) ||
                       (typeof global !== "undefined" && global.setImmediate) ||
                       (this && this.setImmediate);
exports.clearImmediate = (typeof self !== "undefined" && self.clearImmediate) ||
                         (typeof global !== "undefined" && global.clearImmediate) ||
                         (this && this.clearImmediate);

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7)))

/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, process) {(function (global, undefined) {
    "use strict";

    if (global.setImmediate) {
        return;
    }

    var nextHandle = 1; // Spec says greater than zero
    var tasksByHandle = {};
    var currentlyRunningATask = false;
    var doc = global.document;
    var registerImmediate;

    function setImmediate(callback) {
      // Callback can either be a function or a string
      if (typeof callback !== "function") {
        callback = new Function("" + callback);
      }
      // Copy function arguments
      var args = new Array(arguments.length - 1);
      for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i + 1];
      }
      // Store and register the task
      var task = { callback: callback, args: args };
      tasksByHandle[nextHandle] = task;
      registerImmediate(nextHandle);
      return nextHandle++;
    }

    function clearImmediate(handle) {
        delete tasksByHandle[handle];
    }

    function run(task) {
        var callback = task.callback;
        var args = task.args;
        switch (args.length) {
        case 0:
            callback();
            break;
        case 1:
            callback(args[0]);
            break;
        case 2:
            callback(args[0], args[1]);
            break;
        case 3:
            callback(args[0], args[1], args[2]);
            break;
        default:
            callback.apply(undefined, args);
            break;
        }
    }

    function runIfPresent(handle) {
        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
        // So if we're currently running a task, we'll need to delay this invocation.
        if (currentlyRunningATask) {
            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
            // "too much recursion" error.
            setTimeout(runIfPresent, 0, handle);
        } else {
            var task = tasksByHandle[handle];
            if (task) {
                currentlyRunningATask = true;
                try {
                    run(task);
                } finally {
                    clearImmediate(handle);
                    currentlyRunningATask = false;
                }
            }
        }
    }

    function installNextTickImplementation() {
        registerImmediate = function(handle) {
            process.nextTick(function () { runIfPresent(handle); });
        };
    }

    function canUsePostMessage() {
        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
        // where `global.postMessage` means something completely different and can't be used for this purpose.
        if (global.postMessage && !global.importScripts) {
            var postMessageIsAsynchronous = true;
            var oldOnMessage = global.onmessage;
            global.onmessage = function() {
                postMessageIsAsynchronous = false;
            };
            global.postMessage("", "*");
            global.onmessage = oldOnMessage;
            return postMessageIsAsynchronous;
        }
    }

    function installPostMessageImplementation() {
        // Installs an event handler on `global` for the `message` event: see
        // * https://developer.mozilla.org/en/DOM/window.postMessage
        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages

        var messagePrefix = "setImmediate$" + Math.random() + "$";
        var onGlobalMessage = function(event) {
            if (event.source === global &&
                typeof event.data === "string" &&
                event.data.indexOf(messagePrefix) === 0) {
                runIfPresent(+event.data.slice(messagePrefix.length));
            }
        };

        if (global.addEventListener) {
            global.addEventListener("message", onGlobalMessage, false);
        } else {
            global.attachEvent("onmessage", onGlobalMessage);
        }

        registerImmediate = function(handle) {
            global.postMessage(messagePrefix + handle, "*");
        };
    }

    function installMessageChannelImplementation() {
        var channel = new MessageChannel();
        channel.port1.onmessage = function(event) {
            var handle = event.data;
            runIfPresent(handle);
        };

        registerImmediate = function(handle) {
            channel.port2.postMessage(handle);
        };
    }

    function installReadyStateChangeImplementation() {
        var html = doc.documentElement;
        registerImmediate = function(handle) {
            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
            var script = doc.createElement("script");
            script.onreadystatechange = function () {
                runIfPresent(handle);
                script.onreadystatechange = null;
                html.removeChild(script);
                script = null;
            };
            html.appendChild(script);
        };
    }

    function installSetTimeoutImplementation() {
        registerImmediate = function(handle) {
            setTimeout(runIfPresent, 0, handle);
        };
    }

    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;

    // Don't get fooled by e.g. browserify environments.
    if ({}.toString.call(global.process) === "[object process]") {
        // For Node.js before 0.9
        installNextTickImplementation();

    } else if (canUsePostMessage()) {
        // For non-IE10 modern browsers
        installPostMessageImplementation();

    } else if (global.MessageChannel) {
        // For web workers, where supported
        installMessageChannelImplementation();

    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
        // For IE 6–8
        installReadyStateChangeImplementation();

    } else {
        // For older browsers
        installSetTimeoutImplementation();
    }

    attachTo.setImmediate = setImmediate;
    attachTo.clearImmediate = clearImmediate;
}(typeof self === "undefined" ? typeof global === "undefined" ? this : global : self));

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7), __webpack_require__(11)))

/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {
/**
 * Module exports.
 */

module.exports = deprecate;

/**
 * Mark that a method should not be used.
 * Returns a modified function which warns once by default.
 *
 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
 *
 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
 * will throw an Error when invoked.
 *
 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
 * will invoke `console.trace()` instead of `console.error()`.
 *
 * @param {Function} fn - the function to deprecate
 * @param {String} msg - the string to print to the console when `fn` is invoked
 * @returns {Function} a new "deprecated" version of `fn`
 * @api public
 */

function deprecate (fn, msg) {
  if (config('noDeprecation')) {
    return fn;
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (config('throwDeprecation')) {
        throw new Error(msg);
      } else if (config('traceDeprecation')) {
        console.trace(msg);
      } else {
        console.warn(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
}

/**
 * Checks `localStorage` for boolean values for the given `name`.
 *
 * @param {String} name
 * @returns {Boolean}
 * @api private
 */

function config (name) {
  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
  try {
    if (!global.localStorage) return false;
  } catch (_) {
    return false;
  }
  var val = global.localStorage[name];
  if (null == val) return false;
  return String(val).toLowerCase() === 'true';
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(7)))

/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a passthrough stream.
// basically just the most minimal sort of Transform stream.
// Every written chunk gets output as-is.



module.exports = PassThrough;

var Transform = __webpack_require__(86);

/*<replacement>*/
var util = __webpack_require__(25);
util.inherits = __webpack_require__(21);
/*</replacement>*/

util.inherits(PassThrough, Transform);

function PassThrough(options) {
  if (!(this instanceof PassThrough)) return new PassThrough(options);

  Transform.call(this, options);
}

PassThrough.prototype._transform = function (chunk, encoding, cb) {
  cb(null, chunk);
};

/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(46);


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(16);


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(45).Transform


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(45).PassThrough


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer, process) {
/* eslint camelcase: "off" */

var assert = __webpack_require__(88);

var Zstream = __webpack_require__(153);
var zlib_deflate = __webpack_require__(154);
var zlib_inflate = __webpack_require__(157);
var constants = __webpack_require__(160);

for (var key in constants) {
  exports[key] = constants[key];
}

// zlib modes
exports.NONE = 0;
exports.DEFLATE = 1;
exports.INFLATE = 2;
exports.GZIP = 3;
exports.GUNZIP = 4;
exports.DEFLATERAW = 5;
exports.INFLATERAW = 6;
exports.UNZIP = 7;

var GZIP_HEADER_ID1 = 0x1f;
var GZIP_HEADER_ID2 = 0x8b;

/**
 * Emulate Node's zlib C++ layer for use by the JS layer in index.js
 */
function Zlib(mode) {
  if (typeof mode !== 'number' || mode < exports.DEFLATE || mode > exports.UNZIP) {
    throw new TypeError('Bad argument');
  }

  this.dictionary = null;
  this.err = 0;
  this.flush = 0;
  this.init_done = false;
  this.level = 0;
  this.memLevel = 0;
  this.mode = mode;
  this.strategy = 0;
  this.windowBits = 0;
  this.write_in_progress = false;
  this.pending_close = false;
  this.gzip_id_bytes_read = 0;
}

Zlib.prototype.close = function () {
  if (this.write_in_progress) {
    this.pending_close = true;
    return;
  }

  this.pending_close = false;

  assert(this.init_done, 'close before init');
  assert(this.mode <= exports.UNZIP);

  if (this.mode === exports.DEFLATE || this.mode === exports.GZIP || this.mode === exports.DEFLATERAW) {
    zlib_deflate.deflateEnd(this.strm);
  } else if (this.mode === exports.INFLATE || this.mode === exports.GUNZIP || this.mode === exports.INFLATERAW || this.mode === exports.UNZIP) {
    zlib_inflate.inflateEnd(this.strm);
  }

  this.mode = exports.NONE;

  this.dictionary = null;
};

Zlib.prototype.write = function (flush, input, in_off, in_len, out, out_off, out_len) {
  return this._write(true, flush, input, in_off, in_len, out, out_off, out_len);
};

Zlib.prototype.writeSync = function (flush, input, in_off, in_len, out, out_off, out_len) {
  return this._write(false, flush, input, in_off, in_len, out, out_off, out_len);
};

Zlib.prototype._write = function (async, flush, input, in_off, in_len, out, out_off, out_len) {
  assert.equal(arguments.length, 8);

  assert(this.init_done, 'write before init');
  assert(this.mode !== exports.NONE, 'already finalized');
  assert.equal(false, this.write_in_progress, 'write already in progress');
  assert.equal(false, this.pending_close, 'close is pending');

  this.write_in_progress = true;

  assert.equal(false, flush === undefined, 'must provide flush value');

  this.write_in_progress = true;

  if (flush !== exports.Z_NO_FLUSH && flush !== exports.Z_PARTIAL_FLUSH && flush !== exports.Z_SYNC_FLUSH && flush !== exports.Z_FULL_FLUSH && flush !== exports.Z_FINISH && flush !== exports.Z_BLOCK) {
    throw new Error('Invalid flush value');
  }

  if (input == null) {
    input = Buffer.alloc(0);
    in_len = 0;
    in_off = 0;
  }

  this.strm.avail_in = in_len;
  this.strm.input = input;
  this.strm.next_in = in_off;
  this.strm.avail_out = out_len;
  this.strm.output = out;
  this.strm.next_out = out_off;
  this.flush = flush;

  if (!async) {
    // sync version
    this._process();

    if (this._checkError()) {
      return this._afterSync();
    }
    return;
  }

  // async version
  var self = this;
  process.nextTick(function () {
    self._process();
    self._after();
  });

  return this;
};

Zlib.prototype._afterSync = function () {
  var avail_out = this.strm.avail_out;
  var avail_in = this.strm.avail_in;

  this.write_in_progress = false;

  return [avail_in, avail_out];
};

Zlib.prototype._process = function () {
  var next_expected_header_byte = null;

  // If the avail_out is left at 0, then it means that it ran out
  // of room.  If there was avail_out left over, then it means
  // that all of the input was consumed.
  switch (this.mode) {
    case exports.DEFLATE:
    case exports.GZIP:
    case exports.DEFLATERAW:
      this.err = zlib_deflate.deflate(this.strm, this.flush);
      break;
    case exports.UNZIP:
      if (this.strm.avail_in > 0) {
        next_expected_header_byte = this.strm.next_in;
      }

      switch (this.gzip_id_bytes_read) {
        case 0:
          if (next_expected_header_byte === null) {
            break;
          }

          if (this.strm.input[next_expected_header_byte] === GZIP_HEADER_ID1) {
            this.gzip_id_bytes_read = 1;
            next_expected_header_byte++;

            if (this.strm.avail_in === 1) {
              // The only available byte was already read.
              break;
            }
          } else {
            this.mode = exports.INFLATE;
            break;
          }

        // fallthrough
        case 1:
          if (next_expected_header_byte === null) {
            break;
          }

          if (this.strm.input[next_expected_header_byte] === GZIP_HEADER_ID2) {
            this.gzip_id_bytes_read = 2;
            this.mode = exports.GUNZIP;
          } else {
            // There is no actual difference between INFLATE and INFLATERAW
            // (after initialization).
            this.mode = exports.INFLATE;
          }

          break;
        default:
          throw new Error('invalid number of gzip magic number bytes read');
      }

    // fallthrough
    case exports.INFLATE:
    case exports.GUNZIP:
    case exports.INFLATERAW:
      this.err = zlib_inflate.inflate(this.strm, this.flush

      // If data was encoded with dictionary
      );if (this.err === exports.Z_NEED_DICT && this.dictionary) {
        // Load it
        this.err = zlib_inflate.inflateSetDictionary(this.strm, this.dictionary);
        if (this.err === exports.Z_OK) {
          // And try to decode again
          this.err = zlib_inflate.inflate(this.strm, this.flush);
        } else if (this.err === exports.Z_DATA_ERROR) {
          // Both inflateSetDictionary() and inflate() return Z_DATA_ERROR.
          // Make it possible for After() to tell a bad dictionary from bad
          // input.
          this.err = exports.Z_NEED_DICT;
        }
      }
      while (this.strm.avail_in > 0 && this.mode === exports.GUNZIP && this.err === exports.Z_STREAM_END && this.strm.next_in[0] !== 0x00) {
        // Bytes remain in input buffer. Perhaps this is another compressed
        // member in the same archive, or just trailing garbage.
        // Trailing zero bytes are okay, though, since they are frequently
        // used for padding.

        this.reset();
        this.err = zlib_inflate.inflate(this.strm, this.flush);
      }
      break;
    default:
      throw new Error('Unknown mode ' + this.mode);
  }
};

Zlib.prototype._checkError = function () {
  // Acceptable error states depend on the type of zlib stream.
  switch (this.err) {
    case exports.Z_OK:
    case exports.Z_BUF_ERROR:
      if (this.strm.avail_out !== 0 && this.flush === exports.Z_FINISH) {
        this._error('unexpected end of file');
        return false;
      }
      break;
    case exports.Z_STREAM_END:
      // normal statuses, not fatal
      break;
    case exports.Z_NEED_DICT:
      if (this.dictionary == null) {
        this._error('Missing dictionary');
      } else {
        this._error('Bad dictionary');
      }
      return false;
    default:
      // something else.
      this._error('Zlib error');
      return false;
  }

  return true;
};

Zlib.prototype._after = function () {
  if (!this._checkError()) {
    return;
  }

  var avail_out = this.strm.avail_out;
  var avail_in = this.strm.avail_in;

  this.write_in_progress = false;

  // call the write() cb
  this.callback(avail_in, avail_out);

  if (this.pending_close) {
    this.close();
  }
};

Zlib.prototype._error = function (message) {
  if (this.strm.msg) {
    message = this.strm.msg;
  }
  this.onerror(message, this.err

  // no hope of rescue.
  );this.write_in_progress = false;
  if (this.pending_close) {
    this.close();
  }
};

Zlib.prototype.init = function (windowBits, level, memLevel, strategy, dictionary) {
  assert(arguments.length === 4 || arguments.length === 5, 'init(windowBits, level, memLevel, strategy, [dictionary])');

  assert(windowBits >= 8 && windowBits <= 15, 'invalid windowBits');
  assert(level >= -1 && level <= 9, 'invalid compression level');

  assert(memLevel >= 1 && memLevel <= 9, 'invalid memlevel');

  assert(strategy === exports.Z_FILTERED || strategy === exports.Z_HUFFMAN_ONLY || strategy === exports.Z_RLE || strategy === exports.Z_FIXED || strategy === exports.Z_DEFAULT_STRATEGY, 'invalid strategy');

  this._init(level, windowBits, memLevel, strategy, dictionary);
  this._setDictionary();
};

Zlib.prototype.params = function () {
  throw new Error('deflateParams Not supported');
};

Zlib.prototype.reset = function () {
  this._reset();
  this._setDictionary();
};

Zlib.prototype._init = function (level, windowBits, memLevel, strategy, dictionary) {
  this.level = level;
  this.windowBits = windowBits;
  this.memLevel = memLevel;
  this.strategy = strategy;

  this.flush = exports.Z_NO_FLUSH;

  this.err = exports.Z_OK;

  if (this.mode === exports.GZIP || this.mode === exports.GUNZIP) {
    this.windowBits += 16;
  }

  if (this.mode === exports.UNZIP) {
    this.windowBits += 32;
  }

  if (this.mode === exports.DEFLATERAW || this.mode === exports.INFLATERAW) {
    this.windowBits = -1 * this.windowBits;
  }

  this.strm = new Zstream();

  switch (this.mode) {
    case exports.DEFLATE:
    case exports.GZIP:
    case exports.DEFLATERAW:
      this.err = zlib_deflate.deflateInit2(this.strm, this.level, exports.Z_DEFLATED, this.windowBits, this.memLevel, this.strategy);
      break;
    case exports.INFLATE:
    case exports.GUNZIP:
    case exports.INFLATERAW:
    case exports.UNZIP:
      this.err = zlib_inflate.inflateInit2(this.strm, this.windowBits);
      break;
    default:
      throw new Error('Unknown mode ' + this.mode);
  }

  if (this.err !== exports.Z_OK) {
    this._error('Init error');
  }

  this.dictionary = dictionary;

  this.write_in_progress = false;
  this.init_done = true;
};

Zlib.prototype._setDictionary = function () {
  if (this.dictionary == null) {
    return;
  }

  this.err = exports.Z_OK;

  switch (this.mode) {
    case exports.DEFLATE:
    case exports.DEFLATERAW:
      this.err = zlib_deflate.deflateSetDictionary(this.strm, this.dictionary);
      break;
    default:
      break;
  }

  if (this.err !== exports.Z_OK) {
    this._error('Failed to set dictionary');
  }
};

Zlib.prototype._reset = function () {
  this.err = exports.Z_OK;

  switch (this.mode) {
    case exports.DEFLATE:
    case exports.DEFLATERAW:
    case exports.GZIP:
      this.err = zlib_deflate.deflateReset(this.strm);
      break;
    case exports.INFLATE:
    case exports.INFLATERAW:
    case exports.GUNZIP:
      this.err = zlib_inflate.inflateReset(this.strm);
      break;
    default:
      break;
  }

  if (this.err !== exports.Z_OK) {
    this._error('Failed to reset stream');
  }
};

exports.Zlib = Zlib;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(1).Buffer, __webpack_require__(11)))

/***/ }),
/* 151 */
/***/ (function(module, exports) {

module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}

/***/ }),
/* 152 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

function ZStream() {
  /* next input byte */
  this.input = null; // JS specific, because we have no pointers
  this.next_in = 0;
  /* number of bytes available at input */
  this.avail_in = 0;
  /* total number of input bytes read so far */
  this.total_in = 0;
  /* next output byte should be put there */
  this.output = null; // JS specific, because we have no pointers
  this.next_out = 0;
  /* remaining free space at output */
  this.avail_out = 0;
  /* total number of bytes output so far */
  this.total_out = 0;
  /* last error message, NULL if no error */
  this.msg = ''/*Z_NULL*/;
  /* not visible by applications */
  this.state = null;
  /* best guess about the data type: binary or text */
  this.data_type = 2/*Z_UNKNOWN*/;
  /* adler32 value of the uncompressed data */
  this.adler = 0;
}

module.exports = ZStream;


/***/ }),
/* 154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

var utils   = __webpack_require__(34);
var trees   = __webpack_require__(155);
var adler32 = __webpack_require__(89);
var crc32   = __webpack_require__(90);
var msg     = __webpack_require__(156);

/* Public constants ==========================================================*/
/* ===========================================================================*/


/* Allowed flush values; see deflate() and inflate() below for details */
var Z_NO_FLUSH      = 0;
var Z_PARTIAL_FLUSH = 1;
//var Z_SYNC_FLUSH    = 2;
var Z_FULL_FLUSH    = 3;
var Z_FINISH        = 4;
var Z_BLOCK         = 5;
//var Z_TREES         = 6;


/* Return codes for the compression/decompression functions. Negative values
 * are errors, positive values are used for special but normal events.
 */
var Z_OK            = 0;
var Z_STREAM_END    = 1;
//var Z_NEED_DICT     = 2;
//var Z_ERRNO         = -1;
var Z_STREAM_ERROR  = -2;
var Z_DATA_ERROR    = -3;
//var Z_MEM_ERROR     = -4;
var Z_BUF_ERROR     = -5;
//var Z_VERSION_ERROR = -6;


/* compression levels */
//var Z_NO_COMPRESSION      = 0;
//var Z_BEST_SPEED          = 1;
//var Z_BEST_COMPRESSION    = 9;
var Z_DEFAULT_COMPRESSION = -1;


var Z_FILTERED            = 1;
var Z_HUFFMAN_ONLY        = 2;
var Z_RLE                 = 3;
var Z_FIXED               = 4;
var Z_DEFAULT_STRATEGY    = 0;

/* Possible values of the data_type field (though see inflate()) */
//var Z_BINARY              = 0;
//var Z_TEXT                = 1;
//var Z_ASCII               = 1; // = Z_TEXT
var Z_UNKNOWN             = 2;


/* The deflate compression method */
var Z_DEFLATED  = 8;

/*============================================================================*/


var MAX_MEM_LEVEL = 9;
/* Maximum value for memLevel in deflateInit2 */
var MAX_WBITS = 15;
/* 32K LZ77 window */
var DEF_MEM_LEVEL = 8;


var LENGTH_CODES  = 29;
/* number of length codes, not counting the special END_BLOCK code */
var LITERALS      = 256;
/* number of literal bytes 0..255 */
var L_CODES       = LITERALS + 1 + LENGTH_CODES;
/* number of Literal or Length codes, including the END_BLOCK code */
var D_CODES       = 30;
/* number of distance codes */
var BL_CODES      = 19;
/* number of codes used to transfer the bit lengths */
var HEAP_SIZE     = 2 * L_CODES + 1;
/* maximum heap size */
var MAX_BITS  = 15;
/* All codes must not exceed MAX_BITS bits */

var MIN_MATCH = 3;
var MAX_MATCH = 258;
var MIN_LOOKAHEAD = (MAX_MATCH + MIN_MATCH + 1);

var PRESET_DICT = 0x20;

var INIT_STATE = 42;
var EXTRA_STATE = 69;
var NAME_STATE = 73;
var COMMENT_STATE = 91;
var HCRC_STATE = 103;
var BUSY_STATE = 113;
var FINISH_STATE = 666;

var BS_NEED_MORE      = 1; /* block not completed, need more input or more output */
var BS_BLOCK_DONE     = 2; /* block flush performed */
var BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */
var BS_FINISH_DONE    = 4; /* finish done, accept no more input or output */

var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

function err(strm, errorCode) {
  strm.msg = msg[errorCode];
  return errorCode;
}

function rank(f) {
  return ((f) << 1) - ((f) > 4 ? 9 : 0);
}

function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }


/* =========================================================================
 * Flush as much pending output as possible. All deflate() output goes
 * through this function so some applications may wish to modify it
 * to avoid allocating a large strm->output buffer and copying into it.
 * (See also read_buf()).
 */
function flush_pending(strm) {
  var s = strm.state;

  //_tr_flush_bits(s);
  var len = s.pending;
  if (len > strm.avail_out) {
    len = strm.avail_out;
  }
  if (len === 0) { return; }

  utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
  strm.next_out += len;
  s.pending_out += len;
  strm.total_out += len;
  strm.avail_out -= len;
  s.pending -= len;
  if (s.pending === 0) {
    s.pending_out = 0;
  }
}


function flush_block_only(s, last) {
  trees._tr_flush_block(s, (s.block_start >= 0 ? s.block_start : -1), s.strstart - s.block_start, last);
  s.block_start = s.strstart;
  flush_pending(s.strm);
}


function put_byte(s, b) {
  s.pending_buf[s.pending++] = b;
}


/* =========================================================================
 * Put a short in the pending buffer. The 16-bit value is put in MSB order.
 * IN assertion: the stream state is correct and there is enough room in
 * pending_buf.
 */
function putShortMSB(s, b) {
//  put_byte(s, (Byte)(b >> 8));
//  put_byte(s, (Byte)(b & 0xff));
  s.pending_buf[s.pending++] = (b >>> 8) & 0xff;
  s.pending_buf[s.pending++] = b & 0xff;
}


/* ===========================================================================
 * Read a new buffer from the current input stream, update the adler32
 * and total number of bytes read.  All deflate() input goes through
 * this function so some applications may wish to modify it to avoid
 * allocating a large strm->input buffer and copying from it.
 * (See also flush_pending()).
 */
function read_buf(strm, buf, start, size) {
  var len = strm.avail_in;

  if (len > size) { len = size; }
  if (len === 0) { return 0; }

  strm.avail_in -= len;

  // zmemcpy(buf, strm->next_in, len);
  utils.arraySet(buf, strm.input, strm.next_in, len, start);
  if (strm.state.wrap === 1) {
    strm.adler = adler32(strm.adler, buf, len, start);
  }

  else if (strm.state.wrap === 2) {
    strm.adler = crc32(strm.adler, buf, len, start);
  }

  strm.next_in += len;
  strm.total_in += len;

  return len;
}


/* ===========================================================================
 * Set match_start to the longest match starting at the given string and
 * return its length. Matches shorter or equal to prev_length are discarded,
 * in which case the result is equal to prev_length and match_start is
 * garbage.
 * IN assertions: cur_match is the head of the hash chain for the current
 *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
 * OUT assertion: the match length is not greater than s->lookahead.
 */
function longest_match(s, cur_match) {
  var chain_length = s.max_chain_length;      /* max hash chain length */
  var scan = s.strstart; /* current string */
  var match;                       /* matched string */
  var len;                           /* length of current match */
  var best_len = s.prev_length;              /* best match length so far */
  var nice_match = s.nice_match;             /* stop if match long enough */
  var limit = (s.strstart > (s.w_size - MIN_LOOKAHEAD)) ?
      s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0/*NIL*/;

  var _win = s.window; // shortcut

  var wmask = s.w_mask;
  var prev  = s.prev;

  /* Stop when cur_match becomes <= limit. To simplify the code,
   * we prevent matches with the string of window index 0.
   */

  var strend = s.strstart + MAX_MATCH;
  var scan_end1  = _win[scan + best_len - 1];
  var scan_end   = _win[scan + best_len];

  /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
   * It is easy to get rid of this optimization if necessary.
   */
  // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

  /* Do not waste too much time if we already have a good match: */
  if (s.prev_length >= s.good_match) {
    chain_length >>= 2;
  }
  /* Do not look for matches beyond the end of the input. This is necessary
   * to make deflate deterministic.
   */
  if (nice_match > s.lookahead) { nice_match = s.lookahead; }

  // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");

  do {
    // Assert(cur_match < s->strstart, "no future");
    match = cur_match;

    /* Skip to next match if the match length cannot increase
     * or if the match length is less than 2.  Note that the checks below
     * for insufficient lookahead only occur occasionally for performance
     * reasons.  Therefore uninitialized memory will be accessed, and
     * conditional jumps will be made that depend on those values.
     * However the length of the match is limited to the lookahead, so
     * the output of deflate is not affected by the uninitialized values.
     */

    if (_win[match + best_len]     !== scan_end  ||
        _win[match + best_len - 1] !== scan_end1 ||
        _win[match]                !== _win[scan] ||
        _win[++match]              !== _win[scan + 1]) {
      continue;
    }

    /* The check at best_len-1 can be removed because it will be made
     * again later. (This heuristic is not always a win.)
     * It is not necessary to compare scan[2] and match[2] since they
     * are always equal when the other bytes match, given that
     * the hash keys are equal and that HASH_BITS >= 8.
     */
    scan += 2;
    match++;
    // Assert(*scan == *match, "match[2]?");

    /* We check for insufficient lookahead only every 8th comparison;
     * the 256th check will be made at strstart+258.
     */
    do {
      /*jshint noempty:false*/
    } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
             scan < strend);

    // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");

    len = MAX_MATCH - (strend - scan);
    scan = strend - MAX_MATCH;

    if (len > best_len) {
      s.match_start = cur_match;
      best_len = len;
      if (len >= nice_match) {
        break;
      }
      scan_end1  = _win[scan + best_len - 1];
      scan_end   = _win[scan + best_len];
    }
  } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

  if (best_len <= s.lookahead) {
    return best_len;
  }
  return s.lookahead;
}


/* ===========================================================================
 * Fill the window when the lookahead becomes insufficient.
 * Updates strstart and lookahead.
 *
 * IN assertion: lookahead < MIN_LOOKAHEAD
 * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
 *    At least one byte has been read, or avail_in == 0; reads are
 *    performed for at least two bytes (required for the zip translate_eol
 *    option -- not supported here).
 */
function fill_window(s) {
  var _w_size = s.w_size;
  var p, n, m, more, str;

  //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

  do {
    more = s.window_size - s.lookahead - s.strstart;

    // JS ints have 32 bit, block below not needed
    /* Deal with !@#$% 64K limit: */
    //if (sizeof(int) <= 2) {
    //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
    //        more = wsize;
    //
    //  } else if (more == (unsigned)(-1)) {
    //        /* Very unlikely, but possible on 16 bit machine if
    //         * strstart == 0 && lookahead == 1 (input done a byte at time)
    //         */
    //        more--;
    //    }
    //}


    /* If the window is almost full and there is insufficient lookahead,
     * move the upper half to the lower one to make room in the upper half.
     */
    if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {

      utils.arraySet(s.window, s.window, _w_size, _w_size, 0);
      s.match_start -= _w_size;
      s.strstart -= _w_size;
      /* we now have strstart >= MAX_DIST */
      s.block_start -= _w_size;

      /* Slide the hash table (could be avoided with 32 bit values
       at the expense of memory usage). We slide even when level == 0
       to keep the hash table consistent if we switch back to level > 0
       later. (Using level 0 permanently is not an optimal usage of
       zlib, so we don't care about this pathological case.)
       */

      n = s.hash_size;
      p = n;
      do {
        m = s.head[--p];
        s.head[p] = (m >= _w_size ? m - _w_size : 0);
      } while (--n);

      n = _w_size;
      p = n;
      do {
        m = s.prev[--p];
        s.prev[p] = (m >= _w_size ? m - _w_size : 0);
        /* If n is not on any hash chain, prev[n] is garbage but
         * its value will never be used.
         */
      } while (--n);

      more += _w_size;
    }
    if (s.strm.avail_in === 0) {
      break;
    }

    /* If there was no sliding:
     *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
     *    more == window_size - lookahead - strstart
     * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
     * => more >= window_size - 2*WSIZE + 2
     * In the BIG_MEM or MMAP case (not yet supported),
     *   window_size == input_size + MIN_LOOKAHEAD  &&
     *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
     * Otherwise, window_size == 2*WSIZE so more >= 2.
     * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
     */
    //Assert(more >= 2, "more < 2");
    n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
    s.lookahead += n;

    /* Initialize the hash value now that we have some input: */
    if (s.lookahead + s.insert >= MIN_MATCH) {
      str = s.strstart - s.insert;
      s.ins_h = s.window[str];

      /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */
      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + 1]) & s.hash_mask;
//#if MIN_MATCH != 3
//        Call update_hash() MIN_MATCH-3 more times
//#endif
      while (s.insert) {
        /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

        s.prev[str & s.w_mask] = s.head[s.ins_h];
        s.head[s.ins_h] = str;
        str++;
        s.insert--;
        if (s.lookahead + s.insert < MIN_MATCH) {
          break;
        }
      }
    }
    /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
     * but this is not important since only literal bytes will be emitted.
     */

  } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);

  /* If the WIN_INIT bytes after the end of the current data have never been
   * written, then zero those bytes in order to avoid memory check reports of
   * the use of uninitialized (or uninitialised as Julian writes) bytes by
   * the longest match routines.  Update the high water mark for the next
   * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
   * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
   */
//  if (s.high_water < s.window_size) {
//    var curr = s.strstart + s.lookahead;
//    var init = 0;
//
//    if (s.high_water < curr) {
//      /* Previous high water mark below current data -- zero WIN_INIT
//       * bytes or up to end of window, whichever is less.
//       */
//      init = s.window_size - curr;
//      if (init > WIN_INIT)
//        init = WIN_INIT;
//      zmemzero(s->window + curr, (unsigned)init);
//      s->high_water = curr + init;
//    }
//    else if (s->high_water < (ulg)curr + WIN_INIT) {
//      /* High water mark at or above current data, but below current data
//       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
//       * to end of window, whichever is less.
//       */
//      init = (ulg)curr + WIN_INIT - s->high_water;
//      if (init > s->window_size - s->high_water)
//        init = s->window_size - s->high_water;
//      zmemzero(s->window + s->high_water, (unsigned)init);
//      s->high_water += init;
//    }
//  }
//
//  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
//    "not enough room for search");
}

/* ===========================================================================
 * Copy without compression as much as possible from the input stream, return
 * the current block state.
 * This function does not insert new strings in the dictionary since
 * uncompressible data is probably not useful. This function is used
 * only for the level=0 compression option.
 * NOTE: this function should be optimized to avoid extra copying from
 * window to pending_buf.
 */
function deflate_stored(s, flush) {
  /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
   * to pending_buf_size, and each stored block has a 5 byte header:
   */
  var max_block_size = 0xffff;

  if (max_block_size > s.pending_buf_size - 5) {
    max_block_size = s.pending_buf_size - 5;
  }

  /* Copy as much as possible from input to output: */
  for (;;) {
    /* Fill the window as much as possible: */
    if (s.lookahead <= 1) {

      //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
      //  s->block_start >= (long)s->w_size, "slide too late");
//      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
//        s.block_start >= s.w_size)) {
//        throw  new Error("slide too late");
//      }

      fill_window(s);
      if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
        return BS_NEED_MORE;
      }

      if (s.lookahead === 0) {
        break;
      }
      /* flush the current block */
    }
    //Assert(s->block_start >= 0L, "block gone");
//    if (s.block_start < 0) throw new Error("block gone");

    s.strstart += s.lookahead;
    s.lookahead = 0;

    /* Emit a stored block if pending_buf will be full: */
    var max_start = s.block_start + max_block_size;

    if (s.strstart === 0 || s.strstart >= max_start) {
      /* strstart == 0 is possible when wraparound on 16-bit machine */
      s.lookahead = s.strstart - max_start;
      s.strstart = max_start;
      /*** FLUSH_BLOCK(s, 0); ***/
      flush_block_only(s, false);
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
      /***/


    }
    /* Flush if we may have to slide, otherwise block_start may become
     * negative and the data will be gone:
     */
    if (s.strstart - s.block_start >= (s.w_size - MIN_LOOKAHEAD)) {
      /*** FLUSH_BLOCK(s, 0); ***/
      flush_block_only(s, false);
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
      /***/
    }
  }

  s.insert = 0;

  if (flush === Z_FINISH) {
    /*** FLUSH_BLOCK(s, 1); ***/
    flush_block_only(s, true);
    if (s.strm.avail_out === 0) {
      return BS_FINISH_STARTED;
    }
    /***/
    return BS_FINISH_DONE;
  }

  if (s.strstart > s.block_start) {
    /*** FLUSH_BLOCK(s, 0); ***/
    flush_block_only(s, false);
    if (s.strm.avail_out === 0) {
      return BS_NEED_MORE;
    }
    /***/
  }

  return BS_NEED_MORE;
}

/* ===========================================================================
 * Compress as much as possible from the input stream, return the current
 * block state.
 * This function does not perform lazy evaluation of matches and inserts
 * new strings in the dictionary only for unmatched strings or for short
 * matches. It is used only for the fast compression options.
 */
function deflate_fast(s, flush) {
  var hash_head;        /* head of the hash chain */
  var bflush;           /* set if current block must be flushed */

  for (;;) {
    /* Make sure that we always have enough lookahead, except
     * at the end of the input file. We need MAX_MATCH bytes
     * for the next match, plus MIN_MATCH bytes to insert the
     * string following the next match.
     */
    if (s.lookahead < MIN_LOOKAHEAD) {
      fill_window(s);
      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
        return BS_NEED_MORE;
      }
      if (s.lookahead === 0) {
        break; /* flush the current block */
      }
    }

    /* Insert the string window[strstart .. strstart+2] in the
     * dictionary, and set hash_head to the head of the hash chain:
     */
    hash_head = 0/*NIL*/;
    if (s.lookahead >= MIN_MATCH) {
      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
      s.head[s.ins_h] = s.strstart;
      /***/
    }

    /* Find the longest match, discarding those <= prev_length.
     * At this point we have always match_length < MIN_MATCH
     */
    if (hash_head !== 0/*NIL*/ && ((s.strstart - hash_head) <= (s.w_size - MIN_LOOKAHEAD))) {
      /* To simplify the code, we prevent matches with the string
       * of window index 0 (in particular we have to avoid a match
       * of the string with itself at the start of the input file).
       */
      s.match_length = longest_match(s, hash_head);
      /* longest_match() sets match_start */
    }
    if (s.match_length >= MIN_MATCH) {
      // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

      /*** _tr_tally_dist(s, s.strstart - s.match_start,
                     s.match_length - MIN_MATCH, bflush); ***/
      bflush = trees._tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);

      s.lookahead -= s.match_length;

      /* Insert new strings in the hash table only if the match length
       * is not too large. This saves time but degrades compression.
       */
      if (s.match_length <= s.max_lazy_match/*max_insert_length*/ && s.lookahead >= MIN_MATCH) {
        s.match_length--; /* string at strstart already in table */
        do {
          s.strstart++;
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
          /* strstart never exceeds WSIZE-MAX_MATCH, so there are
           * always MIN_MATCH bytes ahead.
           */
        } while (--s.match_length !== 0);
        s.strstart++;
      } else
      {
        s.strstart += s.match_length;
        s.match_length = 0;
        s.ins_h = s.window[s.strstart];
        /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */
        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + 1]) & s.hash_mask;

//#if MIN_MATCH != 3
//                Call UPDATE_HASH() MIN_MATCH-3 more times
//#endif
        /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
         * matter since it will be recomputed at next deflate call.
         */
      }
    } else {
      /* No match, output a literal byte */
      //Tracevv((stderr,"%c", s.window[s.strstart]));
      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

      s.lookahead--;
      s.strstart++;
    }
    if (bflush) {
      /*** FLUSH_BLOCK(s, 0); ***/
      flush_block_only(s, false);
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
      /***/
    }
  }
  s.insert = ((s.strstart < (MIN_MATCH - 1)) ? s.strstart : MIN_MATCH - 1);
  if (flush === Z_FINISH) {
    /*** FLUSH_BLOCK(s, 1); ***/
    flush_block_only(s, true);
    if (s.strm.avail_out === 0) {
      return BS_FINISH_STARTED;
    }
    /***/
    return BS_FINISH_DONE;
  }
  if (s.last_lit) {
    /*** FLUSH_BLOCK(s, 0); ***/
    flush_block_only(s, false);
    if (s.strm.avail_out === 0) {
      return BS_NEED_MORE;
    }
    /***/
  }
  return BS_BLOCK_DONE;
}

/* ===========================================================================
 * Same as above, but achieves better compression. We use a lazy
 * evaluation for matches: a match is finally adopted only if there is
 * no better match at the next window position.
 */
function deflate_slow(s, flush) {
  var hash_head;          /* head of hash chain */
  var bflush;              /* set if current block must be flushed */

  var max_insert;

  /* Process the input block. */
  for (;;) {
    /* Make sure that we always have enough lookahead, except
     * at the end of the input file. We need MAX_MATCH bytes
     * for the next match, plus MIN_MATCH bytes to insert the
     * string following the next match.
     */
    if (s.lookahead < MIN_LOOKAHEAD) {
      fill_window(s);
      if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
        return BS_NEED_MORE;
      }
      if (s.lookahead === 0) { break; } /* flush the current block */
    }

    /* Insert the string window[strstart .. strstart+2] in the
     * dictionary, and set hash_head to the head of the hash chain:
     */
    hash_head = 0/*NIL*/;
    if (s.lookahead >= MIN_MATCH) {
      /*** INSERT_STRING(s, s.strstart, hash_head); ***/
      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
      hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
      s.head[s.ins_h] = s.strstart;
      /***/
    }

    /* Find the longest match, discarding those <= prev_length.
     */
    s.prev_length = s.match_length;
    s.prev_match = s.match_start;
    s.match_length = MIN_MATCH - 1;

    if (hash_head !== 0/*NIL*/ && s.prev_length < s.max_lazy_match &&
        s.strstart - hash_head <= (s.w_size - MIN_LOOKAHEAD)/*MAX_DIST(s)*/) {
      /* To simplify the code, we prevent matches with the string
       * of window index 0 (in particular we have to avoid a match
       * of the string with itself at the start of the input file).
       */
      s.match_length = longest_match(s, hash_head);
      /* longest_match() sets match_start */

      if (s.match_length <= 5 &&
         (s.strategy === Z_FILTERED || (s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096/*TOO_FAR*/))) {

        /* If prev_match is also MIN_MATCH, match_start is garbage
         * but we will ignore the current match anyway.
         */
        s.match_length = MIN_MATCH - 1;
      }
    }
    /* If there was a match at the previous step and the current
     * match is not better, output the previous match:
     */
    if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
      max_insert = s.strstart + s.lookahead - MIN_MATCH;
      /* Do not insert strings in hash table beyond this. */

      //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

      /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
                     s.prev_length - MIN_MATCH, bflush);***/
      bflush = trees._tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH);
      /* Insert in hash table all strings up to the end of the match.
       * strstart-1 and strstart are already inserted. If there is not
       * enough lookahead, the last two strings are not inserted in
       * the hash table.
       */
      s.lookahead -= s.prev_length - 1;
      s.prev_length -= 2;
      do {
        if (++s.strstart <= max_insert) {
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
        }
      } while (--s.prev_length !== 0);
      s.match_available = 0;
      s.match_length = MIN_MATCH - 1;
      s.strstart++;

      if (bflush) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }

    } else if (s.match_available) {
      /* If there was no match at the previous position, output a
       * single literal. If there was a match but the current match
       * is longer, truncate the previous match to a single literal.
       */
      //Tracevv((stderr,"%c", s->window[s->strstart-1]));
      /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
      bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

      if (bflush) {
        /*** FLUSH_BLOCK_ONLY(s, 0) ***/
        flush_block_only(s, false);
        /***/
      }
      s.strstart++;
      s.lookahead--;
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
    } else {
      /* There is no previous match to compare with, wait for
       * the next step to decide.
       */
      s.match_available = 1;
      s.strstart++;
      s.lookahead--;
    }
  }
  //Assert (flush != Z_NO_FLUSH, "no flush?");
  if (s.match_available) {
    //Tracevv((stderr,"%c", s->window[s->strstart-1]));
    /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
    bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);

    s.match_available = 0;
  }
  s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;
  if (flush === Z_FINISH) {
    /*** FLUSH_BLOCK(s, 1); ***/
    flush_block_only(s, true);
    if (s.strm.avail_out === 0) {
      return BS_FINISH_STARTED;
    }
    /***/
    return BS_FINISH_DONE;
  }
  if (s.last_lit) {
    /*** FLUSH_BLOCK(s, 0); ***/
    flush_block_only(s, false);
    if (s.strm.avail_out === 0) {
      return BS_NEED_MORE;
    }
    /***/
  }

  return BS_BLOCK_DONE;
}


/* ===========================================================================
 * For Z_RLE, simply look for runs of bytes, generate matches only of distance
 * one.  Do not maintain a hash table.  (It will be regenerated if this run of
 * deflate switches away from Z_RLE.)
 */
function deflate_rle(s, flush) {
  var bflush;            /* set if current block must be flushed */
  var prev;              /* byte at distance one to match */
  var scan, strend;      /* scan goes up to strend for length of run */

  var _win = s.window;

  for (;;) {
    /* Make sure that we always have enough lookahead, except
     * at the end of the input file. We need MAX_MATCH bytes
     * for the longest run, plus one for the unrolled loop.
     */
    if (s.lookahead <= MAX_MATCH) {
      fill_window(s);
      if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH) {
        return BS_NEED_MORE;
      }
      if (s.lookahead === 0) { break; } /* flush the current block */
    }

    /* See how many times the previous byte repeats */
    s.match_length = 0;
    if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
      scan = s.strstart - 1;
      prev = _win[scan];
      if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
        strend = s.strstart + MAX_MATCH;
        do {
          /*jshint noempty:false*/
        } while (prev === _win[++scan] && prev === _win[++scan] &&
                 prev === _win[++scan] && prev === _win[++scan] &&
                 prev === _win[++scan] && prev === _win[++scan] &&
                 prev === _win[++scan] && prev === _win[++scan] &&
                 scan < strend);
        s.match_length = MAX_MATCH - (strend - scan);
        if (s.match_length > s.lookahead) {
          s.match_length = s.lookahead;
        }
      }
      //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");
    }

    /* Emit match if have run of MIN_MATCH or longer, else emit literal */
    if (s.match_length >= MIN_MATCH) {
      //check_match(s, s.strstart, s.strstart - 1, s.match_length);

      /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
      bflush = trees._tr_tally(s, 1, s.match_length - MIN_MATCH);

      s.lookahead -= s.match_length;
      s.strstart += s.match_length;
      s.match_length = 0;
    } else {
      /* No match, output a literal byte */
      //Tracevv((stderr,"%c", s->window[s->strstart]));
      /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
      bflush = trees._tr_tally(s, 0, s.window[s.strstart]);

      s.lookahead--;
      s.strstart++;
    }
    if (bflush) {
      /*** FLUSH_BLOCK(s, 0); ***/
      flush_block_only(s, false);
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
      /***/
    }
  }
  s.insert = 0;
  if (flush === Z_FINISH) {
    /*** FLUSH_BLOCK(s, 1); ***/
    flush_block_only(s, true);
    if (s.strm.avail_out === 0) {
      return BS_FINISH_STARTED;
    }
    /***/
    return BS_FINISH_DONE;
  }
  if (s.last_lit) {
    /*** FLUSH_BLOCK(s, 0); ***/
    flush_block_only(s, false);
    if (s.strm.avail_out === 0) {
      return BS_NEED_MORE;
    }
    /***/
  }
  return BS_BLOCK_DONE;
}

/* ===========================================================================
 * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
 * (It will be regenerated if this run of deflate switches away from Huffman.)
 */
function deflate_huff(s, flush) {
  var bflush;             /* set if current block must be flushed */

  for (;;) {
    /* Make sure that we have a literal to write. */
    if (s.lookahead === 0) {
      fill_window(s);
      if (s.lookahead === 0) {
        if (flush === Z_NO_FLUSH) {
          return BS_NEED_MORE;
        }
        break;      /* flush the current block */
      }
    }

    /* Output a literal byte */
    s.match_length = 0;
    //Tracevv((stderr,"%c", s->window[s->strstart]));
    /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
    bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
    s.lookahead--;
    s.strstart++;
    if (bflush) {
      /*** FLUSH_BLOCK(s, 0); ***/
      flush_block_only(s, false);
      if (s.strm.avail_out === 0) {
        return BS_NEED_MORE;
      }
      /***/
    }
  }
  s.insert = 0;
  if (flush === Z_FINISH) {
    /*** FLUSH_BLOCK(s, 1); ***/
    flush_block_only(s, true);
    if (s.strm.avail_out === 0) {
      return BS_FINISH_STARTED;
    }
    /***/
    return BS_FINISH_DONE;
  }
  if (s.last_lit) {
    /*** FLUSH_BLOCK(s, 0); ***/
    flush_block_only(s, false);
    if (s.strm.avail_out === 0) {
      return BS_NEED_MORE;
    }
    /***/
  }
  return BS_BLOCK_DONE;
}

/* Values for max_lazy_match, good_match and max_chain_length, depending on
 * the desired pack level (0..9). The values given below have been tuned to
 * exclude worst case performance for pathological files. Better values may be
 * found for specific files.
 */
function Config(good_length, max_lazy, nice_length, max_chain, func) {
  this.good_length = good_length;
  this.max_lazy = max_lazy;
  this.nice_length = nice_length;
  this.max_chain = max_chain;
  this.func = func;
}

var configuration_table;

configuration_table = [
  /*      good lazy nice chain */
  new Config(0, 0, 0, 0, deflate_stored),          /* 0 store only */
  new Config(4, 4, 8, 4, deflate_fast),            /* 1 max speed, no lazy matches */
  new Config(4, 5, 16, 8, deflate_fast),           /* 2 */
  new Config(4, 6, 32, 32, deflate_fast),          /* 3 */

  new Config(4, 4, 16, 16, deflate_slow),          /* 4 lazy matches */
  new Config(8, 16, 32, 32, deflate_slow),         /* 5 */
  new Config(8, 16, 128, 128, deflate_slow),       /* 6 */
  new Config(8, 32, 128, 256, deflate_slow),       /* 7 */
  new Config(32, 128, 258, 1024, deflate_slow),    /* 8 */
  new Config(32, 258, 258, 4096, deflate_slow)     /* 9 max compression */
];


/* ===========================================================================
 * Initialize the "longest match" routines for a new zlib stream
 */
function lm_init(s) {
  s.window_size = 2 * s.w_size;

  /*** CLEAR_HASH(s); ***/
  zero(s.head); // Fill with NIL (= 0);

  /* Set the default configuration parameters:
   */
  s.max_lazy_match = configuration_table[s.level].max_lazy;
  s.good_match = configuration_table[s.level].good_length;
  s.nice_match = configuration_table[s.level].nice_length;
  s.max_chain_length = configuration_table[s.level].max_chain;

  s.strstart = 0;
  s.block_start = 0;
  s.lookahead = 0;
  s.insert = 0;
  s.match_length = s.prev_length = MIN_MATCH - 1;
  s.match_available = 0;
  s.ins_h = 0;
}


function DeflateState() {
  this.strm = null;            /* pointer back to this zlib stream */
  this.status = 0;            /* as the name implies */
  this.pending_buf = null;      /* output still pending */
  this.pending_buf_size = 0;  /* size of pending_buf */
  this.pending_out = 0;       /* next pending byte to output to the stream */
  this.pending = 0;           /* nb of bytes in the pending buffer */
  this.wrap = 0;              /* bit 0 true for zlib, bit 1 true for gzip */
  this.gzhead = null;         /* gzip header information to write */
  this.gzindex = 0;           /* where in extra, name, or comment */
  this.method = Z_DEFLATED; /* can only be DEFLATED */
  this.last_flush = -1;   /* value of flush param for previous deflate call */

  this.w_size = 0;  /* LZ77 window size (32K by default) */
  this.w_bits = 0;  /* log2(w_size)  (8..16) */
  this.w_mask = 0;  /* w_size - 1 */

  this.window = null;
  /* Sliding window. Input bytes are read into the second half of the window,
   * and move to the first half later to keep a dictionary of at least wSize
   * bytes. With this organization, matches are limited to a distance of
   * wSize-MAX_MATCH bytes, but this ensures that IO is always
   * performed with a length multiple of the block size.
   */

  this.window_size = 0;
  /* Actual size of window: 2*wSize, except when the user input buffer
   * is directly used as sliding window.
   */

  this.prev = null;
  /* Link to older string with same hash index. To limit the size of this
   * array to 64K, this link is maintained only for the last 32K strings.
   * An index in this array is thus a window index modulo 32K.
   */

  this.head = null;   /* Heads of the hash chains or NIL. */

  this.ins_h = 0;       /* hash index of string to be inserted */
  this.hash_size = 0;   /* number of elements in hash table */
  this.hash_bits = 0;   /* log2(hash_size) */
  this.hash_mask = 0;   /* hash_size-1 */

  this.hash_shift = 0;
  /* Number of bits by which ins_h must be shifted at each input
   * step. It must be such that after MIN_MATCH steps, the oldest
   * byte no longer takes part in the hash key, that is:
   *   hash_shift * MIN_MATCH >= hash_bits
   */

  this.block_start = 0;
  /* Window position at the beginning of the current output block. Gets
   * negative when the window is moved backwards.
   */

  this.match_length = 0;      /* length of best match */
  this.prev_match = 0;        /* previous match */
  this.match_available = 0;   /* set if previous match exists */
  this.strstart = 0;          /* start of string to insert */
  this.match_start = 0;       /* start of matching string */
  this.lookahead = 0;         /* number of valid bytes ahead in window */

  this.prev_length = 0;
  /* Length of the best match at previous step. Matches not greater than this
   * are discarded. This is used in the lazy match evaluation.
   */

  this.max_chain_length = 0;
  /* To speed up deflation, hash chains are never searched beyond this
   * length.  A higher limit improves compression ratio but degrades the
   * speed.
   */

  this.max_lazy_match = 0;
  /* Attempt to find a better match only when the current match is strictly
   * smaller than this value. This mechanism is used only for compression
   * levels >= 4.
   */
  // That's alias to max_lazy_match, don't use directly
  //this.max_insert_length = 0;
  /* Insert new strings in the hash table only if the match length is not
   * greater than this length. This saves time but degrades compression.
   * max_insert_length is used only for compression levels <= 3.
   */

  this.level = 0;     /* compression level (1..9) */
  this.strategy = 0;  /* favor or force Huffman coding*/

  this.good_match = 0;
  /* Use a faster search when the previous match is longer than this */

  this.nice_match = 0; /* Stop searching when current match exceeds this */

              /* used by trees.c: */

  /* Didn't use ct_data typedef below to suppress compiler warning */

  // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
  // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
  // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */

  // Use flat array of DOUBLE size, with interleaved fata,
  // because JS does not support effective
  this.dyn_ltree  = new utils.Buf16(HEAP_SIZE * 2);
  this.dyn_dtree  = new utils.Buf16((2 * D_CODES + 1) * 2);
  this.bl_tree    = new utils.Buf16((2 * BL_CODES + 1) * 2);
  zero(this.dyn_ltree);
  zero(this.dyn_dtree);
  zero(this.bl_tree);

  this.l_desc   = null;         /* desc. for literal tree */
  this.d_desc   = null;         /* desc. for distance tree */
  this.bl_desc  = null;         /* desc. for bit length tree */

  //ush bl_count[MAX_BITS+1];
  this.bl_count = new utils.Buf16(MAX_BITS + 1);
  /* number of codes at each bit length for an optimal tree */

  //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */
  this.heap = new utils.Buf16(2 * L_CODES + 1);  /* heap used to build the Huffman trees */
  zero(this.heap);

  this.heap_len = 0;               /* number of elements in the heap */
  this.heap_max = 0;               /* element of largest frequency */
  /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
   * The same heap array is used to build all trees.
   */

  this.depth = new utils.Buf16(2 * L_CODES + 1); //uch depth[2*L_CODES+1];
  zero(this.depth);
  /* Depth of each subtree used as tie breaker for trees of equal frequency
   */

  this.l_buf = 0;          /* buffer index for literals or lengths */

  this.lit_bufsize = 0;
  /* Size of match buffer for literals/lengths.  There are 4 reasons for
   * limiting lit_bufsize to 64K:
   *   - frequencies can be kept in 16 bit counters
   *   - if compression is not successful for the first block, all input
   *     data is still in the window so we can still emit a stored block even
   *     when input comes from standard input.  (This can also be done for
   *     all blocks if lit_bufsize is not greater than 32K.)
   *   - if compression is not successful for a file smaller than 64K, we can
   *     even emit a stored file instead of a stored block (saving 5 bytes).
   *     This is applicable only for zip (not gzip or zlib).
   *   - creating new Huffman trees less frequently may not provide fast
   *     adaptation to changes in the input data statistics. (Take for
   *     example a binary file with poorly compressible code followed by
   *     a highly compressible string table.) Smaller buffer sizes give
   *     fast adaptation but have of course the overhead of transmitting
   *     trees more frequently.
   *   - I can't count above 4
   */

  this.last_lit = 0;      /* running index in l_buf */

  this.d_buf = 0;
  /* Buffer index for distances. To simplify the code, d_buf and l_buf have
   * the same number of elements. To use different lengths, an extra flag
   * array would be necessary.
   */

  this.opt_len = 0;       /* bit length of current block with optimal trees */
  this.static_len = 0;    /* bit length of current block with static trees */
  this.matches = 0;       /* number of string matches in current block */
  this.insert = 0;        /* bytes at end of window left to insert */


  this.bi_buf = 0;
  /* Output buffer. bits are inserted starting at the bottom (least
   * significant bits).
   */
  this.bi_valid = 0;
  /* Number of valid bits in bi_buf.  All bits above the last valid bit
   * are always zero.
   */

  // Used for window memory init. We safely ignore it for JS. That makes
  // sense only for pointers and memory check tools.
  //this.high_water = 0;
  /* High water mark offset in window for initialized bytes -- bytes above
   * this are set to zero in order to avoid memory check warnings when
   * longest match routines access bytes past the input.  This is then
   * updated to the new high water mark.
   */
}


function deflateResetKeep(strm) {
  var s;

  if (!strm || !strm.state) {
    return err(strm, Z_STREAM_ERROR);
  }

  strm.total_in = strm.total_out = 0;
  strm.data_type = Z_UNKNOWN;

  s = strm.state;
  s.pending = 0;
  s.pending_out = 0;

  if (s.wrap < 0) {
    s.wrap = -s.wrap;
    /* was made negative by deflate(..., Z_FINISH); */
  }
  s.status = (s.wrap ? INIT_STATE : BUSY_STATE);
  strm.adler = (s.wrap === 2) ?
    0  // crc32(0, Z_NULL, 0)
  :
    1; // adler32(0, Z_NULL, 0)
  s.last_flush = Z_NO_FLUSH;
  trees._tr_init(s);
  return Z_OK;
}


function deflateReset(strm) {
  var ret = deflateResetKeep(strm);
  if (ret === Z_OK) {
    lm_init(strm.state);
  }
  return ret;
}


function deflateSetHeader(strm, head) {
  if (!strm || !strm.state) { return Z_STREAM_ERROR; }
  if (strm.state.wrap !== 2) { return Z_STREAM_ERROR; }
  strm.state.gzhead = head;
  return Z_OK;
}


function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
  if (!strm) { // === Z_NULL
    return Z_STREAM_ERROR;
  }
  var wrap = 1;

  if (level === Z_DEFAULT_COMPRESSION) {
    level = 6;
  }

  if (windowBits < 0) { /* suppress zlib wrapper */
    wrap = 0;
    windowBits = -windowBits;
  }

  else if (windowBits > 15) {
    wrap = 2;           /* write gzip wrapper instead */
    windowBits -= 16;
  }


  if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED ||
    windowBits < 8 || windowBits > 15 || level < 0 || level > 9 ||
    strategy < 0 || strategy > Z_FIXED) {
    return err(strm, Z_STREAM_ERROR);
  }


  if (windowBits === 8) {
    windowBits = 9;
  }
  /* until 256-byte window bug fixed */

  var s = new DeflateState();

  strm.state = s;
  s.strm = strm;

  s.wrap = wrap;
  s.gzhead = null;
  s.w_bits = windowBits;
  s.w_size = 1 << s.w_bits;
  s.w_mask = s.w_size - 1;

  s.hash_bits = memLevel + 7;
  s.hash_size = 1 << s.hash_bits;
  s.hash_mask = s.hash_size - 1;
  s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);

  s.window = new utils.Buf8(s.w_size * 2);
  s.head = new utils.Buf16(s.hash_size);
  s.prev = new utils.Buf16(s.w_size);

  // Don't need mem init magic for JS.
  //s.high_water = 0;  /* nothing written to s->window yet */

  s.lit_bufsize = 1 << (memLevel + 6); /* 16K elements by default */

  s.pending_buf_size = s.lit_bufsize * 4;

  //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
  //s->pending_buf = (uchf *) overlay;
  s.pending_buf = new utils.Buf8(s.pending_buf_size);

  // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
  //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);
  s.d_buf = 1 * s.lit_bufsize;

  //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;
  s.l_buf = (1 + 2) * s.lit_bufsize;

  s.level = level;
  s.strategy = strategy;
  s.method = method;

  return deflateReset(strm);
}

function deflateInit(strm, level) {
  return deflateInit2(strm, level, Z_DEFLATED, MAX_WBITS, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY);
}


function deflate(strm, flush) {
  var old_flush, s;
  var beg, val; // for gzip header write only

  if (!strm || !strm.state ||
    flush > Z_BLOCK || flush < 0) {
    return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
  }

  s = strm.state;

  if (!strm.output ||
      (!strm.input && strm.avail_in !== 0) ||
      (s.status === FINISH_STATE && flush !== Z_FINISH)) {
    return err(strm, (strm.avail_out === 0) ? Z_BUF_ERROR : Z_STREAM_ERROR);
  }

  s.strm = strm; /* just in case */
  old_flush = s.last_flush;
  s.last_flush = flush;

  /* Write the header */
  if (s.status === INIT_STATE) {

    if (s.wrap === 2) { // GZIP header
      strm.adler = 0;  //crc32(0L, Z_NULL, 0);
      put_byte(s, 31);
      put_byte(s, 139);
      put_byte(s, 8);
      if (!s.gzhead) { // s->gzhead == Z_NULL
        put_byte(s, 0);
        put_byte(s, 0);
        put_byte(s, 0);
        put_byte(s, 0);
        put_byte(s, 0);
        put_byte(s, s.level === 9 ? 2 :
                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
                     4 : 0));
        put_byte(s, OS_CODE);
        s.status = BUSY_STATE;
      }
      else {
        put_byte(s, (s.gzhead.text ? 1 : 0) +
                    (s.gzhead.hcrc ? 2 : 0) +
                    (!s.gzhead.extra ? 0 : 4) +
                    (!s.gzhead.name ? 0 : 8) +
                    (!s.gzhead.comment ? 0 : 16)
                );
        put_byte(s, s.gzhead.time & 0xff);
        put_byte(s, (s.gzhead.time >> 8) & 0xff);
        put_byte(s, (s.gzhead.time >> 16) & 0xff);
        put_byte(s, (s.gzhead.time >> 24) & 0xff);
        put_byte(s, s.level === 9 ? 2 :
                    (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
                     4 : 0));
        put_byte(s, s.gzhead.os & 0xff);
        if (s.gzhead.extra && s.gzhead.extra.length) {
          put_byte(s, s.gzhead.extra.length & 0xff);
          put_byte(s, (s.gzhead.extra.length >> 8) & 0xff);
        }
        if (s.gzhead.hcrc) {
          strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
        }
        s.gzindex = 0;
        s.status = EXTRA_STATE;
      }
    }
    else // DEFLATE header
    {
      var header = (Z_DEFLATED + ((s.w_bits - 8) << 4)) << 8;
      var level_flags = -1;

      if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
        level_flags = 0;
      } else if (s.level < 6) {
        level_flags = 1;
      } else if (s.level === 6) {
        level_flags = 2;
      } else {
        level_flags = 3;
      }
      header |= (level_flags << 6);
      if (s.strstart !== 0) { header |= PRESET_DICT; }
      header += 31 - (header % 31);

      s.status = BUSY_STATE;
      putShortMSB(s, header);

      /* Save the adler32 of the preset dictionary: */
      if (s.strstart !== 0) {
        putShortMSB(s, strm.adler >>> 16);
        putShortMSB(s, strm.adler & 0xffff);
      }
      strm.adler = 1; // adler32(0L, Z_NULL, 0);
    }
  }

//#ifdef GZIP
  if (s.status === EXTRA_STATE) {
    if (s.gzhead.extra/* != Z_NULL*/) {
      beg = s.pending;  /* start of bytes to update crc */

      while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
        if (s.pending === s.pending_buf_size) {
          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          flush_pending(strm);
          beg = s.pending;
          if (s.pending === s.pending_buf_size) {
            break;
          }
        }
        put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
        s.gzindex++;
      }
      if (s.gzhead.hcrc && s.pending > beg) {
        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
      }
      if (s.gzindex === s.gzhead.extra.length) {
        s.gzindex = 0;
        s.status = NAME_STATE;
      }
    }
    else {
      s.status = NAME_STATE;
    }
  }
  if (s.status === NAME_STATE) {
    if (s.gzhead.name/* != Z_NULL*/) {
      beg = s.pending;  /* start of bytes to update crc */
      //int val;

      do {
        if (s.pending === s.pending_buf_size) {
          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          flush_pending(strm);
          beg = s.pending;
          if (s.pending === s.pending_buf_size) {
            val = 1;
            break;
          }
        }
        // JS specific: little magic to add zero terminator to end of string
        if (s.gzindex < s.gzhead.name.length) {
          val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
        } else {
          val = 0;
        }
        put_byte(s, val);
      } while (val !== 0);

      if (s.gzhead.hcrc && s.pending > beg) {
        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
      }
      if (val === 0) {
        s.gzindex = 0;
        s.status = COMMENT_STATE;
      }
    }
    else {
      s.status = COMMENT_STATE;
    }
  }
  if (s.status === COMMENT_STATE) {
    if (s.gzhead.comment/* != Z_NULL*/) {
      beg = s.pending;  /* start of bytes to update crc */
      //int val;

      do {
        if (s.pending === s.pending_buf_size) {
          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          flush_pending(strm);
          beg = s.pending;
          if (s.pending === s.pending_buf_size) {
            val = 1;
            break;
          }
        }
        // JS specific: little magic to add zero terminator to end of string
        if (s.gzindex < s.gzhead.comment.length) {
          val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
        } else {
          val = 0;
        }
        put_byte(s, val);
      } while (val !== 0);

      if (s.gzhead.hcrc && s.pending > beg) {
        strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
      }
      if (val === 0) {
        s.status = HCRC_STATE;
      }
    }
    else {
      s.status = HCRC_STATE;
    }
  }
  if (s.status === HCRC_STATE) {
    if (s.gzhead.hcrc) {
      if (s.pending + 2 > s.pending_buf_size) {
        flush_pending(strm);
      }
      if (s.pending + 2 <= s.pending_buf_size) {
        put_byte(s, strm.adler & 0xff);
        put_byte(s, (strm.adler >> 8) & 0xff);
        strm.adler = 0; //crc32(0L, Z_NULL, 0);
        s.status = BUSY_STATE;
      }
    }
    else {
      s.status = BUSY_STATE;
    }
  }
//#endif

  /* Flush as much pending output as possible */
  if (s.pending !== 0) {
    flush_pending(strm);
    if (strm.avail_out === 0) {
      /* Since avail_out is 0, deflate will be called again with
       * more output space, but possibly with both pending and
       * avail_in equal to zero. There won't be anything to do,
       * but this is not an error situation so make sure we
       * return OK instead of BUF_ERROR at next call of deflate:
       */
      s.last_flush = -1;
      return Z_OK;
    }

    /* Make sure there is something to do and avoid duplicate consecutive
     * flushes. For repeated and useless calls with Z_FINISH, we keep
     * returning Z_STREAM_END instead of Z_BUF_ERROR.
     */
  } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) &&
    flush !== Z_FINISH) {
    return err(strm, Z_BUF_ERROR);
  }

  /* User must not provide more input after the first FINISH: */
  if (s.status === FINISH_STATE && strm.avail_in !== 0) {
    return err(strm, Z_BUF_ERROR);
  }

  /* Start a new block or continue the current one.
   */
  if (strm.avail_in !== 0 || s.lookahead !== 0 ||
    (flush !== Z_NO_FLUSH && s.status !== FINISH_STATE)) {
    var bstate = (s.strategy === Z_HUFFMAN_ONLY) ? deflate_huff(s, flush) :
      (s.strategy === Z_RLE ? deflate_rle(s, flush) :
        configuration_table[s.level].func(s, flush));

    if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
      s.status = FINISH_STATE;
    }
    if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
      if (strm.avail_out === 0) {
        s.last_flush = -1;
        /* avoid BUF_ERROR next call, see above */
      }
      return Z_OK;
      /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
       * of deflate should use the same flush parameter to make sure
       * that the flush is complete. So we don't have to output an
       * empty block here, this will be done at next call. This also
       * ensures that for a very small output buffer, we emit at most
       * one empty block.
       */
    }
    if (bstate === BS_BLOCK_DONE) {
      if (flush === Z_PARTIAL_FLUSH) {
        trees._tr_align(s);
      }
      else if (flush !== Z_BLOCK) { /* FULL_FLUSH or SYNC_FLUSH */

        trees._tr_stored_block(s, 0, 0, false);
        /* For a full flush, this empty block will be recognized
         * as a special marker by inflate_sync().
         */
        if (flush === Z_FULL_FLUSH) {
          /*** CLEAR_HASH(s); ***/             /* forget history */
          zero(s.head); // Fill with NIL (= 0);

          if (s.lookahead === 0) {
            s.strstart = 0;
            s.block_start = 0;
            s.insert = 0;
          }
        }
      }
      flush_pending(strm);
      if (strm.avail_out === 0) {
        s.last_flush = -1; /* avoid BUF_ERROR at next call, see above */
        return Z_OK;
      }
    }
  }
  //Assert(strm->avail_out > 0, "bug2");
  //if (strm.avail_out <= 0) { throw new Error("bug2");}

  if (flush !== Z_FINISH) { return Z_OK; }
  if (s.wrap <= 0) { return Z_STREAM_END; }

  /* Write the trailer */
  if (s.wrap === 2) {
    put_byte(s, strm.adler & 0xff);
    put_byte(s, (strm.adler >> 8) & 0xff);
    put_byte(s, (strm.adler >> 16) & 0xff);
    put_byte(s, (strm.adler >> 24) & 0xff);
    put_byte(s, strm.total_in & 0xff);
    put_byte(s, (strm.total_in >> 8) & 0xff);
    put_byte(s, (strm.total_in >> 16) & 0xff);
    put_byte(s, (strm.total_in >> 24) & 0xff);
  }
  else
  {
    putShortMSB(s, strm.adler >>> 16);
    putShortMSB(s, strm.adler & 0xffff);
  }

  flush_pending(strm);
  /* If avail_out is zero, the application will call deflate again
   * to flush the rest.
   */
  if (s.wrap > 0) { s.wrap = -s.wrap; }
  /* write the trailer only once! */
  return s.pending !== 0 ? Z_OK : Z_STREAM_END;
}

function deflateEnd(strm) {
  var status;

  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
    return Z_STREAM_ERROR;
  }

  status = strm.state.status;
  if (status !== INIT_STATE &&
    status !== EXTRA_STATE &&
    status !== NAME_STATE &&
    status !== COMMENT_STATE &&
    status !== HCRC_STATE &&
    status !== BUSY_STATE &&
    status !== FINISH_STATE
  ) {
    return err(strm, Z_STREAM_ERROR);
  }

  strm.state = null;

  return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
}


/* =========================================================================
 * Initializes the compression dictionary from the given byte
 * sequence without producing any compressed output.
 */
function deflateSetDictionary(strm, dictionary) {
  var dictLength = dictionary.length;

  var s;
  var str, n;
  var wrap;
  var avail;
  var next;
  var input;
  var tmpDict;

  if (!strm/*== Z_NULL*/ || !strm.state/*== Z_NULL*/) {
    return Z_STREAM_ERROR;
  }

  s = strm.state;
  wrap = s.wrap;

  if (wrap === 2 || (wrap === 1 && s.status !== INIT_STATE) || s.lookahead) {
    return Z_STREAM_ERROR;
  }

  /* when using zlib wrappers, compute Adler-32 for provided dictionary */
  if (wrap === 1) {
    /* adler32(strm->adler, dictionary, dictLength); */
    strm.adler = adler32(strm.adler, dictionary, dictLength, 0);
  }

  s.wrap = 0;   /* avoid computing Adler-32 in read_buf */

  /* if dictionary would fill window, just replace the history */
  if (dictLength >= s.w_size) {
    if (wrap === 0) {            /* already empty otherwise */
      /*** CLEAR_HASH(s); ***/
      zero(s.head); // Fill with NIL (= 0);
      s.strstart = 0;
      s.block_start = 0;
      s.insert = 0;
    }
    /* use the tail */
    // dictionary = dictionary.slice(dictLength - s.w_size);
    tmpDict = new utils.Buf8(s.w_size);
    utils.arraySet(tmpDict, dictionary, dictLength - s.w_size, s.w_size, 0);
    dictionary = tmpDict;
    dictLength = s.w_size;
  }
  /* insert dictionary into window and hash */
  avail = strm.avail_in;
  next = strm.next_in;
  input = strm.input;
  strm.avail_in = dictLength;
  strm.next_in = 0;
  strm.input = dictionary;
  fill_window(s);
  while (s.lookahead >= MIN_MATCH) {
    str = s.strstart;
    n = s.lookahead - (MIN_MATCH - 1);
    do {
      /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;

      s.prev[str & s.w_mask] = s.head[s.ins_h];

      s.head[s.ins_h] = str;
      str++;
    } while (--n);
    s.strstart = str;
    s.lookahead = MIN_MATCH - 1;
    fill_window(s);
  }
  s.strstart += s.lookahead;
  s.block_start = s.strstart;
  s.insert = s.lookahead;
  s.lookahead = 0;
  s.match_length = s.prev_length = MIN_MATCH - 1;
  s.match_available = 0;
  strm.next_in = next;
  strm.input = input;
  strm.avail_in = avail;
  s.wrap = wrap;
  return Z_OK;
}


exports.deflateInit = deflateInit;
exports.deflateInit2 = deflateInit2;
exports.deflateReset = deflateReset;
exports.deflateResetKeep = deflateResetKeep;
exports.deflateSetHeader = deflateSetHeader;
exports.deflate = deflate;
exports.deflateEnd = deflateEnd;
exports.deflateSetDictionary = deflateSetDictionary;
exports.deflateInfo = 'pako deflate (from Nodeca project)';

/* Not implemented
exports.deflateBound = deflateBound;
exports.deflateCopy = deflateCopy;
exports.deflateParams = deflateParams;
exports.deflatePending = deflatePending;
exports.deflatePrime = deflatePrime;
exports.deflateTune = deflateTune;
*/


/***/ }),
/* 155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

var utils = __webpack_require__(34);

/* Public constants ==========================================================*/
/* ===========================================================================*/


//var Z_FILTERED          = 1;
//var Z_HUFFMAN_ONLY      = 2;
//var Z_RLE               = 3;
var Z_FIXED               = 4;
//var Z_DEFAULT_STRATEGY  = 0;

/* Possible values of the data_type field (though see inflate()) */
var Z_BINARY              = 0;
var Z_TEXT                = 1;
//var Z_ASCII             = 1; // = Z_TEXT
var Z_UNKNOWN             = 2;

/*============================================================================*/


function zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }

// From zutil.h

var STORED_BLOCK = 0;
var STATIC_TREES = 1;
var DYN_TREES    = 2;
/* The three kinds of block type */

var MIN_MATCH    = 3;
var MAX_MATCH    = 258;
/* The minimum and maximum match lengths */

// From deflate.h
/* ===========================================================================
 * Internal compression state.
 */

var LENGTH_CODES  = 29;
/* number of length codes, not counting the special END_BLOCK code */

var LITERALS      = 256;
/* number of literal bytes 0..255 */

var L_CODES       = LITERALS + 1 + LENGTH_CODES;
/* number of Literal or Length codes, including the END_BLOCK code */

var D_CODES       = 30;
/* number of distance codes */

var BL_CODES      = 19;
/* number of codes used to transfer the bit lengths */

var HEAP_SIZE     = 2 * L_CODES + 1;
/* maximum heap size */

var MAX_BITS      = 15;
/* All codes must not exceed MAX_BITS bits */

var Buf_size      = 16;
/* size of bit buffer in bi_buf */


/* ===========================================================================
 * Constants
 */

var MAX_BL_BITS = 7;
/* Bit length codes must not exceed MAX_BL_BITS bits */

var END_BLOCK   = 256;
/* end of block literal code */

var REP_3_6     = 16;
/* repeat previous bit length 3-6 times (2 bits of repeat count) */

var REPZ_3_10   = 17;
/* repeat a zero length 3-10 times  (3 bits of repeat count) */

var REPZ_11_138 = 18;
/* repeat a zero length 11-138 times  (7 bits of repeat count) */

/* eslint-disable comma-spacing,array-bracket-spacing */
var extra_lbits =   /* extra bits for each length code */
  [0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0];

var extra_dbits =   /* extra bits for each distance code */
  [0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];

var extra_blbits =  /* extra bits for each bit length code */
  [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7];

var bl_order =
  [16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];
/* eslint-enable comma-spacing,array-bracket-spacing */

/* The lengths of the bit length codes are sent in order of decreasing
 * probability, to avoid transmitting the lengths for unused bit length codes.
 */

/* ===========================================================================
 * Local data. These are initialized only once.
 */

// We pre-fill arrays with 0 to avoid uninitialized gaps

var DIST_CODE_LEN = 512; /* see definition of array dist_code below */

// !!!! Use flat array instead of structure, Freq = i*2, Len = i*2+1
var static_ltree  = new Array((L_CODES + 2) * 2);
zero(static_ltree);
/* The static literal tree. Since the bit lengths are imposed, there is no
 * need for the L_CODES extra codes used during heap construction. However
 * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
 * below).
 */

var static_dtree  = new Array(D_CODES * 2);
zero(static_dtree);
/* The static distance tree. (Actually a trivial tree since all codes use
 * 5 bits.)
 */

var _dist_code    = new Array(DIST_CODE_LEN);
zero(_dist_code);
/* Distance codes. The first 256 values correspond to the distances
 * 3 .. 258, the last 256 values correspond to the top 8 bits of
 * the 15 bit distances.
 */

var _length_code  = new Array(MAX_MATCH - MIN_MATCH + 1);
zero(_length_code);
/* length code for each normalized match length (0 == MIN_MATCH) */

var base_length   = new Array(LENGTH_CODES);
zero(base_length);
/* First normalized length for each code (0 = MIN_MATCH) */

var base_dist     = new Array(D_CODES);
zero(base_dist);
/* First normalized distance for each code (0 = distance of 1) */


function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {

  this.static_tree  = static_tree;  /* static tree or NULL */
  this.extra_bits   = extra_bits;   /* extra bits for each code or NULL */
  this.extra_base   = extra_base;   /* base index for extra_bits */
  this.elems        = elems;        /* max number of elements in the tree */
  this.max_length   = max_length;   /* max bit length for the codes */

  // show if `static_tree` has data or dummy - needed for monomorphic objects
  this.has_stree    = static_tree && static_tree.length;
}


var static_l_desc;
var static_d_desc;
var static_bl_desc;


function TreeDesc(dyn_tree, stat_desc) {
  this.dyn_tree = dyn_tree;     /* the dynamic tree */
  this.max_code = 0;            /* largest code with non zero frequency */
  this.stat_desc = stat_desc;   /* the corresponding static tree */
}



function d_code(dist) {
  return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
}


/* ===========================================================================
 * Output a short LSB first on the stream.
 * IN assertion: there is enough room in pendingBuf.
 */
function put_short(s, w) {
//    put_byte(s, (uch)((w) & 0xff));
//    put_byte(s, (uch)((ush)(w) >> 8));
  s.pending_buf[s.pending++] = (w) & 0xff;
  s.pending_buf[s.pending++] = (w >>> 8) & 0xff;
}


/* ===========================================================================
 * Send a value on a given number of bits.
 * IN assertion: length <= 16 and value fits in length bits.
 */
function send_bits(s, value, length) {
  if (s.bi_valid > (Buf_size - length)) {
    s.bi_buf |= (value << s.bi_valid) & 0xffff;
    put_short(s, s.bi_buf);
    s.bi_buf = value >> (Buf_size - s.bi_valid);
    s.bi_valid += length - Buf_size;
  } else {
    s.bi_buf |= (value << s.bi_valid) & 0xffff;
    s.bi_valid += length;
  }
}


function send_code(s, c, tree) {
  send_bits(s, tree[c * 2]/*.Code*/, tree[c * 2 + 1]/*.Len*/);
}


/* ===========================================================================
 * Reverse the first len bits of a code, using straightforward code (a faster
 * method ry would fill window, juyped) & 0xgexghtforwardibi_validalue5on send_bits(s lerfirst ( straialiet = deflate  } else /* UPDATEte  < ster
 &l_windowter
 ff;      brete  <<      b}en >= 0) { buf[ctionar
}


funcs   put=========================================================================
 * Reverse theFst.
   */in bi_buf ,* retbottom  * o 7_buf.  Alition deflateSetD leest.
(s.bi_valid > (Buf_size= /* 6_byte(s, strbi_buf);
    s.bi_buf = value >> (B0valid += length;
(s.wrap s.level === 6(Buf_size windowBits uf[s.pending++] = (w >>> 8) &value >>      } else value >> f;  8valid += length;
-  8vali}========================================================================
 * Reverse theCr-32 fol sofs */
   are imposedsmall 

fun call/
    its oft
   are impos thees */

  k */
  this.ertion: there is enougugh sey may n caldad zero in, not u0;      ] * ava*lid       are/
  this.mn// shsong atsync( probabi*/
  this.ertioOUT there is senougugh sevalid
// ellowing rfs */
   are impos,peed.
*lid ead of new utilse cuver sougugcan be keptt length code */
  ..
*lid e of the bi ;       builhe new;esc;
var    buie forthe new i, Fre)) *s.
*lid eMAX_turnion deflateSetDgenee[c   f);
his.dbyte(s,(s, flusl;

  *s_byte(s,re))t_desc*the corrrespondire)) the ripof s de = deflatatic_trlems;     it le   /* the= defla0;       ems;     it le0;      , n;
  var tic_trlems;    it le  /* the e  = static_, n;
  v  = static_tr;    it le  /* the e  = stati, n;
  vfor ea_trlems;    it le  /* the e   /* extra n;
  vtra_bastrlems;    it le  /* the e   /* ease = defla0;  max_lengt;    it le  /* the e   /* max b n;
  v      /* element/ to buixtra_btat_d var h)  /* write gzip . Sintof trapondire))  the treetat_d varextra biwrite gzip for the codtat_d varxextra biwrite gts for each cotat_d varf     /* element/ t/
  this.stat_dsh, straflils.Bber of elements in hash tabendingree */

  /oode withow if t le( /* log2(h /* l<  ts */

v(h /* 
   buf |= (v_BITS+1] /* ] (B0valin using Inller s ofpthedler-32 fol sofs */
   are imposed( must maa highlstraflils */
  tld_fllength codes are send_bhis.bi_vali 1]/= 0;  [= 0;      ].Len*/);
}


/* = p searchdintllength his.heapif t le(h.ins_h];      imum   re   = 2 * m  
   buf |=n.ins_h]; [h]valid  /* logi 1]/i 1]/n.Len*/);
}

Dad = Len*/);
}


/* = +     bre=== B level {

  this.stalementevel + 7  /* max b n;;;;;straflilhile (--n
e(s,re))/n.Len*/);
}


/* = p extra n;the trof trarailer e))/n]
Dad  must ed fon this *monomor trees._=== nvel {

ength {he currenrom writtelleleafmn// r trees._ (v_BITS+1] /* ]hile (--x /* log2(ees._=== nve=vtra_.stalementx /* logndex] n);
 ra_]le (--n
e(s,flogi 1]/ne*/, tre Len*/valid +=;         }fe*/(MATCH -x /* strm.avail_  = stati.status = FINISHvar      }fe*/(sre))/n.Len*/);
}


/* =  -x /* strm.av(s.status ==straflils.=rn Z_STREAM_Erite the/ Trace((srderr,"\nof current btraflil\n")avail_ou may hputenptt lennary fi disbj2n calp  thength CalgteSecorpushow if `malindblock, all if current  must cl winc( probes.statu/* UPDATEevel + 7  /* max ill_windowokahead >v_BITS+1] /* ] (=rn Z_ST /* --eader += >v_BITS+1] /* ]--eaement/ ttereblockleafmdow*/
  this.max_le+= >v_BITS+1] /* */);
   }efinittereblockstraflils temhe o/* *br/
   max_le+= >v_BITS+1]7  /* max ]--e n;the t of br/
   mhength straflils temhe formssionlockhodprthbut thiis not an epport effathis. v_BITS+1]7  /* max ]ut thiix_le+=straflils-} else }en >= 0)straflils>     if ementw
    -32 foal   are impose;
 ca in l_bunc( probabi*/
  this.erthiishn the windro. There   = 2 * . (t frome codsure
      Howeve * of de*e imposedstructure, fixas po*/

so weros po*st 256n erdein thtakated to urce 'ar' s->windosynHaruhiko Okumura if com/if t le( /* log   /* max bi /* lK : Z;T /* --  buf |=n.ins_v_BITS+1] /* ]windowokaheadn       putShortMm.ins_h]; [--h]valid vel < 1vel {

ength {he currenromalid vel < re))/m.Len*/);
}


/* =      /* ss.last_fluse/ Trace((srderr,"     %i_buf. %d->%d\n"h) 2 + 1]/m]

/*,  /* ss.status = BU;         }(< 4)) <re))/m.Len*/);
}


/* =o(stre))/m.Len tre Len*/valid e(s,re))/m.Len*/);
}


/* = p extra n;thlush_pendin--e n;th}ali}========================================================================
 * Reverse theGenSintof/

  // shsmall r of b

fun cals
   *   ed( must e L_C misrepghlss */
 )ertion: there is enouguad of new utilse cuver souguif current  (Take for   exa*byte
 * seq

fun calougugh sevalid
// ellsmall  */

 To use difrtioOUT there is enougugh sev     
// ellsmall  */

 To use dire, non.
*lid ency *      */
  ..
*deflateSetDgene // s(desc)  {

engt, new utildbyte(s,c* ty - ** the dynaast_flusespondire)) void   intof*/byte(s,    0;      ,  dynaast_flusespe with non zero frequency */
  this.statyte(s,LOC(stnew util  /* largest cododes at each bit length for an opti de = deflaext;
       AX_MATCH - MIN  /* numbe codoee ab    in leng length code */
  [tat_dsh,           /* largest g index in l_b    in lentat_d varextra biwrite gzgest g indcodextra_btat_d var a biwrite gzgest g  g ind     
tra_btat
the t of n.

var util  *   ed purp all nsfer thgenSintof/

  // responded to  expresscoderfirstal.f com/if t le( /* log1(h /* l<  ts */

v(h /* 
   buf |=ext;
    ] /* ] (B       ( str nuv_BITS+1] /* *ash_ma<<     b}
the tC
  //tsh is cos
   *   ed/


ew utils pur   H.

eAt(e of tah non zed to inly marbuffen  this.depstrm->avai ( str nuv_BITS+1]ts */

v]-1CH) (1<<ts */

v)-1, the/        "c(   H.

eAtos
   *   e(strm.avTracev((srderr,"\ngene // s:a0;       %i_")  {

engt (bstatt le(* bit leidalu0;      , n
   buf |=uf.length;re))/n.Len*/);
}


/* =trm.avail_ength=rn Z_STe currenromalid ementw
  irst len bch cotat_d gi 1]/ne*/, tree[c *  p exerfirst (ext;
    ] }

++aialiehead[s.avTracecv(descUSH e);
/* The sal_inderr,"\nn %3d %c l %2ev  %4x (%x)_")ad[s.avpendinal_isgraph(n_hufn : ' ')aiali,r e))/n]
Cngt, ext;
    ] }

-1))vali}========================================================================
 * Reverse the the comprlen buf.ngth '========'juypedtion send_bits(slock(;
/* tate)et = deflan max number . Sintosf trapoe))  the treetat_d varextra biwrindcode *     max_leuf.lengax bit len */
  [in lentat_d var    ,  dynind     in lentat_d varn.

,  dynind 1) */


xtra_btat_d var
ew utils  AX_MATCH - MIN  /* numbe
t cododes at each bit length for an optipose,
ees */
  thishow if `stdoings wh/

;
  returbuf = !== INIT/* tate_t ca)TREAM_Er if `maln soomck.
bedd a c witase,glob
  uf.nypedt to buted
gaps

var :functi
  if (NO_ || sGLOBAL_POINTERS
 esc;
var statie  = static_tH e);
/* The s;
 esc;
var statie*/
  this.e=s =   /* ext;
 esc;
vardstatie  = static_tH e);
/* dhe s;
 esc;
vardstatie*/
  this.e=s =   /d ext;
 esc;
varb statie*/
  this.e=s =   /b* ext;
* Flustat
the t the comprlen bmputn l_= MIN_MATar L_) ->e for each noATar 8)btat_dN_MATCH -2(eest le(               <ES  = 29;
/* nll_w     
   buf |=);
/* First[    ] (B* max b n;;;t le(* bit lnd.exvel + =   /* ext[    ]), n
   buf |= de  = new Arr[  = ne> 8) &    , n;/Assert(strm->avail_engATCH nd of, "lock(;
/* tate 16 and v!nd of"be
t codNginal h is co6 and v L_C(h (0 == MIN_M258)bca  or als being ted to  */
wolengths, an   *:      284 nu5code, ur      285,re wwe highlstrarailer  = new Arr[ L_]s software
// sndow Arn l:his.depste  = new Arr[  = ne*ash_) &    , 
the t the comprlen bmputn l_];
}
ATar32K) ->e];
}
ch noATar 9)btat_d];
}
 -2(eest le(               <E16w     
   buf |=);
/*];
}[    ] (Bn.

, n;;;t le(* bit lnd.exvel + =   /d ext[    ]), n
   buf |= deist] : _dist_c> 8) &    , n;/Assert(strm->avail_];
}
 nd of, "lock(;
/* tate 1];
}
!nd of"be
t ];
}


 lent/ t/
ce ntw
oi,r agai*/

var  to bdis', wisyn128om/if t le(       <Eero(basw     
   buf |=);
/*];
}[    ] (Bn.

el +7, n;;;t le(* bit lnd.exvel +( =   /d ext[    ]*as7)), n
   buf |= deist] : _di >>> 7st_c> 8) &    , n;/Assert(strm->avail_];
}
 nd of, "lock(;
/* tate 1 of+];
}
!nd51 (str
the tC  Howeve /

  // shhength ral tree. Since theom/if t le( /* log2(h /* l<  ts */

v(h /* 
   buf |=v_BITS+1] /* ] (B0valin usirm.input okaheadn <   43 = s.strst;
/* The s/n.Len*/);
}


/* = p 8valid nhile (--v_BITS+1]8]hile (}ut okaheadn <   L_)  s.strst;
/* The s/n.Len*/);
}


/* = p 9valid nhile (--v_BITS+1]9]hile (}ut okaheadn <   79)  s.strst;
/* The s/n.Len*/);
}


/* = p 7valid nhile (--v_BITS+1]7]hile (}ut okaheadn <   87 = s.strst;
/* The s/n.Len*/);
}


/* = p 8valid nhile (--v_BITS+1]8]hile (}ut e tC  287 are needed doiMAX_BL;
}bly wiwbe misrhe ENDrlen ms */
   highl theon. However
 r thgetl tree (see _Huffmaeq

fun( thish non zed to buffen  if com/if gene // s(e);
/* The sal;
/* maximu, new utild;t
the t of ance tree. (Actuallyn tht since:om/if t le(* bit lnd.eero(basw n
   buf |=e);
/* dhe s/n.Len*/);
}


/* = p 5;uf |=e);
/* dhe s/n.Len tree[c *  p exerfirst (e, 5* Start a n/entw
ty -  other neewebca  for J */
}



fus
 esc;
var statis  AX_Mesc(static_tree, extral_bits, extral_base,1 + LENGTH_Cal;
/* ma, ts */

v);
 esc;
vardstatis  AX_Mesc(static_tree, extrad_bits, extrad_base,0,gest g  g D
/* ma, ts */

v);
 esc;
varb statis  AX_Mesc(static_treeAX_MATCH -0),s =   /b* exte,0,gest g  gB;
/* ma, ts */L*/

v);
 a n/INIT/* tate_t cath;reenr========================================================================
 * Reverse the the comprl or continuion send_bits(state_ 0, falet = deflan mer . Sintosf trapoe))  the treetat
the t the comprlen btored_om/if t le(* bit lnd.eLro(basw  n
   b = dyn_lhe s/n.Len tre Len*/// Fromif t le(* bit lnd.eero(basw  n
   b = dyn_dhe s/n.Len tre Len*/// Fromif t le(* bit lnd.eBLro(basw n
   bns_v_Bhe s/n.Len tre Len*/// Fromi
  = dyn_lhe s/ = 256;
/*Len tre Len*/// h_avail;       = FINISHvar    tch_lengt= -1;lihead;
h (0 e  } els=======================================================================
 * Reverse theFst.
   */in bi_buf duplic    ngth srt LSBnumbe bug bts.daryon deflateSetD le  }
upale
i_valid > (Buf_size -ndowBits  strbi_buf);
    s.bi_buf s.level === 6(Buf_size    putShor// (uch)((ush)(B)(()s->  s.bi_buf = va[s.pending++] = (w >>> 8) &value >>le (}ut value >> (B0vali+= length;
(s.wr}=====================================================================
 * Reverse theCrp trek(s, 0ontinu,ek(s,abi*/ all s co6 and vuplii MAX_fen ' So we d produf// 2.sh ltern deflateSetDcrp , 0, falseing -ali,r     /*
//Dctionar;

  *s_byts.gzff = * >>l dyninds cout;
  ty - *atytuns   or eac,  dynind/* l */
  [tat
               /c treereenduf/ this wiateSeinly mars->windo de = d le  }
upale max number c    none bug bts.daryetat
thail_     /*owBits  strbi_buf);
alieheits  strbi_buf);
~alieheit}tyte(okaheadali--  buyte(s, (uch)((ush)* >>
  _byte(}ut Set(tmpDict, diuf, s.pending - bt replacing -ali,ruf, s.pening_buf[s.pend
  }
}
wr}=====================================================================
 * Reverse theCrmpare crc subtoredaightforondire)) thptendintie      ly

henxa*byte
subtoredtput aro. Th/
  this.e256n e maximpressionwoall ld_fl */
  ..
*deflateSetDt bufer(desc) nh) 2 thpteet = defla_nInitn.Lenb n;
  v_mInitm.Lenb n;
}


fu re))/_nI tre Len*//<r e))/_mI tre Len*//.status ==== re))/_nI tre Len*//rser e))/_mI tre Len*//&& thpte[n] <  thpte[m]))wr}=====================================================================
 * Reverse theRek(s, ngth his.hpropvaiyisynmovn l_]ow*/
  this.minserbottom n// rk, theexs.gngbotto n// rro fryte
s bufestllen/* l
wols plaailnear sngth k(sutn l thezlib gth his.hpropvaiyin ere-establishor (ngth fa
   mt buferal hnii MAX_f
wols pl)ion put_short(s,q]ow*his.* 2]/*.C, kdbyte(s,(s, flusl;

  *s_byte(s,c* ty - ** the despondire)) voirek(s, n*/byte(s,    ka biwrite gzgestwrittd) voitereb]ow*/ de = deflav.ins_h]; [k]b n;
  vj.inka<<   t len *ftls pllenkom/if okaheadjng_bufh];  aliet = da new etljlowing rs bufestllenondirwols plif (s.strail_j.commh];  alitus !==  Dt bufer(desc) s_h]; [j*/);
) s_h]; [j
) s_thptee  buf |= djhile (--n
e(s,newExioduf/v 
//  buferal hnig ands pla (s.strail_t bufer(desc) v) s_h]; [j
) s_thptee  b       Make sure tExs.gnge/v ro fryte
s bufestls plax_le+= >h]; [k].ins_h]; [j]valid k.inj;ke sure tAndhe current]ow*/
  this. */
engthsjlowing r *ftls pllenkom/if  dj <<      b}
+= >h]; [k].invls===== comlinngth nvial == cTREESMALLEST// h_a====================================================================
 * Send a value on   */ithis ty - output.
 */ghtforondi * seqHuffmaeq

fusrn deflateSetDcrtput.
, 0, falsel_bits,The stbyte(s,(s, flusl;

  *s_byte(s,c. Ho,c* ty - *The s; len . Since theom/iyte(s,c. Ho,c* ty - *dhe s; lenee. (Actuallyn de = deflan.

,  dyngzgestwri 1) */


funh (0 ed     ifmax_leuf.lece dynaast_flusesph (0 == MIN_Mit leh (0 ed s.gz (if ];
}
 nd0)max_leuf.lex      /* largeindex in l_xtra_bits.* ======_d var    ,  dyn largeind/

  // rrc s on ===_d var =   a biwrite gts lements in or each corc s on ===_valid > = -1;lihe      putShor/* UPDATE_H];
}
 -(va[s.pending++]  /* if+lex Len   var) |-(va[s.pending++]  /* if+lex Len*/);
s.status lsc;  a[s.pending++] l/* if+lex]valid vel}
   alid vegth >=s        s.last_flush c, tree) {
lcsel_bit)finitioon a es 0..255 */.ins_h = (s.avTracecv(isgraph(lc)al_inderr," '%c'_") lc)while (val       val = 0;
nitHill blscislen bmp(0 == MIN_M + 1);
zero(ins_h = (s.       e  = new Arr[ c]valid veush c, tree) {
 str nu1 + LENGTH_Call_bit)finitioon s co6 and v0,0,0,0,0,,,,,,, or ea=+ =   /* ext[    ]valid veusgth  or ea      putShortMSBs lsc-==);
/* First[    ];tShortMSBs , tree[c * 2]lcse or ee max numnitioon s co or ea.
 */
funct0,0,0,,,,,,,
      }
 >=s --eawri 1)  ed fowlen bmp(0 = 1) */


- 1(ins_h = (s.       ) {
  return;s_h = (s.av->avai ( str < D
/* ma, "bad ) {
  "   if (s.looh c, tree) {
 strs,The st max numnitioon s code */
  [0,0,0,0,1,,,,,,, or ea=+ =   /d ext[    ]valid veusgth  or ea      putShortMSBs  1)  -==);
/*];
}[    ];tShortMSBs , tree[c * 2]d;
}bl or ee maxnitioon s co or eade */
  [unct0,0,0,,,,,,,
      }} len . Sincehic p(0 =pair ?r trees._the tC
  //tsh is co tralof netweef.
 */
fu/* if cald/* i+l/* ifed okif (s.strstrm->avail(uInt)(s->, s.peni.com->lte_ uf_vali+ 2*lx,s.strstrm,,,,,,,"
 */
funct=straflil"   if (s}en >= 0)ld.comm= -1;lih.wrap = 0;  c, tree) {
 = 256;
/all_bit)f========================================================================
 * Reverse theCr Howeve  catHuffmaeq

funuplicss   sd/

  // rbr J *  ifsnupli imposefrtioU/
    its oft
   are imposees */

  k */
  this.ertion: there is enougugh se may n
// ellsmall  */

 To use difrtioOUT there is senougugh sey alitanev     zero inlowing rfs */
   are impos.
*lid eanev   static tree    .e of the bi ;       builhe new;esc;
var    bu.
*lid ea forthe new i, Fre)) *seMAX_turni256 val se 0;       
// elion deflateSetD nicaBhe sf);
his.dbyte(s,(s, flusl;

  *s_byte(s,re))t_desc*the coespondire)) the ripof s de = deflatatic_trl  it le   /* the= deflastatic_treeit le  /* the e  = static_, n;
  v  = static  it le  /* the e  = stati, n;
  vf = elems  it le  /* the e   /* 
_d var h)  /* write gip . Sintof traphis.h the treetat_d var0;         d BUF_Ee with non zero frequency */
  this.stat_d var    ,  dyn largcodoewittd) rigina protmor treese tC  Howeve /

 
gaps

phis.ny expkleah n/
  thith the tr flush thh]; [SMALLEST]i256 vs pla inh]; [n] zeroh]; [2*n]/
  av]; [2*n+1].ush thh]; [0] *seMAX_nsfethis.depstmmh];  alit(B0vali+=h];      =e   = 2 * mstatt le(* bit lnd.e   /* mn
   buf |=l < re))/n.Len tre Len*//      putShortM >h]; [++mmh];  ali] =r0;         n;tShortM >thpte[n] (s.wrap val       val = 0he s/n.Len*/);
}


/* = p   /* use th}t
the t of pkziptt l p(// 2. Ala very atkleah n catde */
  [0,0,0BL;
}s,ed to bon s ry atkleah n catbr J h  appreder ofthe =l <ough room */

//zed to 
  if (s.    .eSoninitializ_BLOCK cngs wy aate! */ewebt lce atkleah  highl wo  // shhenequency */
  this.this.depstokahead >h];  alit<ut_byte(s,n       >h]; [++mmh];  ali] =r(0;       <ut ?r++0;       :ctionary he s/n,0,0,en tre Len*/// h_avatM >thpte[n   ] (B0valid +=;      --e uf |=l <   = stati.status = FINISHvar    -= she s/n,0,0,en*/);
}


/* =trm.avn
e(s,newn    
//0ehic1re ws.
 port effput aror each cotat_dn
e(it le0;       =r0;      ;t
the t of  the treenot u0;      /2+1e lah];  ali] zeroleav shhength _bits highlestablish
sub-h]; shhenc( probabi* impose:his.depstt le(* bid >h];  alit put/*    /2 === nve=v BUi--  bs,q]ow*his.* 2]/*.C, n)rite the tC  Howeve /

 Huffmaeq

funbynd uselesld outbingths for uah n wo highl/
  thithn// sthis.depstn         /* max numbn largcodoexr flressionn    hength _bit.statu/* UPDATE//pqaltere* 2]/*.C, n)rigcodo   n    henleah n/
  thic    zero(HASH(pqaltere zero(s.hen.ins_h]; [t/*SMALLEST*/]valid +=h]; [t/*SMALLEST*/].ins_h]; [ >h];  ali--]valid ,q]ow*his.* 2]/*.C, t/*SMALLEST*/);zero(HASHtrees._m.ins_h]; [t/*SMALLEST*/]vsesph   n    henoexr leah n/
  thic    zalid +=h]; [--= 0;      ].=an mer  retngth n// shsong atsyn/
  thic    zero(+=h]; [--= 0;      ].=am;ke sure tCprotml or con    fa
   mhenom matcotat_d gi 1]/n,0,0,en tre Len*/// re))/n.Len tre Len*//+tre))/m.Len tre Len*/valid  >thpte[n   ] (B( >thpte[n] ) {
 thpte[m] ?r >thpte[n] :{
 thpte[m]) +     brei 1]/n.Len*/);
}

Dad = =,re))/m.Len*/);
}

Dad = =,n   ;t
thmber cpliiookahegth n con    ib gth his.h  zero(+=h]; [t/*SMALLEST*/].inn   
 valid ,q]ow*his.* 2]/*.C, t/*SMALLEST*/);z
(s}en >= 0) >h];  alit =tatic
o(+=h]; [--= 0;      ].=as_h]; [t/*SMALLEST*/]va the tAot an epoflr,nougugh sey may n caldad zero in.trofca  fow highlgenSintof/

  are imposethis.depstgenee[c   f);
his.d;t
the t of gh sevalid
//fowl in, webca  genSintof/

  are // show  Dgene // s(desc)  {

engt, s_v_BITS+1)f========================================================================
 * Reverse theSca  an . Sincehicee. (Actuallynvoid ts grnesougugcan be kepthength  // s
to  */
th codes are send_..
*deflateSetDtca Bhe sf);
desc)  {

engtdbyte(s,(s, flusl;

  *s_byte(s,c* ty - ** the ddespondire)) voiredeca imor tryte(s,    0;      ,  dyer cplii* l  with non zehenequency */
  this.i de = deflaea biwrite gzgest g  g ind. Sintosf trapl  */

 To use dirtat_d vart lealit(Bd BUest g  g indtah nt
  tor each co===_d var ureac,  dynzgest g  g indthe bi ;f  k */
  0,0,0,0,
 deflaext;ength;re))/00,en*/);
}


/* =t indthe bi ;f oee ab    ,0,
 defla utils  0e dynaast_flusespt) */

/* esthength  k */
  0,0,0,0,_d var0;    tils  7  /* largeind    t) */

/* est,0,_d var0in   tils  4  /* largeind  */

 */

/* est,0,_valid ext;ength     putShor0;    tils  138valid 0in   tils  3   b}
+=re))/(0;       +nctioen*/);
}


/* = p  s.bi_veindgu faseapif t le(* bit lnd.lu0;      , n
   buf |= ureac =aext;engvalid nxt;ength;re))/(* +nctioen*/);
}


/* =e uf |=l < ++  tils<r0;    tils&&= ureac ===aext;eng.status = e currenrrap val      l <   tils<r0in   til.status = FIv_Bhe s/ ureac Len tre Len*//+=
/* esrrap val      l <  ureac       putalid vegth  ureac     t leali  bns_v_Bhe s/ ureac Len tre Len*/
 v,
      }s_v_Bhe s/ = 16;
/Len tre Len*/
 vrap val      l <   tils<  10.status = FIv_Bhe s/ = 17;
/* Len tre Len*/
 vrap val      tatus = FIv_Bhe s/ = 17;
/* reLen tre Len*/
 vrp valrap va utils  0ealid , lealit(B ureac,rees._=== nxt;ength     putShoror0;    tils  138valid d 0in   tils  3  ap val      l <  ureac ===aext;eng.status = 0;    tils  6valid d 0in   tils  3  ap val      tatus = 0;    tils  7valid d 0in   tils  4 /* use th}t=======================================================================
 * Send a value on a  . Sincehicee. (ActuallynitDcrtput.
morphimaightforondi // shinxa*bv_Bhe s..
*deflateSetDt c, he sf);
desc)  {

engtdbyte(s,(s, flusl;

  *s_byte(s,c* ty - ** the espondire)) voiredeca imor tryte(s,    0;      ,  dy dyer cplii* l  with non zehenequency */
  this.i de = deflaea biwrite gzgest g  g ind. Sintosf trapl  */

 To use dirtat_d vart lealit(Bd BUest g  g indtah nt
  tor each co===_d var ureac,  dynzgest g  g indthe bi ;f  k */
  0,0,0,0,
 deflaext;ength;re))/00,en*/);
}


/* =t indthe bi ;f oee ab    ,0,
 defla utils  0e dynaast_flusespt) */

/* esthength  k */
  0,0,0,0,_d var0;    tils  7  /* largeind    t) */

/* est,0,_d var0in   tils  4  /* largeind  */

 */

/* est,0,_va/stre))/m;      +1].Llit(Bd BU    indgu fasty other inl*tLength ext;ength     putShor0;    tils  138valid 0in   tils  3   b}
if t le(* bit lnd.lu0;      , n
   buf |= ureac =aext;engvalid nxt;ength;re))/(* +nctioen*/);
}


/* =e uf |=l < ++  tils<r0;    tils&&= ureac ===aext;eng.status = e currenrrap val      l <   tils<r0in   til.status = /* Uoh c, tree) {
 ureac, FIv_Bhe s)riten >= 0) {  tils      rrap val      l <  ureac       puttus = gth  ureac     t leali  b
/* largeh c, tree) {
 ureac, FIv_Bhe s)r
/* large  til--e n;th,,
      }rm->avail  tils =t3s&&=  tils<  f, " 6;
?"strstart = c, tree) {
 = 16;
, FIv_Bhe s)r
/* lar, tree[c * 2]  tils- 3,tatic
o(val      l <   tils<  10.status = F c, tree) {
 = 17;
/*, FIv_Bhe s)r
/* lar, tree[c * 2]  tils- 3,t3)vrap val      tatus = F c, tree) {
 = 17;
/* r, FIv_Bhe s)r
/* lar, tree[c * 2]  tils- 11, 7)vrp valrap va utils  0ealid , lealit(B ureac,rs = gth nxt;ength     putShoror0;    tils  138valid d 0in   tils  3  ap val      l <  ureac ===aext;eng.status = 0;    tils  6valid d 0in   tils  3  ap val      tatus = 0;    tils  7valid d 0in   tils  4 /* use th}t=======================================================================
 * Send a valuC  Howeve /

 Huffmaeq

funes */

  are imposed,bute 


fu/

 
gra_bitxa*bv_Bcreasing
6 values code */
  [0,0,0rc s onion deflateSetD nicaBv_Bhe salet = defla0;  bl
gra_; dictiora_bhenlues code */
  [0,0,0henequency */
  t,0,_va/stD ts grnesougu are imposeecan be keptt le . Since calde. (Actuallyirtat_dtca Bhe sf);
= dyn_lhe s;
= l_it le0;      ing_buca Bhe sf);
= dyn_dhe s;
= d_it le0;      ing_va/stBnical
th codes are send_if (s.s nicaBhe sf);
FIv_Bhis.d;tva/st;       nils * ENDrs s co6 and vhength _bit.als being to alteBL_Bp  highl hf the bit length codes are sach bit on s co5+5+4ach code oondi /u difrt t,0,_va/stD ts grnesouguits.
 * IN ases are sent inrc s onit of pkziptt l p( highl/ 2. Ala very atkleah n4N ases are sent inreder o. (appnote.te asayded to 3s not ae arivia in lennsferis 4 if com/if t le(0;  bl
gra_s     = 19;
ll_w 0;  bl
gra_s =t3w 0;  bl
gra_--  buf |= === 6(_Bhe s/v_Bcreas[0;  bl
gra_].Len*/);
}


/* =       puttus =       /* use th}tva/stU/
    ;       rc he ENDrlen  codes are send_eanev  u dirtat_dBU;         }3e*/(0;  bl
gra_s+nctinu5cnu5cnu4 /* avTracev((srderr, "\ndynuallyi:ee * %ld) {
   %ld", the/        s->;      [str NISHvar    (bstate 


fu0;  bl
gra_;t=======================================================================
 * Send a value on gth hiseasismall ithis ghtfore */
  tHuffmaeq

fus:oondi /u di,peed.
*lthe bit length codes are sent i256 val. Since theoaon s code */
  [he s..
*on: length <= 16ent in =ta57, dent in =tu, neent in =t4..
*deflateSetDt c, l  Bhe s * 2]lcnt i25dcnt i25neent idbyte(s,(s, flusl;

  *s_byte(s,    lcnt i25dcnt i25neent i; cododes at each bitg length allyn de = deflaranka biwrite gzgest    }r*_xtra_bitsv_Bcreasiow if `s->avail_eent in =ta57/&& tent in =tu/&& neent in =t4, "MAX_Bin penent i(strm.av->avail_eent in<    = 19;
&& tent in<  D = 19;
&& beent in<  B;
/* ma, the/        "/oodmdistent i(strm.avTracev((srderr, "\nbli /u di: ")avail, tree[c * 2]lcnt in-ta57, 5be codoAX_+ L_Cd mut new in appnote.te atat_dB tree[c * 2]dcnt in-t1,ges5avail, tree[c * 2]blcnt in-t4,  4be codoAX_-3Cd mut new in appnote.te atat_dt le(rank bit lrank <5neent i; rank
   buf |=avTracev((srderr, "\nbli /   %2i_") v_Bcreas[rank])while (, tree[c * 2] 6(_Bhe s/v_Bcreas[rank].Len*/);
}


/* =,t3)vrert(strmTracev((srderr, "\nbliend_ifer of%ld", s->  ts_er o (bstatt c, he sf);
= dyn_lhe s;
lcnt in-tmbe code. Since theom/if rmTracev((srderr, "\nliheend_ifer of%ld", s->  ts_er o (bstatt c, he sf);
= dyn_dhe s;
dcnt in-tmbe codee. (Actuallyn de* avTracev((srderr, "\nd1)  end_ifer of%ld", s->  ts_er o (bs=======================================================================
 * Send a valuCgs wh/type fieldar MINis       le      aightforondiestrictionalgorithm:valu-      ienondirwolcic tto al// !!!!zero Takefied:va*lid  )t ofre to butnequ-bpacspacingntrol s.gzarierl// !!ngbottowing .
*lid e  "blacode st"oATar
, 14ar L,ta8..31)ertio =  )t ofre is atkleah n catpr   spacin.gzarier// !!ngbottowing .
*lid e  "n >ler  st"oA9 {TAB}, 10 {LF}, 13 {CR}, 32ar L_).valu-        /
   wise.valu- Tndiestrictionpserbial -bpacspacingntrol s.gzarierl/t l  a.
*lid"g of   st"overy n ergns, 0o */
tn ep tsteSetDalgorithm:valuf rep{BEL}, 8p{BS}, 11 {VT}, 12 {FF}, 26 {SUB}, 2ep{ESC})ertion: there is enougugh sey  Len ng
 yn_lhe s zero in..
*deflateSetDp tste_ield (thoalet = d/*bv___(3maskcislen bcodemaskcteral__(-  st atsytnded to  inlch coTar
, 14ar L,t neede..31ed to 0xf3ffc07f p exateSe11110011111111111100000001111111f com/if  var
e__(3maskc= 0xf3ffc07f 
_d var tr
the tCgs wht leequ-txt;via ("al__(-  st a")tsytnd_om/if t le(* bit lnd. }31, n
 ,r
e__(3maskcff;     buf |= ===(
e__(3maskc&    && (= dyn_lhe s/n.Len tre Len*//       puttus = e 


fu         /* use th}t
the tCgs wht letxt;via ("n >le-  st a")tsytnd_om/if  === 6dyn_lhe s/9.Len tre Len*//      || = dyn_lhe s//* Len tre Len*//      ||atus = FIdyn_lhe s//3.Len tre Len*//      putShore 


fu      vrert(stt le(* bi32 lnd.eL + LENG mn
   buf |=l < = dyn_lhe s/n.Len tre Len*//      puttus = e 


fu      vreruse th}t
the t ofre to butn"al__(-  st a"  le"n >le-  st a"tsytnd: highl h the  ass ei
   moom mpty  le dumtolSintod ("g of-  st a")tsytndm */
this.depste 


fu         /tic_l_desc;
vartate_t cath;false =====================================================================
 * Reverse the the comprlen bre)) teldaFreq = i*shsmall n cozlib IN assertideflateSetD;
  returle
i_if  ===!INIT/* tate_t ca)Tuttus lock(;
/* tate)ehile (,NIT/* tate_t cath;reenr=ap = 0;  l_it lay(D_CODTtic_tree= dyn_lhe s;
=c;
var statiing_bufd_it lay(D_CODTtic_tree= dyn_dhe s;
=c;
vardstatiing_bufb statis  AX_MTtic_tree= (_Bhe s,esc;
varb statitic
o(+=lue >> (B0vali+= length;
(s.wr
the t the comprlen b, all ithis length , all fil_if (s.state_ 0, fale=========================================================================
 * Send a value on a k(s, 0ontinurtideflateSetD;
  k(s, 0, 0, falseing -k(s, 0,   [slues*
//Dctionar;

  *s_byts.gzff* >>l dyn  }r*_xt;
  ithis *atytulg-k(s, 0,   bit len */
  [henc(;
  ithis *atyt    la

,  dyngzge/_fen  ienonn ers
6 values cthis small fil_n de = d, tree[c * 2](K = 0;
var ST<<  tinu(lues ?tu/:cti,t3)vgzge/_fioon */

var MIN_MA Dcrp , 0, falseing -k(s, 0,   [sreenbe cod expkhiseasi*/========================================================================
 * Send a value on en   mpty  */
}

*/

varoi * s_Bin penlookahise smalin======es 286 thtakas 10  exte,hen must 7 maate mabunc(   */in bi_buf ertideflateSetD;
  c    alet = d, tree[c * 2]S = 1;
var DY<<  ,t3)vrer  c, tree) {
 = 256;
/ale);
/* The stat D leest.
(s.=========================================================================
 * Send a valuD ts grnesougu  sndow Arn lees */

  k */
  this.:ee */
  this.sale);
/*
ghl the, ur k(s, ,t neesrt LSBs co w Ared
*/

varois cozipttil_ertideflateSetD;
  est.
, 0, falseing -k(s, 0,   [slues*
//Dctionar;

  *s_byts.gzff* >>l dyn  }r*_xt;
  ithis,
  this.eienooodold *atytulg-k(s, 0,   bit len */
  [henc(;
  ithis *atyt    la

,  dyngzge/_fen  ienonn ers
6 values cthis small fil_n de = dsh, s      b,esc;
var   b;va/st;        neesc;
var    bntsytndm,0,_d var0;  bl
gra_s  0e dynaastictiora_bhenlues code */
  [0,0,0henequency */
  t,0,_va/stBnical
th Huffmaeq

fus unless a k(s, 0ontinuers
t lcedom/if  === 6levele    put
aastictCgs wh/type ffil_nis exateSe letxt;a (s.strail_t.IN m.ield (tho ===aZ_UNKNOWN.status = FINI m.ield (tho =Dp tste_ield (thoalevrp valrap vae tC  Howeve /

  . Since calde. (Actuallyirtat_d.s nicaBhe sf);
FI statiing_b se/ Tracev((srderr, "\nliheield:ee * %ld) {
   %ld", s->;      [g_b se/        tr NISHvar    (bstat.s nicaBhe sf);
FIdstatiing_b se/ Tracev((srderr, "\nd1)  ield:ee * %ld) {
   %ld", s->;      [g_b se/        tr NISHvar    (bsp vae tAot an epoflr,n;        neesc;
var    are/
  thft
   are impos 15 bi  ighl hf crtput.
morithis ty -teBL_ludtforondire)) als being to al.bi  igh/rap vae tBnical
th codes are send_ees */

       rwolhis.sal neegetl/

 
gra_bi  ighlitsv_Bcreasing
6 values code */
  [0,0,0rc s onion is.depst r0;  bl
gra_s   nicaBv_Bhe sale;t
thmber D ts grnesougu  sndow Arn l.eCr-32 fol soithis  impos 1bntsytnd..depst rs      b (B( >;         3   7)   pu3hile (,NIT/*    b (B( >NISHvar      3   7)   pu3hig_b se/ Tracev((srderr, "\n;   %lu(%lu) {
   %lu(%lu) {
s, 0o%lu  .  %u_")ad[s.avpendit rs      b, s->;      [stNIT/*    b[str NISHvar    -k(s, 0,   [g_b se/        tr = -1;lih.)e uf |=l < ,NIT/*    b . }s      b  bns      b (Bsc;
var   b;v}rap s.levelbuf |=av ->avail >> !  ( .gz*)0, "l* o  >>"strstars      b (Bsc;
var   b (Bscs, 0,   cnu5nt/ t/ lce a k(s, 0ontinuetat_dn
if  ===(scs, 0,   cnu4 . }s      b  && ( >> ! (Bd   puttus / t4: rwolwcrecode oondi impos 1h/rap vae tTndite o  >> !  his.eiom */

near sngt  ==L +_BUF2 * e  W2 * .bi  ighlO
   wise webca 'ffput aproct.
morms, ngtaeqW2 * nc(;
  iytndmodes bi  ighl hf lues cthis sst.
seiecaftwacrtput.
SetDll winput abeated t to  ucct.
ful. I==L +_BUF2 * e. }W2 * ,ws.

//fetrapooode  folobi  ighl ranst l  aontinuerninit k(s, 0ontinuion is.depst r;
  k(s, 0, 0, falseing -k(s, 0,   [slues*wrap s.level === 6wardtegy ===aZ_FIXED || =c;
var   b (= }s      b  b
ile (, tree[c * 2](S = 1;
var DY<<  tinu(lues ?tu/:cti,t3)vile (crtput.
, 0, false, extral_bits,, extrad_bit*wrap s.level{ile (, tree[c * 2](DYN
var DY<<  tinu(lues ?tu/:cti,t3)vile (t c, l  Bhe s * 2]= l_it le0;      TH_Cal= d_it le0;      TH_Cal0;  bl
gra_s+nctvile (crtput.
, 0, false, dyn_lhe s;
= dyn_dhe s)vrert(strm ->avail_tr crtput.
mo alit(= s->  ts_er o, "bad crtput.
mor_val"be
t codT

       ngs wh/sl0;  Tmod 2^32,ode ofil_ l  witral hni512 MB highl callLos piwe d proen en 32function f (s.state_ 0, fale==if  ===lues* UPDATEeve  }
upale rert(strm Tracev((srderr,"\ncrtpualit%lu(%lu) ", s->crtput.
mo ali>>3, the/       s->crtput.
mo ali-7*lues*)wr}=====================================================================
 * Reverse theSut aen bmp(0 =in=ooaon sial sougugcan be yi /u dif R 


fu/eendufxa*byte
 k */
  this.einly marsst.
ltern deflateSetD;
  sial * 2]d;
}bll.dbyte(s,(s, flusl;

  *s_byte(s,uns   or n.

,  /ri 1) */


funh (0 ed     ifmax_yte(s,uns   or l corrrespmp(0 == MIN_- 1);
zero(it leh (0 ed s.gz (if ];
}==0)max_ = d//sh, sut* First,wsn* First,wd    ;t
thva[s.pending++]  /* if+l> = -1;liheLen      =7)];
}


/*8 s.pending_buf[s.pending++]  /* if+l> = -1;liheLen*/);
 (Bn.

e.pendingg_buf[s.pending++] l/* if+l> = -1;lih] (B*cs.pending_buf= -1;lih
 vrap gth >=s        s.last_len scislen bleh (0 ed s.gz   zero(+=dyn_lhe s/lc Len tre Len*/
 vrp   s.bi_buf |= (h (0 e 
 vrp va/itHill blscislen bmp(0 == MIN_M + 1);
zero(ins_h =>=s --eaaaaaaaaaaaaa/ri 1)  =r0;(0 = 1) */


- 1(ins_h =rm->avail(ush)? _dist(ush)ts *DISTaletus !== e/       (ush)lsc. } 8));
ts *
zero- 1);
zeroetus !== e/       (ush)) {
  return st(ush)D
/* ma,  ";
  sial : bad 0;(0 "   if (s+=dyn_lhe s/(e  = new Arr[ c] nu1 + LENGTH_C)eLen tre Len*/
 vrp va= dyn_dhe s/) {
  return Len tre Len*/
 vrp  === c(!)286 thntinuers
etuspac0o */zlib (s,aul}s,e`stdo 'ffenspaciillsmalexateSecrtpextbilihy=== 
  if (TRUNCATE256;
/_yte(codTeSeroi uess ifws.

//proficspacirc stopbyte
 k */
  this.eofre ax_yte( ===(s = -1;lihe.pen1fff)       &&  6levele  2  buyte(s,/heCr-32 fohniupper//ts.dode oondi /tput.
moreach co===yte(s,sut* First.=as_= -1;lih*8_byte(s,  * First.=as_   inserid);
 his._inser_bytbyte(s,t le(d          d     <Eero(basw d    
   bue/      sut* First.+=a= dyn_dhe s/)    *n tre Len*//* (5cnu =   /d ext[d    ]),ue/    }=yte(s,sut* First.ff;  3,ue/    avTracev((srderr,"\n= -1;lihe%u,wsn %ld) ress~%ld(%ld%%)_")ae/    av       tr = -1;lih,wsn* First,wsut* First,ae/    av       100Lid)sut* First*100L/sn* First)),ue/     === 6h (0 e  <d > = -1;lih>>1)/*    /2 = && sut* First.<d sn* First>>1)/*    /2 =  bue/      r 


fu/een,ue/    }=yte(}=yt* Flusstate 


fu(s = -1;lihe    s =te_ uf_vali-umbe
t codWeitializro. Tihyy expklte_ uf_valiiecaftwahen raparts.do   64K highletD16bcodemachrneit on iecaftwak(s, 0ontinu  to brek(rictfer t highl64K-1tsytnd.on f (s ==exbpacs.;
  retu  =7;
  retu;=exbpacs.;
  k(s, 0, 0, f =7;
  k(s, 0, 0, f;=exbpacs.;
  est.
, 0, f  =7;
  est.
, 0, f;=exbpacs.;
  sial s=D;
  sial ;=exbpacs.;
  c    n=D;
  c    ;=====* = }),====156o===y=* = (flateSet(modults, ebpacs, __webp__(3/ 2. Al__  b
i"ftwak(rict";==== c(C) 1995-2013 Jean-loup Gaial s on Mark Adler== c(C) 2014-2017 Vicsl sPuzri   neeAndrey Tupextinbytbyte86 thsoftware is pros', wi'as-is',  expressdist ebut.
(it iwe iedbytewpDicnty. Inlnofthe t  e  */

  uxprrl// eofsevanypedipose,
y damagesbytearibabi*/
omlen bl_fllengt thsoftware.bytbytePs gr.
SetD thgicntfer th,
yen   software thsoftware pose,
y purpose,== com_ludtfor /tmerOCK cape ic to alteaon sth,lier/itd,bute n.

var uciil== cgcaelth kubjis. rois coestrictionrek(rictis sebytbyte1it of originllengt thsoftwareeinly  misre gr.als being t; youeinly  miue/   claimovery youewro fol sofriginK csoftware. I==youeftware thsoftwareue/   i    productteao __(nowac0ge tr flol soproducttdocuming to aDll winbeue/   aperLOCKt atsut *seMAX_/ 2. Ald.byt 2. Aliered  oulce irsto al/inly marplai*/

markedCd muuchteaon inly  misreue/   gr.als being tCd mriginal sofriginK csoftware.ue/ 3e256n e miice maat misre altered mall iered /
oml,
y  oulce n.

var util.

modult. ebpacsn=Dbuf 2:      'e L_Cdictis teS',aaaaa/riZ_NEED*DICT       2 f (s.s1:      'e  ass end',gest g  g /riZ_SvarAM_END      1 f (s.s0:      '',gest g  g gest g  g /riZ_OK  g gest g  g 0 f (s.s'-1':   'fil_nerror',gest g  g /riZ_ERRNOest g  g (-1)f (s.s'-2':   'e  ass error',gest g  /riZ_SvarAM_ERRORg (-2)f (s.s'-3':   'teldaerror',gest g  g /riZ_DATA_ERRORg g (-3)f (s.s'-4':   'insuffici tr mlteeS',a/riZ_MEM_ERRORg g  (-4)f (s.s'-5':   'i_buf derror',gest g  /riZ_BUF_ERRORg g  (-5)f (s.s'-6':   'incrtpextble irsto a' /riZ_VERSION_ERRORg(-6)f (s};=====* = }),====157o===y=* = (flateSet(modults, ebpacs, __webp__(3/ 2. Al__  b
i"ftwak(rict";==== c(C) 1995-2013 Jean-loup Gaial s on Mark Adler== c(C) 2014-2017 Vicsl sPuzri   neeAndrey Tupextinbytbyte86 thsoftware is pros', wi'as-is',  expressdist ebut.
(it iwe iedbytewpDicnty. Inlnofthe t  e  */

  uxprrl// eofsevanypedipose,
y damagesbytearibabi*/
omlen bl_fllengt thsoftware.bytbytePs gr.
SetD thgicntfer th,
yen   software thsoftware pose,
y purpose,== com_ludtfor /tmerOCK cape ic to alteaon sth,lier/itd,bute n.

var uciil== cgcaelth kubjis. rois coestrictionrek(rictis sebytbyte1it of originllengt thsoftwareeinly  misre gr.als being t; youeinly  miue/   claimovery youewro fol sofriginK csoftware. I==youeftware thsoftwareue/   i    productteao __(nowac0ge tr flol soproducttdocuming to aDll winbeue/   aperLOCKt atsut *seMAX_/ 2. Ald.byt 2. Aliered  oulce irsto al/inly marplai*/

markedCd muuchteaon inly  misreue/   gr.als being tCd mriginal sofriginK csoftware.ue/ 3e256n e miice maat misre altered mall iered /
oml,
y  oulce n.

var util.

sh, Set(test g  g = __webp__(3/ 2. Al__(34be
sh, adler32t g  g = __webp__(3/ 2. Al__(89be
sh, crc32t g  g g = __webp__(3/ 2. Al__(90be
sh, in=====_fues  = __webp__(3/ 2. Al__(158be
sh, in=====_cspaci= __webp__(3/ 2. Al__(159be

sh, = 19;
(s.wrsh, LENS// h_ash, DISTS// 2 =====Pub ic ========s==============================================================y==================================================================
 * Reverseh/ra=y==Atriced /st.
 espond; s)) th=====() cpliio=====() / !!!!posedetat(te===ytsh, Z_NO_FLUSH  g g = 0;=ytsh, Z_PARTIAL_FLUSH / h_aytsh, Z_SYNC_FLUSH  g / 2 =ytsh, Z_FULL_FLUSH  g / 3_ash, Z_FINISH  g g  s  4 /sh, Z_var ST  g g  s  5 /sh, Z_var DY  g g  s  6;===== R 


fuch bitg leondi /tput.
til/decrtput.
SetDflateSets. Neg tov responded* to berrorltepositov respond to bu
morphiz_BLOCK csut n l plfthe ttion sesh, Z_OK  g gest g  (s.wrsh, Z_SvarAM_END    / h_ash, Z_NEED*DICT     / 2 =ytsh, Z_ERRNOest g  g (Bd Brsh, Z_SvarAM_ERRORg (Bd2Brsh, Z_DATA_ERRORg g (Bd3_ash, Z_MEM_ERRORg g  (Bd4 /sh, Z_vUF_ERRORg g  (Bd5 =ytsh, Z_VERSION_ERRORg(Bd6 ===== of th=====acrtput.
SetDmexprdn sesh, Z_DEFLATED  (B8;===== S = 9;
(========================================================
 * Reverseh/ry==================================================================
 * Reverseh/ra=sh,    HEAD / h_est g  /rii:ewpitn lees *magic hiseasi*/=sh,    FLAGS// 2 st g  /rii:ewpitn lees *mexprdncpli===gs (gzip)i*/=sh,    TIME / 3_est g  /rii:ewpitn lees *modific to a time (gzip)i*/=sh,    OSs  4  /* largeindi:ewpitn lees *ror ea===gs  neespSintn lesystem (gzip)i*/=sh,    EXLENs  5  largeindi:ewpitn lees *ror ea First.(gzip)i*/=sh,    EXTRAs  6; largeindi:ewpitn lees *ror eaiytndm(gzip)i*/=sh,    NAME / 7_est g  /rii:ewpitn lees * on efffil_nname (gzip)i*/=sh,    COMMENT (B8; g  /rii:ewpitn lees * on eff /tmetr (gzip)i*/=sh,    HCRC p 9vest g  /rii:ewpitn lees *hiseasicrc (gzip)i*/=sh,    DICTID / h0; g  /rii:ewpitn lees *dictis teS ngs whin lentatsh,    DICT / h1; largeindwpitn lees *io=====SetDictis teS()bca  *tatsh,        TYPE / 12 st g  /rii:ewpitn lees *(tho  exte,om_ludtfor= -1-===gbcodetatsh,        TYPEDOs  13; g  /rii:esamebly wiskip ngs whroiexioduo=====letDr continuetatsh,        K = 0;s  14; g  /rii:ewpitn lees *k(s, 0o_vali_engATCHanev  we d pro)etatsh,        COPY_s  15,  dynind//o:esameCd mCOPY / !!!bly wi */

/ all sime inetatsh,        COPYs  16; largeindi/o:ewpitn lees *io LSBnresrt LSBsoDcrp  k(s, 0ontinuetatsh,        TABLE / 17,  dynind/:ewpitn lees *d */
  t*/

varspaci impos 1h/rsh,        LENLENS// h8;dynind/:ewpitn lees *      */
  [0,0,0 impos 1h/rsh,        = 19LENS// h9;ynind/:ewpitn lees * impos/litd,butde */
  [0,0,0 impos 1h/rsh,            LEN_s  20 st g  /rii:esameCd mLENs/ !!!bly wi */

/ all sime inetatsh,            LENs  2h_est g  /rii:ewpitn lees * impos/lit/eob 0,0,0,0,sh,            LEN      22; g  /rii:ewpitn lees * */
  [ror each cotatsh,            DIST   23 st g  /rii:ewpitn lees *de */
  [0,0,0,0,sh,            DIST      24;dynind/:ewpitn lees *de */
  [ror each cotatsh,            
zero(=ta5,  dynindo:ewpitn lees *srt LSBsp__eBsoDcrp  k(  ifmax_sh,            LI    26_est g  /rio:ewpitn lees *srt LSBsp__eBsoDrailer . Since*/=sh,    CHE ST   7,  dynind/:ewpitn lees *32- are gs whin lentatsh,    S  = 2T   8; g  /rii:ewpitn lees *32- are First.(gzip)i*/=sh,    DONE / 29 st g  /rifinishor  gs w, t cat--te mabunofre unet(nrekedetatsh,    BAD / 30_est g  /rigotl tteldaerrort--te mabunofre unet(nrekedetatsh,    MEM  }31, st g  /rigotl niio=====() mlteeSaerrort--te mabunofre unet(nrekedetatsh,    SYNC bi32 lt g  /rilookn lees *kynchroniz to a iytndmvoirek(seriio=====() h/ray==================================================================
 * Reverseh/ra=tsh, ENOUGH_LENS// 852Brsh, ENOUGH_DISTS// 592 =ytsh, ENOUGH//  (ENOUGH_LENS+ENOUGH_DISTSbe

sh, ts *W/

vs  15,ay==32K LZ77 t repletatsh, DEF*W/

vs  ts *W/

v;===flateSetDzswap32(q s.lase 


fu (((q


/*24 s.pendi) +
          ((q


/*8 s.pendi00) +
          ((q
.pendi00)  var) +
          ((q
.pendi)  va24 .======flateSetDIntionar;

 ( s.lasre t.m                     y== k */
  uo=====lm,0,0,0,_dre t.lues h;false           y==reenduf/proct.
tfor= -1ontinuetat_dre t. rap                  d/*bvare0=reendes *zlib,bvare1=reendes *gzipetat_dre t.put dict h;false       y==reenduf/dictis teS pros', witat_dre t.===gs                  y==gzipewiateSeiexprdncpli===gs (0duf/zlib)itat_dre t.d    =e               d/*bzlib wiateSei   de */
  [(INFLATE_SvaICT)itat_dre t. gs wh                 y==pro fctfercrp  eff gs whin lentat_dre t.hft
                   y==pro fctfercrp  effsrt LSB/* est,0,_dyte8ODO: maatbe {}t_dre t.pise =_turn,  dyn largeindwofre rc sut agzipewiateSein=ol p(i plax_
t codslidtfort repletat_dre t.  /* log2(h            y==log=);
/ 2 eff/ 2.sh ltrt reple_valitat_dre t. _valiog2(h            y==t reple_valis *zcy *ailnAX_nstfort repletat_dre t. put aog2(h            y==ngth;
iytndmflol sot repletat_dre t. oee aog2(h            y==t replerailer
gra_stat_dre t.  reple=_turn,  dyn lar/o bufocKt atslidtfort repl,aailneedmor treese tvareaccumu===oretat_dre t.pold =e               d/*bc(;
  iareaccumu===oretat_dre t. /* log2(h             cododes at ea /* lflo"in"r treese tes *k(  ifm neescs, 0ontinuecrp  ifmax_lere t.lFirst.=a2(h           /en . Sincehic */
  [henieldaroDcrp  ax_lere t.offkede=a2(h           /ende */
  [ua whroicrp  k(  ifm/
oml treese tes *rspacianev     decrd ifmax_lere t. or ea=+2(h            y==ror each coneedmor treese tfixedncplid */
  t0,0,0rspacsmax_lere t.lFi       nurn,  dyn largcodsnserbotttypedipose impos/litSince // show  Dre t.de *       nurn,  dyn larcodsnserbotttypediposede */
  [0,0,smax_lere t.lFi /* log2(h          ictiora_bch code olFi     ow  Dre t.de * /* log2(h         ictiora_bch code ode *      treese te */
  thypedi nica ifmax_lere t.nc                     y==odes at each b  */
  [0,0,0 impos 1h/rlere t.nllit(B0vh             cododes at ea */
  [0,0,0 impos 1h/rlere t.n 1)  =r               y==odes at eade */
  [0,0,0 impos 1h/r_dre t.put t(B0vh             cododes at ea0,0,0 impos 1its.ens[]1h/rlere t.nee aogturn,  dyn large   codoee aavailypedisp__eBifuch bi[]1h/r_lere t.lFiss  AX_MSet(tmBuf16(320be codtemporteS scs,ageees *      */
   1h/r_dre t.works  AX_MSet(tmBuf16(288be cod orksareaees *     hypedi nica ifmax_eese 
   iecaftwawetdo 'ffput apoflres 1itsjs, webu_fl */     zbutde *     dirfctly
   d mr_buf thsoawetdo 'ffe L_C // s
tt,0,_dytre t. ,0,sm  AX_MSet(tmBuf32(ENOUGHt max numnitip__eBes *     hypedsmax_lere t.lFie * ogturn,  dyn large   code */
  thypedipose impos/litSince // sh(JSz_BLOCfic) ow  Dre t.de *e * ogturn,  dyn large  code */
  thypediposede */
  [0,0,sm(JSz_BLOCfic) ow  Dre t.san t(B0vh                  ictif;false, bufols *ngth;
de. (Actuaoo;faretat_dre t. a wh                       ictch co a whhenlues unproct.
mor impos/litdh/r_dre t.wa log2(h                   ictigaps

p */
  [hen0;(0 = (s ==flateSetDuo=====RekedKeep(NI met = deflal;

 vrap gth !NI m || !NI m>NISHa)Tute 


fu  SvarAM_ERRORv,
   l;

  = shem>NISHang_buhem>hft
 _in = shem>hft
 _ress(Bsc;
e.hft
      g_buhem>msg   ''e coZ_his.m/if  === c;
e. rap)Tut      ictrc supbpac ill-coActired Javaite o sui*/.ins_h =uhem>adlers(Bsc;
e. rap &     b}
+= c;
e.m      HEAD;
+= c;
e.lues h;0;
+= c;
e.put dict h;0;
+= c;
e.d    =e32768;
+= c;
e.pise =_turncoZ_his.m/;
+= c;
e.pold =e  
+= c;
e. /* log2(,_dyt c;
e.lFi        c;
e.de *        c;
e.nee aog c;
e.ent i;
+= c;
e.lFi        c;
e.lFie * ogtX_MSet(tmBuf32(ENOUGH_LENS);
+= c;
e.de *        c;
e.de *e * ogtX_MSet(tmBuf32(ENOUGH_DISTSbe

+= c;
e.san t(B1 
+= c;
e. a wh  -1trm.avTracev((srderr, "uo=====:nreked\n")availe 


fu  OK;s ==flateSetDuo=====Reked(NI met = deflal;

 vrap gth !NI m || !NI m>NISHa)Tute 


fu  SvarAM_ERRORv,
   l;

  = shem>NISHang_buh;
e. _valiog2(g_buh;
e. put t(B0vg_buh;
e. oee aog2(aile 


fuuo=====RekedKeep(NI mevra ==flateSetDuo=====Reked2(NI m,rt replB/* et = defla rap;= deflal;

 vrap y==getl/

 l;

  */ap gth !NI m || !NI m>NISHa)Tute 


fu  SvarAM_ERRORv,
   l;

  = shem>NISHang
  y==ror ect  rap / 2.sh m/
omlt replB/* npseam ts  */ap gth t replB/* n<   s.last_ rap     last_  replB/* n  -  replB/*    b}
+=s.bi_buf |= rap    t replB/* n>> 4) +     bregth t replB/* n< 48.status = t replB/* n&  15,as = e th}t
the tkedeodes at ea  reple exte,gcaea  repleuf/dibuf ent */ap gth t replB/* n&& (t replB/* n< 8 || t replB/* n> 15) putShore 


fu  SvarAM_ERRORv  b}
+= === c;
e.  reple! (Bturn &&  c;
e.  /* l! (Bt replB/* et = d_buh;
e.  reple=_turn, th}t
the tthe ne l;

  ,bute setl/

 restllen/* */ap sc;
e. rap =a rap;= d c;
e.  /* l(Bt replB/* (aile 


fuuo=====Reked(NI mevr ==flateSetDuo===== the2(NI m,rt replB/* et = deflae 
;= deflal;

 vrap gth !NI m)Tute 


fu  SvarAM_ERRORv,
   yt cem>msg   Z_his.(h                ictig catwawete 


fuanaerrortax_eesl;

  = tX_MIntionar;

 ( ng
  y/ === c;
e ===aZ_his.)te 


fu  MEM_ERRORtrm.avTracev((srderr, "uo=====:nbufocKt a\n")availshem>NISHa    c;
e;= d c;
e.  reple=_turncoZ_his.m/;
+=rede=auo=====Reked2(NI m,rt replB/* e;ap gth rede!==aZ_OKet = d_buhem>NISHa   turncoZ_his.m/;
+=}aile 


fue 
;= ==flateSetDuo===== the(NI met = de 


fuuo===== the2(NI m,rDEF*W/

v.========
 R 


fuNISHa  expklegATCHanevde. (Actudecrd ifmhypedsmcpliiora_b_valso inlow
tfixedn     decrd if.  N l pll souisde 


fstfixednhypedsm/
omluo=fixed.h.
 I==BUILDFIXED n ep finng256 vfuuostise ouisderesrnes nicaslen bhypedsmng .
/ all sime it'sbca  ng25,bute 


fsmngos bhypedsmng 
/ all sime ,bu
 ough afts .  Tuisde ducdsmng 
_valisength  // tsynabress2K
iytnd,bitxaexchangeees *a  . tl_nexecuto a time.  Howetra,=BUILDFIXED  h  app misreubu
morphizth othedncpe ic to alteodes l/

 rerail ifmhength _ypedsmcplivirgitxamaat misre th oth-safeion sesh, virgit h;reenr=esh, legfix2]d;
}fix;dyteWefput anoapoflres 1itsJS,hsoa retngypedsmsepseate==flateSetDfixedgypeds(NISHa)Tueese tvnicalfixednhuffmaeq
ypedsmif;f all ca  *(maat misre th oth safe) */ap gth virgitet = d_beflalym;ke surlegfix ogtX_MSet(tmBuf32(512tvile (d;
}fix ogtX_MSet(tmBuf32(3atic
o(va/en . Sinc/s are seypediins_h =uym     last_  >= 0) ym < 144  bnsc;
e.lFis[ ym++] (B8; }last_  >= 0) ym < 256  bnsc;
e.lFis[ ym++] (B9; }last_  >= 0) ym < 280  bnsc;
e.lFis[ ym++] (B7; }last_  >= 0) ym < 288  bnsc;
e.lFis[ ym++] (B8; }l  bregn=====_cspac(LENS,+= c;
e.lFilte0,ta88, legfix2] e0,t c;
e. ork, bn /* : 9 }tic
o(va/ende. (Actuaypediins_h =uym     last_  >= 0) ym < 32  bnsc;
e.lFis[ ym++] (B5; }l  bregn=====_cspac(DISTS,= c;
e.lFilte0,t32,o (d;
}fix,e0,t c;
e. ork, bn /* : 5 }tic
o(va/endo ouisdjuh n ccdiins_h =virgit h;false =ap = 0; c;
e.lFi       legfix;
+= c;
e.lFi /* l(B9;
+= c;
e.de *       d;
}fix;
+= c;
e.de * /* l(B5========
 U/
    its t replerexpk hf lues  _vali(n l pll s32K)tsytndmrailtvfubephieube 


f if.  Iea  reple port effBL;
} yin,  protm it.  Tuisdiom */

ca  ng
dwof      repleussty otherit use, hizwof  srt LSBhd mrif  railtvfudurginal bu.
uo=====lca  ,s not ae  on efftof th=====ae  ass hd m misreefue a0 ed yin..
Iteusstysoaca  nghroicprotml o  replees *dictis teS ieldawof    dictis teS
eusslothed.= 0Pros', ifmhrt LSBr_buf th  witral hni32K rc he=====()  h  apppros', it kpeng
dadvantageteodes l */

 hf lues 32K effsrt LSBisachpinghroing 
_lidtfort replubuponde 


fu/
omluo=====()25,butodes la  *de. (Actsstfts mng 
/ all 32K ef
fsrt LSB e  *fa  *flol sosrt LSBty -temakn le0;(0 =chpindmodwe drncpli=uesf ertT

  dvantage maatbe de[s.pent onmng 
_valisength proct.
or'sbieldaca0 esern deflateSetDthe net repl(NI m,rsrc,  on,icrp et = deflan.

,= deflal;

  = shem>NISHang
  y==ifws.
hd  'ffreefut catty othe,nbufocKt tip__eBes *l sot repletat_d === c;
e.  reple= (Bturnet = d_buh;
e. _valiog1  va c;
e.  /* ;= d_buh;
e. oee aog2(ail_buh;
e. put t(B0vg= d_buh;
e.  reple=_tX_MSet(tmBuf8(uh;
e. _val), th}t
the tcrp  k(;
e->w_valis *less hrt LSBrytndmflroing 
circulfla  repletat_d ===crp  >=buh;
e. _valet = d_bSet(tmpDicySed(NI;
e.  repl,rsrc,  onid);h;
e. _val,);h;
e. _val,)tionary uh;
e. oee aog2(ail_buh;
e. put t(B;h;
e. _val   b}
+=s.bi_buf |= 1)  =ruh;
e. _vali- uh;
e. oee    bregth ];
}

icrp et = df |= 1)  =rcrp ,as = e thm.avzmemcpy(k(;
e->w reple+ k(;
e->woee ,  onid)crp 2]d;
}ionary Set(tmpDicySed(NI;
e.  repl,rsrc,  onid)crp 2]d;
}, uh;
e. oee tvile (crp  -=an.

,= d_d ===crp et = df |=avzmemcpy(k(;
e->w repl,  onid)crp 2]crp e;= df |=Set(tmpDicySed(NI;
e.  repl,rsrc,  onid)crp 2]crp 2]0e;= df |=uh;
e. oee aogcrp ,as = _buh;
e. put t(B;h;
e. _val   b= e thm.     tatus = Fh;
e. oee a+=an.

,= d_d_d === c;
e. oee ao==buh;
e. _valet  uh;
e. oee aog2(,
      } === c;
e. put t<buh;
e. _valet  uh;
e. put t+=an.

,,
     e th}tvae 


fu0;= ==flateSetDuo=====(NI m,r/st.
et = deflal;

 vr deflac(;
 , hrt LS(h         i/ac(;
 /hrt LSBr_buf t
 deflaext;                    ictoexr fl LSBINDEXm,0,_d var LS(h                   ictoexr hrt LSBINDEXm,0,_d varput , left,  dyn large  codavailypedifl LSB neesrt LSB,0,_d varpold                    ictch Br_buf B,0,_d var /* ;                   ictch  1bntsh Br_buf B,0,_d var_in, _res,  dyn large   codsut asnserbottavailypedifl LSB neesrt LSB,0,_d varcrp ,                   ictodes at eascs, 0os *ma(0 =iytndmvoicrp  ax_le var/
om,                   ictwofre rc crp  ma(0 =iytndm/
oml trle var/
om_ oulcevr deflaofre og2(h              y== k */
  decrd ifmhyped  otr  ax_le varofre_ exte,ofre_ope,ofre_val;dytepakedC"ofre" den l plvaldm(JSz_BLOCfic)
 d//sh, la

,  dyngzge          y==pse/
  hyped  otr  ax_le var= -1; exte,= -1;ope,= -1;val;dytepakedC"= -1" den l plvaldm(JSz_BLOCfic)
 dsh, leg(h                   icts are sec crp  es *

 */
s,tch  1voidrop ax_le vare 
;h                   ictr 


fuch b ax_le varo >> (BtX_MSet(tmBuf8(4)vgzge/_fr_buf Bes *gzipehiseasicrc ca culf(i plax_ dsh, s  s;,
 deflae;dytetemporteS  var/  thEED*/

v,
 deflacreasi= y==permug to aD ea0,0,0 impos 1ins_h =[ 1
, 17, 18,e0,t8,e7, 9, f, /*, 5, 11, 4, 12, 3,t13,ta, 14,_Cal15 ]va ap gth !NI m || !NI m>NISHa || !NI m>srt LSB||atus =  !NI m.fl LSB&&  cem>avail_in        puttus e 


fu  SvarAM_ERRORv  b}
   l;

  = shem>NISHang } === c;
e.m        TYPEet  uh;
e.m      TYPEDOrite   codskip ngs whh/ra= d//--- LOAD() ---= dpess(Bscem>oexr_res,
 esrt LSB(Bscem>hrt LS(
  leftB(Bscem>avail_res,
 enee aog cem>oexr_ic,rs fl LSBog cem>fl LS,rs put t(B;hem>avail_in,rs pold =e c;
e.poldat D l* l(B c;
e. /* ;= d//---a= d_in = put ;= d_ress(Bleft,
+=rede=a  OK;srs flf_leut :dytegoroiemulf(i p
s,t le(;;et = d_burex0 == c;
e.m   .status = eatwaHEAD:
         === c;
e. rapth     putShoror d_buh;
e.m      TYPEDOrtShoror d_b      /* usssss}/* usssss//h   hEED/

v(16)r
/* large  >= 0)b/* n< 16 putShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
         ==== c;
e. rapt& 2  && pold =    x8b1f)Tut y==gzipewiateSe*/tShoror d_buh;
e. gs wh   /*crc32(0L,aZ_his.2]0em/;
+=* usssss//h   CRC2(uh;
e. gs w, pold)e n;th,,sss png++0] (Bpold .pending_bth,,sss png++;
 (B(pold 

/*8 s.pending_boror d_buh;
e. gs wh  crc32(uh;
e. gs w, ping -22]0e;= df |=ssss//h  //

+=* usssss//h   INIT/

v()e n;th,,sss pold og2(ail_bor d_b /* nog2(ail_bor d_b//h  //
        _buh;
e.m      FLAGSrtShoror d_b      /* usssss}/* usssssuh;
e.===gs                y==ropis. zlib wiateSe*/
         === c;
e.wiat putShoror d_buh;
e.wiat.t cath;false =* usssss}/* usssssgth != c;
e. rapt& 1) ||   y== gs wh/tyzlib wiateSeatriced */tShoror d_b(((pold .pendi)/*/

v(8em/  var) +B(pold 

ar)) % 31 putShoror d_buhem>msg   'incrrrfctehiseasicgs w'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss ====pold .pen0i)/*/

v(4)*//    Z_DEFLATED putShoror d_buhem>msg   'un(nowtDcrtput.
SetDmexprd'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss//--- DROP/

v(4) ---//
        pold 

/  4 /* us d_b /* n-  4 /* us d_b//---//
        llit(B=pold .pen0i)/*/

v(4)*//+B8;=* usssss === c;
e.  /* no     putShoror d_buh;
e.  /* l(Blac,rs = ssss}/* ussssslevel ===llit>buh;
e.  /*  putShoror d_buhem>msg   'inngth;
t reple_val'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss c;
e.d    =e1  valac,rs = ssssavTracev((srderr, "uo=====:n yzlib wiateSeok\n")availor d_buhem>adlers(Bsc;
e. gs wh  1/*adler32(0L,aZ_his.2]0em/;
+=* usssuh;
e.m      pold .pen200 ? DICTID : TYPE,rs = ssssavh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
              /* ussseatwaFLAGS:rs = ssssavh   hEED/

v(16)r */tShoror d  >= 0)b/* n< 16 putShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
        uh;
e.===gs   poldat Dor d_b ===(uh;
e.===gs .pendi)     Z_DEFLATED putShoror d_buhem>msg   'un(nowtDcrtput.
SetDmexprd'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss === c;
e.===gs .pene00  putShoror d_buhem>msg   'un(nowtDhiseasis==gs set'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss === c;
e.wiat putShoror d_buh;
e.wiat.tee aog((pold 

ar)t& 1) /* usssss}/* usssss === c;
e.===gs .pen020  putShoror d_b//h   CRC2(uh;
e. gs w, pold)e n;th,,sss png++0] (Bpold .pending_bth,,sss png++;
 (B(pold 

/*8 s.pending_boror d_buh;
e. gs wh  crc32(uh;
e. gs w, ping -22]0e;= df |=ssss//h  //
* usssss}/* usssssavh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
        uh;
e.m      TIME,rs = ssssa**fa  smngrn pen*/tShororeatwaTIME:rs = ssssavh   hEED/

v(3ati */tShoror d  >= 0)b/* n< 32  btShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
         === c;
e.wiat putShoror d_buh;
e.wiat.time   poldat Dor d_b}/* usssss === c;
e.===gs .pen020  putShoror d_b//h   CRC4(uh;
e. gs w, pold) n;th,,sss png++0] (Bpold .pending_bth,,sss png++;
 (B(pold 

/*8 s.pending_boror d_bpng++2
 (B(pold 

/*16 p.pending_boror d_bpng++3
 (B(pold 

/*24 s.pending_boror d_buh;
e. gs wh  crc32(uh;
e. gs w, ping -42]0e;= df |=ssss//h  
* usssss}/* usssssavh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
        uh;
e.m      OS,rs = ssssa**fa  smngrn pen*/tShororeatwaOS:rs = ssssavh   hEED/

v(16)r */tShoror d  >= 0)b/* n< 16 putShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
         === c;
e.wiat putShoror d_buh;
e.wiat.x===gs   (pold .pendi)ng_boror d_buh;
e.wiat.os (B(pold 

 8) /* usssss}/* usssss === c;
e.===gs .pen020  putShoror d_b//h   CRC2(uh;
e. gs w, pold)e n;th,,sss png++0] (Bpold .pending_bth,,sss png++;
 (B(pold 

/*8 s.pending_boror d_buh;
e. gs wh  crc32(uh;
e. gs w, ping -22]0e;= df |=ssss//h  //
* usssss}/* usssssavh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
        uh;
e.m      EXLEN,rs = ssssa**fa  smngrn pen*/tShororeatwaEXLEN:
         === c;
e.===gs .pen040  putShoror d_b//h   hEED/

v(16)r */tShoror d d  >= 0)b/* n< 16 putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _buh;
e.lFirst.=apoldat Dor d_b   === c;
e.wiat putShoror d_b_buh;
e.wiat. =   /llit(Bpoldat Dor d_b  }t Dor d_b   === c;
e.===gs .pen020  putShoror d_b_b//h   CRC2(uh;
e. gs w, pold)e n;th,,sss s png++0] (Bpold .pending_bth,,sss s png++;
 (B(pold 

/*8 s.pending_boror d_b_buh;
e. gs wh  crc32(uh;
e. gs w, ping -22]0e;= df |=sssss //h  //
        _b}/* ussssss //h   INIT/

v()e n;th,,sss pold og2(ail_bor d_b /* nog2(ail_bor d_b//h  //
        }/* ussssslevel === c;
e.wiat putShoror d_buh;
e.wiat. or ea=+turncoZ_his.m/;
+=      }/* usssssuh;
e.m      EXTRA,rs = ssssa**fa  smngrn pen*/tShororeatwaEXTRA:
         === c;
e.===gs .pen040  putShoror d_bcrp  =buh;
e.lFirstat Dor d_b   ===crp  > put  pubcrp  =bhut ;s}/* ussssss  ===crp et = df |=       === c;
e.wiat putShoror d_b_b  llit(Buh;
e.wiat. =   /llit-buh;
e.lFirstat Dor d_b       ===!uh;
e.wiat. =    putShoror d_b_b    i/aUse uneypedncDicyees *morcingnveni tr proct.
tfor= tertShoror d_b_b    uh;
e.wiat. or ea=+tew ADicy(uh;
e.wiat. =   /lli)at Dor d_b      }t Dor d_b      Set(tmpDicySed(tShoror d_b_b    uh;
e.wiat. or e,tShoror d_b_b    c(;
 ,tShoror d_b_b    oee ,tShoror d_b_b    i/aror ea=h seeusslimitfer th65536tsytnded tror d_b_b    i/a-butneemorphizad tto aK csvali gs wed tror d_b_b    crp 2ed tror d_b_b    i*   cnucrp  > uh;
e.wiat. =   /    - llit? uh;
e.wiat. =   /    : crp 2*/tShoror d dddddddlated t tttttttttt)at Dor d_b      avzmemcpy(k(;
e.wiat. or ea+    [soee ,tShoror d_b_b  e/           cnucrp  > uh;
e.wiat. =   /    ?tShoror d_b_b  e/        uh;
e.wiat. =   /    - llit:]crp e;= df |=======}= df |=       === c;
e.===gs .pen020  putShoror d_b_b_buh;
e. gs wh  crc32(uh;
e. gs w, c(;
 , crp 2]oee tvile (|=======}= df |=      put t-ogcrp ,as = _bbbbbbboee a+=acrp ,as = _bbbbbbbuh;
e.lFirst.-ogcrp ,as = _bbbbb}t Dor d_b   === c;
e. First)pub      flf_leut ;s}/* usssss}/* usssssuh;
e.lFirst.=a2(/* usssssuh;
e.m      NAME,rs = ssssa**fa  smngrn pen*/tShororeatwaNAME:
         === c;
e.===gs .pen080  putShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss crp  =b2(ail_bor d_bdoputShoror d_b_b//e8ODO: 2os *1tsytnd?tShoror d_b_bllit(Bfl LS[oexrcnucrp ++];= df |=sssss /* ftwacr======slimit iecaftwaitsjsawet h  app misp   ufocKt tmlteeSa*/tShoror d ddd === c;
e.wiat && llitus !==             = c;
e. Firstn< 65536t/*uh;
e.wiat.name/   */) putShoror d_b_b_buh;
e.wiat.namea+=aS(  if./
omCharC
  rlli)at Dor d_b    }/* ussssss }d  >= 0)llitus crp  < put  ;
t Dor d_b   === c;
e.===gs .pen020  putShoror d_b_buh;
e. gs wh  crc32(uh;
e. gs w, c(;
 , crp 2]oee tvile (|=====}/* ussssss put .-ogcrp ,as = _bbbbboee a+=acrp ,as = _bbbbb ===lli)pub      flf_leut ;s}/* usssss}/* ussssslevel === c;
e.wiat putShoror d_buh;
e.wiat.namea=_turn, thusssss}/* usssssuh;
e.lFirst.=a2(/* usssssuh;
e.m      COMMENT,rs = ssssa**fa  smngrn pen*/tShororeatwaCOMMENT:
         === c;
e.===gs .pen100  putShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss crp  =b2(ail_bor d_bdoputShoror d_b_bllit(Bfl LS[oexrcnucrp ++];= df |=sssss /* ftwacr======slimit iecaftwaitsjsawet h  app misp   ufocKt tmlteeSa*/tShoror d ddd === c;
e.wiat && llitus !==             = c;
e. Firstn< 65536t/*uh;
e.wiat. /tm/   */) putShoror d_b_b_buh;
e.wiat. /tmetr +=aS(  if./
omCharC
  rlli)at Dor d_b    }/* ussssss }d  >= 0)llitus crp  < put  ;
oror d ddd === c;
e.===gs .pen020  putShoror d_b_buh;
e. gs wh  crc32(uh;
e. gs w, c(;
 , crp 2]oee tvile (|=====}/* ussssss put .-ogcrp ,as = _bbbbboee a+=acrp ,as = _bbbbb ===lli)pub      flf_leut ;s}/* usssss}/* ussssslevel === c;
e.wiat putShoror d_buh;
e.wiat. /tmetr =_turn, thusssss}/* usssssuh;
e.m      HCRC,rs = ssssa**fa  smngrn pen*/tShororeatwaHCRC:
         === c;
e.===gs .pen020  putShoror d_b//h   hEED/

v(16)r */tShoror d d  >= 0)b/* n< 16 putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _b ===pold     (uh;
e. gs ws.pendiff) putShoror d_b_buhem>msg   'hiseasicrc misma(0 ';tShoror d_b_buh;
e.m      BAD;
+=oror d_b_b      /* usssss_b}/* ussssss //h   INIT/

v()e n;th,,sss pold og2(ail_bor d_b /* nog2(ail_bor d_b//h  //
        }/* usssss === c;
e.wiat putShoror d_buh;
e.wiat.hcrc ===(uh;
e.===gs 
/*9)t& 1) /* usssss_buh;
e.wiat.t cath;reenr=        }/* usssssuhem>adlers(Bsc;
e. gs wh  2(/* usssssuh;
e.m      TYPE,rs = ssss      /* ussseatwaDICTID:rs = ssssavh   hEED/

v(3ati */tShoror d  >= 0)b/* n< 32  btShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
        uhem>adlers(Bsc;
e. gs wh  zswap32(pold)e n;th,,ssavh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
        uh;
e.m      DICT,rs = ssssa**fa  smngrn pen*/tShororeatwaDICT:
         === c;
e.put dict h     putShoror d_b//--- REK = 0() ---= d        uhem>oexr_res    LS,rs         uhem>avail_ress(Bleft,
+=        uhem>oexr_i* ogtXxS,rs         uhem>avail_in = put ;= d        uh;
e.pold ogpoldat Dor d_b   c;
e. /*  og /* ;= d_bor d_b//---a d_bor d_be 


fu  NEED*DICTr=        }/* usssssuhem>adlers(Bsc;
e. gs wh  1/*adler32(0L,aZ_his.2]0em/;
+=* usssuh;
e.m      TYPE,rs = ssssa**fa  smngrn pen*/tShororeatwaTYPE:
         ===/st.
 ===aZ_var ST|| /st.
 ===aZ_var D pub      flf_leut ;s}/* usssssa**fa  smngrn pen*/tShororeatwaTYPEDO:
         === c;
e.lues* UPDATEor d_b//--- BYTE/

v() ---//
          pold 

/   /*  & 7;= d_bor d_b /* n-   /*  & 7;= d_bor d_b//---//
        ssuh;
e.m      CHE S;= d_bor d_b      /* usssss}/* usssss//h   hEED/

v(3ti */tShoror d  >= 0)b/* n< 3  btShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
        uh;
e.luest(B=pold .pen01)/*/

v(1em/;
+=* usss//--- DROP/

v(1) ---//
        pold 

/  1(ail_bor d /* n-  1(ail_bor d//---//

        urex0 ===pold .pen03)/*/

v(2) =  bu d_bor d_beatwa0:                             codsns, 0ontinuetat_d          cvTracev((srderr, "uo=====:n y dsns, 0ontinu%s\n",t_d          cv        uh;
e.luest? "==lues*" : "")availor d_b    uh;
e.m      K = 0;;
+=oror d_b_b      /* usssss_beatwa1:                             codfixednntinuetat_d          fixedgypeds(NISHa);= df |=sssss //Tracev((srderr, "uo=====:n y dfixedn    sontinu%s\n",t_d          cv        uh;
e.luest? "==lues*" : "")availor d_b    uh;
e.m      LEN_,  dyn large  codee0,0,00,0,smax_leeeeeeeeeee ===/st.
 ===aZ_var D putShoror d_b_b_b//--- DROP/

v(2) ---//
              pold 

/  2at Dor d_b       /* n-  2at Dor d_b      //---//
        ss          flf_leut ;t Dor d_b    }/* ussssss _b      /* usssss_beatwa2:                             codd */
  t*/

vatat_d          cvTracev((srderr, "uo=====:n y dd */
  t0,0,sontinu%s\n",t_d          cv        uh;
e.luest? "==lues*" : "")availor d_b    uh;
e.m      TABLE;
+=oror d_b_b      /* usssss_beatwa3:ailor d_b    uhem>msg   'inngth;
*/

varype';tShoror d_b_buh;
e.m      BAD;
+=oror d}/* usssss//--- DROP/

v(2) ---//
        pold 

/  2at Dor d_b /* n-  2at Dor d_b//---//
              /* ussseatwaK = 0;:/* usssss//--- BYTE/

v() ---// /rigor thsytn//ts.daeSa*/tShoror dpold 

/   /*  & 7;= d_bor d /* n-   /*  & 7;= d_bor d//---//
        avh   hEED/

v(3ati */tShoror d  >= 0)b/* n< 32  btShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
         ====pold .pendiff)     ((pold 

/*16 p^pendiff) putShoror d_buhem>msg   'inngth;
sns, 0ontinue impos 'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss c;
e.lFirst.=apold .pendiff;= d_bor d//Tracev((srderr, "uo=====:n y d dsns, 0olFirst.%u\n",t_d      cv        uh;
e.lFirst)),u        avh   INIT/

v()e n;th,,sspold og2(ail_bor d /* nog2(ail_bor d//h  //
        uh;
e.m      COPY_;
         ===/st.
 ===aZ_var D pub      flf_leut ;s}/* usssssa**fa  smngrn pen*/tShororeatwaCOPY_:
        uh;
e.m      COPY,rs = ssssa**fa  smngrn pen*/tShororeatwaCOPY:
        crp  =buh;
e.lFirstat Dor d_b ===crp et = df |=     ===crp  > put  pubcrp  =bhut ;s}/* ussssss  ===crp  > left pubcrp  =bleft, }/* ussssss  ===crp  (     pub      flf_leut ;s}/* ussssss //--- zmemcpy(;
 , oee , crp e; ---= d        Set(tmpDicySed(hrt LS, c(;
 , oee , crp ,  LSe;= df |=ssss//---//
          put .-ogcrp ,as = _bbbbboee a+=acrp ,as = _bbbbbleftB-ogcrp ,as = _bbbbb LSB+=acrp ,as = _bbbbbuh;
e.lFirst.-ogcrp ,as = _bbbbb      /* usssss}/* usssss//Tracev((srderr, "uo=====:n y d dsns, 0oend\n")availor d_buh;
e.m      TYPE,rs = ssss      /* ussseatwaTABLE:rs = ssssavh   hEED/

v(14)r */tShoror d  >= 0)b/* n< 14  btShoror d_b ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssss}/* usssss//h  //
        uh;
e.nllit(B=pold .pen1i)/*/

v(5)*//+B257;= d_bor d//--- DROP/

v(5) ---//
        pold 

/  5;= d_bor d /* n-  5;= d_bor d//---//
        uh;
e.n 1)  =r=pold .pen1i)/*/

v(5)*//+B1(ail_bor d//--- DROP/

v(5) ---//
        pold 

/  5;= d_bor d /* n-  5;= d_bor d//---//
        uh;
e.n       =pold .pen0i)/*/

v(4)*//+B4 /* us d_b//--- DROP/

v(4) ---//
        pold 

/  4 /* us d_b /* n-  4 /* us d_b//---//
= 
  nif (PKZIP_BUG_WORKAROUND
         === c;
e.nllit>b286T|| uh;
e.n 1)  > 3  putShoror d_buhem>msg   'aoo;m,
y  */
  [hsede */
  [symbol 'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/yt* Fluss* us d_b//Tracev((srderr, "uo=====:n y d dhyped _valsook\n")availor d_buh;
e.put h  2(/* usssssuh;
e.m      LENLENS,rs = ssssa**fa  smngrn pen*/tShororeatwaLENLENS:tShoror d  >= 0)uh;
e.put h< uh;
e.n     putShoror d_b//h   hEED/

v(3e;= df |=ssss  >= 0)b/* n< 3  btShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _buh;
e.lFis[creas[uh;
e.put ++]]   =pold .pen07);///

v(3e;= df |=ssss//--- DROP/

v(3) ---//
          pold 

/  3;= d_bor d_b /* n-  3;= df |=ssss//---//
        }/* usssss  >= 0)uh;
e.put h< 19 putShoror d_buh;
e.lFis[creas[uh;
e.put ++]]   0;=* usssss}/* usssss//eWefput asepseateq
ypedsm&anoapoflres . 2f /tmetr 0olrneit/ !!!! misneedmo./* usssss//uh;
e.nee aog c;
e.ent i;
+=usssss//uh;
e.lFi        c;
e.tXxS,rs       //eSrex0 = softwae */
  thyped/* usssss c;
e.lFi        c;
e.lFie *(/* usssssuh;
e.lFi /* l(B7;
t Dor d_bs  sl(Bbn /* : uh;
e.lFi /* l}(/* usssssrede=auo=====_cspac(= 19;,= c;
e.lFilte0,t19,s c;
e.lFi    ,e0,t c;
e. ork, s  savailor d_buh;
e.lFi /* l(Bs  s. /* ;=
         ===red putShoror d_buhem>msg   'inngth;
0,0,0 impos 1set'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss//Tracev((srderr, "uo=====:n y d d0,0,0 impos 1ok\n")availor d_buh;
e.put h  2(/* usssssuh;
e.m      = 19LENS,rs = ssssa**fa  smngrn pen*/tShororeatwaCO19LENS:tShoror d  >= 0)uh;
e.put h< uh;
e.n   cnuuh;
e.n 1)  putShoror d_bt le(;;et = d_bbbbbbbbbofre og c;
e.lFi    [pold .p((1  va c;
e.lFi /* ) - 1)];/*/

v( c;
e.lFi /* )tat_d          ofre_ ext =bhfre 

/*24;t_d          ofre_op    hfre 

/*16 p.pending_boror d_b ,ofre_val =bhfre .pendiff;=tShoror d_b_b ===(ofre_ ext) <   /*  pub     ;s}/* ussssss s //--- PULLBYTE() ---//
          _b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss sss//---//
          }/* ussssss  ===ofre_val < 16 putShoror d_b_b//--- DROP/

v(ofre. /* ) ---//
          _bpold 

/  ofre_ ext;= d_bor d_b_b /* n-  ofre_ ext;= d_bor d_b_b//---//
        ss  uh;
e.lFis[uh;
e.put ++] =bhfre;val;
          }/* ussssss      tatus = sssss  ===ofre_val (   16 putShoror d_b_b_b//h   hEED/

v(ofre. /* /+B2)at Dor d_b      n   ofre_ ext/+B2at Dor d_b        >= 0)b/* n< n putShoror d_b_b_b_b ===put t(     pub      flf_leut ;s}/* ussssss s   _bput --e n;th,,sss s   _bpold += fl LS[oexr++]  va /* ;= d_bor d_b_bbbbb /* n+(B8;=* usssss sss  }t Dor d_b      //h  //
        _b    //--- DROP/

v(ofre. /* ) ---//
          _b_bpold 

/  ofre_ ext;= d_bor d_b_b_b /* n-  ofre_ ext;= d_bor d_b_b  //---//
        ss     === c;
e.put  h     putShoror d_bbbbbbbuhem>msg   'inngth;
*are First.

 */
';= d_bor d_b_bbbbbuh;
e.m      BAD;
+=oror d_b_b_b_b      /* usssss_bss  }t Dor d_b      llit(Buh;
e.lFis[uh;
e.put  - 1] /* usssss_bss  crp  =b3 +B(pold .pen03);///

v(2)at Dor d_b      //--- DROP/

v(2) ---//
              pold 

/  2at Dor d_b       /* n-  2at Dor d_b      //---//
        ss  }t Dor d_b    level ===ofre_val (   17 putShoror d_b_b_b//h   hEED/

v(ofre. /* /+B3)at Dor d_b      n   ofre_ ext/+B3at Dor d_b        >= 0)b/* n< n putShoror d_b_b_b_b ===put t(     pub      flf_leut ;s}/* ussssss s   _bput --e n;th,,sss s   _bpold += fl LS[oexr++]  va /* ;= d_bor d_b_bbbbb /* n+(B8;=* usssss sss  }t Dor d_b      //h  //
        _b    //--- DROP/

v(ofre. /* ) ---//
          _b_bpold 

/  ofre_ ext;= d_bor d_b_b_b /* n-  ofre_ ext;= d_bor d_b_b  //---//
        ss    llit(B0v/* usssss_bss  crp  =b3 +B(pold .pen07);///

v(3e;= df |=ssss    //--- DROP/

v(3) ---//
          _b_bpold 

/  3at Dor d_b       /* n-  3;= df |=ssss_b  //---//
        ss  }t Dor d_b    levelutShoror d_b_b_b//h   hEED/

v(ofre. /* /+B7)at Dor d_b      n   ofre_ ext/+B7at Dor d_b        >= 0)b/* n< n putShoror d_b_b_b_b ===put t(     pub      flf_leut ;s}/* ussssss s   _bput --e n;th,,sss s   _bpold += fl LS[oexr++]  va /* ;= d_bor d_b_bbbbb /* n+(B8;=* usssss sss  }t Dor d_b      //h  //
        _b    //--- DROP/

v(ofre. /* ) ---//
          _b_bpold 

/  ofre_ ext;= d_bor d_b_b_b /* n-  ofre_ ext;= d_bor d_b_b  //---//
        ss    llit(B0v/* usssss_bss  crp  =b11 +B(pold .pen7f);///

v(7)at Dor d_b      //--- DROP/

v(7) ---//
          _b_bpold 

/  7at Dor d_b       /* n-  7at Dor d_b      //---//
        ss  }t Dor d_b     === c;
e.put  nucrp  > uh;
e.n   cnuuh;
e.n 1)  putShoror d_bbbbbuhem>msg   'inngth;
*are First.

 */
';= d_bor d_b_bbbuh;
e.m      BAD;
+=oror d_b_b_b      /* usssss_bss}t Dor d_b      >= 0)crp -- putShoror d_b_b_buh;
e.lFis[uh;
e.put ++] =blac,rs = ssss_bss}t Dor d_b  }/* usssss}/rs = ssssa**handed  rrort      1bnt  >= 0*/
         === c;
e.m        BAD pub     ;s}/rs = ssssa** gs whes * on-of-ntinuecrd 0)betts mput  one) */ap        === c;
e.lFis[256]no     putShoror d_buhem>msg   'inngth;
0,0,0-- mi.
tfor on-of-ntinu'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/rs = ssssa**vnical     hypedsm--but==:ndo! mischangee hf lFi /* lhsede * /* rs = ssss_bsin lesbhfre (9B nee6 prexpress othginal ef /tmetr 1bntflftrees.hrs = ssss_bscoAct
f ifal efENOUGH/cr======s, which de[s.p onmngos bin lesb*/
        uh;
e.lFi /* l(B9;
t Dor d_bs  sl(Bbn /* : uh;
e.lFi /* l}(/* usssssrede=auo=====_cspac(LENS,+ c;
e.lFilte0,tuh;
e.n   ,s c;
e.lFi    ,e0,t c;
e. ork, s  savailor d_b//eWefput asepseateq
ypedsm&anoapoflres . 2f /tmetr 0olrneit/ !!!! misneedmo./* usssss//  c;
e.tXxS_iora_b(Bs  s.
yped_iora_vailor d_buh;
e.lFi /* l(Bs  s. /* ;=* usssss//  c;
e.lFi        c;
e.tXxS,r
         ===red putShoror d_buhem>msg   'inngth;
 . Sinc/s are  1set'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/ailor d_buh;
e.de * /* l(B6;
+=usssss//uh;
e.de *    .crp (uh;
e. nt iavailor d_b//eSrex0 = softwae */
  thyped/* usssss c;
e.de *        c;
e.de *e *;t Dor d_bs  sl(Bbn /* : uh;
e.de * /* l}(/* usssssrede=auo=====_cspac(DISTS,= c;
e.lFilteuh;
e.n   ,s c;
e.nd;
}, uh;
e.de *    ,e0,t c;
e. ork, s  savailor d_b//eWefput asepseateq
ypedsm&anoapoflres . 2f /tmetr 0olrneit/ !!!! misneedmo./* usssss//  c;
e.tXxS_iora_b(Bs  s.
yped_iora_vailor d_buh;
e.de * /* l(Bs  s. /* ;=* usssss//  c;
e.de *        c;
e.nee ,r
         ===red putShoror d_buhem>msg   'inngth;
de. (Actssset'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss//Tracev((srderr, 'uo=====:n y d d0,0, 1ok\n')availor d_buh;
e.m      LEN_,
         ===/st.
 ===aZ_var D pub      flf_leut ;s}/* usssssa**fa  smngrn pen*/tShororeatwaLEN_:
        uh;
e.m      LEN,rs = ssssa**fa  smngrn pen*/tShororeatwaLEN:
         ===put a/  6 && llfta/  258 putShoror d_b//--- REK = 0() ---= d        uhem>oexr_res    LS,rs         uhem>avail_ress(Bleft,
+=        uhem>oexr_i* ogtXxS,rs         uhem>avail_in = put ;= d        uh;
e.pold ogpoldat Dor d_b   c;
e. /*  og /* ;= d_bor d_b//---a d_bor d_buo=====_=ues(NI m,r_rese;= df |=ssss//--- LOAD() ---= dddddddddpess(Bscem>oexr_res,
 eeeeeeeeesrt LSB(Bscem>hrt LS(
          leftB(Bscem>avail_res,
 eeeeeeeeenee aog cem>oexr_ic,rs _bor d_buo LSBog cem>fl LS,rs         put t(B;hem>avail_in,rs         pold =e c;
e.poldat DDDDDDDDD l* l(B c;
e. /* ;= d_bor d_b//---ars _bor d_bu=== c;
e.m        TYPEet rs = ssss_bss c;
e. a wh  -1trm.........}t Dor d_b        /* usssss}/* usssss c;
e. a wh    /* ussssst le(;;et = d_bbbbbbbofre og c;
e.lFi    [pold .p((1  va c;
e.lFi /* ) - 1)];ssa*/

v( c;
e.lFi /* )tat_d        ofre_ ext =bhfre 

/*24;t_d        ofre_op    hfre 

/*16 p.pending_boror d_bofre_val =bhfre .pendiff;=tShoror d_b ===ofre_b/* n<   /*  pub     ;s}/* ussssss //--- PULLBYTE() ---//
           ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssssss//---//
        }/* usssss ===ofre_op && (ofre_op &pend  po     putShoror d_b= -1; ext   ofre_ ext;= d_bor d_b= -1;op   ofre_op;= d_bor d_b= -1;val =bhfre;val;
          t le(;;et = d_bbbbbbbbbofre og c;
e.lFi    [= -1;val += d_bor d_b_bbbbbbbbb==pold .p((1  va(= -1; ext +b= -1;op)) - 1))/*/

v(= -1. ext +b= -1.op)*/ 
/*= -1; ext)] /* usssss_bssofre_ ext =bhfre 

/*24;t_d          ofre_op    hfre 

/*16 p.pending_boror d_b ,ofre_val =bhfre .pendiff;=tShoror d_b_b ===(= -1; ext +bofre_ ext) <   /*  pub     ;s}/* ussssss s //--- PULLBYTE() ---//
          _b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss sss//---//
          }/* ussssss //--- DROP/

v(= -1. ext) ---//
          pold 

/  = -1; ext;= d_bor d_b /* n-  = -1; ext;= d_bor d_b//---//
        ssuh;
e. a wh+  = -1; ext;= d_bor d}/* usssss//--- DROP/

v(ofre. /* ) ---//
        pold 

/  ofre_ ext;= d_bor d /* n-  ofre_ ext;= d_bor d//---//
        uh;
e. a wh+  ofre_ ext;= d_bor d c;
e.lFirst.=apfre;val;
         ===ofre_op h     putShoror d_b//Tracevv((srderr, ofre.val >=pen20 && pfre.val <pen7f ?tShoror d_bcv        "uo=====:n y d d n . Since'%c'\n" :tShoror d_bcv        "uo=====:n y d d n . Since0x%02x\n", pfre.val)) /* usssss_buh;
e.m      LIT;= d_bor d_b      /* usssss}/* usssss ===ofre_op &p32  btShoror d_b//Tracevv((srderr, "uo=====:n y d d n on effntinu\n")availor d_bss c;
e. a wh  -1trm.........uh;
e.m      TYPE,rs = ssss_b      /* usssss}/* usssss ===ofre_op &p64 putShoror d_buhem>msg   'inngth;
 . Sinc/s are d0,0,'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss c;
e. or ea=+ofre_op &p15;= d_bor d c;
e.m      LENEXT,rs = ssssa**fa  smngrn pen*/tShororeatwaLENEXT:
         === c;
e. =    putShoror d_b//h   hEED/

v( c;
e. =    ,
 eeeeeeeeen og c;
e. =   ,
 eeeeeeeee  >= 0)b/* n< n putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _buh;
e.lFirst.+=apold .p((1  va c;
e. =    p- 1)a*/

v( c;
e. =    m/;
+=* usssss//--- DROP/

v( c;
e. =    p---//
          pold 

/   c;
e. =   ,
 eeeeeeeee /* n-   c;
e. =   ,
 eeeeeeeee//---//
        ssuh;
e. a wh+   c;
e. =   ,
 eeeeeee}/* usssss//Tracevv((srderr, "uo=====:n y d d nlFirst.%u\n", uh;
e.lFirst)),u         c;
e. as =buh;
e.lFirstat Dor d_b c;
e.m      DIST,rs = ssssa**fa  smngrn pen*/tShororeatwaDIST:
        t le(;;et = d_bbbbbbbofre og c;
e.de *    [pold .p((1  va c;
e.de * /* ) - 1)];/*/

v( c;
e.de * /* )tat_d        ofre_ ext =bhfre 

/*24;t_d        ofre_op    hfre 

/*16 p.pending_boror d_bofre_val =bhfre .pendiff;=tShoror d_b ===(ofre_ ext) <   /*  pub     ;s}/* ussssss //--- PULLBYTE() ---//
           ===put t(     pub      flf_leut ;s}/* ussssss put --e n;th,,sss pold += fl LS[oexr++]  va /* ;= d_bor d_b /* n+(B8;=* usssssss//---//
        }/* usssss ===(ofre_op &pend  po     putShoror d_b= -1; ext   ofre_ ext;= d_bor d_b= -1;op   ofre_op;= d_bor d_b= -1;val =bhfre;val;
          t le(;;et = d_bbbbbbbbbofre og c;
e.de *    [= -1;val += d_bor d_b_bbbbbbbbb==pold .p((1  va(= -1; ext +b= -1;op)) - 1))/*/

v(= -1. ext +b= -1.op)*/ 
/*= -1; ext)] /* usssss_bssofre_ ext =bhfre 

/*24;t_d          ofre_op    hfre 

/*16 p.pending_boror d_b ,ofre_val =bhfre .pendiff;=tShoror d_b_b ===(= -1; ext +bofre_ ext) <   /*  pub     ;s}/* ussssss s //--- PULLBYTE() ---//
          _b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss sss//---//
          }/* ussssss //--- DROP/

v(= -1. ext) ---//
          pold 

/  = -1; ext;= d_bor d_b /* n-  = -1; ext;= d_bor d_b//---//
        ssuh;
e. a wh+  = -1; ext;= d_bor d}/* usssss//--- DROP/

v(ofre. /* ) ---//
        pold 

/  ofre_ ext;= d_bor d /* n-  ofre_ ext;= d_bor d//---//
        uh;
e. a wh+  ofre_ ext;= d_bor d ===ofre_op &p64 putShoror d_buhem>msg   'inngth;
de */
  [0,0,'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/* usssss c;
e.offsede=ahfre;val;
         c;
e. or ea=+=ofre_op) &p15;= d_bor d c;
e.m      DISTEXT,rs = ssssa**fa  smngrn pen*/tShororeatwaDISTEXT:
         === c;
e. =    putShoror d_b//h   hEED/

v( c;
e. =    ,
 eeeeeeeeen og c;
e. =   ,
 eeeeeeeee  >= 0)b/* n< n putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _buh;
e.offsede+=apold .p((1  va c;
e. =    p- 1)a*/

v( c;
e. =    m/;
+=* usssss//--- DROP/

v( c;
e. =    p---//
          pold 

/   c;
e. =   ,
 eeeeeeeee /* n-   c;
e. =   ,
 eeeeeeeee//---//
        ssuh;
e. a wh+   c;
e. =   ,
 eeeeeee}/= 
  if (INFLATE SvaICT
         === c;
e.offsede> uh;
e.d    putShoror d_buhem>msg   'inngth;
de */
  [aoo;fvar anu'ng_boror d_buh;
e.m      BAD;
+=oror d_b      /* usssss}/yt* Fluss* us d_b//Tracevv((srderr, "uo=====:n y d d nde */
  [%u\n", uh;
e.offsed)availor d_buh;
e.m      MATCH,rs = ssssa**fa  smngrn pen*/tShororeatwaMATCH:
         ===leftB(     pub      flf_leut ;s}/* ussssscrp  =b_ress-Bleft,
+=       === c;
e.offsede> crp et  s = ssssa**crp  e
oml  repletat_d* ussssscrp  =b c;
e.offsede-acrp ,as = _bbbbb ===crp  > uh;
e.wput  putShoror d_b_b ===uh;
e.san  putShoror d_b_b_buhem>msg   'inngth;
de */
  [aoo;fvar anu'ng_boror d_b d_buh;
e.m      BAD;
+=oror d_b d_b      /* usssssssss}/yt (!) Tuisdntinueisdde ypedd1bntzlib if aults,/yt do 'ffenypedift t lebi teS crtpatibi . y/= 
  if (INFLATE ALLOW_INVALID*DISTANCE_TOOFAR_ARRR
cv          Trace((srderr, "uo=====.c[aoo;fva\n")avacv          crp  -=auh;
e.wput vacv           ===crp  > uh;
e. First)pubcrp  =buh;
e.lFirstas}/yt           ===crp  > left pubcrp  =bleft, }/yt          leftB-ogcrp ,ayt          uh;
e.lFirst.-ogcrp ,ayt          doputyt          eesrt LS[ LS++] =b0,ayt          }d  >= 0)--crp e;=yt           === c;
e.lFirst.=     pubuh;
e.m      LEN, }/yt                /yt* Fluss* us d_b  }/* ussssss  ===crp  > uh;
e.woee tputShoror d_b_bcrp  -=auh;
e.wtXxS,rs           e
oml=ruh;
e. _vali- crp ,as = _bbbbb}t Dor d_b  levelutShoror d_b_be
oml=ruh;
e. nee a- crp ,as = _bbbbb}t Dor d_b   ===crp  > uh;
e. First)pubcrp  =buh;
e.lFirstas}/oror d_b_be
om_ oulcel=ruh;
e.  repl /* usssss}/* ussssslevelu                              a**crp  e
omlsrt LSB,0,_dor d_b_be
om_ oulcel=rhrt LS(
          e
oml=rpess-B c;
e.offsed;t_d* ussssscrp  =b c;
e.lFirstat Dor d_b}/* usssss ===crp  > left pubcrp  =bleft, }/* usssssleftB-ogcrp ,as = _bbbuh;
e.lFirst.-ogcrp ,as = _bbbdoputShoror d_bsrt LS[ LS++] =be
om_ oulce[e
om++];= df |=ss}d  >= 0)--crp e;=* usssss === c;
e.lFirst.=     pubuh;
e.m      LEN, }/* usssss      /* ussseatwaLIT:
         ===leftB(     pub      flf_leut ;s}/* ussssssrt LS[ LS++] =b c;
e.lFirstat Dor d_bleft--e n;th,,ssuh;
e.m      LEN,rs = ssss      /* ussseatwaCHE S:
         === c;
e. rap putShoror d_b//h   hEED/

v(32e;= df |=ssss  >= 0)b/* n< 32 putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s i/aUse '|' flstiat of '+'= somake sure rhass osulteisdsignng
d ussssss s pold |= fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _b_ress-(Bleft,
+=        uhem>total_ress+=b_resng_boror d_buh;
e.totals+=b_resng_boror d_b ===_reseputShoror d_b_buhem>adlers(Bsc;
e. gs wh = d_bor d_b_bbbbb/*UPDATE(uh;
e. gs w, pess-B_res,r_rese;*/tShoror d ddddddd(uh;
e.===gs ? crc32(uh;
e. gs w, hrt LS, _res,rpess-B_res) : adler32(uh;
e. gs w, hrt LS, _res,rpess-B_res) ;
t Dor d_b  }
        _b_ress(Bleft,
+=        i/aNB: crc32 sns, 0oasdsignng 32-*areins,rzswap32be 


fsdsignng aoog_boror d_b ===(uh;
e.===gs ? pold : zswap32(pold))     uh;
e. gs w putShoror d_b_buhem>msg   'incrrrfctedataicgs w'ng_boror d_b_buh;
e.m      BAD;
+=oror d_b_b      /* usssss_b}/* ussssss //h   INIT/

v()e n;th,,sss pold og2(ail_bor d_b /* nog2(ail_bor d_b//h  //
        ss//Tracev((srderr, "uo=====:n y gs whma(0 ndmvra>= r\n")availor d_b}/* usssssuh;
e.m      LENGTH,rs = ssssa**fa  smngrn pen*/tShororeatwaLENGTH:
         === c;
e. rapt&&  c;
e.===gs putShoror d_b//h   hEED/

v(32e;= df |=ssss  >= 0)b/* n< 32 putShoror d_b_b ===put t(     pub      flf_leut ;s}/* ussssss s put --e n;th,,sss s pold += fl LS[oexr++]  va /* ;= d_bor d_b_b /* n+(B8;=* usssss s}/* ussssss //h  //
        _b ===pold     (uh;
e.totals.pendiffdiff) putShoror d_b_buhem>msg   'incrrrfctes are d0gs w'ng_boror d_b_buh;
e.m      BAD;
+=oror d_b_b      /* usssss_b}/* ussssss //h   INIT/

v()e n;th,,sss pold og2(ail_bor d_b /* nog2(ail_bor d_b//h  //
        ss//Tracev((srderr, "uo=====:n ys are dma(0 ndmvra>= r\n")availor d_b}/* usssssuh;
e.m      DONE,rs = ssssa**fa  smngrn pen*/tShororeatwaDONE:
        rede=a  SvarAM_END;
+=oror d      flf_leut ;t Dor deatwaBAD:
        rede=a  DATA_ERRORv  boror d      flf_leut ;t Dor deatwaMEM:
        red

fu  MEM_ERRORv  bororeatwaKYNC:
        a**fa  smngrn pen*/tShororif ault:
        red

fu  SvarAM_ERRORv  b_b}/* }a= d// flf_leut  <-bhfre isd   u place t le"goroiflf_leut ",iemulf(ng via "      flf_leut "a= d/*
     Red

fue
omluo=====(), updat ifal eftotalscoutr 1 neel ef gs whin le./* ussIfel ere  as noaprogut.
 dur ifal efuo=====() ca l, red

fuafr_buf /* uss rror.  Ca l update  repl() ec c   te1 ne/ leupdateal eft reple_h;
e./* ussNt==:natmlteeSa rrorte
omluo=====() isdnon-rfcoveryped./* u*/a= d//--- REK = 0() ---= duhem>oexr_res    LS,rs uhem>avail_ress(Bleft,
+=uhem>oexr_i* ogtXxS,rs uhem>avail_in = put ;= duh;
e.pold ogpoldat D c;
e. /*  og /* ;= d//---ars  === c;
e. _vali||==_res     uhem>avail_ress&&  c;
e.m    <aBADtus !==                   ( c;
e.m    <aCHE ST|| /st.
     Z_FINISH)) putShor ===update  repl(NI m,rscem>hrt LS,duhem>oexr_res,b_ress-Buhem>avail_res) putShororuh;
e.m      MEMv  bororred

fu  MEM_ERRORv  bor}/* }a d_in -(B;hem>avail_in,rs _ress-(Bscem>avail_res,
 euhem>total_in +=b_in,rs uhem>total_ress+=b_resng_buh;
e.totals+=b_resng_b === c;
e. rapt&& _reseputShoruhem>adlers(Bsc;
e. gs wh  /*UPDATE(uh;
e. gs w, uhem>oexr_res -B_res,r_rese;*/tShoror(uh;
e.===gs ? crc32(uh;
e. gs w, hrt LS, _res,ruhem>oexr_res -B_res) : adler32(uh;
e. gs w, hrt LS, _res,ruhem>oexr_res -B_res)avail}rs uhem>data_rypel(B c;
e. /*  +B( c;
e.luest? 64 :   p+= d_bor d_b_bbbbbbbbb= c;
e.m        TYPEt? 128 :   p+= d_bor d_b_bbbbbbbbb= c;
e.m        LEN_T|| uh;
e.m        COPY_t? 256 :   ng_b ===((_in =    t&& _rest(     p|| /st.
 ===aZ_FINISH)t&& rede===aZ_OKeputShorrede=a  BUF_ERRORv  b}rs red

fured;t}a=functo aluo=====End(NI meput
   ===!uhrmp|| !uhrm.uh;
e /*|| uhrm->zfre     (fre _func)0 =  bu d_bred

fu  SvarAM_ERRORv  b}a= dvar uh;
et(B;hem>uh;
eng_b === c;
e.  repleputShoruh;
e.  repl =_turn, th}rs uhem>uh;
et(Bturn, thred

fu  OK;t}a=functo aluo=====GetHiseas(NI m,rwiat putShvar uh;
e;a= d/*f gs whuh;
et*/tSh ===!uhrmp|| !uhrm.uh;
e pubred

fu  SvarAM_ERRORvh}rs uh;
et(B;hem>uh;
eng_b ==== c;
e. rapt& 2 po     pubred

fu  SvarAM_ERRORvh}r= d/*fsut  hiseasi;heucture */tShuh;
e.piat = hiseng_bwiat.t cath;false =* red

fu  OK;t}a=functo aluo=====SetDicto aary(NI m,rdicto aary putShvar dictLFirst.=adicto aary.lFirstattShvar uh;
e;aShvar dictid;aShvar red;t= d/*f gs whuh;
et*/tSh ===!uhrmp/*f==aZ_his.t*/p|| !uhrm.uh;
e /*f==aZ_his.t*/ pubred

fu  SvarAM_ERRORvh}rs uh;
et(B;hem>uh;
engg_b === c;
e. rapt!    t&& uh;
e.m    !   DICT  bu d_bred

fu  SvarAM_ERRORv  b}a= da** gs whes *crrrfctedicto aary identifiasi*/tSh ===uh;
e.m        DICT  bu d_bdictid   1(da**adler32(0,Bturn2]0em/
    a**dictid   adler32(dictid,rdicto aary, dictLFirst)r */tShordictid   adler32(dictid,rdicto aary, dictLFirst2]0e;= df  ===dictid     uh;
e. gs w putShororred

fu  DATA_ERRORv  bor}/* }a da**crp  dicto aary ec   repl u
tforupdate  repl(), which wi l ameneel e  boexist ifadicto aary if appropri;
et*/tShrede=aupdate  repl(NI m,rdicto aary, dictLFirst2]dictLFirst)r
   ===red putShoruh;
e.m      MEMv  borred

fu  MEM_ERRORv  b}tShuh;
e.put dict hB1(ail//e8racev((srderr, "uo=====:n ydicto aary set\n")availred

fu  OK;t}a=exports.uo=====Resede=auo=====Resed;=exports.uo=====Resed2e=auo=====Resed2;=exports.uo=====ResedKeepe=auo=====ResedKeep;=exports.uo=====Inide=auo=====Inid;=exports.uo=====Inid2e=auo=====Inid2;=exports.uo=====e=auo=====;=exports.uo=====Ende=auo=====End;=exports.uo=====GetHisease=auo=====GetHiseas;=exports.uo=====SetDicto aarye=auo=====SetDicto aary;=exports.uo=====Info   'pakoauo===== (fromlN   caaprojfct)'ng
a**Nt= implemetr 0=exports.uo=====Crp  =buo=====Crp ;=exports.uo=====GetDicto aarye=auo=====GetDicto aary;=exports.uo=====Marke=auo=====Mark;=exports.uo=====Prime   uo=====Prime;=exports.uo=====Synce=auo=====Sync;=exports.uo=====SyncPoflre=auo=====SyncPoflr;=exports.uo=====Uneasmine   uo=====Uneasmine;
*/a=
a***/p}),
a**158t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
"ftwaNI ict";a=
a/p(C) 1995-2013 Jean-loup Gailly1 neeMarkeAdler
a/p(C) 2014-2017 Vitaly Puzr i1 neeAndrey Tup/* in
//
=  Tuisdsoftware isdprovided 'as-is',prexpress,
y exput.
 s *impli 0==  wpDicnty. In noaevetr wi l l efauxprrit/ bwil;
 .ypediphiza
y damages==  ari
tforfromll efftwaofel isdsoftware.
//
=  Pasmisso alus gicntfer tha
y cat softwal isdsoftwareiphiza
y purpose,/yt incluhgina /tmercialsapplicato as,  neelthalts mit  neerede *ributdift/yt fre ly, subjfctelthl effollowginaut.I icto as:
//
=  1. Tuwaorig i1ofel isdsoftware muest mis/ bmisreput.etr 0; you muest mi/yt   claim rhassyou wroteal eforig iK csoftware.sIfeyou ftwal isdsoftware/yt    i1 dproduct,  n acknowledgmetr inal efproduct documetrato a w  appbe/yt   apprecif(ng but isdnoss oquired.
// 2. Alts ng  oulcelverso as muest/ bplainly mark 0oasdsuch,  neemuest mis/ /yt   misreput.etr 0oasdbe ifal eforig iK csoftware./yt 3. Tuisd miicelmayt mis/ bremot d s *alts ng fromla
y  oulcelde *ributo a.=
a/pSee uh;
etdefste
omluo=====.js
var BADt= 30,  dyn l/rigot  edatai rrort--bremainbhfre untilaut.eSB,0,var TYPEthB12; dyn l/rii: wpit ifaphizrypel /* , incluhginalues-===g
*are*/a=/*
   De0,0,0 . Sinc,ys are ,  neede */
  [0,0, 1 neewr. S hrtal ef osultgin
    . Since neema(0 tsytnd untilaeil ert misenn penuo LSBhizsrt LSBi rs =availyped,  n  on-of-ntinueisdFi  unts ng, s *aedatai rrortisdFi  unts ng./* uWhenalurgesenn penuo LSB neesrt LSBr_buf  1 re suppli 0 toluo=====(), phi  boexample,   16Knuo LSBr_buf B neea 64Kesrt LSBr_buf ,*morcirhan 95%1ofel e  bouo===== executo a time isdspetr inal isd srtine.
t DoEntryeassumpto as:
/* usssssuh;
e.m        LEN/* usssssuhem>avail_in /  6/* usssssuhem>avail_hrta/  258/* usssssuh;rta/  uhem>avail_hrt/* usssssuh;
e.b/* n< 8
/* uOnlred

f,suh;
e.m    isd catof:
/* usssssLENt--bran hrtaofeenn pensrt LSBspace s * on penavailypednuo LS/* usssssTYPEt--brea gsdn on effntinu     ,euo=====() toluots predenee antinu/* usssssBADt--b rrortinfntinu data
/* uNt==s:
/* us- Tuwamaximumnuo LSBr/* nftwg byeays are /de */
  [pairtisd15Br/* nphizrhd/* ussss are d0,0,, 5Br/* nphizrhdss are d or e,d15Br/* nphizrhdede */
  [0,0,,t_d     nee13 r/* nphizrhdede */
  [ or e.  Tuisdtotals 48l /* , hizsixtsytnd./* usssThfreforci ==uhem>avail_in /  6,zrhdnel ere isdFin penuo LSBlthavoig
d usss gs w ifaphizavailypednuo LSs  >= 0ee0,0 if.
/* us- Tuwamaximumnsytnd rhassa 
tfoleys are /de */
  [pairtcan hrt LSBi  258/* ussssytnd, which isdtuwamaximumns are drhasscan b [0,0,d._buo=====_=ues()tShororrequiressuhem>avail_hrta/  258hes * a g loopBlthavoigs gs w ifaphitShororsrt LSBspace./**/am  ule.exportsth;functo aluo=====_=ues(NI m,ruh;rt putShvar uh;
e;aShvar _in,                    /rifocKl  cem>fl LSt*/tShvar lues,                   a**havesenn penuo LSB  >= 0in < luest*/tShvar _resn                   /rifocKl  cem>srt LSB,0,_dvar beg,                    /riuo=====()' 1bnit Kl  cem>srt LSB,0,_dvar  on,                    /ri  >= 0hrta<  on,senn penspace availypedn*//= 
  if (INFLATE SvaICT
  var dmaxn                   /rimaximumnde */
  [e
omlzlib hiseasi*//= 
 Fluss* var  _valn                  /ri  reple_valis *zeroi == misu
tfor  repletat_dvar  hut ;s                 /ringth;
*ytnd inal ef  repletat_dvar  tXxS,                  /ri  replewr. S iora_btat_di/aUse `s_  repl` flstiat `  repl`,havoigs oo==ict rexp flstrumetrato a toolstShvar u_  repl,               a**aufocKt g  th;tfor  repl,i == _vali!   ttat_dvar polda                   /rifocKl  cem>pold ,0,_dvar b/* ;                   /rifocKl  cem>r/* n*/tShvar l0,0,,                  /rifocKl  cem>lFi     */tShvar d0,0,,                  /rifocKl  cem>de *     */tShvar lmask,                  /rimaskhes *firstes vel effs are d0,0, n*/tShvar dmask,                  /rimaskhes *firstes vel effde */
  [0,0, 1tat_dvar pere;                   /riredriet d hyped entryetat_dvar op,                    da**crdel /* , opSinto a,[ or el /* , hiz*/tShoror d ddddddd             da**i  repleposito a,[  replesytnd ro*crp  */tShvar len,                    /rima(0 ts are , unftwg byt, n*/tShvar dies,                   a**ma(0 tde */
  [*/tShvar e
om,                   a**w ere ro*crp  ma(0 te
oml*/tShvar e
om_ oulce;a=
Shvar c(;
 , hrt LS(di/aJSdspecific, iecaftwawefput anoapoflres a= da** rp  uh;
etro*focKl variypedsm*/tShuh;
et(B;hem>uh;
eng_b//ofre og c;
e.pere;a d_in og cem>oexr_ic,rs uo LSBog cem>fl LS,rs luest(B_in + (uhem>avail_in - 5),rs _ress(Bscem>oexr_res,
 esrt LSB(Bscem>hrt LS(
  beg =b_ress-B(uh;rta-Buhem>avail_res)(
  ende=a_ress+ (uhem>avail_ress-B257e;=yt
  if (INFLATE SvaICT
  dmax og c;
e.dmaxn/= 
 Fluss*  _vali=ruh;
e. _val(
  wput t(B;ha
e.wput va   tXxS =auh;
e.wtXxS,rs u_  repll=ruh;
e.  repl /* pold =e c;
e.poldat D l* l(B c;
e. /* ;= dl        c;
e.lFi0,0,,
  d        c;
e.de *0,0,,
  lmaska=+=1  va c;
e.lFi /* ) - 1;
  dmaska=+=1  va c;
e.de * /* ) - 1;a=
Shcodee0,0,0 . Sinc 1 nees are /de */
  d untilaeon-of-ntinueort misenn petShorouo LSBdataihizsrt LSBspace */a= dtop:
  doputShor ===b/* n< 15 putShororpold += fl LS[_in++]  va /* ;= d_bor /* n+(B8;=* ussspold += fl LS[_in++]  va /* ;= d_bor /* n+(B8;=* us}/ailorofre ogl    [pold .plmask];
t Dordos a:
    t le(;;et di/aGoroiemulf(o atShororsp   ofre 

/*24/*ofre. /* m/;
+=* uspold 

/  op;= d_bor /* n-  op;= d_borop    hfre 

/*16 p.pendi/*ofre.opm/;
+=* us ===op h     puor d ddddddd             da** . Since*/tShoror d//Tracevv((srderr, ofre.val >=pen20 && pfre.val <pen7f ?tShoror dcv        "uo=====:n y d d n . Since'%c'\n" :tShoror dcv        "uo=====:n y d d n . Since0x%02x\n", pfre.val)) /* ussssssrt LS[_res++] =bhfres.pendiff/*ofre.valm/;
+=* us}/* ussslevel ===op &p16 puor d ddddddd         a**  are dbatwa*/tShoror dllit(Bhfres.pendiff/*ofre.valm/;
+=* usorop &=p15;or d ddddddd             d a**numbasiofeeor el /*  */ap        ===op putShoror d_b ===b/* n< op putShoror d_bsspold += fl LS[_in++]  va /* ;= d_borrrrrrr /* n+(B8;=* usssss s}/* ussssss    cn=apold .p((1  vaop p- 1) /* usssss_bpold 

/  op;= d_borrrrr /* n-  op;= d_borrr}/* usssss//Tracevv((srderr, "uo=====:n y d d nlFirst.%u\n", lFi)e;=* usssss ===b/* n< 15 putShoror_bsspold += fl LS[_in++]  va /* ;= d_borrrrr /* n+(B8;=* usssss spold += fl LS[_in++]  va /* ;= d_borrrrr /* n+(B8;=* usssss}/* usssssofre ogd    [pold .pdmask];
t Dorrrrrdode *:
        t le(;;et dcv goroiemulf(o atShororrrrrsp   ofre 

/*24/*ofre. /* m/;
+=* usss_bpold 

/  op;= d_borrrrr /* n-  op;= d_borrrorop    hfre 

/*16 p.pendi/*ofre.opm/;
tShoror d_b ===op &p16 puor d ddddddd          a**di */
  [batwa*/tShoror drrrrd1)  =rhfres.pendiff/*ofre.valm/;
+=* usorrrorop &=p15;or d ddddddd           a**numbasiofeeor el /*  */ap        d_b ===b/* n< op putShoror d_bsssspold += fl LS[_in++]  va /* ;= d_borrrrrrrbb /* n+(B8;=* usssss sss   ===b/* n< op putShoror d_bsssssspold += fl LS[_in++]  va /* ;= d_borrrrrrrbbbb /* n+(B8;=* usssss sss  }t Dor d_b    }tShoror drrrrd1)  n=apold .p((1  vaop p- 1) /= 
  if (INFLATE SvaICT
        ss   === 1)  > d    putShoror d_bbbbbuhem>msg   'inngth;
de */
  [aoo;fvar anu'ng_boror d_b d_buh;
e.m      BAD;
+=oror d_b d_b     dtop;t Dor d_b    }tyt* Fluss* us d_b  _bpold 

/  op;= d_borrrrrrr /* n-  op;= d_borrror_b//Tracevv((srderr, "uo=====:n y d d nde */
  [%u\n",  1)  );
+=* usorrrorop =b_ress-Bbeg,                /rimaxnde */
  [inlsrt LSB,0,_dor d_b_b   === 1)  > op pu                /riseel ==crp  e
oml  repletat_d* usssssrrorop =b 1)  - op,               a**di */
  [banueinl  repletat_d* usssssrror ===op > wput  putShoror d_b_brror ===uh;
e.san  putShoror d_b_b_bbbbbuhem>msg   'inngth;
de */
  [aoo;fvar anu'ng_boror d_b d_bbbbbuh;
e.m      BAD;
+=oror d_b d_bbbbb     dtop;t Dor d_b        }
/yt (!) Tuisdntinueisdde ypedd1bntzlib if aults,/yt do 'ffenypedift t lebi teS crtpatibi . y/= 
  if (INFLATE ALLOW_INVALID*DISTANCE_TOOFAR_ARRR
cv          _brror ===   c<  op - wput  putcv          _brror  doputyt          eeeeeeeeeesrt LS[_res++] =b0,ayt                  }d  >= 0)--lFi),ayt                  continuedtop;tyt                }tyt                   c-  op - wput ;tyt                doputyt          eeeeeeeesrt LS[_res++] =b0,ayt                }d  >= 0)--op > wput  ,ayt                 ===op h     putyt          eeeeeeeee
oml=r_ress-Bdies,tcv          _brror  doputyt          eeeeeeeeeesrt LS[_res++] =bsrt LS[e
om++];=yt                  }d  >= 0)--lFi),ayt                  continuedtop;tyt                }tyt* Fluss* us d_b  _b  }t Dor d_b      e
oml=r0(di/a  repleiora_t Dor d_b      e
om_ oulcel=ru_  repl /* usssssssssss === tXxS =     puor d dddddd/rineeS crtmonreatwa*/tShoror d ddddddde
omln=a _vali- op;t Dor d_b         ===op < lFi)t  s = ssssa**some e
oml  repletat_d* usssssrrorrrrr   c-  op;
+=oror d_b d_bbbbbdoputShoror d_bbbbbbbbbbbsrt LS[_res++] =bu_  repl[e
om++];= df |=ssssssssssss}d  >= 0)--op)at Dor d_b      dddde
oml=r_ress-Bdies,  /rire)  e
omlsrt LSB,0,_dor d_b_b    dddde
om_ oulcel=rhrt LS(
          ssssss}s* us d_b  _b  }t Dor d_b      level === tXxS < op pu      a**wraptarts.dl  repletat_d* usssssrrorrre
omln=a _vali+  nee a- op;
+=oror d_b d_bbbop -= wtXxS,rs                ===op < lFi)t  s = ssssa**some e
oml on eff  repletat_d* usssssrrorrrrr   c-  op;
+=oror d_b d_bbbbbdoputShoror d_bbbbbbbbbbbsrt LS[_res++] =bu_  repl[e
om++];= df |=ssssssssssss}d  >= 0)--op)at Dor d_b      dddde
oml=r0v/* usssss_bss       === tXxS < lFi)t  sa**some e
omluh;rtaeff  repletat_d* usssssrrorrrrrorop =bwtXxS,rs               rrrr   c-  op;
+=oror d_b d_bbbbbbbdoputShoror d_bbbbbbbbbbbbbsrt LS[_res++] =bu_  repl[e
om++];= df |=ssssssssssssss}d  >= 0)--op)at Dor d_b      dddddde
oml=r_ress-Bdies,      /rire)  e
omlsrt LSB,0,_dor d_b_b    dddddde
om_ oulcel=rhrt LS(
          ssssss  }t Dor d_b      ss}s* us d_b  _b  }t Dor d_b      leveluor d ddddddd          a**contiguouseinl  repletat_d* usssssrrorrre
omln=a nee a- op;
+=oror d_b d_bbb ===op < lFi)t  s = ssssa**some e
oml  repletat_d* usssssrrorrrrr   c-  op;
+=oror d_b d_bbbbbdoputShoror d_bbbbbbbbbbbsrt LS[_res++] =bu_  repl[e
om++];= df |=ssssssssssss}d  >= 0)--op)at Dor d_b      dddde
oml=r_ress-Bdies,  /rire)  e
omlsrt LSB,0,_dor d_b      dddde
om_ oulcel=rhrt LS(
          ssssss}s* us d_b  _b  }t Dor d_b        >= 0)llit>b2 putShoror d_b_b_bbbsrt LS[_res++] =be
om_ oulce[e
om++];= df |=ss_b_b_bbbsrt LS[_res++] =be
om_ oulce[e
om++];= df |=ss_b_b_bbbsrt LS[_res++] =be
om_ oulce[e
om++];= df |=ss_b_b_bbb   c-  3;= df |=ssss_b  }t Dor d_b       ===    putShoror d_b_b_bbbsrt LS[_res++] =be
om_ oulce[e
om++];= df |=ss_b_b_bbb ===   c/*1 putShoror d_b_b_bbbbbsrt LS[_res++] =be
om_ oulce[e
om++];= df |=ss_b_b_bbb}s* us d_b  _b  }t Dor d_b    }t Dor d_b    levelutShoror d_b_b_be
oml=r_ress-Bdies,          a**crp  dirfctee
omlsrt LSB,0,_dor d_b      dopuShoror d_b_b_bbbbb      a**minimumns are disdture  ,0,_dor d_b      ddsrt LS[_res++] =bsrt LS[e
om++];=_dor d_b      ddsrt LS[_res++] =bsrt LS[e
om++];=_dor d_b      ddsrt LS[_res++] =bsrt LS[e
om++];=_dor d_b      dd   c-  3;= df |=ssss_b  }   >= 0)llit>b2  /* usssssssssss ===    putShoror d_b_b_bbbsrt LS[_res++] =bsrt LS[e
om++];=_dor d_b      dd ===   c/*1 putShoror d_b_b_bbbbbsrt LS[_res++] =bsrt LS[e
om++];=_dor d_b      dd}s* us d_b  _b  }t Dor d_b    }t Dor d_b  }t Dor d_b  level ====op &p64 p=     puor d ddddda**2nees vel de */
  [0,0, ,0,_dor d_b    ofre ogd    [(hfres.pendiff)/*ofre.valm/ +B(pold .p((1  vaop p- 1))] /* usssss_bsscontinueddode *;=* usssss s}/* ussssss levelutShoror d_b_buhem>msg   'inngth;
de */
  [0,0,'ng_boror d_b_buh;
e.m      BAD;
+=oror d_b_b     dtop;t Dor d_b  }
tShoror d_b     ;si/aneed roiemulf(e goroivia "continue"=* usssss}/* usss}/* ussslevel ====op &p64 p=     puor d ddddddddda**2nees vel s are d0,0, ,0,_dor d_bofre ogl    [(hfres.pendiff)/*ofre.valm/ +B(pold .p((1  vaop p- 1))] /* ussssscontinueddolac,rs = ss}/* ussslevel ===op &p32 pu                     a**eon-of-ntinue*/tShoror d//Tracevv((srderr, "uo=====:n y d d n on effntinu\n")availor d_buh;
e.m      TYPE,rs = ssss     dtop;t Dor d}/* ussslevel{ailor d_buhem>msg   'inngth;
 . Sinc/s are d0,0,'ng_boror duh;
e.m      BAD;
+=oror d     dtop;t Dor d}/
or d_b     ;si/aneed roiemulf(e goroivia "continue"=* us}/* }   >= 0)_in < luest&& _rest<  on);t= d/*fred

fuunftwg byt, n(on entry, b/* n< 8,*soeinl o 'ffgo[aoo;fvar anu) */ap llit(Bb/* n>> 3;= d_in -(Blac,rs  /* n-  =  c<< 3;= dpold .=+=1  va /* ) - 1;a= d/*fupdateauh;
et neered

fu*/tShuhem>oexr_i* og_in,rs uhem>oexr_res   _res,
 euhem>avail_in = )_in < luest? 5 +B(luest-g_in) : 5s-B(_in - lues)availuhem>avail_ress(B(_rest<  ont? 257 +B( ont-B_res) : 257 -B(_rest-  on)availuh;
e.pold ogpoldat D c;
e. /*  og /* ;= dred

f;
};a=
a***/p}),
a**159t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
"ftwaNI ict";a=
a/p(C) 1995-2013 Jean-loup Gailly1 neeMarkeAdler
a/p(C) 2014-2017 Vitaly Puzr i1 neeAndrey Tup/* in
//
=  Tuisdsoftware isdprovided 'as-is',prexpress,
y exput.
 s *impli 0==  wpDicnty. In noaevetr wi l l efauxprrit/ bwil;
 .ypediphiza
y damages==  ari
tforfromll efftwaofel isdsoftware.
//
=  Pasmisso alus gicntfer tha
y cat softwal isdsoftwareiphiza
y purpose,/yt incluhgina /tmercialsapplicato as,  neelthalts mit  neerede *ributdift/yt fre ly, subjfctelthl effollowginaut.I icto as:
//
=  1. Tuwaorig i1ofel isdsoftware muest mis/ bmisreput.etr 0; you muest mi/yt   claim rhassyou wroteal eforig iK csoftware.sIfeyou ftwal isdsoftware/yt    i1 dproduct,  n acknowledgmetr inal efproduct documetrato a w  appbe/yt   apprecif(ng but isdnoss oquired.
// 2. Alts ng  oulcelverso as muest/ bplainly mark 0oasdsuch,  neemuest mis/ /yt   misreput.etr 0oasdbe ifal eforig iK csoftware./yt 3. Tuisd miicelmayt mis/ bremot d s *alts ng fromla
y  oulcelde *ributo a.=
var utol  og__webpack_require__(34);t=var MAX/

v =p15;=var ENOUGH_LENS =p852;=var ENOUGH_DISTS =p592;tytvar ENOUGHs(B(ENOUGH_LENS+ENOUGH_DISTS);t=var CODESl=r0v/var LENS =p1v/var DISTS =p2;t=var lbatwa= [d/*fL are d0,0, n257..285[batwa*/tSh3, 4, 5, 6,z7, 8,*9, 10, 11, 13,d15,d17, 19, 23,d27, 31,t_d35,d43,d51, 59, 67, 83,d99, 115,d131, 163,d195,d227, 258,e0,t0
];t=var lXxS =a[d/*fL are d0,0, n257..285[eor el*/tSh16,h16,h16,h16,h16,h16,h16,h16,h17,h17,h17,h17,h18,h18,h18,h18,tSh19,h19,h19,h19,h20,h20,h20,h20,h21,h21,h21,h21,h16,h72,h78
];t=var dbatwa= [d/*fDe */
  [0,0, 10..29[batwa*/tSh1,h2,h3, 4, 5, 7,*9, 13,h17,h25, 33, 49, 65, 97,h129,h193,tSh257, 385,d513, 769, 1025, 1537,h2049, 3073, 4097,h6145,tSh8193,h12289, 16385,d24577,e0,t0
];t=var dXxS =a[d/*fDe */
  [0,0, 10..29[eor el*/tSh16,h16,h16,h16,h17,h17,h18,h18,h19,h19,h20,h20,h21,h21,h22,h22,tSh23, 23,d24,d24,d25,d25,d26,d26,d27,d27,tSh28,h28,h29,h29,h64,h64
];t=m  ule.exportsth;functo aluo=====_cspac(rype, lFis, lFis_iora_,[0,0, , hyped, hyped_iora_,[ ork, s  sa
{ailvar b/*  (Bs  s. /* ;=* usss//ofre ogs  s.pere; /*fhyped entryephizduplicato a */a= dvar lenl=r0(d              a**ad0,0,'sns are dinl /*  */ap var uyml=r0(d              a**iora_bofd0,0, uymbol  */ap var min = 0,hmax og0,          a**minimumn neemaximumn0,0,0  are  1*/ap var rootl=r0(d             a**numbasiofeiora_br/* nphizrootltypedn*//p var currl=r0(d             a**numbasiofeiora_br/* nphizcurretr typedn*//p var drop =b0(d             a**crdel /* elthdrop phizsub-typedn*//p var leftB(B0(d                  a**numbasiofeputfix[0,0, 1 vailypedn*//p var ftwg =b0(d             a**crdelentrind inalypednftwg tat_dvar puff =b0(d             a**Huffm n      */tShvar incr(d             a**for incremetrgina /  ,euora_btat_dvar ei l(d             a**uora_bphizreplicatofor otrind *//p var lpl,               a**!!!!r/* nphizcurretr rootlentryetat_dvar mask,              /rimaskhes *!!!!rootl /*  */ap var tXxS,             a**nXxS  vailypednspace inalypedn,0,_dvar batwa= turn,     a**batwain lealypedn softwa,0,_dvar batw_iora_b(B0,ayt  var uho =   ,    a**eor el /*  lypedn softwa,0,_dvar  on,                    /riftwabatwa neeeor elphizsymbol >  ont*//p var c unta= tew utol .Buf16(MAX/

v + 1) s//[MAX/

v+1],    a**numbasiofe0,0, 1of* a g l are dtat_dvar offsa= tew utol .Buf16(MAX/

v + 1) s//[MAX/

v+1],     a**offsedd inalypednes * a g l are dtat_dvar  or ea=+turn, thvar  or e_iora_b(B0,a
_dvar pere_ /* , ofre_op,ahfre;val;

 d/*
   Proct.
 a setbofd0,0,   are  1ec c   te1 scanonicKl Huffm n     .  Tud/* u0,0,   are  1are lFis[0..0,0, -1].  Ea g l are dcrrrfspondselthl e/* uuymbol  0..0,0, -1.  Tud*Huffm n      us genSintwg byefirstesort ifal e/* uuymbol  byel are de
omluprrttro*fong,t neeredain ifal efsymbol ordf /* ues *cr0, 1rexp equal s are s.  Tudnal ef /deluh;rt 1rexp a l zeroi /* /* ues *l effirste /delofel eluprrtestes are ,1 neel ef ,0, 1 re itr gf /* uincremetr nphizrhdesamees are ,1 neezero 1 re app on 0oasdrhdss are /* uincreatws.  Fhizrhdede===== phimat,zrhdsel /* e re sns, 0o anuward /* ueromll eir*morcinatuinceitr gf uincremetr ordf ing,t neeso*w enal e/* uee0,0 ifq
ypedsm re builr inal eflurgesloopB/ !!!,al efuor gf u ,0, /* u re itcremetr 0o anuward .
/* uT isd srtineeassum, , but doesdnoss gs w, rhassalllofel elentrind in/* ulFis[]u re ital ef anges0..MAX/

v.  Tud*ca lf umuestassurwal is./* u1..MAX/

v us uots pred 0oasdrhatu0,0,   are .  zeroimeansdrhaturhat/* uuymbol doesdnossoccur inal isd    .
/* uT ef ,0, 1 re sortwg byecrtput ifaa c untaofe0,0, 1es * a g l are ,t_d c   ttforfromll assa lypednofluh;rttforioric, 1es * a g l are  ital e/* uuortwg typed,  ndzrhdneetr r ifal efsymbold inaordf  ital efuortwg/* utyped.  Tud*uortwg typed us  ork[],prexpll assspace be ifaprovided by/* utud*ca lf .
/* uT efl are dcrutr 1 rdnftwg es *ol ertpurposesoasdwern2]i.d. fioriin
   tuwaminimumn neemaximumns are d0,0, ,ueetasmintforifel ere  re any/* u0,0,soassall,s gs w ifaphizaingth;
setbofds are s,  ndzloow ifaahise/* u tfl are dcrutr 1lthdetasminezsub-typedn_vals*w enabuild ifal e/* uee0,0 ifq
ypeds./* u*/a= d/**accumulf(e   are  1es *cr0, 1(assum, ulFis[]u lceits0..MAX/

v) */ap t le(lenl=r0(d   c<  MAX/

v(d   ++ putShorcrutr[   ]l=r0v/* }ap t le(uyml=r0(duyml<*cr0, (duym++ putShorcrutr[   s[lFis_iora_ + uym]]++v/* }a= d/**bts.dl0,0,   are  , phice rootltos/ brexpinn0,0,0  are  1*/ap rootl=r /* ;=* t le(max ogMAX/

v(dmax >  1(dmax-- putShor ===crutr[max]t!     pub     ;s}/* }/*  ===rootl>     putShorrootl=rmaxn/* }/*  ===max o     puor d ddddddd         a**nofsymbold ro*cr0,0assalllm/
    a/typed.op[s  s.hyped_iora_]l=r64;ss//ofre.op    var char)64;ss  a**uongth;
cr0,0mark rlm/
    a/typed. /* [s  s.hyped_iora_]l=r1; ss//ofre.b/*  (B var char)1trm...a/typed.ngt[s  s.hyped_iora_++] =b0, ss//ofre.val =b(var uhort)0v/* ushyped[hyped_iora_++] =b=1  va24) | (64  va16 p|B0,a

    a/typed.op[s  s.hyped_iora_]l=r64;
    a/typed. /* [s  s.hyped_iora_]l=r1;rm...a/typed.ngt[s  s.hyped_iora_++] =b0,/* ushyped[hyped_iora_++] =b=1  va24) | (64  va16 p|B0,a
* uss  s. /* l=r1;rm...red

fu0;     a**nofsymbold, but wpitephizde0,0 ifq
ozreprrtt rrortm/
  }ap t le(min = 1(dmin < maxn mi ++ putShor ===crutr[min]t!     pub     ;s}/* }/*  ===rootl< mi  putShorrootl=rmin,rs }a= da** gs whes *an hver-subscrib d s *incrmpleteauetbofds are s */ap llft hB1(ailt le(lenl=r1(d   c<  MAX/

v(d   ++ putShorllft <<=r1;rm...leftB-ogcrutr[   ];tShor ===llft <   putShororred

fu-1trm...}        a**hver-subscrib d m/
  }ap  ===llft >  t&& (rypel(   CODESl||dmax !   1) putShorred

fu-1tor d ddddddd          a**uocrmpleteauetbm/
  }a= da**genSintw*offsedd intofsymbolalypednes * a g l are dphizsort ifam/
  offs[1] =b0,/* t le(lenl=r1(d   c< MAX/

v(d   ++ putShoroffs[   cn 1] =boffs[   ]cn crutr[   ];tSh}r= d/*fsrrttuymbol  byel are , byesymbol ordf brexpinn a g l are dtat_dt le(uyml=r0(duyml<*cr0, (duym++ putShor ===   s[lFis_iora_ + uym]t!     putShoror ork[offs[   s[lFis_iora_ + uym]]++] =buymtrm...}tSh}r= d/*rm..C   te1 ne ei leitsee0,0 ifq
ypeds.  In l isdloop,al eflypednbe if/* uei ldd1bsoassnXxS  ne hasdcurrliora_br/* . uT ef ,0, be ifaftwg bsopuff/* urexpll are dl a. uT atu0,0, isd  nvertfer tha
liora_bryhdropp ifadrop/* u /* lofflofel elbottom.  Fhizcr0, 1r ere    cisdlt.
 rhan drop +dcurr,
   tuosedtop drop +dcurrs-Blenl /* e re itcremetr 0ongrn penalllin led ro/* uei lal eflypednrexplreplicatsdn otrind.
/* urootlisdtuwanumbasiofeiora_br/* nphizl ef ootltyped. uWhenaldneexceed /* u oot,zsub-typed e re c   tedapoflreer thryhl ef ootlentryerexp aneiora_t Doofel el!!!!rootl /*  ofepuff.  Tuisdisdsut deits!!!!ro*cgs whes *w enaat Dotew sub-typedn_h  appbeluh;rt,d._bdrop isdzeroiw enal ezrootltypedni rs =be ifaei ldd,  needrop isdrootlw enasub-typed e re be ifaei ldd.
/* uWhenaaotew sub-typednisd eeddd, it isdnect.
ary ec loowaahise ital e/* u0,0,   are  1ec detasminezw asssvalisub-typednisd eeddd. uT efl are 
horcrutr 1 rdnftwg es *l is,t neeso*crutr[]eisddecremetr 0oasf ,0, 1 re
horents ng ital ef
ypeds./
horftwg keepdmvranueofep!!!ma
y hyped entrind put tbeenaaufocKt g eromll e
horprovided *typednspace.  It isdcgs wwg es *LENS  neeDISTq
ypedsm gaflst/* utud*con */
r 1ENOUGH_LENS  neeENOUGH_DISTS ec guardm gaflst changed in/* ul efuoit Kl rootltypednsvalicon */
r .  See tud*commetr nialuo=treds.h/* ues *morciuo=himato a.=
  uuymuincremetr nngrn penalllsymbold,  neel efloopBlasminatls*w en/* u lle0,0, 1of*s are dmax2]i.d.  lle0,0, , put tbeenaproct.
dd. uT i /* u ortineepasmir niacrmpletea0,0, , stha
ol ertloopBafts ml isd catei ls/* uinal ef ostoofel elee0,0 ifq
ypedsmrexp flngth;
cr0,0mark rs./* u*/a= d/**uetbup1es *cr0,zrypeltat_di/apos *man hptimizato a -iftwaif-level lstiat of srexc ,t_di/althavoigsdes  s inaoappv8ap  ===rypel(   CODES putShorbatwa=  or ea=+ ork;ss  a**dummylin le-- misu
 d m/
    ende=a19,a
* }slevel ===rypel(   LENS putShorbatwa= lbatw;tShorbatw_iora_ -  257;tShor or ea=+lXxS,rs    or e_iora_b-  257;tShor nde=a256,a
* }sleveluor d ddddddd        /*fDISTS m/
    batwa= dbatw;tShor or ea=+dXxS,rs    nde=a-1trm.}r= d/*fuoit Klvalisp* nphizloopBm/
  puff =b0(d                  /*fuh;rttfor     */tShuyml=r0(d                   /*fuh;rttfor     symbol */ap llit(Bmin,                  /*fuh;rttfor     l are dtat_dtXxS =ahyped_iora_(d             a**curretr typednlthei leitstat_dcurrl=rroot,                /ricurretr typedniora_br/* ntat_ddrop =b0(d                  /ricurretr  /* elthdrop proml     for inra_btat_dlpll=r-1tor d ddddddd       /*fhriggf utew sub-typednwhenaldne> rootltat_dftwg =b1  varoot,          /riftwarootltypedn otrind *//p maska=+ftwg - 1tor d ddddddd/rimaskhes *crtpar ifalpletat= da** gs wh vailypedntypednspacei*/tSh ====rypel(   LENSt&& ftwg >1ENOUGH_LENS p||rs   =rypel(   DISTS && ftwg >1ENOUGH_DISTS) putShorred

fu1trm.}r= d/*fproct.
 alle0,0, 1 neemakeltypedn otrind *//p t le(;;et = d_ba**    te1hyped entryetat_dssofre_ ext =b   c-hdrop;tShor === ork[uym]t<  on)putShororpfre_op   0v/* usssofre_val =b ork[uym]trm...}tSh  level === ork[uym]t>  on)putShororpfre_op    or e[ or e_iora_b+b ork[uym]]v/* usssofre_val =bbatw[batw_iora_ +b ork[uym]]v/* us}tSh  levelutShororpfre_op   32 +b64;ss  ddddd/ri on effntinu */tShororofre_val =b0v/* us}t= d_ba**replicats es *l ovel lric, 1rexpllplelenl /* eequal lthpuff */tShorincr =b1  va(   c-hdropavailorei le=b1  vacurrvailormin = ei l(d               d/*fsut  offsedelthtXxS lypedn,0,_dbbdoputShororei le-= incr(tShororhyped[tXxS +B(puff >>hdropa +Bei l] =b=ofre_ ext  va24) | (pfre_op  va16 p|Bofre_val |0v/* us}   >= 0)ei le!     ;t= d_ba** anuward uincremetr rhdss a-*are     puff */tShorincr =b1  va(   c-h1) /* us  >= 0)puff &rincr)putShororincr >>=r1;rm...}tShor ===incr !     putShororpuff &= incr - 1;
  ororpuff += incr(tShor} levelutShororpuff =b0(/* us}t= d_ba**go[aohtXxS symbol,fupdateacrutr, lFi */tShoruym++;tShor ===--crutr[   ]l=     putShoror ===   c=       pub     ;s}/*     llit(B   s[lFis_iora_ +  ork[uym]]v/* us}t= d_ba**    te1tew sub-typednifd eeddd */tShori===   c/*rootl&& (puff &rmask)     lpleputShor d/*fufffirstetime,mvransito a[aohsub-typed e*/tShoror === rop h     put       ddrop =broot,t      }/
or d_ba**uocremetr puestluestlypedn,0,_dbb_dtXxS +(Bmin,            a**here min isd1  vacurretat= d    a**detasminezl are dofhtXxS lypedn,0,_dbb_dcurrl=r   c-hdrop;tShorp llft hB1  vacurrvailorus  >= 0)currl+ddrop <     putShoror dleftB-ogcrutr[currl+ddrop] /* usssss ===llft <    pub     ;s}/* _dbb_dcurr++;tShoror dleftB<<=r1;rm...  }/
or d_ba**cgs whes *enn penspace ,0,_dbb_dftwg +hB1  vacurrvailorus ====rypel(   LENSt&& ftwg >1ENOUGH_LENS p||rs       =rypel(   DISTS && ftwg >1ENOUGH_DISTS) putShorrrrrred

fu1trm...  }/
or d_ba**poflr entryein rootltypednaohsub-typed ,0,_dbb_dlpll=rpuff &rmask;=* usss/*typed.op[lpl] =bcurrvailorustyped. /* [lpl] =broot,t      typed.ngt[lpl] =bnee a- op s.hyped_iora_;*/tShororhyped[lpl] =b=rootl<va24) | (currl va16 p|B(nee a- hyped_iora_) |0v/* us}rm.}r= d/*fei leitsremain ifq
yped entryeifu0,0, isdiacrmpletea(guarcntfeer thput /* u t*mostoonesremain ifqentry, si
  [ifal ef /delisdiacrmplete,ll e
hormaximumn0,0,0  are ll ass as aufoweer thgedel isdfvarisd cat /*)i*/tSh ===puff !     putShora/typed.op[tXxS +Bpuff]l=r64;ss          a**uongth;
cr0,0mark rlm/
    a/typed. /* [tXxS +Bpuff]l=r   c-hdrop;tShora/typed.ngt[tXxS +Bpuff]l=r0,/* ushyped[tXxS +Bpuff]l=r((   c-hdropa  va24) | (64  va16 p|0;tSh}r= d/*fsetrred

fuparametassltat_di/op s.hyped_iora_ +hBftwg;tShs  s. /* l=rroot,t  red

fu0;
};a=
a***/p}),
a**160t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
"ftwaNI ict";a=
a/p(C) 1995-2013 Jean-loup Gailly1 neeMarkeAdler
a/p(C) 2014-2017 Vitaly Puzr i1 neeAndrey Tup/* in
//
=  Tuisdsoftware isdprovided 'as-is',prexpress,
y exput.
 s *impli 0==  wpDicnty. In noaevetr wi l l efauxprrit/ bwil;
 .ypediphiza
y damages==  ari
tforfromll efftwaofel isdsoftware.
//
=  Pasmisso alus gicntfer tha
y cat softwal isdsoftwareiphiza
y purpose,/yt incluhgina /tmercialsapplicato as,  neelthalts mit  neerede *ributdift/yt fre ly, subjfctelthl effollowginaut.I icto as:
//
=  1. Tuwaorig i1ofel isdsoftware muest mis/ bmisreput.etr 0; you muest mi/yt   claim rhassyou wroteal eforig iK csoftware.sIfeyou ftwal isdsoftware/yt    i1 dproduct,  n acknowledgmetr inal efproduct documetrato a w  appbe/yt   apprecif(ng but isdnoss oquired.
// 2. Alts ng  oulcelverso as muest/ bplainly mark 0oasdsuch,  neemuest mis/ /yt   misreput.etr 0oasdbe ifal eforig iK csoftware./yt 3. Tuisd miicelmayt mis/ bremot d s *alts ng fromla
y  oulcelde *ributo a.=
m  ule.exportsth;{r= d/*fAufoweer/st.
 in led;iseelde=====()  neeuo=====() / !!!ephizdetail  */ap Z_NO_FLUSH:n y d d n0,ap Z_PARTIAL_FLUSH:n y 1,ap Z_KYNC_FLUSH:n y d d2,ap Z_FULL_FLUSH:n y d d3,ap Z_FINISH:n y d d n  4,ap Z_BLOCK:n y d d n   5,ap Z_TREES:n y d d n   6,r= d/*fRed

fu0,0, 1es *tud*comput.
o a/ee0,mput.
o a;functo as. Negatovwain les/* *1 rdn rrors, positovwain les1 rdnftwg es *speciK cbut nhimalaevetrs./* */ap Z_OK:n y d d n   d n0,ap Z_SvarAM_END:n y d d1,ap Z_hEED_DICT:n y d d 2,ap Z_ERRNO:n y d d n  -1,ap Z_SvarAM_ERROR:n y -2,ap Z_DATA_ERROR:n y d -3,t_di/  MEM_ERROR:n y d-4,ap Z_BUF_ERROR:n y d d-5,t_di/  VERSION_ERROR:n-6,r= d/*f0,mput.
o a;s vel  */ap Z_NO_COMPRESSION:n y d d n0,ap Z_BEST_SPEED:n y d d n   d1,ap Z_BEST_COMPRESSION:n y d d9,ap Z_DEFAULT_COMPRESSION:n y-1,a
ap Z_FILTERED:n y d d n   d d1,ap Z_HUFFMAN_ONLY:n y d d n  2,ap Z_RLE:n y d d n   d dddddd3,ap Z_FIXED:n y d d n   d d   4,ap Z_DEFAULT_SvaATEGY:n y d d0,r= d/*fPo.
opediin les1ofel eleata_rypelfiil;
(xprepenseefuo=====()) */ap Z_BINARY:n y d d n   d d  0,ap Z_TEXT:n y d d n   d ddddd1,t_di/  ASCII:n y d d n   d dd1,di/a= Z_TEXT== eputcKt g)ap Z_UNKNOWN:n y d d n   d dd2,r= d/*fThdede===== 0,mput.
o a;method */ap Z_DEFLATED:n y d d n   d d8t_di/  his.:n y d d n   d dddturndi/aUse -1eort u leitline,ueep on ifa a;var rype
};a=
a***/p}),
a**161t*/ta***/p(functo a(m  ule,iexportseput
i/aGenSintwg byeCoffeeScript 1.12.6a=/*
PDFPage -breput.etrssa 
tfoleypage inal efPDF documetr
By Dev a;Got tt/**/a
(functo a( putShvar PDFPage;t= dPDFPage = (functo a( putShShvar DEFAULT_MARGINS, SIZES;t= d_bfuncto alPDFPage(documetr, s  o as putShorrrvar dimetso as,t      t is.documetra=+documetrvailorus ===s  o asf==a u l putShorrrrrs  o asf= {};t Dor d}/* ussst is._vali=rs  o as._vali||='letts ',t      t is.layress(Bs  o as.layress||='portrait'vailorus ===rypeofes  o as.margin =   'numbas' putShorrrrrt is.marginsth;{r n   d dddtop:es  o as.margin,r n   d dddleft:es  o as.margin,r n   d dddbottom:es  o as.margin,r n   d dddright:es  o as.marginr n   d d};t Dor d}slevel{ailor d_bt is.marginsth;s  o as.marginss||=DEFAULT_MARGINS;t Dor d}/* usssdimetso asth;ADicy.isADicy(t is._val) ?st is._vali: SIZES[t is._val.toUpperCas=()],t      t is.widst.=adimetso as[t is.layress(   'portrait' ?s0i: 1],t      t is.height.=adimetso as[t is.layress(   'portrait' ?s1 :  ],t      t is.contetra=+t is.documetr.ref(),t      t is.ut.oulcesa=+t is.documetr.ref({ailor d_bProcSet:e['PDF',p'TXxS',p'ImageB',p'ImageC',p'ImageI']t Dor d}),t      Objfct.de=ineProperties(l is,t{ailor d_bfonts:;{r n   d dddget:e(functo a(_l is putShoror d_b_bred

fufuncto a( putShShhhhhhhhhhhvar batw;tShShhhhhhhhhhhred

fu(batwa= _t is.ut.oulces>data).Fonti!   u le? batw.Fonti: batw.Fonti= {};t Dor d   d d};t Dor dor d})(l is)r n   d d},r n   d dxobjfcts:;{r n   d dddget:e(functo a(_l is putShoror d_b_bred

fufuncto a( putShShhhhhhhhhhhvar batw;tShShhhhhhhhhhhred

fu(batwa= _t is.ut.oulces>data).XObjfcti!   u le? batw.XObjfcti: batw.XObjfcti= {};t Dor d   d d};t Dor dor d})(l is)r n   d d},r n   d dexr_g c;
es:;{r n   d dddget:e(functo a(_l is putShoror d_b_bred

fufuncto a( putShShhhhhhhhhhhvar batw;tShShhhhhhhhhhhred

fu(batwa= _t is.ut.oulces>data).ExtGSh;
et!   u le? batw.ExtGSh;
et: batw.ExtGSh;
et= {};t Dor d   d d};t Dor dor d})(l is)r n   d d},r n   d dpatts ns:;{r n   d dddget:e(functo a(_l is putShoror d_b_bred

fufuncto a( putShShhhhhhhhhhhvar batw;tShShhhhhhhhhhhred

fu(batwa= _t is.ut.oulces>data).Patts nt!   u le? batw.Patts nt: batw.Patts nt= {};t Dor d   d d};t Dor dor d})(l is)r n   d d},r n   d dan miato as:;{r n   d dddget:e(functo a(_l is putShoror d_b_bred

fufuncto a( putShShhhhhhhhhhhvar batw;tShShhhhhhhhhhhred

fu(batwa= _t is.dicto aary.data).An mist!   u le? batw.An mist: batw.An mist= [];t Dor d   d d};t Dor dor d})(l is)r n   d d}t Dor d}),t      t is.dicto aarya=+t is.documetr.ref({ailor d_bType: 'Page',r n   d dParetr:+t is.documetr._root.data.Pages,r n   d dMediaBox:e[0,e0,tt is.widst, t is.height],r n   d dContetrs: t is.contetr,r n   d dRt.oulces: t is.ut.oulcest Dor d}),t    }/
or dPDFPage.protorype.maxYth;functo a( putShShhhred

fut is.height.-bt is.margins.bottom,t    };/
or dPDFPage.protorype.wr. S h;functo a(chunw putShororred

fut is.contetr.wr. S(chunw ,t    };/
or dPDFPage.protorype. nde=afuncto a( putShShhht is.dicto aary. nd(),t      t is.ut.oulces. nd(),t      red

fut is.contetr. nd(),t    };/
or dDEFAULT_MARGINSth;{r n   dtop:e72,r n   dleft:e72,r n   dbottom:e72,r n   dright:e72t    };/
or dSIZESth;{r n   d'4A0':e[4767.87,h6740.79],r n   d'2A0':e[3370.39, 4767.87],r n   dA0:e[2383.94, 3370.39],r n   dA1:e[1683.78,h2383.94],r n   dA2:e[1190.55, 1683.78],r n   dA3:e[841.89, 1190.55],r n   dA4:e[595.28,h841.89],r n   dA5:e[419.53,d595.28],r n   dA6:e[297.64,h419.53],r n   dA7:e[209.76,d297.64],r n   dA8:e[147.40,h209.76],r n   dA9:e[104.88,h147.40],r n   dA10:e[73.70, 104.88],r n   dB0:e[2834.65, 4008.19],r n   dB1:e[2004.09,h2834.65],r n   dB2:e[1417.32,h2004.09],r n   dB3:e[1000.63,d1417.32],r n   dB4:e[708.66,h1000.63],r n   dB5:e[498.90, 708.66],r n   dB6:e[354.33, 498.90],r n   dB7:e[249.45, 354.33],r n   dB8:e[175.75,d249.45],r n   dB9:e[124.72,h175.75],r n   dB10:e[87.87,h124.72],r n   dC0:e[2599.37,h3676.54],r n   dC1:e[1836.85,d2599.37],r n   dC2:e[1298.27,h1836.85],r n   dC3:e[918.43,h1298.27],r n   dC4:e[649.13, 918.43],r n   dC5:e[459.21,h649.13],r n   dC6:e[323.15,d459.21],r n   dC7:e[229.61,h323.15],r n   dC8:e[161.57, 229.61],r n   dC9:e[113.39, 161.57],r n   dC10:e[79.37,h113.39],r n   dRA0:e[2437.80, 3458.27],r n   dRA1:e[1729.13, 2437.80],r n   dRA2:e[1218.90, 1729.13],r n   dRA3:e[864.57, 1218.90],r n   dRA4:e[609.45, 864.57],r n   dSRA0:e[2551.18,h3628.35],r n   dSRA1:e[1814.17,h2551.18],r n   dSRA2:e[1275.59, 1814.17],r n   dSRA3:e[907.09,h1275.59],r n   dSRA4:e[637.80, 907.09],r n   dEXECUTIVE:e[521.86,h756.00],r n   dFOLIO:e[612.00, 936.00],r n   dLEGAL:e[612.00, 1008.00],r n   dLETTER:e[612.00, 792.00],r n   dTABLOID:e[792.00, 1224.00]t    };/
or dred

fuPDFPage;t= d})( ;t= dm  ule.exportsth;PDFPage;t=}).ca l(l is);a=
a***/p}),
a**162t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
i/aGenSintwg byeCoffeeScript 1.12.6a(functo a( putShvar PDFGradietr, PDFLinearGradietr, PDFRadialGradietr, namedColors, ref;t= dref og__webpack_require__(163), PDFGradietrl=rref.PDFGradietr, PDFLinearGradietrl=rref.PDFLinearGradietr, PDFRadialGradietrl=rref.PDFRadialGradietr;t= dm  ule.exportsth;utShor nitColor:afuncto a( putShShhht is._opacityRege *ryt= {};t Dor dt is._opacityC unta= 0,t      red

fut is._gradC unta= 0,t    },r n  _nhimalizeColor:afuncto a(color putShorrrvar ha_,[parrvailorus ===colorl lst/
  of PDFGradietr putShorrrrrred

fucolor;t Dor d}/* usss ===rypeofecolorl(   ' *ring' putShorrrrr ===color.charAt(0 p=   '#' putShShhhhhhh ===color.  are l=   4 putShShhhhhhhhhcolorl(hcolor.replace(/#([0-9A-F])([0-9A-F])([0-9A-F])/i, "#$1$1$2$2$3$3"  /* usssssss}/* ussssss ha_b(BparseInt=color.slice(1), 16  /* ussssssscolorl(h[ha_b
/*16, ha_b
/*8s.pendi, ha_b.pendi];t Dor d  }slevel ===namedColors[color] putShShhhhhhhcolorl(hnamedColors[color];t Dor d  }t Dor d}/* usss ===ADicy.isADicy(color  putShorrrrr ===color.  are l=   3 putShShhhhhhhcolorl(h(functo a( putShShhhhhhhhhvar i, lFi,f osult ;= d_borrrrrrr osult t= [];t Dor d   d dt le(i = 0,hllit(Bcolor.  are ; i < lFi; i++ putShorrrrrrrrrrrparrt(Bcolor[i];=_dor d_b       osult .push(parrt/h255  /* usssssssss}= d_borrrrrrr od

fu osult ;= d_borrrrr})( ;t Dor d  }slevel ===color.  are l=   4 putShShhhhhhhcolorl(h(functo a( putShShhhhhhhhhvar i, lFi,f osult ;= d_borrrrrrr osult t= [];t Dor d   d dt le(i = 0,hllit(Bcolor.  are ; i < lFi; i++ putShorrrrrrrrrrrparrt(Bcolor[i];=_dor d_b       osult .push(parrt/h100  /* usssssssss}= d_borrrrrrr od

fu osult ;= d_borrrrr})( ;t Dor d  }tShorrrrrred

fucolor;t Dor d}/* usssred

futurn, th  },r n  _setColor:afuncto a(color,ruhroke putShorrrvar op,aspace;t Dor dcolorl(ht is._nhimalizeColor(color vailorus ===!color putShorrr_bred

fufaltw;tShShhh}/* usssop =buhroke ? 'SCN' : ' cn'vailorus ===colorl lst/
  of PDFGradietr putShorrrrrt is._setColorSpace('Patts n',ruhroke ;t Dor d  color.apply(op)at Dor d}slevel{ailor d_bspace (Bcolor.  are l=   4 ? 'DeviceCMYK' : 'DeviceRGB'ng_boror dt is._setColorSpace(space,ruhroke ;t Dor d  color (Bcolor.join(' ')ng_boror dt is.addContetr=colorl+ " " + op)at Dor d}t      red

futrue, th  },r n  _setColorSpace:afuncto a(space,ruhroke putShorrrvar op;/* usssop =buhroke ? 'CS' : 'cs'ng_bororred

fut is.addContetr="/" + space + " " + op)at Dor},r n  ei lColor:afuncto a(color,ropacity putShorrrvar setng_bororsetr=dt is._setColor(color,rfaltw vailorus ===set putShorrrrrt is.ei lOpacity(opacity ;t Dor d}/* ussst is._ei lColort= [color,ropacity]ng_bororred

fut isat Dor},r n  uhrokeColor:afuncto a(color,ropacity putShorrrvar setng_bororsetr=dt is._setColor(color,rtrue vailorus ===set putShorrrrrt is.uhrokeOpacity(opacity ;t Dor d}/* usssred

fut isat Dor},r n  opacity:afuncto a(opacity putShorrrt is._doOpacity(opacity,ropacity ng_bororred

fut isat Dor},r n  ei lOpacity:afuncto a(opacity putShorrrt is._doOpacity(opacity,r u l ng_bororred

fut isat Dor},r n  uhrokeOpacity:afuncto a(opacity putShorrrt is._doOpacity( u l,ropacity ng_bororred

fut isat Dor},r n  _doOpacity:afuncto a(ei lOpacity, uhrokeOpacity putShorrrvar dicto aary, id, key, name, ref1vailorus ===!((ei lOpacityt!   u l p|| (uheokeOpacityt!   u l ) putShorrrrrred

f;t Dor d}/* usss ===ei lOpacityt!   u l p{ailor d_bfi lOpacityt= Math.max(0,hMath.min(1,bfi lOpacity) ;t Dor d}/* usss ===uheokeOpacityt!   u l l{ailor d_buheokeOpacityt= Math.max(0,hMath.min(1,buhrokeOpacity  ;t Dor d}/* ussskey = ei lOpacityt+ "_" + shrokeOpacityvailorus ===t is._opacityRege *ry[key] putShorrrrrref1r=dt is._opacityRege *ry[key], dicto aarya=+ref1[0], namea=+ref1[1],t      }slevel{ailor d_bdicto aarya=+utShorrrrrrrType: 'ExtGSh;
e't Dor d  }ng_boror d ===ei lOpacityt!   u l p{ailor d_b_bdicto aary.ca = ei lOpacity;t Dor d  }tShorrrrr ===uheokeOpacityt!   u l l{ailor d_b_bdicto aary.CA =buhrokeOpacity;t Dor d  }tShorrrrrdicto aarya=+t is.ref(dicto aary)ng_boror ddicto aary. nd(),t      rr de=a++t is._opacityC unt,t      rrnamea=+"Gs" + idng_boror dt is._opacityRege *ry[key]t= [dicto aary, name];t Dor d}/* ussst is.page.exr_g c;
es[name].=adicto aaryng_bororred

fut is.addContetr="/" + namea+ " gs")at Dor},r n  linearGradietr:afuncto a(x1,by1,bx2,by2 putShororred

futew PDFLinearGradietr(l is,tx1,by1,bx2,by2 at Dor},r n  radialGradietr:afuncto a(x1,by1,br1,bx2,by2,br2 putShororred

futew PDFRadialGradietr(l is,tx1,by1,br1,bx2,by2,br2 ,t    }/  };/
ornamedColorsa=+utShoraliceblue:e[240,h248,h255],r n  antiquewhite:e[250,h235,d215],r n  aqua:e[0,e255,h255],r n  aquamar ie:e[127,e255,h212],r n  azure:e[240,h255,h255],r n  beige:e[245,d245, 220],r n  bisque:e[255,h228,h196],r n  black:e[0,e0,t0],r n  blanchedalmond:e[255,h235,d205],r n  blue:e[0,e0,t255],r n  blueviolet:e[138,d43,d226],r n  brown:e[165,d42,d42],r n  burlywood:e[222,h184, 135],r n  cadetblue:e[95, 158,h160],r n  chartreuse:e[127,e255,h0],r n  chocolate:e[210, 105, 30],r n  coral:e[255,h127,e80],r n  cornffowerblue:e[100, 149, 237],r n  cornsilk:e[255,h248,h220],r n  crimson:e[220,h20,h60],r n  cyan:e[0,e255,h255],r n  darkblue:e[0,e0,t139],r n  darkcyan:e[0,e139, 139],r n  darkgoldenrod:e[184, 134, 11],r n  darkgray:e[169, 169, 169],r n  darkgreen:e[0,e100,t0],r n  darkgrey:e[169, 169, 169],r n  darkkhaki:e[189, 183,h107],r n  darkmagenta:e[139,e0,t139],r n  darkolivegreen:e[85,d107, 47],r n  darko ange:e[255,h140,t0],r n  darkorchid:e[153,d50,h204],r n  darkred:e[139,e0,t0],r n  darksalmon:e[233,d150, 122],r n  darkseagreen:e[143,h188,h143],r n  darkslateblue:e[72,h61,t139],r n  darkslategray:e[47, 79, 79],r n  darkslategrey:e[47, 79, 79],r n  darkd

quoise:e[0,e206,h209],r n  darkviolet:e[148,e0,t211],r n  deepp ik:e[255,h20, 147],r n  deepskyblue:e[0,e191,h255],r n  dimgray:e[105, 105, 105],r n  dimgrey:e[105, 105, 105],r n  dodgerblue:e[30, 144,h255],r n  firebrick:e[178,h34, 34],r n  fforalwhite:e[255,h250,h240],r n  fout.Igreen:e[34, 139,e34],r n  fuchsia:e[255,h0,t255],r n  gaflsboro:e[220,h220,h220],r n  ghostwhite:e[248,h248,h255],r n  gold:e[255,h215,h0],r n  goldenrod:e[218,h165,d32],r n  gray:e[128,h128,h128],r n  grey:e[128,h128,h128],r n  green:e[0,e128,h0],r n  greenyeufow:e[173,e255,h47],r n  honeydew:e[240,h255,h240],r n  hotp ik:e[255,h105, 180],r n   lrianred:e[205, 92, 92],r n   lrigo:e[75,e0,t130],r n   vory:e[255,h255,h240],r n  khaki:e[240,h230, 140],r n  lav on r:e[230,h230, 250],r n  lav on rbst.
:e[255,h240,h245],r n  lawngreen:e[124,d252,h0],r n  lemonchiffon:e[255,h250,h205],r n  lightblue:e[173,e216, 230],r n  lightcoral:e[240,h128,h128],r n  lightcyan:e[224,d255,h255],r n  lightgoldenrodyeufow:e[250,h250,h210],r n  lightgray:e[211,h211,t211],r n  lightgreen:e[144,h238, 144],r n  lightgrey:e[211,h211,t211],r n  lightp ik:e[255,h182,h193],r n  lightsalmon:e[255, 160, 122],r n  lightseagreen:e[32,h178, 170],r n  lightskyblue:e[135,d206, 250],r n  lightslategray:e[119,h136, 153],r n  lightslategrey:e[119,h136, 153],r n  lightsteelblue:e[176,h196,h222],r n  lightyeufow:e[255,h255,h224],r n  lime:e[0,e255,h0],r n  limegreen:e[50,h205,d50],r n  linen:e[250,h240,h230],r n  magenta:e[255,h0,t255],r n  maroon:e[128,h0,t0],r n  mediumaquamar ie:e[102,h205,d170],r n  mediumblue:e[0,e0,t205],r n  mediumorchid:e[186,h85,d211],r n  mediumpurple:e[147,h112,h219],r n  mediumseagreen:e[60, 179, 113],r n  mediumslateblue:e[123,h104,h238],r n  mediumspringgreen:e[0,e250,h154],r n  mediumd

quoise:e[72,h209,h204],r n  mediumvioletred:e[199, 21,h133],r n  midnightblue:e[25,d25,d112],r n  mint    m:e[245,d255,h250],r n  mistyrose:e[255,h228,h225],r n  moccasin:e[255,h228,h181],r n  navajowhite:e[255,h222,h173],r n  navy:e[0,e0,t128],r n  oldlace:a[253,d245, 230],r n  olive:e[128,h128,h0],r n  olivedrab:e[107,h142,d35],r n  o ange:e[255,h165,h0],r n  o angered:e[255,h69, 0],r n  o chid:e[218,h112,h214],r n  palegoldenrod:e[238,h232,d170],r n  palegreen:e[152,h251, 152],r n  paled

quoise:e[175,d238,h238],r n  palevioletred:e[219,h112,h147],r n  papayawhip:e[255,h239, 213],r n  p a gpuff:e[255,h218,h185],r n  p ru:e[205, 133,d63],r n  p ik:e[255,h192,h203],r n  plum:e[221,h160,h221],r n  powderblue:e[176,d224,d230],r n  purple:e[128,h0,t128],r n  red:e[255,h0,t0],r n  rosybrown:e[188,h143,h143],r n  royalblue:e[65,h105, 225],r n  saddlebrown:e[139, 69, 19],r n  salmon:e[250,h128,h114],r n  sandybrown:e[244,h164,h96],r n  seagreen:e[46, 139,e87],r n  seasheuf:e[255,h245,h238],r n  sietna:e[160,h82,h45],r n  silv r:e[192,h192,h192],r n  skyblue:e[135,d206, 235],r n  slateblue:e[106, 90,t205],r n  slategray:e[112,h128,h144],r n  slategrey:e[112,h128,h144],r n  snow:e[255,h250, 250],r n  springgreen:e[0,e255,h127],r n  steelblue:e[70,t130, 180],r n  tan:e[210, 180, 140],r n  teal:e[0,h128,h128],r n  l istle:e[216,e191,h216],r n  tomato:e[255,h99, 71],r n  d

quoise:e[64,h224,d208],r n  violet:e[238, 130,h238],r n  wheat:e[245,d222,h179],r n  white:e[255,h255,h255],r n  whitesmoke:e[245,d245, 245],r n  yeufow:e[255,h255,h0],r n  yeufowgreen:e[154,h205,d50]
  };/
}).ca l(l is);a=
a***/p}),
a**163t*/ta***/p(functo a(m  ule,iexportseput
i/aGenSintwg byeCoffeeScript 1.12.6a(functo a( putShvar PDFGradietr, PDFLinearGradietr, PDFRadialGradietr,r n  ext nde=afuncto a(child,[paretr pudt le(var key in[paretr pud ===pasProp.ca l(paretr, key)) child[key]t= paretr[key]; }bfuncto alctor( puut is.constructor (Bchild; }bctor.protorypet= paretr.protorype;Bchild.protorypet= tew ctor( ;Bchild.__sup r__t= paretr.protorype;Bred

fuchild; },r n  hasPropt= {}.hasOwnProperty;t= dPDFGradietrl=r(functo a( putShShfuncto alPDFGradietr(doc putShShhht is.doca=+doc;t Dor dt is.stop t= [];t Dor dt is.embeddwg =bfaltw;tShShhht is.vrans=himt= [1,h0,t0, 1,h0,t0];t Dor dt is._colorSpacet= 'DeviceRGB'ng_bor}/
or dPDFGradietr.protorype.stope=afuncto a(pos, color,ropacity putShorrr ===s acityt==a u l putShorrrrrs acityt= 1;t Dor d}/* usssopacityt= Math.max(0,hMath.min(1,bopacity  ;t Dor dt is.stop .push([pos, t is.doc._nhimalizeColor(color ,ropacity] ng_bororred

fut isat Dor};/
or dPDFGradietr.protorype.setTrans=himt= functo a(m11,tm12,hm21,hm22,hdx,hdy putShorrrt is.vrans=himt= [m11,tm12,hm21,hm22,hdx,hdy]ng_bororred

fut isat Dor};/
or dPDFGradietr.protorype.embedt= functo a(m putShorrrvar bts.ds, en /  ,efn, phim, grad,[g c;
e, i, j, k,tlues, lFi,fopacityPatts n,ypageBBo_,[patts n,yref, ref1, shader,buhop,astop , vvailorus ===t is.stop .  are l=   0 putShorrrrrred

f;t Dor d}/* ussst is.embeddwg =btrue, th  _bt is.matri_b(Bm, th  _bluest=dt is.stop [t is.stop .  are l- 1],t       ===lues[0]t< 1 putShorrrrrt is.uhop .push([1,tlues[1],tlues[2]] ;t Dor d}/* usssbts.dst= [];t Dor den /  t= [];t Dor dstop t= [];t Dor dt le(i = j = 0,href ogt is.stop .  are l- 1; 0 <  ref ? j < ref : j > ref; i = 0 <  ref ? ++j : --j putShorrrrren /  .push(0, 1),t      rr ===i + 2 !   t is.stop .  are  l{ailor d_b_bbts.ds.push(t is.stop [icn 1][0] ;t Dor d  }tShorrrrrfna=+t is.doc.ref({ailor d_b  Functo aType: 2,r n   dddddDomain:e[0,h1],r n   dddddC0:et is.stop [icn 0][1],r n   dddddC1:et is.stop [icn 1][1],r n   dddddN: 1t Dor d  }availor d_buhop .push(fnavailor d_bfn. nd(),t      }/* usss ===uhop .  are l=   1 putShorrrrrfna=+stop [0],t      }slevel{ailor d_bfna=+t is.doc.ref({ailor d_b  Functo aType: 3,r n   dddddDomain:e[0,h1],r n   dddddFuncto as:astop ,r n   dddddBts.ds: bts.ds,r n   dddddEn /  :ren /  t Dor d  }availor d_bfn. nd(),t      }/* ussst is. de=a'Sh' +B(++t is.doc._gradC unt),t      shader ogt is.shader(fnavailor dshader. nd(),t      patts nt= t is.doc.ref({ailor d_bType: 'Patts n',ailor d_bPatts nType: 2,r n   dddShading: shader,r n   dddMatri_:h(functo a( putShShhhhhhhvar k, lFi,f of1,  osult ;= d_borrrrrref1r=dt is.matri_;= d_borrrrrresult t= [];t Dor d   dt le(k = 0,hllit(Bref1.  are ; k < lFi; k++ putShorrrrrrrrrva=+ref1[k];=_dor d_b     osult .push(+v.toFixed(5)availor d_bss}= d_borrrrr od

fu osult ;= d_borrr}).ca l(l is)t      }),t      patts n. nd(),t       ===t is.stop .some(functo a(stop putShorrr_bred

fustop[2]t< 1,t      }) putShorrrrrgradr=dt is.opacityGradietr(availor d_bgrad._colorSpacet= 'DeviceGray'ng_boror dref1r=dt is.stop vailor d_bf le(k = 0,hllit(Bref1.  are ; k < lFi; k++ putShorrrrrrrstope=aref1[k];=_dor d_b  grad.stop(stop[0], [stop[2]] ;t Dor d  }tShorrrrrgradr=dgrad.embed(t is.matri_ ;t Dor d  pageBBo_t= [0,e0,tt is.doc.page.widst, t is.doc.page.height]vailor d_bf lma=+t is.doc.ref({ailor d_b  Type: 'XObjfct',r n   dddddSubtype: 'F lm',r n   dddddF lmType: 1,r n   dddddBBox:epageBBo_,r n   dddddGroup:putShorrrrrrrrrType: 'Group',r n   dddddddS: 'Transparetcy',r n   dddddddCS: 'DeviceGray'ailor d_bss},r n   dddddRt.oulces: utShorrrrrrrrrProcSet:e['PDF',p'TXxS',p'ImageB',p'ImageC',p'ImageI'],r n   dddddddPatts n: utShorrrrrrrrrddSh1:egradtShorrrrrrrrr}ailor d_bss}= d_borrr}availor d_bf lm.wr. S("/Patts ntcs /Sh1 scn"availor d_bf lm. nd((pageBBo_.join(" "))a+ " reip"availor d_bg c;
ea=+t is.doc.ref({ailor d_b  Type: 'ExtGSh;
e',r n   dddddSMask:putShorrrrrrrrrType: 'Mask',r n   dddddddS: 'Luminosity',r n   dddddddG:bf lmailor d_bss}= d_borrr}availor d_bg c;
e. nd(),t      rropacityPatts na=+t is.doc.ref({ailor d_b  Type: 'Patts n',ailor d_b_bPatts nType: 1,ailor d_b_bPaintType: 1,ailor d_b_bTilingType: 2,r n   dddddBBox:epageBBo_,r n   dddddXStep:epageBBo_[2],r n   dddddYStep:epageBBo_[3],r n   dddddRt.oulces: utShorrrrrrrrrProcSet:e['PDF',p'TXxS',p'ImageB',p'ImageC',p'ImageI'],r n   dddddddPatts n: utShorrrrrrrrrddSh1:epatts ntShorrrrrrrrr},r n   dddddddExtGSh;
e: utShorrrrrrrrrddGs1:eg c;
etShorrrrrrrrr}ailor d_bss}= d_borrr}availor d_bopacityPatts n.wr. S("/Gs1eg  /Patts ntcs /Sh1 scn"availor d_bopacityPatts n. nd((pageBBo_.join(" "))a+ " reip"availor d_bt is.doc.page.patts ns[t is. d] =bopacityPatts n,t      }slevel{ailor d_bt is.doc.page.patts ns[t is. d] =bpatts n,t      }g_bororred

fupatts n,t    };/
or dPDFGradietr.protorype.applyt= functo a(op putShorrrvar dx,hdy,hm,hm0,hm1,tm11,tm12,hm2,hm21,hm22,hm3,hm4,hm5,yref, ref1ng_bororrefa=+t is.doc._ctm.slice(),hm0e=aref[0], m1e=aref[1],tm2e=aref[2],tm3e=aref[3],tm4e=aref[4],tm5e=aref[5]ng_bororref1r=dt is.vrans=him,tm11a=+ref1[0], m12a=+ref1[1],hm21a=+ref1[2],tm22a=+ref1[3],tdxa=+ref1[4],tdya=+ref1[5]ng_borormt= [m0 *tm11a+tm2e*tm12,hm1 *tm11a+tm3e*tm12,hm0 *tm21a+tm2e*tm22,hm1 *tm21a+tm3e*tm22,hm0 *tdxa+tm2e*tdyt+ m4,hm1 *tdxa+tm3e*tdyt+ m5],t       ===!(t is.embeddwg && m.join(" ")l=   t is.matri_.join(" ")) putShorrrrrt is.embed(m ;t Dor d}/* usssred

fut is.doc.addContetr="/" + t is. de+ " " + op)at Dor};/
or dred

fuPDFGradietr;t= d})( ;t= dPDFLinearGradietrl=r(functo a(sup rClues putShorext nd(PDFLinearGradietr, sup rClues ;t= d_bfuncto alPDFLinearGradietr(doc,tx1,by1,bx2,by2 putShShhht is.doca=+doc;t Dor dt is.x1a=+x1;t Dor dt is.y1a=+y1;t Dor dt is.x2a=+x2;t Dor dt is.y2a=+y2;t Dor dPDFLinearGradietr.__sup r__.constructor.apply(l is,targumetrs),t    }/
or dPDFLinearGradietr.protorype.shader ogfuncto a(en putShororred

fut is.doc.ref({ailor d_bShadingType: 2,r n   dddColorSpace:at is._colorSpace,r n   dddCoords: [t is.x1,dt is.y1,dt is.x2,dt is.y2],r n   dddFuncto a:efn,r n   dddExt nd: [true,rtrue]t Dor d}),t    };/
or dPDFLinearGradietr.protorype.opacityGradietrth;functo a( putShShhhred

futew PDFLinearGradietr(l is.doc,tt is.x1,dt is.y1,dt is.x2,dt is.y2)at Dor};/
or dred

fuPDFLinearGradietr;t= d})(PDFGradietr ;t= dPDFRadialGradietrl=r(functo a(sup rClues putShorext nd(PDFRadialGradietr, sup rClues ;t= d_bfuncto alPDFRadialGradietr(doc,tx1,by1,br1,bx2,by2,br2 putShorort is.doca=+doc;t Dor dt is.x1a=+x1;t Dor dt is.y1a=+y1;t Dor dt is.r1a=+r1;t Dor dt is.x2a=+x2;t Dor dt is.y2a=+y2;t Dor dt is.r2a=+r2;t Dor dPDFRadialGradietr.__sup r__.constructor.apply(l is,targumetrs),t    }/
or dPDFRadialGradietr.protorype.shader ogfuncto a(en putShororred

fut is.doc.ref({ailor d_bShadingType: 3,r n   dddColorSpace:at is._colorSpace,r n   dddCoords: [t is.x1,dt is.y1,dt is.r1,dt is.x2,dt is.y2,dt is.r2],r n   dddFuncto a:efn,r n   dddExt nd: [true,rtrue]t Dor d}),t    };/
or dPDFRadialGradietr.protorype.opacityGradietrth;functo a( putShShhhred

futew PDFRadialGradietr(l is.doc,tt is.x1,dt is.y1,dt is.r1,dt is.x2,dt is.y2,dt is.r2)at Dor};/
or dred

fuPDFRadialGradietr;t= d})(PDFGradietr ;t= dm  ule.exportsth;utShorPDFGradietr: PDFGradietr,
or dPDFLinearGradietr: PDFLinearGradietr,
or dPDFRadialGradietr:dPDFRadialGradietr
  };/
}).ca l(l is);a=
a***/p}),
a**164t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
i/aGenSintwg byeCoffeeScript 1.12.6a(functo a( putShvar KAPPA, SVGPath,anumbas,r n  slic t= [].slice;t= dSVGPath og__webpack_require__(165 ;t= dnumbasiog__webpack_require__(26).numbas;t= dKAPPAiog4.0 *t((Math.sqrt(2 p- 1.0) t 3.0 ;t= dm  ule.exportsth;utShor nitVector:afuncto a( putShShhht is._ctmt= [1,h0,t0, 1,h0,t0];t Dor dred

fut is._ctmSh;ckt= [];t Dor},r n  save:afuncto a( putShShhht is._ctmSh;ck.push(t is._ctm.slice()),t      red

fut is.addContetr='q')ng_bor},r n  restore:afuncto a( putShShhht is._ctmr=dt is._ctmSh;ck.pop( p|| [1,h0,t0, 1,h0,t0];t Dor dred

fut is.addContetr='Q')ng_bor},r n  closePath:afuncto a( putShShhhred

fut is.addContetr='h')ng_bor},r n  lineWidst:afuncto a(w putShShhhred

fut is.addContetr=(numbas(w )a+ " w")at Dor},r n  _CAP_STYLES:nutShShhhBUTT: 0,ap     ROUND:n1,ailor dSQUARE: 2g_bor},r n  lineCap:afuncto a(c putShorrr ===rypeofecl(   ' *ring' putShorrrrrcr=dt is._CAP_STYLES[c.toUpperCas=()],t      }/* usssred

fut is.addContetr=ca+ " J")at Dor},r n  _JOIN_STYLES:nutShShhhMITER:e0,ap     ROUND:n1,ailor dBEVEL: 2g_bor},r n  lineJoin:efuncto a(j putShorrr ===rypeofejl(   ' *ring' putShorrrrrjr=dt is._JOIN_STYLES[j.toUpperCas=()],t      }/* usssred

fut is.addContetr=ja+ " j")at Dor},r n  mits Limit: functo a(m putShorrrred

fut is.addContetr=(numbas(m )a+ " M")at Dor},r n  dast:afuncto a(l are , s  o as putShorrrvar phas=,yref, space,rvvailorus ===s  o asf==a u l putShorrrrrs  o asf= {};t Dor d}/* usssi===   re l= a u l putShorrrrrred

fut isat Dor d}/* usss ===ADicy.isADicy(  are   putShoror dle re l=t((functo a( putShShhhhhhhvar i, lFi,f osult ;= d_borrrrrresult t= [];t Dor d   dt le(i = 0,hllit(Ble re .  are ; i < lFi; i++ putShorrrrrrrrrvt(Ble re [i];=_dor d_b     osult .push(numbas(v)availor d_bss}= d_borrrrr od

fu osult ;= d_borrr})()).join(' ')ng_boror dphas= h;s  o as.phas= || 0,t      orred

fut is.addContetr="[" + le re l+ "] " + (numbas(phas= )a+ " d"availor d}slevel{ailor d_bspace (B(refa=+s  o as._pace)t!   u le? ref :   are ;g_boror dphas= h;s  o as.phas= || 0,t      orred

fut is.addContetr="[" + (numbas(  are   p+ " " + (numbas(_pace))l+ "] " + (numbas(phas= )a+ " d"availor d}t Dor},r n  undast:afuncto a( putShorrrred

fut is.addContetr="[] 0 d"availor},r n  moveTo:afuncto a(x,by putShorrrred

fut is.addContetr=(numbas(x  p+ " " + (numbas(y  p+ " m")at Dor},r n  lineTo:afuncto a(x,by putShorrrred

fut is.addContetr=(numbas(x  p+ " " + (numbas(y  p+ " l")at Dor},r n  bezierCurveTo:afuncto a(cp1x,bcp1y,bcp2x,bcp2y,bx,by putShorrrred

fut is.addContetr=(numbas(cp1x  p+ " " + (numbas(cp1y  p+ " " + (numbas(cp2x  p+ " " + (numbas(cp2y  p+ " " + (numbas(x  p+ " " + (numbas(y  p+ " c")at Dor},r n  quadinticCurveTo:afuncto a(cpx,bcpy,bx,by putShorrrred

fut is.addContetr=(numbas(cpx  p+ " " + (numbas(cpy  p+ " " + (numbas(x  p+ " " + (numbas(y  p+ " v")ng_bor},r n  rect:afuncto a(x,by, w, h putShorrrred

fut is.addContetr=(numbas(x  p+ " " + (numbas(y  p+ " " + (numbas(w  p+ " " + (numbas(h))a+ " re")ng_bor},r n  rts.dedRect:afuncto a(x,by, w, h,f  putShorrrvar c;t Dor d ===rl= a u l putShorrrrrr = 0,t      }/* usssrt= Math.min(r,t0.5 *tw,t0.5 *thavailor dcr=dr *t(1.0p- KAPPA ;t Dor dt is.moveTo(xa+tr,by ;t Dor dt is.lineTo(xa+tw -br,by ;t Dor dt is.bezierCurveTo(xa+tw -bc,by, xa+tw,by +dc, xa+tw,by +dr ;t Dor dt is.lineTo(xa+tw,by +d l- r ;t Dor dt is.bezierCurveTo(xa+tw,by +d l- c, xa+tw -bc,by +d , xa+tw -br,by +d  ;t Dor dt is.lineTo(xa+tr,by +d  ;t Dor dt is.bezierCurveTo(xa+tc,by +d , x,by +d l- c, x,by +d l- r ;t Dor dt is.lineTo(x,by +dr ;t Dor dt is.bezierCurveTo(x,by +dc, xa+tc,by, xa+tr,by ;t Dor dred

fut is.closePath()ng_bor},r n  ellipse:afuncto a(x,by, r1,dr2 putShororvar ox,boy, xe,rxm,bye,rym;t Dor d ===r2l= a u l putShorrrrrr2a=+r1;t Dor d}/* usss_b-  r1;t Dor dyb-  r2;t Dor do_t= r1 *tKAPPA;t Dor doya=+r2 *tKAPPA;t Dor dx= h;xa+tr1 *t2;t Dor dy= h;y +dr2 *t2;t Dor dxm h;xa+tr1;t Dor dym h;y +dr2;t Dor dt is.moveTo(x,rym ;t Dor dt is.bezierCurveTo(x,byma- oy, xma- ox,by, xm,by ;t Dor dt is.bezierCurveTo(xm + ox,by, xe,byma- oy, xe,rym ;t Dor dt is.bezierCurveTo(xe,byma+ oy, xma+ ox,bye,rxm,bye ;t Dor dt is.bezierCurveTo(xm - ox,bye,rx,byma+ oy, x,rym ;t Dor dred

fut is.closePath()ng_bor},r n  circle:afuncto a(x,by, radius putShorrrred

fut is.ellipse(x,by, radius ng_bor},r n  arc:afuncto a(x,by, radius,fuh;rtAfole, endAfole, antictinuwise putShorrrvar HALF_PI, TWO_PI, ax2]ay,bcp1x,bcp1y,bcp2x,bcp2y,bcurAfo,ueeltaAfo,ueeltaCx,ueeltaCy, dir, pundleLFi,fi,anumSegs,yref, segAfo,usegIdx;t Dor d ===antictinuwisel= a u l putShorrrrrantictinuwisel=ufaltw;tShShhh}/* usssTWO_PIl=u2.0 *tMath.PI;tShShhhHALF_PI = 0.5 *tMath.PI;tShShhheeltaAfo = endAfole - uh;rtAfole;t Dor d ===Math.abs(eeltaAfo) >sTWO_PI put       ddeltaAfo = TWO_PIvailor d}slevel === eltaAfo !     && antictinuwisel!   = eltaAfo < 0  putShoror ddir = antictinuwisel? -1e: 1,t       ddeltaAfo = dir *sTWO_PIl+ddeltaAfo;tShShhh}/* usssnumSegst= Math.ceil=Math.abs(eeltaAfo) /hHALF_PIavailor dsegAfo = deltaAfo /snumSegsvailor dpundleLFi (B(segAfo /hHALF_PIa *tKAPPA *tradiusvailor dcurAfoa=+st;rtAfole;t Dor deeltaCxa=+-Math.sin(curAfoa *tpundleLFi;t Dor deeltaCyt= Math.cos(curAfoa *tpundleLFi;t Dor dax h;xa+tMath.cos(curAfoa *tradiusvailor day h;y +dMath.sin(curAfoa *tradiusvailor dt is.moveTo(ax2]ayavailor dt le(segIdx h;i = 0,href ognumSegsv 0 <  ref ? i < ref : i > ref; segIdx h;0 <  ref ? ++i : --i putShorrrrrcp1x = axl+ddeltaC_;= d_borrrcp1y = ayl+ddeltaCy;t Dor d  curAfoa+=dsegAfo;t Dor d  ax h;xa+tMath.cos(curAfoa *tradiusvailor d day h;y +dMath.sin(curAfoa *tradiusvailor d deeltaCxa=+-Math.sin(curAfoa *tpundleLFi;t Dor d deeltaCyt= Math.cos(curAfoa *tpundleLFi;t Dor d bcp2x = axl-ddeltaC_;= d_borrrcp2y = ayl-ddeltaCy;t Dor d  t is.bezierCurveTo(cp1x,bcp1y,bcp2x,bcp2y,bax2]ayavailor d}/* usssred

fut isat Dor},r n  polygon:afuncto a( putShorrrvar i, lFi,fpoflr,fpoflrsvailor dpoflrs hB1  =targumetrs.  are l? slic .ca l(argumetrs, 0 p: [];t Dor dt is.moveTo.apply(l is,tpoflrs.shift()),t      t le(i = 0,hllit(Bpoflrs.  are ; i < lFi; i++ putShorrrrrpoflr (Bpoflrs[i];=_dor d_bt is.lineTo.apply(l is,tpoflr ;t Dor d}/* usssred

fut is.closePath()ng_bor},r n  path:afuncto a(path putShorrrSVGPath.apply(l is,tpath ;t Dor dred

fut isat Dor},r n  _wion ifRule:afuncto a(rule putShorrr ===/evet-?odd/.test(rule  putShorrrrrred

fu'*';t Dor d}/* usssred

fu''at Dor},r n  ei l:afuncto a(color,rrule putShorrr ===/(evet-?odd)|(not-?zero)/.test(color  putShorrrrrrule =ucolor;t Dor dhhcolorl(hnurn, th   d}/* usss ===color putShorrr_bt is.ei lColor(color vailorus}/* usssred

fut is.addContetr='f' + t is._wion ifRule(rule  at Dor},r n  uhroke:afuncto a(color putShorrr ===color putShorrr_bt is.uhrokeColor(color vailorus}/* usssred

fut is.addContetr='S')ng_bor},r n  ei lAndShroke:afuncto a(ei lColor, uhrokeColor,rrule putShorrrvar isFi lRule;t Dor d ===uhrokeColorl= a u l putShorrrrruhrokeColorl= ei lColor, th   d}/* usss sFi lRulel= /(evet-?odd)|(not-?zero)/;t Dor d === sFi lRule.test(ei lColor  putShorrrrrrule =uei lColor, th   d  ei lColorl(hnurn, th   d}/* usss === sFi lRule.test(uhrokeColor  putShorrrrrrule =uuhrokeColor;tShorrrrruhrokeColorl= ei lColor, th   d}/* usss ===ei lColor putShorrr_bt is.ei lColor(ei lColor ;tShorrr_bt is.uhrokeColor(uhrokeColor vailorus}/* usssred

fut is.addContetr='B' + t is._wion ifRule(rule  at Dor},r n  clip:afuncto a(rule putShorrrred

fut is.addContetr='W' + t is._wion ifRule(rule  + ' n')ng_bor},r n  vrans=him: functo a(m11,tm12,hm21,hm22,hdx,hdy putShorrrvar m,hm0,hm1,tm2,hm3,hm4,hm5,yv, in led;tShorrrmr=dt is._ctm;tShorrrm0e=am[0], m1e=am[1],tm2e=am[2],tm3e=am[3],tm4e=am[4],tm5e=am[5]ng_bororm[0]t= m0 *tm11a+tm2e*tm12ng_bororm[1]t= m1 *tm11a+tm3e*tm12ng_bororm[2]t= m0 *tm21a+tm2e*tm22ng_bororm[3]t= m1 *tm21a+tm3e*tm22ng_bororm[4]t= m0 *tdxa+tm2e*tdyt+ m4ng_bororm[5]t= m1 *tdxa+tm3e*tdyt+ m5;tShorrrva les1=t((functo a( putShShhhhhvar i, lFi,f of,f osult ;= d_borrrref og[m11,tm12,hm21,hm22,hdx,hdy]ng_bororrrresult t= [];t Dor d  t le(i = 0,hllit(Bref.  are ; i < lFi; i++ putShorrrrrrrva=+ref[i];=_dor d_b   osult .push(numbas(v)availor d_b}tShorrrrrred

fu osult ;= d_bor})()).join(' ')ng_bororred

fut is.addContetr=va les1+ " cm")at Dor},r n  vranslate:efuncto a(x,by putShorrrred

fut is.vrans=him(1,h0,t0, 1,hx,by ;t Dor},r n  rttate:efuncto a(afole, s  o as putShorrrvar cos, rad,[ref, sin,hx,bx1,by,+y1;t Dor d ===s  o asf==a u l putShorrrrrs  o asf= {};t Dor d}/* usssradr=dafole *tMath.PIt/h180,t      cost= Math.cos(radavailor dsin =dMath.sin(radavailor dx h;y = 0,t       ===s  o as.orig i1!   u l l{ailor d_brefa=+s  o as.orig i, xe=aref[0], ye=aref[1]vailor d_bx1a=+x * cost- ye*dsinvailor d_by1a=+x * sin + ye*dcosvailor d_bxb-  x1,t       dyb-  y1;t Dor d}/* usssred

fut is.vrans=him(cos, sin,h-sin,hcos, x,by ;t Dor},r n  sca e:efuncto a(xFactor,byFactor,bs  o as putShorrrvar ref, x,by,t       ===yFactorf==a u l putShorrrrryFactorf= xFactor, th   d}/* usss ===s  o asf==a u l putShorrrrrs  o asf= {};t Dor d}/* usssi===rypeofeyFactorf=== "objfct" putShorrrrrs  o asf= yFactor, th   drryFactorf= xFactor, th   d}/* usssx h;y = 0,t       ===s  o as.orig i1!   u l l{ailor d_brefa=+s  o as.orig i, xe=aref[0], ye=aref[1]vailor d_bxb-  xFactorf* x,t       dyb-  yFactorf* y;t Dor d}/* usssred

fut is.vrans=him(xFactor,b0,t0, yFactor,bx,by ;t Dor}
  };/
}).ca l(l is);a=
a***/p}),
a**165t*/ta***/p(functo a(m  ule,iexportseput
i/aGenSintwg byeCoffeeScript 1.12.6a(functo a( putShvar SVGPath;t= dSVGPath og(functo a( putShShvar apply,tarcToSegmetrs, cx,bcy,[parameters, parse, p_,[py, runners, segmetrToBezier, solveArc, s_,[sy;t= d_bfuncto alSVGPath( pu}/
or dSVGPath.applyth;functo a(doc,tpath putShorrrvar commundsvailor dcommunds (Bparse(path ;t Dor dred

fuapply(communds,+doc)at Dor};/
or dparameters =+utShorrrA: 7,ailor da: 7,ailor dC: 6,rilor dc: 6,rilor dH:n1,ailor dh:n1,ailor dL: 2,r n   dl: 2,r n   dM: 2,r n   dm: 2,r n   dQ: 4,ap     q: 4,ap     S: 4,ap     s: 4,ap     T: 2,r n   dt: 2,r n   dV:n1,ailor dv:n1,ailor dZ:e0,ap     z:e0t Dor};/
or dparsS h;functo a(path putShorrrvar args,yc,tcmd,bcurArg, phundDecimal, j, lFi,fparams,yret;t Dor dredt= [];t Dor dargst= [];t Dor dcurArgt= "",t      t undDecimall=ufaltw;tShShhhparams = 0,t      t le(j = 0,hllit(Bpae .  are ; j < lFi; j++ putShorrrrrct(Bpae [j]vailor d_b ===parameters[c]t!   u l l{ailor d_b_bparams = parameters[c];=_dor d_b   ===cmd putShorrrrrrrrr ===curArg.  are l> 0 putShorrrrr Dor dargs[args.  are ]t= +curArg;tShorrrrr Dor}= d_borrrrrrr od[ od.  are ]t= utShorrrrr Dor dcmd:tcmd,tShorrrrr Dor dargs:dargstShorrrrr Dor};tShorrrrr Dorargst= [];t Dor d Dor dcurArgt= "",t            t undDecimall=ufaltw;tShShhh Dor}= d_borrrrrcmd =ucvailor d_b}slevel ===(cl(   " " ||ecl(   "," p|| (cl(   "-" && curArg.  are l> 0 && curArg[curArg.  are l- 1]l!   'e' p|| (cl(   "." && t undDecimal) putShorrrrr D ===curArg.  are l=   0 putShorrrrrrrrrcontinuw;tShShhh Dor}= d_borrrrr ===args.  are l=   params putShorrrrrrrrr od[ od.  are ]t= utShorrrrr Dor dcmd:tcmd,tShorrrrr Dor dargs:dargstShorrrrr Dor};tShorrrrr Dorargst= [+curArg];t Dor d Dor d ===cmdl(   "M" putShorrrrr Dor dcmd =u"L";tShorrrrr Dor}= d_borrrrrrr ===cmdl(   "m" putShorrrrr Dor dcmd =u"l";tShorrrrr Dor}= d_borrrrr}slevel{ailor d_b Dorargs[args.  are ]t= +curArg;tShorrrrr D}= d_borrrrrt undDecimall=ucl(   ".";tShorrrrr DcurArgt= cl(   '-' ||ecl(   '.' ?sc : ''vailor d_b}slevel{tShorrrrr DcurArgt+=ucvailor d_brr ===cl(   '.' putShorrrrr Dort undDecimall=utrue, th  _brr D}= d_borrr}t Dor d}/* usss ===curArg.  are l> 0 putShorrrrr ===args.  are l=   params putShorrrrrrr od[ od.  are ]t= utShorrrrr Dorcmd:tcmd,tShorrrrr Dorargs:dargstShorrrrr D};tShorrrrr Dargst= [+curArg];t Dor d Dor ===cmdl(   "M" putShorrrrr Dorcmd =u"L";tShorrrrr D}= d_borrrrr ===cmdl(   "m" putShorrrrr Dorcmd =u"l";tShorrrrr D}ailor d_b}slevel{tShorrrrr Dargs[args.  are ]t= +curArg;tShorrrrr}t Dor d}/* usss od[ od.  are ]t= utShorrrrrcmd:tcmd,tShorrrrrargs:dargstShorrr};tShorrrred

fu otat Dor};/
or dcxe=acyth;p_b(Bpyth;s_b(Bsy = 0,t
or dapplyth;functo a(communds,+doc)putShorrrvar c, i, j, lFi,fname;t Dor dcxe=acyth;p_b(Bpyth;s_b(Bsy = 0,t Dor dt le(i = j = 0,hllit(Bcommunds.  are ; j < lFi; i = ++j putShorrrrrct(Bcommunds[i];=_dor d_bi===rypeoferunners[namea=+c.cmd]l(   "functo a" putShorrrrr Drunners[name](doc,tc.argsavailor d_b}tShorrr}/* usssred

fucxe=acyth;p_b(Bpyth;0at Dor};/
or drunnerst= utShorrrM:;functo a(doc,ta putShorrrrrcx = a[0],t       acyth;a[1]vailor d_bp_b(Bpyth;nurn, th   d ;s_b(Bcx,t       dsy = cy;t Dor d  red

fudoc.moveTo(cx,bcy vailorus},r n   dm: functo a(doc,ta putShorrrrrcx += a[0],t       acyt+h;a[1]vailor d_bp_b(Bpyth;nurn, th   d ;s_b(Bcx,t       dsy = cy;t Dor d  red

fudoc.moveTo(cx,bcy vailorus},r n   dC:;functo a(doc,ta putShorrrrrcx = a[4],t       acyth;a[5]vailor d_bp_b(Ba[2]vailor d_bpyth;a[3];t Dor d  red

fudoc.bezierCurveTo.apply(doc,ta vailorus},r n   dc:;functo a(doc,ta putShorrrrrdoc.bezierCurveTo(a[0]a+tcx2]a[1]t+bcy,[a[2]a+tcx2]a[3]t+bcy,[a[4]a+tcx2]a[5]t+bcy)vailor d_bp_b(Bcx +Ba[2]vailor d_bpyth;cyt+;a[3];t Dor d  cx += a[4];t Dor d  red

fucyt+h;a[5]vailor d},ap     S: functo a(doc,ta putShorrrrr ===pxl(    u l l{ailor d_b_bp_b(Bcx,t       d_bpyth;cyvailor d_b}tShorrrrrdoc.bezierCurveTo(cxl-d=pxl-Bcx),bcyl-d=pyl-dcy), a[0]2]a[1],[a[2]2]a[3])vailor d_bp_b(Ba[0],t       apyth;a[1]vailor d_bc_b(Ba[2]vailor d_bred

fucyth;a[3];t Dor d},ap     s: functo a(doc,ta putShorrrrr ===pxl(    u l l{ailor d_b_bp_b(Bcx,t       d_bpyth;cyvailor d_b}tShorrrrrdoc.bezierCurveTo(cxl-d=pxl-Bcx),bcyl-d=pyl-dcy), cx +Ba[0]2]cyt+;a[1],[cx +Ba[2],;cyt+;a[3])vailor d_bp_b(Bcx +Ba[0],t       apyth;cyt+;a[1];t Dor d  cx += a[2]vailor d_bred

fucyt+h;a[3];t Dor d},ap     Q: functo a(doc,ta putShorrrrrp_b(Ba[0],t       apyth;a[1]vailor d_bc_b(Ba[2]vailor d_bcyth;a[3];t Dor d  red

fudoc.quadinticCurveTo(a[0]2]a[1],[cx,bcy vailorus},r n   dq:;functo a(doc,ta putShorrrrrdoc.quadinticCurveTo(a[0]a+tcx2]a[1]t+bcy,[a[2]a+tcx2]a[3]t+bcy)vailor d_bp_b(Bcx +Ba[0],t       apyth;cyt+;a[1];t Dor d  cx += a[2]vailor d_bred

fucyt+h;a[3];t Dor d},ap     T: functo a(doc,ta putShorrrrr ===pxl(    u l l{ailor d_b_bp_b(Bcx,t       d_bpyth;cyvailor d_b}slevel{tShorrrrr Dp_b(Bcx -d=pxl-Bcx),t       d_bpyth;cyl-d=pyl-dcy)vailor d_b}tShorrrrrdoc.quadinticCurveTo(p_,[py, a[0]2]a[1])vailor d_bp_b(Bcx -d=pxl-Bcx),t       dpyth;cyl-d=pyl-dcy)vailor d_bcx = a[0],t       ared

fucyth;a[1];t Dor d},ap     t: functo a(doc,ta putShorrrrr ===pxl(    u l l{ailor d_b_bp_b(Bcx,t       d_bpyth;cyvailor d_b}slevel{tShorrrrr Dp_b(Bcx -d=pxl-Bcx),t       d_bpyth;cyl-d=pyl-dcy)vailor d_b}tShorrrrrdoc.quadinticCurveTo(p_,[py, cx +Ba[0]2]cyt+;a[1]);t Dor d  cx += a[0],t       ared

fucyt+h;a[1];t Dor d},ap     A: functo a(doc,ta putShorrrrrsolveArc(doc,tcx,bcy,[a)vailor d_bcx = a[5],t       ared

fucyth;a[6];t Dor d},ap     a: functo a(doc,ta putShorrrrra[5]t+(Bcx,t       da[6]t+(Bcyvailor d_bsolveArc(doc,tcx,bcy,[a)vailor d_bcx = a[5],t       ared

fucyth;a[6];t Dor d},ap     L:;functo a(doc,ta putShorrrrrcx = a[0],t       acyth;a[1]vailor d_bp_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dl: functo a(doc,ta putShorrrrrcx += a[0],t       acyt+h;a[1]vailor d_bp_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dH:;functo a(doc,ta putShorrrrrcx = a[0],t       ap_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dh: functo a(doc,ta putShorrrrrcx += a[0],t       ap_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dV: functo a(doc,ta putShorrrrrcy = a[0],t       ap_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dv: functo a(doc,ta putShorrrrrcy += a[0],t       ap_b(Bpyth;nurn, th   d ;red

fudoc.lineTo(cx,bcy vailorus},r n   dZ: functo a(doc putShorrrrrdoc.closePath()ng_borrrrrcx = sx,t       ared

fucyth;syvailorus},r n   dz: functo a(doc putShorrrrrdoc.closePath()ng_borrrrrcx = sx,t       ared

fucyth;syvailorus}ailor};/
or dsolveArcth;functo a(doc,tx,by, coords)putShorrrvar bez,iex,iey, j, large, lFi,f osult , rtt, rx,iry, seo,usegs, sweep;/* usssr_b(Bcoords[0]2]rya=+coords[1],[rtta=+coords[2], largea=+coords[3],tsweepa=+coords[4],te_b(Bcoords[5],teya=+coords[6];t Dor dsegst= arcToSegmetrs(ex,iey, rx,iry, large, sweep, rtt, x,by ;t Dor dresult t= [];t Dor dt le(j = 0,hllit(Bsegs.  are ; j < lFi; j++ putShorrrrrsegt(Bsegs[j]vailor d_bbezt(BsegmetrToBezier.apply( u l,rseg),t       aresult .push(doc.bezierCurveTo.apply(doc,tbez  ;t Dor d}/* usssred

fu osult ;= d_b};/
or darcToSegmetrsth;functo a(x,by, rx,iry, large, sweep, rttateX, ox,boy putShorrrvar a00,ta01,ta10, a11,tcos_e , d, i, j, pl,f of,f osult, segmetrs, sfactor,bsfactor_sq, sin_st, t , t 0,tt 1,dt 2,dt 3,dt _arc, x0,bx1,bxc,by0,by1,byc;t Dor dt th;rttateX *t(Math.PIt/h180availor dsin_t th;Math.sin(th ;t Dor dcos_e  = Math.cos(th ;t Dor drx = Math.abs(rx),t      ry = Math.abs(ry ;t Dor dp_b(Bcos_e  *t(oxl-Bxa *t0.5 +dsin_t t*t(oyl-dya *t0.5;t Dor dpyb(Bcos_e  *t(oyl-dya *t0.5 - uin_t t*t(oxl-Bxa *t0.5;t Dor dpll=u=pxl*dp_) /h(rx *trx  + =pyl*dpy) /h(ryl*dry ;t Dor d ===pl > 1 putShorrrrrpll=uMath.sqrt(pl),t       arx *(Bpn, th   d ;ry *(Bpn, th   d}/* usssa00b(Bcos_e  /arx;/* usssa01a=+uin_t t/arx;/* usssa10b(B(-uin_t ) /hryng_borora11a=+cos_e  /aryng_bororx0b(Ba00b*do_t+sa01a*doyng_borory0b(Ba10b*do_t+sa11a*doyng_bororx1a=+a00b*d_t+sa01a*dyng_borory1b(Ba10b*d_t+sa11a*dyng_borord =u(x1a-Bx0a *t(x1a-Bx0a + =y1a-By0a *t(y1a-By0availor dsfactor_sq hB1 /rd -t0.25;t Dor d ===sfactor_sq < 0 putShorrrrrsfactor_sq hB0,t      }/* ussssfactorl=uMath.sqrt(sfactor_sq ;t Dor d ===sweepa=   large putShorrrrrsfactorl=u-sfactor,t      }/* usssxcth;0.5 *t(x0b+rx1 p- sfactorl*t(y1a-By0availor dycth;0.5 *t(y0b+ry1a + sfactorl*t(x1a-Bx0a;t Dor dt 0 = Math.atan2(y0b-Byc, x0a-Bxca;t Dor dt 1 = Math.atan2(y1b-Byc, x1a-Bxca;t Dor dt _arc =dt 1 -dt 0;t Dor d ===t _arc < 0 && sweepa=   1 putShorrrrrt _arc += 2 *tMath.PI;tShShhh}slevel ===t _arc > 0 && sweepa=   0 putShorrrrrt _arc -= 2 *tMath.PI;tShShhh}t Dor dsegmetrsth;Math.ceil=Math.abs(t _arc /t(Math.PIt*t0.5 +d0.001)) ;t Dor dresultt= [];t Dor dt le(i = j = 0,href ogsegmetrs; 0 <  ref ? j < ref : j > ref; i = 0 <  ref ? ++j : --j putShorrrrrt 2 =dt 0b+rit*tt _arc /tsegmetrs;tShorrrrrt 3 =dt 0b+r=i + 1)t*tt _arc /tsegmetrs;tShorrrrrresult[i]t= [xc,byc,dt 2,dt 3,drx,iry, sin_st, cos_e ],t      }/* usssred

furesult;= d_b};/
or dsegmetrToBezierth;functo a(cx,bcy,[t 0,tt 1,drx,iry, sin_st, cos_e  putShorrrvar a00,ta01,ta10, a11,tt,dt _half,bx1,bx2,dx3,by1,by2,by3;/* usssa00b(Bcos_e  *trx;/* usssa01a=+-uin_t t*tryng_borora10a=+uin_t t*trx;/* usssa11a=+cos_e  *tryng_borort _halfth;0.5 *t(t 1 -dt 0a;t Dor dt =u(8 t 3) *tMath.sin(th_halft*t0.5) *tMath.sin(th_halft*t0.5) /tMath.sin(th_halfavailor dx1b(Bcx +BMath.cos(th0 p- t *tMath.sin(th0availor dy1th;cyt+;Math.sin(th0a + t *tMath.cos(th0 vailor dx3b(Bcx +BMath.cos(th1),t      y3th;cyt+;Math.sin(th1),t      x2a=+x3 + t *tMath.sin(th1),t      y2a=+y3p- t *tMath.cos(th1),t      red

fu[a00b*d_1t+sa01a*dy1,ta10b*d_1t+sa11a*dy1,ta00b*d_2t+sa01a*dy2,ta10b*d_2t+sa11a*dy2,ta00b*d_3t+sa01a*dy3,ta10b*d_3t+sa11a*dy3];t Dor};/
or dred

fuSVGPath;t= d})( ;t= dm  ule.exportsth;SVGPath;t=}).ca l(l is);a=
a***/p}),
a**166t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
i/aGenSintwg byeCoffeeScript 1.12.6a(functo a( putShvar PDFFotr;t= dPDFFotr og__webpack_require__(50 ;t= dm  ule.exportsth;utShor nitFotrs:afuncto a( putShorrrt is._fotrFamiliesf= {};t Dor dt is._fotrC unt hB0,t      t is._fotrSizea=+12,t      t is._fotrth;nurn, th   dt is._rege *eredFotrsf= {};t Dor dt Dor},r n  eotr:afuncto a(src, family, size putShorrrvar cacheKey, eotr, id,[ref;t Dor d ===typeofefamilyl(   'numbas' putShorrrrrsizea=+family;tShorrrrrfamilyl(hnurn, th   d}/* usss ===typeofesrcl(   ' *ring' && t is._rege *eredFotrs[src] putShorrrrrcacheKeya=+urc;tShorrrrrrefa=+t is._rege *eredFotrs[src],esrcl(Bref.src, familyl(Bref.family;tShorrr}slevel{tShorrrrrcacheKeya=+familyl||+urc;tShorrrrr ===rypeofecacheKeya!   ' *ring' putShorrrrrrrcacheKeya=+nurn, th   d ;}t Dor d}/* usss ===sizea!   u l l{ailor d_bt is.eotrSize=size ;t Dor d}/* usss ===eotrth;t is._fotrFamilies[cacheKey] l{ailor d_bt is._fotrth;fotr;tShorrrrrred

fut isat Dor d}/* usss de=a'F' +B(++t is._fotrC unt),t      t is._fotrth;PDFFotr.open(l is,tsrc, family, id ;t Dor d ===eotrth;t is._fotrFamilies[t is._fotr.name] l{ailor d_bt is._fotrth;fotr;tShorrrrrred

fut isat Dor d}/* usss ===cacheKey l{ailor d_bt is._fotrFamilies[cacheKey]th;t is._fotr, th   d}/* usss ===t is._fotr.name l{ailor d_bt is._fotrFamilies[t is._fotr.name]th;t is._fotr, th   d}/* usssred

fut isat Dor},r n  eotrSize:afuncto a(_fotrSize putShorrrt is._fotrSizea=+_fotrSize;/* usssred

fut isat Dor},r n  curretrLineHeight:afuncto a(includeGap putShorrr === ncludeGapf==a u l putShorrrrr ncludeGapf=ufaltw;tShShhh}/* usssred

fut is._fotr.lineHeight(t is._fotrSize,r ncludeGap)ng_bor},r n  rege *erFotr:afuncto a(name,tsrc, family putShorrrt is._rege *eredFotrs[name]th;utShorrrrrsrc:asrc,tShorrrrrfamily:rfamilytShShhh};/* usssred

fut isat Dor}
  };/
}).ca l(l is);a=
a***/p}),
a**167t*/ta***/p(functo a(m  ule,iexports, __webpack_require__eput
"uvel *rict";
a**WEBPACK VAR INJECTIONt*/(functo a(Buffer, procees put
functo al_in*eropDefaultt(ex pusred

fu(ex && =rypeofeexl(   'objfct' p&& 'default' in[ex p?[ex['default'] : ex; }/
var ra=+_in*eropDefault(__webpack_require__(168) ;tvar _Objfct$getOwnPropertyDescriptora=+_in*eropDefault(__webpack_require__(197) ;tvar _getItSintora=+_in*eropDefault(__webpack_require__(60) ;tvar _Objfct$freezea=+_in*eropDefault(__webpack_require__(209) ;tvar _Objfct$keysa=+_in*eropDefault(__webpack_require__(212) ;tvar _rypeofe=+_in*eropDefault(__webpack_require__(69) ;tvar _Objfct$definePropertye=+_in*eropDefault(__webpack_require__(74) ;tvar _cluesCa lCheckt= _in*eropDefault(__webpack_require__(106) ;tvar _crentwCluest= _in*eropDefault(__webpack_require__(107) ;tvar _Mapf=u_in*eropDefault(__webpack_require__(225) ;tvar _possibleConstructorRed

fu=u_in*eropDefault(__webpack_require__(236) ;tvar _inheritsa=+_in*eropDefault(__webpack_require__(237) ;tvar restructure_src_utils og__webpack_require__(12 ;tvar _Objfct$definePropertiesf= _in*eropDefault(__webpack_require__(245) ;tvar isEquall=u_in*eropDefault(__webpack_require__(248) ;tvar _Objfct$uesigfu=u_in*eropDefault(__webpack_require__(251) ;tvar _S*ring$fromCodePoflr (B_in*eropDefault(__webpack_require__(255) ;tvar _ADicy$from (B_in*eropDefault(__webpack_require__(258) ;tvar _Ser (B_in*eropDefault(__webpack_require__(263) ;tvar uni /  t= _in*eropDefault(__webpack_require__(269) ;tvar Uni /  Tri t= _in*eropDefault(__webpack_require__(43) ;tvar Sh;
eMachinet= _in*eropDefault(__webpack_require__(271) ;tvar _Numbas$EPSILONt= _in*eropDefault(__webpack_require__(280) ;tvar cloneDeepa=+_in*eropDefault(__webpack_require__(283) ;tvar infl;
ea=+_in*eropDefault(__webpack_require__(79) ;tvar brotlia=+_in*eropDefault(__webpack_require__(284) ;t
/
var fotrkitf= {};tfotrkit.logErrorst= faltw;t
var format t= [];tfotrkit.rege *erFormatth;functo a==eormat putShformat .push(format ;
};/
fotrkit.openSyncth;functo a==eilename,tpostscriptName l{ailvar buffer og__webpack_require__(8).readFileSync=eilename)ng_bred

fufotrkit.crentw(buffer, postscriptName ;
};/
fotrkit.openth;functo a==eilename,tpostscriptName, ca lback l{ail ===rypeofepostscriptNamel(   'functo a' putShorca lback =epostscriptNameat DorpostscriptNamel(+nurn, th}/
or__webpack_require__(8).readFile=eilename,tfuncto a==err, buffer putShor ===err putShorrrred

fuca lback=err at Dor}
t DortryputShorrrvar fotrth;fotrkit.crentw(buffer, postscriptName ;
 Dor}ucatch==e putShorrrred

fuca lback=e at Dor}
t Dorred

fuca lback= u l,rfotr at D} ;t= dred

f;t};/
fotrkit.crentwth;functo a==buffer, postscriptName putShfore(var i = 0; i < format .  are ; i++ putShorvar formatth;format [i];=_dor ===eormat.probw(buffer))putShorrrvar fotrth;tew eormat(tew r.De /  S*ream(buffer));t Dor d ===postscriptName putShShorrrred

fufotr.getFotr=postscriptName ;tShShhh}/
Shorrrred

fufotrat Dor}
  }/
Shthrow;tew Error('Unknowfufotr eormat' ;
};/
a**
 *sT is de /intoracacheshthedresult tofea get*er oramethod such=that
t*tt edresult tare lazilylcomputwg once, andtt enacached.
t*t@priv;
etS*/tfuncto alcache(targer, key,ueescriptor l{ail ===eescriptor.get putShorvar ger (Beescriptor.getat Doreescriptor.getth;functo a==)putShorrrvar va leth;get.ca l(l is);aShorrr_Objfct$defineProperty(l is,tkey,u{ va le: va let}availor dred

fuva le;t Dor};/hh}slevel ===typeofeeescriptor.va leth   'functo a' putShorvar fn (Beescriptor.va le;tt Dorred

fuutShorrrger:afuncto arger( putShShhhhhvar cacheth;tew _Map()ng_borrrrrfuncto armemoized( putShShhhhhhhfore(var _llit(Bargumetrs.  are ,Dargst= ADicy(_lli), _keyth;0a _keyt< _llia _key++ putShorrrrrrrrrargs[_key]t= argumetrs[_key];tShorrrrrrr}/
Shorrrhhhhvar keyth;args.  are l> 0 ?rargs[0] : 'va le';tShorrrrrrr ===cache.has(key)) utShorrrrrrrrrred

fucache.ger(key);tShorrrrrrr}/
Shorrrhhhhvar resultt= fn.apply(l is,targs);tShorrrrrrrcache.ser(key,f osult);tShorrrrrrrred

furesult;= d_b Dor};/= d_b Dor_Objfct$defineProperty(l is,tkey,u{ va le: memoizedr}availor d_bred

fumemoized;tShShhh}/* us};/hh}
}/
var SubHeader ogtew r.Struct({ailfirstC/  :rr.uin*16,riletrryC unt:rr.uin*16,rilidDelta:rr.in*16,rilidRangeOffset:rr.uin*16
} ;t=var CmapGroup ogtew r.Struct({ailst;rtCharC/  :rr.uin*32,riletdCharC/  :rr.uin*32,rilglyphID:rr.uin*32
} ;t=var Uni /  Va leRange ogtew r.Struct({ailst;rtUni /  Va le:rr.uin*24,ap addito aalC unt:rr.uin*8
} ;t=var UVSMappifoa=+tew r.Struct({ailuni /  Va le:rr.uin*24,ap glyphID:rr.uin*16
} ;t=var DefaultUVSa=+tew r.ADicy(Uni /  Va leRange,rr.uin*32 ;tvar NonDefaultUVSa=+tew r.ADicy(UVSMappifo,rr.uin*32 ;ttvar VarSelectorRe /ida=+tew r.Struct({ailvarSelector:rr.uin*24,ap defaultUVS:+tew r.Poflrer(r.uin*32, DefaultUVS,u{ type: 'parett'p}),
  nonDefaultUVS:+tew r.Poflrer(r.uin*32, NonDefaultUVS,u{ type: 'parett'p})
} ;t=var CmapSubtable ogtew r.Verso aedStruct(r.uin*16, utSh0:u{ // Bytwten / ifo/* us  are :rr.uin*16, // Totalltable   are lin bytwse(set to 262hforeformatt0)t    language:rr.uin*16, // Language  /  tforel isten / ifo subtable, orazeror ==language-independetr
     /  Map:atew r.LazyADicy(r.uin*8, 256)t  },/= d2:u{ // High-bytw mappifoa(CJK)/* us  are :rr.uin*16,t    language:rr.uin*16,t    subHeaderKeys:+tew r.ADicy(r.uin*16, 256),t    subHeaderC unt:rfuncto arsubHeaderC unt(t putShorrrred

fuMath.max.apply(Math,at.subHeaderKeys ;t Dor},r n  subHeaders:atew r.LazyADicy(SubHeader, 'subHeaderC unt'),t    glyphIndexADicy:atew r.LazyADicy(r.uin*16, 'subHeaderC unt')t  },/= d4:u{ // Segmetr mappifoato deltarva les/* us  are :rr.uin*16, // Totalltable   are lin bytwst    language:rr.uin*16, // Language  /  r n  segC untX2:rr.uin*16,t    segC unt:rfuncto arsegC unt(t putShorrrred

fut.segC untX2 >> 1,t    },r n  searchRange:rr.uin*16,t    etrrySelector:rr.uin*16,t    rangeShift:rr.uin*16,t    etdC/  :rtew r.LazyADicy(r.uin*16, 'segC unt'),t    reservedPad:rtew r.Reserved(r.uin*16), // T istva letshould beazeror n  st;rtC/  :rtew r.LazyADicy(r.uin*16, 'segC unt'),t    idDelta:rtew r.LazyADicy(r.in*16, 'segC unt'),t    idRangeOffset:rtew r.LazyADicy(r.uin*16, 'segC unt'),t    glyphIndexADicy:atew r.LazyADicy(r.uin*16, functo a==t putShorrrred

fu(t.  are l- t._curretrOffset) /t2,t    })t  },/= d6:u{ // Trimmedrtable/* us  are :rr.uin*16,t    language:rr.uin*16,t    firstC/  :rr.uin*16,rililetrryC unt:rr.uin*16,ril  glyphIndices: tew r.LazyADicy(r.uin*16, 'etrryC unt')t  },/= d8:u{ // mixed 16-bit andt32-bit coveraget    reserved:rtew r.Reserved(r.uin*16),/* us  are :rr.uin*32,t    language:rr.uin*16,t    is32:atew r.LazyADicy(r.uin*8, 8192),/* usnGroups:rr.uin*32,t    groups:rtew r.LazyADicy(CmapGroup, 'nGroups')t  },/= d10:u{ // TrimmedrADicyt    reserved:rtew r.Reserved(r.uin*16),/* us  are :rr.uin*32,t    language:rr.uin*32,t    firstC/  :rr.uin*32,t    etrryC unt:rr.uin*32,t    glyphIndices: tew r.LazyADicy(r.uin*16, 'numChars')t  },/= d12:u{ // Segmetredrcoveraget    reserved:rtew r.Reserved(r.uin*16),/* us  are :rr.uin*32,t    language:rr.uin*32,t    nGroups:rr.uin*32,t    groups:rtew r.LazyADicy(CmapGroup, 'nGroups')t  },/= d13:u{ // Many-to- ae range mappifose(samelasd12 excepr eor group.st;rtGlyphID)t    reserved:rtew r.Reserved(r.uin*16),/* us  are :rr.uin*32,t    language:rr.uin*32,t    nGroups:rr.uin*32,t    groups:rtew r.LazyADicy(CmapGroup, 'nGroups')t  },/= d14:u{ // Uni /   Variato alSequen es/* us  are :rr.uin*32,t    numRe /ids:rr.uin*32,t    varSelectors:rtew r.LazyADicy(VarSelectorRe /id, 'numRe /ids')t  }
} ;t=var CmapEtrrya=+tew r.Struct({ailplatformID:rr.uin*16, // Platform idetrifierrilet / ifoID:rr.uin*16, // Platform-specificten / ifo idetrifierriltable:+tew r.Poflrer(r.uin*32, CmapSubtable,u{ type: 'parett', lazy:atruep})
} ;t=// charac*er to glyph mappifotvar cmap ogtew r.Struct({ailverso a:rr.uin*16,t  numSubtables:rr.uin*16,t  tables:rtew r.ADicy(CmapEtrry, 'numSubtables')
} ;t=// fotr headertvar head ogtew r.Struct({ailverso a:rr.in*32, // 0x00010000 (verso a 1.0)
  reviso a:rr.in*32, // set by fotr manufacturerrilcheckSumAdjustment:rr.uin*32,t  magicNumbas:rr.uin*32, // set to 0x5F0F3CF5ailflags:rr.uin*16,t  unitsPerEm:rr.uin*16, // range from 64 to 16384rilcrentwd:+tew r.ADicy(r.in*32, 2),/* m/ ified:+tew r.ADicy(r.in*32, 2),/* xMia:rr.in*16, // eor all glyph b undifo boxes/* yMia:rr.in*16, // eor all glyph b undifo boxes/* xMax:rr.in*16, // eor all glyph b undifo boxes/* yMax:rr.in*16, // eor all glyph b undifo boxes/* macStyle:+tew r.Bitfield(r.uin*16, ['bold', 'italic', 's.derline', 'outline', 'shadow', 'condetsed', 'ext nded']),/* lowestRe PPEM:rr.uin*16, // smallest readable sizeain pixels/* fotrDirecto aHint:rr.in*16,rilindexToLocFormat:rr.in*16, // 0 eor short offsets, 1 eor lofo/* glyphDataFormat:rr.in*16 // 0 eor curretreformat
} ;t=// horizotrallheadertvar hhea ogtew r.Struct({ailverso a:rr.in*32,ap ascent:rr.in*16, // Dist;n e from baselinetofehighest ascenderrileescent:rr.in*16, // Dist;n e from baselinetofelowestleescenderrillineGap:ar.in*16, // Typographictlinetgapap adv;n eWidstMax:rr.uin*16, // Maximum adv;n e widsttva letin 'hmtx'rtable/* minLeftSideBearifo:ar.in*16, // Maximum adv;n e widsttva letin 'hmtx'rtable/* minRightSideBearifo:ar.in*16, // Minimum right sidebearifotva le/* xMaxExt nt:rr.in*16,rilcaretSlopeRise:ar.in*16, // Usedrtouca cul;
eat edslopetofet edcursore(rise/run); 1 eor vertica rilcaretSlopeRun:rr.in*16, // 0 eor vertica rilcaretOffset:rr.in*16, // Set to 0 eor not-slanredrfotrs
  reserved:rtew r.Reserved(r.in*16, 4),/* me*ricDataFormat:rr.in*16, // 0 eor curretreformat
 dnumbasOfMe*rics:rr.uin*16 // Numbastofeadv;n e widststin 'hmtx'rtable/} ;t=var HmtxEtrrya=+tew r.Struct({ailadv;n e:rr.uin*16,t  bearifo:ar.in*16/} ;t=var hmtxa=+tew r.Struct({ailme*rics:rtew r.LazyADicy(HmtxEtrry, functo a==t putShorred

fut.parett.hhea.numbasOfMe*ricsat D} ,t  bearifos: tew r.LazyADicy(r.in*16, functo a==t putShorred

fut.parett.maxp.numGlyphsl- t.parett.hhea.numbasOfMe*ricsat D} 
} ;t=// maxiumum proeile=var maxp ogtew r.Struct({ailverso a:rr.in*32,ap numGlyphs:rr.uin*16, // T ednumbastofeglyphslinet edfotr/* maxPoflrs:rr.uin*16, // Maximum poflrs inea not-composi
eaglyph/* maxContours:rr.uin*16, // Maximum contours inea not-composi
eaglyph/* maxComponettPoflrs:rr.uin*16, // Maximum poflrs inea composi
eaglyph/* maxComponettContours:rr.uin*16, // Maximum contours inea composi
eaglyph/* maxZones:rr.uin*16, // 1r ==instructo asfdo not uvelt edtwilight zote,u2 ot erwise/* maxTwilightPoflrs:rr.uin*16, // Maximum poflrs usedrineZ0/* maxStorage:rr.uin*16, // NumbastofeStoragerADea locato as/* maxFuncto aDefs:rr.uin*16, // NumbastofeFDEFs/* maxInstructo aDefs:rr.uin*16, // NumbastofeIDEFs/* maxSh;ckElemetrs:rr.uin*16, // Maximum sh;cktdeprh/* maxSizeOfInstructo as:rr.uin*16, // Maximum bytw c unt eor glyph instructo as/* maxComponettElemetrs:rr.uin*16, // Maximum numbastofecomponettsBreferen ed at “tops  vel” eor any composi
eaglyph/* maxComponettDeprh:rr.uin*16 // Maximum   vel toferecurso a; 1 eor simpleecomponetts
} ;t=/**
 *sGet tanten / ifo nameafrom platform,ten / ifo, andtlanguage ids.
t*tRed

fed en / ifo nameslcan beausedrinei /nv-li
eato de /   text.tS*/tfuncto algetEn / ifo(platformID,let / ifoID l{ailvar languageIDt(Bargumetrs.  are  >u2 && argumetrs[2]l!   s.defined ?rargumetrs[2]l: 0,t
or ===platformIDa=   1 && MAC_LANGUAGE_ENCODINGS[languageID] putShorred

fuMAC_LANGUAGE_ENCODINGS[languageID], th}/
orred

fuENCODINGS[platformID][et / ifoID], }t=// Mapfofeplatform idsato en / ifo ids.
var ENCODINGSt= [=// uni /  
['utf16be', 'utf16be', 'utf16be', 'utf16be', 'utf16be', 'utf16be'],t=// macin*osh=// Mappifoseavailable at http://uni /  .org/Public/MAPPINGS/VENDORS/APPLE/=// 0	Roman                 17	Malayalam=// 1	Japanese	            18	Sinhalese=// 2	Tradito aal Chinese	  19	Burmese=// 3	KoDean	              20	Khmerr// 4	Arabic	              21	Thair// 5	Hebrew	              22	Laotianr// 6	Greek	                23	Georgianr// 7	Russian	              24	Armetianr// 8	RSymbol	              25	Simplified Chineser// 9	Dev;nagari	          26	Tibetanr// 10	Gurmukhi	            27	Mofoolianr// 11	Gujainti	            28	Geezr// 12	Oriya	                29	Slavicr// 13	B arali	              30	Vietnameser// 14	Tamil	                31	Sindhir// 15	Telugu	              32	(Unilrerpreded)r// 16	Kannada
['macroman', 'shift-jis', 'big5', 'euc-kr', 'iso-8859-6', 'iso-8859-8', 'macgreek', 'maccyrillic', 'symbol', 'Dev;nagari', 'Gurmukhi', 'Gujainti', 'Oriya', 'B arali', 'Tamil', 'Telugu', 'Kannada', 'Malayalam', 'Sinhalese', 'Burmese', 'Khmer', 'macthai', 'Laotian', 'Georgian', 'Armetian', 'gb-2312-80', 'Tibetan', 'Mofoolian', 'Geez', 'maccetreuro', 'Vietnamese', 'Sindhi'],t=// ISO==eeprecaded)r['ascii'],t=// wionows=// Docslhere:rhttp://msdn.microsoft.com/en-us/library/system.text.en / ifo(v=vs.110).aspxr['symbol', 'utf16be', 'shift-jis', 'gb18030', 'big5', 'wansung', 'johab',  u l,r u l,r u l,r'utf16be']];t=// Overrides eor Mac scripts by language id.
// See http://uni /  .org/Public/MAPPINGS/VENDORS/APPLE/Readme.txt
var MAC_LANGUAGE_ENCODINGSth;utSh15: 'maciceland',ap 17: 'macd

kish',ap 18: 'maccroatian',
  24: 'maccetreuro',
  25: 'maccetreuro',
  26: 'maccetreuro',
  27: 'maccetreuro',
  28: 'maccetreuro',
  30: 'maciceland',ap 37: 'macromania',ap 38: 'maccetreuro',
  39: 'maccetreuro',
  40: 'maccetreuro',
  143: 'macinuit', // Unsupportwg byei /nv-li
e
  146: 'macgaelic' // Unsupportwg byei /nv-li
e
};t=// Mapfofeplatform idsato BCP-47 language  /  s.
var LANGUAGESt= [=// uni /  
[],u{ // macin*osh=Sh0:u'en', 30: 'fo', 60: 'ks', 90: 'rw',
  1: 'fr', 31: 'fa', 61: 'ku', 91: 'rn',
  2: 'de', 32: 'ru', 62: 'sd', 92: 'ny',
  3: 'it', 33: 'zh', 63: 'bo', 93: 'mg',
  4: 'nl', 34: 'nl-BE', 64: 'ne', 94: 'eo',
  5: 'sv', 35: 'ga', 65: 'sa', 128: 'cy',
  6: 'es', 36: 'sq', 66: 'mr', 129: 'eu',
  7: 'da', 37: 'ro', 67: 'bn', 130: 'ca',ap 8: 'pt', 38: 'cz', 68: 'as', 131: 'la',ap 9: 'no', 39: 'sk', 69: 'gu', 132: 'qu',
  10:u'he', 40: 'si', 70: 'pa', 133: 'gn',
  11: 'ja', 41: 'yi', 71: 'or', 134: 'ay',
  12:u'ar', 42: 'sr', 72: 'ml', 135: 'tt',
  13: 'fi', 43: 'mk', 73: 'kn', 136: 'ug',
  14: 'el', 44: 'bg', 74: 'ta', 137: 'dz',
  15: 'is', 45: 'uk', 75: 'te', 138: 'jv',
  16: 'mt', 46: 'be', 76: 'si', 139: 'su',ap 17: 'tr', 47: 'uz', 77: 'my', 140: 'gl',ap 18: 'hr', 48: 'kk', 78: 'km', 141: 'af',ap 19: 'zh-Hatt', 49: 'az-Cyrl', 79: 'lo', 142: 'br',
  20: 'ur', 50: 'az-Arab', 80: 'vi', 143: 'iu',ap 21: 'hi', 51: 'hy', 81: 'id', 144: 'gd',ap 22: 'th', 52: 'ka', 82: 'tl', 145: 'gv',
  23: 'ko', 53: 'mo', 83: 'ms', 146: 'ga',
  24: 'lt', 54: 'ky', 84: 'ms-Arab', 147: 'to',
  25: 'pl', 55: 'tg', 85: 'am', 148: 'el-polyton',
  26: 'hu', 56: 'tk', 86: 'ti', 149: 'kl',
  27: 'es', 57: 'mn-CN', 87: 'om', 150: 'az',
  28: 'lv', 58: 'mn', 88: 'so', 151: 'nn',
  29: 'se', 59: 'ps', 89: 'sw'
},t=// ISO==eeprecaded)r[],u{ // wionows                                        =Sh0x0436: 'af',h0x4009: 'en-IN',h0x0487: 'rw',h0x0432: 'tn',
  0x041C: 'sq', 0x1809: 'en-IE',h0x0441: 'sw',h0x045B: 'si',
  0x0484: 'gsw',h0x2009: 'en-JM',h0x0457: 'kok',h0x041B: 'sk',
  0x045E: 'am', 0x4409: 'en-MY',h0x0412: 'ko', 0x0424: 'sl',
  0x1401: 'ar-DZ', 0x1409: 'en-NZ',h0x0440: 'ky', 0x2C0A: 'es-AR',
  0x3C01: 'ar-BH', 0x3409: 'en-PH',h0x0454: 'lo', 0x400A: 'es-BO',
  0x0C01: 'ar', 0x4809: 'en-SG', 0x0426: 'lv', 0x340A: 'es-CL',
  0x0801: 'ar-IQ', 0x1C09: 'en-ZA', 0x0427: 'lt', 0x240A: 'es-CO',
  0x2C01: 'ar-JO', 0x2C09: 'en-TT', 0x082E: 'dsb', 0x140A: 'es-CR',
  0x3401: 'ar-KW', 0x0809: 'en-GB', 0x046E: 'lb', 0x1C0A: 'es-DO',
  0x3001: 'ar-LB', 0x0409: 'en', 0x042F: 'mk', 0x300A: 'es-EC',
  0x1001: 'ar-LY', 0x3009: 'en-ZW', 0x083E: 'ms-BN', 0x440A: 'es-SV',
  0x1801: 'ary', 0x0425: 'et',h0x043E: 'ms', 0x100A: 'es-GT',
  0x2001: 'ar-OM',h0x0438: 'fo', 0x044C: 'ml', 0x480A: 'es-HN',
  0x4001: 'ar-QA', 0x0464: 'fil',h0x043A: 'mt', 0x080A: 'es-MX',
  0x0401: 'ar-SA', 0x040B: 'fi', 0x0481: 'mi', 0x4C0A: 'es-NI',
  0x2801: 'ar-SY', 0x080C: 'fr-BE', 0x047A: 'arn', 0x180A: 'es-PA',
  0x1C01: 'aeb', 0x0C0C: 'fr-CA', 0x044E: 'mr', 0x3C0A: 'es-PY',
  0x3801: 'ar-AE', 0x040C: 'fr', 0x047C: 'moh', 0x280A: 'es-PE',
  0x2401: 'ar-YE', 0x140C: 'fr-LU',h0x0450: 'mn', 0x500A: 'es-PR',
  0x042B: 'hy', 0x180C: 'fr-MC', 0x0850: 'mn-CN', 0x0C0A: 'es',
  0x044D: 'as', 0x100C: 'fr-CH',h0x0461: 'ne', 0x040A: 'es',
  0x082C: 'az-Cyrl', 0x0462: 'fy', 0x0414: 'nb', 0x540A: 'es-US',
  0x042C: 'az',h0x0456: 'gl', 0x0814: 'nn', 0x380A: 'es-UY',
  0x046D: 'ba',h0x0437: 'ka', 0x0482: 'oc',h0x200A: 'es-VE',
  0x042D: 'eu', 0x0C07: 'de-AT', 0x0448: 'or', 0x081D: 'sv-FI',
  0x0423: 'be', 0x0407: 'de', 0x0463: 'ps', 0x041D: 'sv',
  0x0845: 'bn', 0x1407: 'de-LI', 0x0415: 'pl', 0x045A: 'syr',
  0x0445: 'bn-IN',h0x1007: 'de-LU',h0x0416: 'pt',h0x0428: 'tg',
  0x201A: 'bs-Cyrl', 0x0807: 'de-CH',h0x0816: 'pt-PT', 0x085F: 'tzm',
  0x141A: 'bs', 0x0408: 'el', 0x0446: 'pa', 0x0449: 'ta',
  0x047E: 'br', 0x046F: 'kl', 0x046B: 'qu-BO', 0x0444: 'tt',
  0x0402: 'bg', 0x0447: 'gu', 0x086B: 'qu-EC', 0x044A: 'te',
  0x0403: 'ca', 0x0468: 'ha', 0x0C6B: 'qu',h0x041E: 'th',
  0x0C04: 'zh-HK', 0x040D: 'he', 0x0418: 'ro', 0x0451: 'bo',
  0x1404: 'zh-MO', 0x0439: 'hi', 0x0417: 'rm', 0x041F: 'tr',
  0x0804: 'zh', 0x040E: 'hu',h0x0419: 'ru',h0x0442: 'tk',
  0x1004: 'zh-SG', 0x040F: 'is', 0x243B: 'smn', 0x0480: 'ug',
  0x0404: 'zh-TW', 0x0470: 'ig',h0x103B: 'smj-NO', 0x0422: 'uk',
  0x0483: 'co', 0x0421: 'id', 0x143B: 'smj', 0x042E: 'hsb',
  0x041A: 'hr', 0x045D: 'iu', 0x0C3B: 'se-FI', 0x0420: 'ur',
  0x101A: 'hr-BA', 0x085D: 'iu-Latn', 0x043B: 'se', 0x0843: 'uz-Cyrl',
  0x0405: 'cs', 0x083C: 'ga', 0x083B: 'se-SE',h0x0443: 'uz',
  0x0406: 'da',h0x0434: 'xh', 0x203B: 'sms', 0x042A: 'vi',
  0x048C: 'prs', 0x0435: 'zu', 0x183B: 'sma-NO', 0x0452: 'cy',
  0x0465: 'dv',h0x0410: 'it', 0x1C3B: 'sms', 0x0488: 'wo',
  0x0813: 'nl-BE', 0x0810: 'it-CH',h0x044F: 'sa', 0x0485: 'sah',
  0x0413: 'nl',h0x0411: 'ja', 0x1C1A: 'sr-Cyrl-BA', 0x0478: 'ii',
  0x0C09: 'en-AU',h0x044B: 'kn', 0x0C1A: 'sr', 0x046A: 'yo',
  0x2809: 'en-BZ',h0x043F: 'kk', 0x181A: 'sr-Latn-BA',
  0x1009: 'en-CA', 0x0453: 'km', 0x081A: 'sr-Latn',
  0x2409: 'en-029', 0x0486: 'quc', 0x046C: 'nso'
}];t=var NameRe /ida=+tew r.Struct({ailplatformID:rr.uin*16,
ilet / ifoID:rr.uin*16,
  languageID:rr.uin*16,t  nameID:rr.uin*16,
  l are :rr.uin*16,t   *ring:+tew r.Poflrer(r.uin*16, tew r.Strifo('l are ', functo a==t putShorred

fugetEn / ifo(t.platformID,lt.en / ifoID,lt.languageID at D} ,u{ type: 'parett', relativeTo: 'parett. *ringOffset', allowNull: faltwp})
} ;t=var LangTagRe /ida=+tew r.Struct({aill are :rr.uin*16,t  tag:+tew r.Poflrer(r.uin*16, tew r.Strifo('l are ', 'utf16be' ,u{ type: 'parett', relativeTo: ' *ringOffset'p})
} ;t=var NameTable ogtew r.Verso aedStruct(r.uin*16, utSh0:u{tShorc unt:rr.uin*16,ril   *ringOffset:rr.uin*16,t    re /ids:rtew r.ADicy(NameRe /id, 'count')t  },/  1: {tShorc unt:rr.uin*16,ril   *ringOffset:rr.uin*16,t    re /ids:rtew r.ADicy(NameRe /id, 'count'),t    langTagC unt:rr.uin*16,ril  langTags:rtew r.ADicy(LangTagRe /id, 'langTagC unt')t  }
} ;t=var NAMESt= ['copyright', 'fotrFamily', 'fotrSubfamily', 'uniqueSubfamily', 'fullName', 'verso a', 'postscriptName', // Note:eA fotr may have only  ae PostScript nameaandtt at nameamust beaASCII.
'trademark', 'manufacturer', 'desigfer', 'descripto a', 'vendorURL', 'desigferURL', 'licetse', 'licetseURL',  u l,r// reserved
'preferredFamily', 'preferredSubfamily', 'compatibleFu l', 'sampleText', 'postscriptCIDFotrName', 'wwsFamilyName', 'wwsSubfamilyName'];t=NameTable.proceesth;functo a==s*ream l{ailvar re /idsf= {};t Dfore(var _itSintora=+t is.re /ids, _isADicyt= ADicy.isADicy(_itSintor), _i = 0,h_itSintora=+_isADicyt?h_itSintora: _getItSintor(_itSintor);; putShorvar _ref;ttShor ===_isADicy putShorrr ===_i >=h_itSintor.  are ) break;aShorrr_refa=+_itSintor[_i++];t Dor}slevel{tShorrr_ia=+_itSintor.next();t Dor d ===_i.d ae) break;aShorrr_refa=+_i.va le;t Dor}
tShorvar re /ida=+_ref;ttShor// eindtout w at language l istis eortShorvar language = LANGUAGES[re /id.platformID][re /id.languageID], tShor ===language =(+nurn && t is.langTagsa!   u l && re /id.languageID >=h0x8000 putShorrrlanguage = t is.langTags[re /id.languageID -t0x8000].tag;t Dor}
tShor ===language =(+nurn putShorrrlanguage = re /id.platformID + '-' + re /id.languageID;t Dor}
tShor// ifet ednameIDtis >=h256, ittis aufotr eeature re /ida(AAT)tShorvar keyth;re /id.nameIDt>=h256t?h'fotrFeatures'a: NAMES[re /id.nameID]l||+re /id.nameID;=_dor ===re /ids[key]t=(+nurn putShorrrre /ids[key]t= {};t Dor}
tShorvar objth;re /ids[key];=_dor ===re /id.nameIDt>=h256 putShorrrobjth;obj[re /id.nameID]l||+(obj[re /id.nameID]l= {});t Dor}
tShor ===rypeofere /id. *ringl(   ' *ring' ||+rypeofeobj[language]a!   ' *ring' putShorrrobj[language]a=ere /id. *ringat Dor}
  }/
Shthis.re /idsth;re /ids;
};/
NameTable.preEn / wth;functo a== l{ail ===ADicy.isADicy(this.re /ids))dred

f;tShthis.verso a = 0,t
orvar re /idsf= [];t Dfore(var keytinhthis.re /ids putShorvar vall=uthis.re /ids[key];=_dor ===keyth   'fotrFeatures')rcontinuw;tt    re /ids.push(utShorrrplatformID:r3,tShorrret / ifoID:r1,ailor dlanguageID:r0x409,ailor dnameID:rNAMES.indexOf(key),ailor dl are :rBuffer.bytwL are (val.Fi,f'utf16le'),ailor d *ring:+val.Fit Dor}), tShor ===keyth   'postscriptName' putShorrrre /ids.push(utShorrrrrplatformID:r1,ailor drret / ifoID:r0,ailor drrlanguageID:r0,ailor drrnameID:rNAMES.indexOf(key),ailor d dl are :rval.Fi.  are ,ailor d d *ring:+val.Fit Dor  });t Dor}
  }/
Shthis.re /idsth;re /ids;
Shthis.c unt hBre /ids.  are ;
Shthis. *ringOffset hBNameTable.size(l is,t u l,rfaltw ;
};/
var OS2 ogtew r.Verso aedStruct(r.uin*16, utShheader: {tShorxAvgCharWidst:rr.in*16, // average weighted adv;n e widsttofelower case   t*ersaandtspacet    usWeightClues:rr.uin*16, // visuallweighttofe *roketin glyphst    usWidstClues:rr.uin*16, // relative change from t ednormal aspect intio (widstttohheighttintio)tShorfsType: tew r.Bitfield(r.uin*16, [// Indicates eont embed ifo licetsifo rightst     u l,r'noEmbed ifo', 'viewOnly', 'editable',  u l,r u l,r u l,r u l,r'noSubsettifo', 'bitmapOnly']),ailorySubscriptXSize:ar.in*16, // re /mm nded horizotrallsizeain pixels eor subscriptsailorySubscriptYSize:ar.in*16, // re /mm nded vertica lsizeain pixels eor subscriptsailorySubscriptXOffset:rr.in*16, // re /mm nded horizotralloffset eor subscriptsailorySubscriptYOffset:rr.in*16, // re /mm nded vertica loffset eorm t edbaselineteor subscriptsailorySuperscriptXSize:ar.in*16, // re /mm nded horizotrallsizeain pixels eor superscriptsailorySuperscriptYSize:ar.in*16, // re /mm nded vertica lsizeain pixels eor superscriptsailorySuperscriptXOffset:rr.in*16, // re /mm nded horizotralloffset eor superscriptsailorySuperscriptYOffset:rr.in*16, // re /mm nded vertica loffset erom t edbaselineteor superscriptsailoryS*rikeoutSize:ar.in*16, // widsttofet eds*rikeoute *rokeailoryS*rikeoutPosi
o a:rr.in*16, // posi
o atofet eds*rikeoute *roke relative toht edbaselineril   FamilyClues:rr.in*16, // cluesifica
o atofeeont-familyldesigfril  panose:+tew r.ADicy(r.uin*8, 10), // describelt edvisuallcharac*eristic tofea given+rypefacet    ulCharRange:rtew r.ADicy(r.uin*32, 4),ailorvendorID:rtew r.Strifo(4), // eour charac*er idetrifiertforel edfotrrvendortShorfsSelecto a:rtew r.Bitfield(r.uin*16, [// bit fieldrcontainifo informato ataboutet edfotr/*   'italic', 's.ders /ie', 'negative', 'outlined', 's*rikeout', 'bold', 'regular', 'useTypoMe*rics', 'wws', 'oblique']),ailorusFirstCharIndex:rr.uin*16, // T edminimum Uni /   indextinhthisdfotr/*   usLastCharIndex:rr.uin*16 // T edmaximum Uni /   indextinhthisdfotr/* },/= d// T edAppleeverso a ofet isdtable endslhere, butet edMicrosoft  ae continuw ton...tSh0:u{},/= d1: {tShorrypoAscender:rr.in*16,rilorrypoDescender:rr.in*16,rilorrypoLineGap:ar.in*16,rilorwinAscent:rr.uin*16,rilorwinDescent:rr.uin*16,rilor /  PageRange:rtew r.ADicy(r.uin*32, 2)t  },/= d2:u{tShor// t esetshould bea /mm a wisttverso a 1 somehowtShorrypoAscender:rr.in*16,rilorrypoDescender:rr.in*16,rilorrypoLineGap:ar.in*16,rilorwinAscent:rr.uin*16,rilorwinDescent:rr.uin*16,rilor /  PageRange:rtew r.ADicy(r.uin*32, 2), tShorxHeight:ar.in*16,rilorcapHeight:ar.in*16,rilordefaultChar:rr.uin*16,rilorbreakChar:rr.uin*16,rilormaxContent:rr.uin*16t  },/= d5: {tShorrypoAscender:rr.in*16,rilorrypoDescender:rr.in*16,rilorrypoLineGap:ar.in*16,rilorwinAscent:rr.uin*16,rilorwinDescent:rr.uin*16,rilor /  PageRange:rtew r.ADicy(r.uin*32, 2), tShorxHeight:ar.in*16,rilorcapHeight:ar.in*16,rilordefaultChar:rr.uin*16,rilorbreakChar:rr.uin*16,rilormaxContent:rr.uin*16, tShorusLowerOptica PoflrSize:ar.uin*16,rilorusUpperOptica PoflrSize:ar.uin*16t  }
} ;t=var verso asth;OS2.verso as;
verso as[3]t= verso as[4]t= verso as[2];t=// PostScript informato a=var post ogtew r.Verso aedStruct(r.fixed32, utShheader: {r// t esetfields exist atet edtopsofeall verso astShor talicAngle:ar.fixed32, // Italicaangletinhc unter-clockwiserdegrees erom t edvertica .riloru.derlinePosi
o a:rr.in*16, // Suggested dist;n e ofet edtopsofet edu.derline erom t edbaselineriloru.derlineThicknees:rr.in*16, // Suggested va lestforel edu.derline thickneestShor sFixedPitc :rr.uin*32, // Whet erel edfotrrisdm aospacedrilorminMemType42:rr.uin*32, // Minimum memoryrusage w enaa TrueTypedfotrrisddownloaded as auTyped42dfotr/*   maxMemType42:rr.uin*32, // Maximum memoryrusage w enaa TrueTypedfotrrisddownloaded as auTyped42dfotr/*   minMemType1:rr.uin*32, // Minimum memoryrusage w enaa TrueTypedfotrrisddownloaded as auTyped1dfotr/*   maxMemType1:rr.uin*32 // Maximum memoryrusage w enaa TrueTypedfotrrisddownloaded as auTyped1dfotr/* },/= d1:u{}, // verso a 1 has no addito aaltfields/= d2:u{tShornumbasOfGlyphs:rr.uin*16,tShorglyphNameIndex:rtew r.ADicy(r.uin*16, 'numbasOfGlyphs'),ailornames:rtew r.ADicy(tew r.Strifo(r.uin*8))t  },/= d2.5:u{tShornumbasOfGlyphs:rr.uin*16,tShoroffsets:+tew r.ADicy(r.uin*8, 'numbasOfGlyphs')t  },/= d3:u{}, // verso a 3 has no addito aaltfields/= d4:u{tShormap:atew r.ADicy(r.uin*32, functo a==t putShorrrred

fut.parett.maxp.numGlyphs,t    })t  }
} ;t=// AnaaDicytofepredefined va lestaccessible byeinstructo as/var cvt ogtew r.Struct({ailcontrolVa les:+tew r.ADicy(r.in*16 
} ;t=// A list o==instructo asft at are executwg once w enaa fotrrisdfirstaused.
// T esetinstructo asfare knowfuasel edfotrrprogram. T edmainhuvelofet isdtable
// istforel eddefini
o atofefuncto asft at are usedrinemany different glyph programs.
var fpgm ogtew r.Struct({ailinstructo as:rtew r.ADicy(r.uin*8)
} ;t=var loca ogtew r.Verso aedStruct('head.indexToLocFormat', utSh0:u{tShoroffsets:+tew r.ADicy(r.uin*16)t  },/  1: {tShoroffsets:+tew r.ADicy(r.uin*32)t  }
} ;t=loca.proceesth;functo a== l{ail ===rhis.verso a =   0 putShorfore(var i = 0; i < rhis.offsets.  are ; i++ putShor  rhis.offsets[i]t<<= 1,t    }t  }
};t=loca.preEn / wth;functo a== l{ail ===rhis.verso a !   u l lred

f;t= d// uesume rhis.offsetstis ausortwg aDicyt  this.verso a = rhis.offsets[rhis.offsets.  are  - 1]l> 0xffff ? 1 : 0,t
or ===rhis.verso a =   0 putShorfore(var i = 0; i < rhis.offsets.  are ; i++ putShor  rhis.offsets[i]t>>>= 1,t    }t  }
};t=// Set o==instructo asfexecutwg w eneverel edpoflrlsizeaor fotrttransformato atchange=var prep ogtew r.Struct({ailcontrolVa leProgram:rtew r.ADicy(r.uin*8)
} ;t=// only usedrforeen / ifo/var glyfa=+tew r.ADicy(tew r.Buffer() ;t=var CFFIndexth;functo a== l{ailfuncto a=CFFIndex=rype putShor_cluesCa lCheck(l is,tCFFIndex), tShorrhis.rype = rype, th}/
orCFFIndex.protorype.gerCFFVerso a = functo algetCFFVerso a(ctx putShorwhile (ctx && !ctx.hdrSize putShorrrctxa=+ctx.parett;t Dor}
tShorred

fuctxa?+ctx.verso a : -1,t  };/= dCFFIndex.protorype.de /   = functo alde /  =s*ream, parett putShorvar verso a = rhis.getCFFVerso a(parett ;tShorvar c unt hBverso a >=h2a?+s*ream.readUIn*32BE= l:+s*ream.readUIn*16BE= , tShor ===c unt h   0 putShorrrred

fu[];t Dor}
tShorvar offSizea=+s*ream.readUIn*8( ;tShorvar offsetType = voidB0,t     ===offSizea=   1 putShorrroffsetType = r.uin*8;t Dor}slevel ===offSizea=   2 putShorrroffsetType = r.uin*16;t Dor}slevel ===offSizea=   3 putShorrroffsetType = r.uin*24;t Dor}slevel ===offSizea=   4 putShorrroffsetType = r.uin*32;t Dor}slevelutShor  rhrow;tew Error("Badloffset sizeain CFFIndex: " + offSizea+ " " + s*ream.pos);t Dor}
tShorvar rett= [];t Dorvar st;rtPosa=+s*ream.pos +B(c unt + 1)t*toffSizea- 1,tt Dorvar st;rtth;offsetType.de /  =s*ream);t Dorfore(var i = 0; i < c unt; i++ putShor  var endth;offsetType.de /  =s*ream);ttShor   ===rhis.rype !   u l l{ailor d_bvar posa=+s*ream.posvailor d_bs*ream.pos = st;rtPosa+ st;rt;/= d_b Dorparett.  are  = endt- st;rt;/ d_b Dorret.push(rhis.rype.de /  =s*ream, parett )vailor d_bs*ream.pos = posvailor d}slevel{tShorrrrrret.push({tShorrrrrrroffset: st;rtPosa+ st;rt,tShorrrrrrrl are :rendt- st;rttShorrrrr}availor d}/
Shorrrst;rtth;end;t Dor}
tShors*ream.pos = st;rtPosa+ st;rt;/rrrrret

furet,t  };/= dCFFIndex.protorype.sizea=+functo arsize(arr, parett putShorvar sizea=+2,t     ===arr.  are  =   0 putShorrrred

fusize;/* us}
tShorvar rype = rhis.rype || tew r.Buffer();ttShor// eindtmaximum offset to detmininetoffset typetShorvar offset = 1,t    fore(var i = 0; i < arr.  are ; i++ putShor  var itemt(Barr[i];=_dorrroffset += rype.size(item, parett ;t Dor}
tShorvar offsetType = voidB0,t     ===offset <= 0xff putShorrroffsetType = r.uin*8;t Dor}slevel ===offset <= 0xffff putShorrroffsetType = r.uin*16;t Dor}slevel ===offset <= 0xffffff putShorrroffsetType = r.uin*24;t Dor}slevel ===offset <= 0xffffffff putShorrroffsetType = r.uin*32;t Dor}slevelutShor  rhrow;tew Error("Badloffset in CFFIndex" ;t Dor}
tShorsizea+  1 +;offsetType.size()t*t=arr.  are  + 1);tShorsizea+  offset - 1,tt Dorred

fusize;/* };/= dCFFIndex.protorype.en / wth;functo a=en / w=s*ream, arr, parett putShors*ream.writeUIn*16BE=arr.  are ),t     ===arr.  are  =   0 putShorrrred

f;/* us}
tShorvar rype = rhis.rype || tew r.Buffer();ttShor// eindtmaximum offset to detmininetoffset typetShorvar sizest= [];t Dorvar offset = 1,t    fore(var _itSintora=+arr, _isADicyt= ADicy.isADicy(_itSintor), _i = 0,h_itSintora=+_isADicyt?h_itSintora: _getItSintor(_itSintor);; putShororvar _ref;ttShoror ===_isADicy putShorrrrr ===_i >=h_itSintor.  are ) break;aShorrrrr_refa=+_itSintor[_i++];t Dor d}slevel{tShorrrrr_ia=+_itSintor.next();t Dor d d ===_i.d ae) break;aShorrrrr_refa=+_i.va le;t Dor d}/
Shorrrvar itemt(B_ref;ttShororvar s = rype.size(item, parett ;t Dororsizes.push(s);tShorrroffset += s;t Dor}
tShorvar offsetType = voidB0,t     ===offset <= 0xff putShorrroffsetType = r.uin*8;t Dor}slevel ===offset <= 0xffff putShorrroffsetType = r.uin*16;t Dor}slevel ===offset <= 0xffffff putShorrroffsetType = r.uin*24;t Dor}slevel ===offset <= 0xffffffff putShorrroffsetType = r.uin*32;t Dor}slevelutShor  rhrow;tew Error("Badloffset in CFFIndex" ;t Dor}
tShor// writeloffset sizetShors*ream.writeUIn*8(offsetType.size());ttShor// writelelemetrs
orrroffset = 1,t    offsetType.en / w=s*ream, offset);ttShorfore(var _itSintor2 ogsizes, _isADicy2t= ADicy.isADicy(_itSintor2), _i2 = 0,h_itSintor2a=+_isADicy2t?h_itSintor2a: _getItSintor(_itSintor2);; putShororvar _ref2;ttShoror ===_isADicy2 putShorrrrr ===_i2 >=h_itSintor2.  are ) break;aShorrrrr_ref2a=+_itSintor2[_i2++];t Dor d}slevel{tShorrrrr_i2a=+_itSintor2.next();t Dor d d ===_i2.d ae) break;aShorrrrr_ref2a=+_i2.va le;t Dor d}/
Shorrrvar sizea=+_ref2;ttShororoffset += size;/* usssoffsetType.en / w=s*ream, offset);tor d}/
Shorfore(var _itSintor3a=+arr, _isADicy3t= ADicy.isADicy(_itSintor3), _i3 = 0,h_itSintor3a=+_isADicy3t?h_itSintor3a: _getItSintor(_itSintor3);; putShororvar _ref3;ttShoror ===_isADicy3 putShorrrrr ===_i3 >=h_itSintor3.  are ) break;aShorrrrr_ref3a=+_itSintor3[_i3++];t Dor d}slevel{tShorrrrr_i3a=+_itSintor3.next();t Dor d d ===_i3.d ae) break;aShorrrrr_ref3a=+_i3.va le;t Dor d}/
Shorrrvar _itemt(B_ref3;ttShorortype.en / w=s*ream, _item, parett ;t Dor}
tShorred

f;/* };t= dred

f CFFIndex;
}( ;t=var FLOAT_EOF = 0xf;=var FLOAT_LOOKUPt= ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', 'E', 'E-',  u l,r'-'];t=var FLOAT_ENCODE_LOOKUPt= {tSh'.': 10,ail'E': 11,ail'E-': 12,ap '-': 14
};/
var CFFOpSinndth;functo a== l{ailfuncto a=CFFOpSinnd( putShor_cluesCa lCheck(l is,tCFFOpSinnd), th}/
orCFFOpSinnd.de /   = functo alde /  =s*ream, va le putShor ===32 <= va let&& va let<= 246 putShorrrred

fuva let- 139;t Dor}
tShor ===247 <= va let&& va let<= 250 putShorrrred

fu(va let- 247)t*t256t++s*ream.readUIn*8(  + 108;t Dor}
tShor ===251 <= va let&& va let<= 254 putShorrrred

fu-(va let- 251)t*t256t-+s*ream.readUIn*8(  - 108;t Dor}
tShor ===va leth   28 putShorrrred

fus*ream.readIn*16BE= ,  Dor}
tShor ===va leth   29 putShorrrred

fus*ream.readIn*32BE= ,  Dor}
tShor ===va leth   30 putShororvar s*r = '';tShorrrwhile (true l{ailor d_bvar ba=+s*ream.readUIn*8( ;tailor d_bvar n1a=+b >> 4;t Dor d d ===n1a=   FLOAT_EOF) utShorrrrrrrbreak;aShorrrrr}aShorrrrrs*r += FLOAT_LOOKUP[n1];tailor d_bvar n2a=+b & 15;t Dor d d ===n2a=   FLOAT_EOF) utShorrrrrrrbreak;aShorrrrr}aShorrrrrs*r += FLOAT_LOOKUP[n2];t Dor d}/
Shorrrred

fuparseFloat=s*r at Dor}
t Dorred

funurn, th};/
orCFFOpSinnd.sizea=+functo arsize(va le putShor// ifet edva letneedsato beteorcedrtout edlargest sizea=32 bit)tShor// e.g.rforeunknowfupoflrers,tset to 32768tShor ===va le.eorceLarge putShororva leth;32768,  Dor}
tShor ====va let| 0 p!   va le putShoror// eloatifo poflrtShororvar s*r = '' + va le;t Dor dred

fu1 +;Math.ceil(=s*r.  are  + 1) /t2 ;
 Dor}ulevel ===-107 <= va let&& va let<= 107 putShorrrred

fu1;
 Dor}ulevel ===108 <= va let&& va let<= 1131 || -1131 <= va let&& va let<= -108 putShorrrred

fu2;
 Dor}ulevel ===-32768 <= va let&& va let<= 32767 putShorrrred

fu3;t Dor}slevelutShor  red

fu5,  Dor}
th};/
orCFFOpSinnd.en / wth;functo a=en / w=s*ream, va le putShor// ifet edva letneedsato beteorcedrtout edlargest sizea=32 bit)tShor// e.g.rforeunknowfupoflrers,tsave t edold va leaandtset to 32768tShorvar vall=uNumbas(va le ;
tShor ===va le.eorceLarge putShorors*ream.writeUIn*8(29 ;t Dor dred

fus*ream.writeIn*32BE=va  ;
 Dor}ulevel ====va t| 0 p!   va  putShoror// eloatifo poflrtShorors*ream.writeUIn*8(30 ;ttShororvar s*r = '' + va ;t Dor dfore(var i = 0; i < s*r.  are ; i +  2 putShorrrorvar c1a=+s*r[i];=_dorrr_bvar n1a=+FLOAT_ENCODE_LOOKUP[c1]l||++c1;tailor d_b ===ia=   s*r.  are  - 1 putShorrrrr_bvar n2   FLOAT_EOF;aShorrrrr}slevel{tShorrrrrorvar c2a=+s*r[i + 1];tShorrrrrrrvar n2   FLOAT_ENCODE_LOOKUP[c2]l||++c2;aShorrrrr}aaShorrrrrs*ream.writeUIn*8(n1a<< 4t| n2 & 15availor d}/
Shorrr ===n2a!   FLOAT_EOF) utShorrrrrred

fus*ream.writeUIn*8(FLOAT_EOF << 4availor d}/ Dor}ulevel ===-107 <= va t&& va t<= 107 putShorrrred

fus*ream.writeUIn*8(va t+ 139 ;
 Dor}ulevel ===108 <= va t&& va t<= 1131 putShororva  -= 108;t Dorrrs*ream.writeUIn*8((va t>> 8  + 247);t Dor dred

fus*ream.writeUIn*8(va t& 0xff ;
 Dor}ulevel ===-1131 <= va t&& va t<= -108 putShorrrvall=u-va  - 108;t Dorrrs*ream.writeUIn*8((va t>> 8  + 251);t Dor dred

fus*ream.writeUIn*8(va t& 0xff ;
 Dor}ulevel ===-32768 <= va t&& va t<= 32767 putShorrrs*ream.writeUIn*8(28 ;t Dor dred

fus*ream.writeIn*16BE=va  ;
 Dor}ulevelutShorors*ream.writeUIn*8(29 ;t Dor dred

fus*ream.writeIn*32BE=va  ;
 Dor}/* };t= dred

f CFFOpSinnd;
}( ;t=var CFFDictth;functo a==)putShfuncto a=CFFDict( putShorvar ops (Bargumetrs.  are  >u0 && argumetrs[0]l!   s.defined ?rargumetrs[0] : [];tailor_cluesCa lCheck(l is,tCFFDict), tShorrhis.ops (Bops;tShorrhis.fields = {};t Dorfore(var _itSintora=+ops, _isADicyt= ADicy.isADicy(_itSintor), _i = 0,h_itSintora=+_isADicyt?h_itSintora: _getItSintor(_itSintor);; putShororvar _ref;ttShoror ===_isADicy putShorrrrr ===_i >=h_itSintor.  are ) break;aShorrrrr_refa=+_itSintor[_i++];t Dor d}slevel{tShorrrrr_ia=+_itSintor.next();t Dor d d ===_i.d ae) break;aShorrrrr_refa=+_i.va le;t Dor d}/
Shorrrvar fieldr(B_ref;ttShororvar keyth;ADicy.isADicy(field[0])t?hfield[0][0] << 8t| field[0][1] : field[0];t Dor drhis.fields[key]t= field;
 Dor}/* }/
orCFFDict.protorype.de /  OpSinnds = functo alde /  OpSinnds=rype, s*ream, red, opSinnds putShorvar _t isd= rhis;
tShor ===ADicy.isADicy(type  putShorrrred

fuopSinnds.map(functo a==op, i) utShorrrrrred

fu_t is.de /  OpSinnds=rype[i], s*ream, red, [op]availor d} ;
 Dor}ulevel ===rype.de /   !   u l l{ailor dred

futype.de /  =s*ream, red, opSinnds ;
 Dor}ulevelutShororswitc  =rype putShorrrrrcase 'numbas':tShorrrrrcase 'offset':tShorrrrrcase 'sid':tShorrrrrrrred

fuopSinnds[0];t Dor drrcase 'boolean':tShorrrrrrrred

fu!!opSinnds[0];t Dor drrdefault:tShorrrrrrrred

fuopSinndsvailor d}/ Dor}
th};/
orCFFDict.protorype.en / wOpSinnds = functo alen / wOpSinnds=rype, s*ream, ctx, opSinnds putShorvar _t is2d= rhis;
tShor ===ADicy.isADicy(type  putShorrrred

fuopSinnds.map(functo a==op, i) utShorrrrrred

fu_t is2.en / wOpSinnds=rype[i], s*ream, ctx, op)[0];t Dor d} ;
 Dor}ulevel ===rype.en / wt!   u l l{ailor dred

futype.en / w=s*ream, opSinnds, ctx ;
 Dor}ulevel ===rypeofeopSinnds =   'numbas' putShorrrred

fu[opSinnds];
 Dor}ulevel ===rypeofeopSinnds =   'boolean' putShorrrred

fu[+opSinnds];
 Dor}ulevel ===ADicy.isADicy(opSinnds  putShorrrred

fuopSinnds;t Dor}slevelutShor  red

fu[opSinnds];
 Dor}
th};/
orCFFDict.protorype.de /   = functo alde /  =s*ream, parett putShorvar endth;s*ream.pos +Bparett.  are ;tShorvar rett= {};t Dorvar opSinnds = [];tailor// define hidden properties/* us_Object$defineProperties(red, utShor  parett: {rva le: parett },r n  us_st;rtOffset:r{rva le: s*ream.pos }/ Dor});ttShor// eill in defaultst Dorfore(var keytinhthis.fields putShororvar fieldr(Brhis.fields[key];t Dor dred[field[1]]t= field[3];t Dor}
tShorwhile (s*ream.pos < end putShororvar ba=+s*ream.readUIn*8( ;tShoror ===b < 28 putShorrror ===b =   12 putShorrrrr_bba=+b << 8t| s*ream.readUIn*8( ;tShororrr}aaShorrrrrvar _fieldr(Brhis.fields[b];t Dor drr ===!_field putShorrrrr_brhrow;tew Error('UnknowfuopSintora' + b ;tShororrr}aaShorrrrrvar vall=uthis.de /  OpSinnds=_field[2], s*ream, red, opSinnds ;
 Dor drr ===vall!   u l l{ailor d_brr ===vallinst;n eoferestructure_src_utils.PropertyDescriptor)l{ailor d_brrus_Object$defineProperty(red, _field[1], va  ;
 Dor drrrr}slevel{tShorrrrror dred[_field[1]]t= va ;t Dor dorrr}aShororrr}aaShorrrrropSinnds = [];t drrrr}slevel{tShorrrrropSinnds.push(CFFOpSinnd.de /  =s*ream, b)availor d}/ Dor}
t Dorred

furet,t  };/= dCFFDict.protorype.sizea=+functo arsize(dict, parett putShorvar includePoflrers (Bargumetrs.  are  >u2 && argumetrs[2]l!   s.defined ?rargumetrs[2]l: true,tt Dorvar ctxa=+utShor  parett: parett,tShororval: dict,tShor  poflrerSize:a0,ailor dst;rtOffset:rparett. *;rtOffsetl||+0/ Dor},tt Dorvar   a = 0,t
ororfore(var ktinhthis.fields putShororvar fieldr(Brhis.fields[k];t drrrrvar vall=udict[field[1]];tShoror ===vall=   u l ||+isEqual=val, field[3]) putShorrrrrcontinuw;tororrr}aaShorrrvar opSinnds = rhis.en / wOpSinnds=field[2],  u l,rctx, va  ;
 Dor dfore(var _itSintor2 ogopSinnds, _isADicy2t= ADicy.isADicy(_itSintor2), _i2 = 0,h_itSintor2a=+_isADicy2t?h_itSintor2a: _getItSintor(_itSintor2);; putShorororvar _ref2;ttShororor ===_isADicy2 putShorrrrrrr ===_i2 >=h_itSintor2.  are ) break;aShorrrrrrr_ref2a=+_itSintor2[_i2++];t Dor drr}slevel{tShorrrrror_i2a=+_itSintor2.next();t Dor d d d ===_i2.d ae) break;aShorrrrrrr_ref2a=+_i2.va le;t Dor drr}aaShorrrrrvar opa=+_ref2;ttShororrrl a +  CFFOpSinnd.size(opavailor d}/
Shorrrvar keyth;ADicy.isADicy(field[0])t?hfield[0] : [field[0]];t Dor dl a +  key.  are ;tShor}
tShor ===includePoflrers putShorrrl a +  ctx.poflrerSize;tShor}
tShorred

ful a,t  };/= dCFFDict.protorype.en / wth;functo a=en / w=s*ream, dict, parett putShorvar ctxa=+utShor  poflrers: [],ailor dst;rtOffset:rs*ream.pos,tShor  parett: parett,tShororval: dict,tShor  poflrerSize:a0/ Dor},tt Dorctx.poflrerOffset hBs*ream.pos +Bthis. ize(dict, ctx, faltw ;

ororfore(var _itSintor3a=+rhis.ops, _isADicy3t= ADicy.isADicy(_itSintor3), _i3 = 0,h_itSintor3a=+_isADicy3t?h_itSintor3a: _getItSintor(_itSintor3);; putShororvar _ref3;ttShoror ===_isADicy3 putShorrrrr ===_i3 >=h_itSintor3.  are ) break;aShorrrrr_ref3a=+_itSintor3[_i3++];t Dor d}slevel{tShorrror_i3a=+_itSintor3.next();t Dor d d ===_i3.d ae) break;aShorrrrr_ref3a=+_i3.va le;t Dor d}/
Shorrrvar fieldr(B_ref3;ttShororvar vall=udict[field[1]];tShoror ===vall=   u l ||+isEqual=val, field[3]) putShorrrrrcontinuw;tororrr}aaShorrrvar opSinnds = rhis.en / wOpSinnds=field[2], s*ream, ctx, va  ;
 Dor dfore(var _itSintor4 ogopSinnds, _isADicy4t= ADicy.isADicy(_itSintor4), _i4 = 0,h_itSintor4a=+_isADicy4t?h_itSintor4a: _getItSintor(_itSintor4);; putShorororvar _ref4;ttShororor ===_isADicy4 putShorrrrrrr ===_i4 >=h_itSintor4.  are ) break;aShorrrrrrr_ref4a=+_itSintor4[_i4++];t Dor drr}slevel{tShorrrrror_i4a=+_itSintor4.next();t Dor d d d ===_i4.d ae) break;aShorrrrrrr_ref4a=+_i4.va le;t Dor drr}aaShorrrrrvar opa=+_ref4;ttShorororCFFOpSinnd.en / w=s*ream, opavailor d}/
Shorrrvar keyth;ADicy.isADicy(field[0])t?hfield[0] : [field[0]];t Dor dfore(var _itSintor5   key, _isADicy5t= ADicy.isADicy(_itSintor5), _i5 = 0,h_itSintor5a=+_isADicy5t?h_itSintor5a: _getItSintor(_itSintor5);; putShorororvar _ref5;ttShororor ===_isADicy5 putShorrrrrrr ===_i5 >=h_itSintor5.  are ) break;aShorrrrrrr_ref5a=+_itSintor5[_i5++];t Dor drr}slevel{tShorrrrror_i5a=+_itSintor5.next();t Dor d d d ===_i5.d ae) break;aShorrrrrrr_ref5a=+_i5.va le;t Dor drr}aaShorrrrrvar _opa=+_ref5;ttShororors*ream.writeUIn*8(_opavailor d}/ drr}aaShorvar i = 0;tShorwhile (i < ctx.poflrers.  are ) utShororvar p*r = ctx.poflrers[i++];t Dor dp*r.type.en / w=s*ream, p*r.val, p*r.parett ;t Dor}
tShorred

f;/* };t= dred

f CFFDict;
}( ;t=var CFFPoflrerth;functo a==_r$Poflrer) utSh_inherits(CFFPoflrer,h_r$Poflrer);t= dfuncto a=CFFPoflrer(rype putShorvar opto asth;argumetrs.  are  >u1 && argumetrs[1]l!   s.defined ?rargumetrs[1] : {};tailor_cluesCa lCheck(l is,tCFFPoflrer);t= d   ===opto as.rype =   u l l{ailor dopto as.rype = 'global';tShor}
tShorred

fu_possibleConstructorRed

f(l is,t_r$Poflrer.ca l(l is,t u l,rrype, opto as)), th}/
orCFFPoflrer.protorype.de /   = functo alde /  =s*ream, parett, opSinnds putShorrhis.offsetType = {ailor dde /  : functo alde /  =) utShorrrrrred

fuopSinnds[0];t Dor d}/ Dor},tt Dorred

fu_r$Poflrer.protorype.de /  .ca l(l is,ts*ream, parett, opSinnds ,t  };/= dCFFPoflrer.protorype.en / wth;functo a=en / w=s*ream, va le, ctx putShor ===!s*ream l{ailllll// compute t edsizea=so ctx.poflrerSizetis correct)tShororrhis.offsetType = {ailor dorsize:+functo arsize( putShorrrrrrrred

fu0;t Dor drr}aor drr};ttShororthis. ize(va le, ctx ;t Dor dred

fu[tew Ptr(0)];t Dor}
tShorvar p*r = nurn, thorrhis.offsetType = {ailor den / w:;functo a=en / w=s*ream, va ) utShorrrrrred

fup*r = va ;t Dor d}/ Dor},tt Dor_r$Poflrer.protorype.en / w.ca l(l is,ts*ream, va le, ctx ;t Dorred

fu[tew Ptr(p*r)];t D};t= dred

f CFFPoflrer;
}(r.Poflrer ;t=var Ptrth;functo a==)putShfuncto a=Ptr(va ) utShor_cluesCa lCheck(l is,tPtr);t= d  rhis.vall=uva ;t Dorrhis.forceLarge = rrue, th}/
orPtr.protorype.va leOfth;functo a=va leOf( putShorred

futhis.val;t D};t= dred

f Ptr;
}( ;t=var CFFB  adOpth;functo a==)putShfuncto a=CFFB  adOp( putShor_cluesCa lCheck(l is,tCFFB  adOp), th}/
orCFFB  adOp.de /   = functo alde /  =s*ream, parett, opSinnds putShorvar numB  ads ogopSinnds.pop();ttShor// TODO: actua ly b  ad. Forenow just consume rheddeltastShor// since weddon'tause any ofet edva lesaanywcy.tShorwhile (opSinnds.  are  >unumB  ads l{ailor dopSinnds.pop();tor d}/ D};t= dred

f CFFB  adOp;
}( ;t=var CFFPrivateDictth;tew CFFDict([=// keytttttttnameaaaaaaaaaaaaaaaaaaaarype                                          default
[6, 'B leVa les', 'delta', nurn], [7, 'Ot erB les', 'delta', nurn], [8, 'FamilyB les', 'delta', nurn], [9, 'FamilyOt erB les', 'delta', nurn], [[12, 9], 'B leSca e', 'numbas', 0.039625], [[12, 10], 'B leShift', 'numbas', 7], [[12, 11], 'B leFuzz', 'numbas', 1], [10, 'StdHW', 'numbas', nurn], [11, 'StdVW', 'numbas', nurn], [[12, 12], 'StemSnapH', 'delta', nurn], [[12, 13], 'StemSnapV', 'delta', nurn], [[12, 14], 'ForceBold', 'boolean', faltw], [[12, 17], 'LanguageGroup', 'numbas', 0], [[12, 18], 'Expanso aFactor', 'numbas', 0.06], [[12, 19], 'ini
oalRnndomSeed', 'numbas', 0], [20, 'defaultWidstX', 'numbas', 0], [21,r'nominalWidstX', 'numbas', 0], [22, 'vsindex', 'numbas', 0], [23, 'b  ad',tCFFB  adOp, nurn], [19, 'Subrs', tew CFFPoflrer(tew CFFIndex= ,u{ type: 'local'D} ,unurn]] ;t=// Automatoca ly genSintedrfrom App adix A ofet edCFF specifica
o a;ddo=// not edit. L are tshould bea391.
var st;ndardStrifos = [".notdef", "space", "exclum", "quotedbl", "numbassigf", "dollar", "pSicent", "ampers;nd", "quoteright", "paretleft", "paretright", "as*erisk", "plus", " /mma", "hyphen", "pSiiod", "slueh", "zero", " ae", "two", "three", "eour", "eive", "six", "seven", "eight", "nine", " /lon", "semi /lon", "less", "equal", "grea*er", "ques
o a", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslueh", "bracketright", "asciicircum", "s.ders /ie", "quoteleft", "a", "b", " ", "d", "e", "e", "g", "h", "i", "j", "k", "l", "m", "a", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclumdown", " ent", "s*erlifo", "erac*o a", "yen", "florif", "sec*o a", "currency", "quotesifole", "quotedblleft", "guillemotleft", "guilsifolleft", "guilsifolright", "fi", "fl", "endaeh", "dagger", "daggerdbl", "pSiiodcetrered", "paragraph", "burnet", "quotesifolbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "pSithous;nd", "ques
o adown", "grave", "acutw", "circumflex", "tilde", "macron", "breve", "dotaccetr", "dieresis", "rifo", "cedilla", "hungarumlaur", "og aek", "caron", "emdaeh", "AE", "ordfeminine", "Lslueh", "Oslueh", "OE", "ordmasculine", "ae", "dotlessi", "lslueh", "oslueh", "oe", "germ;ndbls", " aesuperior", "logoca not", "mu", "trademark", "Eth", " aehale", "plusminus", "Thorn", " aequar*er", "divide", "brokenbar", "degree", "thorn", "threequar*ers", "twosuperior", "regisrered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacutw", "Acircumflex", "Adieresis", "Agrave", "Arifo", "Atilde", "Ccedilla", "Eacutw", "Ecircumflex", "Edieresis", "Egrave", "Iacutw", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacutw", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacutw", "Ucircumflex", "Udieresis", "Ugrave", "Yacutw", "Ydieresis", "Zcaron", "aacutw", "acircumflex", "adieresis", "agrave", "arifo", "atilde", "ccedilla", "eacutw", "ecircumflex", "edieresis", "egrave", "iacutw", "icircumflex", "idieresis", "igrave", "ntilde", "oacutw", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacutw", "ucircumflex", "udieresis", "ugrave", "yacutw", "ydieresis", "zcaron", "exclumsma l", "Hungarumlaursma l", "dollaroldstyle", "dollarsuperior", "ampers;ndsma l", "Acutwsma l", "paretleftsuperior", "paretrightsuperior", "twodotetleader", " aedotetleader", "zerooldstyle", " aeoldstyle", "twooldstyle", "threeoldstyle", "eouroldstyle", "eiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", " /mmasuperior", "threequar*ersemdaeh", "pSiiodsuperior", "ques
o asma l", "asuperior", "bsuperior", "cetrsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "paretleftinferior", "paretrightinferior", "Circumflexsma l", "hyphensuperior", "Gravesma l", "Asma l", "Bsma l", "Csma l", "Dsma l", "Esma l", "Fsma l", "Gsma l", "Hsma l", "Isma l", "Jsma l", "Ksma l", "Lsma l", "Msma l", "Nsma l", "Osma l", "Psma l", "Qsma l", "Rsma l", "Ssma l", "Tsma l", "Usma l", "Vsma l", "Wsma l", "Xsma l", "Ysma l", "Zsma l", " /lonm aetary", " aefitted", "rupiah", "Tildesma l", "exclumdownsma l", " etroldstyle", "Lsluehsma l", "Scaronsma l", "Zcaronsma l", "Dieresissma l", "Brevesma l", "Caronsma l", "Dotaccetrsma l", "Macronsma l", "figuredaeh", "hypheninferior", "Og aeksma l", "Rifosma l", "Cedillasma l", "ques
o adownsma l", " aeeighth", "threeeighths", "eiveeighths", "seveneighths", " aethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", " aeinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "cetrinferior", "dollarinferior", "pSiiodinferior", "c/mmainferior", "Agravesma l", "Aacutwsma l", "Acircumflexsma l", "Atildesma l", "Adieresissma l", "Arifosma l", "AEsma l", "Ccedillasma l", "Egravesma l", "Eacutwsma l", "Ecircumflexsma l", "Edieresissma l", "Igravesma l", "Iacutwsma l", "Icircumflexsma l", "Idieresissma l", "Ethsma l", "Ntildesma l", "Ogravesma l", "Oacutwsma l", "Ocircumflexsma l", "Otildesma l", "Odieresissma l", "OEsma l", "Osluehsma l", "Ugravesma l", "Uacutwsma l", "Ucircumflexsma l", "Udieresissma l", "Yacutwsma l", "Thornsma l", "Ydieresissma l", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Rom;n", "Semibold"];t=var St;ndardEn / ifot= ['', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'space', 'exclum', 'quotedbl', 'numbassigf', 'dollar', 'pSicent', 'ampers;nd', 'quoteright', 'paretleft', 'paretright', 'as*erisk', 'plus', 'comma', 'hyphen', 'pSiiod', 'slueh', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'col a', 'semi /lon', 'less', 'equal', 'grea*er', 'ques
o a', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',h'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslueh', 'bracketright', 'asciicircum', 's.ders /ie', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'a', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',h'w',h'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'exclumdown', 'cent', 's*erlifo', 'frac*o a', 'yen', 'florif', 'sec*o a', 'currency', 'quotesifole', 'quotedblleft', 'guillemotleft', 'guilsifolleft', 'guilsifolright', 'fi', 'fl', '', 'endaeh', 'dagger', 'daggerdbl', 'pSiiodcetrered', '', 'paragraph', 'burnet', 'quotesifolbase', 'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis', 'pSithous;nd', '', 'ques
o adown', '', 'grave', 'acutw', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccetr', 'dieresis', '', 'rifo', 'cedilla', '', 'hungarumlaur', 'og aek', 'caron', 'emdaeh', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'AE', '', 'ordfeminine', '', '', '', '', 'Lslueh', 'Oslueh', 'OE', 'ordmasculine', '', '', '', '', '', 'ae', '', '', '', 'dotlessi', '', '', 'lslueh', 'oslueh', 'oe', 'germ;ndbls'];t=var ExpSitEn / ifot= ['', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'space', 'exclumsma l', 'Hungarumlaursma l', '', 'dollaroldstyle', 'dollarsuperior', 'ampers;ndsma l', 'Acutwsma l', 'paretleftsuperior', 'paretrightsuperior', 'twodotetleader', 'oaedotetleader', 'comma', 'hyphen', 'pSiiod', 'frac*o a', 'zerooldstyle', 'oaeoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'col a', 'semi /lon', ' /mmasuperior', 'threequar*ersemdaeh', 'pSiiodsuperior', 'ques
o asma l', '', 'asuperior', 'bsuperior', 'cetrsuperior', 'dsuperior', 'esuperior', '', '', 'isuperior', '', '', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', '', '', 'rsuperior', 'ssuperior', 'tsuperior', '', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'paretleftinferior', '', 'paretrightinferior', 'Circumflexsma l', 'hyphensuperior', 'Gravesma l', 'Asma l', 'Bsma l', 'Csma l', 'Dsma l', 'Esma l', 'Fsma l', 'Gsma l', 'Hsma l', 'Isma l', 'Jsma l', 'Ksma l', 'Lsma l', 'Msma l', 'Nsma l', 'Osma l', 'Psma l', 'Qsma l', 'Rsma l', 'Ssma l', 'Tsma l', 'Usma l', 'Vsma l', 'Wsma l', 'Xsma l', 'Ysma l', 'Zsma l', ' /lonm aetary', 'oaefitted', 'rupiah', 'Tildesma l', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'exclumdownsma l', 'cetroldstyle', 'Lsluehsma l', '', '', 'Scaronsma l', 'Zcaronsma l', 'Dieresissma l', 'Brevesma l', 'Caronsma l', '', 'Dotaccetrsma l', '', '', 'Macronsma l', '', '', 'figuredaeh', 'hypheninferior', '', '', 'Og aeksma l', 'Rifosma l', 'Cedillasma l', '', '', '', ' aequar*er', ' aehale', 'threequar*ers', 'ques
o adownsma l', ' aeeighth', 'threeeighths', 'fiveeighths', 'seveneighths', ' aethird', 'twothirds', '', '', 'zerosuperior', ' aesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', ' aeinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'cetrinferior', 'dollarinferior', 'pSiiodinferior', ' /mmainferior', 'Agravesma l', 'Aacutwsma l', 'Acircumflexsma l', 'Atildesma l', 'Adieresissma l', 'Arifosma l', 'AEsma l', 'Ccedillasma l', 'Egravesma l', 'Eacutwsma l', 'Ecircumflexsma l', 'Edieresissma l', 'Igravesma l', 'Iacutwsma l', 'Icircumflexsma l', 'Idieresissma l', 'Ethsma l', 'Ntildesma l', 'Ogravesma l', 'Oacutwsma l', 'Ocircumflexsma l', 'Otildesma l', 'Odieresissma l', 'OEsma l', 'Osluehsma l', 'Ugravesma l', 'Uacutwsma l', 'Ucircumflexsma l', 'Udieresissma l', 'Yacutwsma l', 'Thornsma l', 'Ydieresissma l'];t=var ISOAdobeCharset hB['.notdef', 'space', 'exclum', 'quotedbl', 'numbassigf', 'dollar', 'pSicent', 'ampers;nd', 'quoteright', 'paretleft', 'paretright', 'as*erisk', 'plus', 'comma', 'hyphen', 'pSiiod', 'slueh', 'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'col a', 'semi /lon', 'less', 'equal', 'grea*er', 'ques
o a', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',h'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslueh', 'bracketright', 'asciicircum', 's.ders /ie', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'a', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',h'w',h'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'exclumdown', 'cent', 's*erlifo', 'frac*o a', 'yen', 'florif', 'sec*o a', 'currency', 'quotesifole', 'quotedblleft', 'guillemotleft', 'guilsifolleft', 'guilsifolright', 'fi', 'fl', 'endaeh', 'dagger', 'daggerdbl', 'pSiiodcetrered', 'paragraph', 'burnet', 'quotesifolbase', 'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis', 'pSithous;nd', 'ques
o adown', 'grave', 'acutw', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccetr', 'dieresis', 'rifo', 'cedilla', 'hungarumlaur', 'og aek', 'caron', 'emdaeh', 'AE', 'ordfeminine', 'Lslueh', 'Oslueh', 'OE', 'ordmasculine', 'ae', 'dotlessi', 'lslueh', 'oslueh', 'oe', 'germ;ndbls', ' aesuperior', 'logoca not', 'mu', 'trademark', 'Eth', ' aehale', 'plusminus', 'Thorn', ' aequar*er', 'divide', 'brokenbar', 'degree', 'thorn', 'threequar*ers', 'twosuperior', 'regisrered', 'minus', 'eth', 'multiply', 'threesuperior', 'copyright', 'Aacutw', 'Acircumflex', 'Adieresis', 'Agrave', 'Arifo', 'Atilde', 'Ccedilla', 'Eacutw', 'Ecircumflex', 'Edieresis', 'Egrave', 'Iacutw', 'Icircumflex', 'Idieresis', 'Igrave', 'Ntilde', 'Oacutw', 'Ocircumflex', 'Odieresis', 'Ograve', 'Otilde', 'Scaron', 'Uacutw', 'Ucircumflex', 'Udieresis', 'Ugrave', 'Yacutw', 'Ydieresis', 'Zcaron', 'aacutw', 'acircumflex', 'adieresis', 'agrave', 'arifo', 'atilde', 'ccedilla', 'eacutw', 'ecircumflex', 'edieresis', 'egrave', 'iacutw', 'icircumflex', 'idieresis', 'igrave', 'ntilde', 'oacutw', 'ocircumflex', 'odieresis', 'ograve', 'otilde', 'scaron', 'uacutw', 'ucircumflex', 'udieresis', 'ugrave', 'yacutw', 'ydieresis', 'zcaron'];t=var ExpSitCharset hB['.notdef', 'space', 'exclumsma l', 'Hungarumlaursma l', 'dollaroldstyle', 'dollarsuperior', 'ampers;ndsma l', 'Acutwsma l', 'paretleftsuperior', 'paretrightsuperior', 'twodotetleader', 'oaedotetleader', 'comma', 'hyphen', 'pSiiod', 'frac*o a', 'zerooldstyle', 'oaeoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'col a', 'semi /lon', ' /mmasuperior', 'threequar*ersemdaeh', 'pSiiodsuperior', 'ques
o asma l', 'asuperior', 'bsuperior', 'cetrsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior', 'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'paretleftinferior', 'paretrightinferior', 'Circumflexsma l', 'hyphensuperior', 'Gravesma l', 'Asma l', 'Bsma l', 'Csma l', 'Dsma l', 'Esma l', 'Fsma l', 'Gsma l', 'Hsma l', 'Isma l', 'Jsma l', 'Ksma l', 'Lsma l', 'Msma l', 'Nsma l', 'Osma l', 'Psma l', 'Qsma l', 'Rsma l', 'Ssma l', 'Tsma l', 'Usma l', 'Vsma l', 'Wsma l', 'Xsma l', 'Ysma l', 'Zsma l', ' /lonm aetary', 'oaefitted', 'rupiah', 'Tildesma l', 'exclumdownsma l', 'cetroldstyle', 'Lsluehsma l', 'Scaronsma l', 'Zcaronsma l', 'Dieresissma l', 'Brevesma l', 'Caronsma l', 'Dotaccetrsma l', 'Macronsma l', 'figuredaeh', 'hypheninferior', 'Og aeksma l', 'Rifosma l', 'Cedillasma l', ' aequar*er', ' aehale', 'threequar*ers', 'ques
o adownsma l', ' aeeighth', 'threeeighths', 'fiveeighths', 'seveneighths', ' aethird', 'twothirds', 'zerosuperior', ' aesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', ' aeinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'cetrinferior', 'dollarinferior', 'pSiiodinferior', ' /mmainferior', 'Agravesma l', 'Aacutwsma l', 'Acircumflexsma l', 'Atildesma l', 'Adieresissma l', 'Arifosma l', 'AEsma l', 'Ccedillasma l', 'Egravesma l', 'Eacutwsma l', 'Ecircumflexsma l', 'Edieresissma l', 'Igravesma l', 'Iacutwsma l', 'Icircumflexsma l', 'Idieresissma l', 'Ethsma l', 'Ntildesma l', 'Ogravesma l', 'Oacutwsma l', 'Ocircumflexsma l', 'Otildesma l', 'Odieresissma l', 'OEsma l', 'Osluehsma l', 'Ugravesma l', 'Uacutwsma l', 'Ucircumflexsma l', 'Udieresissma l', 'Yacutwsma l', 'Thornsma l', 'Ydieresissma l'];t=var ExpSitSubsetCharset hB['.notdef', 'space', 'dollaroldstyle', 'dollarsuperior', 'paretleftsuperior', 'paretrightsuperior', 'twodotetleader', 'oaedotetleader', 'comma', 'hyphen', 'pSiiod', 'frac*o a', 'zerooldstyle', 'oaeoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'col a', 'semi /lon', ' /mmasuperior', 'threequar*ersemdaeh', 'pSiiodsuperior', 'asuperior', 'bsuperior', 'cetrsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior', 'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior', 'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'paretleftinferior', 'paretrightinferior', 'hyphensuperior', ' /lonm aetary', 'oaefitted', 'rupiah', 'cetroldstyle', 'figuredaeh', 'hypheninferior', ' aequar*er', ' aehale', 'threequar*ers', ' aeeighth', 'threeeighths', 'fiveeighths', 'seveneighths', ' aethird', 'twothirds', 'zerosuperior', ' aesuperior', 'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior', ' aeinferior', 'twoinferior', 'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior', 'nineinferior', 'cetrinferior', 'dollarinferior', 'pSiiodinferior', ' /mmainferior'];t=//########################=// ScriptsaandtLanguages #=//########################==var LangSysTableth;tew r.Struct({tShreserved:;tew r.Reserved(r.uin*16),tShreqFeatureIndex: r.uin*16,tShfeatureC unt: r.uin*16,tShfeatureIndexes:;tew r.ADicy(r.uin*16, 'featureC unt')
} ;t=var LangSysRecordth;tew r.Struct({tShtag:;tew r.Strifo(4),tShlangSys:;tew r.Poflrer(r.uin*16, LangSysTable,u{ type: 'parett'D} 
} ;t=var Scriptth;tew r.Struct({tShdefaultLangSys:;tew r.Poflrer(r.uin*16, LangSysTable),tShc unt: r.uin*16,tShlangSysRecords:;tew r.ADicy(LangSysRecord, ' /unt')
} ;t=var ScriptRecordth;tew r.Struct({tShtag:;tew r.Strifo(4),tShscript:;tew r.Poflrer(r.uin*16, Script,u{ type: 'parett'D} 
} ;t=var ScriptListth;tew r.ADicy(ScriptRecord, r.uin*16);t=//#######################=// FeaturesaandtLookups #=//#######################t=var Featureth;tew r.Struct({tShfeatureParams: r.uin*16,r// poflrertShlookupC unt: r.uin*16,tShlookupListIndexes:;tew r.ADicy(r.uin*16, 'lookupC unt')
} ;t=var FeatureRecordth;tew r.Struct({tShtag:;tew r.Strifo(4),tShfeature:;tew r.Poflrer(r.uin*16, Feature,u{ type: 'parett'D} 
} ;t=var FeatureListth;tew r.ADicy(FeatureRecord, r.uin*16);t=var LookupFlaos = tew r.Struct({tShmarkAttachmetrType: r.uin*8,tShflaos:;tew r.Bitfield(r.uin*8,B['rightToLeft', 'ignoreBaseGlyphs', 'ignoreLigatures', 'ignoreMarks', 'useMarkFil*eringSet'] 
} ;t=functo alLookupList(SubTable)l{ailvar Lookup = tew r.Struct({tShShlookupType: r.uin*16,tShShflaos:;LookupFlaos,tShShsubTableC unt: r.uin*16,tShShsubTables:;tew r.ADicy(tew r.Poflrer(r.uin*16, SubTable), 'subTableC unt'),tShShmarkFil*eringSet:;tew r.Opto aal(r.uin*16, functo a==t l{ailor dred

fut.flaos.flaos.useMarkFil*eringSet;tor d})tSh});ttShred

funew r.LazyADicy(tew r.Poflrer(r.uin*16, Lookup), r.uin*16);t}t=//#################=// Coverage Tablet#=//#################t=var RangeRecordth;tew r.Struct({tShst;rt: r.uin*16,tShend: r.uin*16,tShst;rtCoverageIndex: r.uin*16
} ;t=var Coverage h;tew r.VassioaedStruct(r.uin*16, {tSh1:l{ailorglyphC unt: r.uin*16,tShShglyphs:;tew r.ADicy(r.uin*16, 'glyphC unt')tSh},tSh2:l{ailorrangeC unt: r.uin*16,tShShrangeRecords:;tew r.ADicy(RangeRecord, 'rangeC unt')tSh}
} ;t=//#########################=// Clues Definito a=Tablet#=//#########################t=var CluesRangeRecordth;tew r.Struct({tShst;rt: r.uin*16,tShend: r.uin*16,tShclues: r.uin*16
} ;t=var CluesDefa=+tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // Clues aDicytShShst;rtGlyph: r.uin*16,tShShglyphC unt: r.uin*16,tShShcluesVa leADicy:;tew r.ADicy(r.uin*16, 'glyphC unt')tSh},tSh2:l{ // Clues rangestShShcluesRangeC unt: r.uin*16,tShShcluesRangeRecord:;tew r.ADicy(CluesRangeRecord, ' luesRangeC unt')tSh}
} ;t=//###############=// Device Tablet#=//###############t=var Device h;tew r.Struct({tSha: r.uin*16,r// st;rtSizetforehintifo Device, ourerIndextforeVaria
o aIndextShb: r.uin*16,r// endSizetforeDevice, innerIndextforeVaria
o aIndextShdeltaFormat: r.uin*16
} ;t=//#############################################=// Colrextua  Substitu
o a/Posito aifo Tablest#=//#############################################t=var LookupRecordth;tew r.Struct({tShsequenceIndex: r.uin*16,tShlookupListIndex: r.uin*16
} ;t=var Ruleth;tew r.Struct({tShglyphC unt: r.uin*16,tShlookupC unt: r.uin*16,tShinput:;tew r.ADicy(r.uin*16, functo a==t l{ailorred

fut.glyphC unt - 1, th}),tShlookupRecords:;tew r.ADicy(LookupRecord, 'lookupC unt')
} ;t=var RuleSetth;tew r.ADicy(tew r.Poflrer(r.uin*16, Rule), r.uin*16);t=var CluesRuleth;tew r.Struct({tShglyphC unt: r.uin*16,tShlookupC unt: r.uin*16,tSh lueses:;tew r.ADicy(r.uin*16, functo a==t l{ailorred

fut.glyphC unt - 1, th}),tShlookupRecords:;tew r.ADicy(LookupRecord, 'lookupC unt')
} ;t=var CluesSetth;tew r.ADicy(tew r.Poflrer(r.uin*16, CluesRule), r.uin*16);t=var Colrexta=+tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // SimpletcolrexttShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShruleSetC unt: r.uin*16,tShShruleSets:;tew r.ADicy(tew r.Poflrer(r.uin*16, RuleSet), 'ruleSetC unt')tSh},tSh2:l{ // Clues-basedtcolrexttShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShcluesDef:;tew r.Poflrer(r.uin*16, CluesDef),tShShcluesSetCnt: r.uin*16,tShShcluesSet:;tew r.ADicy(tew r.Poflrer(r.uin*16, CluesSet), 'cluesSetCnt')tSh},tSh3:l{ailorglyphC unt: r.uin*16,tShShlookupC unt: r.uin*16,tShShcoverages:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'glyphC unt'),tShShlookupRecords:;tew r.ADicy(LookupRecord, 'lookupC unt')
Sh}
} ;t=//######################################################=// Chaiaifo Colrextua  Substitu
o a/Posito aifo Tablest#=//######################################################t=var ChaiaRuleth;tew r.Struct({tShbacktrackGlyphC unt: r.uin*16,tShbacktrack:;tew r.ADicy(r.uin*16, 'backtrackGlyphC unt'),tShinputGlyphC unt: r.uin*16,tShinput:;tew r.ADicy(r.uin*16, functo a==t l{ailorred

fut.inputGlyphC unt - 1, th}),tShlookaheadGlyphC unt: r.uin*16,tShlookahead:;tew r.ADicy(r.uin*16, 'lookaheadGlyphC unt'),tShlookupC unt: r.uin*16,tShlookupRecords:;tew r.ADicy(LookupRecord, 'lookupC unt')
} ;t=var ChaiaRuleSetth;tew r.ADicy(tew r.Poflrer(r.uin*16, ChaiaRule), r.uin*16);t=var ChaiaifoColrexta=+tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // Simpletcolrextrglyphhsubstitu
o atShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShchaiaC unt: r.uin*16,tShShchaiaRuleSets:;tew r.ADicy(tew r.Poflrer(r.uin*16, ChaiaRuleSet), 'chaiaC unt')tSh},ttSh2:l{ // Clues-basedtchaiaifo colrexttShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShbacktrackCluesDef:;tew r.Poflrer(r.uin*16, CluesDef),tShShinputCluesDef:;tew r.Poflrer(r.uin*16, CluesDef),tShShlookaheadCluesDef:;tew r.Poflrer(r.uin*16, CluesDef),tShShchaiaC unt: r.uin*16,tShShchaiaCluesSet:;tew r.ADicy(tew r.Poflrer(r.uin*16, ChaiaRuleSet), 'chaiaC unt')tSh},ttSh3:l{ // Coverage-basedtchaiaifo colrexttShShbacktrackGlyphC unt: r.uin*16,tShShbacktrackCoverage:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'backtrackGlyphC unt'),tShShinputGlyphC unt: r.uin*16,tShShinputCoverage:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'inputGlyphC unt'),tShShlookaheadGlyphC unt: r.uin*16,tShShlookaheadCoverage:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'lookaheadGlyphC unt'),tShShlookupC unt: r.uin*16,tShShlookupRecords:;tew r.ADicy(LookupRecord, 'lookupC unt')
Sh}
} ;t=var _;t=/*******************
 *eVaria
o a Store *
 *******************/t=var F2DOT14a=+tew r.Fixed(16, 'BE', 14avavar Rego aAxisCoordinates = tew r.Struct({tShst;rtCoord:;F2DOT14,tShpeakCoord:;F2DOT14,tShendCoord:;F2DOT14
} ;t=var Varia
o aRego aListth;tew r.Struct({tShaxisCount: r.uin*16,tShrego aCount: r.uin*16,tShvaria
o aRego as:;tew r.ADicy(tew r.ADicy(Rego aAxisCoordinates, 'axisCount'), 'rego aCount')
} ;t=var DeltaSetth;tew r.Struct({tShshortDeltas:;tew r.ADicy(r.in*16, functo a==t l{ailorred

fut.parett. hortDeltaCount, th}),tShrego aDeltas:;tew r.ADicy(r.in*8, functo a==t l{ailorred

fut.parett.rego aIndexC unt - t.parett. hortDeltaCount, th}),tShdeltas:;functo aldeltas=t l{ailorred

fut.shortDeltas.colcat(t.rego aDeltas), th}/} ;t=var ItemVaria
o aDatath;tew r.Struct({tShitemCount: r.uin*16,tSh hortDeltaCount: r.uin*16,tShrego aIndexC unt: r.uin*16,tShrego aIndexes:;tew r.ADicy(r.uin*16, 'rego aIndexC unt'),tShdeltaSets:;tew r.ADicy(DeltaSet, 'itemCount')
} ;t=var ItemVaria
o aStore h;tew r.Struct({tShformat: r.uin*16,tShvaria
o aRego aList:;tew r.Poflrer(r.uin*32, Varia
o aRego aList),tShvaria
o aDataC unt: r.uin*16,tShitemVaria
o aData:;tew r.ADicy(tew r.Poflrer(r.uin*32, ItemVaria
o aData), 'varia
o aDataC unt')
} ;t=/**********************
 *eFeaturetVaria
o as *
 **********************/t=var Coldito aTableth;tew r.VassioaedStruct(r.uin*16, {tSh1:l(_ = {ailoraxisIndex: r.uin*16
Sh}, _['axisIndex']t= r.uin*16, _.fil*erRangeMinVa let= F2DOT14, _.fil*erRangeMaxVa let= F2DOT14, _)
} ;t=var Coldito aSetth;tew r.Struct({tShcoldito aC unt: r.uin*16,tSh oldito aTable:;tew r.ADicy(tew r.Poflrer(r.uin*32, Coldito aTable), 'coldito aC unt')
} ;t=var FeatureTableSubstitu
o aRecordth;tew r.Struct({tShfeatureIndex: r.uin*16,tShal*ernateFeatureTable:;tew r.Poflrer(r.uin*32, Feature,u{ type: 'parett'D} 
} ;t=var FeatureTableSubstitu
o ath;tew r.Struct({tShvassioa: r.fixed32,
 hsubstitu
o aCount: r.uin*16,tSh ubstitu
o as:;tew r.ADicy(FeatureTableSubstitu
o aRecord, 'substitu
o aCount')
} ;t=var FeatureVaria
o aRecordth;tew r.Struct({tShcoldito aSet:;tew r.Poflrer(r.uin*32, Coldito aSet,u{ type: 'parett'D} ,tShfeatureTableSubstitu
o a:;tew r.Poflrer(r.uin*32, FeatureTableSubstitu
o a,u{ type: 'parett'D} 
} ;t=var FeatureVaria
o as = tew r.Struct({tShmajorVassioa: r.uin*16,tShminorVassioa: r.uin*16,tShfeatureVaria
o aRecordCount: r.uin*32,
 hfeatureVaria
o aRecords:;tew r.ADicy(FeatureVaria
o aRecord, 'featureVaria
o aRecordCount')
} ;t=// Checksr ==afuopSinndtis afuindex ofea predefined va le,=// ot erwiseddelegates toet edprovidedutype.t=var PredefinedOpth;functo a==)putShfuncto a=PredefinedOp(predefinedOps,rrype) utShor_cluesCa lCheck(l is,tPredefinedOp);t= d  rhis.predefinedOpsth;predefinedOps;t Dorrhis.rype = rype, th}/
orPredefinedOp.protorype.de /   = functo alde /  =s*ream, parett, opSinnds putShor ===rhis.predefinedOps[opSinnds[0]] l{ailor dred

futhis.predefinedOps[opSinnds[0]];tShor}
tShorred

furhis.rype.de /  =s*ream, parett, opSinnds ,t  };/= dPredefinedOp.protorype.sizea=+functo arsize(va le, ctx putShorred

furhis.rype. ize(va le, ctx ;t D};/= dPredefinedOp.protorype.en / wth;functo a=en / w=s*ream, va le, ctx putShorvar index =uthis.predefinedOps.indexOf(va le);tor d ===index !   -1 l{ailor dred

fuindex;tShor}
tShorred

furhis.rype.en / w=s*ream, va le, ctx ;t D};t= dred

f PredefinedOp;
}( ;t=var CFFEn / ifoVassioath;functo a==_r$Numbas) utSh_inherits(CFFEn / ifoVassioa,t_r$Numbas);t= dfuncto a=CFFEn / ifoVassioa( putShor_cluesCa lCheck(l is,tCFFEn / ifoVassioa);t= d  red

fu_possibleConstructorRed

f(l is,t_r$Numbas.ca l(l is,t'UIn*8')), th}/
orCFFEn / ifoVassioa.protorype.de /   = functo alde /  =s*ream putShorred

fur.uin*8.de /  =s*ream p& 0x7f;t D};t= dred

f CFFEn / ifoVassioa;
}(r.Numbas);t=var Range1th;tew r.Struct({tShfirst: r.uin*16,tShnLeft: r.uin*8
} ;t=var Range2th;tew r.Struct({tShfirst: r.uin*16,tShnLeft: r.uin*16
} ;t=var CFFCustomEn / ifot= tew r.VassioaedStruct(tew CFFEn / ifoVassioa( , {tSh0:l{ailoraCodes: r.uin*8,tShShcodes:;tew r.ADicy(r.uin*8, 'aCodes')tSh},ttSh1:l{ailornRanges: r.uin*8,tShShranges: tew r.ADicy(Range1,r'nRanges')
Sh}

or// TODO: supplemetr?
} ;t=var CFFEn / ifot= tew PredefinedOp([St;ndardEn / ifo, ExpSitEn / ifo], tew CFFPoflrer(CFFCustomEn / ifo,u{ lazy: trueD}  ;t=// De /  s afuaDicy oferanges untilet edtoral=//   are  is equal toet edprovidedu  are .t=var RangeADicyth;functo a==_r$ADicy) utSh_inherits(RangeADicy,t_r$ADicy);t= dfuncto a=RangeADicy( putShor_cluesCa lCheck(l is,tRangeADicy);t= d  red

fu_possibleConstructorRed

f(l is,t_r$ADicy.apply(l is,targumetrs)), th}/
orRangeADicy.protorype.de /   = functo alde /  =s*ream, parett putShorvar   are  =hrestructure_src_u
ols.resolveL are =rhis.  are ,ts*ream, parett);tor dvar c unt = 0;tShorvar res = [];tShorwhile (c unt <   are ) utShororvar range =uthis.rype.de /  =s*ream, parett ;t Dor drange.offset = count, thShShcount +=drange.nLeft + 1, th d  res.push(range ;t Dor}
tShorred

f res;t D};t= dred

f RangeADicy;
}(r.ADicy);t=var CFFCustomCharset hBtew r.VassioaedStruct(r.uin*8, {tSh0:l{ailorglyphs:;tew r.ADicy(r.uin*16, functo a==t l{ailor dred

fut.parett.CharStrifos.  are  - 1, th d})tSh},ttSh1:l{ailorranges: tew RangeADicy(Range1,rfuncto a==t l{ailor dred

fut.parett.CharStrifos.  are  - 1, th d})tSh},ttSh2:l{ailorranges: tew RangeADicy(Range2,rfuncto a==t l{ailor dred

fut.parett.CharStrifos.  are  - 1, th d})tSh}
} ;t=var CFFCharset hBtew PredefinedOp([ISOAdobeCharset, ExpSitCharset, ExpSitSubsetCharset], tew CFFPoflrer(CFFCustomCharset, { lazy: trueD}  ;t=var FDRange3th;tew r.Struct({tShfirst: r.uin*16,tShfd: r.uin*8
} ;t=var FDRange4th;tew r.Struct({tShfirst: r.uin*32,
 hfd: r.uin*16
} ;t=var FDSelect hBtew r.VassioaedStruct(r.uin*8, {tSh0:l{ailorfds:;tew r.ADicy(r.uin*8, functo a==t l{ailor dred

fut.parett.CharStrifos.  are , th d})tSh},ttSh3:l{ailornRanges: r.uin*16,tShShranges:;tew r.ADicy(FDRange3,r'nRanges'),tShShsetrinel: r.uin*16
Sh},ttSh4:l{ailornRanges: r.uin*32,
 hShranges:;tew r.ADicy(FDRange4,r'nRanges'),tShShsetrinel: r.uin*32tSh}
} ;t=var p*r = new CFFPoflrer(CFFPrivateDict ;t=var CFFPrivateOpth;functo a==)putShfuncto a=CFFPrivateOp( putShor_cluesCa lCheck(l is,tCFFPrivateOp), th}/
orCFFPrivateOp.protorype.de /   = functo alde /  =s*ream, parett, opSinnds putShorparett.  are  =hopSinnds[0];t Dorred

fup*r.de /  =s*ream, parett, [opSinnds[1]] ;t  };/= dCFFPrivateOp.protorype.sizea=+functo arsize(dict, ctx putShorred

fu[CFFPrivateDict.size(dict, ctx, faltw), p*r.size(dict, ctx [0]];tSh};/= dCFFPrivateOp.protorype.en / wth;functo a=en / w=s*ream, dict, ctx putShorred

fu[CFFPrivateDict.size(dict, ctx, faltw), p*r.en / w=s*ream, dict, ctx [0]];tSh};/= dred

f CFFPrivateOp;
}( ;t=var FontDictth;tew CFFDict([=// keytttttttnameaaaaaaaaaaaaaaaaaaarype(s pppppppppppppppppppppppppppppppppdefault
[18, 'Private', tew CFFPrivateOp( , nurn], [[12, 38], 'FontName', 'sid', nurn]] ;t=var CFFTopDictth;tew CFFDict([=// keytttttttnameaaaaaaaaaaaaaaaaaaarype(s pppppppppppppppppppppppppppppppppdefault
[[12, 30], 'ROS', ['sid', 'sid', 'numbas'], nurn], [0, 'vassioa', 'sid', nurn], [1, 'Notice', 'sid', nurn], [[12, 0], 'Copyright', 'sid', nurn], [2, 'FurnName', 'sid', nurn], [3,r'FamilyName', 'sid', nurn], [4,r'Weight', 'sid', nurn], [[12, 1], 'isFixedPitch', 'boolean', faltw], [[12, 2], 'IralicAfole', 'numbas', 0], [[12, 3], 'U.derlinePosito a', 'numbas', -100], [[12, 4], 'U.derlineThickness', 'numbas', 50], [[12, 5], 'PaitrType', 'numbas', 0], [[12, 6], 'CharstrifoType', 'numbas', 2], [[12, 7], 'FontMatrix', 'aDicy', [0.001, 0, 0, 0.001, 0, 0]], [13, 'U.iqueID', 'numbas', nurn], [5, 'FontBBox', 'aDicy', [0, 0, 0, 0]], [[12, 8], 'StrokeWidst', 'numbas', 0], [14, 'XUID', 'aDicy', nurn], [15, 'charset', CFFCharset, ISOAdobeCharset], [16, 'En / ifo',tCFFEn / ifo, St;ndardEn / ifo], [17, 'CharStrifos', tew CFFPoflrer(tew CFFIndex=  , nurn], [18, 'Private', tew CFFPrivateOp( , nurn], [[12, 20], 'Synt eticBase', 'numbas', nurn], [[12, 21], 'PostScript', 'sid', nurn], [[12, 22], 'BaseFontName', 'sid', nurn], [[12, 23], 'BaseFontB  ad',t'delta', nurn],t=// CID font specific
[[12, 31], 'CIDFontVassioa', 'numbas', 0], [[12, 32], 'CIDFontRevisioa', 'numbas', 0], [[12, 33], 'CIDFontType', 'numbas', 0], [[12, 34], 'CIDCount', 'numbas', 8720], [[12, 35], 'UIDBase', 'numbas', nurn], [[12, 37], 'FDSelect', tew CFFPoflrer(FDSelect , nurn], [[12, 36], 'FDADicy', new CFFPoflrer(tew CFFIndex=FontDict) , nurn], [[12, 38], 'FontName', 'sid', nurn]] ;t=var Varia
o aStore h;tew r.Struct({tSh  are : r.uin*16,tShitemVaria
o aStore: ItemVaria
o aStore
} ;t=var CFF2TopDictth;tew CFFDict([[[12, 7], 'FontMatrix', 'aDicy', [0.001, 0, 0, 0.001, 0, 0]], [17, 'CharStrifos', tew CFFPoflrer(tew CFFIndex=  , nurn], [[12, 37], 'FDSelect', tew CFFPoflrer(FDSelect , nurn], [[12, 36], 'FDADicy', new CFFPoflrer(tew CFFIndex=FontDict) , nurn], [24, 'vst/ie', new CFFPoflrer(Varia
o aStore , nurn], [25, 'maxstack', 'numbas', 193]] ;t=var CFFTop hBtew r.VassioaedStruct(r.fixed16, {tSh1:l{ailorhdrSize: r.uin*8,tShShoffSize: r.uin*8,tShShnameIndex: tew CFFIndex=tew r.Strifo('  are ')),tShShtopDictIndex: tew CFFIndex=CFFTopDict),tShShstrifoIndex: tew CFFIndex=tew r.Strifo('  are ')),tShShglobalSubrIndex: tew CFFIndex=)tSh},ttSh2:l{ailorhdrSize: r.uin*8,tShSh  are : r.uin*16,tShShtopDict: CFF2TopDict,tShShglobalSubrIndex: tew CFFIndex=)tSh}
} ;t=var CFFFontth;functo a==)putShfuncto a=CFFFont=s*ream putShor_cluesCa lCheck(l is,tCFFFont);t= d  rhis.s*reamth;s*ream;t Dorrhis.de /  =), th}/
orCFFFont.de /   = functo alde /  =s*ream putShorred

futew CFFFont=s*ream ;tSh};/= dCFFFont.protorype.de /   = functo alde /  = putShorvar st;rt =uthis.s*ream.pos;tShorvar top hBCFFTop.de /  =this.s*ream ;t Dorfore(var keytin top) utShororvar val =utop[key], th d  this[key] =uval;t Dor}
tShor ===rhis.vassioa < 2) utShoror ===rhis.topDictIndex.  are  !   1 l{ailor d  throwutew Error("Only a sifole font is allowedtin CFF" ;t Dor d}
tShororrhis.ropDictth;rhis.topDictIndex[0];t Dor}t= d  rhis.isCIDFontth;rhis.topDict.ROS !  nurn;t Dorred

furhis;tSh};/= dCFFFont.protorype.strifoa=+functo arstrifo(sid putShor ===rhis.vassioa >= 2) utShororred

futurn;t Dor}
tShor ===sid < st;ndardStrifos.  are ) utShororred

fust;ndardStrifos[sid];tShor}
tShorred

furhis.strifoIndex[sid - st;ndardStrifos.  are ];tSh};/= dCFFFont.protorype.getCharStrifoa=+functo argetCharStrifo(glyph) utShorthis.s*ream.posth;rhis.topDict.CharStrifos[glyph].offset;t Dorred

furhis.s*ream.readBuffer(rhis.topDict.CharStrifos[glyph].  are );tSh};/= dCFFFont.protorype.getGlyphNamea=+functo argetGlyphName(gid putShor// CFF2rglyphhnames aDetin t edpost table.tShor ===rhis.vassioa >= 2) utShororred

futurn;t Dor}
tShor// CID-keyedrfonts doa't haverglyphhnamestShor ===rhis.isCIDFont) utShororred

futurn;t Dor}
tShorvar charset hBrhis.topDict.charset;
tShor ===ADicy.isADicy(charset)) utShororred

fucharset[gid];tShor}
tShor ===gid =   0) utShororred

fu'.notdef';tShor}
tShorgid -= 1, tShShswitch (charset.vassioa) utShororcase 0:ailor d  red

furhis.strifo(charset.glyphs[gid]);t= d  orcase 1:= d  orcase 2:ailor d  fore(var i = 0; i <ucharset.ranges.  are , i++ l{ailor d  orvar range =ucharset.ranges[i], th d  Shor ===range.offset <=rgid &&rgid <=drange.offset +drange.nLeft l{ailor d  or  red

furhis.strifo(range.first +d=gid -drange.offset)), th d  Shor}
 d  Shor}
 d  Shorbreak;tShor}
tShorred

futurn;t D};/= dCFFFont.protorype.fdForGlypha=+functo arfdForGlyph(gid putShor ===!rhis.topDict.FDSelect  utShororred

futurn;t Dor}
tShorswitch (rhis.topDict.FDSelect.vassioa) utShororcase 0:ailor d  red

furhis.topDict.FDSelect.fds[gid];ttShororcase 3:= d  orcase 4:ailor d  var rangesth;rhis.topDict.FDSelect.ranges;ttShorororvar  owu= 0;tShorororvar hig  =hranges.  are  - 1, tShorororwhile ( owu<=dhig  l{ailor d  orvar mid =  owu+ hig  >> 1, tShorororor ===gid <hranges[mid].first l{ailor d  or  hig  =hmid -d1, th d  Shor} else  ===mid <hhig  &&rgid >hranges[mid + 1].first l{ailor d  or   owu= mid + 1, th d  Shor} else {ailor d  or  red

furanges[mid].fd, th d  Shor}
 d  Shor}
 d  Shdefault:ailor d  throwutew Error('Unknown FDSelect vassioa: ' + rhis.topDict.FDSelect.vassioa);t Dor}
 D};/= dCFFFont.protorype.privateDictForGlypha=+functo arprivateDictForGlyph(gid putShor ===rhis.topDict.FDSelect  utShororvar fdth;rhis.fdForGlyph(gid , th d   ===rhis.topDict.FDADicy[fd] l{ailor d  red

furhis.topDict.FDADicy[fd].Private;t Dor d}
tShororred

futurn;t Dor}
tShor ===rhis.vassioa < 2) utShororred

furhis.topDict.Private;t Dor}
tShorred

furhis.ropDict.FDADicy[0].Private;t D};/= d_crea*eClues(CFFFont, [utShorkey: 'postscriptName',tShorget:;functo arget() utShoror ===rhis.vassioa < 2) utShorororred

furhis.nameIndex[0];t Dor d}
tShororred

futurn;t Dor}
Sh}, utShorkey: 'furnName',tShorget:;functo arget() utShororred

furhis.strifo(rhis.ropDict.FurnName);t Dor}
Sh}, utShorkey: 'familyName',tShorget:;functo arget() utShororred

furhis.strifo(rhis.ropDict.FamilyName);t Dor}
Sh}]);/= dred

f CFFFont;
}( ;t=var Vastoca Origiath;tew r.Struct({tShglyphIndex: r.uin*16,tShvastOrigiaY: r.in*16
} ;t=var VORG = tew r.Struct({tShmajorVassioa: r.uin*16,tShminorVassioa: r.uin*16,tShdefaultVastOrigiaY: r.in*16,tShnumVastOrigiaYMetrics: r.uin*16,tShmetrics: tew r.ADicy(Vastoca Origia, 'numVastOrigiaYMetrics')
} ;t=var BigMetrics = tew r.Struct({tShheight: r.uin*8,tShwidst: r.uin*8,tShhoriBearifoX: r.in*8,tShhoriBearifoY: r.in*8,tShhoriAdvance: r.uin*8,tShvastBearifoX: r.in*8,tShvastBearifoY: r.in*8,tShvastAdvance: r.uin*8
} ;t=var Sma lMetrics = tew r.Struct({tShheight: r.uin*8,tShwidst: r.uin*8,tShbearifoX: r.in*8,tShbearifoY: r.in*8,tShadvance: r.uin*8
} ;t=var EBDTComponentth;tew r.Struct({tShglyph: r.uin*16,tShxOffset: r.in*8,tShyOffset: r.in*8
} ;t=var ByteAligned =+functo arByteAligned() utSh_cluesCa lCheck(l is,tByteAligned);t};t=var BitAligned =+functo arBitAligned() utSh_cluesCa lCheck(l is,tBitAligned);t};t=var glypha=+tew r.VassioaedStruct('vassioa', {tSh1:l{ailormetrics: Sma lMetrics,tShordata:;ByteAligned
Sh},ttSh2:l{ailormetrics: Sma lMetrics,tShordata:;BitAligned
Sh},ttSh// format 3 is depreca*edtSh// format 4 is not suppor*ed by MicrosoftttSh5:l{ailordata:;BitAligned
Sh},ttSh6:l{ailormetrics: BigMetrics,tShordata:;ByteAligned
Sh},ttSh7:l{ailormetrics: BigMetrics,tShordata:;BitAligned
Sh},ttSh8:l{ailormetrics: Sma lMetrics,tShorpad:;tew r.Reserved(r.uin*8),tShShnumComponents: r.uin*16,tShShcomponents: tew r.ADicy(EBDTComponent, 'numComponents')tSh},ttSh9:l{ailormetrics: BigMetrics,tShorpad:;tew r.Reserved(r.uin*8),tShShnumComponents: r.uin*16,tShShcomponents: tew r.ADicy(EBDTComponent, 'numComponents')tSh},ttSh17:l{ailormetrics: Sma lMetrics,tShordataLen: r.uin*32,
 hShdata:;tew r.Buffer('dataLen')tSh},ttSh18:l{ailormetrics: BigMetrics,tShordataLen: r.uin*32,
 hShdata:;tew r.Buffer('dataLen')tSh},ttSh19:l{ailordataLen: r.uin*32,
 hShdata:;tew r.Buffer('dataLen')tSh}
} ;t=var SBitLineMetrics = tew r.Struct({tShasce.der: r.in*8,tShdesce.der: r.in*8,tShwidstMax: r.uin*8,tShcaredSlopeNumerator: r.in*8,tShcaredSlopeDenominator: r.in*8,tShcaredOffset: r.in*8,tShminOrigiaSB: r.in*8,tShminAdvanceSB: r.in*8,tShmaxBeforeBL: r.in*8,tShminAfterBL: r.in*8,tShpad:;tew r.Reserved(r.in*8, 2)
} ;t=var CodeOffsetPairth;tew r.Struct({tShglyphCode: r.uin*16,tShoffset: r.uin*16
} ;t=var IndexSubtableth;tew r.VassioaedStruct(r.uin*16, {tShheader:l{ailorimageFormat: r.uin*16,ailorimageDataOffset: r.uin*32tSh},ttSh1:l{ailoroffsetADicy:;tew r.ADicy(r.uin*32,rfuncto a==t l{ailor dred

fut.parett.luetGlyphIndext- t.parett.firstGlyphIndext+ 1, th d})tSh},ttSh2:l{ailorimageSize: r.uin*32,
 hShbigMetrics: BigMetricstSh},ttSh3:l{ailoroffsetADicy:;tew r.ADicy(r.uin*16, functo a==t l{ailor dred

fut.parett.luetGlyphIndext- t.parett.firstGlyphIndext+ 1, th d})tSh},ttSh4:l{ailornumGlyphs:;r.uin*32,
 hShglyphADicy:;tew r.ADicy(CodeOffsetPair, functo a==t l{ailor dred

fut.numGlyphst+ 1, th d})tSh},ttSh5:l{ailorimageSize: r.uin*32,
 hShbigMetrics: BigMetrics,ailornumGlyphs:;r.uin*32,
 hShglyphCodeADicy:;tew r.ADicy(r.uin*16, 'numGlyphs')tSh}
} ;t=var IndexSubtableADicyth;tew r.Struct({tShfirstGlyphIndex: r.uin*16,tShluetGlyphIndex: r.uin*16,tSh ubtable:;tew r.Poflrer(r.uin*32, IndexSubtable)
} ;t=var BitmapSizeTableth;tew r.Struct({tShindexSubTableADicy:;tew r.Poflrer(r.uin*32, tew r.ADicy(IndexSubtableADicy, 1),u{ type: 'parett'D} ,tShindexTablesSize: r.uin*32,
 hnumbasOfIndexSubTables:;r.uin*32,
 h /lorRef:;r.uin*32,
 hhori: SBitLineMetrics,tShvast: SBitLineMetrics,tShst;rtGlyphIndex: r.uin*16,tShe.dGlyphIndex: r.uin*16,tShppemX: r.uin*8,tShppemY: r.uin*8,tShbitDepst: r.uin*8,tShflaos:;tew r.Bitfield(r.uin*8,B['horizontal', 'vastoca '] 
} ;t=var EBLCth;tew r.Struct({tShvassioa: r.uin*32, // 0x00020000
 hnumSizes:;r.uin*32,
 hsizes:;tew r.ADicy(BitmapSizeTable, 'numSizes')
} ;t=var ImageTableth;tew r.Struct({tShppem: r.uin*16,tShresolu
o a:;r.uin*16,tShimageOffsets:;tew r.ADicy(tew r.Poflrer(r.uin*32, 'void'), functo a==t l{ailorred

fut.parett.parett.maxp.numGlyphst+ 1, th})
} ;t=// T is is t edApple sbix table, used by t ed"Apple C/lor Emoji"rfont.=// Ithinclu  s severalhimage tableshwie  images foreeachhbitmaphglyph=// of severalhdifferenttsizes.=var sbix h;tew r.Struct({tShvassioa: r.uin*16,tShflaos:;tew r.Bitfield(r.uin*16, ['re.derOutlines'] ,
 hnumImgTables:;r.uin*32,
 himageTables:;tew r.ADicy(tew r.Poflrer(r.uin*32, ImageTable), 'numImgTables')
} ;t=var LayerRecordth;tew r.Struct({tShgid: r.uin*16, // GlyphaID of layer glypha(musthbetin z-order from bottom toetop).tShpaletteIndex: r.uin*16 // Indextva le toeusetin t edappropria
ehpalette. T is va le must
} ; // betless t afutumPaletteEntries in t edCPAL table, exceps for=// t edspecialhcase no*ed below. Eachhpalettehe.try is 16 bits.=// Ahpalettehindex ofe0xFFFF is adspecialhcase indocatifo t at=// t edrextrforegroundh /lorh hould be used.t=var BaseGlyphRecordth;tew r.Struct({tShgid: r.uin*16, // GlyphaID of referencerglyph. T is glyphais forereferenceronlytSh// nndtis not re.deredrforh /lor.tShfirstLayerIndex: r.uin*16, // Indext(from begiaaifo of t edLayer Records) toet edlayer record.tSh// Therehwill be tumLayershcolsecu
ovehe.tries forel is baserglyph.
 hnumLayers: r.uin*16
} ;t=var COLR h;tew r.Struct({tShvassioa: r.uin*16,tShnumBaseGlyphRecords: r.uin*16,tShbaseGlyphRecord:;tew r.Poflrer(r.uin*32, tew r.ADicy(BaseGlyphRecord, 'numBaseGlyphRecords')),tShlayerRecords:;tew r.Poflrer(r.uin*32, tew r.ADicy(LayerRecord, 'numLayerRecords'), { lazy: trueD} ,
 hnumLayerRecords: r.uin*16
} ;t=var ColorRecordth;tew r.Struct({tShb le: r.uin*8,tShgreen: r.uin*8,tShred: r.uin*8,tShalpha: r.uin*8
} ;t=var CPAL h;tew r.VassioaedStruct(r.uin*16, {tShheader:l{ailortumPaletteEntries: r.uin*16,ailortumPalettes: r.uin*16,ailortumColorRecords: r.uin*16,tShShcolorRecords: tew r.Poflrer(r.uin*32, tew r.ADicy(ColorRecord, 'numColorRecords')),tShShcolorRecordIndoces:;tew r.ADicy(r.uin*16, 'tumPalettes')tSh},tSh0:l{},tSh1:l{ailoroffsetPaletteTypeADicy:;tew r.Poflrer(r.uin*32, tew r.ADicy(r.uin*32, 'tumPalettes')),ailoroffsetPaletteLabelADicy:;tew r.Poflrer(r.uin*32, tew r.ADicy(r.uin*16, 'tumPalettes')),ailoroffsetPaletteEntryLabelADicy:;tew r.Poflrer(r.uin*32, tew r.ADicy(r.uin*16, 'tumPaletteEntries'))tSh}
} ;t=var BaseCoorda=+tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // Desigf unitsronlytShShcoordinate: r.in*16 // X oreY va le, ialdesigf unitstSh},ttSh2:l{ // Desigf unitsrplus colrour poflrtShShcoordinate: r.in*16, // X oreY va le, ialdesigf unitstSh ereferenceGlyph: r.uin*16, // GlyphID of colrrolhglyph= hShbaseCoordPoflr: r.uin*16 // Indextof colrour poflrronet edreferenceGlyphtSh},ttSh3:l{ // Desigf unitsrplus Device tabletShShcoordinate: r.in*16, // X oreY va le, ialdesigf unitstSh edeviceTable:;tew r.Poflrer(r.uin*16, Device) // Device tabletforeX oreY va letSh}
} ;t=var BaseVa les = tew r.Struct({tShdefaultIndex: r.uin*16, // Indextof defaulthbaseline forel is script-sameaindex in t edBaseTagList
ShbaseCoordC unt: r.uin*16,tShbaseCoords:;tew r.ADicy(tew r.Poflrer(r.uin*16, BaseCoord), 'baseCoordC unt')
} ;t=var FeatMinMaxRecordth;tew r.Struct({tShtag:;tew r.Strifo(4), // 4-bytehfeature idetrifocationetag-musthmatch FeatureTag in FeatureListtShminCoord:;tew r.Poflrer(r.uin*16, BaseCoord,u{ type: 'parett'D} , // May be NULLtShmaxCoord:;tew r.Poflrer(r.uin*16, BaseCoord,u{ type: 'parett'D}  // May be NULLt} ;t=var MinMax = tew r.Struct({tShminCoord:;tew r.Poflrer(r.uin*16, BaseCoord , // May be NULLtShmaxCoord:;tew r.Poflrer(r.uin*16, BaseCoord , // May be NULLtShfeatMinMaxC unt: r.uin*16, // May be 0tShfeatMinMaxRecords:;tew r.ADicy(FeatMinMaxRecord, 'featMinMaxC unt') // Inhalphabetoca  order
} ;t=var BaseLangSysRecordth;tew r.Struct({tShtag:;tew r.Strifo(4), // 4-bytehlanguage system idetrifocationetagtShminMax: tew r.Poflrer(r.uin*16, MinMax,u{ type: 'parett'D} 
} ;t=var BaseScriptth;tew r.Struct({tShbaseVa les:;tew r.Poflrer(r.uin*16, BaseVa les , // May be NULLtShdefaultMinMax: tew r.Poflrer(r.uin*16, MinMax , // May be NULLtShbaseLangSysC unt: r.uin*16, // May be 0tShbaseLangSysRecords:;tew r.ADicy(BaseLangSysRecord, 'baseLangSysC unt') // inhalphabetoca  order by BaseLangSysTag
} ;t=var BaseScriptRecordth;tew r.Struct({tShtag:;tew r.Strifo(4), // 4-bytehscript idetrifocationetagtShscript:;tew r.Poflrer(r.uin*16, BaseScript,u{ type: 'parett'D} 
} ;t=var BaseScriptListth;tew r.ADicy(BaseScriptRecord, r.uin*16);t=// ADicy ofe4-bytehbaseline idetrifocationetags-musthbetin alphabetoca  order
var BaseTagListth;tew r.ADicy(tew r.Strifo(4), r.uin*16);t=var Axisth;tew r.Struct({tShbaseTagList:;tew r.Poflrer(r.uin*16, BaseTagList , // May be NULLtShbaseScriptList:;tew r.Poflrer(r.uin*16, BaseScriptList 
} ;t=var BASEa=+tew r.VassioaedStruct(r.uin*32, {tShheader:l{ailorhorizAxis:;tew r.Poflrer(r.uin*16, Axis , // May be NULLtShShvastAxis:;tew r.Poflrer(r.uin*16, Axis  // May be NULLtSh},ttSh0x00010000:l{},tSh0x00010001:l{ailoritemVaria
o aStore: tew r.Poflrer(r.uin*32, ItemVaria
o aStore)tSh}
} ;t=var AttachPoflrth;tew r.ADicy(r.uin*16, r.uin*16);tvar AttachListth;tew r.Struct({tShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShglyphC unt: r.uin*16,tShattachPoflrs:;tew r.ADicy(tew r.Poflrer(r.uin*16, AttachPoflr), 'glyphC unt')
} ;t=var CaredVa let= tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // Desigf unitsronlytShShcoordinate: r.in*16tSh},ttSh2:l{ // Colrour poflrtShShcaredVa lePoflr: r.uin*16tSh},ttSh3:l{ // Desigf unitsrplus Device tabletShShcoordinate: r.in*16,tSh edeviceTable:;tew r.Poflrer(r.uin*16, Device)tSh}
} ;t=var LigGlypha=+tew r.ADicy(tew r.Poflrer(r.uin*16, CaredVa le), r.uin*16);t=var LigCaredListth;tew r.Struct({tShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShligGlyphC unt: r.uin*16,tShligGlyphs:;tew r.ADicy(tew r.Poflrer(r.uin*16, LigGlyph), 'ligGlyphC unt')
} ;t=var MarkGlyphSetsDefa=+tew r.Struct({tShmarkSetTableFormat: r.uin*16,ailmarkSetC unt: r.uin*16,tSh overage:;tew r.ADicy(tew r.Poflrer(r.uin*32, Coverage), 'markSetC unt')
} ;t=var GDEFa=+tew r.VassioaedStruct(r.uin*32, {tShheader:l{ailorglyphCluesDef:;tew r.Poflrer(r.uin*16, CluesDef),tShShattachList:;tew r.Poflrer(r.uin*16, AttachList),tShShligCaredList:;tew r.Poflrer(r.uin*16, LigCaredList),tShShmarkAttachCluesDef:;tew r.Poflrer(r.uin*16, CluesDef)tSh},ttSh0x00010000:l{},tSh0x00010002:l{ailormarkGlyphSetsDef: tew r.Poflrer(r.uin*16, MarkGlyphSetsDef)tSh},tSh0x00010003:l{ailormarkGlyphSetsDef: tew r.Poflrer(r.uin*16, MarkGlyphSetsDef),ailoritemVaria
o aStore: tew r.Poflrer(r.uin*32, ItemVaria
o aStore)tSh}
} ;t=var Va leFormata=+tew r.Bitfield(r.uin*16, ['xPlacemetr', 'yPlacemetr', 'xAdvance', 'yAdvance', 'xPlaDevice', 'yPlaDevice', 'xAdvDevice', 'yAdvDevice'] ;t=var types = {ailxPlacemetr: r.in*16,tShyPlacemetr: r.in*16,tShxAdvance: r.in*16,tShyAdvance: r.in*16,tShxPlaDevice:;tew r.Poflrer(r.uin*16, Device,u{ type: 'global', rela
oveTo: 'rel'D} ,tShyPlaDevice:;tew r.Poflrer(r.uin*16, Device,u{ type: 'global', rela
oveTo: 'rel'D} ,tShxAdvDevice:;tew r.Poflrer(r.uin*16, Device,u{ type: 'global', rela
oveTo: 'rel'D} ,tShyAdvDevice:;tew r.Poflrer(r.uin*16, Device,u{ type: 'global', rela
oveTo: 'rel'D} t};t=var Va leRecordth;functo a==)putShfuncto a=Va leRecord= putShorvar keyt=targumetrs.  are  > 0 &&rargumetrs[0] !   undefined ?rargumetrs[0] : 'va leFormat', tShor_cluesCa lCheck(l is,tVa leRecord);t= d  rhis.keyt=tkey, th}t= dVa leRecord.protorype.buildStructth;functo a=buildStruct(parett putShorvar structth;parett, th dwhile (!struct[rhis.key] &&rstruct.parett putShor  structth;struct.parett;t Dor}
tShor ===!struct[rhis.key])rred

f;
tShorvar fields = {};t Dorfields.relth;functo a==)putShilorred

fustruct._st;rtOffset;t Dor};
tShorvar formata=+struct[rhis.key];t Dorfore(var keytin format) utShoror ===format[key])rutShorororfields[key] =utypes[key], th d  }t Dor}
tShorred

funew r.Struct(fields);tSh};/= dVa leRecord.protorype.sizea=+functo arsize(va , ctx putShorred

furhis.buildStruct(ctx .size(va , ctx ;tSh};/= dVa leRecord.protorype.de /   = functo alde /  =s*ream, parett putShorvar resth;rhis.buildStruct(parett .de /  =s*ream, parett ;t Dordelete res.rel;tShorred

fures;t D};t= dred

f Va leRecord;
}( ;t=var PairVa leRecordth;tew r.Struct({tShsecoldGlyph: r.uin*16,tShva le1:;tew Va leRecord='va leFormat1'),tShva le2:;tew Va leRecord='va leFormat2')
} ;t=var PairSetth;tew r.ADicy(PairVa leRecord, r.uin*16);t=var Clues2Recordth;tew r.Struct({tShva le1:;tew Va leRecord='va leFormat1'),tShva le2:;tew Va leRecord='va leFormat2')
} ;t=var Anchort= tew r.VassioaedStruct(r.uin*16, {tSh1:l{ // Desigf unitsronlytShShxCoordinate: r.in*16,tSh eyCoordinate: r.in*16tSh},ttSh2:l{ // Desigf unitsrplus colrour poflrtShShxCoordinate: r.in*16,tSh eyCoordinate: r.in*16,tShShanchorPoflr: r.uin*16tSh},ttSh3:l{ // Desigf unitsrplus Device tablestShShxCoordinate: r.in*16,tSh eyCoordinate: r.in*16,tShShxDeviceTable:;tew r.Poflrer(r.uin*16, Device),tSh eyDeviceTable:;tew r.Poflrer(r.uin*16, Device)tSh}
} ;t=var EntryExitRecordth;tew r.Struct({tShe.tryAnchor:;tew r.Poflrer(r.uin*16, Anchor,u{ type: 'parett'D} ,tShexitAnchor:;tew r.Poflrer(r.uin*16, Anchor,u{ type: 'parett'D} 
} ;t=var MarkRecordth;tew r.Struct({tShclues: r.uin*16,ailmarkAnchor:;tew r.Poflrer(r.uin*16, Anchor,u{ type: 'parett'D} 
} ;t=var MarkADicyth;tew r.ADicy(MarkRecord, r.uin*16);t=var BaseRecordth;tew r.ADicy(tew r.Poflrer(r.uin*16, Anchor), functo a==t l{ailred

fut.parett.cluesCount, });tvar BaseADicyth;tew r.ADicy(BaseRecord, r.uin*16);t=var ComponentRecordth;tew r.ADicy(tew r.Poflrer(r.uin*16, Anchor), functo a==t l{ailred

fut.parett.parett.cluesCount, });tvar LigatureAttachth;tew r.ADicy(ComponentRecord, r.uin*16);tvar LigatureADicyth;tew r.ADicy(tew r.Poflrer(r.uin*16, LigatureAttach), r.uin*16);t=var GPOSLookup = tew r.VassioaedStruct('lookupType', {tSh1:ltew r.VassioaedStruct(r.uin*16, { // Sifole AdjustmetrtSh e1:l{ // Sifole posito aifo va letShShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShva leFormat: Va leFormat,tShShShva le:;tew Va leRecord=)t Dor},tShSh2:l{ailorShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShva leFormat: Va leFormat,tShShShva leC unt: r.uin*16,tShShShva les:;tew r.LazyADicy(tew Va leRecord=), 'va leC unt')
Shor}
Sh}),ttSh2:ltew r.VassioaedStruct(r.uin*16, { // PairtAdjustmetr Posito aifotSh e1:l{ // Adjustmetrs foreglyphapairsailorShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShva leFormat1: Va leFormat,tShShShva leFormat2: Va leFormat,tShShShpairSetC unt: r.uin*16,tShShShpairSets:;tew r.LazyADicy(tew r.Poflrer(r.uin*16, PairSet), 'pairSetC unt')t Dor},ttShSh2:l{ // Clues pair adjustmetrtSh eShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShva leFormat1: Va leFormat,tShShShva leFormat2: Va leFormat,tShShShcluesDef1:;tew r.Poflrer(r.uin*16, CluesDef),tShShShcluesDef2:;tew r.Poflrer(r.uin*16, CluesDef),tShShShclues1C unt: r.uin*16,tShShShclues2C unt: r.uin*16,tShShShcluesRecords:;tew r.LazyADicy(tew r.LazyADicy(Clues2Record, 'clues2Count'), 'clues1C unt')
Shor}
Sh}),ttSh3:l{ // Cussive Attachmetr Posito aifotSh eformat: r.uin*16,tShShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShentryExitC unt: r.uin*16,tShShentryExitRecords: tew r.ADicy(EntryExitRecord, 'entryExitC unt')tSh},ttSh4:l{ // MarkToBase Attachmetr Posito aifotSh eformat: r.uin*16,tShShmarkCoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShbaseCoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShcluesC unt: r.uin*16,tShShmarkADicy: tew r.Poflrer(r.uin*16, MarkADicy),tShShbaseADicy: tew r.Poflrer(r.uin*16, BaseADicy)tSh},ttSh5:l{ // MarkToLigature Attachmetr Posito aifotSh eformat: r.uin*16,tShShmarkCoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShligatureCoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShcluesC unt: r.uin*16,tShShmarkADicy: tew r.Poflrer(r.uin*16, MarkADicy),tShShligatureADicy:;tew r.Poflrer(r.uin*16, LigatureADicy)tSh},ttSh6:l{ // MarkToMark Attachmetr Posito aifotSh eformat: r.uin*16,tShShmark1Coverage:;tew r.Poflrer(r.uin*16, Coverage),tShShmark2Coverage:;tew r.Poflrer(r.uin*16, Coverage),tShShcluesC unt: r.uin*16,tShShmark1ADicy: tew r.Poflrer(r.uin*16, MarkADicy),tShShmark2ADicy: tew r.Poflrer(r.uin*16, BaseADicy)tSh},ttSh7: Colrext, // Colrextua  posito aifotSh8: ChaiaifoColrext, // Chaiaifo colrextua  posito aifot
Sh9:l{ // Extensioa Posito aifotSh eposFormat: r.uin*16,ailorlookupType: r.uin*16, // cannot also be 9tShShextensioa: tew r.Poflrer(r.uin*32, GPOSLookup)
Sh}
} ;t=// Fix circularereference
GPOSLookup.vassioas[9].extensioa.rype = GPOSLookup;t=var GPOSa=+tew r.VassioaedStruct(r.uin*32, {tShheader:l{ailorscriptList:;tew r.Poflrer(r.uin*16, ScriptList ,ailorfeatureList:;tew r.Poflrer(r.uin*16, FeatureList),tShShlookupList:;tew r.Poflrer(r.uin*16, tew LookupList(GPOSLookup))tSh},ttSh0x00010000:l{},tSh0x00010001:l{ailorfeatureVaria
o as: tew r.Poflrer(r.uin*32, FeatureVaria
o as)tSh}
} ;t=var Sequencerh;tew r.ADicy(r.uin*16, r.uin*16);tvar Al*ernateSetth;Sequence;t=var Ligature h;tew r.Struct({tShglyph: r.uin*16,tShcompC unt: r.uin*16,tSh omponents: tew r.ADicy(r.uin*16, functo a==t l{ailorred

fut.compC unt - 1, th})
} ;t=var LigatureSetth;tew r.ADicy(tew r.Poflrer(r.uin*16, Ligature), r.uin*16);t=var GSUBLookup = tew r.VassioaedStruct('lookupType', {tSh1:ltew r.VassioaedStruct(r.uin*16, { // Sifole Substitu
o atShSh1:l{ailorShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShdeltaGlyphID: r.in*16tShor},tShSh2:l{ailorShcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShShglyphC unt: r.uin*16,tShShSh ubstitu
e:;tew r.LazyADicy(r.uin*16, 'glyphC unt')
Shor}
Sh}),ttSh2:l{ // Multiple Substitu
o atShSh ubstFormat: r.uin*16,ailorcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShc unt: r.uin*16,tShShsequences:;tew r.LazyADicy(tew r.Poflrer(r.uin*16, Sequence), 'count')tSh},ttSh3:l{ // Al*ernate Substitu
o atShSh ubstFormat: r.uin*16,ailorcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShc unt: r.uin*16,tShShal*ernateSet:;tew r.LazyADicy(tew r.Poflrer(r.uin*16, Al*ernateSet), 'count')tSh},ttSh4:l{ // Ligature Substitu
o atShSh ubstFormat: r.uin*16,ailorcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShc unt: r.uin*16,tShShligatureSets:;tew r.LazyADicy(tew r.Poflrer(r.uin*16, LigatureSet), 'count')tSh},ttSh5: Colrext, // Colrextua  Substitu
o atSh6: ChaiaifoColrext, // Chaiaifo Colrextua  Substitu
o attSh7: { // Extensioa Substitu
o atShSh ubstFormat: r.uin*16,ailorlookupType: r.uin*16, // cannot also be 7tShShextensioa: tew r.Poflrer(r.uin*32, GSUBLookup)tSh},ttSh8: { // Reverse Chaiaifo Colrextua  Sifole Substitu
o atShSh ubstFormat: r.uin*16,ailorcoverage:;tew r.Poflrer(r.uin*16, Coverage),tShShbacktrackCoverage:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'backtrackGlyphC unt'),tShShlookaheadGlyphC unt: r.uin*16,tShShlookaheadCoverage:;tew r.ADicy(tew r.Poflrer(r.uin*16, Coverage), 'lookaheadGlyphC unt'),tShShglyphC unt: r.uin*16,tShSh ubstitu
es:;tew r.ADicy(r.uin*16, 'glyphC unt')
Sh}
} ;t=// Fix circularereference
GSUBLookup.vassioas[7].extensioa.rype = GSUBLookup;t=var GSUBa=+tew r.VassioaedStruct(r.uin*32, {tShheader:l{ailorscriptList:;tew r.Poflrer(r.uin*16, ScriptList ,ailorfeatureList:;tew r.Poflrer(r.uin*16, FeatureList),tShShlookupList:;tew r.Poflrer(r.uin*16, tew LookupList(GSUBLookup))tSh},ttSh0x00010000:l{},tSh0x00010001:l{ailorfeatureVaria
o as: tew r.Poflrer(r.uin*32, FeatureVaria
o as)tSh}
} ;t=var JstfGSUBModListth;tew r.ADicy(r.uin*16, r.uin*16);t=var JstfPriorityth;tew r.Struct({tShshrinkageEnableGSUB:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShshrinkageDisableGSUB:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShshrinkageEnableGPOS:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShshrinkageDisableGPOS:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShshrinkageJstfMax: tew r.Poflrer(r.uin*16, tew LookupList(GPOSLookup)),tShextensioaEnableGSUB:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShextensioaDisableGSUB:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShextensioaEnableGPOS:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShextensioaDisableGPOS:;tew r.Poflrer(r.uin*16, JstfGSUBModList),tShextensioaJstfMax: tew r.Poflrer(r.uin*16, tew LookupList(GPOSLookup))
} ;t=var JstfLangSysth;tew r.ADicy(tew r.Poflrer(r.uin*16, JstfPriority), r.uin*16);t=var JstfLangSysRecordth;tew r.Struct({tShtag:;tew r.Strifo(4),tShjstfLangSys:;tew r.Poflrer(r.uin*16, JstfLangSys)
} ;t=var JstfScriptth;tew r.Struct({tShextenderGlyphs:;tew r.Poflrer(r.uin*16, tew r.ADicy(r.uin*16, r.uin*16) , // aDicy ofeglyphs toeextend line   are 
ShdefaultLangSys:;tew r.Poflrer(r.uin*16, JstfLangSys),tShlangSysC unt: r.uin*16,tShlangSysRecords: tew r.ADicy(JstfLangSysRecord, 'langSysC unt')
} ;t=var JstfScriptRecordth;tew r.Struct({tShtag:;tew r.Strifo(4),tShscript:;tew r.Poflrer(r.uin*16, JstfScript,u{ type: 'parett'D} 
} ;t=var JSTFth;tew r.Struct({tShvassioa: r.uin*32, //  hould be 0x00010000tShscriptCount: r.uin*16,tSh criptList:;tew r.ADicy(JstfScriptRecord, 'scriptCount')
} ;t=// TODO: addel is toerestructuret=var VariableSizeNumbasth;functo a==)putShfuncto a=VariableSizeNumbas(size putShor_cluesCa lCheck(l is,tVariableSizeNumbas);t= d  rhis._sizea=+size, th}t= dVariableSizeNumbas.protorype.de /   = functo alde /  =s*ream, parett putShorswitch (rhis.size(0, parett ) utShororcase 1:ailor d  red

fus*ream.readUIn*8( , th d  case 2:ailor d  red

fus*ream.readUIn*16BE( , th d  case 3:ailor d  red

fus*ream.readUIn*24BE( , th d  case 4:ailor d  red

fus*ream.readUIn*32BE( , th d}
 D};/= dVariableSizeNumbas.protorype.sizea=+functo arsize(va , parett putShorred

furestructure_src_u
ols.resolveL are =rhis._size, nurn, parett ;t D};t= dred

f VariableSizeNumbas;
}( ;t=var MapDataEntryth;tew r.Struct({tShe.try:;tew VariableSizeNumbas(functo a==t l{ailorred

fu((t.parett.e.tryFormata& 0x0030) >> 4)t+ 1, th}),tShou
erIndex: functo a=ou
erIndex=t l{ailorred

fut.e.try >> (t.parett.e.tryFormata& 0x000F)t+ 1, th},tShinnerIndex: functo a=innerIndex=t l{ailorred

fut.e.try & (1 << (t.parett.e.tryFormata& 0x000F)t+ 1) - 1, th}
} ;t=var DeltaSetIndexMapth;tew r.Struct({tShe.tryFormat: r.uin*16,ailmapC unt: r.uin*16,tShmapData:;tew r.ADicy(MapDataEntry, 'mapC unt')
} ;t=var HVAR h;tew r.Struct({tShmajorVassioa: r.uin*16,tShminorVassioa: r.uin*16,tShitemVaria
o aStore: tew r.Poflrer(r.uin*32, ItemVaria
o aStore),tShadvanceWidstMappifo: tew r.Poflrer(r.uin*32, DeltaSetIndexMap),tShLSBMappifo: tew r.Poflrer(r.uin*32, DeltaSetIndexMap),tShRSBMappifo: tew r.Poflrer(r.uin*32, DeltaSetIndexMap)
} ;t=var Signature h;tew r.Struct({tShformat: r.uin*32,
 h  are : r.uin*32,
 hoffset: r.uin*32t} ;t=var SignatureBlock h;tew r.Struct({tShreserved: tew r.Reserved(r.uin*16, 2),tShcbSignature: r.uin*32, // L are ==in bytes) of t edPKCS#7 packethin pbSignaturetSh ignature: tew r.Buffer('cbSignature')
} ;t=var DSIG = tew r.Struct({tShulVassioa: r.uin*32, // Vassioatnumbas of t edDSIG tablet(0x00000001)tShusNumSigs: r.uin*16, // Numbas of  ignatures in t edtabletShusFlag:;r.uin*16, // PermissioatflaostSh ignatures: tew r.ADicy(Signature, 'usNumSigs'),tShsignatureBlocks: tew r.ADicy(SignatureBlock, 'usNumSigs')
} ;t=var GaspRange =utew r.Struct({tShrangeMaxPPEM:;r.uin*16, // Uppas limit oferange, ialppemtShrangeGaspBehavior:;tew r.Bitfield(r.uin*16, [// Flaoshdescribifo desiredrrasrerizer behaviortSh'gicyscale', 'gridfit', 'symmetricSmoorhifo',t'symmetricGridfit' // only ialvassioa 1,rfor ClearTypetSh] 
} ;t=var gasp h;tew r.Struct({tShvassioa: r.uin*16, //  ethtoe0
 hnumRanges: r.uin*16,tShgaspRanges: tew r.ADicy(GaspRange, 'tumRanges') // Sor*ed by ppemt} ;t=var DeviceRecordth;tew r.Struct({tShpixelSize: r.uin*8,tShmaximumWidst: r.uin*8,tShwidsts:;tew r.ADicy(r.uin*8, functo a==t l{ailorred

fut.parett.parett.maxp.numGlyphs, th})
} ;t=// T e Horizontal Device Metrics tabletst/ies integerhadvancehwidsts scaledhtoeparticularepixeltsizes=var hdmx h;tew r.Struct({tShvassioa: r.uin*16,tShtumRecords: r.in*16,tSh izeDeviceRecord: r.in*32,
 hrecords: tew r.ADicy(DeviceRecord, 'tumRecords')t} ;t=var KernPairth;tew r.Struct({tShleft: r.uin*16,tShright: r.uin*16,tShva le: r.in*16t} ;t=var CluesTableth;tew r.Struct({tShfirstGlyph: r.uin*16,tShtGlyphs:;r.uin*16,tShoffsets:;tew r.ADicy(r.uin*16, 'tGlyphs'),tShmax: functo a=max=t l{ailorred

fut.offsets.  are  && Math.max.apply(Mae ,tt.offsets), th}
} ;t=var Kern2ADicyth;tew r.Struct({tShoff: functo a=off=t l{ailorred

fut._st;rtOffsett- t.parett.parett._st;rtOffset;t D},
 h  a: functo a=  a=t l{ailorred

fu((t.parett.leftTable.maxt- t.off) / t.parett.rowWidstt+ 1) * (t.parett.rowWidstt/ 2);t D},
 hva les:;tew r.LazyADicy(r.in*16, '  a')t} ;t=var KernSubtableth;tew r.VassioaedStruct('format', {tSh0:l{ailornPairs: r.uin*16,tShShsearchRange: r.uin*16,tShShentrySelector: r.uin*16,tShShrangeShift: r.uin*16,tShShpairs:;tew r.ADicy(KernPair, 'tPairs')tSh},ttSh2:l{ailorrowWidst: r.uin*16,tShShleftTable:;tew r.Poflrer(r.uin*16, CluesTable, { type: 'parett'D} ,tShShrightTable:;tew r.Poflrer(r.uin*16, CluesTable, { type: 'parett'D} ,tShShaDicy: tew r.Poflrer(r.uin*16, Kern2ADicy,u{ type: 'parett'D} 
Sh},ttSh3:l{ailorglyphC unt: r.uin*16,tShShkernVa leC unt: r.uin*8,tShShleftCluesC unt: r.uin*8,tShShrightCluesC unt: r.uin*8,tShShflaos:;r.uin*8,tShShkernVa le:;tew r.ADicy(r.in*16, 'kernVa leC unt'),tShShleftClues:;tew r.ADicy(r.uin*8, 'glyphC unt'),tShShrightClues:;tew r.ADicy(r.uin*8, 'glyphC unt'),tShShkernIndex: tew r.ADicy(r.uin*8, functo a==t l{ailor dred

fut.leftCluesC unt * t.rightCluesC unt, th d})tSh}t} ;t=var KernTableth;tew r.VassioaedStruct('vassioa', {tSh0:l{ // Microsoft usesel is format
ShSh ubVassioa: r.uin*16, // Microsoft has aneextrah ub-tabletvassioatnumbastShShleare : r.uin*16, // L are =of t ed ubtable, ialbytestShShformat: r.uin*8, // Formataof  ubtabletShShcoverage:;tew r.Bitfield(r.uin*8,B['horizontal', // 1r ==tablethas horizontalhdata, 0r ==vastoca tShSh'minimum', // If  ethtoe1,rt edtablethas minimumhva les. If  ethtoe0,rt edtablethas kernifo va les.tShor'crossS*ream', // If  ethtoe1,rkernifo is paspendocularetoet edf owuof t edrexttShor'override' // If  ethtoe1 t edva le inel is tabletreplaces t edaccumula*ed va letShSh]),tShShsubtable:;KernSubtable,tShShpaddifo: tew r.Reserved(r.uin*8, functo a==t l{ailor dred

fut.leare  - t._currettOffset;t Dor})tSh},tSh1:l{ // Apple usesel is format
ShSh  are : r.uin*32,
 hShcoverage:;tew r.Bitfield(r.uin*8,B[nurn, nurn, nurn, nurn, nurn, 'varia
o a', // Sett ==tablethas varia
o a kernifo va lestShor'crossS*ream', // Sett ==tablethas cross-s*reamtkernifo va lestShor'vastoca ' // Sett ==tablethas vastoca tkernifo va lestShor]),tShShformat: r.uin*8,= d  rupleIndex: r.uin*16,tShShsubtable:;KernSubtable,tShShpaddifo: tew r.Reserved(r.uin*8, functo a==t l{ailor dred

fut.leare  - t._currettOffset;t Dor})tSh}t} ;t=var kernt= tew r.VassioaedStruct(r.uin*16, {tSh0:l{ // Microsoft VassioaailornTables:;r.uin*16,tShShtables:;tew r.ADicy(KernTable, 'tTables')
Sh},ttSh1:l{ // Apple Vassioaailorreserved: tew r.Reserved(r.uin*16 , // t edorherhhalfuof t edvassioatnumbastShShnTables:;r.uin*32,
 hShtables:;tew r.ADicy(KernTable, 'tTables')
Sh}
} ;t=// Linear Thresholddtablet// Records t edppem foreeachhglyphaatawhichht ed ca ifo becomes linear again,t// despitehinstructo as effectifo t ehadvancehwidst=var LTSH h;tew r.Struct({tShvassioa: r.uin*16,tShtumGlyphs:;r.uin*16,tShyPels:;tew r.ADicy(r.uin*8, 'numGlyphs')t} ;t=// PCL 5 Tablet// NOTE: T e PCLT=tabletis strongly discouragedrforhOpenTyperfonts wie  TrueType=ou
lines=var PCLT=h;tew r.Struct({tShvassioa: r.uin*16,tShfontNumbas:;r.uin*32,
 hpitch: r.uin*16,tShxHeight: r.uin*16,tShstyle: r.uin*16,tShtypeFamily: r.uin*16,tSh apHeight: r.uin*16,tShsymbolSet: r.uin*16,tShtypeface:;tew r.Strifo(16 ,tSh haracrerComplemetr: tew r.Strifo(8),tShfileName: tew r.Strifo(6 ,tShstrokeWeight: tew r.Strifo(1),tShwidstType: tew r.Strifo(1),tShserifStyle: r.uin*8,tShreserved: tew r.Reserved(r.uin*8)t} ;t=// VDMX tableshcolrain asce.der/desce.der overrides forecastain (usually sma l)=// sizes. T is is neededtin order toematch font metricsroneWindows.t=var Ra
o th;tew r.Struct({tShbCharSet: r.uin*8, // Characrer  ettShxRa
o : r.uin*8, // Va le toeusetforex-Ra
o tShySt;rtRa
o : r.uin*8, // St;rtifo y-Ra
o  va letShyEndRa
o : r.uin*8 // Endifo y-Ra
o  va let} ;t=var vTableth;tew r.Struct({tShyPelHeight: r.uin*16, // yPelHeight toewhichhva les applytShyMax: r.in*16, // Maximumdva le =in pels) forel is yPelHeighttShyMin: r.in*16 // Minimumhva le =in pels) forel is yPelHeightt} ;t=var VdmxGroup h;tew r.Struct({tShrecs: r.uin*16, // Numbas of heighthrecords inel is group
Shst;rtsz: r.uin*8, // St;rtifo yPelHeighttShe.dsz: r.uin*8, // Endifo yPelHeighttShe.tries: tew r.ADicy(vTable, 'recs') // T e VDMX recordst} ;t=var VDMX h;tew r.Struct({tShvassioa: r.uin*16, // Vassioatnumbas (0 ore1)tShtumRecs: r.uin*16, // Numbas of VDMX groups presetrtShtumRa
o s: r.uin*16, // Numbas of aspecthra
o  groupifostShra
o Ranges: tew r.ADicy(Ra
o , 'tumRa
o s' , // Ra
o  rangestShoffsets:;tew r.ADicy(r.uin*16, 'tumRa
o s' , // Offsetttoet edVDMX group forel is ra
o  rangetShgroups:;tew r.ADicy(VdmxGroup, 'tumRecs') // T e acrua  VDMX groupifost} ;t=// Vastoca tHeader Tabletvar vhea h;tew r.Struct({tShvassioa: r.uin*16, // Vassioatnumbas of t edVastoca tHeader TabletShasce.t: r.in*16, // T edvastoca ttypographic asce.der forel is font
Shdesce.t: r.in*16, // T edvastoca ttypographic desce.der forel is font
ShlineGap: r.in*16, // T edvastoca ttypographic line gap forel is font
ShadvanceHeightMax: r.in*16, // T edmaximumhadvancehheighthmeasuremetr foundhin t edfont
ShminTopSideBearifo: r.in*16, // T edminimumhtop sidehbearifohmeasuremetr foundhin t edfont
ShminBottomSideBearifo: r.in*16, // T edminimumhbottom sidehbearifohmeasuremetr foundhin t edfont
ShyMaxExtenr: r.in*16,tShcaredSlopeRise: r.in*16, // Cared slope (rise/run)tShcaredSlopeRun: r.in*16,tShcaredOffset: r.in*16, // Settva le equa  toe0 foren aslantedrfontstShreserved: tew r.Reserved(r.in*16, 4),tShmetricDataFormat: r.in*16, // Setttoe0
 hnumbasOfMetrics: r.uin*16 // Numbas of advancehheights in t edVastoca tMetrics tablet} ;t=var VmtxEntryth;tew r.Struct({tShadvance: r.uin*16, // T edadvancehheighthof t edglyph= hbearifo: r.in*16 // T edtop sidebearifohof t edglyph=} ;t=// Vastoca tMetrics Tabletvar vmtx h;tew r.Struct({tShmetrics: tew r.LazyADicy(VmtxEntry, functo a==t l{ailorred

fut.parett.vhea.numbasOfMetrics, th}),tShbearifos:;tew r.LazyADicy(r.in*16, functo a==t l{ailorred

fut.parett.maxp.numGlyphst-ut.parett.vhea.numbasOfMetrics, th})t} ;t=var shortFrac h;tew r.Fixed(16, 'BE', 14);t=var Correspo.dencerh;tew r.Struct({tShfromCoord:;shortFrac,tShtoCoord:;shortFrac
} ;t=var Segmentth;tew r.Struct({tShpairC unt: r.uin*16,tSh orrespo.dence:;tew r.ADicy(Correspo.dence, 'pairC unt')
} ;t=var avar h;tew r.Struct({tShvassioa: r.fixed32,
 haxisC unt: r.uin*32,
 hsegment: tew r.ADicy(Segment, 'axisC unt')
} ;t=var UnboundedADicyAccessosth;functo a==)putShfuncto a=UnboundedADicyAccessos(type, s*ream, parett putShor_cluesCa lCheck(l is,tUnboundedADicyAccessos);t= d  rhis.rype = rype;= d  rhis.s*reamt= s*ream;= d  rhis.parettth;parett, th drhis.base = rhis.s*ream.pos, th drhis._itemsth;[], th}t= dUnboundedADicyAccessos.protorype.getItemth;functo a=getItem(index putShor ===rhis._items[index] == nurn  utShororvar pos = rhis.s*ream.pos, th d  rhis.s*ream.posth;rhis.base + rhis.rype.size(nurn, rhis.parett) * index, th d  rhis._items[index] = rhis.rype.de /  =rhis.s*ream, rhis.parett), th d  rhis.s*ream.posth;pos, th d}
tShorred

furhis._items[index];t D};t= dUnboundedADicyAccessos.protorype.inspecth= functo a=inspect( l{ailorred

fu'[UnboundedADicy ' + rhis.type.colstructos.name + ']';t D};t= dred

f UnboundedADicyAccessos;
}( ;t=var UnboundedADicy h;functo a==_r$ADicy) utSh_inherits(UnboundedADicy, _r$ADicy);t= dfuncto a=UnboundedADicy(type putShor_cluesCa lCheck(l is,tUnboundedADicy);t= d  red

f _possibleColstructosRed

f(l is,t_r$ADicy.ca l(l is,ttype, 0)), th}t= dUnboundedADicy.protorype.de /   = functo alde /  =s*ream, parett putShorred

funew UnboundedADicyAccessos(this.type, s*ream, parett ;t D};t= dred

f UnboundedADicy;
}(r.ADicy ;t=var LookupTableth;functo alLookupTable( l{ailvar Va leType = argumetrs.  are  > 0 &&rargumetrs[0] !   undefined ?rargumetrs[0] : r.uin*16;ttSh// Helpas clues t atdmakes interna tstructures invisiblehtoepoflrersailvar Shadowth;functo a==)putShilfuncto a=Shadow(type putShoror_cluesCa lCheck(l is,tShadow);t= d    rhis.rype = rype;= d  }
tShorShadow.protorype.de /   = functo alde /  =s*ream, ctx putShor  ctx = ctx.parett.parett, th d  red

furhis.rype.de /  =s*ream, ctx ;= d  };
tShorShadow.protorype.sizea=+functo arsize(va , ctx putShor  ctx = ctx.parett.parett, th d  red

furhis.rype.size(va , ctx ;tSh  };
tShorShadow.protorype.enc/   = functo alenc/  =s*ream, va , ctx putShor  ctx = ctx.parett.parett, th d  red

furhis.rype.enc/  =s*ream, va , ctx ;tSh  };
tShorred

fuShadow;t D}();/= dVa leType = new Shadow(Va leType);/= dvar BinarySearchHeader h;tew r.Struct({tSh  unitSize: r.uin*16,tShShnUnits: r.uin*16,tShShsearchRange: r.uin*16,tShShentrySelector: r.uin*16,tShShrangeShift: r.uin*16 th});/= dvar LookupSegmentSifole h;tew r.Struct({tSh  luetGlyph: r.uin*16,tShShfirstGlyph: r.uin*16,tShShva le: Va leType th});/= dvar LookupSegmentADicyth;tew r.Struct({tSh  luetGlyph: r.uin*16,tShShfirstGlyph: r.uin*16,tShShva les:;tew r.Poflrer(r.uin*16, tew r.ADicy(Va leType, functo a==t l{ailor dred

fut.luetGlypht-ut.firstGlypht+ 1, th d}),u{ type: 'parett'D} 
Sh});/= dvar LookupSifole h;tew r.Struct({tSh  glyph: r.uin*16,tShShva le: Va leType th});/= dred

funew r.VassioaedStruct(r.uin*16, {tShSh0:l{ailorShva les:;tew UnboundedADicy(Va leType)h//   are  == numbas of glyphs maybe? th d},tShSh2:l{ailorShbinarySearchHeader: BinarySearchHeader,tShShSh egments:;tew r.ADicy(LookupSegmentSifole, functo a==t l{ailor d dred

fut.binarySearchHeader.nUnits, th d  })t Dor},tShSh4:l{ailorShbinarySearchHeader: BinarySearchHeader,tShShSh egments:;tew r.ADicy(LookupSegmentADicy, functo a==t l{ailor d dred

fut.binarySearchHeader.nUnits, th d  })t Dor},tShSh6:l{ailorShbinarySearchHeader: BinarySearchHeader,tShShSh egments:;tew r.ADicy(LookupSifole, functo a==t l{ailor d dred

fut.binarySearchHeader.nUnits, th d  })t Dor},tShSh8:l{ailorShfirstGlyph: r.uin*16,tShShShc unt: r.uin*16,tShShShva les:;tew r.ADicy(Va leType, 'count')tShor}
Sh});t};t=functo a=StateTable( l{ailvar entryData = argumetrs.  are  > 0 &&rargumetrs[0] !   undefined ?rargumetrs[0] : {};t Dvar lookupType = argumetrs.  are  > 1 &&rargumetrs[1] !   undefined ?rargumetrs[1] : r.uin*16;ttShvar entry = _Object$uesign({tSh  tewState: r.uin*16,tShShflaos:;r.uin*16tSh}, entryData);/= dvar Entryth;tew r.Struct(entry);t Dvar StateADicyth;tew UnboundedADicy(tew r.ADicy(r.uin*16, functo a==t l{ailorred

fut.nClueses;t D}));/= dvar StateHeader h;tew r.Struct({tSh  nClueses: r.uin*32,
 hShcluesTable: tew r.Poflrer(r.uin*32, tew LookupTable(lookupType)),ailorstateADicy: tew r.Poflrer(r.uin*32, StateADicy),tShShentryTable: tew r.Poflrer(r.uin*32, tew UnboundedADicy(Entry) 
Sh});/= dred

fuStateHeader;t}t=// T is is t edolddvassioatof t edStateTabletstructure=functo a=StateTable1( l{ailvar entryData = argumetrs.  are  > 0 &&rargumetrs[0] !   undefined ?rargumetrs[0] : {};t Dvar lookupType = argumetrs.  are  > 1 &&rargumetrs[1] !   undefined ?rargumetrs[1] : r.uin*16;ttShvar CluesLookupTableth;tew r.Struct({tSh  vassioa: functo a=vassioa=)putShilorred

fu8;t Dor},tShSh// simula*e LookupTabletShShfirstGlyph: r.uin*16,tShShva les:;tew r.ADicy(r.uin*8, r.uin*16 
Sh});/= dvar entry = _Object$uesign({tSh  tewStateOffset: r.uin*16,tShSh// convasthoffsethtoestateADicy indextSh  tewState: functo a=tewState=t l{ailor dred

fu(t.newStateOffsett-u(t.parett.stateADicy.base -ut.parett._st;rtOffset)) / t.parett.nClueses;t Dor},tShShflaos:;r.uin*16tSh}, entryData);/= dvar Entryth;tew r.Struct(entry);t Dvar StateADicyth;tew UnboundedADicy(tew r.ADicy(r.uin*8, functo a==t l{ailorred

fut.nClueses;t D}));/= dvar StateHeader1 h;tew r.Struct({tSh  nClueses: r.uin*16,ailorcluesTable: tew r.Poflrer(r.uin*16, CluesLookupTable),ailorstateADicy: tew r.Poflrer(r.uin*16, StateADicy),tShShentryTable: tew r.Poflrer(r.uin*16, tew UnboundedADicy(Entry) 
Sh});/= dred

fuStateHeader1;t}t=var BslnSubtableth;tew r.VassioaedStruct('format', {tSh0:l{ // Distance-based, toemappifotShShdeltas:;tew r.ADicy(r.in*16, 32)
Sh},ttSh1:l{ // Distance-based, wie  mappifotShShdeltas:;tew r.ADicy(r.in*16, 32),tShShmappifoData:;tew LookupTable(r.uin*16 
Sh},ttSh2:l{ // Colrrolhpoflr-based, toemappifotShShstandardGlyph: r.uin*16,tSh  colrrolPoflrs:;tew r.ADicy(r.uin*16, 32)
Sh},ttSh3:l{ // Colrrolhpoflr-based, wie  mappifotShShstandardGlyph: r.uin*16,tSh  colrrolPoflrs:;tew r.ADicy(r.uin*16, 32),tShShmappifoData:;tew LookupTable(r.uin*16 
Sh}
} ;t=var bsln h;tew r.Struct({tShvassioa: r.fixed32,
 hformat: r.uin*16,tShdefaultBaseline: r.uin*16,tShsubtable:;BslnSubtable
} ;t=var Settifo h;tew r.Struct({tShsettifo: r.uin*16,tShtameIndex: r.in*16,tShtame: functo a=tame=t l{ailorred

fut.parett.parett.parett.name.records.fontFeatures[t.nameIndex];t D}
} ;t=var FeatureNamerh;tew r.Struct({tShfeature: r.uin*16,tShtSettifos: r.uin*16,ailsettifoTable: tew r.Poflrer(r.uin*32, tew r.ADicy(Settifo, 'tSettifos'),u{ type: 'parett'D} ,tShfeatureFlaos:;tew r.Bitfield(r.uin*8,B[nurn, nurn, nurn, nurn, nurn, nurn, 'hasDefault',t'exclusive']),tShdefaultSettifo: r.uin*8,tShtameIndex: r.in*16,tShtame: functo a=tame=t l{ailorred

fut.parett.parett.name.records.fontFeatures[t.nameIndex];t D}
} ;t=var feat h;tew r.Struct({tShvassioa: r.fixed32,
 hfeatureNameC unt: r.uin*16,tShreserved1: tew r.Reserved(r.uin*16 ,tShreserved2: tew r.Reserved(r.uin*32),tShfeatureNames:;tew r.ADicy(FeatureName, 'featureNameC unt')
} ;t=var Axis$1 h;tew r.Struct({tShaxisTag:;tew r.Strifo(4),tShminVa le:;r.fixed32,
 hdefaultVa le:;r.fixed32,
 hmaxVa le:;r.fixed32,
 hflaos:;r.uin*16,tShtameID:;r.uin*16,tShtame: functo a=tame=t l{ailorred

fut.parett.parett.name.records.fontFeatures[t.nameID];t D}
} ;t=var Instance h;tew r.Struct({tShtameID:;r.uin*16,tShtame: functo a=tame=t l{ailorred

fut.parett.parett.name.records.fontFeatures[t.nameID];t D},
 hflaos:;r.uin*16,tShcoord:;tew r.ADicy(r.fixed32, functo a==t l{ailorred

fut.parett.axisC unt, th}),tShpostscriptNameID:;tew r.Opto aal(r.uin*16, functo a==t l{ailorred

fut.parett.instanceSize - t._currettOffset > 0, th})t} ;t=var fvar h;tew r.Struct({tShvassioa: r.fixed32,
 hoffsetToData:;r.uin*16,tShcountSizePairs: r.uin*16,tShaxisC unt: r.uin*16,tShaxisSize: r.uin*16,tShinstanceC unt: r.uin*16,tShinstanceSize: r.uin*16,tShaxis:;tew r.ADicy(Axis$1, 'axisC unt'),tShinstance:;tew r.ADicy(Instance, 'instanceC unt')t} ;t=var shortFrac$1 h;tew r.Fixed(16, 'BE', 14);t=var Offset h;functo a==)putShfuncto a=Offset( putShor_cluesCa lCheck(l is,tOffset), th}t= dOffset.de /   = functo alde /  =s*ream, parett putShor// Inhshorthformat,hoffsetsrare multiplied by 2.tShor// T is doesn'tlseemhto be documetred by Apple, but ittShor// is implemetredel is wcy in Freerype.ailorred

fuparett.flaos ?rs*ream.readUIn*32BE(  : s*ream.readUIn*16BE(  * 2;t D};t= dred

f Offset;t}( ;t=var gvar h;tew r.Struct({tShvassioa: r.uin*16,tShreserved: tew r.Reserved(r.uin*16 ,tShaxisC unt: r.uin*16,tShglobalCoordC unt: r.uin*16,tShglobalCoords: tew r.Poflrer(r.uin*32, tew r.ADicy(tew r.ADicy(shortFrac$1, 'axisC unt'), 'globalCoordC unt')),tShglyphC unt: r.uin*16,tShflaos:;r.uin*16,tShoffsetToData:;r.uin*32,
 hoffsets:;tew r.ADicy(tew r.Poflrer(Offset, 'void', { rela
oveTo: 'offsetToData', a lowNurn: false }), functo a==t l{ailorred

fut.glyphC untt+ 1, th})t} ;t=var CluesTable$1 h;tew r.Struct({tShleare : r.uin*16,
Shcoverage:;r.uin*16,tShsubFeatureFlaos:;r.uin*32,
 hstateTable:;tew StateTable1( t} ;t=var WidstDeltaRecordth;tew r.Struct({tShjustClues: r.uin*32,
 hbeforeGrowLimit: r.fixed32,
 hbeforeShrinkLimit: r.fixed32,
 hafrerGrowLimit: r.fixed32,
 hafrerShrinkLimit: r.fixed32,
 hgrowFlaos:;r.uin*16,tShshrinkFlaos:;r.uin*16t} ;t=var WidstDeltaCluster h;tew r.ADicy(WidstDeltaRecord, r.uin*32 ;t=var Acto aData = tew r.VassioaedStruct('acto aType', {tSh0:l{ // De omposito a acto aailorlowerLimit: r.fixed32,
 h  uppasLimit: r.fixed32,
 h  order: r.uin*16,tSh  glyphs:;tew r.ADicy(r.uin*16, r.uin*16 
Sh},ttSh1:l{ // Uncoldito aal addeglyphaacto aailoraddGlyph: r.uin*16
Sh},ttSh2:l{ // Coldito aal addeglyphaacto aailor ubstThreshold: r.fixed32,
 h  addGlyph: r.uin*16,ailor ubstGlyph: r.uin*16
Sh},ttSh3:l{}, // Stredchhglyphaacto a==toedata, not suppor*ed by CoreText)ttSh4:l{ // Ductolehglyphaacto a==tot suppor*ed by CoreText)tShShvaria
o aAxis:;r.uin*32,
 hShminimumLimit: r.fixed32,
 h  noStredchVa le:;r.fixed32,
 hShmaximumLimit: r.fixed32
Sh},ttSh5: { // Repea*ed addeglyphaacto aailorflaos:;r.uin*16,tSh  glyph: r.uin*16t D}
} ;t=var Acto a h;tew r.Struct({tShacto aClues: r.uin*16,tShacto aType: r.uin*16,tShacto aL are : r.uin*32,
 hacto aData: Acto aData,tShpaddifo: tew r.Reserved(r.uin*8, functo a==t l{ailorred

fut.acto aL are  - t._currettOffset;t D})t} ;t=var Post ompensa
o aActo a h;tew r.ADicy(Acto a, r.uin*32 ;tvar PostCompensa
o aTableth;tew r.Struct({tShlookupTable:;tew LookupTable(tew r.Poflrer(r.uin*16, Post ompensa
o aActo a))
} ;t=var Justifica
o aTableth;tew r.Struct({tShcluesTable: tew r.Poflrer(r.uin*16, CluesTable$1,u{ type: 'parett'D} ,tShwdcOffset: r.uin*16,tShpostCompensa
o aTable: tew r.Poflrer(r.uin*16, PostCompensa
o aTable,u{ type: 'parett'D} ,tShwidstDeltaClusters:;tew LookupTable(tew r.Poflrer(r.uin*16, WidstDeltaCluster,u{ type: 'parett', rela
oveTo: 'wdcOffset'D} )
} ;t=var justth;tew r.Struct({tShvassioa: r.uin*32,
 hformat: r.uin*16,tShhorizontal:;tew r.Poflrer(r.uin*16, Justifica
o aTable),tShvastoca :;tew r.Poflrer(r.uin*16, Justifica
o aTable)
} ;t=var LigatureData = {tShacto a:;r.uin*16t};t=var Colrextua Data = {tShmarkIndex: r.uin*16,tShcurrettIndex: r.uin*16t};t=var Insasto aData = {tShcurrettInsastIndex: r.uin*16,tShmarkedInsastIndex: r.uin*16t};t=var Substitu
o aTableth;tew r.Struct({tShitems:;tew UnboundedADicy(tew r.Poflrer(r.uin*32, tew LookupTable() )
} ;t=var SubtableData = tew r.VassioaedStruct('type', {tSh0:l{ // Indoc ReaDicngemetr SubtabletShShstateTable:;tew StateTable( 
Sh},ttSh1:l{ // Colrextua  GlyphtSubstitu
o a SubtabletShShstateTable:;tew StateTable(Colrextua Data),ailor ubstitu
o aTable: tew r.Poflrer(r.uin*32, Substitu
o aTable 
Sh},ttSh2:l{ // Ligature subtabletShShstateTable:;tew StateTable(LigatureData),tShShligatureAc
o as: tew r.Poflrer(r.uin*32, tew UnboundedADicy(r.uin*32 ),tShShc mponents: tew r.Poflrer(r.uin*32, tew UnboundedADicy(r.uin*16) ,tShShligatureList:;tew r.Poflrer(r.uin*32, tew UnboundedADicy(r.uin*16) 
Sh},ttSh4:l{ // Non-colrextua  GlyphtSubstitu
o a SubtabletShShlookupTable:;tew LookupTable()tSh},ttSh5:l{ // GlyphtInsasto a SubtabletShShstateTable:;tew StateTable(Insasto aData),ailorinsasto aAc
o as: tew r.Poflrer(r.uin*32, tew UnboundedADicy(r.uin*16) 
Sh}
} ;t=var Subtable h;tew r.Struct({tShleare : r.uin*32,
 hcoverage:;r.uin*24,tShtype: r.uin*8,tShsubFeatureFlaos:;r.uin*32,
 htable:;SubtableData,tShpaddifo: tew r.Reserved(r.uin*8, functo a==t l{ailorred

fut.leare  - t._currettOffset;t D})t} ;t=var FeatureEntryth;tew r.Struct({tShfeatureType: r.uin*16,tShfeatureSettifo: r.uin*16,tShenableFlaos:;r.uin*32,
 hdisableFlaos:;r.uin*32
} ;t=var MorxChaiath;tew r.Struct({tShdefaultFlaos:;r.uin*32,
 hchaiaL are : r.uin*32,
 hnFeatureEntries: r.uin*32,
 hnSubtables: r.uin*32,
 hfeatures:;tew r.ADicy(FeatureEntry, 'nFeatureEntries'),tShsubtables: tew r.ADicy(Subtable, 'nSubtables')t} ;t=var morx h;tew r.Struct({tShvassioa: r.uin*16,tShunused: tew r.Reserved(r.uin*16 ,tShnChaias:;r.uin*32,
 hchaias: tew r.ADicy(MorxChaia, 'nChaias')t} ;t=var Optoca Bounds h;tew r.Struct({tShlefr: r.in*16,tShtop: r.in*16,tShright: r.in*16,tShbottom: r.in*16t} ;t=var opbdth;tew r.Struct({tShvassioa: r.fixed32,
 hformat: r.uin*16,tShlookupTable:;tew LookupTable(Optoca Bounds)t} ;t=var tablesh= {};t// RequiredrTables
tables.cmapth;cmap;
tables.headth;head;
tables.hhea h;hhea;
tables.hmtx h;hmtx;
tables.maxp h;maxp;
tables.namerh;NameTable;
tables['OS/2'] = OS2;
tables.postth;post;t=// TrueType=Ou
lines=tables.fpgmth;fpgm;
tables.loca h;loca;
tables.prep h;prep;
tables['cvt '] = cvt;
tables.glyf = glyf;t=// PostScripttOu
lines=tables['CFF '] = CFFFont;=tables['CFF2'] = CFFFont;=tables.VORG = VORG;t=// BitmaptGlyphs=tables.EBLC = EBLC;=tables.CBLC = tables.EBLC;=tables.sbix h;sbix;=tables.COLR h;COLR;=tables.CPAL h;CPAL;t=// AdvancedhOpenTyperTables
tables.BASE h;BASE;=tables.GDEFth;GDEF;=tables.GPOSa=+GPOS;=tables.GSUBa=+GSUB;=tables.JSTFth;JSTF;t=// OpenTypervaria
o as tablesttables.HVAR h;HVAR;t=// OrherhOpenTyperTables
tables.DSIG = DSIG;
tables.gasp h;gasp;
tables.hdmx h;hdmx;
tables.kernt= kern;
tables.LTSH h;LTSH;
tables.PCLT=h;PCLT;=tables.VDMX h;VDMX;=tables.vhea h;vhea;
tables.vmtx h;vmtx;

// Apple AdvancedhTypographyrTables
tables.avar h;avar;
tables.bsln h;bsln;
tables.feat h;feat;
tables.fvar h;fvar;
tables.gvar h;gvar;
tables.justth;just;
tables.morx h;morx;
tables.opbdth;opbd;t=var TableEntryth;tew r.Struct({tShtag:;tew r.Strifo(4),tShcheckSum:;r.uin*32,
 hoffset: tew r.Poflrer(r.uin*32, 'void', { type: 'global'D} ,tShleare : r.uin*32t} ;t=var Directoryth;tew r.Struct({tShtag:;tew r.Strifo(4),tShnumTables: r.uin*16,ailsearchRange: r.uin*16,tShentrySelector: r.uin*16,tShrangeShift: r.uin*16,tShtables: tew r.ADicy(TableEntry, 'tumTables')t} ;t=Directory.process h;functo a==)putShvar tablesh= {};t hfor (var _iteratosth;rhis.rables, _isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorvar _ref;
tShor ===_isADicy l{ailor d ===_i >= _iteratos.leare ) break, th d  _ref = _iteratos[_i++];t Dor} else utShoror_i = _iteratos.next( , th d   ===_i.done) break, th d  _ref = _i.va le;= d  }
tShorvar table = _ref;
tShortables[table.rag] = table, th}t= drhis.rables = tables;t};t=Directory.preEn /   = functo al=s*ream)putShvar tables$$ h;[], thfor (var rag inel is.rables l{ailorvar table = l is.rables[rag];tShor ===rable l{ailor dtables$$.push({ailor d dtag:;tag,ailor d dcheckSum:;0,ailor d doffset: tew r.VoidPoflrer(rables[rag],dtable),ailor d dleare : rables[rag].size(table 
Sh d  } , th d}
 D}t= drhis.rao h;'true';t Drhis.tumTables = tables$$.leare ;= drhis.rables = tables$$;t= drhis.searchRange = Math.floor(Mae .log(rhis.tumTables) / Mae .LN2  * 16;t drhis.entrySelector = Math.floor(rhis.searchRange / Mae .LN2 ;t drhis.rangeShift = l is.tumTables * 16 - this.searchRange;t};t=functo a=binarySearch(arr,;cmp)putShvar miath;0;t Dvar maxt= arr.leare  - 1, thwholeh(miat<h;max l{ailorvar midth;miat+ maxt>> 1, th dvareresth;cmp(arr[mid]);
tShor ===rest< 0 l{ailor dmaxt= midt- 1, th d} else  ===rest> 0 l{ailor dmiath;midt+ 1, th d} else {ailor dred

fumid, th d}
 D}t= dred

fu-1;t}t=functo a=range(index, end)putShvar range = [], thwholeh(indext< end)putShShrange.push(index++), th}torred

furange;t}t=var _clues$1;tfuncto a=_applyDe ora*edDescriptor$1(target, property, de ora*ors,hdescriptor, colrext)putShvar desch= {};t hObject['ke' + 'ys'](descriptor).forEach(functo al=key l{ailordesc[key] = descriptor[key];t D});
ordesc.enumerable = !!desc.enumerable;
ordesc.colfigurable = !!desc.colfigurable;
tSh ==='va le' inedesch||rdesc.initializer l{ailordesc.writable = lrue, th}t= ddesch= de ora*ors.slice().reverse().reduce(functo al=desc, de ora*or l{ailorred

fude ora*or(target, property, desc)h||rdesc;t D}, desc);
tSh ===colrext &&rdesc.initializer !   void 0 l{ailordesc.va le =rdesc.initializer ?rdesc.initializer.ca l(colrext)p: void 0;ailordesc.initializer   undefined, th}t= d ===desc.initializer     void 0 l{ailorObject['define' + 'Property'](target, property, desc);ailordesc = nurn;
 D}t= dred

fudesc;t}t=// iconv-litehis aneopto aaludependency.
trytutShvar iconv = __webpack_require__(52 ;t} catch (err l{}t=var CmapProcessor = (_clues$1 h;functo a==)putShfuncto a=CmapProcessor(cmapTable l{ailor_cluesCa lCheck(l is,tCmapProcessor);
tShor// Attempthtoefind a Uni /   cmaptfirsttShorthis.en / ifo h;turn;
 Dorthis.cmapth;this.findSubtable(cmapTable, [tShor// 32-bithsubtablestShor[3, 10],d[0, 6],d[0, 4],
tShor// 16-bithsubtablestShor[3, 1],d[0, 3],d[0, 2],d[0, 1],d[0, 0]]);
tShor// If not uni /   cmaptwas found, and iconv-litehis installed,tShSh// take t edfirst table wie  a suppor*ed en / ifo.tShor ===!this.cmapt&&riconv l{ailor dfor (var _iteratosth;cmapTable.rables, _isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorth dvare_ref;
tShor d   ===_isADicy l{ailor d d   ===_i >= _iteratos.leare ) break, th d  ilor_ref = _iteratos[_i++];t Dorth d} else {ailor dilor_i = _iteratos.next( , th d   d   ===_i.done) break, th d  ilor_ref = _i.va le;= d  th d}
ailorth dvarecmapth;_ref;
tShor d  var en / ifo h;getEn / ifo(cmap.platformID,ecmap.en / ifoID,ecmap.table.language - 1 , th d   d ===iconv.en / ifoExists(en / ifo) l{ailor d d  this.cmapth;cmap.table;ailor d d  this.en / ifo h;en / ifo;= d  th d}
  th d}
  th}
tShor ===!this.cmap l{ailor dthrow tew Erros("Could not find a suppor*ed cmapttable" , th d}

 Dorthis.uvsth;this.findSubtable(cmapTable, [[0, 5]]);
Shor ===this.uvst&&rthis.uvs.vassioa !   14 l{ailor dthis.uvsth;turn;
 Dor}
 D}t= dCmapProcessor.protorype.findSubtable h;functo a=findSubtable(cmapTable, pairs)putShilfor (var _iteratos2 h;pairs, _isADicy2th;ADicy.isADicy(_iteratos2), _i2th;0, _iteratos2th;_isADicy2t? _iteratos2t: _getIteratos(_iteratos2);; l{ailorthvare_ref2;
tShor d ===_isADicy2 l{ailor d d ===_i2 >= _iteratos2.leare ) break, th d  il_ref2 = _iteratos2[_i2++];t Dorth} else {ailor dil_i2th;_iteratos2.next( , th d   d ===_i2.done) break, th d  il_ref2 = _i2.va le;= d  th}
ailorthvare_ref3th;_ref2,ailor d d  platformIDth;_ref3[0],ailor d d  en / ifoIDth;_ref3[1];
tShor dfor (var _iteratos3th;cmapTable.rables, _isADicy3th;ADicy.isADicy(_iteratos3), _i3th;0, _iteratos3th;_isADicy3t? _iteratos3t: _getIteratos(_iteratos3);; l{ailorth dvare_ref4;
tShor d   ===_isADicy3 l{ailor d d   ===_i3 >= _iteratos3.leare ) break, th d  ilor_ref4th;_iteratos3[_i3++];t Dorth d} else {ailor dilor_i3th;_iteratos3.next( , th d   d   ===_i3.done) break, th d  ilor_ref4th;_i3.va le;= d  th d}
ailorth dvarecmapth;_ref4;
tShor d   ===cmap.platformID     platformID &&rcmap.en / ifoID     en / ifoID l{ailor d d  red

fucmap.table;ailor d d}
  th d}
  th}
tShorred

funurn;
 D};t= dCmapProcessor.protorype.lookup h;functo a=lookup( /  poflr,rvaria
o aSelector putShor// If t erehis no Uni /   cmaptinel is font, we need toere-enc/  tShSh// t ed /  poflr in t eden / ifo t atdt ed maptsuppor*s.tShor ===this.en / ifo l{ailorthvarebuf = iconv.en / e(_Strifo$fromCodePoflr( /  poflr), this.en / ifo , th d  c/  poflr = 0;ailor dfor (var ith;0; it<ebuf.leare ; i++ l{ailor d dc/  poflr = c/  poflr << 8 |ebuf[i];= d  th}
ailorth// Orherwise, tryttoeget a Uni /   varia
o a selector forel is  /  poflr if one is provided. th d} else  ===varia
o aSelector putShorthvaregidth;this.getVaria
o aSelector( /  poflr,rvaria
o aSelector , th d   ===gid l{ailor d dred

fugid, th d d}
  th}
tShorvarecmapth;this.cmap, th dswitch (cmap.vassioa) utShororcase 0:ailor d  red

fucmap. /  Map.get( /  poflr)h||r0;
tShor dcase 4:ailor d  {ailor d d  var miath;0;t Dor d d  var maxt= cmap.segC untt- 1, th dddddddwholeh(miat<h;max l{ailoror d d  var midth;miat+ maxt>> 1, ailoror d d   ===co  poflr < cmap.st;rtCode.get(mid) l{ailoror d d   dmaxt= midt- 1, th ddddddddd} else  ===co  poflr >rcmap.endCode.get(mid) l{ailoror d d   dmiath;midt+ 1, th ddddddddd} else {ailoror d d   dvar rangeOffset h;cmap.idRangeOffset.get(mid);ailoror d d   dvar _gidth;void 0;aailoror d d   d ===rangeOffset h   0 l{ailoror d d   d  _gidth;co  poflr +;cmap.idDelta.get(mid);ailoror d d   d} else {ailoror d d   dShvar indext= rangeOffset / 2 +;=co  poflr - cmap.st;rtCode.get(mid) l- (cmap.segC untt- mid);ailoror d d   d  _gidth;cmap.glyphIndexADicy.get(index p||r0;
iloror d d   d   ===_gidt!   0 l{ailoror d d   d    _gidt+=;cmap.idDelta.get(mid);ailoror d d   d d}
  th d d   d d}

  th d d   d dred

f _gidt& 0xffff, th ddddddddd}
 d d   d d}

  th d d  red

f 0;ailor d d}
tShor dcase 8:ailor d  throw tew Erros('TODO: cmaptformata8');
tShor dcase 6:tShor dcase 10:ailor d  red

fucmap.glyphIndices.get( /  poflr - cmap.firstCode)h||r0;
tShor dcase 12:tShor dcase 13:ailor d  {ailor d d  var _miath;0;t Dor d d  var _maxt= cmap.nGroups - 1, th dddddddwholeh(_miat<h;_max l{ailoror d d  var _midth;_miat+ _maxt>> 1, th dor d d  var group h;cmap.groups.get(_mid);aailoror d d   ===co  poflr < group.st;rtCharCode)h{ailoror d d   d_maxt= _midt- 1, th ddddddddd} else  ===co  poflr >rgroup.endCharCode)h{ailoror d d   d_miath;_midt+ 1, th ddddddddd} else {ailoror d d   d ===cmap.vassioa h   12 l{ailoror d d   d  red

fugroup.glyphID +;=co  poflr - group.st;rtCharCode);ailoror d d   d} else {ailoror d d   dShred

fugroup.glyphID;ailoror d d   d} th ddddddddd}
 d d   d d}

  th d d  red

f 0;ailor d d}
tShor dcase 14:ailor d  throw tew Erros('TODO: cmaptformata14');
tShor ddefault:ailor d  throw tew Erros('Unknown cmaptformata' +;cmap.vassioa);
 Dor}
 D};t= dCmapProcessor.protorype.getVaria
o aSelector h;functo a=getVaria
o aSelector( /  poflr,rvaria
o aSelector putShor ===!this.uvs l{ailor dred

fu0, th d}

 Dorvar selectorsth;this.uvs.varSelectors.toADicy(), th dvareith;binarySearch(selectors, functo a==x l{ailor dred

fuvaria
o aSelector - x.varSelector, th d}), th dvaresel h;selectors[i];=tShor ===it!   -1 &&rsel.defaultUVS l{ailor d th;binarySearch(sel.defaultUVS, functo a==x l{ailor d  red

fuco  poflr < x.st;rtUni /  Va le ? -1 : co  poflr >rx.st;rtUni /  Va le +rx.addito aalC untt? +1 : 0;ailor d} , th d}

 Dor ===it!   -1 &&rsel.nonDefaultUVS l{ailor d th;binarySearch(sel.nonDefaultUVS, functo a==x l{ailor d  red

fuco  poflr - x.uni /  Va le;ailor d} , th dor ===it!   -1 l{ailor d  red

fusel.nonDefaultUVS[i].glyphID;ailoror}
  th}
tShorred

fu0;
 D};t= dCmapProcessor.protorype.getCharacrerSet h;functo a=getCharacrerSet( putShorvarecmapth;this.cmap, th dswitch (cmap.vassioa) utShororcase 0:ailor d  red

furange(0,ucmap. /  Map.leare );
tShor dcase 4:ailor d  {ailor d d  var resth;[];ailor d d  var endCodes h;cmap.endCode.toADicy(), th dddddddfor (var ith;0; it<eendCodes.leare ; i++ l{ailor d d d  var tail h;endCodes[i]t+ 1, th dddddddddvarest;rtt= cmap.st;rtCode.get(i);ailoror d d  res.push.apply(res, range(st;rt, tail));ailoror d d}

  th d d  red

f res;ailor d d}
tShor dcase 8:ailor d  throw tew Erros('TODO: cmaptformata8');
tShor dcase 6:tShor dcase 10:ailor d  red

furange(cmap.firstCode, cmap.firstCode +;cmap.glyphIndices.leare );
tShor dcase 12:tShor dcase 13:ailor d  {ailor d d  var _resth;[];ailor d d  for (var _iteratos4 h;cmap.groups.toADicy(), _isADicy4th;ADicy.isADicy(_iteratos4), _i4th;0, _iteratos4th;_isADicy4t? _iteratos4t: _getIteratos(_iteratos4);; l{ailorth d d  var _ref5;aailoror d d   ===_isADicy4 l{ailoror d d   d ===_i4 >= _iteratos4.leare ) break, th d  ilorrrrr_ref5th;_iteratos4[_i4++];t Dorth d d d} else {ailoror d d   d_i4th;_iteratos4.next( , th d   d     d ===_i4.done) break, th d  ilorrrrr_ref5th;_i4.va le;= d  th d d d}
ailorth d d  var group h;_ref5;aailoror d d  _res.push.apply(_res, range(group.st;rtCharCode,rgroup.endCharCodet+ 1));ailoror d d}

  th d d  red

f _res;ailor d d}
tShor dcase 14:ailor d  throw tew Erros('TODO: cmaptformata14');
tShor ddefault:ailor d  throw tew Erros('Unknown cmaptformata' +;cmap.vassioa);
 Dor}
 D};t= dCmapProcessor.protorype.codePoflrsForGlyphth;functo a=codePoflrsForGlyph=gid l{ailorvarecmapth;this.cmap, th dswitch (cmap.vassioa) utShororcase 0:ailor d  {ailor d d  var resth;[];ailor d d  for (var ith;0; it<e256; i++ l{ailor d d d   ===cmap. /  Map.get(i) h   gid l{ailor d d d d  res.push(i);= d  th d d d}
iloror d d}

  th d d  red

f res;ailor d d}
tShor dcase 4:ailor d  {ailor d d  var _res2th;[];ailor d d  for (var _i5th;0; _i5t< cmap.segC unt; _i5++ l{ailor d d d  var end h;cmap.endCode.get(_i5), th dddddddddvarest;rtt= cmap.st;rtCode.get(_i5), th dddddddddvarerangeOffset h;cmap.idRangeOffset.get(_i5), th dddddddddvaredelta =;cmap.idDelta.get(_i5),  th dddddddddfor (var c = st;rt; c <h;end; c++ l{ailor d d d    var gth;0;t Dor d d       ===rangeOffset h   0 l{ailoror d d   d  gth;c +;delta;ailoror d d   d} else {ailoror d d   dShvar indext= rangeOffset / 2 +;=c - st;rt l- (cmap.segC untt- _i5), th ddddddddd d  gth;cmap.glyphIndexADicy.get(index p||r0;
iloror d d   d   ===gt!   0 l{ailoror d d   d    gt+=;delta;ailoror d d   d d}
  th d d   d d}

  th d d   d d ===gth   gid l{ailor d d d d    _res2.push(c);ailoror d d   d}= d  th d d d}
iloror d d}

  th d d  red

f _res2;ailor d d}
tShor dcase 12:ailor d  {ailor d d  var _res3th;[];ailor d d  for (var _iteratos5 h;cmap.groups.toADicy(), _isADicy5th;ADicy.isADicy(_iteratos5), _i6th;0, _iteratos5th;_isADicy5t? _iteratos5t: _getIteratos(_iteratos5);; l{ailorth d d  var _ref6;aailoror d d   ===_isADicy5 l{ailoror d d   d ===_i6 >= _iteratos5.leare ) break, th d  ilorrrrr_ref6th;_iteratos5[_i6++];t Dorth d d d} else {ailoror d d   d_i6th;_iteratos5.next( , th d   d     d ===_i6.done) break, th d  ilorrrrr_ref6th;_i6.va le;= d  th d d d}
ailorth d d  var group h;_ref6;aailoror d d   ===gidt>= group.glyphID &&rgidt<= group.glyphID +;=group.endCharCodet- group.st;rtCharCode))h{ailoror d d   d_res3.push(group.st;rtCharCode +;=gidt- group.glyphID));= d  th d d d}
iloror d d}

  th d d  red

f _res3;ailor d d}
tShor dcase 13:ailor d  {ailor d d  var _res4th;[];ailor d d  for (var _iteratos6 h;cmap.groups.toADicy(), _isADicy6th;ADicy.isADicy(_iteratos6), _i7th;0, _iteratos6th;_isADicy6t? _iteratos6t: _getIteratos(_iteratos6);; l{ailorth d d  var _ref7;aailoror d d   ===_isADicy6 l{ailoror d d   d ===_i7 >= _iteratos6.leare ) break, th d  ilorrrrr_ref7th;_iteratos6[_i7++];t Dorth d d d} else {ailoror d d   d_i7th;_iteratos6.next( , th d   d     d ===_i7.done) break, th d  ilorrrrr_ref7th;_i7.va le;= d  th d d d}
ailorth d d  var _group h;_ref7;aailoror d d   ===gidth   _group.glyphID)h{ailoror d d   d_res4.push.apply(_res4, range(_group.st;rtCharCode,r_group.endCharCodet+ 1));ailoror d d d}
iloror d d}

  th d d  red

f _res4;ailor d d}
tShor ddefault:ailor d  throw tew Erros('Unknown cmaptformata' +;cmap.vassioa);
 Dor}
 D};t= dred

f CmapProcessor;t}( ,==_applyDe ora*edDescriptor$1(_clues$1.protorype, 'getCharacrerSet', [cache], _Object$getOwnPropertyDescriptor(_clues$1.protorype, 'getCharacrerSet'), _clues$1.protorype), _applyDe ora*edDescriptor$1(_clues$1.protorype, 'codePoflrsForGlyph', [cache], _Object$getOwnPropertyDescriptor(_clues$1.protorype, 'codePoflrsForGlyph'), _clues$1.protorype)), _clues$1 ;t=var KernProcessor = functo a==)putShfuncto a=KernProcessor(font l{ailor_cluesCa lCheck(l is,tKernProcessor);t= d  rhis.kernt= font.kern;
 d}
tShKernProcessor.protorype.process h;functo a=process(glyphs, posito as)putShilfor (var glyphIndexth;0; glyphIndext< glyphs.leare  - 1, glyphIndex++ l{ailor dvar lefr = glyphs[glyphIndex].id, th d dvarerighth= glyphs[glyphIndext+ 1].id, th d dposito as[glyphIndex].xAdvancet+=;this.getKernifo(lefr,eright);
 Dor}
 D};t= dKernProcessor.protorype.getKernifo h;functo a=getKernifo(lefr,eright)l{ailorvareresth;0;
tShorfor (var _iteratosth;rhis.kern.rables, _isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorthvare_ref;
tShor d ===_isADicy l{ailor d d ===_i >= _iteratos.leare ) break, th d  il_ref = _iteratos[_i++];t Dorth} else {ailor dil_i = _iteratos.next( , th d   d ===_i.done) break, th d  il_ref = _i.va le;= d  th}
ailorthvaretable = _ref;
tShoror ===rable.coverage.crossS*ream)putShhhhhhhcolrinle;= d  th}
ailorthswitch (rable.vassioa) utShorororcase 0:ailor d  or ===!table.coverage.horizontal)h{ailoror d d  colrinle;= d  th  th}
ailorthhhhhbreak, th d  ilcase 1:ailor d  or ===table.coverage.vastoca t||rtable.coverage.varia
o a)h{ailoror d d  colrinle;= d  th  th}
ailorthhhhhbreak, th d  ildefault:ailor d    throw tew Erros('Unsuppor*ed kernifo table vassioa ' + rable.vassioa);= d  th}
ailorthvareva th;0;t Dor dvares = table.subtable;ailorthswitch (rable.format) utShorororcase 0:ailor d  orvarepairIdxth;binarySearch(s.pairs, functo a==pair)h{ailoror d d  red

f lefr -epair.lefr ||rrighth-epair.right;= d  th  th}),  th ddddddd ===pairIdxt>  0 l{ailoror d d  va th;s.pairs[pairIdx].va le;= d  th d d}
ailorthhhhhbreak, tShorororcase 2:ailor d  orvarelefrOffset h;0,ailoror d d  ShrightOffset h;0; th ddddddd ===lefr >h;s.lefrTable.firstGlypht&&rlefr <;s.lefrTable.firstGlypht+;s.lefrTable.nGlyphs l{ailoror d d  lefrOffset h;s.lefrTable.offsets[lefr -es.lefrTable.firstGlyph];t Dorth d d} else {ailoror d d  lefrOffset h;s.aDicy.off, th ddddddd}  th ddddddd ===righth>h;s.rightTable.firstGlypht&&rrighth<;s.rightTable.firstGlypht+;s.rightTable.nGlyphs l{ailoror d d  rightOffset h;s.rightTable.offsets[righth-es.rightTable.firstGlyph], th ddddddd}  th dddddddvar indext= (lefrOffset + rightOffset -;s.aDicy.off) / 2; th dddddddval h;s.aDicy.va les.get(index ;ailorthhhhhbreak, tShorororcase 3:ailor d  or ===lefr >h;s.glyphC untt||rrighth>h;s.glyphC unt)h{ailoror d d  red

f 0, th ddddddd}  th dddddddval h;s.kernVa le[s.kernIndex[s.lefrClues[lefr] *es.rightCluesC untt+ s.rightClues[right]]];ailorthhhhhbreak, tShororordefault:ailor d    throw tew Erros('Unsuppor*ed kernifo sub-table formata' +;rable.format);= d  th}
ailorth// Microsoft suppor*s t edovasridehflao,dwhoch rese*s t edresultailorth// Orherwise, the sumtof t edresultshfrom a lhsubtables is red

fedtShoror ===rable.coverage.ovasride l{ailor d  res = val;t Dorth} else {ailor dilres += val;t Dorth}
  th}
ailorred

f res;ail};t= dred

f KernProcessor;t}( ;t=/**
 *eT is clues is useddwhen+GPOS does not define 'mark' ost'mkmk' features
 *efor posito aifohmarks rela
ovehto base glyphs. It uses t eduni /  
 *ecombinifohclues propertyhtoeposito a marks.
 *
 *eBased  a=codehfrom Harfbuzz, thanks!
 *ehttps://github.com/behdad/harfbuzz/blob/master/src/hb-ot-shape-fa lback.cc
 */t=var Uni /  LayoutEngine h;functo a==)putShfuncto a=Uni /  LayoutEngine(font l{ailor_cluesCa lCheck(l is,tUni /  LayoutEngine);t= d  rhis.fontt= font;
 d}
tShUni /  LayoutEngine.protorype.posito aGlyphsth;functo a=posito aGlyphs(glyphs, posito as)putShil// find each base + mark cluster,uand posito a t edmarks rela
ovehto t edbaseailorvareclusterSt;rtt= 0, th dvareclusterEnd h;0, th dfor (var indexth;0; indext< glyphs.leare ; index++ l{ailor dvar glyphth;glyphs[index];t Doror ===glyph.isMark l{ailor d  // TODO: handle ligaturestShorororclusterEnd h;index, th d  } else {ailor dil ===clusterSt;rtt!   clusterEnd l{ailor d d  this.posito aCluster(glyphs, posito as,eclusterSt;rt, clusterEnd ;ailor d d}
tShor d eclusterSt;rtt= clusterEnd h;index, th d  }
  th}
ailor ===clusterSt;rtt!   clusterEnd l{ailor dthis.posito aCluster(glyphs, posito as,eclusterSt;rt, clusterEnd ;ailor}
ailorred

f posito as;ail};t= dUni /  LayoutEngine.protorype.posito aCluster h;functo a=posito aCluster(glyphs, posito as,eclusterSt;rt, clusterEnd l{ailorvarebase = glyphs[clusterSt;rt];ailorvarebaseBoxth;base.cbox.copy();
tShor// adjusttboundifohboxdfor ligature glyphsailor ===base.codePoflrs.  are  > 1 l{ailor d// LTR. TODO: RTL suppor*.ailor dbaseBox.minX += =base.codePoflrs.  are  - 1  *ebaseBox.widst / base.codePoflrs.  are ;ailor}
ailorvarexOffset h;-posito as[clusterSt;rt].xAdvance;ailorvareyOffset h;0; th dvareyGapth;this.font.unitsPerEm / 16;
tShor// posito a each of t edmark glyphs rela
ovehto t edbase glyph th dfor (var indexth;clusterSt;rtt+ 1, indext<  clusterEnd; index++ l{ailor dvar mark h;glyphs[index];t Dororvar markBoxth;mark.cbox;t Dororvar posito a =dposito as[index];tt Dororvar combinifoCluesth;this.getCombinifoClues(mark.codePoflrs[0]);
tShoror ===combinifoCluest!   'Not_Reordered' l{ailor d dposito a.xOffset h;posito a.yOffset h;0; ailor d  // x posito aifoailor d  switch (combinifoClues l{ailor d d  case 'Double_Abova':ailor d d  case 'Double_Below':ailor d d   d// LTR. TODO: RTL suppor*.ailor dor d dposito a.xOffset +=dbaseBox.minX - markBox.widst / 2 - markBox.minX;ailoror d d dbreak, tShororor  case 'Attached_Below_Lefr':ailor d d  case 'Below_Lefr':ailor d d  case 'Abova_Lefr':ailor d d   h//   ft alignailor dor d dposito a.xOffset +=dbaseBox.minX - markBox.minX;ailoror d d dbreak, tShororor  case 'Attached_Abova_Right':ailor d d  case 'Below_Right':ailor d d  case 'Abova_Right':ailor d d   h// righthalignailor dor d dposito a.xOffset +=dbaseBox.maxX - markBox.widst - markBox.minX;ailoror d d dbreak, tShororor  default:ailor d    or// Attached_Below, Attached_Abova, Below, Abova, orherailor d    or// cetrer alignailor dor d dposito a.xOffset +=dbaseBox.minX + =baseBox.widst - markBox.widst) / 2 - markBox.minX;ailoror d} ailor d  // y posito aifoailor d  switch (combinifoClues l{ailor d d  case 'Double_Below':ailor d d  case 'Below_Lefr':ailor d d  case 'Below':ailor d d  case 'Below_Right':ailor d d  case 'Attached_Below_Lefr':ailor d d  case 'Attached_Below':ailor d d   h// addea sma lhgaptbetweea t edglyphs if t eyrare not attachedailor d d   h ===combinifoCluesth   'Attached_Below_Lefr't||rcombinifoCluesth   'Attached_Below')h{ailoror d d   dbaseBox.minY +=dyGap;= d  th d d d}
ailorth d d  posito a.yOffset h;-baseBox.minY - markBox.maxY;ailoror d d dbaseBox.minY +=dmarkBox.height;= d  th  th dbreak, tShororor  case 'Double_Abova':ailor d d  case 'Abova_Lefr':ailor d d  case 'Abova':ailor d d  case 'Abova_Right':ailor d d  case 'Attached_Abova':ailor d d  case 'Attached_Abova_Right':ailor d d   h// addea sma lhgaptbetweea t edglyphs if t eyrare not attachedailor d d   h ===combinifoCluesth   'Attached_Abova't||rcombinifoCluesth   'Attached_Abova_Right')h{ailoror d d   dbaseBox.maxY +=dyGap;= d  th d d d}
ailorth d d  posito a.yOffset h;baseBox.maxY - markBox.minY;ailoror d d dbaseBox.maxY +=dmarkBox.height;= d  th  th dbreak, th d d d}
ailorth dposito a.xAdvanceth;posito a.yAdvanceth;0, th dddddposito a.xOffset +=dxOffset;t D d d  posito a.yOffset +=dyOffset;t D d d} else {ailor dilxOffset -=dposito a.xAdvance;t D d d  yOffset -=dposito a.yAdvance;t D d d}
  th}
ailorred

f;ail};t= dUni /  LayoutEngine.protorype.getCombinifoClues h;functo a=getCombinifoClues(codePoflr l{ailorvarecombinifoClues h;uni /  .getCombinifoClues(codePoflr ;
tShor// Thai / Lao need some per-characrer workailor ===(codePoflr & ~0xff) h   0x0e00 l{ailoror ===combinifoCluesth   'Not_Reordered' l{ailor d dswitch (codePoflr l{ailorrrrrrrcase 0x0e31:ailor d d  case 0x0e34:ailor d d  case 0x0e35:ailor d d  case 0x0e36:ailor d d  case 0x0e37:ailor d d  case 0x0e47:ailor d d  case 0x0e4c:ailor d d  case 0x0e3d:ailor d d  case 0x0e4e:ailor d d   hred

f 'Abova_Right', tShororor  case 0x0eb1:ailor d d  case 0x0eb4:ailor d d  case 0x0eb5:ailor d d  case 0x0eb6:ailor d d  case 0x0eb7:ailor d d  case 0x0ebb:ailor d d  case 0x0ecc:ailor d d  case 0x0ecd:ailor d d   hred

f 'Abova', tShororor  case 0x0ebc:ailor d d   hred

f 'Below', th d d d}
 d d d} else  ===co  Poflr h   0x0e3a l{ailor d  // virama
 d d   hred

f 'Below_Right',  d d d}
 d d}
ailorswitch (combinifoClues l{ailor d// Hebrew
tShor dcase 'CCC10':h// shevatShor dcase 'CCC11':h// hataf segoltShor dcase 'CCC12':h// hataf patahtShor dcase 'CCC13':h// hataf qamatstShor dcase 'CCC14':h// hiriqtShor dcase 'CCC15':h// tseretShor dcase 'CCC16':h// segoltShor dcase 'CCC17':h// patahtShor dcase 'CCC18':h// qamatstShor dcase 'CCC20':h// qubutstShor dcase 'CCC22':ailor d d// meteg
 d d   hred

f 'Below', tShororcase 'CCC23':ailor d d// rafe
 d d   hred

f 'Attached_Abova', tShororcase 'CCC24':ailor d d// shinedot
 d d   hred

f 'Abova_Right', tShororcase 'CCC25':h// sinedot
 d d  case 'CCC19':ailor d d// holam
 d d   hred

f 'Abova_Lefr', tShororcase 'CCC26':ailor d d// poflr varika
 d d   hred

f 'Abova', tShororcase 'CCC21':ailor d d// dageshailor d dbreak, tShoror// Arabicuand Syriac tShororcase 'CCC27':h// fat atantShororcase 'CCC28':h// dammatantShororcase 'CCC30':h// fat atShororcase 'CCC31':h// dammatShororcase 'CCC33':h// shaddatShororcase 'CCC34':h// sukuntShororcase 'CCC35':h// superscript aleftShororcase 'CCC36':ailor d d// superscript alaph
 d d   hred

f 'Abova', tShororcase 'CCC29':h// kasratantShororcase 'CCC32':ailor d d// kasra
 d d   hred

f 'Below', tShoror// Thai
tShor dcase 'CCC103':ailor d d// sara u / sara uu
 d d   hred

f 'Below_Right', tShor dcase 'CCC107':ailor d d// mai
 d d   hred

f 'Abova_Right', tShor d// Lao tShor dcase 'CCC118':ailor d d// sign u / sign uu
 d d   hred

f 'Below', tShor dcase 'CCC122':ailor d d// mai
 d d   hred

f 'Abova', tShoror// TibetanttShor dcase 'CCC129':h// sign aatShor dcase 'CCC132':ailor d d// sign u
 d d   hred

f 'Below', tShor dcase 'CCC130':ailor d d// sign i
 d d   hred

f 'Abova',    h}
ailorred

f combinifoClues;ail};t= dred

f Uni /  LayoutEngine;t}( ;t=/**
 *eRepresentsra glyphtboundifohbox
 */tvareBBoxth;functo a==)putShfuncto a=BBox( putShorvareminX = argumetrs.  are  > 0t&&rargumetrs[0]t!   undefined ?rargumetrs[0]t: Infinity;tShorvareminY = argumetrs.  are  > 1t&&rargumetrs[1]t!   undefined ?rargumetrs[1]t: Infinity;tShorvaremaxX = argumetrs.  are  > 2t&&rargumetrs[2]t!   undefined ?rargumetrs[2]t: -Infinity;tShorvaremaxY = argumetrs.  are  > 3t&&rargumetrs[3]t!   undefined ?rargumetrs[3]t: -Infinity;ttShor_cluesCa lCheck(l is,tBBox ;
tShor/**
     *eT ehminimum X posito a in t edboundifohbox
     *e@rype {number}
 d d */td d this.minX = minX;atShor/**
     *eT ehminimum Y posito a in t edboundifohbox
     *e@rype {number}
 d d */td d this.minY = minY;atShor/**
     *eT ehmaxmimum X posito a in t edboundifohbox
     *e@rype {number}
 d d */td d this.maxX = maxX;atShor/**
     *eT ehmaxmimum Y posito a in t edboundifohbox
     *e@rype {number}
 d d */td d this.maxY = maxY;ail}
ail/**
   *eT ehwidst of t edboundifohbox
   *e@rype {number}
 d */t=
 dBBox.protorype.addPoflr hhfuncto a=addPoflr(x, y l{ailor ===Mae .abs=x l!   Infinity l{ailoror ===xt< this.minX l{ailor d  this.minX = x, th d  }
ailoror ===xt> this.maxX l{ailor d  this.maxX = x, th d  }
  th}
ailor ===Mae .abs=y l!   Infinity l{ailoror ===yt< this.minY l{ailor d  this.minY = y, th d  }
ailoror ===yt> this.maxY l{ailor d  this.maxY = y, th d  }
  th}
il};t= dBBox.protorype.copyth;functo a=copy()l{ailorred

funew=BBox(this.minX, this.minY, this.maxX, this.maxY ;ail};t= d_crea*eClues(BBox, [{ailorkey: "widst",tSh  get: functo a=get( l{ailor dred

futhis.maxX - this.minX,    h}
ailor/**
     *eT ehheight of t edboundifohbox
     *e@rype {number}
 d d */tail}, {ailorkey: "height",tSh  get: functo a=get( l{ailor dred

futhis.maxY - this.minY;
 Dor}
 D}]);
tShred

fuBBox;t}( ;t=// T is maps t edUni /   ScripttpropertyhtoeanhOpenTyperscript tag=// Data from http://www.microsoft.com/typography/otspec/scripttags.htm=// and http://www.uni /  .org/Public/UNIDATA/PropertyVa leAliases.txt.=var UNICODE_SCRIPTSa=+{ailCaucasian_Albanian: 'aghb',tShArabic: 'arab',tShImperial_Aramaic: 'armi',tShArmetian: 'armn',tShAvestan: 'avst',tShBalinese: 'bali',tShBamum:;'bamu',tShBassa_Vah:;'bass',tShBatak:;'batk',tShB arali: ['bng2',;'b ar'],ailBopomofo: 'bopo',tShBrahmi: 'brah',tShBraille: 'brai',tShBuginese: 'bugi',tShBuhid: 'buhd',tShChakma: 'cakm',tShCanadian_Aborigina :;'cans',tShCarian: 'cari',tShCham:;'cham',tShCherokee:;'cher',tShCoptoc: 'copt',tShCypriot: 'cprt',tShCyrilloc: 'cyrl',tShDevanagari: ['dev2',;'deva'],ailDeseret: 'dsrt',tShDuployan: 'dupl',tShEgyptoan_Hieroglyphs:;'egyp',tShElbasan: 'elba',tShEthiopoc: 'ethi',tShGeorgian: 'geor',tShGlagolitoc: 'glag',tShGothic: 'goth',tShGrant a: 'gran',tShGreek: 'grek',tShGujarati: ['gjr2',;'gujr'],ailGurmukhi: ['gur2',;'guru'],ailHangu :;'hang',ailHan:;'hani',ailHanunoo:;'hano',tShHebrew:;'hebr',tShHiragana: 'hira',tShPahawh_Hmofo: 'hmng',ailKatakana_Or_Hiragana: 'hrkt',tShOld_Italoc: 'ital',tShJavanese: 'java',ailKayah_Li: 'kali',tShKatakana: 'kana',ailKharoshthi: 'khar',ailKhmer: 'khmr',ailKhojki: 'khoj',tShKannada: ['knd2',;'knda'],ailKaithi: 'kthi',tShTai_Tham:;'lana',ailLao:;'lao ',ailLatin:;'latn',tShLepc a: 'lepc',tShLimbu: 'limb',tShLinear_A: 'lina',ailLinear_B: 'linb',tShLisu: 'lisu',tShLycian: 'lyci',tShLydian: 'lydi',tShMahajani: 'mahj',tShMandaoc: 'mand',tShManic aean: 'mani',ailMende_Kikakui: 'mend',tShMeroitoc_Cursive: 'merc',tShMeroitoc_Hieroglyphs:;'mero',tShMalayalam:;['mlm2',;'mlym'],ailModi: 'modi',tShMofoolian: 'mong',ailMro:;'mroo',tShMeetei_Mayek: 'mtei',tShMyanmar:;['mym2',;'mymr'],ailOld_North_Arabian: 'narb',tShNabataean: 'nbat',tShNko:;'nko ',ailOgham:;'ogam',tShOl_Chiki: 'olck',tShOld_Turkoc: 'orkh',tShOriya: ['ory2',;'orya'],ailOsmanya: 'osma',tShPalmyrene: 'palm',tShPau_Cin_Hau: 'pauc',tShOld_Permic: 'perm',tShPhags_Pa: 'phag',tShInscripto aal_Pahlavi: 'phli',tShPsalter_Pahlavi: 'phlp',tShPhoetician: 'phnx',tShMiao:;'plrd',tShInscripto aal_Parthian: 'prti',tShRejano: 'rjng',ailRuni : 'runr',ailSamaritan: 'samr',ailOld_South_Arabian: 'sarb',tShSaurashtra: 'saur',ailShavian: 'shaw',ailSharada: 'shrd',tShSiddham:;'sidd',ailKhudawadi: 'sind',tShSinhala: 'sinh',tShSora_Sompeno: 'sora',tShSundanese: 'sund',tShSyloti_Nagri: 'sylo',tShSyriac: 'syrc',tShTagbanwa: 'tagb',tShTakri: 'takr',tShTai_Le: 'tale',tShNew_Tai_Lue: 'talu',tShTamil: ['tml2',;'taml'],ailTai_Viet: 'tavt',tShTelugu: ['tel2',;'telu'],ailTifinagh: 'tfng',ailTagaloo: 'tglg',ailThaana: 't aa',ailThai: 't ai',tShTibetan: 'tibt',tShTirhuta: 'tirh',tShUgaritoc: 'ugar',ailVai: 'vai ',ailWarang_Citi: 'wara',tShOld_Persian: 'xpeo',tShCuneiform: 'xsux',tShYi: 'yi  ',tShInherited: 'zinh',tShCommoa: 'zyyy',tShUnknown: 'zzzz't};t=var OPENTYPE_SCRIPTSa=+{};tfor (var script in UNICODE_SCRIPTS)putShvar tao h;UNICODE_SCRIPTS[script];t D ===ADicy.isADicy(tao))h{ailorfor (var _iteratosth;rao,d_isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorthvare_ref;
tShor d ===_isADicy l{ailor d d ===_i >= _iteratos.leare ) break, th d  il_ref = _iteratos[_i++];t Dorth} else {ailor dil_i = _iteratos.next( , th d   d ===_i.done) break, th d  il_ref = _i.va le;= d  th}
ailorthvaret = _ref;
tShororOPENTYPE_SCRIPTS[t] = script;
 Dor}
 D} else {ailorOPENTYPE_SCRIPTS[tag] = script;
 D}t}t=functo a=fromOpenType(tao) {ailred

fuOPENTYPE_SCRIPTS[tag];t}t=functo a=forStrifo(strifo)putShvar lea = strifo.  are ;ailvar idxth;0, thwholeh(idxt<   a l{ailorvareco   = strifo.charCodeAt(idx++), ailor// Check if t is is a high surroga*e
   d ===0xd800t<  co   &&rco   <  0xdbfft&&ridxt<   a l{ailororvarenext = strifo.charCodeAt(idx), tShoror// Check if t is is a low surroga*e
   d d ===0xdc00t<  next &&rnext <  0xdfff) {ailor d d dx++, th d  ilco   = =(codet& 0x3FF) << 10) + =next & 0x3FF) + 0x10000, th d  }
  th}
ailorvare_script h;uni /  .getScript(code);
Shor ===_script !   'Commoa' &&r_script !   'Inherited' &&r_script !   'Unknown' l{ailor dred

fuUNICODE_SCRIPTS[_script];t D d}
 D}t= dred

fuUNICODE_SCRIPTS.Unknown;t}t=functo a=forCodePoflrs(codePoflrs l{ailfor (var ith;0; it<ecodePoflrs.  are ; i++ l{ailorvareco  Poflr hhcodePoflrs[i];ailorvare_script2 h;uni /  .getScript(codePoflr ;
Shor ===_script2 !   'Commoa' &&r_script2 !   'Inherited' &&r_script2 !   'Unknown' l{ailor dred

fuUNICODE_SCRIPTS[_script2];t D d}
 D}t= dred

fuUNICODE_SCRIPTS.Unknown;t}t=// T erscriptstinel is maptare writtea=from righthto   ft=var RTL =+{ailarab: lrue,r// Arabicailhebr: lrue,r// Hebrew
  syrc: lrue,r// Syriac   thaa: lrue,r// Thaana   cprt: lrue,r// CypriothSyllabary   khar: lrue,r// Kharosl i   phnx: lrue,r// Phoetician   'nko ': lrue,r// N'Ko   lydi: lrue,r// Lydianailavst: lrue,r// Avestanailarmi: lrue,r// Imperial Aramaic   phli: lrue,r// Inscripto aal Pahlavi   prti: lrue,r// Inscripto aal Parthian
  sarb: lrue,r// Old South Arabian
  orkh: lrue,r// Old Turkoc,hOrkhonlRuni 
  samr: lrue,r// Samaritan
 dmand: lrue,r// Mandaoc, Mandaean
 dmerc: lrue,r// Meroitoc Cursive
 dmero: lrue,r// Meroitoc Hieroglyphs
ail//dUni /   7.0 =nothlisted  a=http://www.microsoft.com/typography/otspec/scripttags.htm)
 dmani: lrue,r// Manic aean
 dmend: lrue,r// Mende Kikakui
 dnbat: lrue,r// Nabataean
 dnarb: lrue,r// Old North Arabian
  palm: lrue,r// Palmyrene   phlp: lruer// Psalter Pahlavi };t=functo a=directo a(script l{ail ===RTL[script])l{ailorred

fu'rtl';
 D}t= dred

fu'ltr';t}t=/**
 *eRepresentsra run of Glyphtand GlyphPosito a objects.
 *eRed

fed by t edfonttlayout method. t*/t=var GlyphRunth;functo a==)putShfuncto a=GlyphRun(glyphs, features,rscript, language,=directo a$$ l{ailor_cluesCa lCheck(l is,tGlyphRun ;
tShor/**
     *eAn aDicy of Glyphtobjects in t edruntShoro*e@rype {Glyph[]}
 d d */td d this.glyphsth;glyphs;
tShor/**
     *eAn aDicy of GlyphPosito a objectslfor each glyphtin t edruntShoro*e@rype {GlyphPosito a[]}
 d d */td d this.posito as h;turn;
tShor/**
     *eT erscript t atdwas requested for shapifo. T is was eirherhpuesed in oredetected automatoca ly.tShoro*e@rype {strifo}
 d d */td d this.script h;script;
tShor/**
     *eT erlanguage requested for shapifo, as puesed in. If `turn`, the defaultrlanguage forel e
     *escript was used.tShoro*e@rype {strifo}
 d d */td d this.language =rlanguage ||;turn;
tShor/**
     *eT erdirecto a requested for shapifo, as puesed in (eirherhltr orertl).tShoro*eIf `turn`, the defaultrdirecto a of t edscript is used.tShoro*e@rype {strifo}
 d d */td d this.directo a ==directo a$$h||rdirecto a(script ;
tShor/**
     *eT erfeatures requested durifo shapifo. T is is a combinato a of user
     *especified features and features chosen by t edshaper.tShoro*e@rype {object}
 d d */td d this.features =+{};tailor// Convast features toeanhobject
Shor ===ADicy.isADicy(features))h{ailororfor (var _iteratosth;features,r_isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorth dvare_ref;
tShor d   ===_isADicy l{ailor d d   ===_i >= _iteratos.leare ) break, th d  ilor_ref = _iteratos[_i++];t Dorth d} else {ailor dilor_i = _iteratos.next( , th d   d   ===_i.done) break, th d  ilor_ref = _i.va le;= d  th d}
ailorth dvaretao h;_ref;
tShor d  this.features[tag] = lrue, thth d}
th d} else  ===(rypeof features =   'undefined't? 'undefined't: _rypeof(features))h=   'object' l{ailor dthis.features =+features;t D d}
 D}t= d/**
   *eT ehtotal advancetwidst of t edrun.
   *e@rype {number}
 d */t=
 d_crea*eClues(GlyphRun, [{ailorkey: 'advanceWidst',tSh  get: functo a=get( l{ailor dvarewidst = 0;ailor dfor (var _iteratos2th;this.posito as, _isADicy2th;ADicy.isADicy(_iteratos2), _i2th;0, _iteratos2th;_isADicy2t? _iteratos2t: _getIteratos(_iteratos2);; l{ailorththvare_ref2;
tShor d d ===_isADicy2 l{ailor d d d ===_i2 >= _iteratos2.leare ) break, th d  ilil_ref2 = _iteratos2[_i2++];t Dorth d} else {ailor dilor_i2th;_iteratos2.next( , th d   d d ===_i2.done) break, th d  ilil_ref2 = _i2.va le;= d  th d}
ailorth dvareposito a =d_ref2;
tShor d dwidst +=dposito a.xAdvance;t D d d}
ailorthred

fuwidst,    h}
ailor/**
     *eT ehtotal advancetheight of t edrun.
     *e@rype {number}
 d d */tail}, {ailorkey: 'advanceHeight',tSh  get: functo a=get( l{ailor dvareheight = 0;ailor dfor (var _iteratos3th;this.posito as, _isADicy3th;ADicy.isADicy(_iteratos3), _i3th;0, _iteratos3th;_isADicy3t? _iteratos3t: _getIteratos(_iteratos3);; l{ailorth dvare_ref3;
tShor d   ===_isADicy3 l{ailor d d   ===_i3 >= _iteratos3.leare ) break, th d  ilor_ref3th;_iteratos3[_i3++];t Dorth d} else {ailor dilor_i3th;_iteratos3.next( , th d   d   ===_i3.done) break, th d  ilor_ref3th;_i3.va le;= d  th d}
ailorth dvareposito a =d_ref3;
tShor d  height +=dposito a.yAdvance;t D d d}
ailorthred

fuheight;= d  }
ailor/**
     *eT ehboundifohboxdcolrainifoha lhglyphs in t edrun.
     *e@rype {BBox}
 d d */tail}, {ailorkey: 'bbox',tSh  get: functo a=get( l{ailor dvarebbox h;tew=BBox(), tShororvarexth;0;t Dor dvarey = 0;ailor dfor (var indexth;0; indext< this.glyphs.leare ; index++ l{ailor d dvar glyphth;this.glyphs[index];t Doror dvarepth;this.posito as[index];t Doror dvarebth;glyph.bbox;tt Doror dbbox.addPoflr(b.minX + xt+ p.xOffset, b.minY +ey + p.yOffset , th d   dbbox.addPoflr(b.maxX + xt+ p.xOffset, b.maxY +ey + p.yOffset ,  th d   dx +=dp.xAdvance;t D d d  y +=dp.yAdvance;t D d d}
ailorthred

fubbox;t Dor}
 D}]);
tShred

fuGlyphRun;t}( ;t=/**
 *eRepresentsrposito aifohinformato a=forra glyphtin auGlyphRun.
 */tvareGlyphPosito a =hfuncto a=GlyphPosito a()putShvar xAdvanceth;argumetrs.  are  > 0t&&rargumetrs[0]t!   undefined ?rargumetrs[0]t: 0;ailvar yAdvanceth;argumetrs.  are  > 1t&&rargumetrs[1]t!   undefined ?rargumetrs[1]t: 0;ailvar xOffset h;argumetrs.  are  > 2t&&rargumetrs[2]t!   undefined ?rargumetrs[2]t: 0;ailvar yOffset h;argumetrs.  are  > 3t&&rargumetrs[3]t!   undefined ?rargumetrs[3]t: 0;t= d_cluesCa lCheck(l is,tGlyphPosito a);
tSh/**
   *eT eham untttoemoveht ehvirtual pea in t edXrdirecto a after renderifo t is glyph.
   *e@rype {number}
 d */t dthis.xAdvanceth;xAdvance;ttSh/**
   *eT eham untttoemoveht ehvirtual pea in t edYrdirecto a after renderifo t is glyph.
   *e@rype {number}
 d */t dthis.yAdvanceth;yAdvance;ttSh/**
   *eT ehoffset=from t edpea posito a in t edXrdirecto a atdwhoch toerender t is glyph.
   *e@rype {number}
 d */t dthis.xOffset h;xOffset;ttSh/**
   *eT ehoffset=from t edpea posito a in t edYrdirecto a atdwhoch toerender t is glyph.
   *e@rype {number}
 d */t dthis.yOffset h;yOffset;t};t=// seeehttps://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppeadixF.html=// and /System/Library/Frameworks/CoreText.framework/Vassioas/A/Headers/SFNTLayoutTypes.h  a=a Mactvarefeatures =+{t da lTypographicFeatures:l{ailor /  :;0,ailorexclusive: false,ailora lTypeFeatures:l0ail},ailligatures:l{ailor /  :;1,ailorexclusive: false,ailorrequiredLigatures:l0,ailorcommoaLigatures:l2,ailorrareLigatures:l4,ailor// logos:l6ailorrebusPictures:l8,ailordiphthongLigatures:l10,ailorsquaredLigatures:l12,ailorabbrevSquaredLigatures:l14,ailorsymbolLigatures:l16,ailorcontextualLigatures:l18,ailorhistosoca Ligatures:l20ail},ailcursiveConnecto a:l{ailor /  :;2,ailorexclusive: lrue,ailorunconnected: 0,ailorpartia lyConnected: 1,ailorcursive: 2ail},ailletterCase: {ailor /  :;3,ailorexclusive: lrueail},ail// upperAndLowerCase: 0          # depreca*edail// a lCaps:l1                    # depreca*edail// a lLowerCase: 2               # depreca*edail// sma lCaps:l3                  # depreca*edail// initia Caps:l4                # depreca*edail// initia CapsAndSma lCaps:l5    # depreca*edailvastoca Substituto a:l{ailor /  :;4,ailorexclusive: false,ailorsubstituteVastoca Forms:l0ail},aillinguisticReaDicngemetr:l{ailor /  :;5,ailorexclusive: false,ailorlinguisticReaDicngemetr:l0ail},ailnumberSpacino: {ailor /  :;6,ailorexclusive: lrue,ailormoaospacedNumbers:l0,ailorproporto aalNumbers:l1,ailorthirdWidstNumbers:l2,ailorquarterWidstNumbers:l3ail},ailsmartSwash: {ailor /  :;8,ailorexclusive: false,ailorwordInitia Swashes:l0,ailorwordFina Swashes:l2,ailor// lineInitia Swashes:l4ailor// lineFina Swashes:l6ailornonFina Swashes:l8ail},aildiacritocs:l{ailor /  :;9,ailorexclusive: lrue,ailorshowDiacritocs:l0,ailorhideDiacritocs:l1,ailordecomposeDiacritocs:l2ail},ailvastoca Posito a:l{ailor /  :;10,ailorexclusive: lrue,ailornorma Posito a:l0,ailorsuperiors:l1,ailorinferiors:l2,ailorordina s:;3,ailorscietrificInferiors:l4ail},ailfracrioas:l{ailor /  :;11,ailorexclusive: lrue,ailornoFracrioas:l0,ailorvastoca Fracrioas:l1,ailordiag aalFracrioas:l2ail},ailovaslappifoCharacrers:l{ailor /  :;13,ailorexclusive: false,ailorprevetrOvaslap:l0ail},ailtypographicExtras:l{ailor /  :;14,ailorexclusive: false,ailor// hyphensToEmDash: 0ailor// hyphenToEnDash: 2ailorslashedZero: 4ail},ail// formItrerrobano: 6ail// smartQuotes:l8ail// periodsToEllipsis:l10
 dmat ematoca Extras:l{ailor /  :;15,ailorexclusive: false,ailor// hyphenToMinus: 0ailor// asteristoMultiply: 2ailor// slashToDivi  :;4ailor// inequalityLigatures:l6ailor// exponetrs:l8ail dmat ematoca Greek: 10ail},ailornametrSets:l{ailor /  :;16,ailorexclusive: lrue,ailornoOrnametrs:l0,ailordifobats:l1,ailorpiCharacrers:l2,ailorfleuroas:l3,ailordecora
oveBorders:l4,ailoritrernato aa Symbols:;5,ailormat Symbols:;6ail},ailcharacrerAlrernatoves:l{ailor /  :;17,ailorexclusive: lrue,ailornoAlrernates:l0ail},ail// user defined opto astShdesignComplexity:l{ailor /  :;18,ailorexclusive: lrue,ailordesignLevel1:l0,ailordesignLevel2:l1,ailordesignLevel3:l2,ailordesignLevel4:l3,ailordesignLevel5: 4ail},ailstyleOprioas:l{ailor /  :;19,ailorexclusive: lrue,ailornoStyleOprioas:l0,ailordisplayText:;1,ailorengravedText:;2,ailorilluminatedCaps:l3,ailortitlingCaps:l4,ailorta lCaps:l5ail},ailcharacrerShape:l{ailor /  :;20,ailorexclusive: lrue,ailortradito aalCharacrers:l0,ailorsimplifiedCharacrers:l1,ailorJIS1978Characrers:l2,ailorJIS1983Characrers:l3,ailorJIS1990Characrers:l4,ailortradito aalAlrOn :;5,ailortradito aalAlrTwo:;6,ailortradito aalAlrThree:;7,ailortradito aalAlrFour:;8,ailortradito aalAlrFive: 9,ailorexpertCharacrers:l10,ailorJIS2004Characrers:l11,ailorhojoCharacrers:l12,ailorNLCCharacrers:l13,ailortradito aalNamesCharacrers:l14ail},ailnumberCase: {ailor /  :;21,ailorexclusive: lrue,ailorlowerCaseNumbers:l0,ailorupperCaseNumbers:l1ail},ailtextSpacino: {ailor /  :;22,ailorexclusive: lrue,ailorproporto aalText:;0,ailormoaospacedText:;1,ailorhalfWidstText:;2,ailorthirdWidstText:;3,ailorquarterWidstText:;4,ailora tProporto aalText:;5,ailora tHalfWidstText:;6ail},ailtransliterato a:l{ailor /  :;23,ailorexclusive: lrue,ailornoTransliterato a:l0ail},ail// hanjaToHangu :;1ail// hiraganaToKatakana: 2
 d// katakanaToHiragana: 3
 d// kanaToRomanizato a:l4
 d// romanizato aToHiragana: 5
 d// romanizato aToKatakana: 6ail// hanjaToHangu AlrOn :;7ail// hanjaToHangu AlrTwo:;8ail// hanjaToHangu AlrThree:;9ailannotato a:l{ailor /  :;24,ailorexclusive: lrue,ailornoAnnotato a:l0,ailorboxAnnotato a:l1,ailorroundedBoxAnnotato a:l2,ailorcircleAnnotato a:l3,ailoritvastedCircleAnnotato a:l4,ailorparetrhesisAnnotato a:l5,ailorperiodAnnotato a:l6,ailorromanNumeralAnnotato a:l7,ailordiamoadAnnotato a:l8,ailoritvastedBoxAnnotato a:l9,ailoritvastedRoundedBoxAnnotato a:l10ail},ailkanaSpacino: {ailor /  :;25,ailorexclusive: lrue,ailorfullWidstKana: 0,ailorproporto aalKana: 1ail},aili  ographicSpacino: {ailor /  :;26,ailorexclusive: lrue,ailorfullWidstI  ographs:l0,ailorproporto aalI  ographs:l1,ailorhalfWidstI  ographs:l2ail},ailuni /  Decomposito a:l{ailor /  :;27,ailorexclusive: false,ailorcanonoca Composito a:l0,ailorcompatobilityComposito a:l2,ailortrans / ingComposito a:l4ail},ailrubyKana: {ailor /  :;28,ailorexclusive: false,ailor// noRubyKana: 0     # depreca*ed - uselrubyKanaOffritsteadailor// rubyKana: 1     # depreca*ed - uselrubyKanaOnritsteadailorrubyKana: 2ail},ailCJKSymbolAlrernatoves:l{ailor /  :;29,ailorexclusive: lrue,ailornoCJKSymbolAlrernatoves:l0,ailorCJKSymbolAlrOn :;1,ailorCJKSymbolAlrTwo:;2,ailorCJKSymbolAlrThree:;3,ailorCJKSymbolAlrFour:;4,ailorCJKSymbolAlrFive: 5ail},aili  ographicAlrernatoves:l{ailor /  :;30,ailorexclusive: lrue,ailornoI  ographicAlrernatoves:l0,ailori  ographicAlrOn :;1,ailori  ographicAlrTwo:;2,ailori  ographicAlrThree:;3,ailori  ographicAlrFour:;4,ailori  ographicAlrFive: 5ail},ailCJKVastoca RomanPlacemetr:l{ailor /  :;31,ailorexclusive: lrue,ailorCJKVastoca RomanCetrered: 0,ailorCJKVastoca RomanHBaseline: 1ail},ailitalocCJKRoman:l{ailor /  :;32,ailorexclusive: false,ailor// noCJKItalocRoman:l0     # depreca*ed - uselCJKItalocRomanOffritsteadailor// CJKItalocRoman:l1     # depreca*ed - uselCJKItalocRomanOnritsteadailorCJKItalocRoman:l2ail},ailcaseSensitoveLayout:l{ailor /  :;33,ailorexclusive: false,ailorcaseSensitoveLayout:l0,ailorcaseSensitoveSpacino: 2ail},ailalrernateKana: {ailor /  :;34,ailorexclusive: false,ailoralrernateHorizKana: 0,ailoralrernateVastKana: 2ail},ailstylisticAlrernatoves:l{ailor /  :;35,ailorexclusive: false,ailornoStylisticAlrernates:l0,ailorstylisticAlrOn :;2,ailorstylisticAlrTwo:;4,ailorstylisticAlrThree:;6,ailorstylisticAlrFour:;8,ailorstylisticAlrFive: 10,ailorstylisticAlrSix:l12,ailorstylisticAlrSevet:l14,ailorstylisticAlrEight:;16,ailorstylisticAlrNine: 18,ailorstylisticAlrTet:l20,ailorstylisticAlrElevet:l22,ailorstylisticAlrTwelv :;24,ailorstylisticAlrThisteet:l26,ailorstylisticAlrFourteet:l28,ailorstylisticAlrFifteet:l30,ailorstylisticAlrSixteet:l32,ailorstylisticAlrSevetteet:l34,ailorstylisticAlrEighteet:l36,ailorstylisticAlrNineteet:l38,ailorstylisticAlrTwetty:;40ail},ailcontextualAlrernates:l{ailor /  :;36,ailorexclusive: false,ailorcontextualAlrernates:l0,ailorswashAlrernates:l2,ailorcontextualSwashAlrernates:l4ail},aillowerCase: {ailor /  :;37,ailorexclusive: lrue,ailordefaultLowerCase: 0,ailorlowerCaseSma lCaps:l1,ailorlowerCasePetiteCaps:l2ail},ailupperCase: {ailor /  :;38,ailorexclusive: lrue,ailordefaultUpperCase: 0,ailorupperCaseSma lCaps:l1,ailorupperCasePetiteCaps:l2ail},aillanguageTao: {r// indices into  tao rableailor /  :;39,ailorexclusive: lrueail},ailCJKRomanSpacino: {ailor /  :;103,ailorexclusive: lrue,ailorhalfWidstCJKRoman:l0,ailorproporto aalCJKRoman:l1,ailordefaultCJKRoman:l2,ailorfullWidstCJKRoman:l3ail}t};t=var feature =hfuncto a=feature(name, selectos) {ailred

fu[features[name].code, features[name][selectos]];a};t=var OTMappifo =+{t drlio: feature('ligatures',;'requiredLigatures'),ailclio: feature('ligatures',;'contextualLigatures'),aildlio: feature('ligatures',;'rareLigatures'),ailhlio: feature('ligatures',;'histosoca Ligatures'),ailliga: feature('ligatures',;'commoaLigatures'),ailhist: feature('ligatures',;'histosoca Ligatures'),r// ??ttShsmcp: feature('lowerCase',;'lowerCaseSma lCaps'),ailpcap: feature('lowerCase',;'lowerCasePetiteCaps'),a
ilfrac: feature('fracrioas',;'diag aalFracrioas'),aildnom: feature('fracrioas',;'diag aalFracrioas'),r// ??tilnumr: feature('fracrioas',;'diag aalFracrioas'),r// ??tilafrc: feature('fracrioas',;'vastoca Fracrioas'),ail// aaltail// abvf, abvm, abvs, akhn, blwf, blwm, blws,ecfar,ecjct, cpsp, falt, isol, jalt, ljmo, mset?ail// ltra, ltrm, nukt, pref, pres, pstf, psts, rand, rkrf, rphf, rtla, rtlm, size, tjmo, tnum?ail// uni , vatu, vhal, vjmo, vpal, vrt2
 d// dist ->rtrak rable?ail// kern, vk
fu->rkerntrableail// lfbd + opbd + rtbd ->ropbd rable?ail// mark, mkmk ->racntttable?ail// locl ->rlanguageTao +  tao rableaailcase: feature('caseSensitoveLayout',;'caseSensitoveLayout'),r// alsorcaseSensitoveSpacinoailccmp: feature('uni /  Decomposito a',;'canonoca Composito a'),r// compatobilityComposito a?ailcpct: feature('CJKVastoca RomanPlacemetr',;'CJKVastoca RomanCetrered'),r// guess..., probably not goven below
ddvalt: feature('CJKVastoca RomanPlacemetr',;'CJKVastoca RomanCetrered'),tShswsh: feature('contextualAlrernates',;'swashAlrernates'),ailcswh: feature('contextualAlrernates',;'contextualSwashAlrernates'),ailcurs:lfeature('cursiveConnecto a',;'cursive'),r// ??tilc2pc: feature('upperCase',;'upperCasePetiteCaps'),ailc2sc: feature('upperCase',;'upperCaseSma lCaps'),aailinit: feature('smartSwash',;'wordInitia Swashes'),r// ??tilfin2: feature('smartSwash',;'wordFina Swashes'),r// ??tilmedi: feature('smartSwash',;'nonFina Swashes'),r// ??tilmed2: feature('smartSwash',;'nonFina Swashes'),r// ??tilfin3: feature('smartSwash',;'wordFina Swashes'),r// ??tilfina: feature('smartSwash',;'wordFina Swashes'),r// ??tailpkna: feature('kanaSpacino',;'proporto aalKana'),ailhalf: feature('textSpacino',;'halfWidstText'),r// alsorHalfWidstCJKRoman,rHalfWidstI  ographs?ailhalt: feature('textSpacino',;'a tHalfWidstText'),aailhkna: feature('alrernateKana',;'a ternateHorizKana'),ailvkna: feature('alrernateKana',;'a ternateVastKana'),ail// hngl: feature 'transliterato a',;'hanjaToHangu Selectos' # depreca*edaailital: feature('italocCJKRoman',;'CJKItalocRoman'),aillnum: feature('numberCase',;'upperCaseNumbers'),ailonum: feature('numberCase',;'lowerCaseNumbers'),ailmgrk: feature('mat ematoca Extras',;'mat ematoca Greek'),aail// nalt: not enoughhinfo. w atdrype oflannotato a?ail// ornm: ditto,dwhoch ornametrlstyle?aailcalt: feature('contextualAlrernates',;'contextualAlrernates'),l// or more?ailvrt2: feature('vastoca Substituto a',;'substituteVastoca Forms'),l// oh... below?ailvert: feature('vastoca Substituto a',;'substituteVastoca Forms'),ailtnum: feature('numberSpacino',;'moaospacedNumbers'),ailpnum: feature('numberSpacino',;'proporto aalNumbers'),tShsups: feature('vastoca Posito a',;'superiors'),tShsubs: feature('vastoca Posito a',;'inferiors'),ailordn: feature('vastoca Posito a',;'ordina s'),ailpwid: feature('textSpacino',;'proporto aalText'),ailhwid: feature('textSpacino',;'halfWidstText'),ailqwid: feature('textSpacino',;'quarterWidstText'),r// alsorQuarterWidstNumbers?ailtwid: feature('textSpacino',;'thirdWidstText'),r// alsorThirdWidstNumbers?tilfwid: feature('textSpacino',;'proporto aalText'),r//??tilpalt: feature('textSpacino',;'a tProporto aalText'),ailtrad: feature('characrerShape',;'tradito aalCharacrers'),tShsmpl: feature('characrerShape',;'simplifiedCharacrers'),tShjp78: feature('characrerShape',;'JIS1978Characrers'),tShjp83: feature('characrerShape',;'JIS1983Characrers'),tShjp90: feature('characrerShape',;'JIS1990Characrers'),tShjp04: feature('characrerShape',;'JIS2004Characrers'),tShexpt: feature('characrerShape',;'expertCharacrers'),ailhojo: feature('characrerShape',;'hojoCharacrers'),ailnlck: feature('characrerShape',;'NLCCharacrers'),ailtnam: feature('characrerShape',;'tradito aalNamesCharacrers'),ailruby: feature('rubyKana',;'rubyKana'),ailtitl: feature('styleOprioas',;'titlingCaps'),ailzero: feature('typographicExtras',;'slashedZero'),aailss01: feature('stylisticAlrernatoves',;'stylisticAlrOn '),tShss02: feature('stylisticAlrernatoves',;'stylisticAlrTwo'),tShss03: feature('stylisticAlrernatoves',;'stylisticAlrThree'),tShss04: feature('stylisticAlrernatoves',;'stylisticAlrFour'),tShss05: feature('stylisticAlrernatoves',;'stylisticAlrFive'),tShss06: feature('stylisticAlrernatoves',;'stylisticAlrSix'),tShss07: feature('stylisticAlrernatoves',;'stylisticAlrSevet'),tShss08: feature('stylisticAlrernatoves',;'stylisticAlrEight'),tShss09: feature('stylisticAlrernatoves',;'stylisticAlrNine'),tShss10: feature('stylisticAlrernatoves',;'stylisticAlrTet'),tShss11: feature('stylisticAlrernatoves',;'stylisticAlrElevet'),tShss12: feature('stylisticAlrernatoves',;'stylisticAlrTwelv '),tShss13: feature('stylisticAlrernatoves',;'stylisticAlrThisteet'),tShss14: feature('stylisticAlrernatoves',;'stylisticAlrFourteet'),tShss15: feature('stylisticAlrernatoves',;'stylisticAlrFifteet'),tShss16: feature('stylisticAlrernatoves',;'stylisticAlrSixteet'),tShss17: feature('stylisticAlrernatoves',;'stylisticAlrSevetteet'),tShss18: feature('stylisticAlrernatoves',;'stylisticAlrEighteet'),tShss19: feature('stylisticAlrernatoves',;'stylisticAlrNineteet'),tShss20: feature('stylisticAlrernatoves',;'stylisticAlrTwetty')t};t=// salt: feature 'stylisticAlrernatoves',;'stylisticAlrOn ' # hmm,dwhoch onehto chooset=// Add cv01-cv99 features
for (var ith;1; it<= 99; i++ l{ailOTMappifo['cv' + ='00' + i).slice(-2)] = [features.characrerAlrernatoves.code, i];t}t=// crea*eritvassehmappifo=var AATMappifo =+{};tfor (var ot in OTMappifo)putShvar aat h;OTMappifo[ot];t D ===AATMappifo[aat[0]] =h;turn l{ailorAATMappifo[aat[0]] =+{};t d}
ailAATMappifo[aat[0]][aat[1]] =+ot;t}t=// Maps an aDicy of OpenTyperfeatures toeAAT features
// in t edform of {featureType:{featureSettino:lrue}}=functo a=mapOTToAAT(features)putShvar res =+{};t dfor (var k in features)putShShvar r =+void 0;ailor ===r h;OTMappifo[k] l{ailor d ===res[r[0]] =h;turn l{ailorrrrrres[r[0]] =+{};t ddddd}
ailorthres[r[0]][r[1]] =+features[k];t D d}
 D}t= dred

fures;t}t=// Maps strifostin au[featureType, featureSettino]=// to t eir equivaletrlnumberr /  s=functo a=mapFeatureStrifos(f)putShvar typer=+f[0],ailorthsettinor=+f[1];tt D ===isNaN(rype))putShShvar rypeCo   = features[type]t&&rfeatures[type].code;t d} else {ailorvar rypeCo   = rype;t d}
ail ===isNaN(settino))putShShvar settinoCo   = features[type]t&&rfeatures[type][settino];t d} else {ailorvar settinoCo   = settino;
 D}t= dred

fu[rypeCo  , settinoCo  ];t}t=// Maps AAT features toeanhaDicy of OpenTyperfeatures=// Suppor*s bothhaDicys in t edform of [[featureType, featureSettino]]=// and objects in t edform of {featureType:{featureSettino:lrue}}=// featureTypes and featureSettinosrcan be eirherhstrifostor numberr /  s=functo a=mapAATToOT(features)putShvar res =+{};t d ===ADicy.isADicy(features))h{ailorfor (var k h;0; k <rfeatures.leare ; k++ l{ailor dvar r =+void 0;ailor dvar f = mapFeatureStrifos(features[k] , th d   ===r h;AATMappifo[f[0]] &&rAATMappifo[f[0]][f[1]] l{ailorrrrrres[r] = lrue, thth d}
th d}t d} else  ===(rypeof features =   'undefined't? 'undefined't: _rypeof(features))h=   'object' l{ailorfor (var typerin features)putShSh dvare_feature =hfeatures[type];ailor dfor (var settinorin _feature l{ailorth dvare_r =+void 0;ailor d dvare_f = mapFeatureStrifos([type, settino] , th d   d ===_feature[settino] &&r(_r h;AATMappifo[_f[0]] &&rAATMappifo[_f[0]][_f[1]]  l{ailor d d  res[_r] = lrue, thth d d}
 d d d}t D d}
 D}t= dred

fu_Object$keys=res);t}t=vare_clues$3;=functo a=_applyDecora
edDescriptor$3(target, property,rdecora
ors,rdescriptor,rcontext)putShvar desc =+{};t dObject['ke' + 'ys'](descriptor).forEach(functo a==key l{ailordesc[key] = descriptor[key];
 D} , thdesc.enumerable =h!!desc.enumerable, thdesc.configurable =h!!desc.configurable;tt D ==='va le'rin desc ||rdesc.initia izer l{ailordesc.writable =hlrue, th}t= ddesc =+decora
ors.slice().revesse().reduce(functo a==desc,rdecora
or)l{ailorred

fudecora
or(target, property,rdesc) ||rdesc, th},rdesc);tt D ===context &&rdesc.initia izert!   void 0 l{ailordesc.va le = desc.initia izert? desc.initia izer.ca l(context)p:+void 0;ailordesc.initia izert  undefined;t d}
ail ===desc.initia izert    void 0 l{ailorObject['define' + 'Property'](target, property,rdesc);ailordesc h;turn;
 D}t= dred

fudesc, }t=vareAATLookupTable =h(_clues$3th;functo a==)putShfuncto a=AATLookupTable(table l{ailor_cluesCa lCheck(l is,tAATLookupTable ,  th dthis.table =hlable, th}
ailAATLookupTable.protorype.lookupth;functo a=lookup(glyph l{ailorswitch (this.table.vassioa l{ailor dcase 0:ailor d d// simplehaDicy formatailorrrrrret

futhis.table.va les.getItem(glyph , tShor dcase 2:h// segmetrlformatailorrrcase 4:ailor d d{ailor d d  varemin h;0, th dddddorvaremaxth;this.table.binarySearchHeader.nUnits -;1; tShororor  wholeh(min <= max l{ailor d d    varemid = min + maxt>>;1; ilor d d    varesegth;this.table.segmetrs[mid]; tShororor   d// special end of search va letShororor   d ===seg.firstGlyphth   0xffff) {ailor d dorrrrrret

futurn;
 DDDDDDDDDDD}
tShororor   d ===glypht< seg.firstGlyph) {ailor d dorrrrrmaxth;mid -;1; ilor d d    } else  ===glypht> seg.luetGlyph) {ailor d dorrrrrmin h;mid +;1; ilor d d    } else {ailor d dorrrrr ===this.table.vassioath   2) {ailor d dorrrrrrrret

fuseg.va le;= d  th d d    } else {ailor d dorrrrrrrret

fuseg.va les[glypht- seg.firstGlyph];= d  th d d    }
  th d d    }
  th d d  }
tShororor  ret

futurn;
 DDDDDDD} tShor dcase 6:ailor d d{ailor d d  // lookuptsifole th dddddorvare_min h;0, th dddddorvare_maxth;this.table.binarySearchHeader.nUnits -;1; tShororor  wholeh(_min <= _max l{ailor d d    varemid = _min + _maxt>>;1; ilor d d    varesegth;this.table.segmetrs[mid]; tShororor   d// special end of search va letShororor   d ===seg.glyphth   0xffff) {ailor d dorrrrrret

futurn;
 DDDDDDDDDDD}
tShororor   d ===glypht< seg.glyph) {ailor d dorrrrr_maxth;mid -;1; ilor d d    } else  ===glypht> seg.glyph) {ailor d dorrrrr_min h;mid +;1; ilor d d    } else {ailor d dorrrrrret

fuseg.va le;= d  th d d  }
  th d d  }
tShororor  ret

futurn;
 DDDDDDD} tShor dcase 8:ailor d d// lookupttrimmedailorrrrrret

futhis.table.va les[glypht- this.table.firstGlyph];=ailorrrdefault:ailor d dthrow;tew=Error('Unknown lookupttable format: ' + this.table.vassioa ;t D d}
 D};
ailAATLookupTable.protorype.glyphsForVa le = functo a=glyphsForVa le(cluesVa le)putShShvar res =+[];=ailorswitch (this.table.vassioa l{ailor dcase 2:h// segmetrlformatailorrrcase 4:ailor d d{ailor d d  for (var _iteratosth;rhis.table.segmetrs,r_isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorth dShShvar _ref;
tShor d       ===_isADicy l{ailor d d       ===_i >= _iteratos.leare ) break, th d  ilorrrrr_ref = _iteratos[_i++];t Dorth d D d} else {ailor d dorrrrr_i = _iteratos.next( , th d   d       ===_i.done) break, th d  ilorrrrr_ref = _i.va le;= d  th d d  }
 ilor d d    varesegmetrlh;_ref;
tShor d       ===this.table.vassioath   2 &&rsegmetr.va le =   cluesVa le)putShShhhhhhhhhhhres.push.apply(res, icnge(segmetr.firstGlyph,rsegmetr.luetGlyph +;1));t Dorth d D d} else {ailor d dorrrrrfor (var indexth;0; indext< segmetr.va les.leare ; index++ l{ailor d d d       ===segmetr.va les[index] =   cluesVa le)putShShhhhhhhhhhhhhhhres.push(segmetr.firstGlyph + index , th d   d        }
  th d d      }
  th d d    }
  th d d  }
tShororor  break, th d  il} tShor dcase 6:ailor d d{ailor d d  // lookuptsifole th dddddorfor (var _iteratos2th;this.table.segmetrs,r_isADicy2th;ADicy.isADicy(_iteratos2), _i2th;0, _iteratos2th;_isADicy2t? _iteratos2t: _getIteratos(_iteratos2);; l{ailorththhhhhvare_ref2;
tShor d d     ===_isADicy2 l{ailor d d d     ===_i2 >= _iteratos2.leare ) break, th d  ililllll_ref2 = _iteratos2[_i2++];t Dorth d  il} else {ailor d dorrrrr_i2th;_iteratos2.next( , th d   d d     ===_i2.done) break, th d  ilorrrrr_ref2 = _i2.va le;= d  th d  il} tShor dthhhhhvare_segmetrlh;_ref2;
tShor d d     ===_segmetr.va le =   cluesVa le)putShShhhhhhhhhhhres.push=_segmetr.glyph ,  d  th d  il}   th d  il} tShor dthhhbreak, th d  il} tShor dcase 8:ailor d d{ailor d d  // lookupttrimmedailorrrrrilfor (var ith;0; it<ethis.table.va les.  are ; i++ l{ailor d d     ===this.table.va les[i] =   cluesVa le)putShShhhhhhhhhhhres.push=this.table.firstGlyph + i),  d  th d  il}   th d  il} tShor dthhhbreak, th d  il} tShor ddefault:ailor d dthrow;tew=Error('Unknown lookupttable format: ' + this.table.vassioa ;t D d}

hhhhred

fures;t D};
ailred

fuAATLookupTable;t}( ,==_applyDecora
edDescriptor$3(_clues$3.protorype,;'glyphsForVa le', [cache],u_Object$getOwnPropertyDescriptor(_clues$3.protorype,;'glyphsForVa le'), _clues$3.protorype)), _clues$3);t=var START_OF_TEXT_STATE h;0, var END_OF_TEXT_CLASS h;0, var OUT_OF_BOUNDS_CLASS h;1, var DELETED_GLYPH_CLASS h;2, var DONT_ADVANCE h;0x4000, =vareAATSta
eMachine = functo a==)putShfuncto a=AATSta
eMachine(sta
eTable l{ailor_cluesCa lCheck(l is,tAATSta
eMachine ,  th dthis.sta
eTable = sta
eTable; th dthis.lookupTable =htew=AATLookupTable(sta
eTable.cluesTable , th}
ailAATSta
eMachine.protorype.process = functo a=process(glyphs, revesse,=processEntry)putShShvar curretrSta
e = START_OF_TEXT_STATE;r// START_OF_LINE_STATE is usedlfor kashida glyphtinserto as sometimes Idthink?tShShvar indexth;revesset? glyphs.leare  -;1t: 0;ailShvar dirth;revesset? -1t: 1; tShorwholeh(dirth   1t&&rindext<= glyphs.leare  ||rdirth   -1t&&rindext>  -1)putShSh dvareglyphth;turn;
 DDDDDvar cluesCo   = OUT_OF_BOUNDS_CLASS;
 DDDDDvar shouldAdvanceth;lrue, 
 d     ===indexth== glyphs.leare  ||rindexth== -1)putShSh d  cluesCo   = END_OF_TEXT_CLASS, thth d} else {ailor d dglyphth;glyphs[index];t Doror d ===glyph.id =   0xffff) {ailor d dor// dele*ed glyphailor d dorcluesCo   = DELETED_GLYPH_CLASS, th d  il} else {ailor d dorcluesCo   = this.lookupTable.lookup(glyph.id , th d   d   ===cluesCo   =h;turn l{ailorrrrr dorcluesCo   = OUT_OF_BOUNDS_CLASS;
 DDDDD D d}
DDDD D d}
DDDD D}
ailorthvarerow;=dthis.sta
eTable.sta
eADicy.getItem(curretrSta
e);
 DDDDDvar entryIndexth;row[cluesCo  ];
 DDDDDvar entry;=dthis.sta
eTable.entryTable.getItem(entryIndex), 
 d     ===cluesCo   !   END_OF_TEXT_CLASS &&rcluesCo   !   DELETED_GLYPH_CLASS l{ailorrrrrprocessEntry(glyph, entry, index , th d   dshouldAdvanceth;!(entry.flags & DONT_ADVANCE , th d  } tShor dcurretrSta
e = entry.tewSta
e, th d   ===shouldAdvance) {ailor d d ndext+==dir, thth d}
th d}t
hhhhred

fuglyphs;
 D};
ail/**
   *ePerforms a depth-firstltravessal of t edglyphtstrifos
   *erepresented by t edsta
e machine.
   */t=
 dAATSta
eMachine.protorype.travesse = functo a=travesse(opts)putShShvar sta
e = argumetrs.  are  > 1t&&rargumetrs[1]t!   undefined ?rargumetrs[1]t: 0;ailShvar visited h;argumetrs.  are  > 2t&&rargumetrs[2]t!   undefined ?rargumetrs[2]t: tew=_Set(), tShor ===visited.has(sta
e  l{ailor dred

f;t D d}

hhhhvisited.add(sta
e ;
ailorvare_sta
eTable = this.sta
eTable,ailor d dnClueses =+_sta
eTable.nClueses,ailor d dsta
eADicy =+_sta
eTable.sta
eADicy,ailor d dentryTable =+_sta
eTable.entryTable;
ailorvarerow;=dsta
eADicy.getItem(sta
e ;
ailor// Skip predefined cluesesailorfor (var cluesCo   = 4; cluesCo   <dnClueses; cluesCo  ++ l{ailor dvar entryIndexth;row[cluesCo  ];
 DDDDDvar entry;=dentryTable.getItem(entryIndex), 
 d    // Try;a lhglyphs in t edclues
 d    for (var _iteratosth;rhis.lookupTable.glyphsForVa le(cluesCo  ),r_isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorth dvare_ref;
tShor d   ===_isADicy l{ailor d d   ===_i >= _iteratos.leare ) break, th d  ilor_ref = _iteratos[_i++];t Dorth d} else {ailor dilor_i = _iteratos.next( , th d   d   ===_i.done) break, th d  ilor_ref = _i.va le;= d  th d}
ailorth dvareglyphth;_ref;
tShor d   ===opts.etrer l{ailor d d  opts.etrer(glyph, entry);= d  th d}
ailorth d ===entry.tewSta
et!   0 l{ailor d d  this.travesse(opts, entry.tewSta
e,hvisited);= d  th d}
ailorth d ===opts.exit l{ailor d d  opts.exit(glyph, entry);= d  th d}
  th d}
  th}
 D};
ailred

fuAATSta
eMachine;t}( ;t=vare_clues$2;=functo a=_applyDecora
edDescriptor$2(target, property,rdecora
ors,rdescriptor,rcontext)putShvar desc =+{};t dObject['ke' + 'ys'](descriptor).forEach(functo a==key l{ailordesc[key] = descriptor[key];
 D} , thdesc.enumerable =h!!desc.enumerable, thdesc.configurable =h!!desc.configurable;tt D ==='va le'rin desc ||rdesc.initia izer l{ailordesc.writable =hlrue, th}t= ddesc =+decora
ors.slice().revesse().reduce(functo a==desc,rdecora
or)l{ailorred

fudecora
or(target, property,rdesc) ||rdesc, th},rdesc);tt D ===context &&rdesc.initia izert!   void 0 l{ailordesc.va le = desc.initia izert? desc.initia izer.ca l(context)p:+void 0;ailordesc.initia izert  undefined;t d}
ail ===desc.initia izert    void 0 l{ailorObject['define' + 'Property'](target, property,rdesc);ailordesc h;turn;
 D}t= dred

fudesc, }t=// indicereplacemetr flags=vareMARK_FIRST h;0x8000, vareMARK_LAST h;0x2000, vareVERB h;0x000F;t=// contextualrsubstituto a and glyphtinserto a flag=var SET_MARK h;0x8000, 
// ligature entry;flags=vareSET_COMPONENT h;0x8000, varePERFORM_ACTION h;0x2000, 
// ligature acto a=masks=vareLAST_MASK h;0x80000000, vareSTORE_MASK h;0x40000000, vareOFFSET_MASK h;0x3FFFFFFF;t=vareREVERSE_DIRECTION h;0x400000, vareCURRENT_INSERT_BEFORE h;0x0800, vareMARKED_INSERT_BEFORE h;0x0400, vareCURRENT_INSERT_COUNT h;0x03E0, vareMARKED_INSERT_COUNT h;0x001F, =vareAATMorxProcessosth;(_clues$2 = functo a==)putShfuncto a=AATMorxProcessos(font l{ailor_cluesCa lCheck(l is,tAATMorxProcessos ,  th dthis.processIndicReaDicgemetrth;rhis.processIndicReaDicgemetr.bind(l is); th dthis.processContextualSubstituto a =dthis.processContextualSubstituto a.bind(l is); th dthis.processLigature =dthis.processLigature.bind(l is); th dthis.processNoncontextualSubstituto as =dthis.processNoncontextualSubstituto as.bind(l is); th dthis.processGlyphInserto a =dthis.processGlyphInserto a.bind(l is); th dthis.fontt=dfont; th dthis.morxt=dfont.morx; th dthis.inputCache h;turn;
 D}t= d// Processes an aDicy of glyphs and applies t edspecified features= d// Featuresdshould be in t edform of {featureType:{featureSettino:lrue}}=
ailAATMorxProcessos.protorype.process = functo a=process(glyphs)putShShvar features = argumetrs.  are  > 1t&&rargumetrs[1]t!   undefined ?rargumetrs[1]t: {};tailorfor (var _iteratosth;rhis.morx.chains,r_isADicyth;ADicy.isADicy(_iteratos), _ith;0, _iteratosth;_isADicyt? _iteratost: _getIteratos(_iteratos);; l{ailorthvare_ref;
tShor d ===_isADicy l{ailor d d ===_i >= _iteratos.leare ) break, th d  il_ref = _iteratos[_i++];t Dorth} else {ailor dil_i = _iteratos.next( , th d   d ===_i.done) break, th d  il_ref = _i.va le;= d  th}
ailorthvarechainth;_ref;
tShor dvar flags =echain.defaultFlags, 
 d    // enable/disable t edrequested features= dilorfor (var _iteratos2 =echain.features, _isADicy2th;ADicy.isADicy(_iteratos2), _i2th;0, _iteratos2th;_isADicy2t? _iteratos2t: _getIteratos(_iteratos2);; l{ailorththvare_ref2;
tShor d d ===_isADicy2 l{ailor d d d ===_i2 >= _iteratos2.leare ) break, th d  ilil_ref2 = _iteratos2[_i2++];t Dorth d} else {ailor dilor_i2th;_iteratos2.next( , th d   d d ===_i2.done) break, th d  ilil_ref2 = _i2.va le;= d  th d}
ailorth dvarefeature =h_ref2;
tShor d dvar f = void 0;ailor d d ===(f = features[feature.featureType])t&&rf[feature.featureSettino] l{ailor d d dflags &= feature.disableFlags, ilor d d dflags |= feature.enableFlags, ilor d d}
DDDD D}
ailorthfor (var _iteratos3th;chain.subtables, _isADicy3th;ADicy.isADicy(_iteratos3), _i3th;0, _iteratos3th;_isADicy3t? _iteratos3t: _getIteratos(_iteratos3);; l{ailorth dvare_ref3;
tShor d   ===_isADicy3 l{ailor d d   ===_i3 >= _iteratos3.leare ) break, th d  ilor_ref3th;_iteratos3[_i3++];t Dorth d} else {ailor dilor_i3th;_iteratos3.next( , th d   d   ===_i3.done) break, th d  ilor_ref3th;_i3.va le;= d  th d}
ailorth dvaresubtable =d_ref3;
tShor d   ===subtable.subFeatureFlags & flags l{ailor d d  this.processSubtable=subtable, glyphs);= d  th d}
  th d}
  th}
ailor// removehdele*ed glyphstShShvar indexth;glyphs.leare  -;1;= d  wholeh(indext>  0 l{ailor d ===glyphs[index].id =   0xffff) {ailor d dglyphs.splice(index, 1 , th d  } tShor dindex--;t D d}

hhhhred

fuglyphs;
 D};
ailAATMorxProcessos.protorype.processSubtable =dfuncto a=processSubtable=subtable, glyphs) {ailorthis.subtable =dsubtable; th dthis.glyphs =uglyphs;
 D   ===this.subtable.typer=   4 l{ailor dthis.processNoncontextualSubstituto as=this.subtable,dthis.glyphs , th d  red

f;t D d}

hhhhrhis.ligatureStack h;[]; th dthis.markedGlyphth;turn;
 DDDthis.firstGlyphth;turn;
 DDDthis.luetGlyph h;turn;
 DDDthis.markedIndexth;turn;
tShShvar sta
eMachine = this.getSta
eMachine(subtable);ailShvar process = this.getProcessos( ;
ailorvarerevesset=h!!=this.subtable.covascge & REVERSE_DIRECTION);ailShret

fusta
eMachine.process(this.glyphs, revesse,=process);
 D};
ailAATMorxProcessos.protorype.getSta
eMachine =dfuncto a=getSta
eMachine(subtable)l{ailorred

futew=AATSta
eMachine(subtable.table.sta
eTable ;
 D};
ailAATMorxProcessos.protorype.getProcessosth;functo a=getProcessos( l{ailorswitch (this.subtable.type l{ailor dcase 0:ailor d dret

futhis.processIndicReaDicgemetr;ailor dcase 1:ailor d dret

futhis.processContextualSubstituto a;ailor dcase 2:ailor d dret

futhis.processLigature;ailor dcase 4:ailor d dret

futhis.processNoncontextualSubstituto as;ailor dcase 5:ailor d dret

futhis.processGlyphInserto a;ailor ddefault:ailor d dthrow;tew=Error('Inva id morxtsubtable type: ' + this.subtable.type ;t D d}
 D};
ailAATMorxProcessos.protorype.processIndicReaDicgemetrth;functo a=processIndicReaDicgemetr(glyph, entry, index l{ailor ===entry.flags & MARK_FIRST l{ailor dthis.firstGlyphth;index;t D d}

hhhh ===entry.flags & MARK_LAST l{ailor dthis.luetGlyph h;index;t D d}

hhhhreorderGlyphs(this.glyphs, entry.flags & VERB,dthis.firstGlyph,dthis.luetGlyph ;
 D};
ailAATMorxProcessos.protorype.processContextualSubstituto a =dfuncto a=processContextualSubstituto a(glyph, entry, index l{ailorvaresubsituto as =dthis.subtable.table.substituto aTable.items;
 D   ===entry.markIndext!   0xffff) {ailor dvarelookupth;subsituto as.getItem(entry.markIndex);
 DDDDDvar lookupTable =htew=AATLookupTable(lookup);
 DDDDDglyphth;this.glyphs[this.markedGlyph];
 DDDDDvar gid = lookupTable.lookup(glyph.id , th d   ===gid  {ailor d dthis.glyphs[this.markedGlyph]th;this.font.getGlyph=gid, glyph.codePoflrs , th d  }  D d}

hhhh ===entry.curretrIndext!   0xffff) {ailor dvare_lookupth;subsituto as.getItem(entry.curretrIndex);
 DDDDDvar _lookupTable =htew=AATLookupTable(_lookup);
 DDDDDglyphth;this.glyphs[index];t Dororvar gid = _lookupTable.lookup(glyph.id , th d   ===gid  {ailor d dthis.glyphs[index] =;this.font.getGlyph=gid, glyph.codePoflrs , th d  }  D d}

hhhh ===entry.flags & SET_MARK l{ailor dthis.markedGlyphth;index;t D d}
 D};
ailAATMorxProcessos.protorype.processLigature =dfuncto a=processLigature(glyph, entry, index l{ailor ===entry.flags & SET_COMPONENT l{ailor dthis.ligatureStack.push=index , th d}

hhhh ===entry.flags & PERFORM_ACTION) {ailor dvare_ligatureStack;
tShor dvar acrioas =dthis.subtable.table.ligatureActo as;ailor dvarecomponetrs =dthis.subtable.table.componetrs;
 DDDDDvar ligatureList =dthis.subtable.table.ligatureList;
tShor dvar acrioaIndexth;entry.acrioa;
 DDDDDvar last =dfalse;
 DDDDDvar ligatureIndexth;0;ailor dvarecodePoflrs h;[]; th dDDvar ligatureGlyphs =u[];=ailorrrwholeh(!last l{ailorth dvare_codePoflrs;
tShor d dvar componetrGlyphth;this.ligatureStack.pop( , th d   d(_codePoflrs h;codePoflrs .unshift.apply(_codePoflrs,dthis.glyphs[componetrGlyph].codePoflrs , tShor d dvar acto a== acrioas.getItem(acrioaIndex++ , th d   dlast =d!!=acto a=&eLAST_MASK , th d   dvar store =d!!=acto a=&eSTORE_MASK , th d   dvar offset h;=acto a=&eOFFSET_MASK) << 2t>>;2;d// sign extend 30 toe32 bits th d   doffset +=dthis.glyphs[componetrGlyph].id;
tShor d dvar componetr h;componetrs.getItem(offset , th d   dligatureIndext+h;componetr;
tShor d   ===last || store l{ailor d d  var ligatureEntry;=dligatureList.getItem(ligatureIndex , th d   d  this.glyphs[componetrGlyph] =;this.font.getGlyph=ligatureEntry, codePoflrs , th d     dligatureGlyphs.push=componetrGlyph , th d     dligatureIndexth;0;ailor dddddcodePoflrs h;[]; th dDD d} else {ailor dilorthis.glyphs[componetrGlyph] =;this.font.getGlyph=0xffff), ilor d d}
DDDD D}
ailorth// Put ligature glyphtindexes back on t edstack
 d   d(_ligatureStack h;this.ligatureStack).push.apply(_ligatureStack,dligatureGlyphs ;t D d}
 D};
ailAATMorxProcessos.protorype.processNoncontextualSubstituto as =dfuncto a=processNoncontextualSubstituto as=subtable, glyphs, index l{ailorvarelookupTable =htew=AATLookupTable(subtable.table.lookupTable ,  th dfor (indexth;0; indext< glyphs.leare ; index++ l{ailor dvareglyphth;glyphs[index];t Doror ===glyph.id !   0xffff) {ailor dDDvar gid = lookupTable.lookup(glyph.id , th d     ===gid  {ailor d dth// 0 meaas do nothinoailllllllllglyphs[index] =;this.font.getGlyph=gid, glyph.codePoflrs , th d   d}
  th d}
  th}
 D};
ailAATMorxProcessos.protorype._insertGlyphs =ufuncto a=_insertGlyphs(glyphIndex, inserto aAcrioaIndex, count, isBefore l{ailorvare_glyphs;
ailorvareinserto as h;[]; th dwholeh(count-- l{ailor dvaregid = this.subtable.table.inserto aAcrioas.getItem(inserto aAcrioaIndex++ , th d  inserto as.push=this.font.getGlyph=gid) , th d}

hhhh ===!isBefore l{ailorllglyphIndex++, th d}

hhhh(_glyphs =uthis.glyphs .splice.apply(_glyphs, [glyphIndex, 0].concat(inserto as) ;
 D};
ailAATMorxProcessos.protorype.processGlyphInserto a =dfuncto a=processGlyphInserto a(glyph, entry, index l{ailor ===entry.flags & SET_MARK l{ailor dthis.markedIndexth;index;t D d}

hhhh ===entry.markedInsertIndext!   0xffff) {ailor dvarecount h;=entry.flags & MARKED_INSERT_COUNT)t>>> 5; th dDDvar isBefore =d!!=entry.flags & MARKED_INSERT_BEFORE , th d  this._insertGlyphs(this.markedIndex, entry.markedInsertIndex, count, isBefore ;t D d}

hhhh ===entry.curretrInsertIndext!   0xffff) {ailor dvare_count h;=entry.flags & CURRENT_INSERT_COUNT)t>>> 5; th dDDvar _isBefore =d!!=entry.flags & CURRENT_INSERT_BEFORE , th d  this._insertGlyphs(index, entry.curretrInsertIndex,e_count, _isBefore ;t D d}
 D};
ailAATMorxProcessos.protorype.getSuppor*edFeatures = functo a=getSuppor*edFeatures( l{ailorvarefeatures = []; th dfor (var _iteratos4th;rhis.morx.chains,r_isADicy4th;ADicy.isADicy(_iteratos4), _i4th;0, _iteratos4th;_isADicy4t? _iteratos4t: _getIteratos(_iteratos4);; l{ailorthvare_ref4;
tShor d ===_isADicy4  {ailor d d ===_i4 >= _iteratos4.leare ) break, th d  il_ref4th;_iteratos4[_i4++];t Dorth} else {ailor dil_i4th;_iteratos4.next( , th d   d ===_i4.done) break, th d  il_ref4th;_i4.va le;= d  th}
ailorthvarechainth;_ref4;
tShor dfor (var _iteratos5 =echain.features, _isADicy5th;ADicy.isADicy(_iteratos5), _i5th;0, _iteratos5th;_isADicy5t? _iteratos5t: _getIteratos(_iteratos5);; l{ailorth dvare_ref5;
tShor d   ===_isADicy5 l{ailor d d   ===_i5 >= _iteratos5.leare ) break, th d  ilor_ref5th;_iteratos5[_i5++];t Dorth d} else {ailor dilor_i5th;_iteratos5.next( , th d   d   ===_i5.done) break, th d  ilor_ref5th;_i5.va le;= d  th d}
ailorth dvarefeature =h_ref5;
tShor d  features.push=[feature.featureType, feature.featureSettino] , th d  }  D d}

hhhhret

fufeatures;
 D};
ailAATMorxProcessos.protorype.generateInputs = functo a=generateInputs=gid  {ailor ===!this.inputCache l{ailor dthis.generateInputCache( ;t D d}

hhhhret

futhis.inputCache[gid] || []; th};
ailAATMorxProcessos.protorype.generateInputCache h;functo a=generateInputCache(  {ailorthis.inputCache h;{};tailorfor (var _iteratos6th;rhis.morx.chains,r_isADicy6th;ADicy.isADicy(_iteratos6), _i6th;0, _iteratos6th;_isADicy6t? _iteratos6t: _getIteratos(_iteratos6);; l{ailorthvare_ref6;
tShor d ===_isADicy6  {ailor d d ===_i6 >= _iteratos6.leare ) break, th d  il_ref6th;_iteratos6[_i6++];t Dorth} else {ailor dil_i6th;_iteratos6.next( , th d   d ===_i6.done) break, th d  il_ref6th;_i6.va le;= d  th}
ailorthvarechainth;_ref6;
tShor dvar flags =echain.defaultFlags, 
 d    for (var _iteratos7th;chain.subtables, _isADicy7th;ADicy.isADicy(_iteratos7), _i7th;0, _iteratos7th;_isADicy7t? _iteratos7t: _getIteratos(_iteratos7);; l{ailorth dvare_ref7;
tShor d   ===_isADicy7 l{ailor d d   ===_i7 >= _iteratos7.leare ) break, th d  ilor_ref7th;_iteratos7[_i7++];t Dorth d} else {ailor dilor_i7th;_iteratos7.next( , th d   d   ===_i7.done) break, th d  ilor_ref7th;_i7.va le;= d  th d}
ailorth dvaresubtable =d_ref7;
tShor d   ===subtable.subFeatureFlags & flags l{ailor d d  this.generateInputsForSubtable=subtable , th d   d}
  th d}
  th}
 D};
ailAATMorxProcessos.protorype.generateInputsForSubtable = functo a=generateInputsForSubtable=subtable l{ailorvare_thisth;rhis;
ailor// Curretrly, onlyhsupportong ligature subtables.
 d   ===subtable.typer!   2) {ailor dred

f;t D d}

hhhhvarerevesset=h!!=subtable.covascge & REVERSE_DIRECTION);ailSh ===revesse l{ailor dthrow;tew=Error('Revessetsubtable, not suppor*ed.' ;t D d}

hhhhthis.subtable =dsubtable; th dthis.ligatureStack h;[]; 
hhhhvaresta
eMachine = this.getSta
eMachine(subtable);ailShvar process = this.getProcessos( ;
ailorvareinput = []; th dvarestack h;[]; th dthis.glyphs =u[];=ailorsta
eMachine.travesse({ailor detrer: functo a=etrer(glyph, entry) {ailor dDDvar glyphs =u_this.glyphs, th d   dstack.push={ailor d d  glyphs:dglyphs.slice(),ailor d d  ligatureStack:u_this.ligatureStack.slice() th d   d} , tShor d d// Add glyphttoeinput and glyphs toeprocess.ailor dDDvar g =u_this.font.getGlyph=glyph , th d    input.push=g , th d    glyphs.push=input[input.leare  -;1] , tShor d d// Process ligature substituto atShor d dprocess(glyphs[glyphs.leare  -;1], entry, glyphs.leare  -;1 , tShor d d// Add input toeresulth ==onlyhonehmatching (non-dele*ed) glyphtremains.ailor dDDvar count h;0;ailor d dvarefound h;0;ailor d dfor (var ith;0; it<eglyphs.leare  &&rcount <h;1; i++ l{ailor d d   ===glyphs[i].id !   0xffff) {ailor dDDDDDDcount++, th dilor d dfound h;glyphs[i].id, th dilor d}
DDDD D d}
tShor d   ===count h   1 l{ailor d d  var resulth= input.map(functo a==g) {ailor dDDDDDDred

fug.id, th dilor d} , th d   d  vare_cache h;_this.inputCache[found], th d   d   ===_cache l{ailor ddddddd_cache.push=result , th d   d  } else {ailor d dorrr_this.inputCache[found] =u[result], th dilor d}
DDDD D d}
DD D d},
tShor dexit: functo a=exit( l{ailorth dvare_stack$popth;stack.pop( ,  th d  il_this.glyphs =u_stack$pop.glyphs, th d   d_this.ligatureStack =u_stack$pop.ligatureStack;
tShor d  input.pop( , th d  }
  th} ;
 D};
ailred

fuAATMorxProcessos;t}( ,==_applyDecora
edDescriptor$2(_clues$2.protorype,;'getSta
eMachine', [cache],u_Object$getOwnPropertyDescriptor(_clues$2.protorype,;'getSta
eMachine'), _clues$2.protorype)), _clues$2 ,  functo a=swap(glyphs, rcngeA, rcngeB)putShvar revesseA = argumetrs.  are  > 3t&&rargumetrs[3]t!   undefined ?rargumetrs[3]t: false;
 Dvar revesseB = argumetrs.  are  > 4t&&rargumetrs[4]t!   undefined ?rargumetrs[4]t: false;

DDvar end h;glyphs.splice(rcngeB[0] -;(rcngeB[1] -;1 , rcngeB[1] , th ===revesseB l{ailorend.revesse();
 D}

DDvar start h;glyphs.splice.apply(glyphs, [rcngeA[0], rcngeA[1]].concat(end) , th ===revesseA l{ailorstart.revesse();
 D}

DDglyphs.splice.apply(glyphs, [rcngeB[0] -;(rcngeA[1] -;1 , 0].concat(start) , thred

fuglyphs;
}  functo a=reorderGlyphs(glyphs, vesb, firstGlyph,dluetGlyph) {ailvarel are  =dluetGlyph -;firstGlyph + 1;= dswitch (vesb l{ailorcase 0:ailor d// no chcngeailor dred

fuglyphs;
ailorcase 1:ailor d// Ax => xAailor dred

fuswap(glyphs, [firstGlyph,d1], [luetGlyph, 0]);
ailorcase 2:ailor d// xD => Dxailor dred

fuswap(glyphs, [firstGlyph,d0], [luetGlyph, 1]);
ailorcase 3:ailor d// AxD => DxAailor dred

fuswap(glyphs, [firstGlyph,d1], [luetGlyph, 1]);
ailorcase 4:ailor d// ABx => xABailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 0]);
ailorcase 5:ailor d// ABx => xBAailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 0],hlrue, false);
ailorcase 6:ailor d// xCD => CDxailor dred

fuswap(glyphs, [firstGlyph,d0], [luetGlyph, 2]);
ailorcase 7:ailor d// xCD => DCxailor dred

fuswap(glyphs, [firstGlyph,d0], [luetGlyph, 2], false,hlrue);
ailorcase 8:ailor d// AxCD => CDxAailor dred

fuswap(glyphs, [firstGlyph,d1], [luetGlyph, 2]);
ailorcase 9:ailor d// AxCD => DCxAailor dred

fuswap(glyphs, [firstGlyph,d1], [luetGlyph, 2], false,hlrue);
ailorcase 10:ailor d// ABxD => DxABailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 1]);
ailorcase 11:ailor d// ABxD => DxBAailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 1],hlrue, false);
ailorcase 12:ailor d// ABxCD => CDxABailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 2]);
ailorcase 13:ailor d// ABxCD => CDxBAailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 2],hlrue, false);
ailorcase 14:ailor d// ABxCD => DCxABailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 2], false,hlrue);
ailorcase 15:ailor d// ABxCD => DCxBAailor dred

fuswap(glyphs, [firstGlyph,d2], [luetGlyph, 2],hlrue, lrue);
ailordefault:ailor dthrow;tew=Error('Unknown vesb: ' + vesb ;
 D}
}t=vareAATLayoutEngine = functo a==)putShfuncto a=AATLayoutEngine(font l{ailor_cluesCa lCheck(l is,tAATLayoutEngine ,  th dthis.fontt=dfont; th dthis.morxProcessosth;tew=AATMorxProcessos(font ; th dthis.fallbackPosito a =dfalse;
 D}
ailAATLayoutEngine.protorype.substitute = functo a=substitute(glyphRua l{ailor// AAThexpects t edglyphs toebe in visualrorderdpriosttoe