<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>DEC | Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap & Font Awesome -->
<link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
<link rel="stylesheet" href="dist/css/AdminLTE.min.css">

<style>
.modal-login { width: 360px; }
#loginError { display:none; margin-bottom: 10px; }
</style>
</head>

<body class="hold-transition login-page">

<div class="login-box text-center">
    <a href="#loginModal" class="btn btn-primary" data-toggle="modal">
        Login to DEC system
    </a>
</div>

<!-- Login Modal -->
<div id="loginModal" class="modal fade">
  <div class="modal-dialog modal-login">
    <div class="modal-content">

      <form id="loginForm">

        <div class="modal-header">
          <h4 class="modal-title">Login</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <div class="modal-body">

          <!-- ERROR MESSAGE -->
          <div id="loginError" class="alert alert-danger"></div>

          <div class="form-group has-feedback">
            <input type="text" name="login_name1" class="form-control" placeholder="Username" required>
            <span class="glyphicon glyphicon-user form-control-feedback"></span>
          </div>

          <div class="form-group has-feedback">
            <input type="password" id="login_password1" name="login_password1" class="form-control" placeholder="Password" required>
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>

            <label style="font-weight: normal;">
              <input type="checkbox" onclick="togglePassword()"> Show Password
            </label>

            <p id="capsWarning" style="display:none;color:red">
              WARNING! Caps lock is ON.
            </p>
          </div>

        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success btn-block">Login</button>
        </div>

      </form>

    </div>
  </div>
</div>
<!-- jQuery first -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>
<script>
/* Show / hide password */
function togglePassword() {
    const pass = document.getElementById("login_password1");
    pass.type = pass.type === "password" ? "text" : "password";
}

/* CAPS LOCK WARNING */
document.getElementById("login_password1").addEventListener("keyup", function(e) {
    document.getElementById("capsWarning").style.display =
        e.getModifierState("CapsLock") ? "block" : "none";
});

/* AJAX LOGIN WITH SESSION CHECK */
$(document).ready(function () {

    $("#loginForm").on("submit", function (e) {
        e.preventDefault(); // prevent normal form submit

        $("#loginError").hide().text("");

        $.ajax({
            url: "login.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function (res) {

                if (res.status === "success") {

                    // 🔹 Optional: verify session is stored
                    $.ajax({
                        url: "check_session.php", // new PHP file to check session
                        type: "GET",
                        dataType: "json",
                        success: function(sessionRes) {
                            if (sessionRes.logged === true) {
                                window.location.href = "dashboard.php";
                            } else {
                                $("#loginError").text("Session not stored, try again").show();
                            }
                        },
                        error: function() {
                            $("#loginError").text("Could not verify session").show();
                        }
                    });

                } else {
                    $("#loginError").text(res.message).show();
                }

            },
            error: function (xhr) {
                $("#loginError").text("Server error. Check login.php").show();
                console.log(xhr.responseText);
            }
        });
    });

});
</script>



<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>


</body>
</html>
