<?php
session_start();
require_once "dbconn.php";
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status"=>"error","message"=>"Invalid request"]);
    exit;
}

$username = $_POST['login_name1'] ?? '';
$password = $_POST['login_password1'] ?? '';

if ($username === '' || $password === '') {
    echo json_encode(["status"=>"error","message"=>"Please enter both username and password"]);
    exit;
}

try {
    $yes='YES';
    $stmt = $conn->prepare("
         SELECT u.*, r.*,l.*
        FROM sto_users u
        LEFT JOIN roles r ON u.role_id = r.role_id LEFT JOIN  location l ON l.lid=u.sub_store
        WHERE u.usrname = :username AND u.active = :yes
        LIMIT 1
    ");
    $stmt->execute([':username'=>$username,':yes'=>$yes]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(["status"=>"error","message"=>"User not found or inactive"]);
        exit;
    }

    if (!password_verify($password, $user['usrpswd'])) {
        echo json_encode(["status"=>"error","message"=>"Invalid password"]);
        exit;
    }

    // Set individual session variables
    $_SESSION['user_id']     = $user['user_id'];
    $_SESSION['username']    = $user['usrname'];
    $_SESSION['fname']       = $user['fname'];
    $_SESSION['second_name'] = $user['lname'] ?? '';
    $_SESSION['image']       = $user['image'] ?? '';
    $_SESSION['role_name']   = $user['role_name'] ?? '';
    $_SESSION['role_id']     = $user['role_id'];
    $_SESSION['datetime']    = date("Y-m-d H:i:s");
    $_SESSION['location']    = $user['location'] ?? '';
    $_SESSION['lid']         = $user['lid'] ?? '';

    // Force session write
    session_write_close();

    echo json_encode(["status"=>"success"]);

} catch (PDOException $e) {
    error_log($e->getMessage());
    echo json_encode(["status"=>"error","message"=>"Database error"]);
}
