
<?php
/**
  * write_mysql_log($message, $conn)
  *
  * Author(s): thanosb, ddonahue
  * Date: May 11, 2008
  * 
  * Writes the values of certain variables along with a message in a database.
  *
  * Parameters:
  *  $message: Message to be logged
  *  $conn: Object that represents the connection to the MySQL Server    
  *
  * Returns array:
  *  $result[status]:   True on success, false on failure
  *  $result[message]:  Error message
  * https://web.stanford.edu/dept/its/communications/webservices/wiki/index.php/How_to_create_logs_with_PHP
  * connection
  * // Two options for connecting to the database:
 
define('HOST_DIRECT', 'mysql-user.stanford.edu'); // Standard connection
                                                  // Only username and password are encrypted
 
define('HOST_STUNNEL', '127.0.0.1');    // Secure connection, slower performance
                                        // All data is encrypted
                                        // Use '127.0.0.1' and not 'localhost'
 
define('DB_HOST', HOST_DIRECT);         // Choose HOST_DIRECT or HOST_STUNNEL, depending on your application's requirements
 
define('DB_USER', 'mysql_username');    // MySQL account username
define('DB_PASS', 'mysql_password');    // MySQL account password
define('DB_NAME', 'mysql_db_name');     // Name of database
 
// Connect to the database
$db = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
 
if(!$db) {
  // Handle error
  echo "<p>Unable to connect to database</p>";
}
  */

 include("dbconn.php");
 
function write_mysql_log($message, $conn){
  // Check database connection
 // if( ($conn instanceof MySQLi) == false) {
   // return array(status => false, message => 'MySQL connection is invalid');
  //}
 
  // Check message
  if($message =='') {
    return array(status => false, message => 'Message is empty');
  }
 
  // Get IP address
  if( ($remote_addr = $_SERVER['REMOTE_ADDR']) == '') {
    $remote_addr = "REMOTE_ADDR_UNKNOWN";
  }
 
  // Get requested script
  if( ($request_uri = $_SERVER['REQUEST_URI']) == '') {
    $request_uri = "REQUEST_URI_UNKNOWN";
  }
 
  // Escape values
  $message     = $conn->escape_string($message);
  $remote_addr = $conn->escape_string($remote_addr);
  $request_uri = $conn->escape_string($request_uri);
 
  // Construct query
  $sql = "INSERT INTO my_log (remote_addr, request_uri, message) VALUES('$remote_addr', '$request_uri','$message')";
 
  // Execute query and save data
  $result = $conn->query($sql);
 
  if($result) {
    return array(status => true);  
  }
  else {
    return array(status => false, message => 'Unable to write to the database');
  }
}
//usage
//$something_happened = rand(0,1);
 
//if($something_happened == 1) {
  //write_mysql_log("Something happened!", $db);
//}
?>