<?php
namespace Phppot;

use Phppot\DataSource;

class CountryStateCity
{
    private $ds;
    
    function __construct()
    {
        require_once __DIR__ . './../lib/DataSource.php';
        $this->ds = new DataSource();
    }
    
    /**
     * to get the country record set
     *
     * @return array result record
     */
     
     
     	  public function getAllSuppliers()
    {
        
        $query = "SELECT * FROM `suppliers` WHERE `deleted`!='YES' AND `company_name`!=''";
         $result = $this->ds->select($query);
        return $result;
        
    }
    
    
    public function getAllCountry()
    {
        $query = "SELECT * FROM `boq`";
        $result = $this->ds->select($query);
        return $result;
    }
    
    /**
     * to get the state record based on the country_id
     *
     * @param string $countryId
     * @return array result record
     */
     
        public function getAllItemOnRequested($site)
    {
             session_start();
    $site=$_SESSION['user']['lid'];
    
        $query = "SELECT * FROM requested LEFT JOIN store_items ON store_items.item_id=requested.materials  LEFT JOIN units ON units.uid=store_items.unit LEFT JOIN categories ON store_items.category=categories.catid LEFT JOIN location ON location.lid=requested.Store_site where Store_site='$site";
        $result = $this->ds->select($query);
        return $result;
    }
    public function getStateByCountrId($countryId)
    {
        $query = "SELECT * FROM `phases_for_boq` WHERE `boq_id`=? GROUP BY `phase_title`";
        $paramType = 'd';
        $paramArray = array(
            $countryId
        );
        $result = $this->ds->select($query, $paramType, $paramArray);
        return $result;
    }
    
    /**
     * to get the city record based on the state_id
     *
     * @param string $stateId
     * @return array result record
     */
    public function getCityByStateId($stateId)
    {
        print $query = "SELECT * FROM `boq_elements` WHERE `phase_id`=?";
        $paramType = 'd';
        $paramArray = array(
            $stateId
        );
        $result = $this->ds->select($query, $paramType, $paramArray);
        return $result;
    }
     public function getAllCategory()
    {
        $query = "SELECT * FROM `categories`";
        $result = $this->ds->select($query);
        return $result;
    }
   public function getItemByCategory($categoryId)
    {
         session_start();
    $site=$_SESSION['user']['lid'];
        $query = "SELECT * FROM `store_items` INNER JOIN stocks ON stocks.items=store_items.item_id JOIN units on store_items.unit=units.uid WHERE `category`=? and quantity > 0 and  stocks.site='$site' group by Item_name order by Item_name  asc";
        $paramType = 'd';
        $paramArray = array(
            $categoryId
        );
        $result = $this->ds->select($query, $paramType, $paramArray);
        return $result;
    }
    public function getItemByCategoryIn($categoryId)
    {
             session_start();
    $site=$_SESSION['user']['lid'];
    
        $query = "SELECT *,CONVERT(CAST(CONVERT(`Item_name` USING latin1) AS BINARY) USING UTF8) AS Item_name  FROM `store_items` LEFT JOIN stocks ON stocks.items=store_items.item_id JOIN units on store_items.unit=units.uid WHERE `category`=?   group by Item_name order by Item_name  asc";
        $paramType = 'd';
        $paramArray = array(
            $categoryId
        );
        $result = $this->ds->select($query, $paramType, $paramArray);
        return $result;
    }
    
     public function getAllStockBalance($site)
    { 
    session_start();
    $site=$_SESSION['user']['lid'];
        $query = "SELECT * FROM `stocks` INNER JOIN location ON stocks.site=location.lid INNER JOIN sto_users ON stocks.agent=sto_users.user_id INNER JOIN store_items ON stocks.items=store_items.item_id LEFT JOIN categories ON store_items.category=categories.catid left join units on units.uid=store_items.unit WHERE `site`='$site'";

        $result = $this->ds->select($query);
        return $result;
    }
       public function getAllItemOut($site)
    { 
    session_start();
    $site=$_SESSION['user']['lid'];
        $query = "SELECT *,CONVERT(CAST(CONVERT(`Item_name` USING latin1) AS BINARY) USING UTF8) AS Item_name FROM `stock_out`LEFT JOIN store_items ON stock_out.out_item_id=store_items.item_id LEFT JOIN phases_for_boq ON stock_out.phase=phases_for_boq.phas_id LEFT JOIN units ON store_items.unit=units.uid  LEFT JOIN `construction_phase` ON stock_out.phase=construction_phase.phid WHERE `store_location`='$site'";
        $result = $this->ds->select($query);
        return $result;
    }
    public function getAllSites(){
         session_start();
    $loc_id=$_SESSION['user']['lid'];
    // and lid!='$loc_id'
$query="SELECT * FROM `location` WHERE `closed`='NO' and lid!='$loc_id' order by location"; 
 $result = $this->ds->select($query);
        return $result;   	
    	 }
    	  
    	  public function getAllSite(){
         session_start();
    $loc_id=$_SESSION['user']['lid'];
    // and lid!='$loc_id'
$query="SELECT * FROM `location` WHERE `closed`='NO' order by location"; 
 $result = $this->ds->select($query);
        return $result;   	
    	 }
    	  public function getUserBySite($site_id)
    {
        
        $query = "SELECT * FROM `sto_users` WHERE `sub_store`=?";
        $paramType = 'd';
        $paramArray = array(
          $site_id
        );
        $result = $this->ds->select($query, $paramType, $paramArray);
        return $result;
    }
    
    //transfers
 public function getAllTransfers($site)
    { 
session_start();
    $site=$_SESSION['user']['lid'];
  $query="SELECT * FROM `stock_transfers` left JOIN store_items ON store_items.item_id=stock_transfers.item_id LEFT JOIN categories ON categories.catid=stock_transfers.cat_id  LEFT JOIN units ON store_items.unit=units.uid  where `slocation`='$site' ORDER BY trans_id DESC";
        $result = $this->ds->select($query);
        return $result;
    }
     
    	    
}

    ?>