<?php
 
/*
 * Example PHP implementation used for the index.html example
 */
 
// DataTables PHP library
//include( "../lib/DataTables.php" );
require_once __DIR__ . './../lib/DataTable.php';
 
// Alias Editor classes so they are easy to use
use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Mjoin,
    DataTables\Editor\Options,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate,
    DataTables\Editor\ValidateOptions;
 
// Build our Editor instance and process the data coming from _POST
Editor::inst( $db, 'datatables_demo' )
    ->fields(
        Field::inst( 'date' )
            ->validator( Validate::dateFormat( 'Y-m-d' ) )
            ->getFormatter( Format::dateSqlToFormat( 'Y-m-d' ) )
            ->setFormatter( Format::dateFormatToSql('Y-m-d' ) ),
        Field::inst( 'category' )
            ->validator( Validate::notEmpty( ValidateOptions::inst()
                ->message( 'A category is required' ) 
            ) ),
        Field::inst( 'items' )
            ->validator( Validate::notEmpty( ValidateOptions::inst()
                ->message( 'An items is required' )  
            ) ),
        Field::inst( 'unit' ),
        Field::inst( 'Qty' )
            ->validator( Validate::email( ValidateOptions::inst()
                ->message( 'Please enter quantity' )   
            ) ),
        Field::inst( 'u_price' )
        
        ->validator( Validate::numeric() )
         ->setFormatter( Format::ifEmpty(null) ),
        Field::inst( 'Amount' )
        
            ->validator( Validate::numeric() )
            ->setFormatter( Format::ifEmpty(null) )
            
        
            
    )
    ->debug(true)
    ->process( $_POST )
    ->json();